/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import jdbm.helper.CacheEntry;
import jdbm.helper.CacheEvictionException;
import jdbm.helper.CachePolicy;
import jdbm.helper.CachePolicyListener;
import jdbm.helper.ICacheEntry;
import jdbm.helper.Serializer;

public final class CacheAll<K, V>
implements CachePolicy<K, V> {
    Hashtable<K, ICacheEntry<K, V>> _hash = new Hashtable();
    Vector<CachePolicyListener> listeners = new Vector();
    CacheEntry<K, V> _first;
    CacheEntry<K, V> _last;

    public CacheAll() {
        this.removeAll();
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }

    @Override
    public void put(K key, V value, boolean dirty, Serializer<V> ser) throws CacheEvictionException {
        CacheEntry<K, V> entry = (CacheEntry<K, V>)this._hash.get(key);
        if (entry != null) {
            entry._value = value;
            entry._dirty = dirty;
            entry._ser = ser;
            this.touchEntry(entry);
        } else {
            entry = new CacheEntry<K, V>(key, value, dirty, ser);
            this.addEntry(entry);
            this._hash.put(entry._key, entry);
        }
    }

    @Override
    public V get(K key) {
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.touchEntry(entry);
            return entry._value;
        }
        return null;
    }

    @Override
    public void remove(K key) {
        CacheEntry entry = (CacheEntry)this._hash.get(key);
        if (entry != null) {
            this.removeEntry(entry);
            this._hash.remove(entry.getKey());
        }
    }

    @Override
    public void removeAll() {
        this._hash = new Hashtable();
    }

    @Override
    public Enumeration<V> elements() {
        return new CacheAllEnumeration<K, V>(this._hash.elements());
    }

    @Override
    public Enumeration<ICacheEntry<K, V>> entries() {
        return this._hash.elements();
    }

    @Override
    public void addListener(CachePolicyListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Cannot add null listener.");
        }
        if (!this.listeners.contains(listener)) {
            this.listeners.addElement(listener);
        }
    }

    @Override
    public void removeListener(CachePolicyListener listener) {
        this.listeners.removeElement(listener);
    }

    protected void addEntry(CacheEntry<K, V> entry) {
        if (this._first == null) {
            this._first = entry;
            this._last = entry;
        } else {
            this._last._next = entry;
            entry._previous = this._last;
            this._last = entry;
        }
    }

    protected void removeEntry(CacheEntry<K, V> entry) {
        CacheEntry previous = entry._previous;
        CacheEntry next = entry._next;
        if (entry == this._first) {
            this._first = next;
        }
        if (this._last == entry) {
            this._last = previous;
        }
        if (previous != null) {
            previous._next = next;
        }
        if (next != null) {
            next._previous = previous;
        }
        entry._previous = null;
        entry._next = null;
    }

    protected void touchEntry(CacheEntry<K, V> entry) {
        if (this._last == entry) {
            return;
        }
        this.removeEntry(entry);
        this.addEntry(entry);
    }

    private static class CacheAllEnumeration<K, V>
    implements Enumeration<V> {
        private final Enumeration<ICacheEntry<K, V>> _enum;

        CacheAllEnumeration(Enumeration<ICacheEntry<K, V>> enume) {
            this._enum = enume;
        }

        @Override
        public boolean hasMoreElements() {
            return this._enum.hasMoreElements();
        }

        @Override
        public V nextElement() {
            CacheEntry entry = (CacheEntry)this._enum.nextElement();
            return entry._value;
        }
    }
}

