/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.compessor;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import jdbm.helper.compessor.IRecordCompressor;

public abstract class AbstractRecordCompressor
implements IRecordCompressor {
    private final transient Deflater _deflater;
    private final transient Inflater _inflater = new Inflater();
    private byte[] _buf = new byte[1024];

    @Override
    public byte[] compress(byte[] bytes) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bytes.length);
        this._deflater.reset();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, this._deflater);
        try {
            dos.write(bytes);
            dos.flush();
            dos.close();
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        byte[] tmp = baos.toByteArray();
        return tmp;
    }

    protected AbstractRecordCompressor(int level) {
        this._deflater = new Deflater(1);
    }

    @Override
    public byte[] decompress(byte[] cmp) {
        try {
            this._inflater.reset();
            InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(cmp), this._inflater, cmp.length);
            int off = 0;
            while (true) {
                int nread;
                int capacity;
                if ((capacity = this._buf.length - off) == 0) {
                    byte[] tmp = new byte[this._buf.length * 2];
                    System.arraycopy(this._buf, 0, tmp, 0, off);
                    this._buf = tmp;
                    capacity = this._buf.length - off;
                }
                if ((nread = iis.read(this._buf, off, capacity)) == -1) break;
                off += nread;
            }
            byte[] tmp = new byte[off];
            System.arraycopy(this._buf, 0, tmp, 0, off);
            return tmp;
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }
}

