/*
 * Decompiled with CFR 0.152.
 */
package jdbm.helper.compression;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import jdbm.extser.Stateless;
import jdbm.helper.compression.ByteArrayCompressor;
import jdbm.helper.compression.ByteArrayDecompressor;
import jdbm.helper.compression.CompressionProvider;

public class LeadingValueCompressionProvider
implements CompressionProvider,
Externalizable {
    private static final long serialVersionUID = 1L;
    private int ignoreLeadingCount;
    public static final transient LeadingValueCompressionProvider BINARY = new BinaryCompressionProvider();
    public static final transient LeadingValueCompressionProvider STRING = new StringCompressionProvider();

    public LeadingValueCompressionProvider() {
        this(0);
    }

    public LeadingValueCompressionProvider(int ignoreLeadingCount) {
        this.ignoreLeadingCount = ignoreLeadingCount;
    }

    @Override
    public ByteArrayCompressor getCompressor(DataOutput out) {
        Compressor comp = new Compressor();
        comp.out = out;
        return comp;
    }

    @Override
    public ByteArrayDecompressor getDecompressor(DataInput in) {
        Decompressor decomp = new Decompressor();
        decomp.in = in;
        return decomp;
    }

    static byte[] readByteArray(DataInput in, byte[] previous, int ignoreLeadingCount) throws IOException {
        int len = in.readInt();
        if (len == -1) {
            return null;
        }
        short actualCommon = 0;
        if (len < 0) {
            len = -len;
            actualCommon = in.readShort();
        }
        byte[] buf = new byte[len];
        if (previous == null) {
            actualCommon = 0;
        }
        if (actualCommon > 0) {
            in.readFully(buf, 0, ignoreLeadingCount);
            System.arraycopy(previous, ignoreLeadingCount, buf, ignoreLeadingCount, actualCommon - ignoreLeadingCount);
        }
        in.readFully(buf, actualCommon, len - actualCommon);
        return buf;
    }

    static void writeByteArray(DataOutput out, byte[] buf, byte[] previous, int ignoreLeadingCount) throws IOException {
        if (buf == null) {
            out.writeInt(-1);
            return;
        }
        short actualCommon = (short)ignoreLeadingCount;
        if (previous != null) {
            int maxCommon;
            int n = maxCommon = buf.length > previous.length ? previous.length : buf.length;
            if (maxCommon > Short.MAX_VALUE) {
                maxCommon = Short.MAX_VALUE;
            }
            while (actualCommon < maxCommon && buf[actualCommon] == previous[actualCommon]) {
                actualCommon = (short)(actualCommon + 1);
            }
        }
        if (actualCommon > 2) {
            out.writeInt(-buf.length);
            out.writeShort(actualCommon);
            out.write(buf, 0, ignoreLeadingCount);
            out.write(buf, actualCommon, buf.length - actualCommon);
        } else {
            out.writeInt(buf.length);
            out.write(buf);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.ignoreLeadingCount);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.ignoreLeadingCount = in.readInt();
    }

    private class Decompressor
    implements ByteArrayDecompressor {
        private DataInput in;
        private byte[] previous = null;

        private Decompressor() {
        }

        @Override
        public void reset(DataInput in) {
            this.in = in;
        }

        @Override
        public byte[] decompressNextGroup() throws IOException {
            this.previous = LeadingValueCompressionProvider.readByteArray(this.in, this.previous, LeadingValueCompressionProvider.this.ignoreLeadingCount);
            return this.previous;
        }
    }

    private class Compressor
    implements ByteArrayCompressor {
        private DataOutput out;
        private byte[] previous = null;

        private Compressor() {
        }

        @Override
        public void compressNextGroup(byte[] in) throws IOException {
            LeadingValueCompressionProvider.writeByteArray(this.out, in, this.previous, LeadingValueCompressionProvider.this.ignoreLeadingCount);
            this.previous = in != null ? (byte[])in.clone() : null;
        }

        @Override
        public void finishCompression() {
        }
    }

    public static class StringCompressionProvider
    extends LeadingValueCompressionProvider
    implements Stateless {
        public StringCompressionProvider() {
            super(2);
        }
    }

    public static class BinaryCompressionProvider
    extends LeadingValueCompressionProvider
    implements Stateless {
    }
}

