/* The copyright in this software is being made available under the BSD
   License, included below. This software may be subject to contributor and
   other third party rights, including patent rights, and no such rights are
   granted under this license.

   Copyright (c) 2020, Samsung Electronics Co., Ltd.
   All Rights Reserved. */
/*
   Redistribution and use in source and binary forms, with or without
   modification, are permitted provided that the following conditions are met:

   - Redistributions of source code must retain the above copyright notice,
   this list of conditions and the following disclaimer.

   - Redistributions in binary form must reproduce the above copyright notice,
   this list of conditions and the following disclaimer in the documentation
   and/or other materials provided with the distribution.

   - Neither the name of the copyright owner, nor the names of its contributors
   may be used to endorse or promote products derived from this software
   without specific prior written permission.

   THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
   AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
   IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
   ARE DISCLAIMED.IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
   LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
   CONSEQUENTIAL DAMAGES(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
   SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
   INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
   CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
   ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
   POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef _XEVEM_TQ_H_
#define _XEVEM_TQ_H_

#include "xeve_type.h"

int xevem_rdoq_set_ctx_cc(XEVE_CORE* core, int ch_type, int prev_level);
int xevem_sub_block_tq(XEVE_CTX*  ctx,
                       XEVE_CORE* core,
                       s16        coef[N_C][MAX_CU_DIM],
                       int        log2_cuw,
                       int        log2_cuh,
                       int        slice_type,
                       int        nnz[N_C],
                       int        is_intra,
                       int        run_stats);
extern const XEVE_TX (*xeve_func_tx)[MAX_TR_LOG2];
extern const XEVE_TX xeve_tbl_tx[MAX_TR_LOG2];
void                 tx_pb2(s16* src, s16* dst, int shift, int line);
void                 tx_pb4(s16* src, s16* dst, int shift, int line);
void                 tx_pb8(s16* src, s16* dst, int shift, int line);
void                 tx_pb16(s16* src, s16* dst, int shift, int line);
void                 tx_pb32(s16* src, s16* dst, int shift, int line);
void                 tx_pb64(s16* src, s16* dst, int shift, int line);
#endif /* _XEVE_TQ_H_ */
