#include "inner.h"

color_t colors_48gx[ NB_COLORS ] = {
    /* UI4X_COLOR_HP_LOGO */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xB0,
     .rgb = 0xB0B0B8,
     },
    /* UI4X_COLOR_HP_LOGO_BG */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x68,
     .rgb = 0x68686E,
     },
    /* UI4X_COLOR_48GX_128K_RAM */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xF0,
     .rgb = 0xF0F0F0,
     },
    /* UI4X_COLOR_FRAME */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0x0,
     .rgb = 0x000000,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x80,
     .rgb = 0x80808A,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x68,
     .rgb = 0x68686E,
     },
    /* UI4X_COLOR_UPPER_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x54,
     .rgb = 0x54545A,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x58,
     .rgb = 0x585858,
     },
    /* UI4X_COLOR_FACEPLATE */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x4A,
     .rgb = 0x4A4A4A,
     },
    /* UI4X_COLOR_FACEPLATE_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x40,
     .rgb = 0x404040,
     },
    /* UI4X_COLOR_KEYPAD_HIGHLIGHT */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x68,
     .rgb = 0x68686E,
     },
    /* UI4X_COLOR_BUTTON_EDGE_TOP */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x68,
     .rgb = 0x686868,
     },
    /* UI4X_COLOR_BUTTON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x58,
     .rgb = 0x585858,
     },
    /* UI4X_COLOR_BUTTON_EDGE_BOTTOM */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x4A,
     .rgb = 0x4A4A4A,
     },
    /* UI4X_COLOR_PIXEL_OFF */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xCD,
     .rgb = 0x779988,
     },
    /* UI4X_COLOR_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0x478691,
     },
    /* UI4X_COLOR_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x0d6c6f,
     },
    /* UI4X_COLOR_PIXEL_ON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x14,
     .rgb = 0x253d54,
     },
    /* UI4X_COLOR_BLACK_PIXEL_OFF */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xCD,
     .rgb = 0xf5f5f5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_1 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0xa9,
     .rgb = 0xa5a5a5,
     },
    /* UI4X_COLOR_BLACK_PIXEL_GREY_2 */
    {
     .a = 0xff,
     .mono_rgb = 0x00,
     .gray_rgb = 0x69,
     .rgb = 0x454545,
     },
    /* UI4X_COLOR_BLACK_PIXEL_ON */
    {
     .a = 0xFF,
     .mono_rgb = 0x0,
     .gray_rgb = 0x14,
     .rgb = 0x151515,
     },
    /* UI4X_COLOR_LABEL */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xFF,
     .rgb = 0xFFFFFF,
     },
    /* UI4X_COLOR_ALPHA */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xFF,
     .rgb = 0xFFFFFF,
     },
    /* UI4X_COLOR_SHIFT_LEFT */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xDC,
     .rgb = 0xFFBAFF,
     },
    /* UI4X_COLOR_SHIFT_RIGHT */
    {
     .a = 0xFF,
     .mono_rgb = 0xFF,
     .gray_rgb = 0xA9,
     .rgb = 0x00FFCC,
     },
};

#define KB_LINE_HEIGHT 50
#define KB_COLUMN_WIDTH_6_KEYS 50
#define KB_COLUMN_WIDTH_5_KEYS 60

button_t buttons_48gx[ NB_HP48_KEYS ] = {
    {.x = 0,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "A",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "B",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "C",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "D",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "E",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 0,
     .w = 36,
     .h = 23,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = menu_label_width,
     .label_graphic_h = menu_label_height,
     .label_graphic = menu_label_bitmap,
     .letter = "F",
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },

    {.x = 0,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "MTH",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "G",
     .left = "RAD",
     .highlight = false,
     .right = "POLAR",
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "PRG",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "H",
     .left = "CHARS",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "CST",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "I",
     .left = "MODES",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "VAR",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "J",
     .left = "MEMORY",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = up_width,
     .label_graphic_h = up_height,
     .label_graphic = up_bitmap,
     .letter = "K",
     .left = "STACK",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "NXT",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "L",
     .left = "PREV",
     .highlight = false,
     .right = "MENU",
     .sub = 0       },

    {.x = 0,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = quote_width,
     .label_graphic_h = quote_height,
     .label_graphic = quote_bitmap,
     .letter = "M",
     .left = "UP",
     .highlight = false,
     .right = "HOME",
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "STO",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "N",
     .left = "DEF",
     .highlight = false,
     .right = "RCL",
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "EVAL",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "O",
     .left = "\x06NUM",
     .highlight = false,
     .right = "UNDO",
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = left_width,
     .label_graphic_h = left_height,
     .label_graphic = left_bitmap,
     .letter = "P",
     .left = "PICTURE",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = down_width,
     .label_graphic_h = down_height,
     .label_graphic = down_bitmap,
     .letter = "Q",
     .left = "VIEW",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 2 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = right_width,
     .label_graphic_h = right_height,
     .label_graphic = right_bitmap,
     .letter = "R",
     .left = "SWAP",
     .highlight = false,
     .right = 0,
     .sub = 0       },

    {.x = 0,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "SIN",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "S",
     .left = "ASIN",
     .highlight = false,
     .right = "\x07",
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "COS",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "T",
     .left = "ACOS",
     .highlight = false,
     .right = "\x08",
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "TAN",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "U",
     .left = "ATAN",
     .highlight = false,
     .right = "\x09",
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = sqrt_width,
     .label_graphic_h = sqrt_height,
     .label_graphic = sqrt_bitmap,
     .letter = "V",
     .left = "\x13",
     .highlight = false,
     .right = "\x14",
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = power_width,
     .label_graphic_h = power_height,
     .label_graphic = power_bitmap,
     .letter = "W",
     .left = "\x15",
     .highlight = false,
     .right = "LOG",
     .sub = 0       },
    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 3 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = inv_width,
     .label_graphic_h = inv_height,
     .label_graphic = inv_bitmap,
     .letter = "X",
     .left = "\x16",
     .highlight = false,
     .right = "LN",
     .sub = 0       },

    {.x = 0,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 86,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "ENTER",
     .font_size = 2,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "EQUATION",
     .highlight = false,
     .right = "MATRIX",
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = neg_width,
     .label_graphic_h = neg_height,
     .label_graphic = neg_bitmap,
     .letter = "Y",
     .left = "EDIT",
     .highlight = false,
     .right = "CMD",
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "EEX",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = "Z",
     .left = "PURG",
     .highlight = false,
     .right = "ARG",
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "DEL",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "CLEAR",
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = 5 * KB_COLUMN_WIDTH_6_KEYS,
     .y = 4 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = bs_width,
     .label_graphic_h = bs_height,
     .label_graphic = bs_bitmap,
     .letter = 0,
     .left = "DROP",
     .highlight = false,
     .right = 0,
     .sub = 0       },

    {.x = 0,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = alpha_width,
     .label_graphic_h = alpha_height,
     .label_graphic = alpha_bitmap,
     .letter = 0,
     .left = "USER",
     .highlight = false,
     .right = "ENTRY",
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "7",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "SOLVE",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "8",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "PLOT",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "9",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "SYMBOLIC",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 5 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = div_width,
     .label_graphic_h = div_height,
     .label_graphic = div_bitmap,
     .letter = 0,
     .left = "\x17 ",
     .highlight = false,
     .right = "\x18",
     .sub = 0       },

    {.x = 0,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_LEFT,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = shl_width,
     .label_graphic_h = shl_height,
     .label_graphic = shl_bitmap,
     .letter = 0,
     .left = 0,
     .highlight = false,
     .right = 0,
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "4",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "TIME",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "5",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "STAT",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "6",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "UNITS",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 6 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = mul_width,
     .label_graphic_h = mul_height,
     .label_graphic = mul_bitmap,
     .letter = 0,
     .left = "\x19 ",
     .highlight = false,
     .right = "\x1a",
     .sub = 0       },

    {.x = 0,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_SHIFT_RIGHT,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = shr_width,
     .label_graphic_h = shr_height,
     .label_graphic = shr_bitmap,
     .letter = 0,
     .left = 0,
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "1",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "I/O",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "2",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "LIBRARY",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "3",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "EQ LIB",
     .highlight = true,
     .right = 0,
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 7 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = minus_width,
     .label_graphic_h = minus_height,
     .label_graphic = minus_bitmap,
     .letter = 0,
     .left = "\x1b ",
     .highlight = false,
     .right = "\x1c",
     .sub = 0       },

    {.x = 0,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 36,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "ON",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "CONT",
     .highlight = false,
     .right = "OFF",
     .sub = "CANCEL"},
    {.x = KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "0",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "\x04 ",
     .highlight = false,
     .right = "\x03",
     .sub = 0       },
    {.x = 2 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = ".",
     .font_size = 1,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "\x02 ",
     .highlight = false,
     .right = "\x01",
     .sub = 0       },
    {.x = 3 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = "SPC",
     .font_size = 0,
     .label_graphic_w = 0,
     .label_graphic_h = 0,
     .label_graphic = 0,
     .letter = 0,
     .left = "\x05 ",
     .highlight = false,
     .right = "\x1f",
     .sub = 0       },
    {.x = 4 * KB_COLUMN_WIDTH_5_KEYS,
     .y = 8 * KB_LINE_HEIGHT,
     .w = 46,
     .h = 26,
     .label_color = UI4X_COLOR_LABEL,
     .label_text = 0,
     .font_size = 0,
     .label_graphic_w = plus_width,
     .label_graphic_h = plus_height,
     .label_graphic = plus_bitmap,
     .letter = 0,
     .left = "\x1d ",
     .highlight = false,
     .right = "\x1e",
     .sub = 0       },
};
