PROGRAM LA_SGGES_ET_EXAMPLE
!
!  -- LAPACK95 interface driver routine (version 3.0) --
!     UNI-C, Denmark; Univ. of Tennessee, USA; NAG Ltd., UK
!     September, 2000
!
!  .. USE STATEMENTS
      USE LA_PRECISION, ONLY: WP => SP
      USE F95_LAPACK, ONLY: LA_GGES
!  .. IMPLICIT STATEMENT ..
      IMPLICIT NONE
!  .. PARAMETERS ..
      CHARACTER(LEN=*), PARAMETER :: FMT = '(8(1X,F10.3))'
   INTEGER, PARAMETER :: NIN=5, NOUT=6
!  .. LOCAL SCALARS ..
      INTEGER :: I, INFO, N
      INTEGER :: SDIM
!  .. LOCAL ARRAYS ..
   REAL(WP), ALLOCATABLE :: AA(:,:), BB(:,:)
   REAL(WP), ALLOCATABLE :: A(:,:), B(:,:), VSL(:,:), VSR(:,:), &
     &  ALPHAR(:), ALPHAI(:), BETA(:), DUMMY(:,:)
!  .. FUNCTIONAL ARGUMENTS ..
      INTERFACE
      LOGICAL FUNCTION SELECT(ALPHAR, ALPHAI, BETA)
      USE LA_PRECISION, ONLY: WP => SP
      REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
      END FUNCTION SELECT
      END INTERFACE 
!  .. EXECUTABLE STATEMENTS ..
   WRITE (NOUT,*) 'SGGES ET_Example Program Results.'
   READ ( NIN, * )   ! SKIP HEADING IN DATA FILE
   READ ( NIN, * ) N
   PRINT *, 'N = ', N
   ALLOCATE ( A(N,N), AA(N,N), ALPHAR(N), ALPHAI(N), BETA(N), &
              VSL(N,N), VSR(N,N), B(N,N), BB(N,N) )
!
   READ (NIN, *) AA, BB
   A=AA; B=BB
   WRITE(NOUT,*) 'The matrix A:'
   DO I = 1, N; WRITE (NOUT,*) 'I = ', I; WRITE (NOUT,FMT) A(I,:); ENDDO
   WRITE(NOUT,*) 'The matrix B:'
   DO I = 1, N; WRITE (NOUT,*) 'I = ', I; WRITE (NOUT,FMT) B(I,:); ENDDO
!
   WRITE ( NOUT, * )'---------------------------------------------------------'
   WRITE ( NOUT, * )
   WRITE ( NOUT, * )'Details of LA_SGGES LAPACK Subroutine Results.'
   WRITE ( NOUT, * )
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL, VSR, SELECT, SDIM, INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL, VSR, SELECT, SDIM, INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
   WRITE(NOUT,*) 'SDIM = ', SDIM
   WRITE(NOUT,*) ' Alphar:'
   WRITE(NOUT,FMT) ALPHAR
   WRITE(NOUT,*) ' Alphai:'
   WRITE(NOUT,FMT) ALPHAI
   WRITE(NOUT,*) ' Beta:'
   WRITE(NOUT,FMT) BETA
   WRITE(NOUT,*) 'VSL:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) VSL(:,I); END DO
   WRITE(NOUT,*) 'VSR:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) VSR(:,I); END DO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
   WRITE(NOUT,*) 'A:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) A(:,I); END DO
   WRITE(NOUT,*) 'B:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) B(:,I); END DO
   WRITE(NOUT,*) ' Alphar:'
   WRITE(NOUT,FMT) ALPHAR
   WRITE(NOUT,*) ' Alphai:'
   WRITE(NOUT,FMT) ALPHAI
   WRITE(NOUT,*) ' Beta:'
   WRITE(NOUT,FMT) BETA
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( DUMMY, B, ALPHAR, ALPHAI, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( DUMMY, B, ALPHAR, ALPHAI, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, DUMMY, ALPHAR, ALPHAI, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, DUMMY, ALPHAR, ALPHAI, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR(1:N-1), ALPHAI, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR(1:N-1), ALPHAI, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI(1:N-1), BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI(1:N-1), BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA=BETA(1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA=BETA(1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL(:,1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL(:,1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL(1:N-1,:), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSL(1:N-1,:), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSR=VSR(1:N-1,:), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSR=VSR(1:N-1,:), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSR=VSR(:,1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHAR, ALPHAI, BETA, VSR=VSR(:,1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
END PROGRAM LA_SGGES_ET_EXAMPLE
      LOGICAL FUNCTION SELECT(ALPHAR, ALPHAI, BETA)
      USE LA_PRECISION, ONLY: WP => SP
      REAL(WP), INTENT(IN) :: ALPHAR, ALPHAI, BETA
      SELECT = .TRUE.
      END FUNCTION SELECT 
            
