PROGRAM LA_ZGGES_ET_EXAMPLE
!
!  -- LAPACK95 interface driver routine (version 3.0) --
!     UNI-C, Denmark; Univ. of Tennessee, USA; NAG Ltd., UK
!     September, 2000
!
!  .. USE STATEMENTS
      USE LA_PRECISION, ONLY: WP => DP
      USE F95_LAPACK, ONLY: LA_GGES
!  .. IMPLICIT STATEMENT ..
      IMPLICIT NONE
!  .. PARAMETERS ..
      CHARACTER(LEN=*), PARAMETER :: FMT = '(4(1X,1H(,F7.3,1H,,F7.3,1H):))'
   INTEGER, PARAMETER :: NIN=5, NOUT=6
!  .. LOCAL SCALARS ..
      INTEGER :: I, INFO, N
      INTEGER :: SDIM
!  .. LOCAL ARRAYS ..
      REAL(WP), ALLOCATABLE :: AA(:,:), BB(:,:)
      COMPLEX(WP), ALLOCATABLE :: A(:,:), B(:,:), VSL(:,:), VSR(:,:), &
     &  ALPHA(:), BETA(:), DUMMY(:,:)
      INTERFACE
      LOGICAL FUNCTION SELECT( ALPHA, BETA)
      USE LA_PRECISION, ONLY: WP => DP
      COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
      END FUNCTION SELECT
      END INTERFACE
!  .. EXECUTABLE STATEMENTS ..
   WRITE (NOUT,*) 'ZGGES ET_Example Program Results.'
   READ ( NIN, * )   ! SKIP HEADING IN DATA FILE
   READ ( NIN, * ) N
   PRINT *, 'N = ', N
   ALLOCATE ( A(N,N), AA(N,N), ALPHA(N), BETA(N), &
&    VSL(N,N), VSR(N,N), B(N,N), BB(N,N) )
!
   READ (NIN, *) AA, BB
   A=AA; B=BB
   WRITE(NOUT,*) 'The matrix A:'
   DO I = 1, N; WRITE (NOUT,*) 'I = ', I; WRITE (NOUT,FMT) A(I,:); ENDDO
   WRITE(NOUT,*) 'The matrix B:'
   DO I = 1, N; WRITE (NOUT,*) 'I = ', I; WRITE (NOUT,FMT) B(I,:); ENDDO
!
   WRITE ( NOUT, * )'---------------------------------------------------------'
   WRITE ( NOUT, * )
   WRITE ( NOUT, * )'Details of LA_ZGGES LAPACK Subroutine Results.'
   WRITE ( NOUT, * )
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, VSL, VSR, SELECT, SDIM, INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA, VSL, VSR, SELECT, SDIM, INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
   WRITE(NOUT,*) ' Alpha:'
   WRITE(NOUT,FMT) ALPHA
   WRITE(NOUT,*) ' Beta:'
   WRITE(NOUT,FMT) BETA
   WRITE(NOUT,*) 'VSL:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) VSL(:,I); END DO
   WRITE(NOUT,*) 'VSR:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) VSR(:,I); END DO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES(A, B, ALPHA, BETA, INFO=INFO)
   WRITE(NOUT,*) 'INFO = ', INFO
   WRITE(NOUT,*) 'A:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) A(:,I); END DO
   WRITE(NOUT,*) 'B:'
   DO I = 1, N; WRITE(NOUT,*) 'I = ', I; WRITE (NOUT,FMT) B(:,I); END DO
   WRITE(NOUT,*) ' Alpha:'
   WRITE(NOUT,FMT) ALPHA
   WRITE(NOUT,*) ' Beta:'
   WRITE(NOUT,FMT) BETA
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( DUMMY, B, ALPHA, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( DUMMY, B, ALPHA, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, DUMMY, ALPHA, BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, DUMMY, ALPHA, BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA(1:N-1), BETA, INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA(1:N-1), BETA, INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA(1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA(1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, VSL(:,1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA, VSL(:,1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, VSL(1:N-1,:), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA, VSL(1:N-1,:), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, VSR=VSR(1:N-1,:), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA, VSR=VSR(1:N-1,:), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
   WRITE(NOUT,*)
   WRITE(NOUT,*) 'CALL LA_GGES( A, B, ALPHA, BETA, VSR=VSR(:,1:N-1), INFO=INFO )'
   A=AA
   CALL LA_GGES( A, B, ALPHA, BETA, VSR=VSR(:,1:N-1), INFO=INFO )
   WRITE(NOUT,*) 'INFO = ', INFO
!
END PROGRAM LA_ZGGES_ET_EXAMPLE
      LOGICAL FUNCTION SELECT( ALPHA, BETA)
      USE LA_PRECISION, ONLY: WP => DP
      COMPLEX(WP), INTENT(IN) :: ALPHA, BETA
      SELECT = .TRUE.
      END FUNCTION SELECT
            
