#! /usr/bin/env python
#  -*- coding: utf-8 -*-
# ======================================================
#     Multiple_support.py
#  ------------------------------------------------------
# Created for PAGE Version 7 Tutorial
# Written by G.D. Walters
# Copyright (c) 2021 by G.D. Walters
# This source code is released under the MIT License
# ======================================================
# Support module generated by PAGE version 7bb
#  in conjunction with Tcl version 8.6
#    Nov 20, 2021 05:51:51 AM CST  platform: Linux

import sys
import shared  # empty file shared.py in the project folder
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import Multiple


def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol('WM_DELETE_WINDOW', root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = Multiple.Main(_top1)
    # Creates a toplevel widget.
    global _top2, _w2
    _top2 = tk.Toplevel(root)
    _w2 = Multiple.Form2(_top2)
    # Creates a toplevel widget.
    global _top3, _w3
    _top3 = tk.Toplevel(root)
    _w3 = Multiple.Form3(_top3)
    # Process the startup function
    startup()
    root.mainloop()


def startup():
    # Set the shared module variables to False
    # If we don't we will get an error that the variable doesn't exist
    shared.MainActive = True
    shared.Top2Active = False
    shared.Top3Active = False
    # Hide forms 2 and 3
    hide_me_2()
    hide_me_3()
    # Load the button images, since we didn't do it in PAGE
    load_btn_images()


def load_btn_images():
    # Images need a global variable so that Python's garbage collection doesn't
    #    clear the image accidentally.
    global img1, img2, img3, img4, img5, img6, img7, img8
    # Image for button 1
    img1 = tk.PhotoImage(file="./images/img1-40.png")
    _w1.btnBBarShowMain.configure(image=img1)
    # Image for button 2
    img2 = tk.PhotoImage(file="./images/img2-40.png")
    _w1.btnBBarShow2.configure(image=img2)
    # Image for button 3
    img3 = tk.PhotoImage(file="./images/img3-40.png")
    _w1.btnBBarShow3.configure(image=img3)
    # Image for button 4
    img4 = tk.PhotoImage(file="./images/img-Multi-1-2-40.png")
    _w1.btnBBarShow1and2.configure(image=img4)
    # Image for button 5
    img5 = tk.PhotoImage(file="./images/img-Multi-1-3-40.png")
    _w1.btnBBarShow1and3.configure(image=img5)
    # Image for button 6
    img6 = tk.PhotoImage(file="./images/img-Multi-2-3-40.png")
    _w1.btnBBarShow2and3.configure(image=img6)
    # Image for button 7
    img7 = tk.PhotoImage(file="./images/img-Multi-all-40.png")
    _w1.btnBBarShowAll.configure(image=img7)
    # Image for button 8
    img8 = tk.PhotoImage(file="./images/system-shutdown.png")
    _w1.btnBBarExit.configure(image=img8)


def on_mnuExit(*args):
    print('Multiple_support.on_mnuExit')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    root.destroy()


def on_mnuMultipleAll(*args):
    print('Multiple_support.on_mnuMultipleAll')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.Top2Active:
        show_me_2()
    if not shared.Top3Active:
        show_me_3()
    if not shared.MainActive:
        show_me_Main()


def on_mnuMultipleMainSub1(*args):
    print('Multiple_support.on_mnuMultipleMainSub1')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.Top2Active:
        show_me_2()
    if shared.Top3Active:
        hide_me_3()
    if not shared.MainActive:
        show_me_Main()


def on_mnuMultipleMainSub2(*args):
    print('Multiple_support.on_mnuMultipleMainSub2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top2Active:
        hide_me_2()
    if not shared.Top3Active:
        show_me_3()
    if not shared.MainActive:
        show_me_Main()


def on_mnuMultipleSub1Sub2(*args):
    print('Multiple_support.on_mnuMultipleSub1Sub2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.Top2Active:
        show_me_2()
    if not shared.Top3Active:
        show_me_3()
    if shared.MainActive:
        hide_me_Main()


def on_mnuSingleMain(*args):
    print('Multiple_support.on_mnuSingleMain')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top2Active:
        hide_me_2()
    if shared.Top3Active:
        hide_me_3()
    if not shared.MainActive:
        show_me_Main


def on_mnuSingleSub1(*args):
    print('Multiple_support.on_mnuSingleSub1')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.Top2Active:
        show_me_2()
    if shared.Top3Active:
        hide_me_3()
    if shared.MainActive:
        hide_me_Main()


def on_mnuSingleSub2(*args):
    print('Multiple_support.on_mnuSingleSub2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top2Active:
        hide_me_2()
    if not shared.Top3Active:
        show_me_3()
    if shared.MainActive:
        hide_me_Main()


def on_btnBBarShowMain(*args):
    print('Multiple_support.on_btnBBarShowMain')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top2Active:
        hide_me_2()
    if shared.Top3Active:
        hide_me_3()


def on_btnBBarExit(*args):
    print('Multiple_support.on_btnBBarExit')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    root.destroy()


def on_btnBBarShow1and2(*args):
    print('Multiple_support.on_btnBBarShow1and2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top3Active:
        hide_me_3()
    show_me_Main()
    show_me_2()


def on_btnBBarShow1and3(*args):
    print('Multiple_support.on_btnBBarShow1and3')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.Top2Active:
        hide_me_2()
    show_me_Main()
    show_me_3()


def on_btnBBarShow2(*args):
    print('Multiple_support.on_btnBBarShow2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.MainActive:
        hide_me_Main()
    if shared.Top3Active:
        hide_me_3()
    show_me_2()


def on_btnBBarShow2and3(*args):
    print('Multiple_support.on_btnBBarShow2and3')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.MainActive:
        hide_me_Main()
    show_me_2()
    show_me_3()


def on_btnBBarShow3(*args):
    print('Multiple_support.on_btnBBarShow3')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if shared.MainActive:
        hide_me_Main()
    if shared.Top2Active:
        hide_me_2()
    show_me_3()


def on_btnBBarShowAll(*args):
    print('Multiple_support.on_btnBBarShowAll')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    show_me_Main()
    show_me_2()
    show_me_3()


def on_btnDismiss2(*args):
    print('Multiple_support.on_btnDismiss2')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.MainActive:
        show_me_Main()
    hide_me_2()


def on_btnDismiss3(*args):
    print('Multiple_support.on_btnDismiss3')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if not shared.MainActive:
        show_me_Main()
    hide_me_3()


# ===================================================
# Show and hide functions
# ===================================================
def show_me_Main():
    global _top1
    _top1.deiconify()
    shared.MainActive = True


def hide_me_Main():
    global _top1
    _top1.withdraw()
    shared.MainActive = False


def show_me_2():
    global _top2
    _top2.deiconify()
    shared.Top2Active = True


def hide_me_2():
    global _top2
    _top2.withdraw()
    shared.Top2Active = False


def show_me_3():
    global _top3
    _top3.deiconify()
    shared.Top3Active = True


def hide_me_3():
    global _top3
    _top3.withdraw()
    shared.Top3Active = False


# ===================================================
# End of Show and hide functions
# ===================================================

if __name__ == '__main__':
    Multiple.start_up()
