#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
#
# GUI module generated by PAGE version 8.1b
#  in conjunction with Tcl version 8.6
#    Mar 04, 2024 05:50:28 AM CST  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
import os.path

_location = os.path.dirname(__file__)

import sclbDemo8_support

_bgcolor = 'cornsilk4'
_fgcolor = 'black'
_tabfg1 = 'black' 
_tabfg2 = 'white' 
_bgmode = 'light' 
_tabbg1 = '#d9d9d9' 
_tabbg2 = 'gray40' 

_style_code_ran = 0
def _style_code():
    global _style_code_ran
    if _style_code_ran: return        
    try: sclbDemo8_support.root.tk.call('source',
                os.path.join(_location, 'themes', 'page-cornsilkdark.tcl'))
    except: pass
    style = ttk.Style()
    style.theme_use('page-cornsilkdark')
    style.configure('.', font = "-family {DejaVu Sans} -size 10")
    _style_code_ran = 1

class Main:
    def __init__(self, top=None):
        '''This class configures and populates the toplevel window.
           top is the toplevel containing window.'''

        top.geometry("864x683+761+296")
        top.minsize(1, 1)
        top.maxsize(4225, 1410)
        top.resizable(0,  0)
        top.title("ScrolledCheckedListbox version 2.0 Demo ")
        top.configure(background="cornsilk4")
        top.configure(highlightbackground="cornsilk4")
        top.configure(highlightcolor="black")

        self.top = top
        self.MessageData = tk.StringVar()

        _style_code()
        self.TFrame2 = ttk.Frame(self.top)
        self.TFrame2.place(x=2, y=2, height=50, width=860)
        self.TFrame2.configure(relief='sunken')
        self.TFrame2.configure(borderwidth="2")
        self.TFrame2.configure(relief="sunken")

        self.btnExit = ttk.Button(self.TFrame2)
        self.btnExit.place(x=812, y=3, height=42, width=42)
        self.btnExit.configure(command=sclbDemo8_support.on_btnExit)
        photo_location = os.path.join(_location,"./graphics/system-shutdown.png")
        global _img0
        _img0 = tk.PhotoImage(file=photo_location)
        self.btnExit.configure(image=_img0)
        self.btnExit.configure(compound='none')
        self.btnExit_tooltip = \
        ToolTip(self.btnExit, '''Exit Program''')

        self.TFrame1 = ttk.Frame(self.top)
        self.TFrame1.place(x=2, y=52, height=615, width=860)
        self.TFrame1.configure(relief='sunken')
        self.TFrame1.configure(borderwidth="2")
        self.TFrame1.configure(relief="sunken")

        self.FrameSCLB = ttk.Frame(self.TFrame1)
        self.FrameSCLB.place(x=10, y=110, height=495, width=355)
        self.FrameSCLB.configure(relief='sunken')
        self.FrameSCLB.configure(borderwidth="2")
        self.FrameSCLB.configure(relief="sunken")

        self.FrameMessage = ttk.Frame(self.TFrame1)
        self.FrameMessage.place(x=13, y=6, height=95, width=835)
        self.FrameMessage.configure(relief='sunken')
        self.FrameMessage.configure(borderwidth="2")
        self.FrameMessage.configure(relief="sunken")

        self.Message1 = tk.Message(self.FrameMessage)
        self.Message1.place(x=18, y=11, height=72, width=799)
        self.Message1.configure(background="cornsilk4")
        self.Message1.configure(borderwidth="2")
        self.Message1.configure(cursor="crosshair")
        self.Message1.configure(font="-family {DejaVu Sans} -size 11 -weight bold")
        self.Message1.configure(highlightbackground="cornsilk4")
        self.Message1.configure(padx="5")
        self.Message1.configure(pady="5")
        self.Message1.configure(relief="groove")
        self.Message1.configure(text='''Message''')
        self.Message1.configure(textvariable=self.MessageData)
        self.MessageData.set('''Message''')
        self.Message1.configure(width=799)

        self.btnSelectAll = ttk.Button(self.TFrame1)
        self.btnSelectAll.place(x=420, y=290, height=48, width=172)
        self.btnSelectAll.configure(command=sclbDemo8_support.on_btnSelectAll)
        self.btnSelectAll.configure(text='''Select All''')
        self.btnSelectAll.configure(compound='left')
        self.btnSelectAll.configure(style='bold.TButton')

        self.btnClearChecks = ttk.Button(self.TFrame1)
        self.btnClearChecks.place(x=420, y=200, height=48, width=172)
        self.btnClearChecks.configure(command=sclbDemo8_support.on_btnClearChecks)
        self.btnClearChecks.configure(text='''Clear Checks''')
        self.btnClearChecks.configure(compound='left')
        self.btnClearChecks.configure(style='bold.TButton')

from time import time, localtime, strftime
class ToolTip(tk.Toplevel):
    """ Provides a ToolTip widget for Tkinter. """
    def __init__(self, wdgt, msg=None, msgFunc=None, delay=0.5,
                 follow=True):
        self.wdgt = wdgt
        self.parent = self.wdgt.master
        tk.Toplevel.__init__(self, self.parent, bg='black', padx=1, pady=1)
        self.withdraw()
        self.overrideredirect(True)
        self.msgVar = tk.StringVar()
        if msg is None:
            self.msgVar.set('No message provided')
        else:
            self.msgVar.set(msg)
        self.msgFunc = msgFunc
        self.delay = delay
        self.follow = follow
        self.visible = 0
        self.lastMotion = 0
        self.msg = tk.Message(self, textvariable=self.msgVar, bg=_bgcolor,
                   fg=_fgcolor, font="TkDefaultFont",
                   aspect=1000)
        self.msg.grid()
        self.wdgt.bind('<Enter>', self.spawn, '+')
        self.wdgt.bind('<Leave>', self.hide, '+')
        self.wdgt.bind('<Motion>', self.move, '+')
    def spawn(self, event=None):
        self.visible = 1
        self.after(int(self.delay * 1000), self.show)
    def show(self):
        if self.visible == 1 and time() - self.lastMotion > self.delay:
            self.visible = 2
        if self.visible == 2:
            self.deiconify()
    def move(self, event):
        self.lastMotion = time()
        if self.follow is False:
            self.withdraw()
            self.visible = 1
        self.geometry('+%i+%i' % (event.x_root + 20, event.y_root - 10))
        try:
            self.msgVar.set(self.msgFunc())
        except:
            pass
        self.after(int(self.delay * 1000), self.show)
    def hide(self, event=None):
        self.visible = 0
        self.withdraw()
    def update(self, msg):
        self.msgVar.set(msg)
    def configure(self, **kwargs):
        backgroundset = False
        foregroundset = False
        # Get the current tooltip text just in case the user doesn't provide any.
        current_text = self.msgVar.get()
        # to clear the tooltip text, use the .update method
        if 'debug' in kwargs.keys():
            debug = kwargs.pop('debug', False)
            if debug:
                for key, value in kwargs.items():
                    print(f'key: {key} - value: {value}')
        if 'background' in kwargs.keys():
            background = kwargs.pop('background')
            backgroundset = True
        if 'bg' in kwargs.keys():
            background = kwargs.pop('bg')
            backgroundset = True
        if 'foreground' in kwargs.keys():
            foreground = kwargs.pop('foreground')
            foregroundset = True
        if 'fg' in kwargs.keys():
            foreground = kwargs.pop('fg')
            foregroundset = True

        fontd = kwargs.pop('font', None)
        if 'text' in kwargs.keys():
            text = kwargs.pop('text')
            if (text == '') or (text == "\n"):
                text = current_text
            else:
                self.msgVar.set(text)
        reliefd = kwargs.pop('relief', 'flat')
        justifyd = kwargs.pop('justify', 'left')
        padxd = kwargs.pop('padx', 1)
        padyd = kwargs.pop('pady', 1)
        borderwidthd = kwargs.pop('borderwidth', 2)
        wid = self.msg      # The message widget which is the actual tooltip
        if backgroundset:
            wid.config(bg=background)
        if foregroundset:
            wid.config(fg=foreground)
        wid.config(font=fontd)
        wid.config(borderwidth=borderwidthd)
        wid.config(relief=reliefd)
        wid.config(justify=justifyd)
        wid.config(padx=padxd)
        wid.config(pady=padyd)
#                   End of Class ToolTip

def start_up():
    sclbDemo8_support.main()

if __name__ == '__main__':
    sclbDemo8_support.main()




