#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
# ======================================================
#     sclbDemo8_support.py
#  ------------------------------------------------------
# Created for PAGE and PAGE users.
# Written by G.D. Walters
# Copyright © 2023, 2024 by G.D. Walters
# This source code is released under the MIT License
# ======================================================
# Purpose:
#          Demonstration program showing how to use the
#          ScrolledCheckedListBox version 2.0 in PAGE or
#          in a "standard" tkinter program.
# ======================================================
# Support module generated by PAGE version 8.0
#  in conjunction with Tcl version 8.6
#    Mar 04, 2024 03:46:15 AM CST  platform: Linux

import sys
import ScrolledCheckedListBox
import os
import platform

# ======================================================
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

# ======================================================
import sclbDemo8

# ======================================================
_debug = True  # False to eliminate debug printing from callback functions.
location = sclbDemo8._location
programName = "ScrolledCheckedListbox version 2.0 Demo"
version = "0.1.0"

def main(*args):
    """Main entry point for the application."""
    global root
    root = tk.Tk()
    root.protocol("WM_DELETE_WINDOW", root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = sclbDemo8.Main(_top1)
    startup()
    root.mainloop()

def startup():
    global sclb, ListInfo
    # ===================================================
    # Create a list of items for the SCLB
    # ===================================================
    ListInfo = [
        "Appetizer",
        "Snack",
        "Barbecue",
        "Cake",
        "Candy",
        "Beverages",
        "Breads",
        "Canning & Freezing",
        "Cookies",
        "Desserts",
        "Meats",
        "Main Dish",
        "Snacks",
        "Rice",
        "Poultry",
        "Sauces",
        "Soups",
        "American",
        "Mexican",
        "Asian",
    ]
    # ===================================================
    # Instantiate the ScrolledCheckListBox widget as an object
    # ===================================================
    sclb = ScrolledCheckedListBox.ScrolledCheckedListBox(
        _w1.FrameSCLB,
        width=350,
        height=490,
        font="-family {DejaVu Sans} -size 12 -weight bold -slant roman",
        sorted=True,
    )
    # ===================================================
    # Use tkinter Place geometery manager to place the
    #   widget into a frame in your Toplevel.
    # ===================================================
    sclb.place(
        x=0,
        y=0,
        width=350,
        height=490,
    )
    # ===================================================
    # Define the callback function for the SCLB widget
    # ===================================================
    sclb.cback = on_click
    # ===================================================
    # Load the list of items into the SCLB
    # ===================================================
    sclb.load(ListInfo)
    # ===================================================
    # Set some of the checks for the demo
    # ===================================================
    sclb.set(["Appetizer", "Candy", "Breads"])
    # ===================================================
    # Print the version of the SCLB (should be 2.0)
    # ===================================================
    print(f"SCLB Widget version: {sclb.version()}")
    # ===================================================
    # Refresh the Message Widget, showing the checked items
    # ===================================================
    update_label()
    # ===================================================
    # Set the text for the Toplevel Titlebar
    # ===================================================
    _top1.title(programName)
    # ===================================================
    # Show the environment information
    # ===================================================
    show_environ_info()
    # ===================================================
    # Finally, center the Toplevel in the screen.
    # ===================================================
    centre_screen(864, 683)

def on_click(s=None):
    # ======================================================
    # On event, SCLB returns a list containing:
    #    item number selected
    #    text of checkbox selected
    # ======================================================
    update_label()
    print(sclb.get())

def update_label():
    dat = sclb.get()
    lst = []
    for x in dat:
        # print(len(x),x)
        if len(x) == 2:
            t = x[0]
            k = x[1]
            lst.append(t)
        else:
            lst.append(x)
    s = ", ".join(lst)
    _w1.MessageData.set(s)

# ======================================================
# function ClearLabel()
# ------------------------------------------------------
# simply clears the message widget
# ======================================================
def clear_label():
    _w1.MessageData.set("")

def on_btnClearChecks(*args):
    if _debug:
        print("sclbDemo8_support.on_btnClearChecks")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    sclb.clear()
    update_label()

def on_btnExit(*args):
    if _debug:
        print("sclbDemo8_support.on_btnExit")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    sys.exit()

def on_btnSelectAll(*args):
    if _debug:
        print("sclbDemo8_support.on_btnSelectAll")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    for itm in ListInfo:
        sclb.set([itm])
    update_label()

# ===========================================
#   show_environ_info function
# ===========================================
# Shows information at the beginning of the program that could be helpful for troubleshooting
def show_environ_info():
    osVersion = platform.system()
    release = platform.release()
    platformversion = platform.version()
    pv = platform.python_version()
    print("=" * 35)
    print(f"Program name: {programName} {version}")
    print(f"System running {osVersion} {release}")
    print(f"Running under Python {pv}")
    print(f"Program path: {location}")
    print("=" * 35)

# ===========================================
#    Latest centre_screen function
# ===========================================
def centre_screen(wid, hei, testing=False):
    # ===================================================
    # This will centre the Toplevel form in the monitor.
    #     If used in a dual monitor situation, this would
    #     mean that the Toplevel form will centre within a
    #     screen width of (primaryMonitor) + (secondaryMonitor)
    # ---------------------------------------------------
    # Written by G.D. Walters 20 November, 2023
    # ===================================================
    # version 0.9
    # ===================================================
    # Parameters:
    #    Inputs:
    #        wid: integer - Toplevel width
    #        hei: integer - Toplevel height
    #        testing: boolean - Overrides the system width and height.
    #             change the values to the width/height of your primary
    #             monitor.
    #    Returns:
    #        Nothing
    #    Example:
    #        centre_screen(880, 629, 1)
    # ===================================================
    if testing == False:
        ws = root.winfo_screenwidth()
        hs = root.winfo_screenheight()
    else:
        # Override python tkinter winfo_screenwidth/winfo_screenheight
        # set to the values of your monitor to test.  This could be either
        # the primar or secondary monitor screen width and height
        ws = 2560
        hs = 1440
    x = (ws / 2) - (wid / 2)
    y = (hs / 2) - (hei / 2)
    root.geometry("%dx%d+%d+%d" % (wid, hei, x, y))

if __name__ == "__main__":
    sclbDemo8.start_up()




