#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# Support module generated by PAGE version 7v
#  in conjunction with Tcl version 8.6
#    Sep 12, 2021 09:14:18 AM PDT  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import cal
import datetime
import calendar

def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol( 'WM_DELETE_WINDOW' , root.destroy)
    # Creates a toplevel widget.
    global _top34, _w34
    _top34 = root
    _w34 = cal.Toplevel1(_top34)
    init(_top34, _w34)
    root.mainloop()

def init(top, gui, *args, **kwargs):
    global w, top_level, root
    w = gui
    top_level = top
    root = top
    current()

def current(*args):
    sys.stdout.flush()
    w.today = datetime.date.today()
    load_cal(w.today)

def last(*args):
    month = w.date.month - 1
    year = w.date.year
    day = 1
    if month == 0:
        month = 12
        year -= 1
    date = datetime.date(year, month, day)
    load_cal(date = date)

def next(*args):
    month = w.date.month + 1
    year = w.date.year
    if month == 13:
        month = 1
        year += 1
    date = datetime.date(year, month, 1)
    load_cal(date = date)

def load_cal(date):
    obj = w.Text1
    w.date = date
    calendar.setfirstweekday(calendar.SUNDAY)
    cal_str = calendar.month(date.year, date.month)
    obj.delete(1.0, END)
    obj.insert(END,cal_str)
    print (sys._getframe().f_code.co_name, f': {date.year = }')   # Rozen dpr
    print (sys._getframe().f_code.co_name, f': {date.month = }')   # Rozen dpr
    print (sys._getframe().f_code.co_name, f': {w.today.year = }')   # Rozen dpr
    print (sys._getframe().f_code.co_name, f': {w.today.month = }')   # Rozen dpr
    if date.year == w.today.year and date.month == w.today.month:
        # Color today's day if month and year are current month and year.
        day = str(date.day)
        obj.tag_configure('e0', foreground='red')
        obj.tag_remove('e0', 1.0, 'end')
        start = cal_str.find(day,15)  # Skip month and year
        end = start + len(day)
        min_c = '%d.0+%dchars' % (1, start)
        max_c = '%d.0+%dchars' % (1, end)
        obj.tag_add('e0', min_c, max_c)


def quit(*args):
    sys.exit()

if __name__ == '__main__':
    cal.start_up()




