#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# Support module generated by PAGE version 7.4l
#  in conjunction with Tcl version 8.6
#    Apr 22, 2022 07:59:31 AM PDT  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import color_show
from tkinter import simpledialog
import re
import math

def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol( 'WM_DELETE_WINDOW' , root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = color_show.Toplevel1(_top1)
    run()
    root.mainloop()

def run():
    if len(sys.argv) < 2:
        args = simpledialog.askstring("Input", "Input color",parent=root)
    else:
        args = sys.argv[1:]
        args = ' '.join(args)
    hex = 0
    ret = re.search("^[0-9a-f]{6}$", args)
    if ret:
        color = "#" + args
        hex = 1
    else:
        color = args
    print (sys._getframe().f_code.co_name, f': {color = }')   # Rozen dpr
    _w1.Label1.configure(text=color)
    _w1.Frame1.configure(background=color)
    rgb = _top1.winfo_rgb(color)
    rgb = tuple((c//256 for c in root.winfo_rgb(color)))
    (r, g, b) = rgb

    _w1.Message2.configure(text='')
    if hex == 0:
       msg = "#%02x%02x%02x" % (rgb[0], rgb[1], rgb[2])
       _w1.Message2.configure(text=msg)
    h = math.sqrt(0.299 * (r * r) + 0.587 * (g * g)+ 0.114 * (b * b))
    if h > 127.5:
        l_or_d = 'Light'
    else:
        l_or_d = 'Dark'

    _w1.Message3.configure(text=l_or_d)




if __name__ == '__main__':
    color_show.start_up()




