#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# Support module generated by PAGE version 7.4j
#  in conjunction with Tcl version 8.6
#    Apr 09, 2022 09:00:37 AM PDT  platform: Linux

# ======================================================
#     plotextdemo_support.py
#  ------------------------------------------------------
# Created for PAGE 7 Example code set
# Written by G.D. Walters
# Copyright (c) 2021 by G.D. Walters
# This source code is released under the MIT License
# ======================================================

import sys
import platform
import os
# ===================================================
# This program requires plotext package version 4.1.3 or greater
# ===================================================
try:
    import plotext as plt

    pver = plt.version()
    # print(pver)
    if pver < "4.1.3":
        print("A version of Plotext >= 4.1.3 is required to run this program")
        sys.exit(1)
except:
    print("A version of Plotext >= 4.1.3 is required to run this program")
    sys.exit(1)

# ------------------------------------
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
# ------------------------------------

import plotextdemo


def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol( 'WM_DELETE_WINDOW' , root.destroy)
    # Creates a toplevel widget.
    global _top74, _w74
    _top74 = root
    _w74 = plotextdemo.Main(_top74)
    # Since I am manually updating a support module created in an
    # earlier version of PAGE where the numbering was slightly
    # different and "_wX" variable was "w1", I am manually setting
    # "_w1" and making it global. Rozen
    global _w1      
    _w1 = _w74
    setup()
    root.mainloop()

def on_btnClear(*args):
    print('plotextdemo_support.on_btnClear')
    for arg in args:
        print ('another arg:', arg)
    sys.stdout.flush()

def on_btnExit(*args):
    print('plotextdemo_support.on_btnExit')
    for arg in args:
        print ('another arg:', arg)
    sys.stdout.flush()

def on_btnPlot(*args):
    print('plotextdemo_support.on_btnPlot')
    for arg in args:
        print ('another arg:', arg)
    sys.stdout.flush()

def setup():
    global version
    version = "2.0.2"
    pv = platform.python_version()
    print(f"Running under Python {pv}")
    # Set the path for the icon files
    global path1
    path1 = os.getcwd()
    print(path1)
    print(f"Program Version: {version}")
    # ========================================
    global markers, plottypes
    markers = [
        "sd",
        "hd",
        "dot",
        "at",
        "heart",
        "smile",
    ]  # "showflake"]  # The font for the Label Widget does not support the snowflake character
    plottypes = [
        "sine",
        "Simple Bar",
        "Horizontal Bar",
        "Multiple Bar",
        "Log Plot",
        "User Data Plot 1",
        "Travis County Covid New Cases",
        "Hays County Covid New Cases",
        "Travis County Covid Total Cases",
        "Hays County Covid Total Cases",
    ]
    # ========================================
    # Set the first TCombobox
    _w1.TCombobox1["values"] = markers
    _w1.TCombobox1.bind("<<ComboboxSelected>>", lambda e: on_Marker_Select(e))
    global selected
    selected = "sd"
    _w1.TCombobox1.set(markers[0])
    # -------------------------------------
    # Set the second TCombobox
    _w1.TCombobox2["values"] = plottypes
    _w1.TCombobox2.bind("<<ComboboxSelected>>",
                        lambda e: on_PlotType_Select(e))
    _w1.TCombobox2.set(plottypes[0])
    # ========================================
    command_clear()


def on_Marker_Select(e):
    global selected
    selected = _w1.combobox.get()
    command_clear()
    command_plot()


def on_PlotType_Select(e):
    global plottype, plottypes
    plottype = _w1.cmboPType.get()
    if plottype == 'sine':
        _w1.TCombobox1.config(state='normal')
        command_clear()
        command_plot()
    elif plottype == "Simple Bar":
        _w1.TCombobox1.config(state='disabled')
        command_plot_SBar()
    elif plottype == 'Horizontal Bar':
        _w1.TCombobox1.config(state='disabled')
        command_plot_HBar()
    elif plottype == "Multiple Bar":
        _w1.TCombobox1.config(state='disabled')
        command_plot_MBar()
    elif plottype == "Log Plot":
        command_log_plot()
    elif plottype == "User Data Plot 1":
        command_user_data1()
    elif plottype == "Travis County Covid New Cases":
        command_Travis_County(1)
    elif plottype == "Hays County Covid New Cases":
        command_Hays_County(1)
    elif plottype == "Travis County Covid Total Cases":
        command_Travis_County(2)
    elif plottype == "Hays County Covid Total Cases":
        command_Hays_County(2)


def command_clear():
    global markers, plottypes, selected
    _w1.btnClear.config(state="disabled")
    _w1.btnPlot.config(state="normal")
    _w1.TCombobox1.config(state='normal')
    _w1.TCombobox2.set(plottypes[0])
    canv = ""
    _w1.PlotData.set(canv)


def command_plot():
    global selected
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='normal')
    # ===================================================
    # Function data and code from Plotext Website
    # https://github.com/piccolomo/plotext/blob/master/readme/basic.md
    # ===================================================
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    plt.plot(plt.sin(), marker=selected)
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_plot_SBar():
    global selected
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    #     _top1.update()
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Function data and code from Plotext Website
    # https://github.com/piccolomo/plotext/blob/master/readme/bar.md
    # ===================================================
    pizzas = ["Sausage", "Pepperoni", "Mushrooms", "Cheese", "Chicken", "Beef"]
    percentages = [14, 36, 11, 8, 7, 4]
    plt.clc()
    plt.bar(pizzas, percentages)
    plt.title("Most Favored Pizzas in the World")
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_plot_HBar():
    global selected
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Function data and code from Plotext Website
    # https://github.com/piccolomo/plotext/blob/master/readme/bar.md
    # ===================================================
    pizzas = ["Sausage", "Pepperoni", "Mushrooms", "Cheese", "Chicken", "Beef"]
    percentages = [14, 36, 11, 8, 7, 4]
    plt.clc()
    plt.bar(pizzas, percentages,
            orientation="horizontal")  # or shorter orientation = 'h'
    plt.title("Most Favoured Pizzas in the World")
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_plot_MBar():
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Function data and code from Plotext Website
    # https://github.com/piccolomo/plotext/blob/master/readme/bar.md
    # ===================================================
    pizzas = ["Sausage", "Pepperoni", "Mushrooms", "Cheese", "Chicken", "Beef"]
    male_percentages = [14, 36, 11, 8, 7, 4]
    female_percentages = [12, 20, 35, 15, 2, 1]

    plt.multiple_bar(pizzas, [male_percentages, female_percentages],
                     label=["men", "women"],
                     marker=['sd', 'dot'])
    plt.title("Most Favored Pizzas in the World by Gender")
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_log_plot():
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    # ===================================================
    # Function data and code from Plotext Website
    # https://github.com/piccolomo/plotext/blob/master/readme/basic.md
    # ===================================================
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    l = 10**4
    x = range(1, l + 1)
    y = plt.sin(1, 2, l)
    plt.plot(x, y)
    plt.xscale("log")
    plt.yscale("linear")
    plt.grid(1, 0)
    plt.title("Logarithmic Plot")
    plt.xlabel("logarithmic scale")
    plt.ylabel("linear scale")
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_user_data1():
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Covid-19 data from State of Texas Published Spreadsheet
    # https://dshs.texas.gov/coronavirus/AdditionalData.aspx
    # ===================================================
    data = [
        21146, 21183, 21197, 21220, 21254, 21254, 21245, 21245, 21245, 21290,
        21304, 21329, 21350, 21350, 21350, 21472, 21486, 21540, 21562, 21621,
        21621, 21621, 21704, 21761, 21850, 21928, 22020, 22020, 22020, 22305,
        22420
    ]
    datedata = [
        '6/27/21', '6/28/21', '6/29/21', '6/30/21', '7/1/21', '7/2/21',
        '7/3/21', '7/4/21', '7/5/21', '7/6/21', '7/7/21', '7/8/21', '7/9/21',
        '7/10/21', '7/11/21', '7/12/21', '7/13/21', '7/14/21', '7/15/21',
        '7/16/21', '7/17/21', '7/18/21', '7/19/21', '7/20/21', '7/21/21',
        '7/22/21', '7/23/21', '7/24/21', '7/25/21', '7/26/21', '7/27/21'
    ]
    # ===================================================
    # Here we send the data into plotext.
    # ===================================================
    plt.datetime.set_datetime_form(date_form='%m/%d/%y')
    plt.plot_date(datedata, data)
    plt.plotsize(65, 20)
    plt.title("Covid-19 Hays County, Tx. Data from 06/27/2021 - 07/27/2021")
    plt.ylabel('Confirmed Cases')
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_Travis_County(which):
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Covid-19 data from State of Texas Published Spreadsheet
    # https://dshs.texas.gov/coronavirus/AdditionalData.aspx
    # ===================================================
    TravisList = [['Cases 11-21-2021', 121709.0, 0.0],
                  ['Cases 11-22-2021', 121709.0, 0.0],
                  ['Cases 11-23-2021', 121812.0, 103.0],
                  ['Cases 11-24-2021', 122029.0, 217.0],
                  ['Cases 11-25-2021', 122176.0, 147.0],
                  ['Cases 11-26-2021', 122176.0, 0.0],
                  ['Cases 11-27-2021', 122176.0, 0.0],
                  ['Cases 11-28-2021', 122176.0, 0.0],
                  ['Cases 11-29-2021', 122176.0, 0.0],
                  ['Cases 11-30-2021', 122277.0, 101.0],
                  ['Cases 12-01-2021', 122379.0, 102.0],
                  ['Cases 12-02-2021', 122481.0, 102.0],
                  ['Cases 12-03-2021', 122606.0, 125.0],
                  ['Cases 12-04-2021', 122726.0, 120.0],
                  ['Cases 12-05-2021', 122962.0, 236.0],
                  ['Cases 12-06-2021', 123056.0, 94.0],
                  ['Cases 12-07-2021', 123173.0, 117.0],
                  ['Cases 12-08-2021', 123252.0, 79.0],
                  ['Cases 12-09-2021', 123358.0, 106.0],
                  ['Cases 12-10-2021', 123491.0, 133.0],
                  ['Cases 12-11-2021', 123601.0, 110.0],
                  ['Cases 12-12-2021', 123689.0, 88.0],
                  ['Cases 12-13-2021', 123829.0, 140.0],
                  ['Cases 12-14-2021', 123969.0, 140.0],
                  ['Cases 12-15-2021', 124098.0, 129.0],
                  ['Cases 12-16-2021', 124287.0, 189.0],
                  ['Cases 12-17-2021', 124518.0, 231.0],
                  ['Cases 12-18-2021', 124822.0, 304.0],
                  ['Cases 12-19-2021', 125102.0, 280.0],
                  ['Cases 12-20-2021', 125521.0, 419.0]]
    datedata = []
    totaldata = []
    newdata = []
    for case in TravisList:
        datedata.append(case[0][6:])
        totaldata.append(case[1])
        newdata.append(case[2])
    plt.datetime.set_datetime_form(date_form='%m-%d-%Y')
    if which == 1:
        plt.plot_date(datedata, newdata)
        plt.title(
            "Covid-19 Travis County, Tx. NEW Cases 11/21/2021 to 12/20/2021")
    else:
        plt.plot_date(datedata, totaldata)
        plt.title(
            "Covid-19 Travis County, Tx. TOTAL Cases 11/21/2021 to 12/20/2021")
    plt.plotsize(65, 20)
    plt.ylabel('Confirmed Cases')
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def command_Hays_County(which):
    _w1.btnClear.config(state="normal")
    _w1.btnPlot.config(state="disabled")
    _w1.TCombobox1.config(state='disabled')
    plt.clear_data()
    plt.clear_plot()
    plt.clear_figure()
    # ===================================================
    # Covid-19 data from State of Texas Published Spreadsheet
    # https://dshs.texas.gov/coronavirus/AdditionalData.aspx
    # ===================================================
    HaysList = [['Cases 11-21-2021', 30147.0, 0.0],
                ['Cases 11-22-2021', 30147.0, 0.0],
                ['Cases 11-23-2021', 30303.0, 156.0],
                ['Cases 11-24-2021', 30314.0, 11.0],
                ['Cases 11-25-2021', 30314.0, 0.0],
                ['Cases 11-26-2021', 30314.0, 0.0],
                ['Cases 11-27-2021', 30314.0, 0.0],
                ['Cases 11-28-2021', 30314.0, 0.0],
                ['Cases 11-29-2021', 30314.0, 0.0],
                ['Cases 11-30-2021', 30374.0, 60.0],
                ['Cases 12-01-2021', 30408.0, 34.0],
                ['Cases 12-02-2021', 30436.0, 28.0],
                ['Cases 12-03-2021', 30466.0, 30.0],
                ['Cases 12-04-2021', 30502.0, 36.0],
                ['Cases 12-05-2021', 30528.0, 26.0],
                ['Cases 12-06-2021', 30564.0, 36.0],
                ['Cases 12-07-2021', 30579.0, 15.0],
                ['Cases 12-08-2021', 30612.0, 33.0],
                ['Cases 12-09-2021', 30644.0, 32.0],
                ['Cases 12-10-2021', 30684.0, 40.0],
                ['Cases 12-11-2021', 30722.0, 38.0],
                ['Cases 12-12-2021', 30742.0, 20.0],
                ['Cases 12-13-2021', 30761.0, 19.0],
                ['Cases 12-14-2021', 30775.0, 14.0],
                ['Cases 12-15-2021', 30803.0, 28.0],
                ['Cases 12-16-2021', 30846.0, 43.0],
                ['Cases 12-17-2021', 30919.0, 73.0],
                ['Cases 12-18-2021', 30975.0, 56.0],
                ['Cases 12-19-2021', 31020.0, 45.0],
                ['Cases 12-20-2021', 31089.0, 69.0]]
    datedata = []
    totaldata = []
    newdata = []
    for case in HaysList:
        datedata.append(case[0][6:])
        totaldata.append(case[1])
        newdata.append(case[2])
    plt.datetime.set_datetime_form(date_form='%m-%d-%Y')
    if which == 1:
        plt.plot_date(datedata, newdata)
        plt.title(
            "Covid-19 Hays County, Tx. NEW Cases 11/21/2021 to 12/20/2021")
    else:
        plt.plot_date(datedata, totaldata)
        plt.title(
            "Covid-19 Hays County, Tx. TOTAL Cases 11/21/2021 to 12/20/2021")
    plt.plotsize(65, 20)
    plt.ylabel('Confirmed Cases')
    plt.plotsize(160, 35)
    plt.limitsize(False)
    plt.clc()
    canv = ''
    canv = plt.build()
    _w1.PlotData.set(canv)


def on_btnClear(*args):
    print("testrc3_support.on_btnClear")
    for arg in args:
        print("another arg:", arg)
    sys.stdout.flush()
    command_clear()


def on_btnExit(*args):
    print("testrc3_support.on_btnExit")
    for arg in args:
        print("another arg:", arg)
    sys.stdout.flush()
    root.destroy()


def on_btnPlot(*args):
    print("testrc3_support.on_btnPlot")
    for arg in args:
        print("another arg:", arg)
    sys.stdout.flush()
    command_plot()

    
    
    
if __name__ == '__main__':
    plotextdemo.start_up()




