#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
# ======================================================
#     ttiphack4_support.py
#  ------------------------------------------------------
# Created for PAGE 7.6
# Written by G.D. Walters
# Copyright (c) 2022 by G.D. Walters
# This source code is released under the MIT License
# ======================================================
#
# ===================================================
# Purpose:
#    To create a configurations function to allow tooltip
#    defaults to be modified to a user desired configuration.
#    See function HackTooltip for more information.
# ===================================================
# Version 4.2
# ===================================================
# Change list
# ---------------------------------------------------
# Added Don's hack to my hack in GUI.py file
# Removed Entry widget and replaced with ScrolledTextbox
#   to support multiline text.
# ===================================================
# Support module generated by PAGE version 7.6d
#  in conjunction with Tcl version 8.6
#    Oct 05, 2022 01:33:17 PM CDT  platform: Linux
#    Oct 06, 2022 04:24:12 AM CDT  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
from tkinter import colorchooser

# from regex import F

import ttiphack4

_debug = False  # False to eliminate debug printing from callback functions.


def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol('WM_DELETE_WINDOW', root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = ttiphack4.Toplevel1(_top1)
    startup()
    root.mainloop()


def startup():
    # These are the things to do on startup...
    global ReliefInfo, JustifyInfo
    ReliefInfo = 'flat'
    JustifyInfo = 'left'
    global currentbackground, currentforeground, currentfont, currentpadx, currentpady, currentrelief, currentjustify, currenttext
    currentbackground = '#ffffdd'
    currentforeground = 'black'
    currentfont = 'TkDefaultFont'
    currentpadx = 1
    currentpady = 1
    currentjustify = 'left'
    currentrelief = 'flat'
    borderwidthdata = 2
    currenttext = 'This is a very long string of text \n so I can see if the multiline abilities \n will work!'
    _w1.Scrolledtext1.insert(1.0, currenttext)
    _w1.bkgnd.set(currentbackground)
    _w1.frgnd.set(currentforeground)
    _w1.FontData.set(currentfont)
    _w1.BorderwidthData.set(borderwidthdata)
    setup_combos()
    setup_pad_defaults()

    _w1.Button1.configure(text='Hover here to see tooltip')
    _w1.btnTryIt_tooltip = ttiphack4.ToolTip(
        _w1.btnTryIt, 'TkDefaultFont', '''Click here after making changes.''')


def setup_combos():
    global currentrelief, currentjustify
    justifyoptions = ['left', 'center', 'right']
    reliefoptions = ['flat', 'raised', 'sunken', 'groove', 'ridge']
    _w1.TCombobox1['values'] = reliefoptions
    _w1.TCombobox2['values'] = justifyoptions
    _w1.TCombobox1.bind("<<ComboboxSelected>>",
                        lambda e: on_CmboReliefSelect(e))
    _w1.TCombobox2.bind("<<ComboboxSelected>>",
                        lambda e: on_CmboJustifySelect(e))
    _w1.TCombobox1.set(currentrelief)
    _w1.TCombobox2.set(currentjustify)


def on_CmboJustifySelect(e):
    global currentjustify
    if _debug:
        print("JustifySelect")
    selected = _w1.JustifyData.get()
    if _debug:
        print(selected)
    currentjustify = selected


def on_CmboReliefSelect(e):
    global currentrelief
    if _debug:
        print("ReliefSelect")
    selected = _w1.ReliefData.get()
    if _debug:
        print(selected)
    currentrelief = selected


def setup_pad_defaults():
    global currentpadx, currentpady
    _w1.PadxData.set(currentpadx)
    _w1.PadyData.set(currentpady)


def on_btnExit(*args):
    if _debug:
        print('ttiphack4_support.on_btnExit')
        for arg in args:
            print('    another arg:', arg)
        sys.stdout.flush()
    sys.exit()


def on_btnTryIt(*args):
    if _debug:
        print('ttiphack4_support.on_btnTryIt')
        for arg in args:
            print('    another arg:', arg)
        sys.stdout.flush()
    HackToolTip()


def on_btngetfont(*args):
    global currentfont
    if _debug:
        print('ttiphack4_support.on_btngetfont')
        for arg in args:
            print('    another arg:', arg)
        sys.stdout.flush()
    global newfont
    root.tk.call('tk', 'fontchooser', 'configure', '-font', currentfont,
                 '-command', root.register(font_changed))
    root.tk.call('tk', 'fontchooser', 'show')


def font_changed(font):
    global currentfont
    if _debug:
        print('font_changed called.')
    global newfont
    newfont = font
    currentfont = font
    _w1.FontData.set(currentfont)


def HackToolTip():
    '''
    This function will call the added config method of the tooltip class provided by PAGE 7.6
    NOTE: This will not work with earlier versions of the tooltip class, since the config method isn't provided.
    ---------------------------------------
    Configuration options provided:
        background color - Either a named color or hex value.
        foreground color - Either a named color or hex value.
        font - Should be a string like '{DejaVu Sans} 10 Bold'.
        text - any legal string.
        justify - for multiline strings - can be 'left','right','center'.
        relief - any legal tk relief name.  Must be lower case.
        padx - Padding to the right and left of text in pixels.
        pady - Padding above and below text in pixels.
        borderwidth - Area around the relief in pixels.  Ignored when relief is 'flat'.
        debug - Provided for developers.  If True, will print out all the parameters
                passed to the config method
    ------------------------------------------
    Call should be like...

    widget_tooltip.config(parameters)
    ------------------------------------------
    Parameters may be in any order and for those not needed you dont' have to provide.
    ------------------------------------------
    Background and foreground colors may be sent in as either
        background={color}
        foreground={color}
    or
        bg={color}
        fg={color}
    ------------------------------------------
    '''
    global currentrelief, currentjustify

    _w1.Button1_tooltip.configure(
        text=_w1.Scrolledtext1.get(1.0, END),
        # send either "background" and "foreground" or "bg" and "fg"
        background=_w1.bkgnd.get(),
        foreground=_w1.frgnd.get(),
        # bg=_w1.bkgnd.get(),
        # fg=_w1.frgnd.get(),
        font=_w1.FontData.get(),
        justify=currentjustify,
        relief=currentrelief,
        padx=_w1.PadxData.get(),
        pady=_w1.PadyData.get(),
        borderwidth=_w1.BorderwidthData.get(),
        debug=True,
    )


def on_Background_Click(*args):
    if _debug:
        print('ttiphack4_support.on_Background_Click')
        for arg in args:
            print('    another arg:', arg)
        sys.stdout.flush()
    global currentbackground
    newcolor = colorchooser.askcolor(initialcolor=currentbackground)
    _w1.bkgnd.set(newcolor[1])
    currentbackground = newcolor[1]


def on_Foreground_Click(*args):
    if _debug:
        print('ttiphack4_support.on_Foreground_Click')
        for arg in args:
            print('    another arg:', arg)
        sys.stdout.flush()
    global currentforeground
    newcolor = colorchooser.askcolor(initialcolor=currentforeground)
    _w1.frgnd.set(newcolor[1])
    currentforeground = newcolor[1]


if __name__ == '__main__':
    ttiphack4.start_up()
