# -*- Tcl -*-
# Time-stamp: 2012-12-17 23:00:07 rozen>

# gui_python_gen.tcl - procedures for generating Python User Interfaces
#
# This program was written by Don Rozenberg and is based on java_ui.tcl
# written by Constantin Teodorescu.
#
# The original copyright notice is attached and this program is released
# under the terms of that copyright.
#
# Copyright (C) 1996-1997 Constantin Teodorescu
# Copyright (C) 2013-2020 Donald Rozenberg
#
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
##############################################################################

# vTcl:python_quick_run
# vTcl:python_parse_men
# vTcl:Window.py_console
# vTcl:python_configure_widget
# vTcl:relative_placement
# vTcl:relative_x_y
# vTcl:python_source_widget    Switch for generating code for each widget class
# vTcl:python_menu_options
# vTcl:python_process_menu
# vTcl:generate_python           Top of the python generation.
# vTcl:generate_python_UI
# vTcl:style_code
# vTcl:get_top_level_configuration
# vTcl:python_menu_font
# vTcl:python_generate_context_menu
# vTcl:save_GUI_file
# vTcl:toplevel_geometry
# vTcl:python_dump_bind
# vTcl:create_functions
# vTcl:load_python_idle
# vTcl:run_prep
# vTcl:load_console
# vTcl:create_functions          Where the functions are created for the output
# vTcl:validation_parameters
# vTcl:calc_relative_geometry
# vTcl:py_build_set_Tk_var
# vTcl:style_function           Output function _style_function.
# vTcl:get_global_colors        Output color statements
# vTcl:get_global_fonts
# vTcl:style_function           Creates _style_code

# Changes: line 70

#  To  add a special attribute:
#      1. Add the attribute to global.tcl or lib_tix to put it in
#          vTcl(opt,list)
#      2. Add a new case to vTcl:update_widget_info
#      3. Add code to case of  vTcl:python_source_widget to handle
#             the special attributes.

#  Menu stuff starts 1900.

proc lambda {{p1 ""} {p2 ""} {p3 ""} {p4 ""} {p5 ""} {p6 ""} {p7 ""} {p8 ""}} {
    # This is a null proc to facilitate certain bindings.
    # If the user binds a command to a window event it may be executed when
    # the tcl file is sourced.  Since the command will attempt to execute a
    # Python lambda function, an error message will occur.  By having this null
    # procedure, the error message is avoided.
}


proc vTcl:generate_python_UI {} {
    # Code Generation starts here. <control-p> brings us here. Creates
    # the Python Console and calls vTcl:generate_python for actual
    # code generation.
    global vTcl env
    global widget
    global tcl_platform
	set vTcl(imported_support_module) 0
    if {$vTcl(change)} {
        vTcl:save
        set vTcl(change) 0
    }
    if {![file exists $vTcl(project,file)]} {
        vTcl:save
    }
    set vTcl(rework) 1                 ;# for debugging rework second version.
    # set window $vTcl(real_top)
    # if {$window == ""} {
    #     # There is nothing to save or process.
    #     tk_dialog .foo Error "There is no GUI to process." error 0 "OK"
    #     return
    # }
    vTcl:get_project_name    ;# Creates vTcl(project,name)
    set vTcl(project_specified) 1
    vTcl:Window.py_console "gui"
    update
    $vTcl(gui_source_window) delete 1.0 end
    $vTcl(gui_output_window) delete 1.0 end
    vTcl:set_timestamp
    # if {![info exists vTcl(bar_height)]} {
    #     vTcl:window_geom
    # }
    set source \
        "#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
#
# GUI module generated by PAGE version $vTcl(version)
#  in conjunction with Tcl version $vTcl(tcl_version)
#    $vTcl(timestamp)  platform: $tcl_platform(os)\n"
    # Append to source the import code.
    append source \
"
import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
"
    append source \
"import os.path

_location = os.path.dirname(__file__)
"

    vTcl:get_import_name
    append source \
"
import $vTcl(import_name)\n"
    append source [vTcl:get_global_colors] 
    #append source [vTcl:get_global_fonts]

    set vTcl(funct_list) {}
    set vTcl(functions) ""
    set vTcl(class_functions) ""
    set vTcl(proc_list) {}
    set vTcl(fonts_defined,$vTcl(actual_gui_font_dft_name)) 1
    set vTcl(fonts_defined,$vTcl(actual_gui_font_text_name)) 1
    set vTcl(fonts_defined,$vTcl(actual_gui_font_fixed_name)) 1
    set vTcl(fonts_used) []
    set vTcl(menu_names) []
    set vTcl(image_count) 0
    lappend vTcl(alias_names) 1
    set bg $vTcl(actual_bg)
    set vTcl(bgcolor) $bg
    set fg $vTcl(actual_fg)
    set vTcl(fgcolor) $fg
    set vTcl(import_module) 0
    set vTcl(import_module) "[file rootname $vTcl(project,file)]_support.py"
    set t [file tail $vTcl(project,file)]
    regsub -all "#" $t "" t
    set vTcl(import_name) [file rootname $t]_support

    set root_list [winfo children .]
    set vTcl(popup_code) ""

    set vTcl(toplevel_config) ""
    if {[info exists vTcl(py_initfunc)]} {
        # set vTcl(py_initfunc) ""
        unset vTcl(py_initfunc)
    }
    set vTcl(need_PIL) 0
    # Determine popup code before we analyze and determine the code
    # for the toplevel widgets. However I wait to output the code
    # after I have put out any necessary function: _style_code.
    set vTcl(add_helper_code) 0
    set vTcl(add_pnotebook_helper) 0
    set vTcl(tooltip_helper) 0
    set vTcl(helper_list) {}
    set vTcl(toplevel_menu_header) ""
    set vTcl(Tree_cnt) 0
    set vTcl(slash_pos_list) 0
    set vTcl(pw_cnt) 0
#    set vTcl(image_count) 0
    set vTcl(menu_names) []
    set vTcl(menu_image_count) 0
#    set vTcl(using_ttk) 0
    set vTcl(import_module) 0
    set vTcl(gui_save_warning) ""
    set vTcl(gui_search_pattern) ""
    set vTcl(gui_py_change_time) [clock milliseconds]
    set vTcl(pnotebook_count) 0
    set vTcl(global_using_ttk) 0
    set vTcl(ttk_classes_found) [list]
foreach window $vTcl(tops) {
    if {[string first ".bor" $window] == 0} { continue }
    # For debugging only
    #set winfo_geometry [winfo geometry $window]
    #set wm_geometry [winfo geometry $window]
    #end debug code
    if {![info exists vTcl($window,x)]} {
        vTcl:active_widget $window
    }
    set vTcl(py_title) [wm title $window]
    set alias $widget(rev,$window)
    set  vTcl(py_classname) [vTcl:clean_string $alias]


    #--------------------------------------------------------------- #
    set vTcl(in_popup) 0
    set vTcl(no_popup) 0
    set vTcl(tnotebook_count) 0
    set vTcl(notebook_image_count) 0
    set vTcl(using_ttk) 0
    set vTcl(style_code_emitted) 0
    set vTcl(toplevel_menu_header) ""
    ;# <---------------------------------------
    try {
        #vTcl:withBusyCursor {
        set top_source [vTcl:generate_python $window]
        # append source $top_source   ;# NEEDS WORK code
        append source_t $top_source
        #}
    } trap {401} {errmsg} {
        #set err_split [split $errmsg]
        set err_split [regexp -all -inline {\S+} $errmsg]
        set wid [lrange $err_split 2 2]
        Window hide .vTcl.gui_console
        Window show $window
        vTcl:select_widget $wid
        vTcl:create_handles $wid
        return
    }
}
# After going thru code generation of code for toplevels but before
# outputting that code we put out the global fonts
append source [vTcl:get_global_fonts] ;# NEEDS WORK code

# If we have used images in the GUI then the following code is emitted.
# if {$vTcl(image_count) > 0} {
#         append source \
# "import os.path
# _script = sys.argv\[0\]
# _location = os.path.dirname(_script)
# "
# }

# We also put out style routine at the top before the toplevel code.
append source [vTcl:style_function] ;# NEEDS WORK code

# Drop in the popup code here.

# if {[info exists popup_code]} {
#     append source $popup_code
# }

# Need to go thru code generation of code for toplevels to learn which
# fonts may be used before putting out that code.
append source $source_t

    # Create the PNotebook helper functions. vTcl(add_pnotebook_helper)
    # set in vTcl:python_source_widget.
    if {$vTcl(add_pnotebook_helper)} {
        set pnotebook_helper [create_pnotebook_helper]
    } else {
        set pnotebook_helper ""
    }
    if {$pnotebook_helper != ""} {
        append source \
            "$pnotebook_helper"
    }

    # If user wants balloon help (tooltips) create helper function here.
    if {$vTcl(tooltip_helper)} {
        set tooltip_helper [vTcl:create_tooltip_helper]
    } else {
        set tooltip_helper ""
    }
    if {$tooltip_helper != ""} {
        append source \
            "$tooltip_helper"
    }

    # Finally the ttk helper functions. vTcl(add_helper_code) set in
    # widget switch in vTcl:python_source_widget.
    if {$vTcl(add_helper_code)} {
        set ttk_helper [create_ttk_helper]
    } else {
        set ttk_helper ""
    }
    if {$ttk_helper != ""} {
        append source \
            "$ttk_helper"
    }
# end of trial

    append source \
"
def start_up():
$vTcl(tab)$vTcl(import_name).main()\n\n"
    append source \
"if __name__ == '__main__':
$vTcl(tab)$vTcl(import_name).main()\n"
    set numbered [vTcl:add_line_numbers $source]
    $vTcl(gui_source_window)  insert end $numbered
    set vTcl(python_module) "GUI"            ;#  10/4/14
    set vTcl(gui_save_warning) "Unsaved changes"
    set vTcl(py_source) $source
    vTcl:colorize_python "gui"
    set filename "[file rootname $vTcl(project,file)].py"
    set top .vTcl.gui_console
    wm title $top "GUI Console - $filename"
    update
}

proc vTcl:generate_python {window} {
    # This is the top of the python generation. Called from
    # vTcl:generate_python_UI.
    global vTcl
    global tcl_platform
    global style_code
    # set vTcl(add_helper_code) 0
    # set vTcl(add_pnotebook_helper) 0
    # set vTcl(tooltip_helper) 0
    # set vTcl(helper_list) {}
    # set vTcl(toplevel_menu_header) ""
    # set vTcl(Tree_cnt) 0
    # set vTcl(slash_pos_list) 0
    # set vTcl(pw_cnt) 0
    # set vTcl(image_count) 0
    # set vTcl(menu_names) []
    # set vTcl(menu_image_count) 0
    # set vTcl(using_ttk) 0
    # set vTcl(import_module) 0
    # set vTcl(gui_save_warning) ""
    # set vTcl(gui_search_pattern) ""
    #vTcl:set_timestamp
    #set vTcl(gui_py_change_time) [clock milliseconds]
    # The following loop gets rid of all the fonts that were defined
    # in the last call to generate python.  In short, it is one of the
    # things necessary to let one generate python multiple times within
    # PAGE.
    foreach index [array names vTcl fonts_defined,*] {
        unset vTcl($index)
    }

    #set vTcl(fonts_defined,gui_font_dft) 1

    set vTcl(fonts_defined,$vTcl(actual_gui_font_dft_name)) 1
    set vTcl(fonts_defined,$vTcl(actual_gui_font_text_name)) 1
    set vTcl(fonts_defined,$vTcl(actual_gui_font_fixed_name)) 1
    set vTcl(fonts_used) []
    set bg $vTcl(actual_bg)
    set vTcl(bgcolor) $bg
    set fg $vTcl(actual_fg)
    set vTcl(fgcolor) $fg
    lappend vTcl(alias_names) 1
    unset vTcl(alias_names)
    if {[info exists style_code]} {
        unset style_code
    }
    lappend vTcl(alias_names) 1
    set resizable [wm resizable $window]
    if {([lindex $resizable 0]=="0") || ([lindex $resizable 1]=="0")} {
        set resizable false
    } else {
        set resizable true
    }
    set classname $vTcl(py_classname)
    set title $vTcl(py_title)
    set constructor_arguments ""
    set constructor_super ""
    set main_args ""
    set main ""
    set onWindowClose "this.setVisible(false); this.dispose();"
    #    set lwin $vTcl(py_window)
    set geom [vTcl:toplevel_geometry $window]
    #set vTcl(geometry) \"[winfo geometry $window]\"
    set vTcl(geometry) $geom
    # set main "\nif __name__ == '__main__':\n"
    # # append main "$vTcl(tab)vp_start_gui()\n"
    # append main "$vTcl(tab)import $vTcl(import_name)\n"
    # append main "$vTcl(tab)$vTcl(import_name).main()\n"
    set onWindowClose "sys.exit()"
    set vTcl(py_vars) {}
    set vTcl(py_initfunc) {}
    set vTcl(py_funcdef) {}
    set vTcl(py_action) {}
    set vTcl(py_has_menus) 0
    set vTcl(global_variable) 0
    #set vTcl(l_v_list) {}
    set vTcl(funct_list) {}
    set vTcl(functions) ""
    set vTcl(class_functions) ""
    set vTcl(proc_list) {}
    ;# NEEDS WORK Am I setting these at the wrong place
    set vTcl(g_v_list) [list]
    set vTcl(t_v_list) [list]   ;# values of text variable attributes
    set vTcl(v_list) [list]     ;# values of variables attributes
    set vTcl(p_v_list) [list]   ;# values of variables attributes for popup
    set source ""
    #    set vTcl(output_adjust_sash) 0   ;# temporary
    foreach bg [array names vTcl py_btngroup,*] {
        unset vTcl($bg)
    }
    set vTcl(import_module) "[file rootname $vTcl(project,file)]_support.py"
    vTcl:get_import_name
    # generates code for all the widgets.
    vTcl:py_source_frame $window   ""  ""
    #vTcl:py_process_menubutton_list

    # generate code for creating tk variables.
    vTcl:py_tk_variable_code

    # Put in stuff like geometry,title, etc.
    vTcl:get_top_level_configuration $window ;# Move-to-just-once
    set my_procs ""
    set class_procs "\n"
    # if {$vTcl(global_variable)} {
    #     set set_vars [vTcl:py_build_set_Tk_var $vTcl(g_v_list)]
    # } else {
    #     set set_vars ""
    # }
    set set_vars ""
    set start_up_proc [vTcl:python_gui_startup $geom $title $classname]

    #set my_procs "def init():\n    pass\n"

    # Separate the proc's into those that go inside the class definition
    # from those that go outside.  Skip any without the 'py:' prefix.

    # The next loop and the call to create_functions generate the code
    # for the functions needed to make code executable.  They fall
    # into two cases, those which the user specified using the function
    # editor and those which PAGE detected from bindings or command
    # attributes. For the first case, all I do is to spit them out and
    # add their names to vTcl(proc_list) to preclude their being
    # generated twice. With the rest, I guess that I will have to
    # analyze the argument lists to generate parameter lists.

    # This deals with the proc which were generated with the Function
    # Editor. These are the py:... functions.
    set init_found 0
    foreach i  [lsort $vTcl(procs)] {
        if {[string first "py:" $i] == -1} {
            continue
        }
        if {$i == "main"} {
            continue
        }
        if {$i == "vp_start_gui"} {
            continue
        }
        if {$i == "append_python_attributes"} {
            continue
        }
        if {$i == "py:init"} {
            set init_found 1
        }
        if {![regexp -nocase {vtcl} $i]} {
            # I just want the name so I pick up between the "def " and
            # the parameter list.
            set last [string first "(" $new_proc]
            set nn [string range $new_proc 4 [expr $last - 1]]
            set nn [string trim $nn]
            lappend vTcl(proc_list) $nn
            set p1 $last
            set p2 [string first ")" $new_proc]
            set parm_list [string range $new_proc [expr $p1 + 1] [expr $p2 - 1]]
            set type "global"
            if {$parm_list == "self"} {set type "class"}
            if {[string first "self," $parm_list] > -1} {set type "class"}
            if {$type == "global"} {
                # Global proc
                set new_proc [vTcl:python_subst_tabs $new_proc]
                set new_proc [vTcl:python_delete_lambda $new_proc]
                #set my_procs "$my_procs$new_proc\n"
                append my_procs "$new_proc\n"
            } else {
                # class procs
                set new_proc [vTcl:python_delete_lambda $new_proc]
                set new_proc [vTcl:python_subst_tabs $new_proc]
                set new_proc [vTcl:python_delete_leading_tabs $new_proc]
                set new_proc [vTcl:python_indent_lines $new_proc]
                #set class_procs "$class_procs$new_proc\n"
                append class_procs "$new_proc\n"
            }
        }
    }
    if {$init_found == 0} {
        if {$vTcl(import_module) == ""} {
            append my_procs "def init():\n    pass\n"
        }
    }

    if {$vTcl(need_PIL)} {
        append source \
            "

from PIL import Image, ImageTk
"
    }
    if {$vTcl(global_string) != ""} {
        append source \
            "
$vTcl(global_string)
"
    }
    if {$start_up_proc != ""} {
        append source \
            "
$start_up_proc
"
    }
    if {$set_vars != ""} {
        append source \
            "
$set_vars
"
    }
    if {$my_procs != ""} {
        append source \
            "
$my_procs
"
    }
# I don't create any user functions in GUI module 9/15/21
#     if {$vTcl(functions) != ""} {
#         append source \
#             "
# $vTcl(functions)
# "
#     }
    append source \
        "
class $classname:
$vTcl(tab)def __init__(self, top=None):
$vTcl(tab)$vTcl(tab)'''This class configures and populates the toplevel window.
$vTcl(tab)$vTcl(tab)   top is the toplevel containing window.'''
$vTcl(toplevel_config)
$vTcl(tab)$vTcl(tab)self.top = top
$vTcl(tkvar_code)
$vTcl(py_initfunc)"
	if {$vTcl(class_functions) ne ""} {
		append source \
             "
$vTcl(class_functions)
"
    }
    if {$vTcl(popup_code) != ""} {
        append source \
"$vTcl(popup_code)"
		set vTcl(popup_code) ""
	}	

    # set source "$source
    # $balloon_code
    # $class_procs
    # $ttk_helper
    # $main
    # "
#     if {$balloon_code != ""} {
#         append source \
#             "
# $balloon_code
# "
#     }
#     if {$class_procs != ""} {
#         append source \
#             "
# $class_procs
# "
#     }

#     if {$pnotebook_helper != ""} {
#         append source \
#             "$pnotebook_helper"
#     }

#     if {$tooltip_helper != ""} {
#         append source \
#             "$tooltip_helper"
#     }

#     if {$ttk_helper != ""} {
#         append source \
#             "$ttk_helper"
#     }

return $source
    #set numbered [vTcl:add_line_numbers $source]
    #$vTcl(gui_source_window)  delete 1.0 end
    # $vTcl(gui_source_window)  insert end $numbered
    $vTcl(gui_source_window)  insert end $source
    set vTcl(python_module) "GUI"            ;#  10/4/14
    set vTcl(gui_save_warning) "Unsaved changes"
    set vTcl(py_source) $source
    #vTcl:colorize_python "gui"
    set filename "[file rootname $vTcl(project,file)].py"
    set top .vTcl.gui_console
    wm title $top "GUI Console - $filename"
    update
    return
}

proc vTcl:python_unique_menu_name {name} {
    # Sees if name is in vTcl(menu_names) and if so generates an
    # integer when when appended to the name is unique in the
    # list. The last step is to add the new name to the list.
    global vTcl
	set i 0
    set final_name ${name}0
    # while {[lsearch -exact $vTcl(menu_names) $final_name] > -1} {
    #     incr i
    # }
	while {$final_name in $vTcl(menu_names)} {
		set final_name ${name}[incr i]		
	}
    lappend vTcl(menu_names) $final_name
    return $final_name
}

proc vTcl:context_function_name {top} {
	# Get an unique to the toplevel window function name.
	global vTcl
	set vTcl($top,no_popups) 0
	set children [winfo children $top]
	foreach child $children {
		if {[string first ".pop" $child] > 0} {incr vTcl($top,no_popups)}
	}
	return $vTcl($top,no_popups)
}

proc vTcl:seek_menu_variables { target } {
	global vTcl
	set entries [$target index end]
	if {$entries == "none"} {return}
	set vTcl(variables) ""
    for {set i 0} {$i<=$entries} {incr i} {
        set type [$target type $i]
        set opts [$target entryconfigure $i]
        set lab_name {}
        switch $type {
            cascade {
                set child [$target entrycget $i -menu]
                vTcl:seek_menu_variables $child
			}
			checkbutton -
            radiobutton {
				lappend vTcl(variables) [$target entrycget $i -variable]
			}
		}
	}
}

proc vTcl:add_line_numbers {code} {
    # Split the code and add line numbers and remove multiple blank
    # lines. Had a user who generated more than 10,000 lines of code.
    global vTcl
    regsub -all {\n\n\n+} $code "\n\n" code
    set i 1
    foreach line [split $code "\n"] {
        set filler_len [expr 5 - [string length $i]]
        set filler [string repeat " " $filler_len]
        append str $filler  $i " " $line "\n"
        incr i
    }
    return $str
}

proc vTcl:remove_numbers {code} {
    # Remove the leading line numbers from the code in the Python
    # Console before saving the code.
    global vTcl
    foreach line [split $code "\n"] {
        set new_line [string range $line 6 end]
        append str $new_line "\n"
    }
    return $str
} ;# end remove_numbers

proc vTcl:remove_tabs {code} {
    # Replace tabs with vTcl(tab) the length of which is set in the
    # preferences.
    global vTcl
    regsub -all "\t" $code $vTcl(tab) ret
    return $ret
}

proc vTcl:toplevel_geometry {window} {
    global vTcl tcl_platform
    # Routine to set up toplevel geometry for use in generated
    # code. The geometry now includes setting up the geometry as well
    # as setting the attributes of minsize, maxsize, and resizable.

    # Determine default position.
    set str "\n"
    set dflt_origin $vTcl(pr,default_origin)
    if {[info exists ::widgets::${window}::dflt,origin]} {
        set dflt_origin [vTcl:at ::widgets::${window}::dflt,origin]
    }
    # It seems that wm geometry is wm's understanding while winfo
    # geometry is the actual current geometry. Confusing!  On Linux,
    # the two differ by the bar height, the top decoration plus menu
    # bar, and the border width.
    if {$tcl_platform(os) == "Linux"} {
        vTcl:window_decoration $window  ;# Determines decoration thicknesses
    } else {
        set vTcl(bar_height) 0
        set vTcl(border_width) 0
    }
    set geom [winfo geometry $window]
    set geom_split [split $geom "x+"]
    foreach {w h x y} $geom_split {}
    if {!$dflt_origin} {
        set x [expr {$x - $vTcl(border_width)}]
        set y [expr {$y - $vTcl(bar_height)}]
        append str "\n" $vTcl(tab2)top.geometry(\"$w x $h + $x + $y\")
    } else {
        append str "\n" $vTcl(tab2)top.geometry(\"$w x $h\")
    }
    set minsize [wm minsize $window]
    foreach {w h} $minsize {
        append str "\n" "$vTcl(tab2)top.minsize($w, $h)"
    }
    set maxsize [wm maxsize $window]
    foreach {w h} $maxsize {
        append str "\n" "$vTcl(tab2)top.maxsize($w, $h)"
    }
    #set resizable [wm resizable $window]
    #foreach {w h} $resizable {
    #    append str "\n" "$vTcl(tab2)top.resizable($w, $h)"
    #}
    # if {[vTcl:get_mode $window] eq "Absolute"} {}
    # if {$vTcl(mode) eq "Absolute"} {
    #     append str "\n" "$vTcl(tab2)top.resizable(0, 0)"
    # } else {
    #     append str "\n" "$vTcl(tab2)top.resizable(1, 1)"
    # }
    append str "\n" \
        "$vTcl(tab2)top.resizable($vTcl(actual_relative_placement), \
        $vTcl(actual_relative_placement))"
    return $str
}

proc vTcl:py_tk_variable_code {} {
    # Generates the code in the init function to create instances of
    # tk_variables.
    global vTcl
    set vTcl(tkvar_code) ""
	foreach {var class text} $vTcl(t_v_list) {
		regsub {^::vTcl::} $var "" var
        regsub {^::} $var "" var
        regsub {^::vTcl::} $text "" text
        append vTcl(tkvar_code) \
            "$vTcl(tab)$vTcl(tab)self.$var = " tk.${class}() "\n"
        if {$text ne ""} {
            append vTcl(tkvar_code) \
                "$vTcl(tab)$vTcl(tab)self.${var}.set('$text')\n"
        }
    }
    foreach {var class} $vTcl(g_v_list) { 
    #foreach entry $vTcl(g_v_list) { }
		#set var [lindex $entry 0]
		#set class [lindex $entry 1]
		append vTcl(tkvar_code) \
            "$vTcl(tab)$vTcl(tab)self.$var = " tk.${class}() "\n"
    }
}
proc vTcl:create_functions {{gen gui}} {
    # Generate functions contained in vTcl(funct_list).  Called from
    # vTcl:generate_python near line 270. Also called from
    # support_python_gen.tcl.
    global vTcl
    set vTcl(functions) ""
    set mod ""
    set name_list {}
    if {! [info exists vTcl(funct_list)] || $vTcl(funct_list) eq ""} {
        # Empty list
        return
    }
    foreach fun [lsort -unique $vTcl(funct_list)] {
        if {$fun eq ""} continue
        if {$gen == "import" && \
                [regexp {^popup[0-9]+} $fun]} continue
        if {$fun == "_button_press" || $fun == "_button_release"
            || $fun == "_mouse_over" } continue
        # separate name and argument list.
        set spot [string first "(" $fun]
        if {$spot > -1} {
            set name [string range $fun 0 [expr $spot - 1]]
            set arg_list [string range $fun $spot end]
        } else {
            set name $fun
            set arg_list ""
        }
        # see if in vTcl(proc_list).
        set fun [vTcl:python_delete_lambda $name]
        if {[lsearch -exact $vTcl(proc_list) $name] > -1} {continue}
        # see if we have already generated the function.
        if {[lsearch -exact $name_list $fun] > -1} {continue}
        if {[string first "self." $name] > -1} {
            continue         ;# NEEDS WORK Monday 4/26/21
            # class method skip in support module
            if {$gen == "import"} continue
            # Remove leading "self."
            set cfun [string range $fun 5 end]
            if {[lsearch -exact $vTcl(variable_parms) $fun]  > -1} {
                # We want a variable parameter list
                set parms "(*args)"
            } else {
                set parms [prepare_parameter_list $arg_list "class"]
            }
            append vTcl(class_functions) \
                "
$vTcl(tab)def $cfun$parms:
$vTcl(tab)$vTcl(tab)$vTcl(tab)print('self.$cfun')
$vTcl(tab)$vTcl(tab)$vTcl(tab)sys.stdout.flush()
"
        } elseif { [string first "." $name] > -1} {
            # Name refers to an imported module.
            continue
            set spot [string first "." $name]
            set mod [string range $name 0 $spot]
            set ifun [string range $name [expr $spot + 1] end]
            # set parms [prepare_parameter_list $arg_list "global"]
            set parms "(*args)"
            if {$gen == ""} {
                append vTcl(functions) \
                    "
def $ifun$parms:
$vTcl(tab)$vTcl(tab)print('$fun')
$vTcl(tab)$vTcl(tab)sys.stdout.flush()
"
            }
        } else {
            if {$gen == "gui"} continue
            # It's a global function.
            set mod $vTcl(import_name).
            # if {[lsearch -exact $vTcl(variable_parms) $fun]  > -1} {
            #     set parms "(*args)"
            # } else {
            #     set parms [prepare_parameter_list $arg_list "global"]
            # }
            set parms "(*args)"
            set eventParm "(event)";

            append vTcl(functions) \
                "
def $fun$parms:
    if _debug:
        print('$mod$fun')
        for arg in args:
            print ('\tanother arg:', arg)
        sys.stdout.flush()
"
            set mod ""
        }
        lappend name_list $fun
    }
}

proc vTcl:create_validation_functions {} {
    # Generate functions for the entry validation. This is a feature
    # that is very poorly documented and so this may have problems.
    global vTcl
    set vTcl(functions) ""
    if {! [info exists vTcl(validate_function_list)]} {
        # Empty list
        return
    }
    set mod $vTcl(import_name).
    set parms "(*args)"
    foreach fun [lsort -unique $vTcl(validate_function_list)] {
        regsub {\(.*\)} $fun "" f_name  ;# Ignore arguments
        append vTcl(functions) \
            "
def $f_name$parms:
    if _debug:
        print('$mod$f_name')
        for arg in args:
            print ('\tanother arg:', arg)
        sys.stdout.flush()
        return True
"
    }
}

proc vTcl:validation_parameters {} {
    global vTcl
}

proc split_long_font_string {str} {
    global vTcl
    if {[lsearch $vTcl(standard_fonts) $str] > -1} {
        return "$str\n"
    }
    set font_stmt $str
    set len [string length $font_stmt]
    if {$len <= 70} {
        return "$str\n"
    }
    set brk [string wordstart $font_stmt 70]
    set pre_char [string index $font_stmt [expr $brk - 1]]
    if {$pre_char == "-"} {
        set brk [expr $brk - 1]
    }
    set part1 [string range $font_stmt 0 [expr $brk - 1]]
    set part2 [string range $font_stmt [expr $brk] end]
    set ret "$part1\""
    if {$part2 != ""} {
        append ret " \ \\\n$vTcl(tab2)$vTcl(tab)\"$part2\n"
    }
    return $ret
}

proc color_value {color} {
    if {[string first "#" $color] > -1} {
        return $color
    } else {
        return [::colorDlg::colorToPoundRgb $color]
    }
}

proc color_comment {color} {
    if {[string first "#" $color] > -1} {
        lassign [FindClosestNamedColor $color] name dist
        if {$dist == 0} {
            return "# X11 color: '$name'"
        } else {
            return "# Closest X11 color: '$name'"
        }
    } else {
        return "# X11 color: [::colorDlg::colorToHex $color]"
    }
}

proc check_default_font {font} {
    # Determine if font is one of the standard fonts, if so just
    # return the font name in quotes.  Oct 2013
    global vTcl
    if {$font in $vTcl(standard_fonts)} {
        return "\"$font\""
    } elseif {"-family" in $font} {
        return "\"$font\""
    } else {
        lappend vTcl(fonts_used) $font
        return $font
    }
}

proc vTcl:get_top_level_colors_fonts {} {
    # First put out the color definitions and fonts.
    global vTcl
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_bgcolor = '$vTcl(actual_gui_bg)' \
                       [color_comment $vTcl(actual_gui_bg)]\n"
    #"$vTcl(tab2)_bgcolor = '$vTcl(bgcolor)'\n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_fgcolor = '$vTcl(actual_gui_fg)' \
                       [color_comment $vTcl(actual_gui_fg)]\n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_bgmode = '$vTcl(bg_mode)' \n"
return	

    vTcl:comp_color        ;# Puts out stmt for complement color.
    vTcl:analog_colors     ;# Puts out stmts for analog colors.
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_tabfg1 = '$vTcl(tabfg1)' \n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_tabfg2 = '$vTcl(tabfg2)' \n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_tabbg1 = '$vTcl(tabbg1)' \n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_tabbg2 = '$vTcl(tabbg2)' \n"
    append vTcl(toplevel_config) \
        "$vTcl(tab2)_bgmode = '$vTcl(bg_mode)' \n"
    # Put out the fonts actually used.
    vTcl:fonts_actually_used
}


proc vTcl:get_global_colors {} {
    # First put out the color definitions and fonts.
    global vTcl
	if {$vTcl(current_theme) eq "page-legacy"} {
    append ret \
        "\n_bgcolor = '$vTcl(actual_gui_bg)' \
                       [color_comment $vTcl(actual_gui_bg)]\n"
    #"_bgcolor = '$vTcl(bgcolor)'\n"
	append ret \
        "_fgcolor = '$vTcl(actual_gui_fg)' \
                       [color_comment $vTcl(actual_gui_fg)]\n"
	} else {
		append ret \
			"\n_bgcolor = \'[ttk::style lookup . -background]\'"
		append ret \
			"\n_fgcolor = \'[ttk::style lookup . -foreground]\'\n"
	}
    append ret \
        "_tabfg1 = '$vTcl(tabfg1)' \n"
    append ret \
        "_tabfg2 = '$vTcl(tabfg2)' \n"
    append ret \
        "_bgmode = '$vTcl(bg_mode)' \n"
    append ret \
        "_tabbg1 = '$vTcl(tabbg1)' \n"
    append ret \
        "_tabbg2 = '$vTcl(tabbg2)' \n"
return $ret

    append ret [vTcl:comp_color]        ;# Puts out stmt for complement color.
    append ret [vTcl:analog_colors]     ;# Puts out stmts for analog colors.
    append ret \
        "_tabfg1 = '$vTcl(tabfg1)' \n"
    append ret \
        "_tabfg2 = '$vTcl(tabfg2)' \n"
    append ret \
        "_tabbg1 = '$vTcl(tabbg1)' \n"
    append ret \
        "_tabbg2 = '$vTcl(tabbg2)' \n"
    append ret \
        "_bgmode = '$vTcl(bg_mode)' \n"
    # Put out the fonts actually used.
    # vTcl:fonts_actually_used
    return $ret
}

proc vTcl:fonts_actually_used {{selfie ""}} {
    # Put out the fonts actually used.
return	
    global vTcl
    set putout []
    set f_used [lsort -unique $vTcl(fonts_used)]
    foreach f [lsort -unique $vTcl(fonts_used)] {
        # if {[string range $f 0 1] == "Tk" || $f == ""} {}
        if {$f in $vTcl(standard_fonts) || $f == ""} {
            # If f is a default font then do nothing.
            continue
        }
        if {[catch {
            set font_cfg [font configure $f]}]} {
            # font configure failed.
            set font_cfg "TkDefaultFont"
        }
        #set font_string [vTcl:python_menu_font $font_cfg]
        # if {$popup_fonts == 0} {
        #     append vTcl(toplevel_config) \
        #         [split_long_font_string "$vTcl(tab2)self.$f = \"$font_cfg\""]
        #          #"$vTcl(tab2)$f = $font_string\n"
        #     lappend putout $f
        # } else {
        #     append vTcl(toplevel_config) \
            #         [split_long_font_string "$vTcl(tab2)$f = \"$font_cfg\""]
        #     lappend putout $f
        #}
        set font_cfg [vTcl:condense_font_description $font_cfg]
        append vTcl(toplevel_config) \
            [split_long_font_string "$vTcl(tab2)$selfie$f = \"$font_cfg\""]
        #"$vTcl(tab2)$f = $font_string\n"
        lappend putout $f
    }
}

;# NEEDS WORK Hoping that this will replace the above function.
# proc vTcl:fonts_actually_used {{selfie ""}} { }
proc vTcl:get_global_fonts {{selfie ""}} {
    # Put out the fonts actually used at the global level.
return	
    global vTcl
    set ret ""
    set putout []
    set f_used [lsort -unique $vTcl(fonts_used)]
    foreach f [lsort -unique $vTcl(fonts_used)] {
        # if {[string range $f 0 1] == "Tk" || $f == ""} {}
        if {$f in $vTcl(standard_fonts) || $f == ""} {
            # If f is a default font then do nothing.
            continue
        }
        if {[catch {
            set font_cfg [font configure $f]}]} {
            # font configure failed.
            set font_cfg "TkDefaultFont"
        }
        #set font_string [vTcl:python_menu_font $font_cfg]
        # if {$popup_fonts == 0} {
        #     append vTcl(toplevel_nfig) \
        #         [split_long_font_string "$vTcl(tab2)self.$f = \"$font_cfg\""]
        #          #"$vTcl(tab2)$f = $font_string\n"
        #     lappend putout $f
        # } else {
        #     append vTcl(toplevel_config) \
            #         [split_long_font_string "$vTcl(tab2)$f = \"$font_cfg\""]
        #     lappend putout $f
        #}
        set font_cfg [vTcl:condense_font_description $font_cfg]
        append ret \
            [split_long_font_string "$selfie$f = \"$font_cfg\""]
            # [split_long_font_string "$vTcl(tab2)$selfie$f = \"$font_cfg\""]
        #"$vTcl(tab2)$f = $font_string\n"
        lappend putout $f
    }
    return $ret
}

proc vTcl:style_function { } {
    # generates the style function that goes out just after the color
    # statements if required
    global vTcl
    if {!$vTcl(global_using_ttk)} { return } ;# No ttk widgets, no function.
	set theme_name [ttk::style theme use]
	# set vTcl(condensed_font) [vTcl:condense_font_description $vTcl(pr,gui_font_dft)]
	set vTcl(condensed_font) [vTcl:condense_font_description $vTcl(actual_gui_font_dft_desc)]
    set ret \
"
_style_code_ran = 0
def _style_code():
    global _style_code_ran
    if _style_code_ran: return"
	if {$vTcl(current_theme) eq "page-legacy"} {
		append ret \
"
    $vTcl(import_name).root.tk.eval('set ::xframe $vTcl(actual_gui_bg)')
    $vTcl(import_name).root.tk.eval('set ::xfore $vTcl(actual_gui_fg)')
    $vTcl(import_name).root.tk.eval('set ::ana2color $vTcl(analog_color_m)')
    $vTcl(import_name).root.tk.eval('set ::_tabfg1 $vTcl(tabfg1)')
    $vTcl(import_name).root.tk.eval('set ::_tabfg2 $vTcl(tabfg2)')
    $vTcl(import_name).root.tk.eval('set ::_tabbg1 $vTcl(tabbg1)')
    $vTcl(import_name).root.tk.eval('set ::_tabbg2 $vTcl(tabbg2)')
    $vTcl(import_name).root.tk.eval('set ::_bgmode $vTcl(bg_mode)')"
	}
	append ret \
"		
    try: $vTcl(import_name).root.tk.call('source',
                os.path.join(_location, 'themes', '$theme_name.tcl'))
    except: pass
    style = ttk.Style()
    style.theme_use('$theme_name')
    style.configure('.', font = \"$vTcl(condensed_font)\")
"
	if {$vTcl(current_theme) eq "page-legacy"} {
		append ret \
"    $vTcl(import_name).root.tk_setPalette(
            foreground = '$vTcl(actual_gui_fg)',
            background = '$vTcl(actual_gui_bg)',
			activeForeground = 'black',
            activeBackground = '#d9d9d9',
            selectForeground = 'black',
            selectBackground =  '#d9d9d9')
"
    }	
	if {$theme_name eq "default"} {
		append ret \
"    if sys.platform == \"win32\":
       style.theme_use('winnative')	
"
    }
# 	append ret \
# "    '''
#     style.configure('.',background=_bgcolor)
#     style.configure('.',foreground=_fgcolor)
#     style.configure('.',font='$vTcl(actual_gui_font_dft_desc)')
#     style.map('.',background =
#        \[('selected', _compcolor), ('active',_ana2color)\])
#     if _bgmode == 'dark':
#        style.map('.',foreground =
#          \[('selected', 'white'), ('active','white')\])
#     else:
#        style.map('.',foreground =
#          \[('selected', 'black'), ('active','black')\])
#     '''
# "
    ;# NEEDS WORK put in the extra style coding.
    foreach ttk_class $vTcl(ttk_classes_found) {
        append ret [vTcl:style_code $ttk_class]
    }
    append ret "$vTcl(tab)_style_code_ran = 1\n"
    return $ret
}

proc vTcl:emit_style_code { } {
    global vTcl
    if {$vTcl(style_code_emitted)} { return }
    set ret "$vTcl(tab2)_style_code()\n"
    set vTcl(style_code_emitted) 1
    return $ret
}

proc vTcl:get_top_level_configuration {window} {
    # Get configure information for the top level window.
    global vTcl
    set vTcl(toplevel_config) ""
    # Get the color and font information
    #vTcl:get_top_level_colors_fonts

    if {[::colorDlg::dark_color $vTcl(complement_color)]} {
        set comp_fg "white"
    } else {

        set comp_fg "black"
    }
    if {$vTcl(using_ttk)} {
        #append vTcl(toplevel_config) \
            "$vTcl(tab2)_style_code()\n"
        set vTcl(global_using_ttk) 1
    }
    # Set the geometry of the top level.
    append vTcl(toplevel_config) \
        "$vTcl(geometry)\n"
    # Set the title for the top level
    append vTcl(toplevel_config) \
        "$vTcl(tab2)top.title(\"$vTcl(py_title)\")\n"
    # Obtain a list of all attributes of the top level window.
    set opt [$window configure]
    # Above returns a list of lists. The values are:
    #              argvName,  dbName,  dbClass,  defValue, and current value
    foreach op $opt {
        foreach {o x y d v} $op {}
        set v [string trim $v]
        if {$d == $v} continue   ;# If value == default value bail.
        set len [string length $o]
        set sub [string range $o 1 end]
        switch -exact -- $sub {
            padX -
            padY -
            dropdown -
            editable -
            orient -
            fancy {
            }
            menu {
            }
            background {
                #append vTcl(toplevel_config) \
                            #    "$vTcl(tab2)master.configure($sub=_bgcolor)\n"
                append vTcl(toplevel_config) \
                    "$vTcl(tab2)top.configure($sub=\"$v\")\n"

            }
            default {
                append vTcl(toplevel_config) \
                    "$vTcl(tab2)top.configure($sub=\"$v\")\n"
            }
        }
    }
    # Include top bindings
    append vTcl(toplevel_config) \
        "$vTcl(bind_top)\n"
}

# No longer called since version 7.
# proc prepare_parameter_list {arg_list type} {
#     # Auto gen the parameter list.  We can't just use the parameter
#     # given in the command clause because they may be constants. This
#     # function returns a string.
#     if {[string length $arg_list] == 0} { # Rozen change 2 into 0
#         if {$type == "class"} {
#             return "(self)"
#         } else {
#             return "()"
#         }
#     }
#     set args "("            ;# Open the parenthesized list.
#     if {$type == "class"} {
#         append args "self,"
#     }
#     set argl [split $arg_list "(,)"]  ;# Get a list of the arguments
#     set zlist [lrange $argl 1 end-1]  ;# Throw out the "(" and ")" list elements
#     set c 1
#     foreach z $zlist {
#         append args p$c ","
#         incr c
#     }
#     set args [string range $args 0 end-1]  ;# Get rid of last ","
#     append args ")"                        ;# Close the parenthesized list.
#     return $args
# }

proc create_pnotebook_helper {} {
    global vTcl
    set pnotebook_helper \
        "
# The following code is add to handle mouse events with the close icons
# in PNotebooks widgets.
def _button_press(event):
$vTcl(tab)widget = event.widget
$vTcl(tab)element = widget.identify(event.x, event.y)
$vTcl(tab)if \"close\" in element:
$vTcl(tab)$vTcl(tab)index = widget.index(\"@%d,%d\" % (event.x, event.y))
$vTcl(tab)$vTcl(tab)widget.state(\['pressed'\])
$vTcl(tab)$vTcl(tab)widget._active = index

def _button_release(event):
$vTcl(tab)widget = event.widget
$vTcl(tab)if not widget.instate(\['pressed'\]):
$vTcl(tab)$vTcl(tab)$vTcl(tab)return
$vTcl(tab)element = widget.identify(event.x, event.y)
$vTcl(tab)try:
$vTcl(tab)$vTcl(tab)index = widget.index(\"@%d,%d\" % (event.x, event.y))
$vTcl(tab)except tk.TclError:
$vTcl(tab)$vTcl(tab)pass
$vTcl(tab)if \"close\" in element and widget._active == index:
$vTcl(tab)$vTcl(tab)widget.forget(index)
$vTcl(tab)$vTcl(tab)widget.event_generate(\"<<NotebookTabClosed>>\")

$vTcl(tab)widget.state(\['!pressed'\])
$vTcl(tab)widget._active = None

def _mouse_over(event):
$vTcl(tab)widget = event.widget
$vTcl(tab)element = widget.identify(event.x, event.y)
$vTcl(tab)if \"close\" in element:
$vTcl(tab)$vTcl(tab)widget.state(\['alternate'\])
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)widget.state(\['!alternate'\])
"
}

proc create_ttk_helper {} {
    global vTcl
    set ttk_helper \
        "
# The following code is added to facilitate the Scrolled widgets you specified.
class AutoScroll(object):
$vTcl(tab)'''Configure the scrollbars for a widget.'''
$vTcl(tab)def __init__(self, master):
$vTcl(tab)$vTcl(tab)#  Rozen. Added the try-except clauses so that this class
$vTcl(tab)$vTcl(tab)#  could be used for scrolled entry widget for which vertical
$vTcl(tab)$vTcl(tab)#  scrolling is not supported. 5/7/14.
$vTcl(tab)$vTcl(tab)try:
$vTcl(tab)$vTcl(tab)$vTcl(tab)vsb = ttk.Scrollbar(master, orient='vertical', command=self.yview)
$vTcl(tab)$vTcl(tab)except:
$vTcl(tab)$vTcl(tab)$vTcl(tab)pass
$vTcl(tab)$vTcl(tab)hsb = ttk.Scrollbar(master, orient='horizontal', command=self.xview)
$vTcl(tab)$vTcl(tab)try:
$vTcl(tab)$vTcl(tab)$vTcl(tab)self.configure(yscrollcommand=self._autoscroll(vsb))
$vTcl(tab)$vTcl(tab)except:
$vTcl(tab)$vTcl(tab)$vTcl(tab)pass
$vTcl(tab)$vTcl(tab)self.configure(xscrollcommand=self._autoscroll(hsb))
$vTcl(tab)$vTcl(tab)self.grid(column=0, row=0, sticky='nsew')
$vTcl(tab)$vTcl(tab)try:
$vTcl(tab)$vTcl(tab)$vTcl(tab)vsb.grid(column=1, row=0, sticky='ns')
$vTcl(tab)$vTcl(tab)except:
$vTcl(tab)$vTcl(tab)$vTcl(tab)pass
$vTcl(tab)$vTcl(tab)hsb.grid(column=0, row=1, sticky='ew')
$vTcl(tab)$vTcl(tab)master.grid_columnconfigure(0, weight=1)
$vTcl(tab)$vTcl(tab)master.grid_rowconfigure(0, weight=1)
$vTcl(tab)$vTcl(tab)# Copy geometry methods of master  (taken from ScrolledText.py)
$vTcl(tab)$vTcl(tab)methods = tk.Pack.__dict__.keys() | tk.Grid.__dict__.keys() \\
$vTcl(tab)$vTcl(tab)$vTcl(tab)$vTcl(tab)  | tk.Place.__dict__.keys()
$vTcl(tab)$vTcl(tab)for meth in methods:
$vTcl(tab)$vTcl(tab)$vTcl(tab)if meth\[0\] != '_' and meth not in ('config', 'configure'):
$vTcl(tab)$vTcl(tab)$vTcl(tab)$vTcl(tab)setattr(self, meth, getattr(master, meth))

$vTcl(tab)@staticmethod
$vTcl(tab)def _autoscroll(sbar):
$vTcl(tab)$vTcl(tab)'''Hide and show scrollbar as needed.'''
$vTcl(tab)$vTcl(tab)def wrapped(first, last):
$vTcl(tab)$vTcl(tab)$vTcl(tab)first, last = float(first), float(last)
$vTcl(tab)$vTcl(tab)$vTcl(tab)if first <= 0 and last >= 1:
$vTcl(tab)$vTcl(tab)$vTcl(tab)$vTcl(tab)sbar.grid_remove()
$vTcl(tab)$vTcl(tab)$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)$vTcl(tab)$vTcl(tab)sbar.grid()
$vTcl(tab)$vTcl(tab)$vTcl(tab)sbar.set(first, last)
$vTcl(tab)$vTcl(tab)return wrapped

$vTcl(tab)def __str__(self):
$vTcl(tab)$vTcl(tab)return str(self.master)

def _create_container(func):
$vTcl(tab)'''Creates a ttk Frame with a given master, and use this new frame to
$vTcl(tab)place the scrollbars and the widget.'''
$vTcl(tab)def wrapped(cls, master, **kw):
$vTcl(tab)$vTcl(tab)container = ttk.Frame(master)
$vTcl(tab2)container.bind('<Enter>', lambda e: _bound_to_mousewheel(e, container))
$vTcl(tab2)container.bind('<Leave>', lambda e: _unbound_to_mousewheel(e, container))
$vTcl(tab)$vTcl(tab)return func(cls, container, **kw)
$vTcl(tab)return wrapped"
    if {[lsearch $vTcl(helper_list) Scrolledtext] > -1} {
        append ttk_helper \
"

class ScrolledText(AutoScroll, tk.Text):
$vTcl(tab)'''A standard Tkinter Text widget with scrollbars that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Text.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
     }
     if {[lsearch $vTcl(helper_list) Scrolledlistbox] > -1} {
     append ttk_helper \
"

class ScrolledListBox(AutoScroll, tk.Listbox):
$vTcl(tab)'''A standard Tkinter Listbox widget with scrollbars that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Listbox.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)
$vTcl(tab)def size_(self):
$vTcl(tab)$vTcl(tab)sz = tk.Listbox.size(self)
$vTcl(tab)$vTcl(tab)return sz"
    }
    if {[lsearch $vTcl(helper_list) Scrolledentry] > -1} {
        append ttk_helper \
"

class ScrolledEntry(AutoScroll, tk.Entry):
$vTcl(tab)'''A standard Tkinter Entry widget with a horizontal scrollbar
$vTcl(tab)that will automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Entry.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    if {[lsearch $vTcl(helper_list) Scrolledspinbox] > -1} {
        append ttk_helper \
"

class ScrolledSpinbox(AutoScroll, tk.Spinbox):
$vTcl(tab)'''A standard Tkinter Spinbox widget with a horizontal scrollbar
$vTcl(tab)that will automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Spinbox.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    if {[lsearch $vTcl(helper_list) Scrolledcombo] > -1} {
        append ttk_helper \
"

class ScrolledCombo(AutoScroll, ttk.Combobox):
$vTcl(tab)'''A ttk Combobox with a horizontal scrollbar that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)ttk.Combobox.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    if {[lsearch $vTcl(helper_list) Scrolledcanvas] > -1} {
        append ttk_helper \
"

class ScrolledCanvas(AutoScroll, tk.Canvas):
$vTcl(tab)'''A standard Tkinter Canvas widget with scrollbars that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Canvas.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    if {[lsearch $vTcl(helper_list) Scrolledwindow] > -1} {
        append ttk_helper \
"

class ScrolledWindow(AutoScroll, tk.Canvas):
$vTcl(tab)'''A standard Tkinter Canvas widget with scrollbars that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)tk.Canvas.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    if {[lsearch $vTcl(helper_list) Scrolledtreeview] > -1} {
        append ttk_helper \
"

class ScrolledTreeView(AutoScroll, ttk.Treeview):
$vTcl(tab)'''A standard ttk Treeview widget with scrollbars that will
$vTcl(tab)automatically show/hide as needed.'''
$vTcl(tab)@_create_container
$vTcl(tab)def __init__(self, master, **kw):
$vTcl(tab)$vTcl(tab)ttk.Treeview.__init__(self, master, **kw)
$vTcl(tab)$vTcl(tab)AutoScroll.__init__(self, master)"
    }
    append ttk_helper \
"

import platform
def _bound_to_mousewheel(event, widget):
$vTcl(tab)child = widget.winfo_children()\[0\]
$vTcl(tab)if platform.system() == 'Windows' or platform.system() == 'Darwin':
$vTcl(tab)$vTcl(tab)child.bind_all('<MouseWheel>', lambda e: _on_mousewheel(e, child))
$vTcl(tab)$vTcl(tab)child.bind_all('<Shift-MouseWheel>', lambda e: _on_shiftmouse(e, child))
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)child.bind_all('<Button-4>', lambda e: _on_mousewheel(e, child))
$vTcl(tab)$vTcl(tab)child.bind_all('<Button-5>', lambda e: _on_mousewheel(e, child))
$vTcl(tab)$vTcl(tab)child.bind_all('<Shift-Button-4>', lambda e: _on_shiftmouse(e, child))
$vTcl(tab)$vTcl(tab)child.bind_all('<Shift-Button-5>', lambda e: _on_shiftmouse(e, child))

def _unbound_to_mousewheel(event, widget):
$vTcl(tab)if platform.system() == 'Windows' or platform.system() == 'Darwin':
$vTcl(tab)$vTcl(tab)widget.unbind_all('<MouseWheel>')
$vTcl(tab)$vTcl(tab)widget.unbind_all('<Shift-MouseWheel>')
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)widget.unbind_all('<Button-4>')
$vTcl(tab)$vTcl(tab)widget.unbind_all('<Button-5>')
$vTcl(tab)$vTcl(tab)widget.unbind_all('<Shift-Button-4>')
$vTcl(tab)$vTcl(tab)widget.unbind_all('<Shift-Button-5>')

def _on_mousewheel(event, widget):
$vTcl(tab)if platform.system() == 'Windows':
$vTcl(tab)$vTcl(tab)widget.yview_scroll(-1*int(event.delta/120),'units')
$vTcl(tab)elif platform.system() == 'Darwin':
$vTcl(tab)$vTcl(tab)widget.yview_scroll(-1*int(event.delta),'units')
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)if event.num == 4:
$vTcl(tab)$vTcl(tab)$vTcl(tab)widget.yview_scroll(-1, 'units')
$vTcl(tab)$vTcl(tab)elif event.num == 5:
$vTcl(tab)$vTcl(tab)$vTcl(tab)widget.yview_scroll(1, 'units')

def _on_shiftmouse(event, widget):
$vTcl(tab)if platform.system() == 'Windows':
$vTcl(tab)$vTcl(tab)widget.xview_scroll(-1*int(event.delta/120), 'units')
$vTcl(tab)elif platform.system() == 'Darwin':
$vTcl(tab)$vTcl(tab)widget.xview_scroll(-1*int(event.delta), 'units')
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)if event.num == 4:
$vTcl(tab)$vTcl(tab)$vTcl(tab)widget.xview_scroll(-1, 'units')
$vTcl(tab)$vTcl(tab)elif event.num == 5:
$vTcl(tab)$vTcl(tab)$vTcl(tab)widget.xview_scroll(1, 'units')"

    return $ttk_helper
}
#"
proc vTcl:py_build_set_Tk_var {var_list {new yes}} {
    # Build the function which will initialize the Tkinter variables.
    # A lot of code trying to get the blank lines in the right
    # place. Still confused.
    global vTcl
    if {$new == "yes"} {
        append ret \
            "def set_Tk_var():\n"
    }
    set vars {}
    foreach {v m} $var_list {
        # If the variable contains '::' then I want to remove the '::'.
        regsub "::" $v "" v
        set vv $v
        set m ${vTcl(tk_prefix)}$m
        set i [string first . $v]
        if {$i > -1} {
            set v [string range $v  [expr $i + 1] end]
        }
        if {[lsearch -exact $vars $v] == -1} {
            if {[info exists vTcl($v,add_smileyface)] &&
                $vTcl($v,add_smileyface) != 0} {
                set extra "\n$vTcl(tab)$v.set('$vTcl($v,add_smileyface)')"
                # if {$new eq "yes"} {
                #     append extra "\n"
                # }
            } else {

                set extra ""
            }
            append ret \
                "$vTcl(tab)global $v
$vTcl(tab)$v = ${m}()${extra}\n"
            lappend vars $v
        }
    }
    #append ret "$vTcl(tab)return"
    return $ret
}


proc vTcl:colorize_python {prefix} {
    global vTcl
    vTcl:syntax_color $vTcl(${prefix}_source_window)
}

proc vTcl:save_python_code {prefix} {
    global vTcl
    # We come here when the user hits the save button on the Python
    # Console. From here we either save the GUI module or the support
    # module depending on the value of vTcl(python_module) which was
    # set in either vTcl:generate_python_UI or
    # vTcl:generate_python_support. I also save the tcl file to be
    # sure that the tcl version and the gui code is in sync on the
    # disk.
    if {$prefix == "supp"  &&  \
            $vTcl(supp_save_warning)  != ""} {
        vTcl:save_support_file
    }
    if {$prefix == "gui"    &&   \
            $vTcl(gui_save_warning)  != ""} {

        vTcl:save
        vTcl:save_gui_file
    }
    $vTcl(${prefix}_source_window) edit modified 0
    update
    set vTcl(${prefix}_save_warning) ""
    set vTcl(${prefix}_search_pattern) ""
}

proc vTcl:save_gui_file {} {
    global vTcl
    # First we make a backup copy of any existing Python file popping
    # it onto a stack of backup files and then we write the new
    # version.  This saves up to five versions.

    # If the module most recently generated is the support module, it
    # was saved as part of the generation so there is nothing to do
    # here.
    #    if {$vTcl(python_module) == "Support"} return
    if {$vTcl(project,file) == ""} {
        vTcl:save
    }
    set filename "[file rootname $vTcl(project,file)].py"
    vTcl:save_python_file $filename "gui"
    return 0
}

proc vTcl:py_source_frame {window prefix parentframe} {
    global vTcl
    # Starting entry for analyzing and creating the window.
    set class [winfo class $window]
    if {$class == "Toplevel"} {
        set menu [$window cget -menu]
        set vTcl(toplevel_menu) $menu
        set vTcl(bind_top) [vTcl:python_dump_bind $window $vTcl(py_classname)]
    }
    if {$prefix!=""} {
        set prefix $prefix\_
    }
    set vTcl(balloon_widgets) ""
    foreach widget [winfo children $window] { # Rozen
        #vTcl:python_source_widget $widget $prefix $parentframe
        if {[string first "#" $widget] == -1} {
        if {[string first ".pop" $widget] > -1} {
			vTcl:python_generate_context_menu $widget
            continue
        }
            vTcl:python_source_widget $widget $prefix $window
        }
    }
}

proc vTcl:py_get_command_parameters {cmdpar} {
    # Confusing. Rozen
    global vTcl
    upvar cmdname lname
    upvar cmdbody lbody
    set lname {}
    set lbody {}
    catch {
        set lname $cmdpar
        if {$lname!=""} {
            foreach line [split $lname "\n"] {
                set line [string trim $line]
                if {[info procs $lname]!=""} {
                    set lbody [info body $lname]
                }
            }
        }
    }

}

proc vTcl:python_parse_menu {menubutton widname {suffix m}} {
    global vTcl
    foreach widget [winfo children $menubutton] {
        if {[winfo class $widget]=="Menu"} {
            set nritems [$widget index end]
            for {set i 0} {$i<=$nritems} {incr i} {
                switch [$widget type $i] {
                    command {
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname==""} {
                            set cmdname "$widname\_$i\_click"
                        }
                        append vTcl(py_initfunc) \
                            "$vTcl(tab2)self.$widname\_m$suffix.add_command(label="
                        append vTcl(py_initfunc) \
                            "\"[$widget entrycget $i -label]\","
                        # added to add the accelerator capability.
                        if {[$widget entrycget $i -accel] != ""} {
                            append vTcl(py_initfunc) \
                                "accel=\"[$widget entrycget $i -accel]\","
                        }
                        append vTcl(py_initfunc) \
                            "command=$cmdname,underline=0)\n"
                        set v $cmdname
                        if {[string first "(" $v] == -1} {
                            append v "()"
                        }
                        lappend vTcl(funct_list) $v
                    }
                    checkbutton { # Like to put in more options
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname == ""} {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_checkbutton(label=\"[$widget entrycget $i -label]\""
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    "accel=\"[$widget entrycget $i -accel]\""
                            }
                        } else {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_checkbutton(label=\"[$widget entrycget $i -label]\",command=$cmdname"
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }
                        }
                        append vTcl(py_initfunc) ")\n"
                    }
                    radiobutton { # Like to put in more options
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname == ""} {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_radiobutton(label=\"[$widget entrycget $i -label]\""
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }
                        } else {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_radiobutton(label=\"[$widget entrycget $i -label]\",command=$cmdname"
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }                        }
                        append vTcl(py_initfunc) ")\n"
                    }
                    separator {
                        append vTcl(py_initfunc)  \
                            "$vTcl(tab2)self.$widname\_m$suffix.add_separator()\n"
                    }
                    cascade {
                        set incsuffix ""
                        append incsuffix "m$suffix" "_cas$suffix"
                        append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_$incsuffix = "
                        append vTcl(py_initfunc) \
                                "Menu(self.$widname\_m$suffix)\n"
                        append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_cascade(label=\"[$widget entrycget $i -label]\","
                        if {[$widget entrycget $i -accel] != ""} {
                            append vTcl(py_initfunc) \
                                    "accel=\"[$widget entrycget $i -accel]\","
                        }
                        append vTcl(py_initfunc) \
                                "menu=self.$widname\_$incsuffix)\n"
                        set arg_suffix ""
                        append arg_suffix $suffix "_cas$suffix"
                        vTcl:python_parse_menu $widget $widname \
                                $arg_suffix
                    }
                }
            }
        }
    }
}

proc vTcl:python_parse_combo_menu {menubutton widname} {
    global vTcl
    global suffix
    foreach widget [winfo children $menubutton] {
        set suffix [expr $suffix + 1]
        if {[winfo class $widget]=="Menu"} {
            set nritems [$widget index last]
            for {set i 0} {$i<=$nritems} {incr i} {
                set suffix [expr $suffix + 1]
                if {[$widget type $i]=="command"} {
                    vTcl:py_get_command_parameters \
                        [$widget entrycget $i -command]
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)self.$widname\.add_command(\"z_$suffix\",label="
                    append vTcl(py_initfunc) \
                        "\"[$widget entrycget $i -label]\","
                    append vTcl(py_initfunc) \
                        "underline=0)\n"
                }
                if {[$widget type $i]=="separator"} {

                    append vTcl(py_initfunc) \
                        "$vTcl(tab)$vTcl(tab)self."
                    append vTcl(py_initfunc) \
                        "$widname\.add_separator(\"z_$suffix\")\n"
                }
            }
        }
    }
}

proc vTcl:python_quick_run {base prefix} {
    global vTcl
    global tcl_platform
    #    set run [vTcl:run_prep $prefix]
    if {[vTcl:run_prep $prefix] == "OK"} {
        switch $tcl_platform(platform) {
            unix {
                vTcl:python_run_unix $base $prefix
            }
            default {
                vTcl:python_run $base $prefix
            }
        }
    }
}

proc vTcl:run_prep {prefix {save "save"}} {
    # Introduced 12/21/15
    # Save the current content of source window then test if we have
    # both GUI and support modules saved and then execute the GUI
    # module.
    global vTcl global tcl_platform
    update
    vTcl:save_python_code $prefix ;# This will also save the tcl file
                                   # if appropriate.
    update
    # Be sure python command is specified, otherwise specify 'python'.
    if {$vTcl(python_cmd) == ""} {set vTcl(python_cmd) "3"}
    # Test to see that we have both a GUI module and a support module!
    set fg "[file rootname $vTcl(project,file)].py"
    set fs "[file rootname $vTcl(project,file)]_support.py"
    #set fg "\"[file rootname $vTcl(project,file)].py\""
    #set fs "\"[file rootname $vTcl(project,file)]_support.py\""
    set nogui [expr ![file exists $fg]]
    set nosupp [expr ![file exists $fs]]

    if {$nogui == 1} {
        set choice [tk_messageBox -title Error -message \
                               "No GUI module has been created and saved." \
                               -icon warning \
                               -type ok]
        #set choice [tk_dialog .foo "ERROR" \
                        "No GUI module has been created and saved." \
                        question 0 "OK"]
        return "BAIL"
    }
    if {$nosupp == 1} {
        set choice [::vTcl::MessageBox -title Error -message \
                             "No support module has been created and saved." \
                             -icon warning \
                             -type ok]
        #set choice [tk_dialog .foo "ERROR" \
                        "No support module has been created and saved." \
                        question 0 "OK"]
        return "BAIL"
    }
    # Test to see if the GUI python module has been generated after
    # the latest GUI change.
    if {$vTcl(gui_py_change_time) < $vTcl(gui_change_time)} {
        set question "GUI definition has been changed since GUI module created. Do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                        question 0 "Cancel" "Proceed"]
        if {$choice == 0} {
            return "BAIL"
        }
    }
    # Test to see if support module needs updates.
    set window $vTcl(real_top)
    set vTcl(popup_found) 0     ;# NEEDS WORK popup
    vTcl:determine_updates
    if {$vTcl(update_necessary)} {
        # There are possible updates.
        set question "Support module missing available updates. Do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                        question 0 "Cancel" "Proceed"]
        if {$choice == 0} {
            return "BAIL"
        }
    }
    # Everything OK
    return "OK"
}

proc vTcl:python_run {base prefix} {
    # This is the function to run on Windows.
    global vTcl
    global tcl_platform
    set root_name [file rootname $vTcl(project,file)]
    set pc .vTcl.gui_console
    set pc $base
    set pc_output $vTcl(gui_output_window)
    $pc_output delete 1.0 end
    $pc_output insert end "Running $root_name.py using $vTcl(pr,python_cmd) ...\n"
    update
    if {[file exists $root_name.output]} {
        file delete $root_name.output
    }
    if { [catch {set res \
    "[exec $vTcl(pr,python_cmd) $root_name.py >>& $root_name.output]"} result]} {
        puts stderr $result
    }
    #catch {set res \
        #    "[exec python $root_name.py >>& $root_name.output]"}
    if {[file exists $root_name.output] && \
            [file size $root_name.output] > 0} {
        set fid [open $root_name.output r]
        while {![eof $fid]} {
            gets $fid line
            $pc_output insert end "$line\n"
        }
        close $fid
    } else {
        $pc_output insert end "No Output"
    }
    update
}

proc vTcl:python_run_unix {base prefix} {
    global tcl_platform
    # Executes the generated GUI code by opening a pipe to a python
    # process which executes the saved generated python GUI code.
    global vTcl
    set pc $base
    set pc_output $vTcl(${prefix}_output_window)
    $pc_output delete 1.0 end
    set root_name [file rootname $vTcl(project,file)]
    $pc_output insert end \
        "Running $root_name.py using $vTcl(pr,python_cmd) ...\n"
    update
    #set cmd "python $root_name.py 2>&1"
    set cmd "$vTcl(pr,python_cmd) \"$root_name.py\""
    # Start the pipe, vTcl(fifo), to the python interpreter
    # running the GUI
    set vTcl(fifo) [open "|$cmd |& cat" {RDWR}]
    # Configure buffering and blocking of the pipe
    fconfigure $vTcl(fifo) -buffering line -blocking 0
    # Link files events, such as close and flush, to the proc
    # vTcl:read_fifo.
    if {$prefix == "gui"} {
        fileevent $vTcl(fifo) readable {vTcl:read_fifo "gui"}
    } else {
        fileevent $vTcl(fifo) readable {vTcl:read_fifo "supp"}
    }
}

proc vTcl:python_run_both {pcommand} {
    global tcl_platform
    # Executes the generated GUI code by opening a pipe to a python
    # process which executes the saved generated python GUI code.
    # NEEDS WORK - doesn't look like I ever call this function.
    global vTcl
    set pc .vTcl.gui_console
    set pc_output $vTcl(gui_output_window)
    $pc_output delete 1.0 end
    set root_name [file rootname $vTcl(project,file)]
    $pc_output insert end "Running $root_name.py using $vTcl(python_cmd) ...\n"
    update
    #set cmd "python $root_name.py 2>&1"
    set cmd "vTcl(pr,python_cmd) $root_name.py"
    # Start the pipe, vTcl(fifo), to the python interpreter process
    # running the GUI
    set vTcl(fifo) [open "|$cmd |& $pcommand" {RDWR}]
    # Configure buffering and blocking of the pipe
    fconfigure $vTcl(fifo) -buffering line -blocking 0
    # Link files events, such as close and flush, to the proc
    # vTcl:read_fifo.
    fileevent $vTcl(fifo) readable vTcl:read_fifo
}

proc vTcl:read_fifo {prefix} {
    # Reads the output of the execution pipe whenever a file event
    # such as close or buffer flush occurs. Mated with
    # vTcl:python_run. It adds the line read to output window of the
    # gui_console.
    global vTcl
    set pc_output $vTcl(${prefix}_output_window)
    if {[gets $vTcl(fifo) line] >= 0} {
        $pc_output insert end "$line\n"
    }
    if {[eof $vTcl(fifo)]} {
        close $vTcl(fifo)
        $pc_output insert end "Execution terminated.\n"
    }
    $pc_output see end ;# Last line visible
    update
}

proc vTcl:check_upon_close_button {base prefix} {
    # We check to see if we are closing the Python Console containing a
    # modified support module
    global vTcl
    set exists [winfo exists $vTcl(${prefix}_code_window)]
    if {!$exists} return
    if {$vTcl(${prefix}_save_warning) != ""} {
        set reply [tk_dialog .foo "Save Question" \
                       "Do you wish to save the content of the Console" \
                       question 1 "Save" "Abandon"]
        switch $reply {
            0 {
                vTcl:save_python_code $prefix
            }
            1 {
                # Abandon
            }
        }
    }
    Window hide $base
    update
    return
}

proc vTcl:search_text {prefix} {
    # searches the Python console, the one determined by 'prefix', for
    # the string specified by the variable, 'search_pattern', treated
    # as a regexp. Highlight the string found.
    global vTcl
    switch $prefix {
        callback {
            set source_window $::vTcl(gui,callback).cpd21.03
            set bg plum
        }
        default {
            set source_window $vTcl(${prefix}_source_window)
            set bg yellow
        }
    }
    #set source_window $vTcl(${prefix}_source_window)
    set patt $vTcl(${prefix}_search_pattern)
    if {$patt == ""} {
        # No pattern given.
        return
    }
    $source_window tag remove highlight 1.0 end ;# Remove existing highlight.
    # The "-count cnt" below is the number of characters matched.
    set index [$source_window search -regexp -count cnt $patt insert]
    if {$index != ""} {
        if {$prefix == "callback"} {
            # This cause the search to set selection to the matched string.
            $source_window tag add sel $index "$index+${cnt}c"
        } else {
            $source_window mark set insert "$index+${cnt}c"
            $source_window see $index
            $source_window tag add highlight $index insert
            $source_window tag configure highlight -background $bg
        }
    } ;# end if
}
proc vTcl:text_top {prefix} {
    global vTcl
    switch $prefix {
        callback -
        tree {
            set source_window $::vTcl(gui,$prefix).cpd21.03
        }
        default {
            set source_window $vTcl(${prefix}_source_window)
        }
    }
    $source_window mark set insert 1.0
    $source_window see insert
}



proc vTcl:Window.py_console {type} {
    # Builds the  Python Console
    global vTcl
    set prefix $type
    set base .vTcl.${prefix}_console
    if {[winfo exists $base]} {
        wm deiconify $base; raise $base
        return
    }
    set top $base
    set vTcl(${prefix}_save_warning) ""
    ###################
    # CREATING WIDGETS
    ###################
    vTcl:toplevel $top -class Toplevel \
        -background $vTcl(actual_bg) ;# 11/22/12
    wm focusmodel $top passive
    wm withdraw $base
    #wm transient $base .vTcl
    set maxs [wm maxsize .]
    foreach {maxx maxy} $maxs {}
    set start_h [expr $maxy - (50*4)]

    wm geometry $top 800x$start_h+100+50; update
    #wm maxsize $top 1905 1170
    wm maxsize $top $maxx $maxy
    wm minsize $top 1 1
    wm overrideredirect $top 0
    wm resizable $top 1 1
    wm deiconify $top
    if {$prefix == "gui"} {
        set window_name "GUI"
    } else {
        set window_name "Support"
    }
    wm title $top "$window_name Console"
    vTcl:DefineAlias "$top" "Toplevel1" vTcl:Toolorplevel:WidgetProc "" 1
    bindtags $top "$top Toplevel all _TopLevel"
    vTcl:FireEvent $top <<Create>>
    wm protocol $top WM_DELETE_WINDOW "vTcl:FireEvent $top <<DeleteWindow>>"

	panedwindow $top.tPa42 -orient vertical -showhandle 1 \
	                       -handlesize 10
	
    labelframe $top.tPa42.f1 \
        -text {Generated Python} -font TkDefaultFont \
		-background $vTcl(pr,bgcolor) -foreground $vTcl(pr,fgcolor) 

    $top.tPa42 add $top.tPa42.f1

    labelframe $top.tPa42.f2 \
        -text {Execution Output} -font TkDefaultFont \
		-background $vTcl(pr,bgcolor) -foreground $vTcl(pr,fgcolor) 
		
    $top.tPa42 add $top.tPa42.f2 -minsize 100
	set top_size [winfo height $top]
	set code_size [expr $top_size - 100]
	$top.tPa42 paneconfigure $top.tPa42.f1 -height $code_size
	#$top.tPa42 paneconfigure $top.tPa42.f2  -stretch never
	
    # Code goes into this text widget.  ;# NEEDS WORK dark
    # text $top.tPa42.f1.01  -background #eff0f1 -foreground black
    text $top.tPa42.f1.01  -background $vTcl(area_bg) -foreground black \
        -xscrollcommand "$top.tPa42.f1.02 set"\
        -yscrollcommand "$top.tPa42.f1.03 set" \
		-font $vTcl(pr,gui_font_text) \
		-selectbackground blue -selectforeground white \
        -insertborderwidth 3 
	    # add to get user soecified font -font $vTcl(font,gui_font_dft)
    set text_window $top.tPa42.f1.01
    set vTcl(${prefix}_code_window) $top.tPa42.f1.01

	# To get a decent contrast between slider and trough in scrollbars
    if {[::colorDlg::dark_color $vTcl(pr,bgcolor)]} {
		set persent 140
	} else {
		set persent 60
	}
	set darkerBg [tk::Darken $vTcl(pr,bgcolor) $persent] ;# in palette.tcl
	
    scrollbar $top.tPa42.f1.02  -command "$top.tPa42.f1.01 xview" \
        -orient horizontal -background $vTcl(pr,bgcolor) \
		-troughcolor $darkerBg
	
    scrollbar $top.tPa42.f1.03  -command "$top.tPa42.f1.01 yview" \
		-background $vTcl(pr,bgcolor) -troughcolor $darkerBg
	
    grid $top.tPa42.f1.01  -in $top.tPa42.f1 -column 0 -row 0 -columnspan 1 \
        -rowspan 1 -sticky nesw
    # Since the text window has the attribute "wrap", it will never
    #need the horizontal scrollbar and so I commented out the
    #following line.
    #grid $top.tPa42.f1.02 -in $top.tPa42.f1 -column 0 -row 1 -columnspan 1 \
        -rowspan 1 -sticky ew
    grid $top.tPa42.f1.03  -in $top.tPa42.f1 -column 1 -row 0 -columnspan 1 \
        -rowspan 1 -sticky ns
    # Rozen Added row, column config stuff so that it would resize properly.
    grid rowconfigure $top.tPa42.f1 0 -weight 1
    grid columnconfigure $top.tPa42.f1 0 -weight 1

    # Bindings for the mousewheel.
    bind $top.tPa42.f1.01 <Button-4> [list %W yview scroll -5 units]
    bind $top.tPa42.f1.01 <Button-5> [list %W yview scroll 5 units]
    # Color below was white or #ececec ;# NEEDS WORK dark
    text $top.tPa42.f2.01  -background $vTcl(area_bg) -foreground black \
        -xscrollcommand "$top.tPa42.f2.02 set" \
        -yscrollcommand "$top.tPa42.f2.03 set" \
		-font $vTcl(pr,gui_font_text) 


    scrollbar $top.tPa42.f2.02  -command "$top.tPa42.f2.01 xview" \
        -orient horizontal -background $vTcl(pr,bgcolor) \
		-troughcolor $darkerBg

    scrollbar $top.tPa42.f2.03  -command "$top.tPa42.f2.01 yview" \
		-background $vTcl(pr,bgcolor) -troughcolor $darkerBg

    grid $top.tPa42.f2.01  -in  $top.tPa42.f2 -column 0 -row 0 -columnspan 1 \
        -rowspan 1 -sticky nesw
    grid $top.tPa42.f2.02  -in $top.tPa42.f2 -column 0 -row 1 -columnspan 1 \
        -rowspan 1 -sticky ew
    grid $top.tPa42.f2.03  -in $top.tPa42.f2 -column 1 -row 0 -columnspan 1 \
        -rowspan 1 -sticky ns
    # Rozen Added row, column config stuff so that it would resize properly.
    grid rowconfigure $top.tPa42.f2 0 -weight 1
    grid columnconfigure $top.tPa42.f2 0 -weight 1

    # Bindings for the mousewheel.  Both of the following approaches work.
    bind $top.tPa42.f2.01 <Button-4> [list %W yview scroll -5 units]
    bind $top.tPa42.f2.01 <Button-5> [list %W yview scroll 5 units]

    frame $top.butframe  -height 40 -background $vTcl(pr,bgcolor) \
	
    # -----------------
    # Save button
    button $top.butframe.but33 \
        -text Save -command "vTcl:save_python_code $prefix" \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		-activeforeground black -activebackground #d9d9d9	
		#-font $vTcl(pr,font_dft)
		
    # save label
    label $top.butframe.lab14 \
        -textvariable vTcl(${prefix}_save_warning) \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		
    # Run button
    button  $top.butframe.but34 \
        -text Run -command "vTcl:python_quick_run $base $prefix" \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		-activeforeground black -activebackground #d9d9d9	
	    #-background $vTcl(actual_bg) -foreground $vTcl(actual_fg)

    # Search entry
    vTcl:entry $top.butframe.ent14 \
        -textvariable vTcl(${prefix}_search_pattern) \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) 

	# Search button
    button $top.butframe.but36 \
        -text Search \
        -command "vTcl:search_text $prefix" \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		-activeforeground black -activebackground #d9d9d9	

	# Top button/
    button $top.butframe.but37 \
        -text Top \
        -command "vTcl:text_top $prefix" \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		-activeforeground black -activebackground #d9d9d9	

    # Close button
    button  $top.butframe.but35 \
        -text Close -command "vTcl:check_upon_close_button $base $prefix" \
		-foreground $vTcl(pr,fgcolor) -background $vTcl(pr,bgcolor) \
		-activeforeground black -activebackground #d9d9d9	

    place $top.butframe.but33 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.02 -y 5

    # save label
    place $top.butframe.lab14 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.13 -y 8

    place $top.butframe.but34 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.34 -y 5   ;# Run button
    # !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
    place $top.butframe.ent14 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.45 -y 8

    place $top.butframe.but36 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.70 -y 5

    place $top.butframe.but37 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.80 -y 5
    # !!!!!!!!!!!!!!!!!!!!!!!!!!!
    place $top.butframe.but35 \
        -in $top.butframe  -anchor nw -bordermode ignore \
        -relx 0.88 -y 5
    ####################
    # SETTING GEOMETRY #
    ####################

    # Added 6/9/09
    grid $top.tPa42 -in $top -column 0 -row 0 -sticky news
	
	grid $top.butframe -in $top -column 0 -row 1 -sticky news
    grid rowconfigure $top 0 -weight 1
    grid columnconfigure $top 0 -weight 1

    # 6/9/09
    #pack $top.tPa42 -in $top -expand true -fill both -side top
    #pack $top.butframe -in $top  -fill x -side bottom
    # The purpose of the following is to overwrite the geometry stuff
    # above with the geometry which has been saved in the preferences.
    catch {wm geometry $base \
               $vTcl(geometry,$base)}
    set old_geometry [wm geometry $base]
    set old_height [split $old_geometry "x+"]
    set old_height [lindex $old_height 1]
    set vTcl(old_height) old_height
    # The following if-the-else needed because the second parameter is
    # a script which is not exercised until the event occures at which
    # point the local variable prefix does not exist. Don't know what
    # else to do! 1/9/16
    update
    if {$prefix == "gui"} {
       bind $base <Configure> {
            #set new_geometry [wm geometry .vTcl.gui_console]
            #set new_height [split $new_geometry "x+-"]
            #set new_height [lindex $new_height 1]
            set new_height [winfo height .vTcl.gui_console]
            if {$new_height != $vTcl(old_height)} {
                #set pos [expr int($new_height * 0.8)]
				#set pos [min $pos [expr int($new_height) - 150]]
				#set new_height [winfo height .vTcl.gui_console]
				set pos [expr int($new_height) - 150]
				.vTcl.gui_console.tPa42 paneconfigure \
					.vTcl.gui_console.tPa42.f1 -height $pos
                #.vTcl.gui_console.tPa42 sashpos 0 $pos
            }
            set vTcl(old_height) $new_height
        }		
        bind $top.butframe.ent14 <Return> {vTcl:search_text "gui"}
    } else {
        bind $base <Configure> {
            #set new_geometry [wm geometry .vTcl.supp_console]
            #set new_height [split $new_geometry "x+-"]
            #set new_height [lindex $new_height 1]
            set new_height [winfo height .vTcl.supp_console]
            if {$new_height != $vTcl(old_height)} {
                #set pos [expr int($new_height * 0.8)]
                #set pos [min $pos [expr int($new_height) - 150]]
				set pos [expr int($new_height) - 150]
				.vTcl.supp_console.tPa42 paneconfigure \
					.vTcl.supp_console.tPa42.f1 -height $pos
                #.vTcl.supp_console.tPa42 sashpos 0 $pos
            }
            set vTcl(old_height) $new_height
        }
        bind $top.butframe.ent14 <Return> {vTcl:search_text "supp"}
    }

    focus $top.butframe.but34     ;# Rozen 10/20/12
    update idletasks

    # if {[info exists vTcl(${prefix}_sash)]} {
    #     #$top.tPa42 sashpos 0 [expr int($vTcl(${prefix}_sash))]
    # } else {
    #     set size [wm geometry $top]
    #     set size [split $size "x+-"] ;# minus cause window geometry
    #     # might be to far right
    #     set pos [lindex $size 1]
    #     set pos [expr int($pos * 0.8)]
    #     #$top.tPa42 sashpos 0 $pos
    # }

    vTcl:FireEvent $base <<Ready>>

    bind $base <Control-q> {vTcl:quit}
    ;# Rozen 3/31/14
    bind $base <Control-p> {vTcl:generate_python_UI}
    bind $base <Control-u> {vTcl:generate_python_support}
    bind $base <Control-i> {vTcl:load_python_idle}

    if {$prefix == "gui"} {
        bind $base <Control-r> {vTcl:python_quick_run .vTcl.gui_console "gui"}
        bind $base <Control-w> {vTcl:check_upon_close_button \
                                    .vTcl.gui_console "gui"}
		# bind .vTcl.gui_console <<ThemeChanged>>  \
		# 	".vTcl.gui_console.tPa42.f1.01 configure -foreground black 
        #      .vTcl.gui_console.tPa42.f2.01 configure -foreground black "
    } else {
        bind $base <Control-r> {vTcl:python_quick_run .vTcl.supp_console "supp"}
        bind $base <Control-w> {vTcl:check_upon_close_button \
                                    .vTcl.supp_console "supp"}
		# bind .vTcl.supp_console <<ThemeChanged>>  \
		# 	".vTcl.supp_console.tPa42.f1.01 configure -foreground black 
		# 	 .vTcl.supp_console.tPa42.f2.01 configure -foreground black "
    }
    # save label
    if {$prefix == "gui"} {
        bind $vTcl(gui_code_window) <<Modified>> {
            set vTcl(gui_save_warning) "Unsaved changes"
        }
    } else {
        bind $vTcl(supp_code_window) <<Modified>> {
            set vTcl(supp_save_warning) "Unsaved changes"
        }
    }
    # When you enter the console window raise it to the top.
    bind $base <Enter> "raise $base"
    set vTcl(${prefix}_source_window)   $top.tPa42.f1.01
    set vTcl(${prefix}_output_window)   $top.tPa42.f2.01
} ;# End vTcl:Window.vTcl.py_console




proc  vTcl:build_treeview_support {target widname cmdname widclass} {
    # This routine rounds out the support of the scrolledtreeview by
    # creating columns, and assigning them characteristics.
    global vTcl
    append vTcl(py_initfunc) \
        "$vTcl(tab2)# build_treeview_support starting.\n"

    set cols [$target cget -columns]
    set column_names [concat "#0" $cols]
    foreach c $column_names {
        set heading($c) [$target heading $c]
        set column($c) [$target column $c]
    }
    foreach c $column_names {
        foreach {o v} $heading($c) {
            if {$v == ""} continue
            if {[string range $o 0 0] == "-"} {
                set sub [string range $o 1 end]
            }
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.heading(\"$c\",$sub=\"$v\")\n"
        }
        foreach {o v} $column($c) {
            if {$v == ""} continue
            if {$o == "-id"} continue
            if {[string range $o 0 0] == "-"} {
                set sub [string range $o 1 end]
            }
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.column(\"$c\",$sub=\"$v\")\n"
        }
    }
}

proc vTcl:gen_file_desc {block} {
    # I use this to transform something like "\{DajaVue Sans\} 9 bold" into
    # "-family {DajaVue Sans} -size 9 -weight bold".

    # We need to split the block up into words but cannot use
    # list operations as they throw away some significant
    # quoting, and [split] ignores braces as it should.
    while {[string length $block]} {
        # Look for the next word containing a quote: { }
        if {[regexp {[^ ]*(\{.*\})(.*)} $block match word rest]} {
            set block [string trim $rest]
            lappend words $word
        } else {
            # Take everything up to the end of the block ans split it.
            lappend words {*}[split $block]
            set block {}
        }
    }
    return $words
}

proc vTcl:transform_font_variable {v} {
    # NEEDS WORK May not neet the following two tests.
    # Fonts added by PAGE have the form font[0-9]*
    if {[regexp "font\[0-9\]*" $v]} {
        return $v
    }
    # System fonts have the form Tk[a-zA-Z]*Font, we need to quote it.
    if {[regexp "Tk\[a-zA-Z\]*Font" $v]} {
        return $v
    }
    set words [vTcl:gen_file_desc $v]
    set params {-family -size -weight -slant -underline -overstrike}
    set parm_index 0
    set desc ""
    foreach word $words {
        append desc [lindex $params $parm_index] " " $word " "
        incr parm_index
    }
    set desc [string trim $desc]
    return $desc
}

proc vTcl:prepend_import_name {cmd_exp {widname ""}} {
    global vTcl
    if {[string first "self." $cmd_exp] == 0} {
        # Found initial "self." Assuming that this is a method of the
        # parent object like destroy method of a toplevel.
        return $cmd_exp
    }

    set first_period [string first "." $cmd_exp]
    set paren [string first "(" $cmd_exp]
    if {$first_period > -1 && $paren > -1 && $first_period < $paren} {
        # String already is qualified with a module name, possibly "self".
        return $cmd_exp
    }

    # I assume that the $cmd_exp has already been trimmed.
    if {$widname == ""} {
        set sub_name $vTcl(import_name)

    } else {
        set sub_name $widname
    }
    if {[string first "lambda" $cmd_exp] == 0} {
        # Extract the non lambda part of the function name
        set index [string first ":" $cmd_exp]
        set exp [expr $index + 1]
        # r will be the non lambda part
        set r [string range $cmd_exp [expr $index + 1] end]
        set r [string trim $r]
        #set new_cmd [string replace $cmd_exp $exp $exp $vTcl(import_name).]
        set new_cmd [string replace $cmd_exp $exp end $sub_name.$r]
    } else {
        set new_cmd $sub_name.$cmd_exp
    }
    return $new_cmd
}
proc vTcl:python_configure_widget {widget widname cmdname \
                                       widclass {name ""} {menu_name ""}} {
    global vTcl
    global color
    # Obtains a list of all attributes of the widget, checks to see if
    # the current value differs from the default value.  If it does, then
    # puts adds the configuration statement for that value.
    set opt [$widget configure]
	set active_fg_there 0
    foreach op $opt {
        foreach {o x y d v} $op {}
        set v [string trim $v]
        if {$o == "-activeforeground"} {
            set active_fg_there 1
        }

    }
    # Above returns a list of lists. The values are:
    #              argvName,  dbName,  dbClass,  defValue, and current value
    if {$name == ""} {\
                          set name "self.$widname"
    }
    set class [vTcl:get_class $widget]
    foreach op $opt {
        foreach {o x y d v} $op {}
        set v [string trim $v]
        if {$o == "-class"} { continue }
        if {$o == "-variable"} {
			set var_name $v
            switch $class {
                Radiobutton {
                    # Want to output the value even if it is the default.
                }
                TRadiobutton {
                    # Must get rid of the '::' because it is not a
                    # valid Python identifier.
                    if {$v == "::selectedButton"} {
                        set v "selectedButton"
                    }
                }
                default {
                    # In other cases don't output default case.
                    if {$d == $v} {
                        continue   ;# value == default value bail.
                    }
                }
            }
        } else {
            if {$d == $v} {
                continue   ;# If value == default value bail.
            }
        }
        set len [string length $o]
        set sub [string range $o 1 end]
		switch -exact -- $sub {
            padX -
            padY -
            dropdown -
            editable -
            height -
            fancy {
            }
            xscrollcommand -
            yscrollcommand {

                # There is a question here whether I really want
                # to support separate scrollbars.  I think that now
                # the answer is no.

            }
            textvariable {
                if {[string first "self." $v] == 0} {
					if {[lsearch -exact $vTcl(l_v_list) $v] == -1} {
                        # Class variable.
                        append vTcl(py_initfunc) \
                            "$vTcl(tab2)$v = StringVar()\n"
                        lappend vTcl(l_v_list) $v
                        set local_var 1
                    }
                } else {
                    # Global variable
                    set local_var 0
                    # if {[lsearch -exact $vTcl(g_v_list) $v] == -1} {
                    #     set vTcl(global_variable) 1
                    #     lappend vTcl(g_v_list) $v StringVar
                    # }
                    if {[lsearch -exact $vTcl(t_v_list) $v] == -1} {
                        set vTcl(global_variable) 1
                        regsub {^::vTcl::} $v "" v
                        regsub {^::} $v "" v
						set test_list \
                            [list Entry TEntry TCombobox Menubutton TMenubutton]
                        if {[lsearch -exact $test_list $widclass] > -1} {
                            # lappend vTcl(t_v_list) $v StringVar ""
                            lappend vTcl(t_v_list) $v StringVar $widclass
							#lappend vTcl(t_v_list) $v StringVar \
                                "[$widget cget -text]"
                        } elseif {$widclass eq "Spinbox" ||
                                  $widclass eq "TSpinbox"} {
                            lappend vTcl(t_v_list) $v StringVar \
                                "[$widget cget -from]"
                        } else {
                            # widclass in [Entry TEntry TCombobox]
                            lappend vTcl(t_v_list) $v StringVar ""
                        }
                    }
                }

                append vTcl(py_initfunc) \
                      "$vTcl(tab2)self.$widname.configure($sub=self.$v)\n"
                set l [$widget cget -text]
                # if {$widclass ni {Entry Spinbox TEntry TCombobox}} {
                #     append vTcl(py_initfunc) \
                #         "$vTcl(tab2)self.$v.set(\'\'\'$l\'\'\')\n"
                # }
                #lappend  vTcl(g_v_list) $v $m  CHECK This OUT!! What is $m.
            }
            listvariable -
            variable {				
				if {[string bytelength $v] == 0} {
                    vTcl:error "No variable specified for $widget"
                }
                if {[string first :: $v] != -1} {
                    vTcl:error "Illegal variable $v specified in $widget"
                }
                # First some code to see if class or global variable
                # is wanted, I will tell by checking if 'self.' is
                # part of the name.
                if {[string first self. $v] == 0} {
                    # Class variable.
                    if {[lsearch -exact $vTcl(l_v_list) $v] == -1} {
                        switch $widclass {
                            "Scrolledlistbox" -
                            "Checkbutton" -
                            "TCheckbutton" -
                            "Radiobutton" -
                            "TRadiobutton" {
                                append v \
                                "$vTcl(tab2)$v = StringVar()\n"
                            }
                            "TScale" -
                            "Scale" {
                                append vTcl(py_initfunc) \
                                    "$vTcl(tab2)$v = DoubleVar()\n"
                                set var_name $v
                            }
                            "TProgressbar" {
                                append vTcl(py_initfunc) \
                                    "$vTcl(tab2)$v = IntVar()\n"
                            }
                        }
                        lappend vTcl(l_v_list) $v
                    }
                    #} elseif {[string first . $v] >= 0} {
                    #    # Variable in imported module
                    #    set vTcl(supp_variables) 1
                } else {
                    # Global variable
                    if {[lsearch -exact $vTcl(g_v_list) $v] == -1} {
                        set vTcl(global_variable) 1
                        switch $widclass {
                            "Scrolledlistbox" -
                            "Listbox" {
                                set m StringVar
                            }
                            "TScale" -
                            "Scale" {
                                set m DoubleVar
                            }
                            "Checkbutton" -
                            "Radiobutton" -
                            "TCheckbutton" -
                            "TRadiobutton" -
                            "TProgressbar" {
                                set m IntVar
                            }
                        }
                        #set l [list $v $m]
                        #lappend vTcl(g_v_list) $l
                        lappend vTcl(g_v_list) $v $m
                    }
                }
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname.configure($sub=self.$v)\n"
            }
            validatecommand -
            invalidcommand {
                # The value, v, looks like 'vcmd %P ...' and that has
                # to be rewritten to be 'vcmd, "%P" ...' with all the
                # arguments containing '%' quoted.
                # First pull out the function name.
                regexp {\w+} $v vfunct
                set vv [vTcl:prepend_import_name $vfunct]
                # Surround '%parameters' with "'".
                regsub -all {(%[diPsSvVW])} $v {'\1'} v
                #set pieces [split $v]
                set pieces [regexp -all -inline {\S+} $v]
                set v [join $pieces ", "]
                # Parenthesize v
                set v ($v)
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$vfunct = self.$widname.register($vv)\n"
                lappend vTcl(validate_function_list) $vfunct
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=$v)\n"
            }
            postcommand -
            command {
                if {[string first xview $v] > -1} {
                    set blank_index [string first " " $v]
                    set nm [string range $v 1 [expr $blank_index-1]]
                    set nm_wid [vTcl:widget_2_widname $nm]
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=self.$nm_wid.xview)\n"
                } elseif {[string first yview $v] > -1} {
                    set blank_index [string first " " $v]
                    set nm [string range $v 1 [expr $blank_index-1]]
                    set nm_wid [vTcl:widget_2_widname $nm]
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=self.$nm_wid.yview)\n"
                } else {
                    set vv $v
                    #if {[string first "(" $vv] == -1} {
                    # If we don't have any parameters make an
                    # empty parameter list.
                    #NEEDS WORK Check to see if we need the next command
                    #append vv "()"
                    #}
                    set v [vTcl:add_lambda $v] ;# Check to see if lambda needed.
                    set v [vTcl:prepend_import_name $v]
                    lappend vTcl(funct_list) $vv
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=$v)\n"
                }
            }
            opencmd -
            closecmd -
            browsecmd {
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=$v)\n"
            }
            menu {
                #set menu $v
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=$menu_name)\n"
            }
            selectimage -
            image {
                # NEEDS WORK Consolidate (use  vTcl:python_create_image)
                set file_name $vTcl(imagefile,$v)
                set image_ext [file extension $file_name]
                # Try for relative path.
                set to_name [vTcl:set_to_name]
                # set file_name [vTcl:relTo $file_name [pwd]]
                set file_name [vTcl:relTo $file_name $to_name]
                # set image_name self._img$vTcl(image_count)
                set image_name _img$vTcl(image_count)
                append vTcl(py_initfunc) \
       "$vTcl(tab2)photo_location = os.path.join(_location,\"$file_name\")\n"

                append vTcl(py_initfunc) \
                    "$vTcl(tab2)global $image_name\n"
                switch $image_ext {
                    .png -
                    .gif -
                    .pgm {
                        append vTcl(py_initfunc) \
            "$vTcl(tab2)$image_name = tk.PhotoImage(file=photo_location)\n"
                    } ;# end of standard image formats
                    default {
                        # Where we handle the other types of images
                        set vTcl(need_PIL) 1
                        append vTcl(py_initfunc) \
        "$vTcl(tab2)$image_name = ImageTk.PhotoImage(file=photo_location)\n"
                        incr vTcl(need_PIL)
                    }
                }
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=$image_name)\n"
                incr vTcl(image_count)
            }
            values {
                # Used by Spinbox and Combobox.
                set values_list {}
                append values_list "\["

                foreach value $v {
                    if {$value == ""} continue
                    append values_list "'" $value "',"
                }
                append values_list "\]"
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.value_list = $values_list\n"
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=self.value_list)\n"
            }
            font {
                set vv [vTcl:condense_font_description $v]
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=\"$vv\")\n"
            }
            #class {}
            #height -
            width {
                # I don't want to configure the widget with height and
                # width because in some cases values are interpreted
                # as character widths and in others in terms of
                # pixels.  Rather let us specify them in the call to
                # place where the values seem to be in units of
                # pixels.

                # It seem as though I do need this for Message
                # Widgets. 10/16/12
                if {$class == "Message"} {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=$v)\n"
                }
            }
            text {
                # I may have a problem with multiline text.
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=\'\'\'$v\'\'\')\n"
            }
            orient {
                if {$widclass != "TPanedwindow"} {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=\"$v\")\n"
                }
            }
            background {
                if {$v == $vTcl(bgcolor)} {
                    if {![info exists classes($class,ttkWidget)]} {
                        # The widget is not a ttkwidget
                        append vTcl(py_initfunc) \
                            "$vTcl(tab2)$name.configure($sub=\"$v\")\n"
                    }
                } else {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=\"$v\")\n"
                }
            }
            activebackground {
                set active_bg $v
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=\"$v\")\n"
                # if {$active_fg_there == 1 &&
                #     [::colorDlg::dark_color $active_bg]  == 1 } {
                #     append vTcl(py_initfunc) \
                #       "$vTcl(tab2)$name.configure(activeforeground=\"white\")\n"
                # }
            }
            align -
            anchor -
            state -
            selectmode -
            style -
            compound -
            justify {
                if {$widclass == "PNotebook" && $sub == "style"} {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub=PNOTEBOOK)\n"
                } else {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub='$v')\n"
                }
            }
            from -
            to -
            resolution {
                # This is where I would like to handle the two and
                # from attributes but there seems to be a problem with
                # the scale widgets which seems to require these
                # attributes at creation so I wanted to treat them all
                # the same.  So nothing doing here.
            }
            value {
                if {$widclass eq "TScale"} {
                    append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.${var_name}.set($v)\n"
                } else {
                    append vTcl(py_initfunc) \
                        "$vTcl(tab2)$name.configure($sub='$v')\n"
                }
            }
            default {
                if {$sub == "from"} {
                    set sub "from_"
                }
                if {[info exists color($v)]} {
                    if {$d == $color($v)} {
                        # The color name corresponds to the Hexadecimal
                        # default. So bail
                        continue
                    }
                }
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)$name.configure($sub=\"$v\")\n"
            }
        }
    }
    vTcl:python_configure_special_opts $widget $widname
}

proc vTcl:python_configure_special_opts {widget widname} {
    # If any widget has a non blank tooltip text option we turn on
    # vTcl(tooltip_helper) which will cause the Python tooltip code to
    # be generated and included in the output.
    global vTcl
    vTcl:WidgetVar $widget options
    if {![info exists options]} return
    if {[info exists options(-_tooltip)]} {
        set msg $options(-_tooltip)
        if {$msg != ""} {
            # I experimented with doing one line or two and decided
            # that two looked better.
            #set str \
      "$vTcl(tab2)ToolTip(self.$widname, \"$vTcl(actual_gui_font_tooltip_desc)\", '''$msg''', delay=0.5)\n"
            #set str [vTcl:split_line $str]
            #append vTcl(py_initfunc) $str
            #append vTcl(py_initfunc) \
       "$vTcl(tab2)self.tooltip_font = \"$vTcl(actual_gui_font_tooltip_desc)\"\n"
      append vTcl(py_initfunc) \
          "$vTcl(tab2)self.${widname}_tooltip = \\\n"
            #append vTcl(py_initfunc) \
            "$vTcl(tab2)ToolTip(self.$widname, self.tooltip_font, '''$msg''')\n"
            append vTcl(py_initfunc) \
            "$vTcl(tab2)ToolTip(self.$widname, '''$msg''')\n"
      incr vTcl(tooltip_helper)
        }
    }
}

proc vTcl:set_to_name {} {
    global argv
    set argv_1 [lrange $argv 0 0]
    set dir_part [file dirname $argv_1 ]
    set to_name [file join [pwd] $dir_part]
    return $to_name
}

proc vTcl:python_add_special_opt_to_optlist {option target} {
    global vTcl
    lappend vTcl(w,optlist) $option
    set vTcl(w,opt,$option) ""
    if {[info exists vTcl(w,opt,$option,$target)] != 0} {
        set vTcl(w,opt,$option) $vTcl(w,opt,$option,$target)
        if {[info exists vTcl(special_attributes)] == 0} {
            lappend vTcl(special_attributes) vTcl(w,opt,$option,$target)
        } else {
            if {[lsearch $vTcl(special_attributes) \
                     vTcl(w,opt,$option,$target)] == -1} {
                lappend vTcl(special_attributes) vTcl(w,opt,$option,$target)
            }
        }
    }
}

# Utility  Similar to vTcl:lib_tix:dump_subwidgets.
proc vTcl:python_source_subwidgets {subwidget parentframe} {
    global vTcl
    # set widget_tree [vTcl:widget_tree $subwidget]
    # The above nets me all of the widgets in the subtree.
    # Things appeared at two levels in NoteBook pages, for instance.
    # However, if a subwidget is a container widget, I
    # expect it to handle its own subwidgets.  Therefore,
    # I do not want this procedure to look inside a
    # container subwidget.  I think I will try the following:
    set widget_tree [vTcl:get_children $subwidget]
    foreach i $widget_tree {
        set basename [vTcl:base_name $i]
        # don't try to source subwidget itself
        if {"$i" != "$subwidget"} {
            set class [vTcl:get_class $i]
            #set pc [vTcl:get_class $parentframe]
            set pframe [ vTcl:widget_2_widname $subwidget] ;# New
            #vTcl:python_source_widget $i ""  $pframe
            vTcl:python_source_widget $i ""  $subwidget
        }
    }
    return
}

proc vTcl:split_line {str} {
    # An attempt to keep lines from wrapping, especially those with
    # relative placement.  If line is longer than max_l then back up
    # to last comma and see if it fits, etc.

    # Want to augment to split remaining long line at equal sign if
    # present.
    global vTcl
    set max_l 80
    set len [string length $str]
    if {$len <= $max_l} {
        return $str
    }
    if {[string first "\n" $str] > -1 } {
        set cr 1
    } else {
        set cr 0
    }
    set trim_str [string trimright $str]
    set pieces [split $trim_str ,]
    # Algorithm:
    # set chunk ""
    # while a chunk is left append chunk next piece.
    # If chunk shorter than max
    #   while another chunk will fit, add it.
    #   otherwise add the \n and add to output.
    #
    set ind 0
    set l_size [llength $pieces]
    set chunk ""
    while {$ind < $l_size} {
        if {$ind == 0} {
            append chunk [lindex $pieces $ind]
        } else {
            append chunk "," [lindex $pieces $ind]
        }
        incr ind
        while {$ind <= $l_size} {
            set l_chuck [string length $chunk]
            set l_next [string length [lindex $pieces $ind]]
            set t_len [expr $l_chuck + $l_next]
            if {$t_len > $max_l} {
                append output $chunk "\n"
                set chunk "$vTcl(tab2)$vTcl(tab2)"
                break
            } else {
                if {$ind == $l_size} {
                    append output $chunk
                } else {
                    #look at the space below.
                    append chunk ", " [string trim [lindex $pieces $ind]]
                }
                incr ind
            }
        }
    }
    if {$cr} {
        # add final newline, if needed.
        append output "\n"
    }
    return $output
}

proc vTcl:get_bmc {parent} {
    # Determines whether we need to include the bordermode option. It
    # appears we need it iff the parent is a labelframe.
    set parent_class [vTcl:get_class $parent]
    if {$parent_class == "Labelframe" ||$parent_class == "TLabelframe"} {
        set bmc ", bordermode='ignore'"
    } else {
        set bmc ""
    }
    return $bmc
}

proc vTcl:relative_placement {{parent {}}} {
    global vTcl
    global rel
    set bmc [vTcl:get_bmc $parent]
    if {$vTcl(actual_relative_placement)} {
        append str \
         "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely), "
        append str \
            "relheight=$rel(relh), relwidth=$rel(relw)$bmc)\n"
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y, "
        append str \
            "height=$rel(h), width=$rel(w)$bmc)\n"
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:entry_placement {{parent {}}} {
    # For entry widgets, I don't want to constrain the height so that
    # there will be room for scroll bars without eating into the
    # entry field itself.`
    global vTcl
    global rel
    set bmc [vTcl:get_bmc $parent]
    if {$vTcl(actual_relative_placement)} { ;# Most common case
        append str \
          "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely),"
        append str \
            " height=$rel(h), relwidth=$rel(relw)$bmc)\n"
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y, "
        append str \
            "height=$rel(h), width=$rel(w)$bmc)\n"
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:scale_placement {widget parent} {
    # For the placement of scales one wants relative placement and
    # relative widths for horizontal scales and relative height for
    # vertical ones.
    global vTcl
    global rel
    set parent_class [vTcl:get_class $parent]
    set bmc [vTcl:get_bmc $parent]
    if {$vTcl(actual_relative_placement)} { ;# Most common case
        set o [$widget cget -orient]
        append str \
         "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely), "
        if {$o == "horizontal"} {
            append str \
                "relwidth=$rel(relw), relheight=0.0, height=$rel(h),"
            append str "bordermode='ignore')\n"
        } else {
            append str \
                "relwidth=0.0, relheight=$rel(relh), width=$rel(w),"
            append str "bordermode='ignore')\n"
        }
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y,"
        append str " height=$rel(h), width=$rel(w)$bmc)\n"
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:separator_placement {widget parent} {
    # For the placement of scales one wants relative placement and
    # relative widths for horizontal scales and relative height for
    # vertical ones.
    global vTcl
    global rel
    set bmc [vTcl:get_bmc $parent]
    set o [$widget cget -orient]
    if {$vTcl(actual_relative_placement)} { ;# Most common case
        set parent_geometry [winfo geometry $parent]
        foreach {W H X Y} [split $parent_geometry "x+"] {}  ;# new 4/3/17
        append str \
         "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely), "
        if {$o == "horizontal"} {
            append str " relwidth=$rel(relw)$bmc)\n"
        } else {
            append str " relheight=$rel(relh)$bmc)\n"
        }
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y,"
        if {$o == "horizontal"} {
            set width [place configure $widget -width]
            set width [lrange $width end end]
            append str " width=$width$bmc)\n"
        } else {
            set height [place configure $widget -height]
            set height [lrange $height end end]
            append str " height=$height$bmc)\n"
        }
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]

}

proc vTcl:progressbar_placement {{parent {}}} {
    # For placement of progress bars on wants something like
    # horizontal scale_placement above.
    global vTcl
    global rel
    set bmc [vTcl:get_bmc $parent]
    if {$vTcl(actual_relative_placement)} { ;# Most common case
        append str \
         "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely), "
        append str  "relwidth=$rel(relw), relheight=0.0, height=$rel(h)$bmc)\n"
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y,"
        append str " width=$rel(w), height=$rel(h)$bmc)\n"
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:fixed_placement {} {
    global vTcl
    global rel
    append str \
        "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$rel(y), "
    append str " height=$rel(h), width=$rel(w)$bmc)\n"
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:relative_x_y {{parent {}}} {
    # Generates the place command for the widget based on whether or
    # not the relative flag is set. If set then the parameters relx,
    # rely, relwidth and relheight are set otherwise just x and
    # y. When I wrote this I expected to have a user option to turn it
    # on or off.  I have since decided not to make this an option.
    global vTcl
    global rel
    set bmc [vTcl:get_bmc $parent]
    if {$vTcl(actual_relative_placement)} { ;# Most common case
        append str \
         "$vTcl(tab2)self.$rel(widname).place(relx=$rel(relx), rely=$rel(rely),"
        append str " height=$rel(h), width=$rel(w)$bmc)\n"
    } else {
        set y $rel(y)
        append str \
            "$vTcl(tab2)self.$rel(widname).place(x=$rel(x), y=$y, "
        append str "height=$rel(h), width=$rel(w)$bmc)\n"
    }
    append vTcl(py_initfunc) [vTcl:split_line $str]
}

proc vTcl:comp_color {} {
    global vTcl
    if {![info exists style_code(compcolor)]} {
        # set comp $vTcl(pr,guicomplement_color)
        set comp $vTcl(complement_color)
        #append vTcl(toplevel_config) \
            #"$vTcl(tab2)_compcolor = '$comp' [color_comment $comp]\n"
        append ret \
            "_compcolor = '$comp' [color_comment $comp]\n" ;# NEEDS WORK code

        set style_code(compcolor) 1
    }
    return $ret
}

proc vTcl:analog_colors {} {
    global vTcl
    if {![info exists style_code(anacolors)]} {
        set ap $vTcl(analog_color_p)
        set am $vTcl(analog_color_m)
        # append vTcl(toplevel_config) \
        #     "$vTcl(tab2)_ana1color = '$ap' [color_comment $ap]\n"
        # append vTcl(toplevel_config) \
        #     "$vTcl(tab2)_ana2color = '$am' [color_comment $am]\n"
        append ret \
            "_ana1color = '$ap' [color_comment $ap]\n"
        append ret \
            "_ana2color = '$am' [color_comment $am]\n" ;# NEEDS WORK code
        set style_code(anacolors) 1
    }
    return $ret
}


;# NEEDS WORK The following is the new version working with vTcl:style_function.
;# NEEDS WORK code
proc vTcl:style_code {widclass} {
    global vTcl
    global style_code
    if {[info exists style_code($widclass)]} return
    if {[info exists style_code(Scrolled)] && \
         [string first "Scrolled" $widclass] > -1} return
    if {$widclass == "Text"} return
    set ret ""
# if {[string index $widclass 0] in {"S" "T"} || $widclass eq "PNotebook" ||
#     $widclass == "Heading" || $widclass == "Scrolledtreeview"} {
#         switch $widclass {
#             Heading {
#                 append ret \
#         "$vTcl(tab2)self.style.configure('$widclass', background=_compcolor)\n"
#             }
#             TSizegrip {
#                 #append ret \
#        "$vTcl(tab2)self.style.configure('$widclass', background=_bgcolor)\n"
#             }
#             TNotebook {
#                 append ret \
# "$vTcl(tab)style.map('TNotebook.Tab', background =
# $vTcl(tab2)$vTcl(tab)\[('selected', _bgcolor), ('active', _tabbg1),
# $vTcl(tab2)$vTcl(tab)('!active', _ana2color)\], foreground =
# $vTcl(tab2)$vTcl(tab)\[('selected', _fgcolor), ('active', _tabfg1), ('!active',  _tabfg2)\])\n"
#             }
#             Scrolledentry -
#             Scrolledlistbox -
#             Scrolledspinbox -
#             Scrolledwindow -
#             Scrolledtext {
#                 append ret \
# "$vTcl(tab)style.configure('Vertical.TScrollbar',  background=_bgcolor,
# $vTcl(tab2)arrowcolor= _fgcolor)
# $vTcl(tab)style.configure('Horizontal.TScrollbar',  background=_bgcolor,
# $vTcl(tab2)arrowcolor= _fgcolor)\n"
#                 set style_code(Scrolled) 1
#             }
#             Scrolledtreeview {
#                 append ret \
# "$vTcl(tab)style.configure('Vertical.TScrollbar',  background=_bgcolor,
# $vTcl(tab2)arrowcolor= _fgcolor)
# $vTcl(tab)style.configure('Horizontal.TScrollbar',  background=_bgcolor,
# $vTcl(tab2)arrowcolor= _fgcolor)\n"
#                 set style_code(Scrolled) 1
#                append ret \
#           "$vTcl(tab)style.configure('Treeview', \
#                font=[check_default_font $vTcl(actual_gui_font_treeview_name)])\n"
#             }
#             TCheckbutton -
#             TRadiobutton {
#                 append ret \
#          "$vTcl(tab)style.map('$widclass',background =
#            \[('selected', _bgcolor), ('active', _ana2color)\], indicatorcolor =
#            \[('selected', _fgcolor), ('!active', _bgcolor)\])\n"
#             }
#             PNotebook {
#                 append ret \
# "
# $vTcl(tab)global _images
# $vTcl(tab)_images = (
# $vTcl(tab2) tk.PhotoImage(\"img_close\", data='''R0lGODlhDAAMAIQUADIyMjc3Nzk5OT09PT
# $vTcl(tab2)$vTcl(tab2) 8/P0JCQkVFRU1NTU5OTlFRUVZWVmBgYGF hYWlpaXt7e6CgoLm5ucLCwszMzNbW
# $vTcl(tab2)$vTcl(tab2) 1v//////////////////////////////////// ///////////yH5BAEKAB8ALA
# $vTcl(tab2)$vTcl(tab2) AAAAAMAAwAAAUt4CeOZGmaA5mSyQCIwhCUSwEIxHHW+ fkxBgPiBDwshCWHQfc5
# $vTcl(tab2)$vTcl(tab2)  KkoNUtRHpYYAADs= '''),
# $vTcl(tab2) tk.PhotoImage(\"img_close_white\", data='''R0lGODlhDAAMAPQfAM3NzcjI
# $vTcl(tab2)$vTcl(tab2)yMbGxsLCwsDAwL29vbq6urKysrGxsa6urqmpqZ+fn56enpaWloSEhF9fX0ZGR
# $vTcl(tab2)$vTcl(tab2)j09PTMzMykpKQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP///yH
# $vTcl(tab2)$vTcl(tab2)5BAEKAB8ALAAAAAAMAAwAAAUt4CeOZGmaA5mSyQCIwhCUSwEIxHHW+fkxBgPi
# $vTcl(tab2)$vTcl(tab2)BDwshCWHQfc5KkoNUtRHpYYAADs='''),
# $vTcl(tab2) tk.PhotoImage(\"img_closeactive\", data='''R0lGODlhDAAMAIQcALwuEtIzFL46
# $vTcl(tab2)$vTcl(tab2) INY0Fdk2FsQ8IdhAI9pAIttCJNlKLtpLL9pMMMNTP cVTPdpZQOBbQd60rN+1rf
# $vTcl(tab2)$vTcl(tab2) Czp+zLxPbMxPLX0vHY0/fY0/rm4vvx8Pvy8fzy8P//////// ///////yH5BAEK
# $vTcl(tab2)$vTcl(tab2) AB8ALAAAAAAMAAwAAAVHYLQQZEkukWKuxEgg1EPCcilx24NcHGYWFhx P0zANBE
# $vTcl(tab2)$vTcl(tab2) GOhhFYGSocTsax2imDOdNtiez9JszjpEg4EAaA5jlNUEASLFICEgIAOw== '''),
# $vTcl(tab2) tk.PhotoImage(\"img_closepressed\", data='''R0lGODlhDAAMAIQeAJ8nD64qELE
# $vTcl(tab2)$vTcl(tab2) rELMsEqIyG6cyG7U1HLY2HrY3HrhBKrlCK6pGM7lD LKtHM7pKNL5MNtiViNaon
# $vTcl(tab2)$vTcl(tab)$vTcl(tab)  +GqoNSyq9WzrNyyqtuzq+O0que/t+bIwubJw+vJw+vTz+zT z////////yH5BAE
# $vTcl(tab2)$vTcl(tab2) KAB8ALAAAAAAMAAwAAAVJIMUMZEkylGKuwzgc0kPCcgl123NcHWYW Fs6Gp2mYB
# $vTcl(tab2)$vTcl(tab2) IRgR7MIrAwVDifjWO2WwZzpxkxyfKVCpImMGAeIgQDgVLMHikmCRUpMQgA7 ''')
# $vTcl(tab2))
# $vTcl(tab)if _bgmode == \"dark\":
# $vTcl(tab)$vTcl(tab)style.element_create(\"close\", \"image\", \"img_close_white\",
# $vTcl(tab)$vTcl(tab)   ('active', 'pressed',  'img_closepressed'),
# $vTcl(tab)$vTcl(tab)   ('active', 'alternate', 'img_closeactive'), border=8, sticky='')
# $vTcl(tab)else:
# $vTcl(tab)$vTcl(tab)style.element_create(\"close\", \"image\", \"img_close\",
# $vTcl(tab)$vTcl(tab)   ('active', 'pressed',  'img_closepressed'),
# $vTcl(tab)$vTcl(tab)   ('active', 'alternate', 'img_closeactive'), border=8, sticky='')

# $vTcl(tab)style.layout(\"ClosetabNotebook\", \[\(\"ClosetabNotebook.client\",
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab) \{\"sticky\": \"nswe\"\}\)\]\)
# $vTcl(tab)style.layout(\"ClosetabNotebook.Tab\", \[
# $vTcl(tab)$vTcl(tab)\(\"ClosetabNotebook.tab\",
# $vTcl(tab)$vTcl(tab)  \{ \"sticky\": \"nswe\",
# $vTcl(tab)$vTcl(tab2)\"children\": \[
# $vTcl(tab)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.padding\", \{
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"side\": \"top\",
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"sticky\": \"nswe\",
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"children\": \[
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.focus\", \{
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"side\": \"top\",
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"sticky\": \"nswe\",
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"children\": \[
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.label\", \{\"side\":
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)  \"left\", \"sticky\": ''\}\),
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.close\", \{\"side\":
# $vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"left\", \"sticky\": ''\}\),\]\}\)\]\}\)\]\}\)\]\)\n
# $vTcl(tab)style.map('ClosetabNotebook.Tab', background =
# $vTcl(tab)$vTcl(tab)\[\('selected', _bgcolor\), \('active', _tabbg1\),
# $vTcl(tab)$vTcl(tab)\('!active', _tabbg2\)\], foreground =
# $vTcl(tab)$vTcl(tab)\[\('selected', _fgcolor\), \('active', _tabfg1\), \('!active', _tabfg2\)\])\n"
#             }
#         }
#         set style_code($widclass) 1
#    }
#"
	switch $widclass {
		PNotebook {
                append ret \
"
$vTcl(tab)global _images
$vTcl(tab)_images = (
$vTcl(tab2) tk.PhotoImage(\"img_close\", data='''R0lGODlhDAAMAIQUADIyMjc3Nzk5OT09PT
$vTcl(tab2)$vTcl(tab2) 8/P0JCQkVFRU1NTU5OTlFRUVZWVmBgYGF hYWlpaXt7e6CgoLm5ucLCwszMzNbW
$vTcl(tab2)$vTcl(tab2) 1v//////////////////////////////////// ///////////yH5BAEKAB8ALA
$vTcl(tab2)$vTcl(tab2) AAAAAMAAwAAAUt4CeOZGmaA5mSyQCIwhCUSwEIxHHW+ fkxBgPiBDwshCWHQfc5
$vTcl(tab2)$vTcl(tab2)  KkoNUtRHpYYAADs= '''),
$vTcl(tab2) tk.PhotoImage(\"img_close_white\", data='''R0lGODlhDAAMAPQfAM3NzcjI
$vTcl(tab2)$vTcl(tab2)yMbGxsLCwsDAwL29vbq6urKysrGxsa6urqmpqZ+fn56enpaWloSEhF9fX0ZGR
$vTcl(tab2)$vTcl(tab2)j09PTMzMykpKQAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAP///yH
$vTcl(tab2)$vTcl(tab2)5BAEKAB8ALAAAAAAMAAwAAAUt4CeOZGmaA5mSyQCIwhCUSwEIxHHW+fkxBgPi
$vTcl(tab2)$vTcl(tab2)BDwshCWHQfc5KkoNUtRHpYYAADs='''),
$vTcl(tab2) tk.PhotoImage(\"img_closeactive\", data='''R0lGODlhDAAMAIQcALwuEtIzFL46
$vTcl(tab2)$vTcl(tab2) INY0Fdk2FsQ8IdhAI9pAIttCJNlKLtpLL9pMMMNTP cVTPdpZQOBbQd60rN+1rf
$vTcl(tab2)$vTcl(tab2) Czp+zLxPbMxPLX0vHY0/fY0/rm4vvx8Pvy8fzy8P//////// ///////yH5BAEK
$vTcl(tab2)$vTcl(tab2) AB8ALAAAAAAMAAwAAAVHYLQQZEkukWKuxEgg1EPCcilx24NcHGYWFhx P0zANBE
$vTcl(tab2)$vTcl(tab2) GOhhFYGSocTsax2imDOdNtiez9JszjpEg4EAaA5jlNUEASLFICEgIAOw== '''),
$vTcl(tab2) tk.PhotoImage(\"img_closepressed\", data='''R0lGODlhDAAMAIQeAJ8nD64qELE
$vTcl(tab2)$vTcl(tab2) rELMsEqIyG6cyG7U1HLY2HrY3HrhBKrlCK6pGM7lD LKtHM7pKNL5MNtiViNaon
$vTcl(tab2)$vTcl(tab)$vTcl(tab)  +GqoNSyq9WzrNyyqtuzq+O0que/t+bIwubJw+vJw+vTz+zT z////////yH5BAE
$vTcl(tab2)$vTcl(tab2) KAB8ALAAAAAAMAAwAAAVJIMUMZEkylGKuwzgc0kPCcgl123NcHWYW Fs6Gp2mYB
$vTcl(tab2)$vTcl(tab2) IRgR7MIrAwVDifjWO2WwZzpxkxyfKVCpImMGAeIgQDgVLMHikmCRUpMQgA7 ''')
$vTcl(tab2))
$vTcl(tab)if _bgmode == \"dark\":
$vTcl(tab)$vTcl(tab)style.element_create(\"close\", \"image\", \"img_close_white\",
$vTcl(tab)$vTcl(tab)   ('active', 'pressed',  'img_closepressed'),
$vTcl(tab)$vTcl(tab)   ('active', 'alternate', 'img_closeactive'), border=8, sticky='')
$vTcl(tab)else:
$vTcl(tab)$vTcl(tab)style.element_create(\"close\", \"image\", \"img_close\",
$vTcl(tab)$vTcl(tab)   ('active', 'pressed',  'img_closepressed'),
$vTcl(tab)$vTcl(tab)   ('active', 'alternate', 'img_closeactive'), border=8, sticky='')

$vTcl(tab)style.layout(\"ClosetabNotebook\", \[\(\"ClosetabNotebook.client\",
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab) \{\"sticky\": \"nswe\"\}\)\]\)
$vTcl(tab)style.layout(\"ClosetabNotebook.Tab\", \[
$vTcl(tab)$vTcl(tab)\(\"ClosetabNotebook.tab\",
$vTcl(tab)$vTcl(tab)  \{ \"sticky\": \"nswe\",
$vTcl(tab)$vTcl(tab2)\"children\": \[
$vTcl(tab)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.padding\", \{
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"side\": \"top\",
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"sticky\": \"nswe\",
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)\"children\": \[
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.focus\", \{
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"side\": \"top\",
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"sticky\": \"nswe\",
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"children\": \[
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.label\", \{\"side\":
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)  \"left\", \"sticky\": ''\}\),
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab)\(\"ClosetabNotebook.close\", \{\"side\":
$vTcl(tab)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)$vTcl(tab2)\"left\", \"sticky\": ''\}\),\]\}\)\]\}\)\]\}\)\]\)\n
$vTcl(tab)style.map('ClosetabNotebook.Tab', background =
$vTcl(tab)$vTcl(tab)\[\('selected', _bgcolor\), \('active', _tabbg1\),
$vTcl(tab)$vTcl(tab)\('!active', _tabbg2\)\], foreground =
$vTcl(tab)$vTcl(tab)\[\('selected', _fgcolor\), \('active', _tabfg1\), \('!active', _tabfg2\)\])\n"
		}
		TNotebook {
                #append ret \
#"$vTcl(tab)style.map('TNotebook.Tab', background =
#$vTcl(tab2)$vTcl(tab)\[('selected', _bgcolor), ('active', _tabbg1),
#$vTcl(tab2)$vTcl(tab)('!active', _ana2color)\], foreground =
#$vTcl(tab2)$vTcl(tab)\[('selected', _fgcolor), ('active', _tabfg1), ('!activ,  _tabfg2)\])\n"
		}
	}
		set style_code($widclass) 1
    return $ret
}

proc vTcl:python_source_widget {target prefix parentframe} {
    # This is the work horse of PAGE; it takes a widget and returns
    # the stream of Python code which realizes the widget.
    global vTcl widget
    global suffix
    global rel
    # Get target name and class
    set suffix 0
    set widclass [winfo class $target]
    set parent $parentframe            ;# Just to save typing.
    set widname [vTcl:widget_2_widname $target]
    if {[string first "vTH_" $target]>-1} {
        return
    }
    if {[winfo class $target]=="Menubutton"} {
        set menu_y_shift 24
    } else {
        set menu_y_shift 0
    }
    foreach {w h x y} [split [winfo geometry $target] "x+"] {}
    set rectangle "$x, [expr {$y-$menu_y_shift}], $w, $h"
    set cmdbody {}
    set cmdname {}
    set vTcl(gen_name) {}
    catch {
        vTcl:py_get_command_parameters [$target cget -command]
    }
    set parentclass [winfo class $parentframe]
    if {$parentclass == "Toplevel"} {     # Rozen
        set pframe "self.top"                 ;# 4/8/21
    } else {
        set parentf [vTcl:widget_2_widname $parentframe]
        set pframe "self.$parentf"
    }
    vTcl:calc_relative_geometry $target
    set rel(widname) $widname
    set rel(pframe) $pframe
    set vTcl(py_initfunc) "$vTcl(py_initfunc)\n"
    # Following block determines when style code is required for ttk widgets.
    if {([string index $widclass 0] in  [list "T" "P"] ||
         [string first  "Scroll" $widclass] > -1)  && $widclass != "Text"} {
        set vTcl(using_ttk) 1
        if {$widclass ni $vTcl(ttk_classes_found)} {
            lappend vTcl(ttk_classes_found) $widclass
        }
    }
    # if {[info exists vTcl(widget_class,$target)]} {  #  12/17/17
    #     set widclass $vTcl(widget_class,$target)
    # }

    switch $widclass {
        Label {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Label($pframe)\n"
            vTcl:relative_x_y $parent  ;# Don't want labels stretchable.
            switch [$target cget -borderwidth] {
                0 {set bdt none}
                1 {set bdt SoftBevelBorder}
                default {set bdt BevelBorder}
            }
            vTcl:python_configure_widget $target $widname "" $widclass
        }
        Entry {
            vTcl:py_get_command_parameters [$target cget -textvar]
            if {$cmdname == ""} {
                set cmdname "$widname\_hit_enter"
            }
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Entry($pframe)\n"
            vTcl:entry_placement $parent
            vTcl:python_configure_widget $target $widname "" $widclass
        }
        Button {
            set im [$target cget -image]
            set hi [$target cget -height]
            set wi [$target cget -width]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Button($pframe)\n"
            vTcl:relative_x_y $parent   ;# Don't want buttons stretchable.
            #vTcl:relative_placement
             if {$cmdname==""} {
                set cmdname "$widname\_click()"
			 }
			vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        Scale {
            set from [$target cget -from]
            set to [$target cget -to]
            set res [$target cget -resolution]
            append vTcl(py_initfunc) \
				"$vTcl(tab2)self.$widname = \
                tk.Scale($pframe, from_=$from, to=$to, resolution=$res)\n"
            vTcl:relative_placement
            #vTcl:scale_placement $target $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        Scrollbar { # Since I am using the Tix widgets I am not too interested
                    # in scrollbars, so I haven't checked them out.
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Scrollbar($pframe)\n"
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname.place(in_=$pframe, x=$x, y=$y)\n"
            vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        Frame -
        Labelframe {
            # Because vTcl uses Labelframe as the class name
            # and Tkinter uses LabelFrame, it is necessary for
            # some one to switch the names. I think it is
            # better to have the hack here in my code than
            # sprinkled through out the vtcl code.
            switch $widclass  {
                Frame {
                    set nn "tk.Frame"
                }
                Labelframe {
                    set nn "tk.LabelFrame"
                }
            }
            append vTcl(py_initfunc) \
                        "$vTcl(tab2)self.$widname = $nn" "($pframe)\n"
            vTcl:relative_placement $parent
            switch [$target cget -borderwidth] {
                0 {set bdt none}
                1 {set bdt SoftBevelBorder}
                default {set bdt BevelBorder}
            }
            # if {$bdt == "none"} {
            #     set vTcl(py_initfunc) "$vTcl(py_initfunc)$vTcl(tab)"

            #         "$widname.setBorder(new EmptyBorder(0,0,0,0))\n"
            # } else {
            #     set relf [$target cget -relief]
            #     append vTcl(py_initfunc) \
            #         "$vTcl(tab2)self.$widname.configure(relief='$relf')\n"
            # }
            if {$bdt ne "none"} {
                set relf [$target cget -relief]
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname.configure(relief='$relf')\n"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:py_source_frame $target \
                    $prefix[lindex [split $target .] end] $widname
        }
        Text {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Text($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:python_load_cmd $target $widname
        }
        Message {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Message($pframe)\n"
            vTcl:relative_placement $parent
            #vTcl:fixed_placement
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:python_load_cmd $target $widname
        }
        Listbox {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Listbox($pframe)\n"
            vTcl:relative_placement $parent
            if {$cmdname==""} {
                set cmdname "$widname\_state_changed"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:python_load_cmd $target $widname

        }
        Radiobutton {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Radiobutton($pframe)\n"
            vTcl:relative_placement $parent
            if {$cmdname==""} {
                set cmdname "$widname\_click"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            # NEEDS WORK because I don't know what the following is for.
            set rbvar [$target cget -variable]
            if {![info exists vTcl(py_btngroup,$rbvar)]} {
                set vTcl(py_btngroup,$rbvar) 1
            }
            # We are going to need a global variable even if one is not specified
            #set vTcl(global_variable) 1
        }
        Checkbutton {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Checkbutton($pframe)\n"
            vTcl:relative_placement $parent
            if {$cmdname==""} {
                set cmdname "$widname\_state_changed"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        Menubutton {
            set vTcl(in_menubutton) 1
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname = tk.Menubutton($pframe)\n"
            vTcl:relative_placement $parent
            set menu [$target cget -menu]
            set menu_name [vTcl:widget_2_widname $menu]
            append vTcl(py_initfunc) \
				"$vTcl(tab2)self.$menu_name = " \
				"tk.Menu(self.$widname,tearoff=0,background=_bgcolor)\n"
            vTcl:python_configure_widget $target $widname \
                $cmdname $widclass "" self.$menu_name
			set widname First
			set vTcl(firstIteration) 1
			#vTcl:python_process_menu $menu self.$menu_name  $menu_name $widname
			vTcl:python_process_menubutton $menu self.$menu_name  $menu_name;# $widname
            set vTcl(in_menubutton) 0
        }
        Canvas {
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = tk.Canvas($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:py_source_frame $target \
                    $prefix[lindex [split $target .] end] $widname
        }
        Spinbox {
            set from [$target cget -from]
            set to [$target cget -to]
            append vTcl(py_initfunc) \
          "$vTcl(tab2)self.$widname = tk.Spinbox($pframe, from_=$from, to=$to)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        TButton {
            #set image_file [vTcl:look_for_image $widget]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                 "$vTcl(tab2)self.$widname = ttk.Button($pframe)\n"
            vTcl:relative_x_y $parent  ;# Don't want buttons stretchable.
            # if {$Popupmenu1cmdname==""} {
            #     set cmdname "$widname\_click()"
            # }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TEntry {
            vTcl:py_get_command_parameters [$target cget -textvar]
            if {$cmdname == ""} {
                set cmdname "$widname\_hit_enter"
            }
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Entry($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname "" $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TFrame {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Frame($pframe)\n"
            vTcl:relative_placement $parent
            switch [$target cget -borderwidth] {
                0 {set bdt none}
                1 {set bdt SoftBevelBorder}
                default {set bdt BevelBorder}
            }
            if {$bdt == "none"} {
                set vTcl(py_initfunc) "$vTcl(py_initfunc)$vTcl(tab)"

                    "$widname.setBorder(new EmptyBorder(0,0,0,0))\n"
            } else {
                set relf [$target cget -relief]
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname.configure(relief='$relf')\n"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            vTcl:py_source_frame $target \
                    $prefix[lindex [split $target .] end] $widname
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TLabel {
            # Don't forget to discuss the strange behavior of no width
            # upon creation.
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Label($pframe)\n"
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            vTcl:relative_x_y $parent   ;# Don't want labels stretchable.
            switch [$target cget -borderwidth] {
                0 {set bdt none}
                1 {set bdt SoftBevelBorder}
                default {set bdt BevelBorder}
            }
            vTcl:python_configure_widget $target $widname "" $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TLabelframe {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
           append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Labelframe($pframe)\n"
            vTcl:relative_placement $parent
            switch [$target cget -borderwidth] {
                0 {set bdt none}
                1 {set bdt SoftBevelBorder}
                default {set bdt BevelBorder}
            }
            if {$bdt == "none"} {
                set vTcl(py_initfunc) "$vTcl(py_initfunc)$vTcl(tab)"
                    "$widname.setBorder(new EmptyBorder(0,0,0,0))\n"
            } else {
                set relf [$target cget -relief]
                append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname.configure(relief='$relf')\n"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            #vTcl:py_source_frame $target \
                    $prefix[lindex [split $target .] end] $widname
            vTcl:py_source_frame $target \
                    $prefix[lindex [split $target .] end] $parentframe
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TSpinbox {
            set from [$target cget -from]
            set to [$target cget -to]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
        "$vTcl(tab2)self.$widname = ttk.Spinbox($pframe, from_=$from, to=$to)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
        }
        PNotebook {
            #this is PNotebook if there is an image and TNotebook in other cases
            #Don, winfo class $target returns TNotebook, as you've mentioned earlier
            #so I couldn't use it istead like so
            #if {[winfo class $target] == "PNotebook"}


            # Maksim

            incr vTcl(pnotebook_count)

            incr vTcl(pnotebook_count)
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    $vTcl(tab)$vTcl(tab)PNOTEBOOK = "\"ClosetabNotebook\"\n"
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname = ttk.Notebook($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname ""  $widclass
            # Lets try to put out options for the nbframe subwidget
            set pages [$target tabs]
            set i 0
            foreach p  $pages {
                set sub_name $::widget(rev,$p)
                append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$sub_name = tk.Frame(self.$widname)\n"
                append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.add(self.$sub_name, padding=3)\n"
                set options [vTcl:python_nb_tab_configure $target $p]
				append vTcl(py_initfunc) \
                [vTcl:split_line "$vTcl(tab2)self.$widname.tab($i, $options)\n"]
                vTcl:python_configure_widget $p $sub_name "" "Frame"
                incr i
            }
            # Now get the widgets inside each page.

            # # Since the pg returns a geometry of 1x1+0+0 we pick up
            # # the geometry of the parent.  Definitely a kludge. Not
            # # needed 4/3/17.
            # set rel(geometry) [winfo geometry [winfo parent $p]]
            foreach p  $pages {
                vTcl:python_source_subwidgets $p $p
            }
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
            set vTcl(add_pnotebook_helper) 1
        }
        TNotebook {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname = ttk.Notebook($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname ""  \
                [winfo class $target]
			# Lets try to put out options for the nbframe subwidget
            set pages [$target tabs]
            set i 0
            foreach p $pages {
				set vTcl(do_image) ""
                set sub_name $::widget(rev,$p)
                #append vTcl(py_initfunc) \
					"\n#Page self.$sub_name starting."
				if {$vTcl(current_theme) eq "page-legacy"} {
					append vTcl(py_initfunc) \
                         "$vTcl(tab2)self.$sub_name = tk.Frame(self.$widname)\n"
				} else {
					append vTcl(py_initfunc) \
                         "$vTcl(tab2)self.$sub_name = tk.Frame(self.$widname)\n"
				}
				set options [vTcl:python_nb_tab_configure $target $p]
				if {$vTcl(encoding) != ""} {
                    append vTcl(py_initfunc) \
						"$vTcl(tab2)self.img$vTcl(notebook_image_count) = \
						tk.PhotoImage(file='''$vTcl(encoding)''')\n"
                    append options "image=self.img$vTcl(notebook_image_count)"
                    incr vTcl(notebook_image_count)
                }

				
                append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.add(self.$sub_name, padding=3)\n"
                append vTcl(py_initfunc) \
                [vTcl:split_line "$vTcl(tab2)self.$widname.tab($i, $options)\n"]
				if {$vTcl(do_image) ne ""} {
					set image [vTcl:tab_image $vTcl(do_image)]
					append vTcl(py_initfunc) \
						[vTcl:split_line \
							 "$vTcl(tab2)self.$widname.tab($i, image=$image)\n"]
}
                vTcl:python_configure_widget $p $sub_name "" "Frame" ;# "
                incr i
            }
            # Now get the widgets inside each page.

            # # Since the pg returns a geometry of 1x1+0+0 we pick up
            # # the geometry of the parent.  Definitely a kludge. Not
            # # needed 4/3/17.
            # set rel(geometry) [winfo geometry [winfo parent $p]]
            foreach p  $pages {
                vTcl:python_source_subwidgets $p $p

            }
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        Scrolledtext {
            set config [$target configure]
            append py_initfunc [vTcl:style_code "TScrollbar"]
            #append vTcl(py_initfunc) \
                "$vTcl(tab2)root.option_add('*scrollbar*background', '$vTcl(actual_gui_bg)')\n"
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledText($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            #vTcl:python_load_cmd $target $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledtext
        }
        Scrolledcanvas {
            set config [$target configure]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            #append vTcl(py_initfunc) \
                "$vTcl(tab2)root.option_add('*scrollbar*background', '$vTcl(actual_gui_bg)')\n"
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledCanvas($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            #vTcl:python_load_cmd $target $widname
            vTcl:py_source_frame $target.01 \
                    $prefix[lindex [split $target.01 .] end] $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledcanvas
        }
        Scrolledentry {
            set config [$target configure]
            append py_initfunc [vTcl:style_code "TScrollbar"]
            #append vTcl(py_initfunc) \
                "$vTcl(tab2)root.option_add('*scrollbar*background', '$vTcl(actual_gui_bg)')\n"
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledEntry($pframe)\n"
            vTcl:entry_placement  $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            #vTcl:python_load_cmd $target $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledentry
        }
        Scrolledspinbox {
            set from [$target.01 cget -from]
            set to [$target.01 cget -to]
            set config [$target configure]
            append py_initfunc [vTcl:style_code "TScrollbar"]
            #append vTcl(py_initfunc) \
                "$vTcl(tab2)root.option_add('*scrollbar*background', '$vTcl(actual_gui_bg)')\n"
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
				"$vTcl(tab2)self.$widname = \
				ScrolledSpinbox($pframe, from_=$from, to=$to)\n"
            vTcl:entry_placement  $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
#                    append vTcl(py_initfunc) \
         "$vTcl(tab2)self.$widname.configure(buttonbackground=_bgcolor)\n"
            #vTcl:python_load_cmd $target $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledspinbox
        }
        Scrolledcombo {
            set config [$target configure]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            #append vTcl(py_initfunc) \
                "$vTcl(tab2)root.option_add('*scrollbar*background', '$vTcl(actual_gui_bg)')\n"
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledCombo($pframe)\n"
            vTcl:entry_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            #vTcl:python_load_cmd $target $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledcombo
        }
        Scrolledwindow {
            set config [$target configure]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledWindow($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            vTcl:inner_frame $widname
            #vTcl:python_load_cmd $target $widname
            foreach w [winfo children $target.01] { ;#Children of the canvas.
                set w_class [vTcl:get_class $w]
                if {$w_class eq "Canvas"} { continue }
                if {$w_class eq "Scrollbar"} { continue }
                vTcl:python_source_widget $w {} $target
            }
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledwindow
        }
        TProgressbar {
            set config [$target configure]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Progressbar($pframe)\n"
            #vTcl:relative_placement
            vTcl:progressbar_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass

        }
        TMenubutton {
            set vTcl(in_menubutton) 1
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
               "$vTcl(tab2)self.$widname = ttk.Menubutton($pframe)\n"
#            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.place(in_=$pframe, x=$x, y=$y)\n"
            vTcl:relative_placement $parent
            set menu [$target cget -menu]
            set menu_name [vTcl:widget_2_widname $menu]
#set menu_name [vTcl:python_unique_menu_name menu]
            append vTcl(py_initfunc) \
				"$vTcl(tab2)self.$menu_name = " \
				"tk.Menu(self.$widname,tearoff=0,background=_bgcolor)\n"
            vTcl:python_configure_widget $target $widname $cmdname \
                      $widclass "" "self.$menu_name"
set widname First
			set vTcl(firstIteration) 1
            # vTcl:python_process_menu $menu $widname $menu_name $widname 
            # vTcl:python_process_menu $menu $widname $menu_name $widname 
			vTcl:python_process_menubutton $menu self.$menu_name  $menu_name;# $widname
            #append vTcl(py_initfunc) \
            #   "$vTcl(tab2)self.$widname.config(menu=$lablab)\n"
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
            set vTcl(in_menubutton) 0
        }
        Scrolledlistbox {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledListBox($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass
            #vTcl:python_load_cmd $target $widname
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledlistbox
        }
        Scrolledtreeview {
            #append py_initfunc [vTcl:comp_color]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ScrolledTreeView($pframe)\n"
            append py_initfunc [vTcl:style_code "TScrollbar"]
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target.01 $widname $cmdname $widclass

            vTcl:build_treeview_support $target.01 $widname $cmdname $widclass
            set vTcl(add_helper_code) 1
            lappend vTcl(helper_list) Scrolledtreeview
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TCheckbutton {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Checkbutton($pframe)\n"
            vTcl:progressbar_placement $parent
            if {$cmdname==""} {
                set cmdname "$widname\_state_changed"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
                           # $('<Map>', self.__adjust_sash)widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TCombobox {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Combobox($pframe)\n"
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        Custom {
            # We have to play some extra games to allow variants of
            # the Custom class.
            #set variant $::widgets::${target}::options($spec_opt)
            set spec_opt "-variant"
            set variant [$::configcmd($spec_opt,get) $target]
            if {[info exists vTcl($target,-variant)]} {
                set variant $vTcl($target,-variant)
                set c_v Custom$variant
            } else {
                set c_v Custom
            }

            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname = $vTcl(import_name).${c_v}($pframe)\n"
            vTcl:relative_placement $parent
        }
        TRadiobutton {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Radiobutton($pframe)\n"
            #vTcl:relative_placement $parent
            vTcl:progressbar_placement $parent
            if {$cmdname==""} {
                set cmdname "$widname\_click"
            }
            vTcl:python_configure_widget $target $widname $cmdname $widclass
# NEEDS WORK because I don't know what the following is for.
            set rbvar [$target cget -variable]
            if {![info exists vTcl(py_btngroup,$rbvar)]} {
                set vTcl(py_btngroup,$rbvar) 1
            }
            # We are going to need a global variable even if one is not specified
            #set vTcl(global_variable) 1
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TScale {
            set from [$target cget -from]
            set to [$target cget -to]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
          "$vTcl(tab2)self.$widname = ttk.Scale($pframe, from_=$from, to=$to)\n"
            vTcl:relative_placement
            #vTcl:scale_placement $target $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TSeparator {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname = ttk.Separator($pframe)\n"
            vTcl:separator_placement $target $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
        }
        TSizegrip {
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                    "$vTcl(tab2)self.$widname = ttk.Sizegrip($pframe)\n"
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.$widname.place(anchor='se', relx=1.0, rely=1.0)\n"
        }
        TPanedwindow {
            set orient [$target cget -orient]
            append vTcl(py_initfunc) [vTcl:emit_style_code]
            append vTcl(py_initfunc) \
                [vTcl:split_line "$vTcl(tab2)self.$widname = ttk.Panedwindow($pframe, orient=\"$orient\")\n"]
            vTcl:relative_placement $parent
            vTcl:python_configure_widget $target $widname $cmdname $widclass
            # Add the panes.  The panes are added so that each pane
            # shares the same space.
            set panes [$target panes]
            set no_panes [llength $panes]
            set cnt 0
            foreach p $panes {
                incr cnt
                set conf [$target pane $p]
                set weight [lrange $conf 1 1]
                set text [$p cget -text]
                if {[catch {set sub_name $widget(rev,$p)}]} {
                    # This is the otherwise path: no alias
                    set sub_name [join [concat $widname "_p" $cnt] ""]
                    vTcl:python_alias $sub_name $p   ;# Rozen new
                }
                if {$orient == "horizontal"} {
                    # Horizontal sash.
                    set w [$p cget -width]
                    if {$cnt < $no_panes} {
                        set width_clause "width=$w, "
                    } else {
                        set width_clause ""
                    }
                    append vTcl(py_initfunc) \
                        [vTcl:split_line "$vTcl(tab2)self.$sub_name = ttk.Labelframe(self.$widname, ${width_clause}text='$text')\n"]
                    append vTcl(py_initfunc) \
                 "$vTcl(tab2)self.$widname.add(self.$sub_name, weight=$weight)\n"
                } else {
                    # Vertical sash.
                    set h [$p cget -height]
                    if {$cnt < $no_panes} {
                        set height_clause "height=$h, "
                    } else {
                        set height_clause ""
                    }
                    append vTcl(py_initfunc) \
                        [vTcl:split_line "$vTcl(tab2)self.$sub_name = ttk.Labelframe(self.$widname, ${height_clause}text='$text')\n"]
                    append vTcl(py_initfunc) \
                 "$vTcl(tab2)self.$widname.add(self.$sub_name, weight=$weight)\n"
                }
                vTcl:python_configure_widget $p $sub_name "" "Frame"
            }

        update idletasks
        set pos "pos = \["
        for {set i 0;set p [expr [llength $panes]-1]} {$i < $p} {incr i} {
            set coord [$target sashpos $i]
            append pos $coord ", "
        }
        append pos "\]"

#     This is the sort of code I want. It is from Guilherme Polo's Theming.py
#         self.__funcid = paned.bind('<Map>', self.__adjust_sash)

#     def __adjust_sash(self, event):
#         """Adjust the initial sash position between the top frame and the
#         bottom frame."""
#         height = self.master.geometry().split('x')[1].split('+')[0]
#         paned = event.widget
#         paned.sashpos(0, int(height) - 180)
#         paned.unbind('<Map>', self.__funcid)
#         del self.__funcidTcl(pr,menubgcolor
            append vTcl(py_initfunc) \
                "$vTcl(tab2)self.__funcid$vTcl(pw_cnt) = self.$widname.bind('<Map>', self.__adjust_sash$vTcl(pw_cnt))\n"

            append vTcl(class_functions) \
"
$vTcl(tab)def __adjust_sash$vTcl(pw_cnt)(self, event):
$vTcl(tab)$vTcl(tab)paned = event.widget
$vTcl(tab)$vTcl(tab)$pos
$vTcl(tab)$vTcl(tab)i = 0
$vTcl(tab)$vTcl(tab)for sash in pos:
$vTcl(tab)$vTcl(tab)$vTcl(tab)paned.sashpos(i, sash)
$vTcl(tab)$vTcl(tab)$vTcl(tab)i += 1
$vTcl(tab)$vTcl(tab)paned.unbind('<map>', self.__funcid$vTcl(pw_cnt))
$vTcl(tab)$vTcl(tab)del self.__funcid$vTcl(pw_cnt)
"
            incr vTcl(pw_cnt)

            # Generate code for each of the subwidgets.
            foreach p $panes {
                #set child [winfo children $p]
                vTcl:python_source_subwidgets $p $p
            }

            #vTcl:python_configure_widget $target $widname $cmdname $widclass
            lappend vTcl(fonts_used) $vTcl(actual_gui_font_dft_name)
         }
         Menu {			 
             if {$target == $vTcl(toplevel_menu)} {
                # First step is to put out the proper toplevel menus headers.
                # But only do once.
                set menu_config [$target configure]
                #set menu_font [$target cget -font] In the line below
                # I want the top level to have the font specified in
                # the preferences.  Since this is a menubar and there
                # will only be one menubar per toplevel window, I will
                # change the widname to "menubar".
                set readable_name menubar
set vTcl(toplevel_menu_header) ""
                if {$vTcl(toplevel_menu_header) == "" } {
                    #python_configure_widget
                    #set f_s [vTcl:python_menu_font $vTcl(pr,gui_font_menu)]
                    set f_s [vTcl:python_menu_font \
                        $vTcl(actual_gui_font_menu_name)]
                    #set f_s [vTcl:condense_font_description \
                        $vTcl(actual_gui_font_menu_name)]
                    #lappend vTcl(fonts_used) $vTcl(actual_gui_font_menu_name)
                    if {$f_s == "font=()"} {
                        # For readability I am explicitly saying that I
                        # will specify the use of TkMenuFont.
                        set f_s "font=\"TkMenuFont\""
                        #set f_s ""
                    }
                    if {$f_s != ""} {
                        set f_s ",$f_s"
                    }
                    set menu_bg [$target cget -background]
                    # set bg_s ""
                    # if { $vTcl(pr,menubgcolor) != $vTcl(pr,bgcolor)} {
                    #     append bg_s ",background=\'" $vTcl(pr,menubgcolor) "\'"
                    # }
                    set bg_s ""
                    if {[::colorDlg::compare_colors $menu_bg \
                             $vTcl(actual_gui_bg)]} {
                        append bg_s ",bg=_bgcolor"
                    } else {
                        append bg_s ",bg=\'" $menu_bg "\'"
                    }
                    # set fg_s ""
                    # if { $vTcl(pr,menufgcolor) != "#000000"} {
                    #     append fg_s ",fg=\'" $vTcl(pr,menufgcolor) "\'"
                    # }
                    set menu_fg [$target cget -foreground]
                    set fg_s ""
                    if {[::colorDlg::compare_colors $menu_fg \
                             $vTcl(actual_gui_fg)]} {
                        append fg_s ",fg=_fgcolor"
                    } else {
                        append fg_s ",fg=\'" $menu_fg "\'"
                    }
				#NEEDS WORK for activebackground.
				set str \
                 "$vTcl(tab2)self.$readable_name = tk.Menu(top$f_s$bg_s$fg_s)\n"
				    append vTcl(py_initfunc) [vTcl:split_line $str]
                    append vTcl(py_initfunc) \
                   "$vTcl(tab2)top.configure(menu = self.$readable_name)\n"
                           #"$vTcl(tab2)master\[\'menu\'\] = self.$widname\n"
                    set vTcl(toplevel_menu_header) 1
                    append vTcl(py_initfunc) "\n"
			    # }
				set vTcl(firstIteration) 1
                append vTcl(py_initfunc) \
					"$vTcl(tab2)########### start #######################\n"
				vTcl:python_process_menu $target $widname $readable_name \
					vTcl(py_initfunc)
                append vTcl(py_initfunc) \
					"$vTcl(tab2)########### end #######################\n"
                #append vTcl(py_initfunc) \
					"$vTcl(tab2)top.configure(menu = self.$readable_name)\n"
            }
        }
        default {
            puts "Unknown widget class encountered: $widclass"
       }
    }
    # Here is were I put in the bindings.
    append vTcl(py_initfunc) [vTcl:python_dump_bind $target $widname]
}

proc vTcl:inner_frame {name} {
    global vTcl
    set no 1
    append vTcl(py_initfunc) \
        "$vTcl(tab2)self.color = self.$name.cget(\"background\")
        self.${name}_f = tk.Frame(self.$name,
                            background=self.color)
        self.${name}.create_window(0, 0, anchor='nw',
                                           window=self.${name}_f)\n"
}

proc vTcl:python_menu_font {font_in} {
    # Change something like
 #-family Purisa -size 14 -weight normal -slant roman -underline 0 -overstrike 0
    # into ,font=('Purisa',14,'normal','roman',)
    # Badly named becaues I use it whenever I want to reformat a font
    # description.
    global vTcl
    set font_string ""
    # I want to see if font is a font name.  I will assume that if the
    # font name does not contain the string "family"we have then it is a font
    # name.
    if {[regexp {^font[0-9]+$} $font_in]} {
        # Remember that we used it.
        lappend vTcl(fonts_used) $font_in
    }
    set new [vTcl:condense_font_description $font_in]
return "font=\"$new\""
    if {$font_in in $vTcl(standard_fonts)} {
        return "font=\"$font_in\""
    }
    if {[string index $font_in 0] == "\{"} {
        foreach value $font_in {
        }
        return "font=\"$font_in\""
    }
    if {[string first "-family" $font_in] == -1} {

    # I think that we have a font name.
        lappend vTcl(fonts_used) $font_in
        #return "font=self.$font"
        #return "font=$font"         ;# 2/9/19
        return "font=$font_in"          ;# 6/13/19
        set font_in [font actual $font_in]
    }
    if {$font_in == "" } {
        # I don't think that I hit this batch of code.
        set font_in vTcl(pr,gui_font_menu)
        #set font TkMenuFont
    }
    if {$font_in != ""} {
        set font_string "font=("
        # Reformat font sting for python
        # append font_string [vTcl:prune_font_string $font_in] ")"
        append font_string [vTcl:enclose_font_string $font_in] ")"
        # append font_string '$font_in' ")"
    }
    return $font_string
}

proc vTcl:enclose_font_string {font} {
    # Determine if font is a string encased by quotes.
    set encased [regexp "\".*\"$" $font]
    if {$encased} {
        return $font
    }
    set encased [regexp "'.'$" $font]
    if {$encased} {
        return $font
    }
    return '$font'
}

proc vTcl:python_menu_options { opts {index {}} {menu_name {}} \
                                    {image_name {}} {target {}}} {
    # Each time vTcl:python_process_menu processes a menu entry this
    # routine is called to create a python string which will add the
    # non default option values. It is passed the list of option lists.
    # The option list items looks like {-underline {} {} -1 -1}
    global vTcl
    set option_string ""
    # Now I will handle the configuration options: Added 12/24/11	
    foreach op $opts {
        foreach {o x y d v} $op {
            # o - option
            # d - default
            # v - value
        }
        set v [string trim $v]
        if {$d == $v && $o != "-variable"} continue ;# If value ==
                                                     # default value bail.
        set oa [string range $o 1 end]
        switch -exact -- $o {
            -font {
                set font_string [vTcl:python_menu_font $v]
                if {$font_string != ""} {
                    #append option_string \
                    #    "$vTcl(tab2)$vTcl(tab2)$font_string,\n"
                    append option_string \
                        "$font_string,"
                }
            }
            -menu {
                set z ''
                # Do nothing
                #append option_string "$oa=self.$menu_name,\n"
            }
            -accelerator -
            -activebackground -
            -activeforeground -
            -disabledforeground -
            -background -
            -compound -
            -foreground -
            -label -
            -selectcolor {
                #append option_string \
                #    "$vTcl(tab2)$vTcl(tab2)$oa=\"$v\",\n"
                append option_string \
                    "$oa='$v',"
                    #"$oa=\"$v\","
            }
            -value {
                    append option_string \
                    "$oa='$v',"
                    # "$vTcl(tab2)$vTcl(tab2)$oa='$v',\n"
            }
			-postcommand -
            -command {
                if {$v eq "#"} {
                    continue
                }
                #set v $cmdname
                #if {[string first "(" $v] == -1} {
                #        append v "()"
                #}
                regsub {^#+} $v "" v ;# Remove leading string of '#' chars.
                if {$v == "\# TODO"} {
                    # This is here for compatibility with previous
                    # creations. I am removing the hint # TODO.
                    continue
                }
                if {$v == "\{\}"} {
                    continue
                }

                lappend vTcl(funct_list) $v
                set v [vTcl:add_lambda $v]
                set v [vTcl:prepend_import_name $v]
                #append option_string \
                #     "$vTcl(tab2)$vTcl(tab2)$oa=$v,\n"
                append option_string \
                     "$oa=$v,"
            }
            -image {
                #append option_string \
                        #        "$vTcl(tab2)$vTcl(tab2)$oa=$image_name,\n"
                append option_string \
                    "$oa=$image_name,"
            }
            -variable {
                # The big deal here is to be sure that the global
                # variable is created $v is the variable name. Check
                # to see if it begins with "self." to tell if it is a
                # local rather than a global.

				if {[string first self. $v] == 0} {
                    if {[lsearch -exact $vTcl(l_v_list) $v] == -1} {
                        set vv  "$vTcl(tab2)$v = StringVar()\n"
                        lappend vTcl(l_v_list) $vv
                    }

                #} elseif {[string first . $v] >= 0} {
                #    # Variable in imported module
                    #    set vTcl(supp_variables) 1
                } else {
                    # Global variable
					set vv ${v}StringVar

foreach e $vTcl(g_v_list) {
    lappend joinedList [join $e ""]
}


if {![info exists joinedList]} { set joinedList [list]}
                    # if {[lsearch -exact $vTcl(g_v_list) $v] == -1} { }
                    # if {[lsearch -exact $joinedList $joinedv] == -1} { }
					if {[lsearch -exact $joinedList $vv] == -1} {
                        set vTcl(global_variable) 1
                        set m StringVar
                        set l [list $v $m]
                        # lappend vTcl(g_v_list) $l
                        lappend vTcl(g_v_list) $v $m
                        # if {$vTcl(in_popup)} {
                        #     if {[lsearch -exact $vTcl(p_v_list) $v] == -1}  {                                lappend vTcl(p_v_list) $v $m $target
                        #    }
                        # } elseif {[lsearch -exact $vTcl(g_v_list) $v] == -1}  {
                        #     lappend vTcl(g_v_list) $v $m
                        # }
                    }
                }
                #set v [vTcl:prepend_import_name $v]
                # if {[string first ".pop" $target] == -1} {
                #     append option_string "$vTcl(tab2)$vTcl(tab2)$oa=self.$v,\n"
                # } else {
                #     append option_string "$vTcl(tab2)$vTcl(tab2)$oa=$v,\n"
                # }
                if {[string first ".pop" $target] == -1} {
                    append option_string "$oa=self.$v,"
                } else {
                    append option_string "$oa=$v,"
                }
            }    ;# End of value and variable.
            -state -
            -relief {
                #set v [string toupper $v]
                set v \"$v\"
                # append option_string "$vTcl(tab2)$vTcl(tab2)$oa=$v,\n"
                append option_string "$oa=$v,\n"
            }
            default {
                # append option_string "$vTcl(tab2)$vTcl(tab2)$oa=$v,\n"
                append option_string "$oa=$v,"
            }
        } ;# End of Switch
    }  ;# End of loop over opts
    # Remove last ',' from opt_string
    set option_string [string range $option_string 0 end-1]
    return $option_string
}

proc vTcl:python_create_image {target index} {
    # Looks up file name, converts it to a relative file name, and
    # generates an image name which it uses to generate a line of code
    # required by Python to create an reference. I do not have to
    # return the name because it will be used when processing the
    # option list before another will be generated. This was borrowed
    # from vTcl:python_configure_widget.

    #  This called for every item in a menu. Called from
    #  vTcl:python_process_menu

    # NEEDS WORK: Should not have the same code in two places; will
    # consolidate. Add a parameter to increment.
    global vTcl
    # See if menu entry has an image. If not return blank ; other wise put
    # out the image code needed.
    set image  [$target entrycget $index -image]
    if {$image == ""} return ""
    set file_name $vTcl(imagefile,$image)  ;# Fetch file name coupled to image.
    # Try for relative path
    set to_name [vTcl:set_to_name]
    set file_name [vTcl:relTo $file_name $to_name]
    # set image_name self._img$vTcl(image_count)
    set image_name _img$vTcl(image_count)
    set image_ext [file extension $file_name]

    append vTcl(py_initfunc) \
       "$vTcl(tab2)photo_location = os.path.join(_location,\"$file_name\")\n"
      #"$vTcl(tab2)photo_location = os.path.join(prog_location,\"$file_name\")\n"
       # "$vTcl(tab2)photo_location = \"$file_name\"\n"
    append vTcl(py_initfunc) \
       "$vTcl(tab2)global $image_name\n"
    switch $image_ext {
        .png -
        .gif -
        .pgm {
            # Handling images supported by Tk.
            append vTcl(py_initfunc) \
                  "$vTcl(tab2)$image_name = tk.PhotoImage(file=photo_location)\n"
                #"$vTcl(tab2)$image_name = tk.PhotoImage(file=\"$file_name\")\n"
        } ;# end of standard image formats
        default {
            # Where we handle the other types of images
            set vTcl(need_PIL) 1
            append vTcl(py_initfunc) \
             "$vTcl(tab2)$image_name = ImageTk.PhotoImage(file=photo_location)\n"
            incr vTcl(need_PIL)
        }
    }
    incr vTcl(image_count)
    return $image_name
}

proc vTcl:python_replace_blanks {str} {
    # Replace all blanks in str with "_" and write to
    # no_blanks. Return no_blanks. Before starting we remove beginning
    # and train ling white space.
    set str [string trim $str]
    regsub -all {\s+}  $str "_" no_blanks
    return $no_blanks
}

proc vTcl:python_process_menubutton {target widname {readable_name {}}
                               {ret_var {vTcl(py_initfunc)}}} {
    # This is a recursive proc to translate the menu stuff in
    # python. When we get to a menu item which is a cascade we so that
    # item and then recurse into the new cascade menu. It calls
    # vTcl:python_create_image to determine if the item contains an
    # image and to generate the needed extra reference to the
    # PhotoImage object (see
    # http://effbot.org/tkinterbook/photoimage.htm for an example.)
    # and then calls vTcl:python_menu_options to process the options
    # for the menu entry. 
    global vTcl
	if {[string first .# $target] >= 0} {return}
    set entries [$target index end]
    if {$entries == "none"} {return}
    set result ""
    if {$readable_name == ""} {
        set widname [vTcl:widget_2_widname $target]
    } else {
        set widname $readable_name
    }
    for {set i 0} {$i<=$entries} {incr i} {
        set type [$target type $i]
        if {[info exists vTcl(toplevel_menu)] &&
            $target == $vTcl(toplevel_menu)} {
            if {$type == "tearoff"} {
                # tearoff at toplevel doesn't really mean anything,
                # but let the user specify it anyway.
                continue
            }
        }
        set opts [$target entryconfigure $i]
        set lab_name {}
		switch $type {
           cascade {
                # First thing to do is find the -menu entry an then
                # put out the right code. Following that go back and
                # process the rest of the cascade configure entries.
                set lab [$target entrycget $i -label] ;# Get label
                set lab_lower [string tolower $lab]
                set lab_name [vTcl:python_unique_menu_name "sub_menu"]
                set child [$target entrycget $i -menu]
                set widname_child [vTcl:widget_2_widname $child]
				set tearoff [$child cget -tearoff]
                if {$tearoff} {
                    set tearoff "tearoff=1"
                } else {
                    set tearoff "tearoff=0"
                }
                # The definition of the submenu required before it is
                # referenced in the add_cascade statement.
                set str ""
            
				append str \
                      "$vTcl(tab2)self.$lab_name = tk.Menu(self.$widname, "
				# Configure sub menu.
                set sub_menu_opts [$child configure]
                set op_str [vTcl:python_menu_options $sub_menu_opts]
				append str $op_str ")\n"
                append $ret_var [vTcl:split_line $str]
                # Generate the line of code which creates the
                # required reference.
                set image_name [vTcl:python_create_image $target $i]
         
				set str \
                        "$vTcl(tab2)self.$readable_name.add_cascade("

                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name]
                append str \
                        ",menu=self.$lab_name,"
                append str ")\n"
				append $ret_var [vTcl:split_line $str]
                # End of add_cascade statement.
                vTcl:python_process_menubutton $child $lab_name \
                    $lab_name $ret_var
                    # $lab_name vTcl(popup_code)

				append str \
                         "$vTcl(tab2)self.$readable_name.add_cascade("
            }
            command {
                set image_name [vTcl:python_create_image $target $i]
                set str "$vTcl(tab2)self.$widname.add_command("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n" 
				append $ret_var [vTcl:split_line $str]
           }
            separator {
                set image_name ""
                set str  \
					"$vTcl(tab2)self.$widname.add_separator("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n"
				append $ret_var [vTcl:split_line $str]
            }
            checkbutton {
                set image_name [vTcl:python_create_image $target $i]
				#set selectimage_name \
				#	[vTcl:python_create_image $target $i "-selectimage"]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$widname.add_checkbutton("
                append str [vTcl:python_menu_options \
							$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"
				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$widname.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}
            }
            radiobutton {
                set image_name [vTcl:python_create_image $target $i]
				#set selectimage_name \
					[vTcl:python_create_image $target $i "-selectimage"]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$widname.add_radiobutton("
                append str [vTcl:python_menu_options \
									$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"

				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$widname.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}				
            }
        }   ;# End of Switch
    }
    return $lab_name
}

proc vTcl:python_get_inner_frame {target} {
    global vTcl
    set output ""
    set pieces [split $target .]
    set max 0
    for {set i 1} {$i <= [llength $pieces]} {incr i} {
        set can [lindex $pieces $i]
        if {[string first "tix" $can] != -1} {
            set max $i
        }
    }
    if {$max > 2} {
        append f_name [lindex $pieces 2] "_" [lindex $pieces $max]
    } else {dp
        set f_name [lindex $pieces 2]
    }
     return f_name
}

proc vTcl:find_attribute {widget attribute} {
    global vTcl
    set config [$widget configure]
    foreach c  $config {
        if {[lindex $c 0] == $attribute} {
            return [lindex $c 4]
        }
    }
}

proc vTcl:python_process_me {command widget widname} {
    global vTcl
    set i [string first "%me" $vTcl($widget,$command)]
    set x $vTcl($widget,$command)
    set ind [string first "self." $widname]
    if {$ind > -1} {
        set widname [string range $widname 5 end]
    }
    if {$i > -1} {
        set head [string range $x 0  [expr $i - 1]]
        set tail [string range $x [expr $i + 3] end]
        set x $head
        append x "self.$widname"
        append x $tail
    }
    return $x
}

proc vTcl:python_load_cmd  {widget widname} {
    global vTcl
    if {[info exists vTcl($widget,-loadcommand)]} {
        set x [vTcl:python_process_me "-loadcommand" $widget $widname]
        append vTcl(py_initfunc) "$vTcl(tab2)$x\(self.$widname\)\n"
    }
}

proc vTcl:python_delete_leading_tabs {proc} {
    set p $proc
    set spaces ""
    while {[string first "\n" $p] == 0} {
        set p [string range $p 1 end]
        set spaces 1
    }
    while {[string first " " $p] == 0} {
        set p [string range $p 1 end]
        set spaces 1
    }
    while {[string first "\t" $p] == 0} {
        set p [string range $p 1 end]
        set spaces 1
    }
    if {$spaces == ""} {
        return $proc
    }
    return $p
}

proc vTcl:python_delete_lambda {proc} {
    set p $proc
    set p [regsub "lambda.*:" $p ""]
    set p [string trim $p]
    return $p
}

proc vTcl:python_indent_lines {proc} {
    global vTcl
global log
    set p $proc
    set rem  ""
    set tail $proc
    set lines ""
    while {[string first "\n" $tail] > -1} {
        set i [string first "\n" $tail]
        set head [string range $tail 0 $i]
        set tail [string range $tail [expr $i + 1] end]
        append rem $vTcl(tab) $head
        set lines 1
    }
    if {$lines == ""} {
        return proc
    }
    return $rem
}

proc vTcl:python_subst_tabs {proc} {
    global vTcl
    set p $proc
    set res ""
    set tabs ""
    while {[string first "\t" $p] > -1} {
        set i [string first "\t" $p]
        set head [string range $p 0 $i]
        set tail [string range $p [expr $i + 1] end]
        append p $head $vTcl(tab) $tail
        set tabs 1
    }
    if {$tabs == ""} {
        return $proc
    }
    return $p
}

proc vTcl:python_print_proc {proc} {
    set p $proc
    set i [string first "\t" $p]
    puts $p
}

proc vTcl:python_gui_startup {geom title classname} {
    global vTcl
    set start_gui ""
    if {$vTcl(import_module) != ""} {
        if {!$vTcl(imported_support_module)} {
            #append start_gui \
#"
#import $vTcl(import_name)
#"
            set vTcl(imported_support_module) 1
        }
    }
    # if {$vTcl(image_count)} {
    #     append start_gui "import os.path\n"
    # }
#    append start_gui \
#"
#def vp_start_gui():
#$vTcl(tab)'''Starting point when module is the main routine.'''
#$vTcl(tab)global val, w, root"
#     if {$vTcl(image_count)} {
# #        append start_gui \
# #"
# #$vTcl(tab)global prog_location
# #$vTcl(tab)prog_call = sys.argv\[0\]
# #$vTcl(tab)prog_location = os.path.split(prog_call)\[0\]\n"
#         append start_gui \
# "
# prog_call = sys.argv\[0\]
# prog_location = os.path.split(prog_call)\[0\]\n"
#     }
return $start_gui
if {$vTcl(image_count) == 0} {append start_gui "\n"}
    append start_gui  "$vTcl(tab)root = tk.Tk()\n"
    # root.title('$classname')"
    # Add the geometry stuff.
    #append start_gui $geom \
#"
#    root.geometry(geom)"

    if {$vTcl(global_variable)} {
        append start_gui \
"$vTcl(tab)$vTcl(import_name).set_Tk_var()\n"
    }
    append start_gui \
"$vTcl(tab)top = $classname (root)
"
    if {$vTcl(import_module) == "" } {
        append start_gui \
"
$vTcl(tab)init()
$vTcl(tab)root.mainloop()"
    } else {
        append start_gui \
"$vTcl(tab)$vTcl(import_name).init(root, top)
$vTcl(tab)root.mainloop()
"
    }
    append start_gui "\nw = None\n" "def create_$classname" \
                                "(rt, *args, **kwargs):\n"
    append start_gui \
    "$vTcl(tab)'''Starting point when module is imported by another module.\n"
    append start_gui \
"$vTcl(tab)   Correct form of call: 'create_$classname" \
    "(root, *args, **kwargs)' .'''
$vTcl(tab)global w, w_win, root"
#     if {$vTcl(image_count)} {
#         append start_gui \
# "
# $vTcl(tab)global prog_location
# $vTcl(tab)prog_call = sys.argv\[0\]
# $vTcl(tab)prog_location = os.path.split(prog_call)\[0\]\n"
#     }
if {$vTcl(image_count) == 0} {append start_gui "\n"}
    append start_gui \
"$vTcl(tab)#rt = root
$vTcl(tab)root = rt
$vTcl(tab)w = tk.Toplevel (root)"
#     append start_gui $geom \
#     w.title('$classname')"
# "
#     w.geometry(geom)"

if {$vTcl(global_variable)} {
        append start_gui \
"
${vTcl(tab)}$vTcl(import_name).set_Tk_var()"
    }
    append start_gui \
"
$vTcl(tab)top = $classname (w)"
    if {$vTcl(import_module) == "" } {
        append start_gui \
"
$vTcl(tab)init()
$vTcl(tab)return (w, top)"
    } else {
        append start_gui \
"
$vTcl(tab)$vTcl(import_name).init(w, top, *args, **kwargs)
$vTcl(tab)return (w, top)
"
    }
    append start_gui "\ndef destroy_$classname" "():"
    append start_gui \
"
$vTcl(tab)global w
$vTcl(tab)w.destroy()
$vTcl(tab)w = None
"
    return $start_gui
}

proc  vTcl:get_subwidget_options {widget hlist} {
    # This Proc puts options of the subwidget into the -options
    # string of the widget creation.  I think that I could have
    #used this in more places.
    global vTcl
    set w [$widget subwidget $hlist]
    set config [$w config]
    # The following loop was borrowed from vTcl:python_configure_widget
    # It needs to be modified to return not a configure call but a
    # list for -options.
    set options ""
    foreach c  $config {
        if {[llength $c] == 5 &&
            [string first "Cmd" [lindex $c 1]] ==  -1 &&
            [string first "command" [lindex $c 1]] ==  -1 &&
            [string first "Command" [lindex $c 1]] ==  -1 } {
            if {[lindex $c 3] != [lindex $c 4]} {
                set str [lindex $c 0]
                # get rid of the - sign.
                set len [string length $str]
                set sub [string range $str 1 [expr $len -1]]
                append options \
              "\\\n$vTcl(tab2)$vTcl(tab2)$hlist.[lindex $c 1] \"[lindex $c 4]\""
            }
        }
    }
    return $options
}


proc vTcl:python_nb_tab_configure {target tab} {
    # Ttk version of program to handle the setting of options for
    # Tnotebook.
    global vTcl
    set output ""
    set vTcl(encoding) ""
    set tab_options [$target tab $tab]
    foreach {opt val} $tab_options {
        set str [lindex $opt]
        # get rid of the - sign.
        set len [string length $str]
        set sub [string range $str 1 [expr $len -1]]
        switch $sub {
            underline {
				if {$val ne "-1"} {
					append output "$sub='''$val''',"
				}
			}
			state {
				if {$val ne "normal"} {
					append output "$sub='''$val''',"
				}
			}
            image {
				if {$val ne ""} {
					set vTcl(do_image) $val
				}
            }
			padding {
				if {$val ne 0} {
					append output "$sub='''$val''',"
				}
            }				
			sticky {
				if {$val ne "nsew"} {
					append output "$sub='''$val''',"
				}
            }				
            default {
                append output "$sub=\"$val\","
            }
        }
    }
    return $output
}

proc vTcl:tab_image {image} {
	global vTcl
	set file $vTcl(images,filename,$image)
	set file_name [regsub [pwd]/ $file ""] ;# Relative path.
	set image_ext [file extension $file_name]
	set image_name _img$vTcl(image_count)
	append vTcl(py_initfunc) \
		"$vTcl(tab2)photo_location =" \
		" os.path.join(_location,\"$file_name\")\n"

	append vTcl(py_initfunc) \
		"$vTcl(tab2)global $image_name\n"
	switch $image_ext {
		.png -
		.gif -
		.pgm {
			append vTcl(py_initfunc) \
				"$vTcl(tab2)$image_name = \
				 tk.PhotoImage(file=photo_location)\n"
		} ;# end of standard image formats
		default {
			# Where we handle the other types of images
			set vTcl(need_PIL) 1
			append vTcl(py_initfunc) \
				"$vTcl(tab2)$image_name =" \
				" ImageTk.PhotoImage(file=photo_location)\n"
			incr vTcl(need_PIL)
		}
	}
	incr vTcl(image_count)
	return $image_name
} ;# end V


proc vTcl:python_nb_page_configure {p widget widname name} {
    # Configures the option of the pageframe widget (TixNotebook)
    global vTcl
    set output ""
    set config [$widget pageconfigure $p]
    foreach c  $config {
        if {[llength $c] == 5 && [string first "cmd" [lindex $c 1]] ==  -1 } {
            if {[lindex $c 3] != [lindex $c 4]} {
                set str [lindex $c 0]
                # get rid of the - sign.
                set len [string length $str]
                set sub [string range $str 1 [expr $len -1]]
                append output \
                     ",$sub=\"[lindex $c 4]\""
            }
        }
    }
    return $output
}

proc vTcl:widget_2_widname {target} {
    # See if there is an alias defined, if so return it.  Otherwise,
    # transform the widget name by replacing the periods with '_'.
    # Originally, it was written assuming that the first character was
    # "." but it maybe something like $top which would throw off the
    # the indices 2 and 3 below.
    global vTcl widget
    # in case target is an alias, then just return it!
    if {[info exists vTcl(alias_names)]} {
        if {[lsearch -exact $vTcl(alias_names) $target] > -1} {
            return $target
        }
    }
    if {[catch {set alias $widget(rev,$target)}]} {
        # This is the otherwise path: no alias
        set pieces [split $target ".$"]
        set no [llength $pieces]
        set first [lindex $pieces 2]
        set sublist [lrange $pieces 3 end]
        set widname $first
        # What I am doing is risky. NEEDS WORK
        foreach p $sublist {
            set p_trim [string trim $p \"]
            append widname "_" $p_trim
        }
    } else {
        # Work on the alias rather than the target value. Replace
        # blanks with '_' in the alias.
        #set pieces [split $alias]
        set pieces [regexp -all -inline {\S+} $alias]
        set widname [lindex $pieces 0]
        if {[llength $pieces] > 1} {
            set sublist [lrange $pieces 1 end]
            foreach p $sublist {
                set p_trim [string trim $p]
                append widname "_" $p_trim
            }
        }
        lappend vTcl(alias_names) $widname
    }
    return $widname
}

proc vTcl:python_set_alias {target name} {
    # Sees if an alias exists and if so put out an assignment in the
    #  wrong place.  This needs to be fixed.  NEEDS WORK
    global vTcl widget
    if {[catch {set alias $widget(rev,$target)}]} {
        return
    } else {
        # Don't put out this statement, Try a comment instead.
        append vTcl(py_initfunc) \
                "$vTcl(tab2)$alias = $name  \# alias $target\n"
    }
}

proc vTcl:python_alias {alias target} {
    # Update the current value of alias when the
    # alias field in the attribute editor is changed.
    # Never called ??
    global widget
    global vTcl widget
    catch {
        unset widget($was)
        unset widget(rev,$target)
    }
    if {$alias != ""} {
        set widget($alias) $target
        set widget(rev,$target) $alias
    }
}

proc vTcl:python_dump_bind {target widname} {
    # This is a take off from vTcl:dump_widget_bind
    global vTcl
    set class [vTcl:get_class $target]
    # set needle [string first "Scrolled" $class]
    # if {$needle > -1}  {
    #     set result [vTcl:python_dump_bind $target.01 $widname]
    #     return $result
    # }
    set result ""
    if {[catch {bindtags $target \{$vTcl(bindtags,$target)\}}]} {
        return ""
    }
    set bindlist [lsort [bind $target]]
    foreach i $bindlist {
        if {$i == "<<SetBalloon>>"} continue
        set command [bind $target $i]
        set command [string trim $command]
		if {[regexp "(lambda.*:)(.*)" $command match lambda_part name]} {
            # We have a lambda function so there separate out the
            # callback name and add to the function list to be
            # created.

            # This is the only condition which will occur for popup
            # menus and so for a popup I call a special routine rather
            # than have a big if bock here.
            set class [vTcl:get_class $target]
			# if {[string first "pop" $name] > -1} { }
			if {$i eq "<Button-3>"} {
                # Binding refers to popup menu so we put out special
                # case code and leave.
# dpr command				
#                 if {[string first "self" $name] == -1} {
#                     regsub "popup" $command "self.popup" cmd
# dpr cmd
# bp Z
# 				} else {
#                     set cmd $command
#                 }
                #set cmd [vTcl:prepend_import_name $command $widname]
                # set cmd "self.$command"
                append cmd ${lambda_part} " " self.${name}
                if {$class == "Toplevel"} {
                    set b_name top
                } else {
                    set b_name self.$widname
                }

                append result \
"$vTcl(tab2)if ($vTcl(import_name).root.tk.call('tk', 'windowingsystem')=='aqua'):
$vTcl(tab2)$vTcl(tab)$b_name.bind('<Control-1>', $cmd)
$vTcl(tab2)$vTcl(tab)$b_name.bind('<Button-3>', $cmd)
$vTcl(tab2)else:
$vTcl(tab2)$vTcl(tab)$b_name.bind('<Button-3>', $cmd)
"
#return $result
                continue
            }
            set name [string trim $name]
            lappend vTcl(funct_list) $name
        } else {
            # If I got here then the command is not a lambda function
            # but rather a function name is added it to the list of
            # functions to generate. However one still need to have at
            # least one parameter which is the event.  If there were
            # more parameters then we would have been in the lambda
            # branch above where there would have been the event
            # variable.
            if {$command != "_mouse_over" &&
                $command != "_button_press" &&
                $command != "_button_release"} {
                set name [string trim $command]
                append name "(e)"
                lappend vTcl(funct_list) $name
            }
        }
        if {"$vTcl(bind,ignore)" == "" ||
            ![regexp "^($vTcl(bind,ignore))" $command] } {
            if { ![regexp "focus" $command] } { # This if is another of
                                                # those tix hacks._e,
                # Special case for PNotebooks.  The command is in the GUI module.
                if {$class != "PNotebook"} {
                    set command [vTcl:prepend_import_name $command]
                } elseif {$command != "_mouse_over" &&
                          $command != "_button_press" &&
                          $command != "_button_release" &&
                          $i != "<<SetBalloon>>"} {
                    set command [vTcl:prepend_import_name $command]
                }
                if {$class == "Toplevel"} {
                    append result \
                        "$vTcl(tab2)top.bind('$i',$command)\n"
                } elseif {$i eq "<Map>" && $class in {TPanedwindow}} {
                    continue
                } else {
                    append result \
                        "$vTcl(tab2)self.$widname.bind('$i',$command)\n"
                }
            }
        }
    }
    bindtags $target vTcl(b)
    return $result
}

proc x_compare {a b} {
    set alast [lindex $a end]
    set blast [lindex $b end]/home/rozen/pkg/idleX/idlex-1.12
    if {$alast <= $blast} {
        return -1
    } else {
        return 1
    }
}

proc vTcl:sort_menubuttons {} {
    global vTcl
    set sort_list {}
    foreach i $vTcl(menubutton_list) {
        set x [winfo x $i]
        set item [list $i $x]
        lappend sort_list $item
    }
    set new [lsort -command x_compare $sort_list
    return $new
}

proc vTcl:python_idle_checks {filename}  {
    #Checks to see if GUI changed since Python Generated so ask if
    #user really wants to execute the GUI code.
    global vTcl
return
    if {$vTcl(gui_py_change_time) < $vTcl(gui_change_time)} {
        set question "GUI definition has been changed since GUI module created. Do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                         question 0 "Cancel" "Proceed"]
        if {$choice == 0} {
            return "BAIL"
        }
    }
    if {[info exists vTcl(source_window)]} {
        set new_content [$vTcl(source_window) get 1.0 end] ;# Read
                                                            # contents
                                                            # of
                                                            # Python
                                                            # Console
        if {[vTcl:test_file_content $filename $new_content] == 1} {  NEEDS WORK
            set question "Python Console with GUI module has changed since last save; do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                         question 0 "Cancel" "Proceed"]
            if {$choice == 0} {
                return "BAIL"
            }
        }
    }
    return ""
}

proc vTcl:load_python_idle {} {
    global vTcl
    if { $vTcl(ide_cmd) == ""} {
        ::vTcl::MessageBox -title Error -message "No IDE command has been specified."
        return
    }
    if {! $vTcl(project_specified)} {
        set choice [tk_dialog .foo "ERROR" \
                        "No project specified. \nNot opening IDE." \
                        question 0 "OK"]
        return
    }
    if {$vTcl(change)} {
        vTcl:save
        set vTcl(change) 0
    }
    set fg "[file rootname $vTcl(project,file)].py"
    set fs "[file rootname $vTcl(project,file)]_support.py"
    if {[vTcl:python_idle_checks $fg] == "BAIL"} return
    set fs_exists [file exists $fs]
    set fg_exists [file exists $fg]
    if {!$fs_exists && !$fg_exists} {
        set msg "No GUI or support files."
        tk_dialog .foo "Warning" \
            "No GUI or support module has been saved." \
            question 0 "OK"
        return
    }
    if {[winfo exists .vTcl.gui_console] &&
        $vTcl(gui_save_warning) != ""} {
        set question "GUI console contains unsaved changes. Do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                         question 0 "Cancel" "Proceed"]
        if {$choice == 0} {
            return "BAIL"
        }
    }
    if {[winfo exists .vTcl.supp_console] &&
        $vTcl(supp_save_warning) != ""} {
        set question "Support console contains unsaved changes. Do you want to proceed or cancel?"
        set choice [tk_dialog .foo "Warning" $question \
                         question 0 "Cancel" "Proceed"]
        if {$choice == 0} {
            return "BAIL"
        }
    }
    set result ""
    if {[file exists $fs] && [file exists $fg]} {
        #catch {exec $vTcl(ide_cmd) $fs $fg} result
        exec $vTcl(ide_cmd) $fs $fg "&"
        return
    }
    if {[file exists $fs]} {
        #catch {exec $vTcl(ide_cmd) $fs} result
        exec $vTcl(ide_cmd) $fs
        return
    }
    if {[file exists $fg]} {
        set show_gui 0
        #catch {exec $vTcl(ide_cmd) $fg} result
        exec $vTcl(ide_cmd) $fg
        return
    }
    ::vTcl::MessageBox -title Error -message "No project files exist to be loaded."
}

proc vTcl:load_console {prefix file} {
    # This loads the console from memory.  I used to issue a warning
    # about overwriting an existing console but I abandoned that
    # because of too many messages.
    global vTcl
    vTcl:Window.py_console $prefix
    update
    $vTcl(${prefix}_source_window) delete 1.0 end
    $vTcl(${prefix}_output_window) delete 1.0 end
    set fid [open $file r]
    set contents [read $fid]
    set numbered [vTcl:add_line_numbers $contents]

    $vTcl(${prefix}_source_window) insert end $numbered
    set vTcl(${prefix}_search_pattern) ""
    close $fid
    if {$prefix == "supp"} {
        set vTcl(imported_variable) 0        ;# Moved init stuff here 12/18/15
        set vTcl(support_variable_list)  []
        set vTcl(support_function_list)  []
        set vTcl(import_filename) $file
    }
    vTcl:colorize_python $prefix
    set vTcl(${prefix}_save_warning) ""
    $vTcl(${prefix}_source_window) edit modified 0
}


proc vTcl:load_python_consoles {} {
    # Loads existing project into the two python consoles.
    global vTcl
    if {! $vTcl(project_specified)} {
        set choice [tk_dialog .foo "ERROR" \
                        "No project specified. \nExiting" \
                        question 0 "OK"]
        return
    }
    set fg "[file rootname $vTcl(project,file)].py"
    set fs "[file rootname $vTcl(project,file)]_support.py"
    if {[vTcl:python_idle_checks $fg] == "BAIL"} return
    set fs_exists [file exists $fs]
    set fg_exists [file exists $fg]
    if {!$fs_exists && !$fg_exists} {
        set msg "No GUI or support files."
        tk_dialog .foo "Warning" \
            "No GUI or support module has been saved." \
            question 0 "OK"
        return
    }
    if {$vTcl(change)} {
        vTcl:save
        set vTcl(change) 0
    }
    if {[file exists $fs] && [file exists $fg]} {
        vTcl:load_console "gui" $fg
        vTcl:load_console "supp" $fs
        update
        set vTcl(gui_save_warning) ""
        set vTcl(supp_save_warning) ""
        return
    }
    if {[file exists $fs]} {
        vTcl:load_console "supp" $fs
        update
        set vTcl(gui_save_warning) ""
    }
    if {[file exists $fg]} {
        vTcl:load_console "gui" $fg
        update
        set vTcl(supp_save_warning) ""
    }
}

proc vTcl:clean_string {str} {
    # Replace characters that would be illegal in a Python2 identifier
    # with '_'.
    for {set i 0} {$i<[string length $str]} {incr i} {
        set char [string index $str $i]
        set ret [regexp {\w} $char]
        if {$ret == 0} {
            set str [string replace $str $i $i "_"]
        }
    }
    return $str
}

# For debugging purposes.
proc printenv { args } {
    global env
    set maxl 0
    if {[llength $args] == 0} {
        set args [lsort [array names env]]
    }
    foreach x $args {
        if {[string length $x] > $maxl} {
            set maxl [string length $x]
        }
    } incr maxl 2
    foreach x $args {
        puts stdout [format "%*s = %s" $maxl $x $env($x)]
    }
}

proc vTcl:calc_relative_geometry {target} {
    # Convert the geometry from absolute to relative.
    # Also called during code generation.
    global vTcl
    global rel

    set parent_window [winfo parent $target]

    ### Have to play games with the TNotebook because only one of the
    ### children widgets is mapped and the geometry of unmapped widget
    ### is unusable. So we go to the grand parent and run thru the
    ### tabs to find the one that is mapped and use its geometry. 4/3/17

    if { [catch {set grand_parent_window [winfo parent $parent_window]}]} {
        set grand_parent_window ""
    }
    if {$grand_parent_window != ""} {
        set gpc [winfo class $grand_parent_window]
    } else {
        set gpc ""
    }
    # if {$gpc in {TNotebook PNotebook}} {
    #     # We're here because the target is in the enclosing frame of a
    #     # notebook tab.
    #     if {[info exists vTcl(mapped,$parent_window)]} {
    #         # Here because the containing tab has been mapped at some
    #         # point in the session. So we can just get its geometry.
    #         set parent_geometry [winfo geometry $parent_window]
    #     } else {
    #         # Here because we may loaded the project and never looked
    #         # at the parent tab. In this case we to make the tab the
    #         # active widget. Then we can get the geometry. To keep
    #         # things moving along, we short circuit updating the
    #         # Attribute Editor.
    #         set vTcl(skip_AE_update) 1
    #         #vTcl:active_widget $parent_window
    #         set vTcl(skip_AE_update) 0
    #         set parent_geometry [winfo geometry $parent_window]

    #     }
    # } else {
    #     set parent_geometry [winfo geometry $parent_window]
    # }
    set parent_geometry [winfo geometry $parent_window]
    # Now set up the geometry values
    foreach {w h x y} [split [winfo geometry $target] "x+"] {}
    foreach {W H X Y} [split $parent_geometry "x+"] {}  ;# new 4/3/17
    set rel(x) $x
    set rel(y) $y
    set rel(h) $h
    set rel(w) $w
    set relx [expr $x / $W.0]
    set rel(relx) [expr {round($relx*1000)/1000.0}]
    set rely [expr $y / $H.0]
    set rel(rely) [expr {round($rely*1000)/1000.0}]
    set relw [expr $w / $W.0]
    set rel(relw) [expr {round($relw*1000)/1000.0}]
    set relh [expr $h / $H.0]
    set rel(relh) [expr {round($relh*1000)/1000.0}]
}

proc vTcl:parent_geometry {target} {
    # This called from vTcl:resize_tseparator in dragsize.tcl
    # Return geometry string of parent.
    foreach {w h x y} [split [winfo geometry $target] "x+"] {}
    set parent_window [winfo parent $target]
    ### Have to play games with the TNotebook because only one of parent.
    ### children widgets is mapped and the geometry of unmapped widget
    ### is unusable. So we go to the grand parent and run thru the
    ### tabs to find the one that is mapped and use its geometry. 4/3/17
    if { [catch {set grand_parent_window [winfo parent $parent_window]}]} {
        set grand_parent_window ""
    }
    if {$grand_parent_window != ""} {
        set gpc [winfo class $grand_parent_window]
    } else {
        set gpc ""
    }
    if {$gpc in {TNotebook PNotebook}} {
        foreach t [$grand_parent_window tabs] {
            if {[set parent_geometry [winfo geometry $t]] != "1x1+0+0"} {
                break
            }
        }
    } else {
        set parent_geometry [winfo geometry $parent_window]
    }
    return $parent_geometry
}

proc vTcl:add_lambda {cmd} {
    # Called when processing command options.
    # Checks to see if a lambda is necessary and if so creates the
    # lambda function.
    if {[string first "lambda" $cmd] > -1} { return $cmd}
    if {[regexp {\([0-9, ]*\)$} $cmd]} {
        # Arguments are present and they are integers.
        return "lambda:$cmd"
    }
    if {![regexp {\(.*\)$} $cmd]} {
        # No Arguments, just return input.
        return $cmd
    }
    set new_plist ""
    regexp {(.*)\((.*)\)} $cmd match name parms
    set p_list [split $parms ","] foreach p $p_list {
        set p [string trim $p]
        if {[string is integer $p]} { continue }   ;# Number
        if {[regexp {^['"].*['"]$} $p]} { continue } ;# Quoted string
        if {[regexp {^[0-9.]+$} $p]} { continue } ;# Decimal
        set msg "No GUI or support files."
        tk_dialog .foo "Warning" \
            "Suspect parameter $p found in command option $cmd." \
            question 0 "OK"
        return
        #append new_plist $p ", "
    }
    append new_cmd "lambda " $new_plist ":" $match
    return $new_cmd
}


proc vTcl:python_parse_menubutton {menubutton widname {suffix m}} {
    global vTcl
    foreach widget [winfo children $menubutton] {
        if {[winfo class $widget]=="Menu"} {
            set nritems [$widget index end]
            for {set i 0} {$i<=$nritems} {incr i} {
                switch [$widget type $i] {
                    command {
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname==""} {
                            set cmdname "$widname\_$i\_click"
                        }
                        append vTcl(py_initfunc) \
                            "$vTcl(tab2)self.$widname\_m$suffix.add_command(label="
                        append vTcl(py_initfunc) \
                            "\"[$widget entrycget $i -label]\","
                        # added to add the accelerator capability.
                        if {[$widget entrycget $i -accel] != ""} {
                            append vTcl(py_initfunc) \
                                "accel=\"[$widget entrycget $i -accel]\","
                        }
                        append vTcl(py_initfunc) \
                            "command=$cmdname,underline=0)\n"
                        set v $cmdname
                        if {[string first "(" $v] == -1} {
                            append v "()"
                        }
                        lappend vTcl(funct_list) $v
                    }
                    checkbutton { # Like to put in more options
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname == ""} {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_checkbutton(label=\"[$widget entrycget $i -label]\""
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    "accel=\"[$widget entrycget $i -accel]\""
                            }
                        } else {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_checkbutton(label=\"[$widget entrycget $i -label]\",command=$cmdname"
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }
                        }
                        append vTcl(py_initfunc) ")\n"
                    }
                    radiobutton { # Like to put in more options
                        vTcl:py_get_command_parameters \
                            [$widget entrycget $i -command]
                        if {$cmdname == ""} {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_radiobutton(label=\"[$widget entrycget $i -label]\""
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }
                        } else {
                            append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_radiobutton(label=\"[$widget entrycget $i -label]\",command=$cmdname"
                            if {[$widget entrycget $i -accel] != ""} {
                                append vTcl(py_initfunc) \
                                    ",accel=\"[$widget entrycget $i -accel]\""
                            }                        }
                        append vTcl(py_initfunc) ")\n"
                    }
                    separator {
                        append vTcl(py_initfunc)  \
                            "$vTcl(tab2)self.$widname\_m$suffix.add_separator()\n"
                    }
                    cascade {
                        set incsuffix ""
                        append incsuffix "m$suffix" "_cas$suffix"
                        append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_$incsuffix = "
                        append vTcl(py_initfunc) \
                                "Menu(self.$widname\_m$suffix)\n"
                        append vTcl(py_initfunc) \
                                "$vTcl(tab2)self.$widname\_m$suffix.add_cascade(label=\"[$widget entrycget $i -label]\","
                        if {[$widget entrycget $i -accel] != ""} {
                            append vTcl(py_initfunc) \
                                    "accel=\"[$widget entrycget $i -accel]\","
                        }
                        append vTcl(py_initfunc) \
                                "menu=self.$widname\_$incsuffix)\n"
                        set arg_suffix ""
                        append arg_suffix $suffix "_cas$suffix"
                        vTcl:python_parse_menu $widget $widname \
                                $arg_suffix
                    }
                }
            }
        }
    }
}

# Picked up from version 8.1t
proc vTcl:python_process_popup_menu {target widname parent readable_name} {
    # This is a recursive proc to translate the menu stuff in
    # python. When we get to a menu item which is a cascade we so that
    # item and then recurse into the new cascade menu. It calls
    # vTcl:python_create_image to determine if the item contains an
    # image and to generate the needed extra reference to the
    # PhotoImage object (see
    # http://effbot.org/tkinterbook/photoimage.htm for an example.)
    # and then calls vTcl:python_menu_options to process the options
    # for the menu entry.
	# This is called from vTcl:python_generate_context_menu.
    global vTcl
	if {[string first .# $target] >= 0} {return}
    set entries [$target index end]
    if {$entries == "none"} {return}
	set skip_declaration 0
	set ret_var vTcl(popup_code)
    set result ""
	append str "$vTcl(tab2)self.$readable_name = tk.Menu(self.$parent," 
	set opt [$target configure]
	append str 	[vTcl:python_menu_options $opt]
	append str ")\n"
	append $ret_var [vTcl:split_line $str]
	for {set i 0} {$i<=$entries} {incr i} {
        set type [$target type $i]
        set opts [$target entryconfigure $i]
        set lab_name {}
		switch $type {
            cascade {
                # First thing to do is find the -menu entry an then
                # put out the cright code. Following that go back and
                # process the rest of the cascade configure entries.
                set lab [$target entrycget $i -label] ;# Get label
                set lab_lower [string tolower $lab]
                set lab_name [vTcl:python_unique_menu_name "sub_menu"]
                set child [$target entrycget $i -menu]
                set widname_child [vTcl:widget_2_widname $child]
				set tearoff [$child cget -tearoff]
                if {$tearoff} {
                    set tearoff "tearoff=1"
                } else {
                    set tearoff "tearoff=0"
                }
                # The definition of the submenu required before it is
                # referenced in the add_cascade statement.
                set str ""
                set image_name [vTcl:python_create_image $target $i]
				vTcl:python_process_popup_menu $child $widname $widname $lab_name
				set str \
                        "$vTcl(tab2)self.$readable_name.add_cascade("
                # This is passing opts which are the options for the
                # cascade entry which are different from the options
                # to the sub menu.
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name]
                append str \
                        ",menu=self.$lab_name,"
                append str ")\n"
				append $ret_var [vTcl:split_line $str]
            }
            command {
			    set image_name [vTcl:python_create_image $target $i]
                set str "$vTcl(tab2)self.$readable_name.add_command("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n" 
				append $ret_var [vTcl:split_line $str]
           }
            separator {
                set image_name ""
                set str  "$vTcl(tab2)self.$readable_name.add_separator("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n"
				append $ret_var [vTcl:split_line $str]
            }

            checkbutton {
                set image_name [vTcl:python_create_image $target $i]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$readable_name.add_checkbutton("
                append str [vTcl:python_menu_options \
									$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"
				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$readable_name.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}
            }
		    radiobutton {
                set image_name [vTcl:python_create_image $target $i]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$readable_name.add_radiobutton("
                append str [vTcl:python_menu_options \
									$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"

				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$widname.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}				
            }
        }   ;# End of Switch
    }
    return $lab_name
} ;# end vTcl:python_process_popup_menu

proc vTcl:python_generate_context_menu {root_list} {
    # Generate source strings for the context (popup) menu.
    global vTcl widget
	set vTcl(popup_function_names) [list]
    set popups [lsearch -all -inline $root_list "*.pop*"]
    if {[llength $popups]} {append vTcl(popup_code) "\n"}
    foreach popup $popups {
        if {$popup eq ".vTcl"} {
            continue
        }
		regexp {^\.top\d+} root_list top_part
        set widname  $widget(rev,$popup)
        incr vTcl(no_popup)
        set name popup${vTcl(no_popup)}
		# set name [vTcl:at ::widgets::${popup}::proc]
		set name [vTcl:at ::widgets::${popup}::ClassOption(-proc)]		

		vTcl:seek_menu_variables $popup
		lappend vTcl(popup_function_names) $name ;# Keep track of funct. names.
            append vTcl(popup_code) "${vTcl(tab)}def $name"
            append vTcl(popup_code) "(self, event, *args, **kwargs):\n"
        # Now know vTcl(p_v_list) so we can putout the global statements.
		# But first remove any duplicates
		set vTcl(p_v_list) [lsort -index 0 -unique $vTcl(p_v_list)]
		foreach {var type target} $vTcl(p_v_list) {
                append vTcl(popup_code) "$vTcl(tab2)global $var\n"
                append vTcl(popup_code) "$vTcl(tab2)$var = tk.${type}()\n"
        }

        # Now to process the menu.  This code generates the actual
        # menu entries in vTcl(popup_code) and are added below.
        set vTcl(in_popup) 1
		set vTcl(firstIteration) 1		
		vTcl:python_process_popup_menu $popup $widname top $widname
		
        append vTcl(popup_code) \
           "$vTcl(tab)$vTcl(tab)self.$widname.post(event.x_root, event.y_root)\n"
        append vTcl(popup_code) "\n"
        set vTcl(in_popup) 0
        if {[info exists vTcl(toplevel_config)]} {
            unset vTcl(toplevel_config)
        }
    }
    set vTcl(in_popup) 0	
}

proc vTcl:python_process_menu {target widname {readable_name {}}
                               {ret_var {vTcl(py_initfunc)}}} {
    # This is a recursive proc to translate the menu stuff in
    # python. When we get to a menu item which is a cascade we so that
    # item and then recurse into the new cascade menu. It calls
    # vTcl:python_create_image to determine if the item contains an
    # image and to generate the needed extra reference to the
    # PhotoImage object (see
    # http://effbot.org/tkinterbook/photoimage.htm for an example.)
    # and then calls vTcl:python_menu_options to process the options
    # for the menu entry.
    global vTcl
    if {[string first .# $target] >= 0} {return}
    set entries [$target index end]
    if {$entries == "none"} {return}
    set result ""
    if {$readable_name == ""} {
        set widname [vTcl:widget_2_widname $target]
    } else {
        set widname $readable_name
    }
    for {set i 0} {$i<=$entries} {incr i} {
        set type [$target type $i]
        if {[info exists vTcl(toplevel_menu)] &&
            $target == $vTcl(toplevel_menu)} {
            if {$type == "tearoff"} {
                # tearoff at toplevel doesn't really mean anything,
                # but let the user specify it anyway.
                continue
            }
        }
        set opts [$target entryconfigure $i]
        set lab_name {}
        switch $type {
            cascade {
                # First thing to do is find the -menu entry an then
                # put out the right code. Following that go back and
                # process the rest of the cascade configure entries.
                set lab [$target entrycget $i -label] ;# Get label
                set lab_lower [string tolower $lab]
                set lab_name [vTcl:python_unique_menu_name "sub_menu"]
                set child [$target entrycget $i -menu]
                set widname_child [vTcl:widget_2_widname $child]
				set tearoff [$child cget -tearoff]
                if {$tearoff} {
                    set tearoff "tearoff=1"
                } else {
                    set tearoff "tearoff=0"
                }
                # The definition of the submenu required before it is
                # referenced in the add_cascade statement.
                set str ""
                if {$vTcl(in_popup)} {
                    append str \
                      "$vTcl(tab2)self.$lab_name = tk.Menu(self.$widname, "
					# "$vTcl(tab2)self.$lab_name = tk.Menu($widname, "
                } else {
                    # Creates the sub menu widget.
                    append str \
                      "$vTcl(tab2)self.$lab_name = tk.Menu(self.$widname, "
                        # GDW 9/27/22
                        #"$vTcl(tab2)self.$lab_name = tk.Menu($widname, "
                }
                # Configure sub menu.
                set sub_menu_opts [$child configure]
                set op_str [vTcl:python_menu_options $sub_menu_opts]
				append str $op_str ")\n"
                append $ret_var [vTcl:split_line $str]
                # Generate the line of code which creates the
                # required reference.
                set image_name [vTcl:python_create_image $target $i]
                if {$vTcl(in_popup)} {
				set str \
                        "$vTcl(tab2)self.$readable_name.add_cascade("
				} else {
					set str \
                        "$vTcl(tab2)self.$readable_name.add_cascade("
				}
                # This is passing opts which are the options for the
                # cascade entry which are different from the options
                # to the sub menu.
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name]
                append str \
                        ",menu=self.$lab_name,"
                append str ")\n"
				append $ret_var [vTcl:split_line $str]
                # End of add_cascade statement.
                vTcl:python_process_menu $child $lab_name \
                    $lab_name $ret_var
                    # $lab_name vTcl(popup_code)
            }
            command {
                set image_name [vTcl:python_create_image $target $i]
                set str "$vTcl(tab2)self.$widname.add_command("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n" 
				append $ret_var [vTcl:split_line $str]
           }
            separator {
                set image_name ""
                set str  \
					"$vTcl(tab2)self.$widname.add_separator("
                append str [vTcl:python_menu_options \
                                $opts "" $lab_name $image_name] ")\n"
				append $ret_var [vTcl:split_line $str]
            }
            checkbutton {
                set image_name [vTcl:python_create_image $target $i]
				#set selectimage_name \
				#	[vTcl:python_create_image $target $i "-selectimage"]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$widname.add_checkbutton("
                append str [vTcl:python_menu_options \
									$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"
				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$widname.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}
            }
            radiobutton {
                set image_name [vTcl:python_create_image $target $i]
				#set selectimage_name \
					[vTcl:python_create_image $target $i "-selectimage"]
				set selectimage_name $image_name
                set str "$vTcl(tab2)self.$widname.add_radiobutton("
                append str [vTcl:python_menu_options \
									$opts "" $lab_name $image_name]
                append $ret_var [vTcl:split_line $str] ")\n"

				if {$selectimage_name ne ""} {
					incr i
					set str \
						"$vTcl(tab2)self.$widname.entryconfig(\
						$i,selectimage=$selectimage_name"
					append $ret_var [vTcl:split_line $str] ")\n"
				}				
            }
        }   ;# End of Switch
    }
    return $lab_name
}

