# Python wrapper for executing PAGE. Running under Python removes the
# requirement of installing Tcl/Tk. Python 3 is required for running
# PAGE and the Python modules generated by PAGE.

import sys
import os, os.path

try:
    import tkinter as tk
    py_version = 3
except ImportError:
    import Tkinter as tk
    import tkMessageBox
    py_version = 2
    print("py_version = %s" % py_version)
    if py_version < 3:
        root = tk.Tk()
        root.withdraw()
        tkMessageBox.showerror("Error", "Python 3 required!\nExiting.")
        sys.exit(1)
        root.mainloop()

root = tk.Tk()
root.withdraw()

root.tk.eval('set argv {}; set argc 0')
p = os.path.abspath(sys.argv[0])
cmd = "source {" + os.path.join(os.path.dirname(p), 'page.tcl') + "}"

for a in sys.argv[1:]: # Skip argv[0] (the filename of this script)
    # root.tk.eval(f'lappend argv {{{a}}}; incr argc')
    root.tk.eval("lappend argv {%s}; incr argc" % a)

try:
    root.tk.eval(cmd)
    sys.exit()
except:
    pass

root.mainloop()

