#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# GUI module generated by PAGE version 7x
#  in conjunction with Tcl version 8.6
#    Oct 01, 2021 02:41:17 PM CDT  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import searcher_support

class searcher:
    def __init__(self, top=None):
        '''This class configures and populates the toplevel window.
           top is the toplevel containing window.'''
        _bgcolor = '#d9d9d9'  # X11 color: 'gray85'
        _fgcolor = '#000000'  # X11 color: 'black'
        _compcolor = '#d9d9d9' # X11 color: 'gray85'
        _ana1color = '#d9d9d9' # X11 color: 'gray85'
        _ana2color = '#d9d9d9' # X11 color: 'gray85'
        self.style = ttk.Style()
        if sys.platform == "win32":
            self.style.theme_use('winnative')
        self.style.configure('.',background=_bgcolor)
        self.style.configure('.',foreground=_fgcolor)
        self.style.configure('.',font="TkDefaultFont")
        self.style.map('.',background=
            [('selected', _compcolor), ('active',_ana2color)])

        top.geometry("767x541+703+206")
        top.minsize(1, 1)
        top.maxsize(1265, 770)
        top.resizable(1,  1)
        top.title("Searcher")
        top.configure(highlightcolor="black")

        self.top = top
        self.FilePath = tk.StringVar()
        self.VchkMP3 = tk.IntVar()
        self.VchkWAV = tk.IntVar()
        self.VchkOGG = tk.IntVar()
        self.VchkAVI = tk.IntVar()
        self.VchkMKV = tk.IntVar()
        self.VchkMP4 = tk.IntVar()

        self.frameTop = tk.Frame(self.top)
        self.frameTop.place(relx=0.005, rely=0.007, relheight=0.49
                , relwidth=0.992)
        self.frameTop.configure(relief='groove')
        self.frameTop.configure(borderwidth="2")
        self.frameTop.configure(relief="groove")

        self.Label1 = tk.Label(self.frameTop)
        self.Label1.place(relx=0.053, rely=0.098, height=19, width=99)
        self.Label1.configure(activebackground="#f9f9f9")
        self.Label1.configure(text='''Path to search:''')

        self.txtPath = tk.Entry(self.frameTop)
        self.txtPath.place(relx=0.184, rely=0.075, height=31, relwidth=0.52)
        self.txtPath.configure(background="white")
        self.txtPath.configure(font="TkFixedFont")
        self.txtPath.configure(selectbackground="#c4c4c4")
        self.txtPath.configure(textvariable=self.FilePath)

        self.btnSearchPath = tk.Button(self.frameTop)
        self.btnSearchPath.place(relx=0.71, rely=0.083, height=27, width=38)
        self.btnSearchPath.configure(activebackground="#d9d9d9")
        self.btnSearchPath.configure(command=searcher_support.OnBtnSearchPath)
        self.btnSearchPath.configure(text='''...''')

        self.btnExit = tk.Button(self.frameTop)
        self.btnExit.place(relx=0.854, rely=0.075, height=37, width=79)
        self.btnExit.configure(activebackground="#d9d9d9")
        self.btnExit.configure(text='''Exit''')
        self.btnExit.bind('<Button-1>',lambda e:searcher_support.OnBtnExit(e))

        self.Labelframe1 = tk.LabelFrame(self.frameTop)
        self.Labelframe1.place(relx=0.092, rely=0.226, relheight=0.698
                , relwidth=0.329)
        self.Labelframe1.configure(relief='groove')
        self.Labelframe1.configure(text='''Audio Files''')

        self.chkMP3 = tk.Checkbutton(self.Labelframe1)
        self.chkMP3.place(relx=0.12, rely=0.162, relheight=0.124, relwidth=0.476
                , bordermode='ignore')
        self.chkMP3.configure(activebackground="#d9d9d9")
        self.chkMP3.configure(anchor='w')
        self.chkMP3.configure(justify='left')
        self.chkMP3.configure(text='''.MP3''')
        self.chkMP3.configure(variable=self.VchkMP3)

        self.chkWAV = tk.Checkbutton(self.Labelframe1)
        self.chkWAV.place(relx=0.12, rely=0.27, relheight=0.124, relwidth=0.476
                , bordermode='ignore')
        self.chkWAV.configure(activebackground="#d9d9d9")
        self.chkWAV.configure(anchor='w')
        self.chkWAV.configure(justify='left')
        self.chkWAV.configure(text='''.WAV''')
        self.chkWAV.configure(variable=self.VchkWAV)

        self.chkOGG = tk.Checkbutton(self.Labelframe1)
        self.chkOGG.place(relx=0.12, rely=0.378, relheight=0.124, relwidth=0.476
                , bordermode='ignore')
        self.chkOGG.configure(activebackground="#d9d9d9")
        self.chkOGG.configure(anchor='w')
        self.chkOGG.configure(justify='left')
        self.chkOGG.configure(text='''.OGG''')
        self.chkOGG.configure(variable=self.VchkOGG)

        self.Labelframe2 = tk.LabelFrame(self.frameTop)
        self.Labelframe2.place(relx=0.42, rely=0.226, relheight=0.698
                , relwidth=0.329)
        self.Labelframe2.configure(relief='groove')
        self.Labelframe2.configure(text='''Video Files''')

        self.chkAVI = tk.Checkbutton(self.Labelframe2)
        self.chkAVI.place(relx=0.08, rely=0.162, relheight=0.124, relwidth=0.532
                , bordermode='ignore')
        self.chkAVI.configure(activebackground="#d9d9d9")
        self.chkAVI.configure(anchor='w')
        self.chkAVI.configure(justify='left')
        self.chkAVI.configure(text='''.AVI''')
        self.chkAVI.configure(variable=self.VchkAVI)

        self.chkMKV = tk.Checkbutton(self.Labelframe2)
        self.chkMKV.place(relx=0.08, rely=0.27, relheight=0.124, relwidth=0.532
                , bordermode='ignore')
        self.chkMKV.configure(activebackground="#d9d9d9")
        self.chkMKV.configure(anchor='w')
        self.chkMKV.configure(justify='left')
        self.chkMKV.configure(text='''.MKV''')
        self.chkMKV.configure(variable=self.VchkMKV)

        self.chkMP4 = tk.Checkbutton(self.Labelframe2)
        self.chkMP4.place(relx=0.08, rely=0.378, relheight=0.124, relwidth=0.532
                , bordermode='ignore')
        self.chkMP4.configure(activebackground="#d9d9d9")
        self.chkMP4.configure(anchor='w')
        self.chkMP4.configure(justify='left')
        self.chkMP4.configure(text='''.MP4''')
        self.chkMP4.configure(variable=self.VchkMP4)

        self.btnGo = tk.Button(self.frameTop)
        self.btnGo.place(relx=0.788, rely=0.491, height=31, width=53)
        self.btnGo.configure(activebackground="#d9d9d9")
        self.btnGo.configure(text='''GO!''')
        self.btnGo.bind('<Button-1>',lambda e:searcher_support.OnBtnGo(e))

        self.frameTreeview = tk.Frame(self.top)
        self.frameTreeview.place(relx=0.005, rely=0.499, relheight=0.49
                , relwidth=0.992)
        self.frameTreeview.configure(relief='groove')
        self.frameTreeview.configure(borderwidth="2")
        self.frameTreeview.configure(relief="groove")

        self.style.configure('Treeview',  font="TkDefaultFont")
        self.Scrolledtreeview1 = ScrolledTreeView(self.frameTreeview)
        self.Scrolledtreeview1.place(relx=0.005, rely=0.0, relheight=0.977
                , relwidth=0.992)
        self.Scrolledtreeview1.configure(columns="Col1")
        # build_treeview_support starting.
        self.Scrolledtreeview1.heading("#0",text="Tree")
        self.Scrolledtreeview1.heading("#0",anchor="center")
        self.Scrolledtreeview1.column("#0",width="370")
        self.Scrolledtreeview1.column("#0",minwidth="20")
        self.Scrolledtreeview1.column("#0",stretch="1")
        self.Scrolledtreeview1.column("#0",anchor="w")
        self.Scrolledtreeview1.heading("Col1",text="Col1")
        self.Scrolledtreeview1.heading("Col1",anchor="center")
        self.Scrolledtreeview1.column("Col1",width="371")
        self.Scrolledtreeview1.column("Col1",minwidth="20")
        self.Scrolledtreeview1.column("Col1",stretch="1")
        self.Scrolledtreeview1.column("Col1",anchor="w")
        self.Scrolledtreeview1.bind('<Button-1>',lambda e:searcher_support.OnTreeviewClick(e))

# The following code is added to facilitate the Scrolled widgets you specified.
class AutoScroll(object):
    '''Configure the scrollbars for a widget.'''
    def __init__(self, master):
        #  Rozen. Added the try-except clauses so that this class
        #  could be used for scrolled entry widget for which vertical
        #  scrolling is not supported. 5/7/14.
        try:
            vsb = ttk.Scrollbar(master, orient='vertical', command=self.yview)
        except:
            pass
        hsb = ttk.Scrollbar(master, orient='horizontal', command=self.xview)
        try:
            self.configure(yscrollcommand=self._autoscroll(vsb))
        except:
            pass
        self.configure(xscrollcommand=self._autoscroll(hsb))
        self.grid(column=0, row=0, sticky='nsew')
        try:
            vsb.grid(column=1, row=0, sticky='ns')
        except:
            pass
        hsb.grid(column=0, row=1, sticky='ew')
        master.grid_columnconfigure(0, weight=1)
        master.grid_rowconfigure(0, weight=1)
        # Copy geometry methods of master  (taken from ScrolledText.py)
        methods = tk.Pack.__dict__.keys() | tk.Grid.__dict__.keys() \
                  | tk.Place.__dict__.keys()
        for meth in methods:
            if meth[0] != '_' and meth not in ('config', 'configure'):
                setattr(self, meth, getattr(master, meth))

    @staticmethod
    def _autoscroll(sbar):
        '''Hide and show scrollbar as needed.'''
        def wrapped(first, last):
            first, last = float(first), float(last)
            if first <= 0 and last >= 1:
                sbar.grid_remove()
            else:
                sbar.grid()
            sbar.set(first, last)
        return wrapped

    def __str__(self):
        return str(self.master)

def _create_container(func):
    '''Creates a ttk Frame with a given master, and use this new frame to
    place the scrollbars and the widget.'''
    def wrapped(cls, master, **kw):
        container = ttk.Frame(master)
        container.bind('<Enter>', lambda e: _bound_to_mousewheel(e, container))
        container.bind('<Leave>', lambda e: _unbound_to_mousewheel(e, container))
        return func(cls, container, **kw)
    return wrapped

class ScrolledTreeView(AutoScroll, ttk.Treeview):
    '''A standard ttk Treeview widget with scrollbars that will
    automatically show/hide as needed.'''
    @_create_container
    def __init__(self, master, **kw):
        ttk.Treeview.__init__(self, master, **kw)
        AutoScroll.__init__(self, master)

import platform
def _bound_to_mousewheel(event, widget):
    child = widget.winfo_children()[0]
    if platform.system() == 'Windows' or platform.system() == 'Darwin':
        child.bind_all('<MouseWheel>', lambda e: _on_mousewheel(e, child))
        child.bind_all('<Shift-MouseWheel>', lambda e: _on_shiftmouse(e, child))
    else:
        child.bind_all('<Button-4>', lambda e: _on_mousewheel(e, child))
        child.bind_all('<Button-5>', lambda e: _on_mousewheel(e, child))
        child.bind_all('<Shift-Button-4>', lambda e: _on_shiftmouse(e, child))
        child.bind_all('<Shift-Button-5>', lambda e: _on_shiftmouse(e, child))

def _unbound_to_mousewheel(event, widget):
    if platform.system() == 'Windows' or platform.system() == 'Darwin':
        widget.unbind_all('<MouseWheel>')
        widget.unbind_all('<Shift-MouseWheel>')
    else:
        widget.unbind_all('<Button-4>')
        widget.unbind_all('<Button-5>')
        widget.unbind_all('<Shift-Button-4>')
        widget.unbind_all('<Shift-Button-5>')

def _on_mousewheel(event, widget):
    if platform.system() == 'Windows':
        widget.yview_scroll(-1*int(event.delta/120),'units')
    elif platform.system() == 'Darwin':
        widget.yview_scroll(-1*int(event.delta),'units')
    else:
        if event.num == 4:
            widget.yview_scroll(-1, 'units')
        elif event.num == 5:
            widget.yview_scroll(1, 'units')

def _on_shiftmouse(event, widget):
    if platform.system() == 'Windows':
        widget.xview_scroll(-1*int(event.delta/120), 'units')
    elif platform.system() == 'Darwin':
        widget.xview_scroll(-1*int(event.delta), 'units')
    else:
        if event.num == 4:
            widget.xview_scroll(-1, 'units')
        elif event.num == 5:
            widget.xview_scroll(1, 'units')
def start_up():
    searcher_support.main()

if __name__ == '__main__':
    searcher_support.main()




