#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# Support module generated by PAGE version 7x
#  in conjunction with Tcl version 8.6
#    Oct 01, 2021 02:41:33 PM CDT  platform: Linux

import sys
# -------------------------------
import platform
import os
from os.path import join, getsize, exists
# -------------------------------
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *
# -------------------------------
from tkinter import messagebox
from tkinter import font
from tkinter import filedialog

import searcher


def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol('WM_DELETE_WINDOW', root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = searcher.searcher(_top1)
    init()
    root.mainloop()


def init():
    global treeview, exts, FileList
    exts = []
    # FilePath=StringVar()
    FileList = []
    #-------------
    BlankChecks()
    treeview = _w1.Scrolledtreeview1
    SetupTreeview()
    #-------------
    global busyCursor, preBusyCursors, busyWidgets
    busyCursor = 'watch'
    preBusyCursors = None
    busyWidgets = (root, )


def OnBtnExit(*args):
    print('searcher_support.OnBtnExit')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    root.destroy()


def OnBtnGo(*args):
    print('searcher_support.OnBtnGo')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    ClearDataGrid()
    busyStart()
    BuildExts()
    fp = _w1.FilePath.get()
    e1 = tuple(exts)
    #Clear the list in case user wants to "go" again
    del FileList[:]  # under python 3.3, you can use list.clear()
    Walkit(fp, e1)
    LoadDataGrid()
    busyEnd()


def OnBtnSearchPath(*args):
    print('searcher_support.OnBtnSearchPath')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    path = filedialog.askdirectory()
    _w1.FilePath.set(path)


def OnTreeviewClick(*args):
    # def OnTreeviewClick(e):
    print('searcher_support.OnTreeviewClick')
    # for arg in args:
    #     print('another arg:', arg)
    sys.stdout.flush()
    row = treeview.identify_row(args[0].y)
    col = treeview.identify_column(args[0].x)
    if row == None:
        print('Header Row')
    elif row == '':
        print('Row Empty - Header Row')
    print(f'Row: {row}  -  Col: {col}')
    filename = treeview.set(row, 0)
    path = treeview.set(row, 1)
    if row != '':
        titl = 'Searcher Treeview Click'
        msg = f'Filename: {filename} - Path: {path}'
        messagebox.showinfo(title=titl, message=msg)


def BlankChecks():
    _w1.VchkAVI.set('0')
    _w1.VchkMKV.set('0')
    _w1.VchkMP3.set('0')
    _w1.VchkMP4.set('0')
    _w1.VchkOGG.set('0')
    _w1.VchkWAV.set('0')


def BuildExts():
    del exts[:]  # Clear the extentions list, then rebuild it...
    if _w1.VchkAVI.get() == 1:
        exts.append(".avi")
    if _w1.VchkMKV.get() == 1:
        exts.append(".mkv")
    if _w1.VchkMP3.get() == 1:
        exts.append(".mp3")
    if _w1.VchkMP4.get() == 1:
        exts.append(".mp4")
    if _w1.VchkOGG.get() == 1:
        exts.append(".ogg")
    if _w1.VchkWAV.get() == 1:
        exts.append(".wav")


def busyStart(newcursor=None):
    global preBusyCursors, busyWidgets
    print('busyStart')
    if not newcursor:
        newcursor = busyCursor
    newPreBusyCursors = {}
    for component in busyWidgets:
        newPreBusyCursors[component] = component['cursor']
        component.configure(cursor=newcursor)
        component.update_idletasks()
    preBusyCursors = (newPreBusyCursors, preBusyCursors)


def busyEnd():
    global preBusyCursors, busyWidgets
    print('busyEnd')
    if not preBusyCursors:
        return
    oldPreBusyCursors = preBusyCursors[0]
    preBusyCursors = preBusyCursors[1]
    for component in busyWidgets:
        try:
            component.configure(cursor=oldPreBusyCursors[component])
        except KeyError:
            pass
        component.update_idletasks()


def Walkit(musicpath, extensions):
    print(f'Into Walkit - Path: {musicpath} - Exts: {extensions}')
    rcntr = 0
    fl = []
    for root, dirs, files in os.walk(musicpath):
        rcntr += 1  # This is the number of folders we have walked
        for file in [f for f in files if f.endswith(extensions)]:
            fl.append(file)
            fl.append(root)
            FileList.append(fl)
            fl = []


def SetupTreeview():
    global ColHeads
    ColHeads = ['Filename', 'Path']
    treeview.configure(columns=ColHeads, show="headings")
    for col in ColHeads:
        treeview.heading(col,
                         text=col.title(),
                         command=lambda c=col: sortby(treeview, c, 0))
        ## adjust the column's width to the header string
        treeview.column(col, width=font.Font().measure(col.title()))


def ClearDataGrid():
    #print("Into ClearDataGrid")
    for c in treeview.get_children(''):
        treeview.delete(c)


def LoadDataGrid():
    global ColHeads
    ClearDataGrid()
    for c in FileList:
        treeview.insert('', 'end', values=c)
        # adjust column's width if necessary to fit each value
        for ix, val in enumerate(c):
            col_w = font.Font().measure(val)

            if treeview.column(ColHeads[ix], width=None) < col_w:
                treeview.column(ColHeads[ix], width=col_w)


def sortby(tree, col, descending):
    """sort tree contents when a column header is clicked on"""
    # grab values to sort
    data = [(tree.set(child, col), child) \
        for child in tree.get_children('')]
    # if the data to be sorted is numeric change to float
    #data =  change_numeric(data)
    # now sort the data in place
    data.sort(reverse=descending)
    for ix, item in enumerate(data):
        tree.move(item[1], '', ix)
    # switch the heading so it will sort in the opposite direction
    tree.heading(col, command=lambda col=col: sortby(tree, col, \
        int(not descending)))


if __name__ == '__main__':
    searcher.start_up()
