#! /usr/bin/env python
#  -*- coding: utf-8 -*-
#
# ======================================================
#     Chapter4_support.py
#  ------------------------------------------------------
# Created for PAGE Version 7 Tutorial
# Written by G.D. Walters
# Copyright (c) 2021 by G.D. Walters
# This source code is released under the MIT License
# ======================================================
# Support module generated by PAGE version 7aa
#  in conjunction with Tcl version 8.6
#    Nov 08, 2021 05:08:17 AM CST  platform: Linux

import sys
from os.path import exists
from datetime import datetime, timedelta
from pathlib import Path
import requests
from requests.exceptions import Timeout
from PIL import Image, ImageTk
import shutil

import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

from tkinter import Spinbox, messagebox
from tkinter import font
from tkinter import filedialog

import Chapter4


def main(*args):
    '''Main entry point for the application.'''
    global root
    root = tk.Tk()
    root.protocol('WM_DELETE_WINDOW', root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = Chapter4.Toplevelevel1(_top1)
    startup()
    root.mainloop()


def startup():
    global feed_url, WIDTH, HEIGHT, HEIGHT_16_9, MIN_DELTA, MAX_DELTA, DELTA
    global Timer_ID, resize, refresh_time, debug
    feed_url = 'https://science.ksc.nasa.gov/shuttle/countdown/video/chan2large.jpg'
    # Frame size without and with 16:9 aspect ratio correction
    WIDTH = 704
    HEIGHT = 480
    HEIGHT_16_9 = 396
    # Minimum, default, and maximum autoreload interval in seconds
    MIN_DELTA = 45
    DELTA = MIN_DELTA
    MAX_DELTA = 300
    refresh_time = MIN_DELTA
    resize = True
    _w1.spinbox.set(DELTA)
    _w1.che48.set(0)
    _w1.che47.set(0)
    _w1.Spinbox1.configure(state=DISABLED)
    debug = True
    # check for existence of the save file counter
    if exists('filecounter.txt'):
        pass
    else:
        filecount = open("filecounter.txt", "w")
        filecount.write('0')
        filecount.close
    # Set up the root.after timer
    centre_screen(777, 657)
    Timer_ID = root.after(0, on_tick())


def on_btnExit(*args):
    print('Chapter4_support.on_btnExit')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    root.destroy()


def on_btnReload(*args):
    print('Chapter4_support.on_btnReload')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    global feed_url
    get_image_from_web(feed_url)


def on_btnSave(*args):
    print('Chapter4_support.on_btnSave')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    # get last filenumber
    filecount = open('filecounter.txt', 'r+')
    global lastfile
    lastfile = filecount.read()
    lastfilenumber = int(lastfile) + 1
    filecount.seek(0)
    filecount.write(str(lastfilenumber))
    filecount.close
    src = 'local_image.png'
    dst = f'NasaStills{lastfilenumber}.png'
    shutil.copyfile(src, dst)


def on_btnSet(*args):
    print('Chapter4_support.on_btnSet')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    showinfo("Set", "Set function is not yet implemented")


def on_chkAspect(*args):
    print('Chapter4_support.on_chkAspect')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()


def on_chkTime(*args):
    print('Chapter4_support.on_chkTime')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    if _w1.che48.get() == 1:
        _w1.Spinbox1.configure(state=tk.NORMAL)
    else:
        _w1.Spinbox1.configure(state=tk.DISABLED)
    refresh_time = _w1.spinbox.get()
    root.update()


def on_spinChange(*args):
    print('Chapter4_support.on_spinChange')
    for arg in args:
        print('another arg:', arg)
    sys.stdout.flush()
    global refresh_time
    refresh_time = _w1.spinbox.get()


def get_image_from_web(url):
    # Attempt to get image from url and place it in w.lblImage
    global _img2, debug
    pic_url = url
    if debug:
        print(f'Refresh Time: {refresh_time}')
        print(f'Attempting to get {url}')
    try:
        with open('pic1.jpg', 'wb') as handle:
            response = requests.get(url, stream=True)
            if not response.ok:
                print(response)
            for block in response.iter_content(1024):
                if not block:
                    break
                handle.write(block)
        jpgfile = Image.open('pic1.jpg')
        jpgfile.save('local_image.png')
        original = Image.open('local_image.png')
        wid, hei = original.size
        if _w1.che47.get():
            newheight = HEIGHT_16_9
        else:
            newheight = HEIGHT
        if debug:
            print(f'Width: {wid} - Height: {hei}')
        _img1 = original.resize((WIDTH, newheight), Image.ANTIALIAS)
        _img2 = ImageTk.PhotoImage(_img1)
        _w1.labelImage.configure(image=_img2)
        _img1.save('local_image.png')
    except Exception:
        boxTitle = "Image Error"
        boxMessage = "An error occured getting the image."
        showerror(boxTitle, boxMessage)
        if debug:
            print("An error occured getting the image")
        _img2 = None
        _w1.labelImage.configure(image=_img2)


def on_tick():
    global Timer_ID, debug
    global feed_url  # , WIDTH, HEIGHT, HEIGHT_16_9, MIN_DELTA, MAX_DELTA, DELTA
    if debug:
        print('Into on_tick')
        print(f'RefreshTime = {_w1.spinbox.get()}')
        print(datetime.now())
    rt = int(_w1.spinbox.get())
    if debug:
        print(f'rt: {_w1.spinbox.get()}')
    get_image_from_web(feed_url)
    Timer_ID = root.after(rt * 1000, on_tick)


def showinfo(titl, msg):
    messagebox.showinfo(titl, msg, parent=root, icon=messagebox.INFO)


def showerror(titl, msg):
    messagebox.showerror(titl, msg, parent=root, icon=messagebox.ERROR)


def centre_screen(wid, hei):
    ws = _top1.winfo_screenwidth()
    hs = _top1.winfo_screenheight()
    x = (ws / 2) - (wid / 2)
    y = (hs / 2) - (hei / 2)
    _top1.geometry('%dx%d+%d+%d' % (wid, hei, x, y))


if __name__ == '__main__':
    Chapter4.start_up()
