#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
# ===============================================================
#                     WidgetHack_support.py
# ---------------------------------------------------------------
# Written for users PAGE of Tkinter
# ~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
# Author: Greg Walters
# Date Created: 2025-09-14 07:56:17
# ---------------------------------------------------------------
# Copyright © 2023, 2024, 2025 by G.D. Walters and Designated Geek Software
# ===============================================================
# Purpose:
#
#    Demonstrates how to "hack" (Override) theme settings.
# ===============================================================

# Support module generated by PAGE version 8.0
#  in conjunction with Tcl version 8.6
#    Sep 14, 2025 06:46:50 AM CDT  platform: Linux
#    Sep 14, 2025 07:02:54 AM CDT  platform: Linux
#    Sep 14, 2025 07:41:24 AM CDT  platform: Linux

import sys
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import WidgetHack

_debug = True  # False to eliminate debug printing from callback functions.

def main(*args):
    """Main entry point for the application."""
    global root
    root = tk.Tk()
    root.protocol("WM_DELETE_WINDOW", root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = WidgetHack.Toplevel1(_top1)
    root.mainloop()

def on_btnExit(*args):
    if _debug:
        print("WidgetHack_support.on_btnExit")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    sys.exit()

def on_btnHackIt(*args):
    if _debug:
        print("WidgetHack_support.on_btnHackIt")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()

    sty = ttk.Style()
    sty.configure(
        "My.TLabelframe", background="pink2", bordercolor="blue", borderwidth=4
    )
    _w1.TLabelframe1.configure(style="My.TLabelframe")

def on_btnHackAll(*args):
    if _debug:
        print("WidgetHack_support.on_btnHackAll")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()

    sty = ttk.Style()
    sty.configure("TLabelframe", background="pink2", bordercolor="blue", borderwidth=4)

def on_btnHackIt2(*args):
    if _debug:
        print("WidgetHack_support.on_btnHackIt2")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    sty = ttk.Style()
    sty.configure(
        "My.TLabelframe", background="pink2", bordercolor="blue", borderwidth=4
    )

    sty.configure("My.TLabelframe.Label", background="pink2")
    _w1.TLabelframe1.configure(style="My.TLabelframe.Label")
    _w1.TLabelframe1.configure(style="My.TLabelframe")

def on_btnHackAll2(*args):
    if _debug:
        print("WidgetHack_support.on_btnHackAll2")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()

    sty = ttk.Style()
    sty.configure("TLabelframe.Label", background="pink2")
    sty.configure("TLabelframe", background="pink2", bordercolor="blue", borderwidth=4)

if __name__ == "__main__":
    WidgetHack.start_up()




