#! /usr/bin/env python3
#  -*- coding: utf-8 -*-
# ======================================================
#     themeswitch_support.py
#  ------------------------------------------------------
# Created for PAGE and PAGE users.
# Written by G.D. Walters
# Copyright © 2023 by G.D. Walters
# This source code is released under the MIT License
# ======================================================
# Support module generated by PAGE version 8.0I
#  in conjunction with Tcl version 8.6
#    Oct 31, 2023 12:51:16 PM CDT  platform: Linux

import sys

# ===================================================
# Additional non-tkinter imports needed
# ===================================================
import os.path
import glob

# ===================================================
# PAGE provided tkinter imports
# ===================================================
import tkinter as tk
import tkinter.ttk as ttk
from tkinter.constants import *

import themeswitch

# ===================================================
# program level global variables
# ===================================================
_debug = True  # False to eliminate debug printing from callback functions.
location = themeswitch._location
programName = "Theme Switch Demo"
version = "0.1.0"


# ===================================================
# This is the main function that PAGE creates.
# ===================================================
def main(*args):
    """Main entry point for the application."""
    global root
    root = tk.Tk()
    root.protocol("WM_DELETE_WINDOW", root.destroy)
    # Creates a toplevel widget.
    global _top1, _w1
    _top1 = root
    _w1 = themeswitch.Toplevel1(_top1)
    startup()
    root.mainloop()


# ===================================================
# This is my startup function.  Everything here is
#   run before the program is seen by the user
# ===================================================
def startup():
    global currentTheme
    sty = ttk.Style()
    currentTheme = sty.theme_use()
    # Load the themes (OS level and theme folder themes)
    themelist = load_tcl_themes(location, True)
    # Bind the virtual <<ComboboxSelected>> event to the callback
    _w1.TCombobox1["values"] = themelist
    _w1.TCombobox1.bind("<<ComboboxSelected>>", lambda e: on_ComboThemeSelect(e))
    # call the fix_all_widgets function
    fix_all_widgets()
    # Set the titlebar
    _top1.title(f"{programName} version {version}")


# ===================================================
# Callback to exit the program
# ===================================================
def on_btnExit(*args):
    if _debug:
        print("themeswitch_support.on_btnExit")
        for arg in args:
            print("    another arg:", arg)
        sys.stdout.flush()
    sys.exit()


def load_tcl_themes(folder, silent):
    # ===================================================
    # This will load the various tcl Themes.
    # ---------------------------------------------------
    # This function is now Windows 10+ compliant and supports
    # the page-legacy theme.
    # ---------------------------------------------------
    # Written by G.D. Walters 3 March, 2024
    # ===================================================
    # version 0.20
    # ===================================================
    # Parameters:
    #    Inputs:
    #        folder: string - The current working directory.
    #                   This allows the parent program to be
    #                   run from any folder, if the program name
    #                   is in '~/.bashrc' or '~/.bash_aliases'
    #        silent: boolean - if False: surpress debugging
    #                   output
    #    Returns:
    #        list containing all ttk themes found in folder
    # Example:
    #     theme_list = load_tcl_themes(curdir, 1)
    # ===================================================
    # version 0.20
    # ---------------------------------------------------
    #   Added a fix just in case someone accidentally copies
    #     the themes_list.tcl into the themes folder
    # ---------------------------------------------------

    if silent:
        print(sys.platform)
    sty = ttk.Style()
    localThemes = sty.theme_names()
    currentTheme = sty.theme_use()

    if silent:
        print(f"{currentTheme=}")
    if sys.platform == "win32":
        cthemename = f"\\{currentTheme}.tcl"
    else:
        cthemename = f"/{currentTheme}.tcl"
    filedef = os.path.join(folder, "themes", "*.tcl")
    if silent:
        print(filedef)
    themelist1 = glob.glob(filedef)
    themelist = []
    if silent:
        print(f"{localThemes=}")
        print(f"{themelist1=}")
    for theme in localThemes:
        themelist.append(theme)
    for theme in themelist1:
        _top1.option_clear()
        if silent:
            print(f"{theme=}")
        if theme.endswith(cthemename):
            pass
        elif theme.endswith("themes_list.tcl"):
            pass
        elif theme.endswith("page-legacy.tcl"):
            if silent:
                print(f"{theme=}")
            root.tk.eval("set ::xframe #d9d9d9")
            root.tk.eval("set ::xfore #000000")
            root.tk.eval("set ::ana2color beige")
            root.tk.eval("set ::_tabfg1 black")
            root.tk.eval("set ::_tabfg2 black")
            root.tk.eval("set ::_tabbg1 #d9d9d9")
            root.tk.eval("set ::_tabbg2 #afb5cc")
            root.tk.eval("set ::_bgmode light")
            try:
                if sys.platform == "win32":
                    rs = theme.rsplit("\\", 1)[1]
                    nameend = rs.rfind(".tcl")
                    themename = rs[:nameend]
                else:
                    rs = theme.rsplit("/", 1)[1]
                    nameend = rs.rfind(".tcl")
                    themename = rs[:nameend]
                _top1.tk.call("source", theme)
                themelist.append(themename)
            except:
                pass
        else:
            if sys.platform == "win32":
                if silent:
                    print(f"{theme=}")
                rs = theme.rsplit("\\", 1)[1]
                nameend = rs.rfind(".tcl")
                themename = rs[:nameend]
            else:
                rs = theme.rsplit("/", 1)[1]
                nameend = rs.rfind(".tcl")
                themename = rs[:nameend]
            if silent:
                print(f"{themename=}")
            themelist.append(themename)
            _top1.tk.call("source", theme)

    themelist.sort()
    return themelist


# ===================================================
# Callback for the Combobox.
# ===================================================
def on_ComboThemeSelect(e):
    global currentTheme
    toUse = ""
    selected = _w1.combobox.get()
    if _debug:
        print(f"Combobox Select: {selected}")

    sty = ttk.Style()
    # ===================================================
    # If you only use ttk widgets, you can uncomment the
    #   next line and skip the fix_all_widgets function.
    # ===================================================
    sty.theme_use(selected)
    fix_all_widgets()


# ===================================================
# Makes sure that the theme background/foreground is
#   applied to all the various widgets including the
#   Toplevel background
# ===================================================
def fix_all_widgets():
    sty = ttk.Style()
    # ===================================================
    # Apply the theme and get the background and foreground
    #   colours.
    # ===================================================

    bg = sty.lookup(".", "background")
    fg = sty.lookup(".", "foreground")
    # ===================================================
    # Get a list of all the toplevel children
    # ===================================================
    kids = get_TopLevel_Children()
    # ===================================================
    # Walk the list applying the background/foreground
    #   colors.
    # ===================================================
    for k in kids:
        print(f"{k=} - {k.winfo_class()=}")
        # print(f"{k.winfo_class()=}")
        clas = k.winfo_class()
        if str(clas).startswith("T"):
            if str(clas) == "TLabel":
                k.configure(background=bg)
                k.configure(foreground=fg)
            else:
                pass
        else:
            k.configure(background=bg)
            try:
                k.configure(foreground=fg)
            except:
                pass
    # ===================================================
    # TNotebook tab pages are somewhat difficult for themes
    # since they must be dealt with separately
    # ===================================================
    _w1.TNotebook1_t1.configure(background=bg)
    _w1.TNotebook1_t2.configure(background=bg)
    _w1.TNotebook1_t3.configure(background=bg)
    _w1.TNotebook1_t4.configure(background=bg)
    # ===================================================
    # Finally update the Toplevel background
    #  NOTE:  if you use a TFrame as the background for all
    #         of your widgets, you won't need to do this.
    #         The toplevel widget is a TK widget, so it doesn't
    #         automatically get the theme.
    # ===================================================
    _top1.configure(background=bg)
    _top1.update()


# ===================================================
# This function gets all children of the Toplevel widget
# ===================================================
def get_TopLevel_Children():
    kids = _top1.winfo_children()
    # print(kids)
    return kids


if __name__ == "__main__":
    themeswitch.start_up()
