/*
 * trs_chars.c
 * $Id: trs_chars.c,v 1.9 2008/06/26 04:39:56 mann Exp $
 *
 * This file contains the bitmap data for all 256 characters in the
 * TRS-80 character set, for both Model I and Model III/4.  Thanks to
 * Al Petrofsky for supplying some of the data in .bdf format.  Thanks
 * to Todd P. Cromwell III for supplying exact dumps of two different
 * Model III character generator ROMs.
 */

static const Uint8 trs_char_data[][MAX_CHARS][MAX_CHAR_HEIGHT] = {

{
  /* CG 0 - for Model I */
  /* Source: MCM6674 Data Sheet */
  /* This is a very old version of the Model I font, found in only a
     few machines, that has standard ASCII [ \ ] ^ instead of
     directional arrows.  It also has odd symbols in positions 0-31,
     and the lowercase letters with descenders (plus 'a') are
     raised. Level II Basic put the odd symbols on the screen instead
     of uppercase if you did a homebrew lowercase conversion and did
     not replace the CG.
  */
  { 0x00,0x1f,0x11,0x11,0x11,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x1e,0x04,0x08,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x1b,0x15,0x1b,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x05,0x03,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1f,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x02,0x0f,0x12,0x14,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x15,0x0e,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x1b,0x15,0x1b,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x15,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x1f,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x15,0x15,0x1d,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1d,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x17,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x15,0x15,0x17,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x08,0x15,0x03,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x0a,0x0a,0x0a,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x0a,0x04,0x0a,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x0e,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x02,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x15,0x15,0x17,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x17,0x15,0x15,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x1d,0x15,0x15,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x15,0x15,0x1d,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x15,0x0e,0x1f,0x0e,0x15,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x0e,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x0c,0x0a,0x09,0x1f,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x10,0x08,0x04,0x02,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1e,0x10,0x08,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x06,0x00,0x06,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x08,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x16,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x12,0x12,0x0e,0x12,0x12,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x12,0x12,0x12,0x12,0x12,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x07,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x07,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x01,0x01,0x19,0x11,0x11,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x13,0x15,0x19,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x11,0x15,0x1b,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x02,0x02,0x02,0x02,0x02,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x01,0x02,0x04,0x08,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x08,0x08,0x08,0x08,0x08,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x0d,0x13,0x11,0x13,0x0d,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x01,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x16,0x19,0x11,0x19,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x16,0x19,0x19,0x16,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x09,0x05,0x03,0x05,0x09,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0b,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0d,0x13,0x11,0x13,0x0d,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x16,0x19,0x11,0x19,0x16,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0d,0x13,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1f,0x04,0x04,0x14,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x11,0x19,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x1e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x15,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x15,0x0a,0x15,0x0a,0x15,0x0a,0x00,0x00,0x00,0x00 },
},

{
  /* CG 1 - for Model I */
  /* Source: MCM6674 Data Sheet, modified by mann (from memory) to add
     arrows. */
  /* This is the standard Model I character generator found in
     machines without the Radio Shack lower case modification,
     including the arrows.  It has odd symbols in positions 0-31, and
     lowercase letters with descenders (plus 'a') are raised. Level II
     Basic put the odd symbols on the screen if you did a homebrew
     lowercase conversion and did not replace the CG.
  */
  { 0x00,0x1f,0x11,0x11,0x11,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x1e,0x04,0x08,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x1b,0x15,0x1b,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x05,0x03,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1f,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x02,0x0f,0x12,0x14,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x15,0x0e,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x1b,0x15,0x1b,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x15,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x1f,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x15,0x15,0x1d,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1d,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x17,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x15,0x15,0x17,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x08,0x15,0x03,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x0a,0x0a,0x0a,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x0a,0x04,0x0a,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x0e,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x02,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x15,0x15,0x17,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x17,0x15,0x15,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x11,0x11,0x1d,0x15,0x15,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x15,0x15,0x1d,0x11,0x11,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x15,0x0e,0x1f,0x0e,0x15,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x0e,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x0c,0x0a,0x09,0x1f,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x10,0x08,0x04,0x02,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x1e,0x10,0x08,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x06,0x00,0x06,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x08,0x04,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x10,0x16,0x15,0x15,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x12,0x12,0x0e,0x12,0x12,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x12,0x12,0x12,0x12,0x12,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x07,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x01,0x01,0x07,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x01,0x01,0x19,0x11,0x11,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x13,0x15,0x19,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x11,0x15,0x1b,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0e,0x15,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x0d,0x13,0x11,0x13,0x0d,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x01,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x16,0x19,0x11,0x19,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x16,0x19,0x19,0x16,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x01,0x09,0x05,0x03,0x05,0x09,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0b,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0d,0x13,0x11,0x13,0x0d,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x16,0x19,0x11,0x19,0x16,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0d,0x13,0x01,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1f,0x04,0x04,0x14,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x11,0x19,0x16,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x11,0x11,0x11,0x1e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x15,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x15,0x0a,0x15,0x0a,0x15,0x0a,0x00,0x00,0x00,0x00 },
},

{
  /* CG 2 - for Model I */
  /* Source: MCM6674 Data Sheet, modified by mann (from memory). */
  /* This is the replacement Model I character generator you got with
     the Radio Shack lowercase modification. Positions 0-31 are a copy
     of the uppercase letters, to work around a bug (?) in the Level
     II ROM. All characters without descenders are moved up one row.
     Backquote (position 0x60) and tilde (position 0x7e) have been
     replaced by Pound sign and Yen sign, respectively.
  */
  { 0x0e,0x11,0x10,0x16,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x12,0x12,0x0e,0x12,0x12,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x12,0x12,0x12,0x12,0x12,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x07,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x07,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x01,0x01,0x19,0x11,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x13,0x15,0x19,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x15,0x1b,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0e,0x15,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x15,0x0e,0x1f,0x0e,0x15,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0e,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x0c,0x0a,0x09,0x1f,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x04,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1e,0x10,0x08,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x00,0x06,0x06,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x00,0x06,0x06,0x02,0x01,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x08,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x16,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x12,0x12,0x0e,0x12,0x12,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x12,0x12,0x12,0x12,0x12,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x07,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x07,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x01,0x01,0x19,0x11,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x13,0x15,0x19,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x15,0x1b,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0e,0x15,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x02,0x1f,0x02,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x1f,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x02,0x07,0x02,0x12,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x0d,0x13,0x11,0x13,0x0d,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x01,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x16,0x19,0x11,0x19,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x14,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x1e,0x10,0x0e,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x00,0x18,0x10,0x10,0x10,0x12,0x0c,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x12,0x0a,0x06,0x0a,0x12,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0b,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0d,0x13,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0d,0x13,0x13,0x0d,0x01,0x01,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x16,0x19,0x19,0x16,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0d,0x13,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x0e,0x04,0x04,0x14,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x19,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x1e,0x10,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x0a,0x04,0x1f,0x04,0x1f,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x15,0x0a,0x15,0x0a,0x15,0x0a,0x15,0x0a,0x00,0x00,0x00,0x00 },
},

{
  /* CG 3 - for Model I */
  /* Source: BDF font from Al Petrofsky, probably adapted from another
     emulator.  This is not the real Model I font, which used a 6x12
     matrix; it seems to be a modified version of the 8x12 Model III
     font.
  */
  { 0x7c,0x82,0x80,0x8c,0x92,0x92,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x84,0x84,0xfc,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x88,0x88,0x78,0x88,0x88,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x04,0x04,0x04,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x88,0x88,0x88,0x88,0x88,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x04,0x04,0x3c,0x04,0x04,0xfc,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x04,0x04,0x3c,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x04,0x04,0xe4,0x84,0x84,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x84,0xfc,0x84,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x80,0x80,0x80,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x44,0x24,0x1c,0x24,0x44,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x04,0xfc,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0xc6,0xaa,0x92,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x8c,0x94,0xa4,0xc4,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x84,0x84,0x7c,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0x84,0xa4,0x44,0xb8,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x84,0x84,0x7c,0x24,0x44,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x04,0x78,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x82,0x82,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x82,0x92,0xaa,0xc6,0x82,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x48,0x30,0x48,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0xfe,0x40,0x20,0x10,0x08,0x04,0xfe,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x92,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x92,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0xfe,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x40,0xfe,0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x48,0x48,0x48,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x48,0x48,0xfc,0x48,0xfc,0x48,0x48,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0xfc,0x12,0x7c,0x90,0x7e,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x8c,0x40,0x20,0x10,0x08,0xc4,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x28,0x18,0xa4,0x44,0xb8,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x30,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x20,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x54,0x38,0xfe,0x38,0x54,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x30,0x30,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0xc4,0xa4,0x94,0x8c,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x18,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x80,0x78,0x04,0x04,0xfc,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x80,0x70,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x60,0x50,0x48,0xfc,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x04,0x7c,0x80,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x08,0x04,0x7c,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x80,0x40,0x20,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0x78,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0xf8,0x80,0x40,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x00,0x00,0x30,0x30,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xfc,0x00,0xfc,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x30,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x82,0x80,0x8c,0x92,0x92,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x84,0x84,0xfc,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x88,0x88,0x78,0x88,0x88,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x04,0x04,0x04,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x88,0x88,0x88,0x88,0x88,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x04,0x04,0x3c,0x04,0x04,0xfc,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x04,0x04,0x3c,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x04,0x04,0xe4,0x84,0x84,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x84,0xfc,0x84,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x80,0x80,0x80,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x44,0x24,0x1c,0x24,0x44,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x04,0xfc,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0xc6,0xaa,0x92,0x82,0x82,0x82,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x8c,0x94,0xa4,0xc4,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x84,0x84,0x7c,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x84,0x84,0xa4,0x44,0xb8,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x84,0x84,0x7c,0x24,0x44,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x84,0x04,0x78,0x80,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0xfe,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x84,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x82,0x82,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x82,0x92,0xaa,0xc6,0x82,0x00,0x00,0x00,0x00,0x00 },
  { 0x84,0x84,0x48,0x30,0x48,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x82,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0xfe,0x40,0x20,0x10,0x08,0x04,0xfe,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x04,0xfe,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x40,0xfe,0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x1c,0x08,0x88,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x80,0xf8,0x84,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x74,0x8c,0x84,0x8c,0x74,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x84,0x04,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x80,0xb8,0xc4,0x84,0xc4,0xb8,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x84,0xfc,0x04,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x08,0x1c,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x84,0x84,0xf8,0x80,0x78,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x74,0x8c,0x84,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x00,0xc0,0x80,0x80,0x84,0x84,0x78,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x84,0x44,0x3c,0x44,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6e,0x92,0x92,0x92,0x82,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x74,0x8c,0x84,0x84,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x78,0x84,0x84,0x84,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x74,0x8c,0x8c,0x74,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xb8,0xc4,0xc4,0xb8,0x80,0x80,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x74,0x8c,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xf8,0x04,0x78,0x80,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x7c,0x10,0x10,0x90,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x44,0x44,0x44,0x44,0xb8,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x82,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x84,0x48,0x30,0x48,0x84,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x84,0x84,0x84,0xf8,0x80,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x20,0x10,0x08,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x10,0x0c,0x10,0x10,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x10,0x10,0x60,0x10,0x10,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x82,0x44,0x38,0xfe,0x10,0xfe,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0xaa,0x54,0xaa,0x54,0xaa,0x54,0xaa,0x54,0x00,0x00,0x00,0x00 },
},

{
  /* CG 4 - for Model III */
  /* Source: A model III CG ROM, read by Todd P. Cromwell III (todd2.bin) */
  /* This is the older CG with Katakana alternate characters */
  /* Letters start at top of cell, Model III style */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x48,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x28,0x00,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0xb8,0x44,0x64,0x54,0x4c,0x44,0x3a,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x34,0x4c,0x44,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x5e,0x22,0x22,0x1e,0x12,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x28,0x00,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x44,0x4c,0x54,0x64,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x90,0x68,0x64,0x54,0x4c,0x2c,0x12,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x18,0x24,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x54,0x50,0x38,0x14,0x54,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x14,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x02,0x3e,0x42,0x7c,0x40,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x7c,0x04,0x7c,0x04,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x78,0x24,0x64,0x3c,0x24,0x64,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x04,0x04,0x44,0x38,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x7e,0x24,0x7e,0x24,0x24,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x78,0x14,0x38,0x50,0x3c,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x46,0x26,0x10,0x08,0x64,0x62,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x12,0x12,0x0c,0x52,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x54,0x38,0x7c,0x38,0x54,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x18,0x14,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x30,0x0c,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x38,0x40,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x30,0x28,0x24,0x7e,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x1e,0x20,0x40,0x22,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x04,0x02,0x3e,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x42,0x20,0x10,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x7c,0x40,0x20,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x30,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x52,0x6a,0x32,0x04,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x24,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x02,0x02,0x02,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x24,0x44,0x44,0x44,0x24,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x02,0x1e,0x02,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x02,0x72,0x42,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x22,0x12,0x0e,0x12,0x22,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x02,0x02,0x02,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x66,0x5a,0x5a,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x42,0x42,0x3e,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x42,0x52,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x42,0x42,0x3e,0x12,0x22,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x02,0x3c,0x40,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x5a,0x5a,0x66,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0x44,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x20,0x18,0x04,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x3a,0x46,0x42,0x46,0x3a,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x40,0x5c,0x62,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x00,0x30,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x22,0x12,0x0a,0x16,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6e,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x46,0x3a,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x02,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x3e,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x20,0x18,0x04,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00,0x00 },
  { 0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00,0x00 },
  { 0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00,0x00 },
  { 0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00,0x00 },
  { 0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00,0x00 },
  { 0x86,0x41,0x21,0x16,0x68,0x94,0x92,0x61,0x00,0x00,0x00,0x00 },
  { 0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x44,0x44,0x54,0x6c,0x44,0x00,0x00,0x00,0x00 },
  { 0x44,0x28,0x10,0x7c,0x10,0x7c,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x0a,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x20,0x20,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x02,0x04,0x08,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x20,0x3c,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x40,0x30,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x10,0x18,0x14,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x7c,0x44,0x40,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x10,0x10,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x3c,0x18,0x14,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x7c,0x48,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x20,0x20,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x40,0x78,0x40,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x54,0x54,0x44,0x20,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x28,0x18,0x08,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x20,0x10,0x18,0x14,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x7c,0x44,0x44,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x10,0x10,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x7e,0x10,0x18,0x14,0x12,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x7e,0x48,0x48,0x48,0x44,0x72,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x10,0x7c,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x44,0x44,0x42,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x7c,0x14,0x12,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x40,0x40,0x40,0x40,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x7e,0x24,0x24,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x40,0x4e,0x40,0x40,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x20,0x10,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x7e,0x48,0x28,0x08,0x48,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x44,0x48,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x42,0x42,0x50,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x3e,0x10,0x7c,0x10,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x00,0x7e,0x40,0x20,0x10,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x00,0x7c,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x1c,0x24,0x44,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x7c,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x40,0x28,0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x7e,0x40,0x20,0x30,0x58,0x14,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x50,0x50,0x50,0x48,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x7e,0x02,0x02,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x40,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x14,0x22,0x40,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x7c,0x10,0x54,0x54,0x54,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x40,0x28,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x3c,0x42,0x3c,0x42,0x3c,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x04,0x12,0x22,0x5e,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x44,0x28,0x10,0x28,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x08,0x3c,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x7e,0x48,0x28,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x20,0x20,0x20,0x10,0x08,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x40,0x7c,0x40,0x40,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x54,0x54,0x44,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x42,0x22,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x0a,0x4a,0x4a,0x2a,0x1a,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x44,0x44,0x24,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x42,0x42,0x42,0x42,0x42,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x42,0x42,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x4e,0x40,0x40,0x40,0x20,0x12,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x12,0x24,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
},

{
  /* CG 5 - for Model III */
  /* Source: see corresponding Model 4/4P CG below */
  /* This is the newer CG with international alternate characters.
     Characters 0-31 are also different from the older CG. I'm not
     certain this CG was available in the Model III; it may have been
     introduced in the Model 4 */
  /* Letters shifted up 1 to start at top of cell, Model III style */
  { 0x24,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x3c,0x44,0x44,0x3c,0x02,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x24,0x04,0x0e,0x04,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x02,0x3c,0x42,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x14,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0xfe,0x82,0xfe,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x20,0x20,0x14,0x0c,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x3c,0x24,0x24,0x3c,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00,0x00 },
  { 0x01,0x03,0x07,0x0f,0x1f,0x3f,0x7f,0xff,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x38,0x38,0x28,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x08,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x7e,0x24,0x7e,0x24,0x24,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x78,0x14,0x38,0x50,0x3c,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x46,0x26,0x10,0x08,0x64,0x62,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x12,0x12,0x0c,0x52,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x54,0x38,0x7c,0x38,0x54,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x18,0x14,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x30,0x0c,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x38,0x40,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x30,0x28,0x24,0x7e,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x1e,0x20,0x40,0x22,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x04,0x02,0x3e,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x42,0x20,0x10,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x7c,0x40,0x20,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x40,0x30,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x52,0x6a,0x32,0x04,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x24,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x02,0x02,0x02,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x24,0x44,0x44,0x44,0x24,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x02,0x1e,0x02,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x02,0x72,0x42,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x22,0x12,0x0e,0x12,0x22,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x02,0x02,0x02,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x66,0x5a,0x5a,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x42,0x42,0x3e,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x42,0x42,0x52,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x42,0x42,0x3e,0x12,0x22,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x02,0x3c,0x40,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x42,0x5a,0x5a,0x66,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0x44,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x40,0x20,0x18,0x04,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x3a,0x46,0x42,0x46,0x3a,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x40,0x5c,0x62,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x00,0x30,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x02,0x02,0x22,0x12,0x0a,0x16,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6e,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x46,0x3a,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3a,0x46,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x02,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x3e,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x82,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x42,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7e,0x20,0x18,0x04,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00,0x00 },
  { 0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00,0x00 },
  { 0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00,0x00 },
  { 0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00,0x00 },
  { 0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00,0x00 },
  { 0x86,0x41,0x21,0x16,0x68,0x94,0x92,0x61,0x00,0x00,0x00,0x00 },
  { 0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x44,0x44,0x54,0x6c,0x44,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x08,0x00,0x00,0x00,0x00 },
  { 0x18,0x24,0x04,0x0e,0x04,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x44,0x44,0x44,0x64,0x5c,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x14,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x1c,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x02,0x3c,0x42,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x9d,0xa5,0x9d,0xa5,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x04,0x44,0x24,0x14,0x08,0x54,0x72,0x40,0x00,0x00,0x00,0x00 },
  { 0x06,0x44,0x26,0x14,0x0e,0x54,0x72,0x40,0x00,0x00,0x00,0x00 },
  { 0x04,0x44,0x24,0x14,0x68,0x44,0x22,0x60,0x00,0x00,0x00,0x00 },
  { 0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0x28,0x10,0x7c,0x10,0x7c,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x3c,0x44,0x44,0x3c,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x07,0x52,0xaa,0xaa,0x8a,0x8a,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x08,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x14,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x00,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x3a,0x46,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x14,0x12,0x72,0x1e,0x12,0x72,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x2e,0x50,0x7c,0x12,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x62,0x5a,0x46,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x46,0x4a,0x52,0x62,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x7e,0x02,0x1e,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x18,0x24,0x7e,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x38,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x08,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x00,0x08,0x04,0x02,0x22,0x1c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x7e,0x02,0x1e,0x02,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x18,0x24,0x7e,0x42,0x42,0x00,0x00,0x00,0x00,0x00 },
},

{
  /* CG 6 - for Model III */
  /* Source: a Model III CG ROM, read by Todd P. Cromwell III (todd2_4.bin) */
  /* I'm guessing this was a 3rd party replacement CG, not from Radio
     Shack.  The ROM was marked as "Model III/4 character
     generator". The normal ASCII characters are bold, and alternates
     are the upper case and numbers in inverse video. This ROM doesn't
     seem especially suited for the Model 4, which had inverse video
     in hardware. */
  /* Letters start at top of cell, Model III style */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x3e,0x08,0x48,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x28,0x00,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0xb8,0x44,0x64,0x54,0x4c,0x44,0x3a,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x34,0x4c,0x44,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x5e,0x22,0x22,0x1e,0x12,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x28,0x00,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x44,0x4c,0x54,0x64,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x90,0x68,0x64,0x54,0x4c,0x2c,0x12,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x4c,0x32,0x00,0x18,0x24,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x54,0x50,0x38,0x14,0x54,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x14,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x02,0x3e,0x42,0x7c,0x40,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x7c,0x04,0x7c,0x04,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x78,0x24,0x64,0x3c,0x24,0x64,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x04,0x04,0x44,0x38,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x1e,0x1e,0x0c,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x36,0x36,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x36,0x36,0x7f,0x36,0x7f,0x36,0x36,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x3e,0x03,0x1e,0x30,0x1f,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x36,0x33,0x18,0x0c,0x66,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x36,0x1c,0x6e,0x3b,0x33,0x6e,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x0c,0x06,0x06,0x06,0x0c,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x0c,0x18,0x18,0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x3f,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x30,0x18,0x0c,0x06,0x03,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x63,0x63,0x6b,0x63,0x63,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x0e,0x0c,0x0c,0x0c,0x0c,0x3f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x30,0x1c,0x06,0x33,0x3f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x30,0x1c,0x30,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x3c,0x36,0x33,0x7f,0x30,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x03,0x1f,0x30,0x30,0x30,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x06,0x03,0x1f,0x33,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x33,0x30,0x18,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x33,0x1e,0x33,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x33,0x3e,0x30,0x18,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x18,0x0c,0x06,0x03,0x06,0x0c,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x30,0x18,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x63,0x7b,0x7b,0x7b,0x03,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x1e,0x33,0x33,0x3f,0x33,0x33,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x66,0x66,0x3e,0x66,0x66,0x3f,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x66,0x03,0x03,0x03,0x66,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x36,0x66,0x66,0x66,0x36,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x7f,0x46,0x16,0x1e,0x16,0x46,0x7f,0x00,0x00,0x00,0x00,0x00 },
  { 0x7f,0x46,0x16,0x1e,0x16,0x06,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x66,0x03,0x03,0x73,0x66,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x33,0x33,0x33,0x3f,0x33,0x33,0x33,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x30,0x30,0x30,0x33,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x67,0x66,0x36,0x1e,0x36,0x66,0x67,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x06,0x06,0x06,0x46,0x66,0x7f,0x00,0x00,0x00,0x00,0x00 },
  { 0x63,0x77,0x7f,0x7f,0x6b,0x63,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x63,0x67,0x6f,0x7b,0x73,0x63,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x3e,0x63,0x63,0x63,0x63,0x63,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x66,0x66,0x3e,0x06,0x06,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x33,0x33,0x3b,0x1e,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x66,0x66,0x3e,0x36,0x66,0x67,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x33,0x07,0x0e,0x38,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x2d,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x33,0x33,0x33,0x33,0x33,0x33,0x3f,0x00,0x00,0x00,0x00,0x00 },
  { 0x33,0x33,0x33,0x33,0x33,0x1e,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x63,0x63,0x63,0x6b,0x7f,0x77,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x63,0x63,0x36,0x1c,0x1c,0x36,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x33,0x33,0x33,0x1e,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x7f,0x63,0x31,0x18,0x4c,0x66,0x7f,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x0c,0x18,0x30,0x60,0xc0,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00 },
  { 0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x30,0x3e,0x33,0x6e,0x00,0x00,0x00,0x00,0x00 },
  { 0x07,0x06,0x3e,0x66,0x66,0x66,0x3b,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x33,0x03,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x30,0x3e,0x33,0x33,0x33,0x6e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x33,0x3f,0x03,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x36,0x06,0x0f,0x06,0x06,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6e,0x33,0x33,0x3e,0x30,0x1f,0x00,0x00,0x00,0x00 },
  { 0x07,0x06,0x36,0x6e,0x66,0x66,0x67,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x00,0x0e,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x00,0x30,0x30,0x30,0x33,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x07,0x06,0x66,0x36,0x1e,0x36,0x67,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x33,0x7f,0x7f,0x6b,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x33,0x33,0x33,0x33,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x33,0x33,0x33,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3b,0x66,0x66,0x3e,0x06,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6e,0x33,0x33,0x3e,0x30,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3b,0x6e,0x66,0x06,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x03,0x1e,0x30,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x0c,0x3e,0x0c,0x0c,0x2c,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x33,0x33,0x33,0x33,0x6e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x33,0x33,0x33,0x1e,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x63,0x6b,0x7f,0x7f,0x36,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x63,0x36,0x1c,0x36,0x63,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x33,0x33,0x33,0x3e,0x30,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3f,0x19,0x0c,0x26,0x3f,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x30,0x30,0x00,0x30,0x30,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00,0x00 },
  { 0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00,0x00 },
  { 0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x42,0x99,0x85,0x85,0x99,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00,0x00 },
  { 0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00,0x00 },
  { 0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00,0x00 },
  { 0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00,0x00 },
  { 0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00,0x00 },
  { 0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x41,0x21,0x16,0x68,0x94,0x92,0x60,0x00,0x00,0x00,0x00 },
  { 0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x38,0x28,0x28,0x6c,0xfe,0xc6,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xf3,0xe1,0xe1,0xf3,0xf3,0xff,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xc9,0xc9,0xc9,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xc9,0xc9,0x80,0xc9,0x80,0xc9,0xc9,0xff,0x00,0x00,0x00,0x00 },
  { 0xf3,0xc1,0xfc,0xe1,0xcf,0xe0,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xc9,0xcc,0xe7,0xf3,0x99,0x9c,0xff,0x00,0x00,0x00,0x00 },
  { 0xe3,0xc9,0xe3,0x91,0xc4,0xcc,0x91,0xff,0x00,0x00,0x00,0x00 },
  { 0xf9,0xf9,0xfc,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xe7,0xf3,0xf9,0xf9,0xf9,0xf3,0xe7,0xff,0x00,0x00,0x00,0x00 },
  { 0xf9,0xf3,0xe7,0xe7,0xe7,0xf3,0xf9,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0x99,0xc3,0x00,0xc3,0x99,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xf3,0xf3,0xc0,0xf3,0xf3,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xff,0xf3,0xf3,0xf9,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xff,0xf3,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0x9f,0xcf,0xe7,0xf3,0xf9,0xfc,0xff,0x00,0x00,0x00,0x00 },
  { 0xc1,0x9c,0x9c,0x94,0x9c,0x9c,0xc1,0xff,0x00,0x00,0x00,0x00 },
  { 0xf3,0xf1,0xf3,0xf3,0xf3,0xf3,0xc0,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcf,0xe3,0xf9,0xcc,0xc0,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcf,0xe3,0xcf,0xcc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xc7,0xc3,0xc9,0xcc,0x80,0xcf,0x87,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0xfc,0xe0,0xcf,0xcf,0xcf,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xe3,0xf9,0xfc,0xe0,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0xcc,0xcf,0xe7,0xf3,0xf3,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcc,0xe1,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcc,0xc1,0xcf,0xe7,0xf1,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xf3,0xf3,0xff,0xff,0xf3,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xf3,0xf3,0xff,0xff,0xf3,0xf3,0xf9,0x00,0x00,0x00,0x00 },
  { 0xe7,0xf3,0xf9,0xfc,0xf9,0xf3,0xe7,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xc0,0xff,0xc0,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xf9,0xf3,0xe7,0xcf,0xe7,0xf3,0xf9,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcf,0xe7,0xf3,0xff,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0xc1,0x9c,0x84,0x84,0x84,0xfc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xf3,0xe1,0xcc,0xcc,0xc0,0xcc,0xcc,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0x99,0x99,0xc1,0x99,0x99,0xc0,0xff,0x00,0x00,0x00,0x00 },
  { 0xc3,0x99,0xfc,0xfc,0xfc,0x99,0xc3,0xff,0x00,0x00,0x00,0x00 },
  { 0xe0,0xc9,0x99,0x99,0x99,0xc9,0xe0,0xff,0x00,0x00,0x00,0x00 },
  { 0x80,0xb9,0xe9,0xe1,0xe9,0xb9,0x80,0xff,0x00,0x00,0x00,0x00 },
  { 0x80,0xb9,0xe9,0xe1,0xe9,0xf9,0xf0,0xff,0x00,0x00,0x00,0x00 },
  { 0xc3,0x99,0xfc,0xfc,0x8c,0x99,0xc3,0xff,0x00,0x00,0x00,0x00 },
  { 0xcc,0xcc,0xcc,0xc0,0xcc,0xcc,0xcc,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xf3,0xf3,0xf3,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0x87,0xcf,0xcf,0xcf,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0x98,0x99,0xc9,0xe1,0xc9,0x99,0x98,0xff,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf9,0xf9,0xf9,0xb9,0x99,0x80,0xff,0x00,0x00,0x00,0x00 },
  { 0x9c,0x88,0x80,0x80,0x94,0x9c,0x9c,0xff,0x00,0x00,0x00,0x00 },
  { 0x9c,0x98,0x90,0x84,0x8c,0x9c,0x9c,0xff,0x00,0x00,0x00,0x00 },
  { 0xc1,0x9c,0x9c,0x9c,0x9c,0x9c,0xc1,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0x99,0x99,0xc1,0xf9,0xf9,0xf0,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xcc,0xcc,0xc4,0xe1,0xc7,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0x99,0x99,0xc1,0xc9,0x99,0x98,0xff,0x00,0x00,0x00,0x00 },
  { 0xe1,0xcc,0xf8,0xf1,0xc7,0xcc,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xc0,0xd2,0xf3,0xf3,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xc0,0xff,0x00,0x00,0x00,0x00 },
  { 0xcc,0xcc,0xcc,0xcc,0xcc,0xe1,0xf3,0xff,0x00,0x00,0x00,0x00 },
  { 0x9c,0x9c,0x9c,0x94,0x80,0x88,0x9c,0xff,0x00,0x00,0x00,0x00 },
  { 0x9c,0x9c,0xc9,0xe3,0xe3,0xc9,0x9c,0xff,0x00,0x00,0x00,0x00 },
  { 0xcc,0xcc,0xcc,0xe1,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00,0x00 },
  { 0x80,0x9c,0xce,0xe7,0xb3,0x99,0x80,0xff,0x00,0x00,0x00,0x00 },
  { 0xc3,0xfb,0xfb,0xfb,0xfb,0xfb,0xc3,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xf9,0xf3,0xe7,0xcf,0x9f,0x3f,0xff,0x00,0x00,0x00,0x00 },
  { 0xc3,0xdf,0xdf,0xdf,0xdf,0xdf,0xc3,0xff,0x00,0x00,0x00,0x00 },
  { 0xef,0xc7,0x93,0x39,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x1c,0x2a,0x3e,0x14,0x1c,0x63,0x1c,0x63,0x00,0x00,0x00,0x00 },
},

{
  /* CG 7 - for Model 4/4P */
  /* Source: A model III CG ROM, read by Todd P. Cromwell III (todd2.bin) */
  /* This is the older CG with Katakana alternate characters */
  /* Letters shifted 1 line down by mann to match M4 style */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x48,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x00,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0xb8,0x44,0x64,0x54,0x4c,0x44,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x34,0x4c,0x44,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x5e,0x22,0x22,0x1e,0x12,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x00,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x44,0x4c,0x54,0x64,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x28,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x90,0x68,0x64,0x54,0x4c,0x2c,0x12,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x18,0x24,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x54,0x50,0x38,0x14,0x54,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x14,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x02,0x3e,0x42,0x7c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x7c,0x04,0x7c,0x04,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x78,0x24,0x64,0x3c,0x24,0x64,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x04,0x04,0x44,0x38,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x7e,0x24,0x7e,0x24,0x24,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x78,0x14,0x38,0x50,0x3c,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x46,0x26,0x10,0x08,0x64,0x62,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x12,0x12,0x0c,0x52,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x54,0x38,0x7c,0x38,0x54,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x18,0x14,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x30,0x0c,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x38,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x30,0x28,0x24,0x7e,0x20,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x1e,0x20,0x40,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x04,0x02,0x3e,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x20,0x10,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x7c,0x40,0x20,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x30,0x08,0x00,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x52,0x6a,0x32,0x04,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x02,0x02,0x02,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x24,0x44,0x44,0x44,0x24,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x02,0x1e,0x02,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x02,0x72,0x42,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x70,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x22,0x12,0x0e,0x12,0x22,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x66,0x5a,0x5a,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x3e,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x52,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x3e,0x12,0x22,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x3c,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x5a,0x5a,0x66,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0x44,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x20,0x18,0x04,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x46,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x40,0x5c,0x62,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x00,0x30,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x22,0x12,0x0a,0x16,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6e,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x46,0x3a,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x40,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x02,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x08,0x3e,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x82,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x20,0x18,0x04,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00 },
  { 0x00,0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00 },
  { 0x00,0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00 },
  { 0x00,0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00 },
  { 0x00,0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00 },
  { 0x00,0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00 },
  { 0x00,0x86,0x41,0x21,0x16,0x68,0x94,0x92,0x61,0x00,0x00,0x00 },
  { 0x00,0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00 },
  { 0x00,0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x44,0x44,0x54,0x6c,0x44,0x00,0x00,0x00 },
  { 0x00,0x44,0x28,0x10,0x7c,0x10,0x7c,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x04,0x0a,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x20,0x20,0x20,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x02,0x04,0x08,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x20,0x3c,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x40,0x30,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x10,0x18,0x14,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x7c,0x44,0x40,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x38,0x10,0x10,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x3c,0x18,0x14,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x7c,0x48,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x38,0x20,0x20,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x40,0x78,0x40,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x54,0x54,0x44,0x20,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x28,0x18,0x08,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x20,0x10,0x18,0x14,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x7c,0x44,0x44,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x10,0x10,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x7e,0x10,0x18,0x14,0x12,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x7e,0x48,0x48,0x48,0x44,0x72,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x10,0x7c,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x44,0x44,0x42,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x7c,0x14,0x12,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x40,0x40,0x40,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x7e,0x24,0x24,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x40,0x4e,0x40,0x40,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x20,0x10,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x7e,0x48,0x28,0x08,0x48,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x44,0x48,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x42,0x50,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x50,0x3e,0x10,0x7c,0x10,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x00,0x7e,0x40,0x20,0x10,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x00,0x7c,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1c,0x24,0x44,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x7c,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x40,0x28,0x10,0x28,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x7e,0x40,0x20,0x30,0x58,0x14,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x20,0x50,0x50,0x50,0x48,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x7e,0x02,0x02,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x40,0x20,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x14,0x22,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x7c,0x10,0x54,0x54,0x54,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x40,0x28,0x10,0x20,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x3c,0x42,0x3c,0x42,0x3c,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x04,0x12,0x22,0x5e,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x44,0x28,0x10,0x28,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x08,0x3c,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x7e,0x48,0x28,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x20,0x20,0x20,0x10,0x08,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x40,0x7c,0x40,0x40,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x54,0x54,0x44,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x22,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x0a,0x0a,0x4a,0x4a,0x2a,0x1a,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x04,0x44,0x44,0x24,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x42,0x42,0x42,0x42,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x42,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x4e,0x40,0x40,0x40,0x20,0x12,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x12,0x24,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
},

{
  /* CG 8 - for Model 4/4P */
  /* Source: Reed M4 emulator (reedm4l.xbm, reedm4la.xbm). Checked by
     eye against my Model 4P. I should really pull out the ROM and read
     it directly to be sure this is right. Apologies to Matthew Reed. */
  /* This is the newer CG with international alternate characters.
     Characters 0-31 are also different from the older CG. */
  /* Letters start one line from top of cell, Model 4 style */
  { 0x00,0x24,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x38,0x44,0x3c,0x44,0x44,0x3c,0x02,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x04,0x0e,0x04,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x02,0x3c,0x42,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0xfe,0x82,0xfe,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x20,0x20,0x14,0x0c,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x42,0x3c,0x24,0x24,0x3c,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x03,0x00,0x00,0x00 },
  { 0x00,0x01,0x03,0x07,0x0f,0x1f,0x3f,0x7f,0xff,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0xff,0xff,0x00,0x00,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x38,0x38,0x28,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x08,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x00,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x7e,0x24,0x7e,0x24,0x24,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x78,0x14,0x38,0x50,0x3c,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x46,0x26,0x10,0x08,0x64,0x62,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x12,0x12,0x0c,0x52,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x54,0x38,0x7c,0x38,0x54,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x18,0x14,0x10,0x10,0x10,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x30,0x0c,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x38,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x30,0x28,0x24,0x7e,0x20,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x1e,0x20,0x40,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x04,0x02,0x3e,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x20,0x10,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x7c,0x40,0x20,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x00,0x00,0x10,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x60,0x30,0x18,0x0c,0x18,0x30,0x60,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x30,0x08,0x00,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x52,0x6a,0x32,0x04,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x02,0x02,0x02,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x24,0x44,0x44,0x44,0x24,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x02,0x1e,0x02,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x02,0x72,0x42,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x70,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x22,0x12,0x0e,0x12,0x22,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x66,0x5a,0x5a,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x3e,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x52,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x3e,0x12,0x22,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x3c,0x40,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x5a,0x5a,0x66,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0x44,0x44,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x40,0x20,0x18,0x04,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x46,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x40,0x40,0x5c,0x62,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x00,0x30,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x22,0x12,0x0a,0x16,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6e,0x92,0x92,0x92,0x92,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x46,0x3a,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x5c,0x62,0x62,0x5c,0x40,0x40,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x02,0x02,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x02,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x08,0x3e,0x08,0x08,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x82,0x92,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x62,0x5c,0x40,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x20,0x18,0x04,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x00,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00 },
  { 0x00,0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00 },
  { 0x00,0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00 },
  { 0x00,0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00 },
  { 0x00,0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00 },
  { 0x00,0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00 },
  { 0x00,0x86,0x41,0x21,0x16,0x68,0x94,0x92,0x61,0x00,0x00,0x00 },
  { 0x00,0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00 },
  { 0x00,0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x44,0x44,0x54,0x6c,0x44,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x02,0x42,0x3c,0x08,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x04,0x0e,0x04,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x44,0x64,0x5c,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x14,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x1c,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x02,0x3c,0x42,0x3c,0x40,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x9d,0xa5,0x9d,0xa5,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xb9,0x85,0x85,0xb9,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x04,0x44,0x24,0x14,0x08,0x54,0x72,0x40,0x00,0x00,0x00 },
  { 0x00,0x06,0x44,0x26,0x14,0x0e,0x54,0x72,0x40,0x00,0x00,0x00 },
  { 0x00,0x04,0x44,0x24,0x14,0x68,0x44,0x22,0x60,0x00,0x00,0x00 },
  { 0x00,0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0x28,0x10,0x7c,0x10,0x7c,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x38,0x44,0x3c,0x44,0x44,0x3c,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x07,0x52,0xaa,0xaa,0x8a,0x8a,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x08,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x18,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x3a,0x46,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x14,0x12,0x72,0x1e,0x12,0x72,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x2e,0x50,0x7c,0x12,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x24,0x42,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x62,0x5a,0x46,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x62,0x5a,0x46,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x46,0x4a,0x52,0x62,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x7e,0x02,0x1e,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x18,0x24,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x38,0x10,0x10,0x10,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x08,0x04,0x02,0x22,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x7e,0x02,0x1e,0x02,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x18,0x24,0x7e,0x42,0x42,0x00,0x00,0x00,0x00 },
},

{
  /* CG 9 - for Model 4/4P */
  /* Source: a Model III CG ROM, read by Todd P. Cromwell III (todd2_4.bin) */
  /* I'm guessing this was a 3rd party replacement CG, not from Radio
     Shack.  The ROM was marked as "Model III/4 character
     generator". The normal ASCII characters are bold, and alternates
     are the upper case and numbers in inverse video. This ROM doesn't
     seem especially suited for the Model 4, which had inverse video
     in hardware. */
  /* Letters shifted 1 line down by mann to match M4 style */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3e,0x08,0x48,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x3c,0x42,0x7e,0x02,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x7e,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x00,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0xb8,0x44,0x64,0x54,0x4c,0x44,0x3a,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x34,0x4c,0x44,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x5e,0x22,0x22,0x1e,0x12,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x28,0x00,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x10,0x28,0x44,0x7c,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x44,0x4c,0x54,0x64,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x28,0x38,0x44,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x90,0x68,0x64,0x54,0x4c,0x2c,0x12,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x3c,0x42,0x42,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x44,0x44,0x3c,0x44,0x44,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x00,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x18,0x24,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x54,0x50,0x38,0x14,0x54,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x14,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x1c,0x20,0x3c,0x22,0x5c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x02,0x3e,0x42,0x7c,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x7c,0x04,0x7c,0x04,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x78,0x24,0x64,0x3c,0x24,0x64,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x04,0x04,0x44,0x38,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x1e,0x1e,0x0c,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x36,0x36,0x36,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x36,0x36,0x7f,0x36,0x7f,0x36,0x36,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x3e,0x03,0x1e,0x30,0x1f,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x36,0x33,0x18,0x0c,0x66,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x36,0x1c,0x6e,0x3b,0x33,0x6e,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x06,0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x0c,0x06,0x06,0x06,0x0c,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x0c,0x18,0x18,0x18,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x66,0x3c,0xff,0x3c,0x66,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x0c,0x3f,0x0c,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x60,0x30,0x18,0x0c,0x06,0x03,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x63,0x63,0x6b,0x63,0x63,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x0e,0x0c,0x0c,0x0c,0x0c,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x30,0x1c,0x06,0x33,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x30,0x1c,0x30,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x3c,0x36,0x33,0x7f,0x30,0x78,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x03,0x1f,0x30,0x30,0x30,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x06,0x03,0x1f,0x33,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x33,0x30,0x18,0x0c,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x33,0x1e,0x33,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x33,0x3e,0x30,0x18,0x0e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x0c,0x00,0x00,0x0c,0x0c,0x06,0x00,0x00,0x00 },
  { 0x00,0x18,0x0c,0x06,0x03,0x06,0x0c,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3f,0x00,0x3f,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x0c,0x18,0x30,0x18,0x0c,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x30,0x18,0x0c,0x00,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x63,0x7b,0x7b,0x7b,0x03,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x1e,0x33,0x33,0x3f,0x33,0x33,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x66,0x66,0x3e,0x66,0x66,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x66,0x03,0x03,0x03,0x66,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x1f,0x36,0x66,0x66,0x66,0x36,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x7f,0x46,0x16,0x1e,0x16,0x46,0x7f,0x00,0x00,0x00,0x00 },
  { 0x00,0x7f,0x46,0x16,0x1e,0x16,0x06,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x66,0x03,0x03,0x73,0x66,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x33,0x33,0x33,0x3f,0x33,0x33,0x33,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x30,0x30,0x30,0x33,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x67,0x66,0x36,0x1e,0x36,0x66,0x67,0x00,0x00,0x00,0x00 },
  { 0x00,0x0f,0x06,0x06,0x06,0x46,0x66,0x7f,0x00,0x00,0x00,0x00 },
  { 0x00,0x63,0x77,0x7f,0x7f,0x6b,0x63,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x63,0x67,0x6f,0x7b,0x73,0x63,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x3e,0x63,0x63,0x63,0x63,0x63,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x66,0x66,0x3e,0x06,0x06,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x33,0x33,0x3b,0x1e,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x66,0x66,0x3e,0x36,0x66,0x67,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x33,0x07,0x0e,0x38,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x3f,0x2d,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x33,0x33,0x33,0x33,0x33,0x33,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x33,0x33,0x33,0x33,0x33,0x1e,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x63,0x63,0x63,0x6b,0x7f,0x77,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x63,0x63,0x36,0x1c,0x1c,0x36,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x33,0x33,0x33,0x1e,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x7f,0x63,0x31,0x18,0x4c,0x66,0x7f,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x04,0x04,0x04,0x04,0x04,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x0c,0x18,0x30,0x60,0xc0,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x20,0x20,0x20,0x20,0x20,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x6c,0xc6,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00 },
  { 0x00,0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x30,0x3e,0x33,0x6e,0x00,0x00,0x00,0x00 },
  { 0x00,0x07,0x06,0x3e,0x66,0x66,0x66,0x3b,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x33,0x03,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x30,0x3e,0x33,0x33,0x33,0x6e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x33,0x3f,0x03,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x1c,0x36,0x06,0x0f,0x06,0x06,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6e,0x33,0x33,0x3e,0x30,0x1f,0x00,0x00,0x00 },
  { 0x00,0x07,0x06,0x36,0x6e,0x66,0x66,0x67,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x00,0x0e,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x00,0x30,0x30,0x30,0x33,0x33,0x1e,0x00,0x00,0x00 },
  { 0x00,0x07,0x06,0x66,0x36,0x1e,0x36,0x67,0x00,0x00,0x00,0x00 },
  { 0x00,0x0e,0x0c,0x0c,0x0c,0x0c,0x0c,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x33,0x7f,0x7f,0x6b,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x33,0x33,0x33,0x33,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1e,0x33,0x33,0x33,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3b,0x66,0x66,0x3e,0x06,0x0f,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6e,0x33,0x33,0x3e,0x30,0x78,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3b,0x6e,0x66,0x06,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3e,0x03,0x1e,0x30,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x0c,0x3e,0x0c,0x0c,0x2c,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x33,0x33,0x33,0x33,0x6e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x33,0x33,0x33,0x1e,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x63,0x6b,0x7f,0x7f,0x36,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x63,0x36,0x1c,0x36,0x63,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x33,0x33,0x33,0x3e,0x30,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3f,0x19,0x0c,0x26,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x08,0x08,0x04,0x08,0x08,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x30,0x30,0x00,0x30,0x30,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x0c,0x92,0x60,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0xfe,0x7c,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x6c,0xfe,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x7c,0xfe,0x7c,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x38,0x10,0xd6,0xfe,0xd6,0x10,0x38,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x3c,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x9c,0x62,0x62,0x9c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x44,0x3c,0x44,0x44,0x3c,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x86,0x48,0x28,0x18,0x08,0x0c,0x0c,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x30,0x50,0x48,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x10,0x08,0x7c,0x08,0x10,0x60,0x00,0x00,0x00,0x00 },
  { 0x00,0x68,0x60,0x10,0x08,0x38,0x40,0x30,0x00,0x00,0x00,0x00 },
  { 0x00,0x34,0x4a,0x48,0x48,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x44,0x7c,0x44,0x28,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x44,0x44,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x02,0x12,0x0a,0x06,0x0a,0x52,0x22,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x08,0x08,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x24,0x5c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x4c,0x48,0x28,0x18,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x04,0x18,0x04,0x38,0x40,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x42,0x42,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x2a,0x28,0x28,0x28,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x24,0x1c,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x12,0x0c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x12,0x10,0x10,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x26,0x24,0x24,0x24,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x54,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x46,0x28,0x10,0x28,0xc4,0x00,0x00,0x00,0x00 },
  { 0x00,0x92,0x54,0x54,0x38,0x10,0x10,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x82,0x92,0x92,0x6c,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xc6,0x44,0xc6,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x08,0x08,0x08,0x0a,0x0c,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x7c,0x00,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x7e,0x04,0x08,0x30,0x08,0x04,0x7e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x4c,0x32,0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x28,0x44,0xfe,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x10,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x80,0x40,0xfe,0x10,0xfe,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x7c,0x08,0x10,0x20,0x00,0x00,0x00,0x00 },
  { 0x00,0xfc,0x4a,0x24,0x10,0x48,0xa4,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x82,0x82,0xfe,0x44,0x44,0xc6,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x6c,0x92,0x92,0x6c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x12,0x0a,0x06,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x78,0x04,0x38,0x44,0x38,0x40,0x3c,0x00,0x00,0x00,0x00 },
  { 0x00,0x44,0xaa,0x54,0x28,0x54,0xaa,0x44,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x99,0x85,0x85,0x99,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x42,0x24,0x18,0x24,0x18,0x24,0x42,0x00,0x00,0x00,0x00 },
  { 0x00,0x7c,0x52,0x52,0x5c,0x50,0x50,0x50,0x50,0x00,0x00,0x00 },
  { 0x00,0x10,0x38,0x54,0x14,0x54,0x38,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x5e,0xa5,0xa5,0x9d,0x95,0x66,0x3c,0x00,0x00,0x00 },
  { 0x00,0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00,0x00 },
  { 0x00,0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00,0x00 },
  { 0x00,0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x1e,0x22,0x22,0x1e,0x52,0x22,0xd2,0x00,0x00,0x00,0x00 },
  { 0x00,0x06,0x41,0x21,0x16,0x68,0x94,0x92,0x60,0x00,0x00,0x00 },
  { 0x00,0x70,0x60,0x50,0x0e,0x09,0x09,0x06,0x00,0x00,0x00,0x00 },
  { 0x00,0x38,0x44,0x44,0x44,0x38,0x10,0x38,0x10,0x00,0x00,0x00 },
  { 0x00,0x70,0x10,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0xff,0xc7,0xbb,0xcf,0xef,0xff,0xef,0xff,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x10,0x28,0x44,0x00,0x00,0x00 },
  { 0x00,0x10,0x28,0x10,0x38,0x54,0x28,0x7c,0x28,0x00,0x00,0x00 },
  { 0x00,0x10,0x10,0x38,0x28,0x28,0x6c,0xfe,0xc6,0x00,0x00,0x00 },
  { 0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xf3,0xe1,0xe1,0xf3,0xf3,0xff,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xc9,0xc9,0xc9,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xc9,0xc9,0x80,0xc9,0x80,0xc9,0xc9,0xff,0x00,0x00,0x00 },
  { 0x00,0xf3,0xc1,0xfc,0xe1,0xcf,0xe0,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xc9,0xcc,0xe7,0xf3,0x99,0x9c,0xff,0x00,0x00,0x00 },
  { 0x00,0xe3,0xc9,0xe3,0x91,0xc4,0xcc,0x91,0xff,0x00,0x00,0x00 },
  { 0x00,0xf9,0xf9,0xfc,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xe7,0xf3,0xf9,0xf9,0xf9,0xf3,0xe7,0xff,0x00,0x00,0x00 },
  { 0x00,0xf9,0xf3,0xe7,0xe7,0xe7,0xf3,0xf9,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0x99,0xc3,0x00,0xc3,0x99,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xf3,0xf3,0xc0,0xf3,0xf3,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xff,0xff,0xff,0xff,0xf3,0xf3,0xf9,0x00,0x00,0x00 },
  { 0x00,0xff,0xff,0xff,0xc0,0xff,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xff,0xff,0xff,0xff,0xf3,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0x9f,0xcf,0xe7,0xf3,0xf9,0xfc,0xff,0x00,0x00,0x00 },
  { 0x00,0xc1,0x9c,0x9c,0x94,0x9c,0x9c,0xc1,0xff,0x00,0x00,0x00 },
  { 0x00,0xf3,0xf1,0xf3,0xf3,0xf3,0xf3,0xc0,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcf,0xe3,0xf9,0xcc,0xc0,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcf,0xe3,0xcf,0xcc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xc7,0xc3,0xc9,0xcc,0x80,0xcf,0x87,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0xfc,0xe0,0xcf,0xcf,0xcf,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xe3,0xf9,0xfc,0xe0,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0xcc,0xcf,0xe7,0xf3,0xf3,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcc,0xe1,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcc,0xc1,0xcf,0xe7,0xf1,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xf3,0xf3,0xff,0xff,0xf3,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xf3,0xf3,0xff,0xff,0xf3,0xf3,0xf9,0x00,0x00,0x00 },
  { 0x00,0xe7,0xf3,0xf9,0xfc,0xf9,0xf3,0xe7,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xff,0xc0,0xff,0xc0,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0xf9,0xf3,0xe7,0xcf,0xe7,0xf3,0xf9,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcf,0xe7,0xf3,0xff,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0xc1,0x9c,0x84,0x84,0x84,0xfc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xf3,0xe1,0xcc,0xcc,0xc0,0xcc,0xcc,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0x99,0x99,0xc1,0x99,0x99,0xc0,0xff,0x00,0x00,0x00 },
  { 0x00,0xc3,0x99,0xfc,0xfc,0xfc,0x99,0xc3,0xff,0x00,0x00,0x00 },
  { 0x00,0xe0,0xc9,0x99,0x99,0x99,0xc9,0xe0,0xff,0x00,0x00,0x00 },
  { 0x00,0x80,0xb9,0xe9,0xe1,0xe9,0xb9,0x80,0xff,0x00,0x00,0x00 },
  { 0x00,0x80,0xb9,0xe9,0xe1,0xe9,0xf9,0xf0,0xff,0x00,0x00,0x00 },
  { 0x00,0xc3,0x99,0xfc,0xfc,0x8c,0x99,0xc3,0xff,0x00,0x00,0x00 },
  { 0x00,0xcc,0xcc,0xcc,0xc0,0xcc,0xcc,0xcc,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xf3,0xf3,0xf3,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0x87,0xcf,0xcf,0xcf,0xcc,0xcc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0x98,0x99,0xc9,0xe1,0xc9,0x99,0x98,0xff,0x00,0x00,0x00 },
  { 0x00,0xf0,0xf9,0xf9,0xf9,0xb9,0x99,0x80,0xff,0x00,0x00,0x00 },
  { 0x00,0x9c,0x88,0x80,0x80,0x94,0x9c,0x9c,0xff,0x00,0x00,0x00 },
  { 0x00,0x9c,0x98,0x90,0x84,0x8c,0x9c,0x9c,0xff,0x00,0x00,0x00 },
  { 0x00,0xc1,0x9c,0x9c,0x9c,0x9c,0x9c,0xc1,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0x99,0x99,0xc1,0xf9,0xf9,0xf0,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xcc,0xcc,0xc4,0xe1,0xc7,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0x99,0x99,0xc1,0xc9,0x99,0x98,0xff,0x00,0x00,0x00 },
  { 0x00,0xe1,0xcc,0xf8,0xf1,0xc7,0xcc,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xc0,0xd2,0xf3,0xf3,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0xcc,0xc0,0xff,0x00,0x00,0x00 },
  { 0x00,0xcc,0xcc,0xcc,0xcc,0xcc,0xe1,0xf3,0xff,0x00,0x00,0x00 },
  { 0x00,0x9c,0x9c,0x9c,0x94,0x80,0x88,0x9c,0xff,0x00,0x00,0x00 },
  { 0x00,0x9c,0x9c,0xc9,0xe3,0xe3,0xc9,0x9c,0xff,0x00,0x00,0x00 },
  { 0x00,0xcc,0xcc,0xcc,0xe1,0xf3,0xf3,0xe1,0xff,0x00,0x00,0x00 },
  { 0x00,0x80,0x9c,0xce,0xe7,0xb3,0x99,0x80,0xff,0x00,0x00,0x00 },
  { 0x00,0xc3,0xfb,0xfb,0xfb,0xfb,0xfb,0xc3,0xff,0x00,0x00,0x00 },
  { 0x00,0xff,0xf9,0xf3,0xe7,0xcf,0x9f,0x3f,0xff,0x00,0x00,0x00 },
  { 0x00,0xc3,0xdf,0xdf,0xdf,0xdf,0xdf,0xc3,0xff,0x00,0x00,0x00 },
  { 0x00,0xef,0xc7,0x93,0x39,0xff,0xff,0xff,0xff,0x00,0x00,0x00 },
  { 0x00,0x1c,0x2a,0x3e,0x14,0x1c,0x63,0x1c,0x63,0x00,0x00,0x00 },
},

{
  /* CG 10 - german charset for Genie I/II & Video Genie from:
   * http://oldcomputers-ddns.org/public/pub/rechner/eaca/genie_1/
   * roms/vg1_mit_tcs-erweiterung/tcs-rom-ext_zeichensatz_2716.bin */
  { 0xf8,0x88,0x88,0x88,0x88,0x88,0x88,0xf8,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xb0,0x48,0xb0,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x50,0x20,0x50,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x10,0x20,0x40,0x20,0x10,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x40,0xf8,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x20,0x50,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x80,0x40,0x28,0x18,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0xf8,0x50,0x50,0xd8,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x90,0x10,0x38,0x10,0x30,0xd8,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x30,0x50,0x60,0x40,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x40,0x80,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x10,0x78,0x90,0xa0,0x80,0x80,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0xa8,0x70,0x20,0xa8,0x70,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0xf8,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x40,0xf8,0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x20,0x20,0x20,0xa8,0x70,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x70,0x50,0x50,0x50,0x70,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x40,0x60,0x40,0x40,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x70,0x40,0x70,0x10,0x70,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x70,0x90,0x90,0x90,0x90,0x00,0x00,0x00,0x00 },
  { 0x70,0x50,0x50,0x50,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x60,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x40,0x70,0x10,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x40,0x70,0x40,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x50,0x70,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x10,0x70,0x40,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x10,0x70,0x50,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x50,0x40,0x40,0x40,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x50,0x70,0x50,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x50,0x70,0x40,0x70,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x90,0x90,0x90,0x90,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x88,0x88,0x78,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x20,0x20,0x20,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x50,0xf8,0x50,0xf8,0x50,0x50,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0xf0,0x28,0x70,0xa0,0x78,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x98,0x40,0x20,0x10,0xc8,0xc0,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x28,0x28,0x10,0xa8,0x48,0xb0,0x00,0x00,0x00,0x00,0x00 },
  { 0xc0,0x40,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x40,0x40,0x40,0x20,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0xa8,0x70,0xf8,0x70,0xa8,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x20,0xf8,0x20,0x20,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x60,0x20,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x60,0x60,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x80,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0xc8,0xa8,0x98,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x30,0x20,0x20,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x80,0x70,0x08,0x08,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x80,0x40,0x60,0x80,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0x60,0x50,0x48,0xf8,0x40,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x08,0x78,0x80,0x80,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x60,0x10,0x08,0x78,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x80,0x80,0x40,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0x70,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0xf0,0x80,0x40,0x30,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x60,0x60,0x00,0x60,0x60,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x60,0x00,0x60,0x20,0x10,0x00,0x00,0x00,0x00 },
  { 0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xf8,0x00,0xf8,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x40,0x80,0x40,0x20,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x80,0x40,0x20,0x00,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x80,0xb0,0xa8,0xa8,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x50,0x88,0x88,0xf8,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x90,0x90,0x70,0x90,0x90,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x08,0x08,0x08,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x90,0x90,0x90,0x90,0x90,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x08,0x08,0x38,0x08,0x08,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x08,0x08,0x38,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0xf0,0x08,0x08,0xc8,0x88,0x88,0xf0,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x88,0xf8,0x88,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x80,0x80,0x80,0x80,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x48,0x28,0x18,0x28,0x48,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x08,0x08,0x08,0x08,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0xd8,0xa8,0xa8,0x88,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x98,0xa8,0xc8,0x88,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x88,0x88,0x78,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0x88,0xa8,0x48,0xb0,0x00,0x00,0x00,0x00,0x00 },
  { 0x78,0x88,0x88,0x78,0x28,0x48,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x08,0x70,0x80,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x20,0x20,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x88,0x88,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x88,0x50,0x50,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x88,0x88,0xa8,0xd8,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x50,0x20,0x50,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x88,0x50,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0xf8,0x80,0x40,0x20,0x10,0x08,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x20,0x50,0x88,0xf8,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x00,0x70,0x88,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x88,0x00,0x88,0x88,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x70,0xa8,0x20,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xf8,0xf8,0xf8,0xf8,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xf0,0x58,0x50,0x50,0x50,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x70,0x80,0xf0,0x88,0xf0,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x68,0x98,0x88,0x98,0x68,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x70,0x88,0x08,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x80,0xb0,0xc8,0x88,0xc8,0xb0,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x70,0x88,0xf8,0x08,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x40,0xa0,0x20,0x70,0x20,0x20,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x70,0x88,0x88,0xf0,0x80,0x70,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x68,0x98,0x88,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x00,0x30,0x20,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x80,0x00,0xc0,0x80,0x80,0x80,0x90,0x60,0x00,0x00,0x00,0x00 },
  { 0x08,0x08,0x48,0x28,0x18,0x28,0x48,0x00,0x00,0x00,0x00,0x00 },
  { 0x30,0x20,0x20,0x20,0x20,0x20,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x58,0xa8,0xa8,0xa8,0xa8,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x68,0x98,0x88,0x88,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x70,0x88,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x68,0x98,0x98,0x68,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xb0,0xc8,0xc8,0xb0,0x80,0x80,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x68,0x98,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xf0,0x08,0x70,0x80,0x78,0x00,0x00,0x00,0x00,0x00 },
  { 0x20,0x20,0xf8,0x20,0x20,0xa0,0x40,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x88,0x88,0xc8,0xb0,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x88,0x88,0x50,0x20,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x88,0xa8,0xa8,0x50,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x50,0x20,0x50,0x88,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x88,0x88,0x88,0xf0,0x80,0x70,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0xf8,0x40,0x20,0x10,0xf8,0x00,0x00,0x00,0x00,0x00 },
  { 0x50,0x00,0x70,0x80,0xf0,0x88,0xf0,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x50,0x00,0x70,0x88,0x88,0x70,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x88,0x00,0x88,0x88,0xc8,0xb0,0x00,0x00,0x00,0x00,0x00 },
  { 0x70,0x88,0x88,0x78,0x88,0x88,0x78,0x08,0x00,0x00,0x00,0x00 },
  { 0xa8,0x50,0xa8,0x50,0xa8,0x50,0xa8,0x50,0x00,0x00,0x00,0x00 },
},

{
  /* CG 11 - Charset for HT-1080Z.
   * Source: http://ht.homeserver.hu/bin/rom/ht_s2_chargen.rom */
  { 0x1f,0x11,0x11,0x11,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x04,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x05,0x06,0x04,0x0c,0x14,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x1b,0x15,0x1b,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x08,0x08,0x05,0x05,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x1f,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x15,0x15,0x1d,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1d,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x17,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x15,0x15,0x17,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x08,0x1c,0x05,0x05,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x0a,0x0a,0x0a,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x07,0x03,0x05,0x08,0x08,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x04,0x08,0x1f,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x15,0x15,0x15,0x15,0x0e,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x15,0x15,0x0e,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x04,0x02,0x1f,0x02,0x04,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x1b,0x15,0x1b,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x15,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x0a,0x04,0x0a,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x02,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x15,0x17,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x17,0x15,0x15,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x1d,0x15,0x15,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x15,0x1d,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x02,0x01,0x01,0x01,0x02,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x15,0x0e,0x04,0x0e,0x15,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0e,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x0c,0x0a,0x1f,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1e,0x10,0x08,0x07,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0c,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x1f,0x01,0x1f,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x11,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x0f,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x11,0x01,0x01,0x19,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x1b,0x15,0x15,0x15,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x13,0x15,0x19,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x15,0x15,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0e,0x15,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x0e,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x00,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x0f,0x11,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x01,0x01,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x1e,0x11,0x11,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x0c,0x00,0x00,0x00 },
  { 0x01,0x01,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x08,0x08,0x08,0x09,0x06,0x00,0x00,0x00 },
  { 0x02,0x02,0x12,0x0a,0x06,0x0a,0x12,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0b,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x11,0x0f,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x1a,0x06,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0e,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x1e,0x10,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x00,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x00,0x11,0x11,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x15,0x0a,0x15,0x0a,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
},

{
  /* CG 12 - Uppercase Charset for Meritum I (Mera-Elzab). */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x18,0x18,0x18,0x18,0x00,0x18,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x28,0x28,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x28,0x6c,0x00,0x6c,0x28,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x38,0x54,0x14,0x38,0x50,0x54,0x38,0x10,0x00 },
  { 0x00,0x00,0x00,0x0c,0x4c,0x20,0x10,0x08,0x64,0x60,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x14,0x14,0x08,0x54,0x24,0x58,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x40,0x20,0x10,0x10,0x10,0x20,0x40,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x10,0x38,0x7c,0x38,0x10,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x10,0x10,0x7c,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x10,0x08 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x64,0x54,0x4c,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x18,0x10,0x10,0x10,0x10,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x40,0x38,0x04,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x40,0x30,0x40,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x30,0x28,0x24,0x7c,0x20,0x20,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x04,0x3c,0x40,0x40,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x30,0x08,0x04,0x3c,0x44,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x40,0x20,0x10,0x08,0x08,0x08,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x44,0x38,0x44,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x44,0x78,0x40,0x20,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x18,0x18,0x10,0x08 },
  { 0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x10,0x20,0x40,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x7c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x20,0x10,0x10,0x00,0x10,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x74,0x54,0x74,0x04,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x44,0x7c,0x44,0x44,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x48,0x48,0x38,0x48,0x48,0x3c,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x04,0x04,0x04,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x48,0x48,0x48,0x48,0x48,0x3c,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x04,0x04,0x3c,0x04,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x04,0x04,0x3c,0x04,0x04,0x04,0x00,0x00 },
  { 0x00,0x00,0x00,0x78,0x04,0x04,0x74,0x44,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x44,0x7c,0x44,0x44,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x10,0x10,0x10,0x10,0x10,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x40,0x40,0x40,0x40,0x40,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x24,0x14,0x0c,0x14,0x24,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x6c,0x54,0x54,0x44,0x44,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x4c,0x54,0x64,0x44,0x44,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x44,0x44,0x44,0x44,0x44,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x44,0x44,0x3c,0x04,0x04,0x04,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x44,0x44,0x54,0x24,0x58,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x44,0x44,0x3c,0x14,0x24,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x08,0x10,0x20,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x10,0x10,0x10,0x10,0x10,0x10,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x44,0x44,0x44,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x44,0x28,0x28,0x10,0x10,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x44,0x54,0x54,0x54,0x28,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x28,0x10,0x28,0x44,0x44,0x00,0x00 },
  { 0x00,0x00,0x00,0x44,0x44,0x28,0x10,0x10,0x10,0x10,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x40,0x20,0x10,0x08,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x70,0x10,0x10,0x10,0x10,0x10,0x70,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1c,0x10,0x10,0x10,0x10,0x10,0x1c,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x28,0x44,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x38,0x44,0x44,0x7c,0x44,0x44,0x64,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x38,0x44,0x04,0x04,0x04,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7c,0x04,0x04,0x3c,0x04,0x04,0x7c,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x04,0x24,0x14,0x0c,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x44,0x4c,0x54,0x64,0x44,0x44,0x44,0x00,0x00 },
  { 0x00,0x20,0x10,0x7c,0x44,0x44,0x44,0x44,0x44,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x38,0x44,0x08,0x10,0x20,0x44,0x38,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x7c,0x40,0x20,0x10,0x08,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x30,0x30,0x7c,0x40,0x20,0x10,0x08,0x04,0x7c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x54,0x28,0x54,0x28,0x54,0x28,0x54,0x00,0x00 },
},

{
  /* CG 13 - Aster CT-80 charset - ROM dump by Fred Jan Kraan:
   * https://electrickery.nl/comp/trs80/doc/aster_chargen.zip */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xe3,0xc1,0x88,0x88,0x80,0x9c,0x9c,0x9c,0x9c,0xff,0xff },
  { 0xff,0xc0,0x99,0x99,0x99,0xc1,0x99,0x99,0x99,0xc0,0xff,0xff },
  { 0xff,0xc3,0x99,0xfc,0xfc,0xfc,0xfc,0xfc,0x99,0xc3,0xff,0xff },
  { 0xff,0xe0,0xc9,0x99,0x99,0x99,0x99,0x99,0xc9,0xe0,0xff,0xff },
  { 0xff,0x80,0x9c,0xfc,0xfc,0xe0,0xfc,0xfc,0x9c,0x80,0xff,0xff },
  { 0xff,0x80,0x9c,0xfc,0xfc,0xe0,0xfc,0xfc,0xfc,0xfc,0xff,0xff },
  { 0xff,0xc3,0x99,0xfc,0xfc,0x8c,0x9c,0x9c,0x89,0xa3,0xff,0xff },
  { 0xff,0x9c,0x9c,0x9c,0x9c,0x80,0x9c,0x9c,0x9c,0x9c,0xff,0xff },
  { 0xff,0xc3,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,0xc3,0xff,0xff },
  { 0xff,0x8f,0x9f,0x9f,0x9f,0x9f,0x9c,0x9c,0x9c,0xc1,0xff,0xff },
  { 0xff,0x9c,0xcc,0xe4,0xf0,0xf8,0xf0,0xe4,0xcc,0x9c,0xff,0xff },
  { 0xff,0xf0,0xf9,0xf9,0xf9,0xf9,0xf9,0xf9,0x99,0x80,0xff,0xff },
  { 0xff,0x9c,0x88,0x80,0x94,0x9c,0x9c,0x9c,0x9c,0x9c,0xff,0xff },
  { 0xff,0x9c,0x9c,0x98,0x90,0x80,0x84,0x8c,0x9c,0x9c,0xff,0xff },
  { 0xff,0xc1,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0xc1,0xff,0xff },
  { 0xff,0xc0,0x9c,0x9c,0x9c,0xc0,0xfc,0xfc,0xfc,0xfc,0xff,0xff },
  { 0xff,0xc1,0x9c,0x9c,0x9c,0x9c,0x9c,0x94,0x94,0xc1,0x8f,0xff },
  { 0xff,0xc0,0x9c,0x9c,0x9c,0xc0,0xe4,0xcc,0xcc,0x9c,0xff,0xff },
  { 0xff,0xc1,0x8c,0xfc,0xf8,0xc1,0x8f,0x9f,0x98,0xc1,0xff,0xff },
  { 0xff,0x00,0x66,0xe7,0xe7,0xe7,0xe7,0xe7,0xe7,0xc3,0xff,0xff },
  { 0xff,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x9c,0x80,0xc1,0xff,0xff },
  { 0xff,0x9c,0x9c,0x9c,0x9c,0x9c,0xc9,0xc9,0xe3,0xe3,0xff,0xff },
  { 0xff,0x9c,0x9c,0x9c,0x9c,0x9c,0x94,0x80,0x88,0x9c,0xff,0xff },
  { 0xff,0x9c,0x9c,0x9c,0xc9,0xe3,0xc9,0x9c,0x9c,0x9c,0xff,0xff },
  { 0xff,0x99,0x99,0x99,0xc3,0xe7,0xe7,0xe7,0xe7,0xe7,0xff,0xff },
  { 0xff,0x80,0x9c,0x8f,0xc7,0xe3,0xf1,0xf8,0x9c,0x80,0xff,0xff },
  { 0x00,0x18,0x0c,0x0c,0x0c,0x06,0x0c,0x0c,0x0c,0x18,0x00,0x00 },
  { 0x00,0x00,0x03,0x06,0x0c,0x18,0x30,0x60,0xc0,0x00,0x00,0x00 },
  { 0x00,0x0c,0x18,0x18,0x18,0x30,0x18,0x18,0x18,0x0c,0x00,0x00 },
  { 0x00,0x08,0x1c,0x36,0x63,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7f,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x08,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x7e,0x24,0x24,0x24,0x7e,0x24,0x24,0x00,0x00 },
  { 0x00,0x08,0x7c,0x0a,0x0a,0x3c,0x48,0x48,0x3e,0x08,0x00,0x00 },
  { 0x00,0x00,0x04,0x4a,0x24,0x10,0x08,0x24,0x52,0x20,0x00,0x00 },
  { 0x00,0x04,0x0a,0x0a,0x04,0x04,0x2a,0x32,0x32,0x5c,0x00,0x00 },
  { 0x00,0x18,0x18,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x04,0x04,0x04,0x04,0x04,0x08,0x10,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x10,0x10,0x10,0x10,0x08,0x04,0x00,0x00 },
  { 0x00,0x00,0x08,0x2a,0x1c,0x3e,0x1c,0x2a,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x08,0x3e,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x0c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x62,0x52,0x4a,0x46,0x42,0x24,0x18,0x00,0x00 },
  { 0x00,0x08,0x0c,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x40,0x38,0x04,0x02,0x42,0x7e,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x40,0x38,0x40,0x40,0x42,0x3c,0x00,0x00 },
  { 0x00,0x20,0x30,0x28,0x24,0x22,0x7e,0x20,0x20,0x20,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x02,0x3e,0x40,0x40,0x42,0x3c,0x00,0x00 },
  { 0x00,0x38,0x04,0x02,0x02,0x3e,0x42,0x42,0x42,0x3c,0x00,0x00 },
  { 0x00,0x7e,0x42,0x40,0x20,0x10,0x08,0x08,0x08,0x08,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x7c,0x40,0x40,0x40,0x3e,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x18,0x00,0x00,0x18,0x18,0x0c,0x00,0x00 },
  { 0x00,0x00,0x20,0x10,0x08,0x04,0x08,0x10,0x20,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x3e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x40,0x20,0x10,0x18,0x00,0x18,0x00,0x00 },
  { 0x00,0x3c,0x42,0x52,0x6a,0x6a,0x7a,0x02,0x42,0x3c,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00 },
  { 0x00,0x3e,0x44,0x44,0x44,0x3c,0x44,0x44,0x44,0x3e,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x02,0x02,0x02,0x02,0x42,0x3c,0x00,0x00 },
  { 0x00,0x1e,0x24,0x44,0x44,0x44,0x44,0x44,0x24,0x1e,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x02,0x1e,0x02,0x02,0x42,0x7e,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x02,0x1e,0x02,0x02,0x02,0x02,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x02,0x72,0x42,0x42,0x62,0x5c,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00 },
  { 0x00,0x1c,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00 },
  { 0x00,0x60,0x40,0x40,0x40,0x40,0x42,0x42,0x42,0x3c,0x00,0x00 },
  { 0x00,0x42,0x22,0x12,0x0a,0x06,0x0a,0x12,0x22,0x42,0x00,0x00 },
  { 0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x04,0x44,0x7e,0x00,0x00 },
  { 0x00,0x42,0x66,0x66,0x5a,0x42,0x42,0x42,0x42,0x42,0x00,0x00 },
  { 0x00,0x42,0x42,0x46,0x4a,0x52,0x62,0x42,0x42,0x42,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x42,0x3e,0x02,0x02,0x02,0x02,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x4a,0x52,0x3c,0x40,0x00 },
  { 0x00,0x3e,0x42,0x42,0x42,0x3e,0x0a,0x12,0x12,0x62,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x02,0x3c,0x40,0x40,0x42,0x3c,0x00,0x00 },
  { 0x00,0x7f,0x49,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x5a,0x5a,0x66,0x42,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x24,0x18,0x24,0x42,0x42,0x42,0x00,0x00 },
  { 0x00,0x22,0x22,0x22,0x1c,0x08,0x08,0x08,0x08,0x08,0x00,0x00 },
  { 0x00,0x7e,0x42,0x20,0x10,0x08,0x04,0x02,0x42,0x7e,0x00,0x00 },
  { 0x00,0x08,0x1c,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00 },
  { 0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x1c,0x08,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x0c,0x7e,0x0c,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x10,0x30,0x7e,0x30,0x10,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00 },
  { 0x00,0x0c,0x0c,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x20,0x3c,0x22,0x22,0x5c,0x00,0x00 },
  { 0x00,0x02,0x02,0x02,0x3a,0x46,0x42,0x42,0x46,0x3a,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x02,0x02,0x22,0x1c,0x00,0x00 },
  { 0x00,0x20,0x20,0x20,0x2c,0x32,0x22,0x22,0x32,0x2c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x3e,0x02,0x22,0x1c,0x00,0x00 },
  { 0x18,0x24,0x04,0x04,0x1e,0x04,0x04,0x04,0x04,0x04,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x22,0x22,0x22,0x3c,0x20,0x20,0x1c },
  { 0x00,0x02,0x02,0x02,0x1a,0x26,0x22,0x22,0x22,0x22,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x0c,0x08,0x08,0x08,0x08,0x1c,0x00,0x00 },
  { 0x00,0x00,0x30,0x00,0x30,0x20,0x20,0x20,0x20,0x20,0x22,0x1c },
  { 0x00,0x02,0x02,0x02,0x22,0x12,0x0a,0x0e,0x12,0x22,0x00,0x00 },
  { 0x00,0x0c,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x16,0x2a,0x2a,0x2a,0x2a,0x2a,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1a,0x26,0x22,0x22,0x22,0x22,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x22,0x22,0x22,0x1c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1a,0x26,0x22,0x22,0x26,0x1a,0x02,0x02 },
  { 0x00,0x00,0x00,0x00,0x2c,0x32,0x22,0x22,0x32,0x2c,0x20,0x20 },
  { 0x00,0x00,0x00,0x00,0x1a,0x26,0x02,0x02,0x02,0x02,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x0c,0x18,0x22,0x1c,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x1e,0x04,0x04,0x04,0x24,0x18,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x32,0x2c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x14,0x14,0x08,0x08,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x2a,0x2a,0x3e,0x14,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x14,0x08,0x08,0x14,0x22,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x32,0x2c,0x20,0x22,0x1c },
  { 0x00,0x00,0x00,0x00,0x3e,0x20,0x18,0x0c,0x02,0x3e,0x00,0x00 },
  { 0x00,0x3e,0x3e,0x06,0x06,0x06,0x06,0x06,0x3e,0x3e,0x00,0x00 },
  { 0x00,0x08,0x08,0x08,0x08,0x00,0x08,0x08,0x08,0x08,0x00,0x00 },
  { 0x00,0x3e,0x3e,0x30,0x30,0x30,0x30,0x30,0x3e,0x3e,0x00,0x00 },
  { 0x00,0x00,0x04,0x2a,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x08,0x1c,0x3e,0x7f,0x7f,0x3e,0x08,0x08,0x00,0x00 },
  { 0x00,0x00,0x00,0x36,0x7f,0x7f,0x3e,0x1c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x1c,0x3e,0x7f,0x3e,0x1c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x1c,0x08,0x6b,0x7f,0x6b,0x08,0x1c,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0xa5,0x81,0xa5,0x99,0x42,0x3c,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0xa5,0x81,0x99,0xa5,0x42,0x3c,0x00,0x00 },
  { 0xff,0xff,0xc3,0x81,0x00,0x00,0x00,0x00,0x81,0xc3,0xff,0xff },
  { 0xff,0xff,0xc3,0xbd,0x7e,0x7e,0x7e,0x7e,0xbd,0xc3,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0x4e,0x31,0x31,0x4e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x42,0x3e,0x42,0x42,0x3e,0x02,0x01,0x00,0x00 },
  { 0x00,0x00,0x43,0x24,0x14,0x0c,0x04,0x06,0x06,0x00,0x00,0x00 },
  { 0x7f,0x7f,0x3f,0x1f,0x1f,0x0f,0x07,0x07,0x03,0x01,0x01,0x00 },
  { 0x00,0x80,0x80,0xc0,0xe0,0xe0,0xf0,0xf8,0xf8,0xfc,0xfe,0xfe },
  { 0x00,0x01,0x01,0x03,0x07,0x07,0x0f,0x1f,0x1f,0x3f,0x7f,0x7f },
  { 0xfe,0xfe,0xfc,0xf8,0xf8,0xf0,0xe0,0xe0,0xc0,0x80,0x80,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x3c,0x7e,0xff,0xff,0xff,0xff,0x7e,0x3c,0x00,0x00 },
  { 0x00,0x00,0x12,0x12,0x12,0x12,0x2e,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x7e,0x7e,0x7e,0x7e,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x9d,0xa5,0x9d,0x95,0xa5,0x42,0x3c,0x00,0x00 },
  { 0x0c,0x12,0x08,0x04,0x1e,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3e,0x15,0x14,0x14,0x14,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x7e,0x1b,0x0f,0x0f,0x1f,0x7e,0x3c,0x00,0x00 },
  { 0x00,0x00,0x3c,0x7e,0xdf,0xff,0xe7,0xc3,0x42,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x7e,0xd8,0xf0,0xf0,0xf8,0x7e,0x3c,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0xc3,0xe7,0xff,0xfb,0x7e,0x3c,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x18,0x3c,0x3c,0x18,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x42,0x81,0xa5,0x81,0x81,0x81,0xff,0xa5,0x00 },
  { 0x00,0x00,0x3c,0x7e,0xff,0xdb,0xff,0xff,0xff,0xff,0xa5,0x00 },
  { 0x00,0x00,0x1c,0x22,0x41,0x41,0x41,0x22,0x14,0x77,0x00,0x00 },
  { 0x55,0xaa,0x55,0xaa,0x55,0xaa,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x55,0xaa,0x55,0xaa,0x55,0xaa },
  { 0x55,0xaa,0x55,0xaa,0x55,0xaa,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0x55,0xaa,0x55,0xaa,0x55,0xaa },
  { 0x06,0x09,0x09,0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x41,0x21,0x11,0x09,0x05,0x3a,0x45,0x30,0x08,0x7c,0x00,0x00 },
  { 0x41,0x21,0x11,0x09,0x25,0x32,0x29,0x7c,0x20,0x20,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10,0x10 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0xff,0x10,0x10,0x10,0x10,0x10 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0xf0,0x10,0x10,0x10,0x10,0x10 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0xff,0x10,0x10,0x10,0x10,0x10 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x10,0x10 },
  { 0x00,0x3c,0x42,0x99,0xa5,0x85,0xa5,0x99,0x42,0x3c,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0xf0,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0x10,0x10,0x10,0x10,0x10 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x10,0x10,0x10,0x10,0x10 },
  { 0x10,0x10,0x10,0x10,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x20,0x40,0x80,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x20,0x10,0x10,0x10 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x04,0x08,0x10,0x10,0x10 },
  { 0x08,0x04,0x04,0x02,0x01,0x01,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x20,0x20,0x40,0x80,0x80,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x80,0x40,0x40,0x20,0x10,0x10 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x01,0x02,0x02,0x04,0x08,0x08 },
  { 0x00,0x00,0x7e,0x40,0x40,0x40,0x48,0x44,0x7e,0x04,0x08,0x00 },
  { 0x1c,0x14,0x1c,0x08,0x3e,0x2a,0x2a,0x08,0x1c,0x22,0x22,0x22 },
  { 0x5d,0x55,0x5d,0x49,0x3e,0x08,0x08,0x08,0x1c,0x22,0x22,0x22 },
  { 0x00,0x08,0x14,0x22,0x41,0x41,0x41,0x41,0x49,0x55,0x63,0x41 },
},

{
  /* CG 14 - Charset for Video Genie, System 80, PMC-80. */
  { 0x1f,0x11,0x11,0x11,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x01,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x04,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x10,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x05,0x06,0x04,0x0c,0x14,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x1b,0x15,0x1b,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x08,0x08,0x05,0x05,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0e,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x1f,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x15,0x15,0x1d,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1d,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x17,0x15,0x15,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x15,0x15,0x17,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x08,0x1c,0x05,0x05,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x0a,0x0a,0x0a,0x0a,0x0a,0x1b,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x1f,0x10,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x07,0x03,0x05,0x08,0x08,0x10,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x04,0x08,0x1f,0x08,0x04,0x03,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x00,0x00,0x1f,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x15,0x15,0x15,0x15,0x0e,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x15,0x15,0x0e,0x15,0x0e,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x18,0x04,0x02,0x1f,0x02,0x04,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x1b,0x15,0x1b,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x15,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x0a,0x04,0x0a,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x02,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x15,0x17,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x17,0x15,0x15,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x11,0x11,0x1d,0x15,0x15,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x15,0x1d,0x11,0x11,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x13,0x08,0x04,0x02,0x19,0x18,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x02,0x01,0x01,0x01,0x02,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x15,0x0e,0x04,0x0e,0x15,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0e,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x0c,0x0a,0x1f,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1c,0x02,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x1e,0x10,0x08,0x07,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x10,0x0c,0x04,0x00,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x15,0x1d,0x0d,0x01,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x11,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x0f,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x01,0x01,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x1e,0x11,0x01,0x01,0x19,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x1b,0x15,0x15,0x15,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x13,0x15,0x19,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x15,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x11,0x15,0x15,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x03,0x03,0x03,0x03,0x03,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x01,0x02,0x04,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x1f,0x18,0x18,0x18,0x18,0x18,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x10,0x1e,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x01,0x01,0x0f,0x11,0x11,0x11,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x01,0x01,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x10,0x10,0x1e,0x11,0x11,0x11,0x1e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x1f,0x01,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x0c,0x00,0x00,0x00 },
  { 0x01,0x01,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x08,0x08,0x08,0x09,0x06,0x00,0x00,0x00 },
  { 0x02,0x02,0x12,0x0a,0x06,0x0a,0x12,0x00,0x00,0x00,0x00,0x00 },
  { 0x06,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0b,0x15,0x15,0x15,0x15,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x11,0x0f,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x1a,0x06,0x02,0x02,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x04,0x0e,0x04,0x04,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x1e,0x10,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x08,0x04,0x04,0x02,0x04,0x04,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x00,0x00,0x00,0x00,0x00 },
  { 0x02,0x04,0x04,0x08,0x04,0x04,0x02,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x15,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0a,0x15,0x0a,0x15,0x0a,0x15,0x0a,0x00,0x00,0x00,0x00,0x00 },
},

{
  /* CG 15 - Charset for EACA EG 3200 (Genie III). */
  { 0x00,0x00,0x3e,0x22,0x22,0x22,0x22,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x02,0x02,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x20,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x0a,0x0c,0x08,0x18,0x28,0x20,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x22,0x36,0x2a,0x36,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x10,0x10,0x0a,0x0a,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x1c,0x22,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x22,0x22,0x3e,0x22,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x2a,0x2a,0x3a,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x3a,0x2a,0x2a,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x2e,0x2a,0x2a,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x2a,0x2a,0x2e,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x10,0x38,0x0a,0x0a,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x14,0x14,0x14,0x14,0x14,0x36,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x20,0x3e,0x20,0x20,0x20,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x06,0x0a,0x10,0x10,0x20,0x20,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x08,0x10,0x3e,0x10,0x08,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x00,0x00,0x3e,0x00,0x00,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x2a,0x2a,0x2a,0x2a,0x1c,0x1c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x2a,0x2a,0x1c,0x2a,0x1c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x30,0x08,0x04,0x3e,0x04,0x08,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x36,0x2a,0x36,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x2a,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x22,0x14,0x08,0x14,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x1c,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x04,0x08,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x3e,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x2a,0x2a,0x2e,0x22,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x22,0x22,0x2e,0x2a,0x2a,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x22,0x22,0x3a,0x2a,0x2a,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x2a,0x2a,0x3a,0x22,0x22,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x14,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x14,0x3e,0x14,0x3e,0x14,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x3c,0x0a,0x1c,0x28,0x1e,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x26,0x10,0x08,0x04,0x32,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x0a,0x0a,0x04,0x2a,0x12,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x10,0x20,0x20,0x20,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x2a,0x1c,0x08,0x1c,0x2a,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x08,0x3e,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x32,0x2a,0x26,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x0c,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x20,0x1c,0x02,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x10,0x18,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x18,0x14,0x3e,0x10,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x1e,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x38,0x04,0x02,0x1e,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x1c,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x3c,0x20,0x10,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x08,0x00,0x08,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x00,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x10,0x20,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x20,0x18,0x08,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x2a,0x3a,0x1a,0x02,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x14,0x22,0x22,0x3e,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x1e,0x22,0x22,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x02,0x02,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x22,0x22,0x22,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x02,0x1e,0x02,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x3c,0x22,0x02,0x02,0x32,0x22,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x3e,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x12,0x0a,0x06,0x0a,0x12,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x36,0x2a,0x2a,0x2a,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x26,0x2a,0x32,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x1e,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x22,0x2a,0x12,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x1e,0x0a,0x12,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x1c,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x2a,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x14,0x14,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x2a,0x2a,0x2a,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x14,0x08,0x14,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x14,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x10,0x08,0x04,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x08,0x14,0x22,0x3e,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x00,0x1c,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x00,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x3e,0x3e,0x3e,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x20,0x3c,0x22,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x1e,0x22,0x22,0x22,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x02,0x02,0x02,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x3c,0x22,0x22,0x22,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x3e,0x02,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x08,0x1c,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x22,0x22,0x22,0x3c,0x20,0x18,0x00 },
  { 0x00,0x00,0x02,0x02,0x1e,0x22,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x0c,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x10,0x00,0x10,0x10,0x10,0x12,0x0c,0x00 },
  { 0x00,0x00,0x04,0x04,0x24,0x14,0x0c,0x14,0x24,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x16,0x2a,0x2a,0x2a,0x2a,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x22,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x22,0x22,0x22,0x1e,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x22,0x22,0x22,0x3c,0x20,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x34,0x0c,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x02,0x1c,0x20,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x1c,0x08,0x08,0x08,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x14,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x2a,0x2a,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x14,0x08,0x14,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x3c,0x20,0x18,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x10,0x08,0x04,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x00,0x1c,0x20,0x3c,0x22,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x14,0x00,0x1c,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x22,0x00,0x22,0x22,0x32,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x1e,0x22,0x22,0x1e,0x02,0x02,0x00 },
  { 0x00,0x00,0x14,0x2a,0x14,0x2a,0x14,0x2a,0x14,0x00,0x00,0x00 },
},

{
  /* CG 16 - EACA EG 3200 (Genie III) charset from Thomas Holte:
   * http://oldcomputers-ddns.org/public/pub/rechner/eaca/genie_3/
   * roms/g3_holte_zs_neu_2516.bin */
  { 0x00,0x00,0x3c,0x02,0x02,0x1c,0x22,0x22,0x1c,0x20,0x20,0x00 },
  { 0x00,0x00,0x22,0x08,0x14,0x22,0x3e,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x00,0x1c,0x12,0x12,0x12,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x1c,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x00,0x1c,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x00,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x00,0x22,0x22,0x22,0x32,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x1e,0x22,0x22,0x1e,0x02,0x02,0x00 },
  { 0x00,0x00,0x08,0x1c,0x2a,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x08,0x2a,0x1c,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x10,0x3e,0x10,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x04,0x3e,0x04,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00 },
  { 0x00,0x00,0x08,0x14,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x14,0x10,0x08,0x04,0x1c,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x10,0x08,0x10,0x14,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x2c,0x12,0x12,0x12,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x1a,0x22,0x22,0x1a,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x34,0x08,0x14,0x22,0x14,0x08,0x00 },
  { 0x00,0x00,0x0c,0x02,0x04,0x0c,0x12,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x02,0x1c,0x02,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x34,0x38,0x08,0x04,0x02,0x02,0x1c,0x20,0x10,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x24,0x24,0x24,0x24,0x20,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x02,0x02,0x02,0x12,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x12,0x0a,0x06,0x0a,0x12,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x08,0x08,0x08,0x14,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x1e,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x12,0x0a,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x14,0x14,0x14,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x22,0x26,0x1a,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x14,0x2a,0x2a,0x2a,0x1c,0x08,0x08,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x22,0x14,0x14,0x36,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x08,0x08,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x14,0x3e,0x14,0x3e,0x14,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x3c,0x0a,0x1c,0x28,0x1e,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x26,0x26,0x10,0x08,0x04,0x32,0x32,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x0a,0x0a,0x04,0x2a,0x12,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x0c,0x08,0x04,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x04,0x04,0x08,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x14,0x08,0x3e,0x08,0x14,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x08,0x3e,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x08,0x04,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x3e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x10,0x08,0x04,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x2a,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x0c,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x20,0x10,0x08,0x04,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x10,0x18,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x08,0x14,0x12,0x3e,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x1e,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x02,0x02,0x1e,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x1c,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x3c,0x20,0x20,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0c,0x0c,0x00,0x0c,0x0c,0x08,0x04,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x00,0x3e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x20,0x18,0x08,0x00,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x3a,0x2a,0x3a,0x02,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x14,0x22,0x22,0x3e,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x24,0x24,0x1c,0x24,0x24,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x02,0x02,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x24,0x24,0x24,0x24,0x24,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x02,0x1e,0x02,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x02,0x02,0x1e,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x3a,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x3e,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x12,0x0a,0x06,0x0a,0x12,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x36,0x2a,0x2a,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x26,0x2a,0x32,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x1e,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x22,0x22,0x2a,0x12,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x22,0x22,0x1e,0x0a,0x12,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x22,0x02,0x1c,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x14,0x14,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x22,0x2a,0x2a,0x2a,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x14,0x08,0x14,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x22,0x22,0x14,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x3e,0x20,0x10,0x08,0x04,0x02,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x04,0x04,0x04,0x04,0x04,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x04,0x08,0x10,0x20,0x20,0x00,0x00,0x00 },
  { 0x00,0x00,0x1c,0x10,0x10,0x10,0x10,0x10,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x14,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3e,0x00 },
  { 0x00,0x00,0x18,0x18,0x08,0x10,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x12,0x12,0x12,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x1e,0x22,0x22,0x22,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x02,0x02,0x02,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x20,0x20,0x3c,0x22,0x22,0x22,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x1e,0x02,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x24,0x04,0x0e,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x22,0x22,0x22,0x3c,0x20,0x1e,0x00 },
  { 0x00,0x00,0x02,0x02,0x1e,0x22,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x0c,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x00,0x10,0x10,0x10,0x10,0x12,0x0c,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x12,0x0a,0x06,0x0a,0x12,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x04,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x2a,0x2a,0x2a,0x2a,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x22,0x22,0x22,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1c,0x22,0x22,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x22,0x22,0x22,0x1e,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x22,0x22,0x22,0x3c,0x20,0x20,0x00 },
  { 0x00,0x00,0x00,0x00,0x1a,0x26,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3c,0x02,0x1c,0x20,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x0e,0x04,0x04,0x24,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x32,0x2c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x14,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x2a,0x2a,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x14,0x08,0x14,0x22,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x22,0x22,0x22,0x22,0x3c,0x20,0x1e,0x00 },
  { 0x00,0x00,0x00,0x00,0x3e,0x10,0x08,0x04,0x3e,0x00,0x00,0x00 },
  { 0x00,0x00,0x18,0x04,0x04,0x02,0x04,0x04,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x08,0x08,0x00,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x10,0x10,0x20,0x10,0x10,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x2a,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3e,0x3e,0x3e,0x3e,0x3e,0x00,0x00,0x00,0x00 },
},

{
  /* CG 17 - TCS SpeedMaster charset (modified) by Thomas Holte:
   * https://oldcomputers-ddns.org/public/pub/rechner/eaca/
   * speedmaster/cpmv22/sys&tool/font.dat */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x12,0x02,0x07,0x02,0x12,0x0f,0x00,0x00,0x00 },
  { 0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x04,0x0e,0x11,0x0f,0x01,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x08,0x08,0x08,0x08,0x08,0x0e,0x00,0x00,0x00 },
  { 0x04,0x0a,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x1f,0x10,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x01,0x01,0x02,0x04,0x08,0x10,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x2c,0x12,0x1a,0x1e,0x16,0x12,0x0d,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x0a,0x05,0x00,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00 },
  { 0x02,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x0a,0x05,0x00,0x0e,0x09,0x09,0x09,0x1e,0x00,0x00,0x00 },
  { 0x00,0x1e,0x17,0x09,0x09,0x07,0x09,0x09,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x02,0x02,0x02,0x02,0x02,0x0e,0x00,0x00,0x00 },
  { 0x0a,0x05,0x00,0x04,0x0a,0x11,0x1f,0x11,0x11,0x00,0x00,0x00 },
  { 0x0a,0x05,0x00,0x11,0x13,0x15,0x19,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x00,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x14,0x0a,0x19,0x15,0x13,0x0a,0x05,0x00,0x00,0x00 },
  { 0x00,0x0a,0x05,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x08,0x08,0x10,0x08,0x08,0x06,0x00,0x00,0x00 },
  { 0x00,0x0a,0x05,0x00,0x06,0x09,0x09,0x09,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0b,0x14,0x0e,0x05,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x02,0x02,0x01,0x02,0x02,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x0e,0x09,0x09,0x09,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x0e,0x09,0x09,0x09,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x1d,0x15,0x1d,0x01,0x0e,0x00,0x00,0x00 },
  { 0x08,0x04,0x1f,0x01,0x01,0x0f,0x01,0x01,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x1e,0x09,0x09,0x1f,0x09,0x19,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x04,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x0a,0x05,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x04,0x04,0x04,0x04,0x00,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x0a,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x0a,0x1f,0x0a,0x1f,0x0a,0x0a,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x1e,0x05,0x0e,0x14,0x0f,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x13,0x13,0x08,0x04,0x02,0x19,0x19,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x05,0x05,0x02,0x15,0x09,0x16,0x00,0x00,0x00 },
  { 0x00,0x00,0x06,0x06,0x04,0x02,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x04,0x02,0x02,0x02,0x04,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x08,0x08,0x08,0x04,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x0a,0x04,0x1f,0x04,0x0a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x04,0x1f,0x04,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x04,0x02,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x1f,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x08,0x04,0x02,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x19,0x15,0x13,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x06,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x10,0x0c,0x02,0x01,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x10,0x08,0x0c,0x10,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x04,0x0a,0x09,0x1f,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x01,0x0f,0x10,0x10,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x01,0x01,0x0f,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x10,0x10,0x08,0x04,0x02,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x0e,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x1e,0x10,0x10,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x06,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x06,0x06,0x00,0x06,0x06,0x04,0x02,0x00 },
  { 0x00,0x00,0x08,0x04,0x02,0x01,0x02,0x04,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1f,0x00,0x1f,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x01,0x02,0x04,0x08,0x04,0x02,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x10,0x0c,0x04,0x00,0x04,0x00,0x00,0x00 },
  { 0x00,0x1e,0x01,0x01,0x0e,0x11,0x11,0x0e,0x10,0x10,0x0f,0x00 },
  { 0x00,0x00,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x12,0x12,0x0e,0x12,0x12,0x0f,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x01,0x01,0x01,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x12,0x12,0x12,0x12,0x12,0x0f,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x01,0x01,0x0f,0x01,0x01,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x01,0x01,0x0f,0x01,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x01,0x1d,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x1f,0x11,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x10,0x10,0x10,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x09,0x05,0x03,0x05,0x09,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x01,0x01,0x01,0x01,0x01,0x01,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x1b,0x15,0x15,0x11,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x13,0x15,0x19,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x0f,0x01,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x15,0x09,0x16,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x0f,0x05,0x09,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x01,0x0e,0x10,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x04,0x04,0x04,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x0a,0x0a,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x0a,0x04,0x0a,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x11,0x11,0x0a,0x04,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x1f,0x10,0x08,0x04,0x02,0x01,0x1f,0x00,0x00,0x00 },
  { 0x11,0x00,0x04,0x0a,0x11,0x11,0x1f,0x11,0x11,0x00,0x00,0x00 },
  { 0x11,0x00,0x0e,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x11,0x00,0x11,0x11,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x0a,0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1f,0x00 },
  { 0x00,0x00,0x0c,0x0c,0x04,0x08,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0e,0x09,0x09,0x09,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x01,0x01,0x0f,0x11,0x11,0x11,0x0f,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x01,0x01,0x01,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x10,0x10,0x1e,0x11,0x11,0x11,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0e,0x11,0x0f,0x01,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x12,0x02,0x07,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x0f,0x00 },
  { 0x00,0x00,0x01,0x01,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x00,0x06,0x04,0x04,0x04,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x00,0x08,0x08,0x08,0x08,0x09,0x06,0x00,0x00 },
  { 0x00,0x00,0x01,0x01,0x09,0x05,0x03,0x05,0x09,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x02,0x02,0x02,0x02,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x15,0x15,0x15,0x15,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x11,0x11,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x11,0x11,0x11,0x0f,0x01,0x01,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x11,0x11,0x11,0x1e,0x10,0x10,0x00 },
  { 0x00,0x00,0x00,0x00,0x0d,0x13,0x01,0x01,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x01,0x0e,0x10,0x0f,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x02,0x07,0x02,0x02,0x12,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x0a,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x15,0x15,0x0a,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x0a,0x04,0x0a,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x1e,0x10,0x0f,0x00 },
  { 0x00,0x00,0x00,0x00,0x1f,0x08,0x04,0x02,0x1f,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x00,0x0e,0x09,0x09,0x09,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0a,0x00,0x11,0x11,0x11,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x0f,0x11,0x11,0x0f,0x01,0x01,0x00 },
  { 0x00,0x00,0x00,0x1f,0x1f,0x1f,0x1f,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00 },
  { 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00 },
  { 0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00 },
  { 0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00 },
  { 0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00 },
  { 0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00 },
  { 0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00 },
  { 0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07 },
  { 0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07 },
  { 0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07 },
  { 0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07 },
  { 0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07 },
  { 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07 },
  { 0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07 },
  { 0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07 },
  { 0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07 },
  { 0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07 },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07 },
  { 0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07 },
  { 0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07 },
  { 0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07 },
  { 0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07 },
  { 0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38 },
  { 0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38 },
  { 0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38 },
  { 0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38 },
  { 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38 },
  { 0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38 },
  { 0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38 },
  { 0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38 },
  { 0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38 },
  { 0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f },
  { 0x07,0x07,0x07,0x07,0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f },
  { 0x38,0x38,0x38,0x38,0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f },
  { 0x3f,0x3f,0x3f,0x3f,0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f },
  { 0x00,0x00,0x00,0x00,0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f },
  { 0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f },
  { 0x38,0x38,0x38,0x38,0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f },
  { 0x3f,0x3f,0x3f,0x3f,0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f },
  { 0x00,0x00,0x00,0x00,0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f },
  { 0x07,0x07,0x07,0x07,0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f },
  { 0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f },
  { 0x3f,0x3f,0x3f,0x3f,0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f },
  { 0x00,0x00,0x00,0x00,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f },
  { 0x07,0x07,0x07,0x07,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f },
  { 0x38,0x38,0x38,0x38,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f },
  { 0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f,0x3f },
  { 0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18,0x18 },
  { 0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x03,0x03,0x03,0x03,0x03 },
  { 0xc0,0xc0,0xc0,0xc0,0xc0,0xff,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x03,0x03,0x03,0x03,0x03,0xff,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x03,0x03,0x03,0x03,0x03 },
  { 0xc0,0xc0,0xc0,0xc0,0xc0,0xff,0xff,0xc0,0xc0,0xc0,0xc0,0xc0 },
  { 0x03,0x03,0x03,0x03,0x03,0xff,0xff,0x03,0x03,0x03,0x03,0x03 },
  { 0x18,0x18,0x18,0x18,0x18,0xff,0xff,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0xff,0xff,0x18,0x18,0x18,0x18,0x18 },
  { 0x00,0x00,0x00,0x00,0x16,0x09,0x09,0x09,0x16,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x0d,0x11,0x11,0x0d,0x01,0x01,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x1a,0x04,0x0a,0x11,0x0a,0x04,0x00 },
  { 0x00,0x00,0x06,0x01,0x02,0x06,0x09,0x11,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x01,0x1e,0x01,0x1e,0x00,0x00,0x00 },
  { 0x00,0x00,0x1a,0x1c,0x04,0x02,0x01,0x01,0x0e,0x10,0x08,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x11,0x11,0x11,0x11,0x10,0x10,0x00 },
  { 0x00,0x00,0x06,0x09,0x0a,0x1c,0x09,0x0a,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x01,0x01,0x01,0x09,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x09,0x05,0x03,0x05,0x09,0x00,0x00,0x00 },
  { 0x00,0x00,0x03,0x04,0x04,0x04,0x0a,0x11,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x11,0x11,0x0f,0x01,0x01,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x11,0x09,0x05,0x03,0x00,0x00,0x00 },
  { 0x00,0x00,0x1a,0x1c,0x02,0x0c,0x02,0x01,0x0e,0x10,0x08,0x00 },
  { 0x00,0x00,0x00,0x00,0x1f,0x0a,0x0a,0x0a,0x0a,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0e,0x11,0x11,0x13,0x0d,0x01,0x01,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x09,0x09,0x09,0x06,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x1e,0x05,0x04,0x04,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x11,0x12,0x12,0x12,0x0c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0a,0x15,0x15,0x15,0x0e,0x04,0x04,0x00 },
  { 0x00,0x00,0x00,0x00,0x13,0x12,0x0a,0x04,0x0a,0x09,0x19,0x00 },
  { 0x00,0x00,0x00,0x00,0x15,0x15,0x15,0x15,0x0e,0x04,0x04,0x00 },
  { 0x00,0x00,0x00,0x00,0x0a,0x11,0x15,0x15,0x0a,0x00,0x00,0x00 },
  { 0x00,0x00,0x0e,0x11,0x11,0x11,0x0a,0x0a,0x1b,0x00,0x00,0x00 },
  { 0x00,0x3c,0x04,0x04,0x04,0x04,0x05,0x06,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x00,0x1f,0x00,0x04,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x3f,0x02,0x04,0x08,0x04,0x02,0x3f,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x26,0x19,0x00,0x26,0x19,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x04,0x0a,0x1f,0x00,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x04,0x04,0x04,0x04,0x04,0x04,0x05,0x02,0x00 },
  { 0x00,0x00,0x20,0x10,0x3f,0x08,0x3f,0x02,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x04,0x08,0x10,0x3f,0x02,0x04,0x08,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x12,0x21,0x21,0x3f,0x12,0x12,0x33,0x00,0x00 },
  { 0x00,0x00,0x00,0x20,0x10,0x09,0x05,0x03,0x01,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x01,0x0e,0x11,0x0e,0x10,0x0f,0x00,0x00,0x00 },
  { 0x15,0x2a,0x15,0x2a,0x15,0x2a,0x15,0x2a,0x15,0x2a,0x15,0x2a },
  { 0x00,0x1e,0x21,0x2d,0x25,0x2d,0x21,0x1e,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x11,0x0e,0x11,0x11,0x0e,0x11,0x00,0x00,0x00 },
  { 0x00,0x00,0x1e,0x15,0x15,0x16,0x14,0x14,0x14,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x04,0x1e,0x05,0x05,0x05,0x1e,0x04,0x00,0x00 },
  { 0x00,0x00,0xfa,0x06,0xc6,0x46,0x26,0xde,0x06,0xfa,0x00,0x00 },
  { 0x00,0x00,0xff,0x20,0xc0,0x3f,0x40,0x3f,0x20,0x1f,0x00,0x00 },
  { 0x00,0x00,0x3f,0x40,0x3f,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x0f,0x11,0x11,0x0f,0x29,0x11,0x29,0x00,0x00,0x00 },
  { 0x00,0x00,0x26,0x11,0x0e,0x14,0x2a,0x11,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x38,0x30,0x28,0x06,0x05,0x05,0x02,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0e,0x11,0x11,0x0e,0x04,0x0e,0x04,0x00 },
  { 0x3c,0x04,0x04,0x3c,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x7f,0x7f,0x63,0x5d,0x5f,0x67,0x77,0x7f,0x77,0x7f,0x7f,0x7f },
  { 0x00,0x04,0x0a,0x04,0x0e,0x15,0x04,0x0a,0x11,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x04,0x0e,0x15,0x0a,0x1f,0x0a,0x00,0x00,0x00 },
  { 0x00,0x04,0x0a,0x11,0x11,0x11,0x15,0x1b,0x11,0x00,0x00,0x00 },
  { 0x00,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x1e,0x00,0x00,0x00 },
  { 0x00,0x02,0x04,0x08,0x10,0x08,0x04,0x02,0x1e,0x00,0x00,0x00 },
},

{
  /* CG 18 - Aster CT-80 CP/M mode - ROM dump by Fred Jan Kraan:
   * https://electrickery.nl/comp/trs80/doc/aster_chargen.zip */
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x18,0x18,0x18,0x00,0x00,0x18,0x00,0x00,0x00 },
  { 0x00,0x24,0x24,0x24,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x24,0x7e,0x24,0x24,0x24,0x7e,0x24,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x3c,0x5a,0x1c,0x38,0x5a,0x3c,0x18,0x00,0x00,0x00 },
  { 0x00,0x04,0x4a,0x24,0x10,0x08,0x24,0x52,0x20,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x14,0x08,0x54,0x24,0x24,0x58,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x10,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x20,0x10,0x08,0x08,0x08,0x08,0x10,0x20,0x00,0x00,0x00 },
  { 0x00,0x04,0x08,0x10,0x10,0x10,0x10,0x08,0x04,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x2a,0x1c,0x3e,0x1c,0x2a,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x08,0x08,0x3e,0x08,0x08,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x10,0x08,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x40,0x20,0x10,0x08,0x04,0x02,0x00,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x52,0x52,0x4a,0x4a,0x24,0x18,0x00,0x00,0x00 },
  { 0x00,0x08,0x0c,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x40,0x38,0x04,0x42,0x7e,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x30,0x30,0x40,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x20,0x30,0x28,0x24,0x22,0x7e,0x20,0x20,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x3e,0x40,0x40,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x38,0x04,0x02,0x02,0x3e,0x42,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x20,0x10,0x10,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x3c,0x42,0x42,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x7c,0x40,0x40,0x3c,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x00,0x00,0x00,0x00,0x18,0x18,0x10,0x08,0x00 },
  { 0x00,0x00,0x10,0x08,0x04,0x02,0x04,0x08,0x10,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x7e,0x00,0x00,0x7e,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x10,0x20,0x40,0x20,0x10,0x08,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x40,0x40,0x30,0x08,0x08,0x00,0x08,0x00,0x00 },
  { 0x00,0x3c,0x42,0x72,0x4a,0x72,0x02,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x18,0x24,0x42,0x42,0x7e,0x42,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x3e,0x42,0x42,0x42,0x3e,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x02,0x02,0x02,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x1e,0x22,0x42,0x42,0x42,0x42,0x22,0x1e,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x1e,0x02,0x02,0x42,0x7e,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x02,0x1e,0x02,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x02,0x7a,0x42,0x62,0x5c,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x7e,0x42,0x42,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x1c,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x70,0x20,0x20,0x20,0x20,0x20,0x22,0x1c,0x00,0x00,0x00 },
  { 0x00,0x42,0x22,0x12,0x0a,0x0e,0x12,0x22,0x42,0x00,0x00,0x00 },
  { 0x00,0x0e,0x04,0x04,0x04,0x04,0x04,0x44,0x7e,0x00,0x00,0x00 },
  { 0x00,0x42,0x66,0x66,0x5a,0x42,0x42,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x46,0x46,0x4a,0x4a,0x52,0x52,0x62,0x62,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3e,0x42,0x42,0x42,0x3e,0x02,0x02,0x02,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x42,0x42,0x42,0x42,0x4a,0x3c,0x54,0x20,0x00 },
  { 0x00,0x3e,0x42,0x42,0x42,0x3e,0x0a,0x12,0x62,0x00,0x00,0x00 },
  { 0x00,0x3c,0x42,0x02,0x0c,0x30,0x40,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x3e,0x08,0x08,0x08,0x08,0x08,0x08,0x08,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x42,0x24,0x18,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x42,0x42,0x42,0x5a,0x66,0x42,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x24,0x18,0x18,0x24,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x7e,0x42,0x20,0x10,0x08,0x04,0x42,0x7e,0x00,0x00,0x00 },
  { 0x00,0x3c,0x0c,0x0c,0x0c,0x0c,0x0c,0x0c,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x02,0x04,0x08,0x10,0x20,0x40,0x00,0x00,0x00,0x00 },
  { 0x00,0x3c,0x30,0x30,0x30,0x30,0x30,0x30,0x3c,0x00,0x00,0x00 },
  { 0x00,0x08,0x14,0x22,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x7e,0x00,0x00,0x00 },
  { 0x00,0x08,0x10,0x20,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x1c,0x20,0x3c,0x22,0x22,0x5c,0x00,0x00,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x42,0x46,0x3a,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x02,0x02,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x40,0x40,0x5c,0x62,0x42,0x42,0x62,0x5c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x7e,0x02,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x30,0x48,0x08,0x3c,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x62,0x5c,0x40,0x3c,0x00 },
  { 0x00,0x02,0x02,0x3a,0x46,0x42,0x42,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x08,0x00,0x0c,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x20,0x00,0x30,0x20,0x20,0x20,0x20,0x20,0x22,0x1c,0x00 },
  { 0x00,0x06,0x04,0x44,0x24,0x14,0x1c,0x24,0x46,0x00,0x00,0x00 },
  { 0x00,0x0c,0x08,0x08,0x08,0x08,0x08,0x08,0x1c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x2a,0x56,0x52,0x52,0x52,0x52,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x42,0x42,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x42,0x42,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3a,0x46,0x42,0x42,0x46,0x3a,0x02,0x02,0x00 },
  { 0x00,0x00,0x00,0x5c,0x62,0x42,0x42,0x62,0x5c,0x40,0x40,0x00 },
  { 0x00,0x00,0x00,0x36,0x4c,0x04,0x04,0x04,0x0e,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x3c,0x42,0x0c,0x30,0x42,0x3c,0x00,0x00,0x00 },
  { 0x00,0x00,0x08,0x3c,0x08,0x08,0x08,0x08,0x30,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x42,0x62,0x5c,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x24,0x24,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x42,0x5a,0x5a,0x24,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x24,0x18,0x18,0x24,0x42,0x00,0x00,0x00 },
  { 0x00,0x00,0x00,0x42,0x42,0x44,0x24,0x28,0x10,0x08,0x06,0x00 },
  { 0x00,0x00,0x00,0x7e,0x22,0x10,0x08,0x44,0x7e,0x00,0x00,0x00 },
  { 0x00,0x00,0x30,0x18,0x18,0x0c,0x18,0x18,0x30,0x00,0x00,0x00 },
  { 0x00,0x18,0x18,0x18,0x00,0x00,0x18,0x18,0x18,0x00,0x00,0x00 },
  { 0x00,0x00,0x0c,0x18,0x18,0x30,0x18,0x18,0x0c,0x00,0x00,0x00 },
  { 0x00,0x4c,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 },
  { 0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0 },
  { 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff },
  { 0x00,0x00,0x00,0x00,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0x0f,0x0f,0x0f,0x0f,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xf0,0xf0,0xf0,0xf0,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xe7,0xe7,0xe7,0xe7,0xe7,0xff,0xff,0xe7,0xff,0xff,0xff },
  { 0xff,0xdb,0xdb,0xdb,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xdb,0x81,0xdb,0xdb,0xdb,0x81,0xdb,0xff,0xff,0xff,0xff },
  { 0xff,0xe7,0xc3,0xa5,0xe3,0xc7,0xa5,0xc3,0xe7,0xff,0xff,0xff },
  { 0xff,0xfb,0xb5,0xdb,0xef,0xf7,0xdb,0xad,0xdf,0xff,0xff,0xff },
  { 0xff,0xf7,0xeb,0xeb,0xf7,0xab,0xdb,0xdb,0xa7,0xff,0xff,0xff },
  { 0xff,0xe7,0xe7,0xef,0xf7,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xdf,0xef,0xf7,0xf7,0xf7,0xf7,0xef,0xdf,0xff,0xff,0xff },
  { 0xff,0xfb,0xf7,0xef,0xef,0xef,0xef,0xf7,0xfb,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xd5,0xe3,0xc1,0xe3,0xd5,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xf7,0xf7,0xc1,0xf7,0xf7,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe7,0xe7,0xef,0xf7,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0x81,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0xff,0xbf,0xdf,0xef,0xf7,0xfb,0xfd,0xff,0xff,0xff,0xff },
  { 0xff,0xe7,0xdb,0xad,0xad,0xb5,0xb5,0xdb,0xe7,0xff,0xff,0xff },
  { 0xff,0xf7,0xf3,0xf7,0xf7,0xf7,0xf7,0xf7,0xe3,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbd,0xbf,0xc7,0xfb,0xbd,0x81,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbf,0xcf,0xcf,0xbf,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xdf,0xcf,0xd7,0xdb,0xdd,0x81,0xdf,0xdf,0xff,0xff,0xff },
  { 0xff,0x81,0xbd,0xfd,0xc1,0xbf,0xbf,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xc7,0xfb,0xfd,0xfd,0xc1,0xbd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0x81,0xbd,0xdf,0xef,0xef,0xf7,0xf7,0xf7,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbd,0xc3,0xbd,0xbd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbd,0xbd,0x83,0xbf,0xbf,0xc3,0xff,0xff,0xff },
  { 0xff,0xe7,0xe7,0xff,0xff,0xff,0xff,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0xe7,0xe7,0xff,0xff,0xff,0xff,0xe7,0xe7,0xef,0xf7,0xff },
  { 0xff,0xff,0xef,0xf7,0xfb,0xfd,0xfb,0xf7,0xef,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0x81,0xff,0xff,0x81,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xf7,0xef,0xdf,0xbf,0xdf,0xef,0xf7,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbf,0xbf,0xcf,0xf7,0xf7,0xff,0xf7,0xff,0xff },
  { 0xff,0xc3,0xbd,0x8d,0xb5,0x8d,0xfd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xe7,0xdb,0xbd,0xbd,0x81,0xbd,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xc1,0xbd,0xbd,0xc1,0xbd,0xbd,0xbd,0xc1,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xfd,0xfd,0xfd,0xfd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xe1,0xdd,0xbd,0xbd,0xbd,0xbd,0xdd,0xe1,0xff,0xff,0xff },
  { 0xff,0x81,0xbd,0xfd,0xe1,0xfd,0xfd,0xbd,0x81,0xff,0xff,0xff },
  { 0xff,0x81,0xbd,0xfd,0xe1,0xfd,0xfd,0xfd,0xfd,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xfd,0xfd,0x85,0xbd,0x9d,0xa3,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xbd,0x81,0xbd,0xbd,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xe3,0xf7,0xf7,0xf7,0xf7,0xf7,0xf7,0xe3,0xff,0xff,0xff },
  { 0xff,0x8f,0xdf,0xdf,0xdf,0xdf,0xdf,0xdd,0xe3,0xff,0xff,0xff },
  { 0xff,0xbd,0xdd,0xed,0xf5,0xf1,0xed,0xdd,0xbd,0xff,0xff,0xff },
  { 0xff,0xf1,0xfb,0xfb,0xfb,0xfb,0xfb,0xbb,0x81,0xff,0xff,0xff },
  { 0xff,0xbd,0x99,0x99,0xa5,0xbd,0xbd,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xb9,0xb9,0xb5,0xb5,0xad,0xad,0x9d,0x9d,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xc1,0xbd,0xbd,0xbd,0xc1,0xfd,0xfd,0xfd,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xbd,0xbd,0xbd,0xbd,0xb5,0xc3,0xab,0xdf,0xff },
  { 0xff,0xc1,0xbd,0xbd,0xbd,0xc1,0xf5,0xed,0x9d,0xff,0xff,0xff },
  { 0xff,0xc3,0xbd,0xfd,0xf3,0xcf,0xbf,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xc1,0xf7,0xf7,0xf7,0xf7,0xf7,0xf7,0xf7,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xbd,0xbd,0xbd,0xbd,0xdb,0xe7,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xbd,0xbd,0xdb,0xdb,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xbd,0xbd,0xbd,0xa5,0x99,0xbd,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xdb,0xe7,0xe7,0xdb,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xbd,0xbd,0xdb,0xdb,0xe7,0xe7,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0x81,0xbd,0xdf,0xef,0xf7,0xfb,0xbd,0x81,0xff,0xff,0xff },
  { 0xff,0xc3,0xf3,0xf3,0xf3,0xf3,0xf3,0xf3,0xc3,0xff,0xff,0xff },
  { 0xff,0xff,0xfd,0xfb,0xf7,0xef,0xdf,0xbf,0xff,0xff,0xff,0xff },
  { 0xff,0xc3,0xcf,0xcf,0xcf,0xcf,0xcf,0xcf,0xc3,0xff,0xff,0xff },
  { 0xff,0xf7,0xeb,0xdd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0x81,0xff,0xff,0xff },
  { 0xff,0xf7,0xef,0xdf,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xe3,0xdf,0xc3,0xdd,0xdd,0xa3,0xff,0xff,0xff },
  { 0xff,0xfd,0xfd,0xc5,0xb9,0xbd,0xbd,0xb9,0xc5,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc3,0xbd,0xfd,0xfd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xbf,0xbf,0xa3,0x9d,0xbd,0xbd,0x9d,0xa3,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc3,0xbd,0x81,0xfd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xcf,0xb7,0xf7,0xc3,0xf7,0xf7,0xf7,0xe3,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc3,0xbd,0xbd,0xbd,0x9d,0xa3,0xbf,0xc3,0xff },
  { 0xff,0xfd,0xfd,0xc5,0xb9,0xbd,0xbd,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xf7,0xff,0xf3,0xf7,0xf7,0xf7,0xf7,0xe3,0xff,0xff,0xff },
  { 0xff,0xdf,0xff,0xcf,0xdf,0xdf,0xdf,0xdf,0xdf,0xdd,0xe3,0xff },
  { 0xff,0xf9,0xfb,0xbb,0xdb,0xeb,0xe3,0xdb,0xb9,0xff,0xff,0xff },
  { 0xff,0xf3,0xf7,0xf7,0xf7,0xf7,0xf7,0xf7,0xe3,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xd5,0xa9,0xad,0xad,0xad,0xad,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc5,0xb9,0xbd,0xbd,0xbd,0xbd,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc3,0xbd,0xbd,0xbd,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc5,0xb9,0xbd,0xbd,0xb9,0xc5,0xfd,0xfd,0xff },
  { 0xff,0xff,0xff,0xa3,0x9d,0xbd,0xbd,0x9d,0xa3,0xbf,0xbf,0xff },
  { 0xff,0xff,0xff,0xc9,0xb3,0xfb,0xfb,0xfb,0xf1,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xc3,0xbd,0xf3,0xcf,0xbd,0xc3,0xff,0xff,0xff },
  { 0xff,0xff,0xf7,0xc3,0xf7,0xf7,0xf7,0xf7,0xcf,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xbd,0xbd,0xbd,0xbd,0x9d,0xa3,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xbd,0xbd,0xdb,0xdb,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xbd,0xbd,0xbd,0xa5,0xa5,0xdb,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xbd,0xdb,0xe7,0xe7,0xdb,0xbd,0xff,0xff,0xff },
  { 0xff,0xff,0xff,0xbd,0xbd,0xbb,0xdb,0xd7,0xef,0xf7,0xf9,0xff },
  { 0xff,0xff,0xff,0x81,0xdd,0xef,0xf7,0xbb,0x81,0xff,0xff,0xff },
  { 0xff,0xff,0xcf,0xe7,0xe7,0xf3,0xe7,0xe7,0xcf,0xff,0xff,0xff },
  { 0xff,0xe7,0xe7,0xe7,0xff,0xff,0xe7,0xe7,0xe7,0xff,0xff,0xff },
  { 0xff,0xff,0xf3,0xe7,0xe7,0xcf,0xe7,0xe7,0xf3,0xff,0xff,0xff },
  { 0xff,0xb3,0xcd,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff },
  { 0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55,0xaa,0x55 },
}

};
