package locales

var dict_ashkenazi_romanian = map[string]string{
	"Achrei Mot": "Aĥrei Mot",
	"Adar": "Odor",
	"Adar I": "Odor Alef",
	"Adar II": "Odor Beis",
	"Arachin": "Arochin",
	"Asara B'Tevet": "Asoro Beteives",
	"Av": "Ov",
	"Avodah Zarah": "Avoydo Zoro",
	"Baba Batra": "Bovo Basro",
	"Baba Kamma": "Bovo Camo",
	"Baba Metzia": "Bovo Meţio",
	"Balak": "Bolok",
	"Bamidbar": "Bamidbor",
	"Bechorot": "Bâĥoiros",
	"Bechukotai": "Beĥucoisai",
	"Beha'alotcha": "Bahaalosĥo",
	"Beitzah": "Beiţo",
	"Berachot": "Broĥos",
	"Bereshit": "Breişis",
	"Beshalach": "Beşalach",
	"Bo": "Boi",
	"Candle lighting": "Hadlokas neiros",
	"Chagigah": "Chagigo",
	"Chanukah": "Ĥanuco",
	"Chanukah: 1 Candle": "Ĥanuco: 1 Candelă",
	"Chanukah: 2 Candles": "Ĥanuco: 2 Candele",
	"Chanukah: 3 Candles": "Ĥanuco: 3 Candele",
	"Chanukah: 4 Candles": "Ĥanuco: 4 Candele",
	"Chanukah: 5 Candles": "Ĥanuco: 5 Candele",
	"Chanukah: 6 Candles": "Ĥanuco: 6 Candele",
	"Chanukah: 7 Candles": "Ĥanuco: 7 Candele",
	"Chanukah: 8 Candles": "Ĥanuco: 8 Candele",
	"Chanukah: 8th Day": "Ĥanuco: a VIII-a Zi",
	"Chayei Sara": "Ĥaiei Soro",
	"Cheshvan": "Ĥeşvon",
	"Chukat": "Ĥukas",
	"Chullin": "Ĥulin",
	"Daf Yomi": "Daf Ioimi",
	"Date out of range in input file. Skipping line %s": "Fecha fuera de rango en el archivo de entrada. Saltando la línea %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Dată în afara gamei în fişierul iahrţeit. Trecere peste linia %s",
	"Days of the Omer": "Zile de Oimer",
	"Devarim": "Dâvorim",
	"Eikev": "Eiqev",
	"Erev Pesach": "Erev Peisaĥ",
	"Erev Rosh Hashana": "Erev Roş-Haşono",
	"Erev Shavuot": "Erev Şâvuos",
	"Erev Simchat Torah": "Erev Simĥas Toiro",
	"Erev Sukkot": "Erev Sucos",
	"Erev Tish'a B'Av": "Erev Tişo Bov",
	"Erev Yom Kippur": "Erev Iom Chipur",
	"Error in input file.  Skipping line %s": "Eroare în fişier de intrare.  Trecere peste linia %s",
	"Error in yahrtzeit file.  Skipping line %s": "Eroare în fişierul iahrţeit.  Trecere peste linia %s",
	"Eruvin": "Eiruvin",
	"Fast begins": "Postul începe",
	"Fast ends": "Postul se încheie",
	"Ha'azinu": "Haazinu",
	"Havdalah": "Havdolo",
	"Horayot": "Hoiroios",
	"Iyyar": "Aior",
	"Kedoshim": "Qdoişim",
	"Keritot": "Cârisos",
	"Ketubot": "Câsubos",
	"Ki Tavo": "Chi-Sovo",
	"Ki Teitzei": "Chi-Seiţei",
	"Ki Tisa": "Chi-Siso",
	"Kiddushin": "Chiduşin",
	"Kinnim": "Chinim",
	"Kislev": "Chislev",
	"Korach": "Coiraĥ",
	"Lag BaOmer": "Lag Boimer",
	"Lech-Lecha": "Lecî-Leko",
	"Leil Selichot": "Sliĥos",
	"Makkot": "Makos",
	"Matot": "Matos",
	"Megillah": "Megillo",
	"Meilah": "Meilo",
	"Menachot": "Menochos",
	"Metzora": "Meţoiro",
	"Midot": "Midos",
	"Miketz": "Miqeiţ",
	"Mishpatim": "Mişpotim",
	"Moed Katan": "Moied Coton",
	"Nasso": "Noso",
	"Nazir": "Nozir",
	"Nedarim": "Nedorim",
	"Niddah": "Nido",
	"Nisan": "Nison",
	"Nitzavim": "Niţovim",
	"Noach": "Noiaĥ",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Lună non-numerică în fişierul iahrţeit. Trecere peste linia %s",
	"Numeric hebrew month in input file.  Skipping line %s": "Lună ebraică în fişier intrare.  Trecere peste linia %s",
	"Parashat": "Parşas",
	"Pekudei": "Pâqudei",
	"Pesach": "Peisaĥ",
	"Pesach Chol ha-Moed Day 1": "Pesah Col ha-Moed Ziua 1",
	"Pesach Chol ha-Moed Day 2": "Pesah Col ha-Moed Ziua 2",
	"Pesach Chol ha-Moed Day 3": "Pesah Col ha-Moed Ziua 3",
	"Pesach Chol ha-Moed Day 4": "Pesah Col ha-Moed Ziua 4",
	"Pesach I": "Peisaĥ I",
	"Pesach I (on Shabbat)": "Pesah I (în sabat)",
	"Pesach II": "Peisaĥ II",
	"Pesach II (CH''M)": "Peisaĥ II (Co''M)",
	"Pesach III (CH''M)": "Peisaĥ III (Co''M)",
	"Pesach IV (CH''M)": "Peisaĥ IV (Co''M)",
	"Pesach Shabbat Chol ha-Moed": "Pesah Shabat Col ha-Moed",
	"Pesach Sheni": "Peisaĥ Şeini",
	"Pesach V (CH''M)": "Peisaĥ V (CH''M)",
	"Pesach VI (CH''M)": "Peisaĥ VI (CH''M)",
	"Pesach VII": "Peisaĥ VII",
	"Pesach VIII": "Peisaĥ VIII",
	"Pesachim": "Pâsoĥim",
	"Pinchas": "Pinĥos",
	"Purim Katan": "Purim Coton",
	"Re'eh": "Reei",
	"Rosh Chodesh": "Roş Ĥoideş",
	"Rosh Chodesh %s": "Roş Ĥydeş %s",
	"Rosh Chodesh Adar": "Roş Hodeş Adar",
	"Rosh Chodesh Adar I": "Roş Hodeş Adar I",
	"Rosh Chodesh Adar II": "Roş Hodeş Adar II",
	"Rosh Chodesh Av": "Roş Hodeş Av",
	"Rosh Chodesh Cheshvan": "Roş Hodeş Ceşvan",
	"Rosh Chodesh Elul": "Roş Hodeş Elul",
	"Rosh Chodesh Iyyar": "Roş Hodeş Aiar",
	"Rosh Chodesh Kislev": "Roş Hodeş Chislev",
	"Rosh Chodesh Nisan": "Roş Hodesh Nisan",
	"Rosh Chodesh Sh'vat": "Roş Hodeş Şâvat",
	"Rosh Chodesh Sivan": "Roş Hodeş Sivan",
	"Rosh Chodesh Tamuz": "Roş Hodeş Tamuz",
	"Rosh Chodesh Tevet": "Roş Hodeş Teives",
	"Rosh Hashana": "Roş Haşono",
	"Rosh Hashana I": "Roş Haşono I",
	"Rosh Hashana I (on Shabbat)": "Roş Haşana I (în Sabat)",
	"Rosh Hashana II": "Roş Haşono II",
	"Sh'lach": "Şlaĥ",
	"Sh'vat": "Şvat",
	"Shabbat": "Şabos",
	"Shabbat Chazon": "Şavos Ĥazon",
	"Shabbat HaChodesh": "Şavos HaĤoideş",
	"Shabbat HaGadol": "Şavos HaGodol",
	"Shabbat Machar Chodesh": "Şavos Moĥor Ĥoideş",
	"Shabbat Nachamu": "Şavos Naĥamu",
	"Shabbat Parah": "Şavos Poro",
	"Shabbat Rosh Chodesh": "Şavos Rosh Ĥoideş",
	"Shabbat Shekalim": "Şavos Şâqolim",
	"Shabbat Shuva": "Şavos Şuvo",
	"Shabbat Zachor": "Şavos Zoĥor",
	"Shavuot": "Şâvuos",
	"Shavuot I": "Şâvuos I",
	"Shavuot II": "Şâvuos II",
	"Shavuot II (on Shabbat)": "Şavuot II (în Sabat)",
	"Shekalim": "Şqolim",
	"Shemot": "Şâmois",
	"Shevuot": "Şâvuos",
	"Shmini": "Şmini",
	"Shmini Atzeret": "Şmini Aţeres",
	"Shoftim": "Şoftim",
	"Shushan Purim": "Şuşon Purim",
	"Simchat Torah": "Simĥas Toiro",
	"Sivan": "Sivon",
	"Sotah": "Soito",
	"Sukkah": "Suco",
	"Sukkot": "Sucos",
	"Sukkot Chol ha-Moed Day 1": "Sucot Col ha-Moed Ziua 1",
	"Sukkot Chol ha-Moed Day 2": "Sucot Col ha-Moed Ziua 2",
	"Sukkot Chol ha-Moed Day 3": "Sucot Col ha-Moed Ziua 3",
	"Sukkot Chol ha-Moed Day 4": "Sucot Col ha-Moed Ziua 4",
	"Sukkot Final Day (Hoshana Raba)": "Ziua finală de Sucot (Hoşana Raba)",
	"Sukkot I": "Sucos I",
	"Sukkot I (on Shabbat)": "Sucot I (în Sabat)",
	"Sukkot II": "Sucos II",
	"Sukkot II (CH''M)": "Sucos II (Co''M)",
	"Sukkot III (CH''M)": "Sucos III (Co''M)",
	"Sukkot IV (CH''M)": "Sucos IV (Co''M)",
	"Sukkot Shabbat Chol ha-Moed": "Sucot Şavat Col ha-Moed",
	"Sukkot V (CH''M)": "Sucos V (CH''M)",
	"Sukkot VI (CH''M)": "Sucos VI (CH''M)",
	"Sukkot VII (Hoshana Raba)": "Sucos VII (Hoişano Rabo)",
	"Ta'anit Bechorot": "Taanis Bîĥoros",
	"Ta'anit Esther": "Taanis Ester",
	"Taanit": "Taanis",
	"Tamid": "Tomid",
	"Tazria": "Tazâria",
	"Temurah": "Tâmuro",
	"Terumah": "Târumo",
	"Tetzaveh": "Teţave",
	"Tevet": "Teives",
	"Tish'a B'Av": "Tişo B'ov",
	"Tish'a B'Av (observed)": "Tişo B'ov (observed)",
	"Tishrei": "Tişrei",
	"Toldot": "Toldos",
	"Tu B'Av": "Tu B'ov",
	"Tu B'Shvat": "Tu BîŞâvat",
	"Tu BiShvat": "Tu BiŞâvat",
	"Tzav": "Ţav",
	"Tzom Gedaliah": "Ţom Gâdalio",
	"Tzom Tammuz": "Ţom Tamuz",
	"Unable to allocate memory for holiday.": "Imposibil de alocat memorie pemtru sărbătorea.",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Lună ebraică nerecunoscută în fişier intrare.  Trecere peste linia %s",
	"Vaera": "Voeiro",
	"Vaetchanan": "Voesĥanan",
	"Vayakhel": "Vaiaqhel",
	"Vayechi": "Vaieĥi",
	"Vayeilech": "Vaieileĥ",
	"Vayera": "Vaieiro",
	"Vayeshev": "Vaieişev",
	"Vayetzei": "Vaieiţei",
	"Vayigash": "Vaiigaş",
	"Vayikra": "Vaiiqro",
	"Vayishlach": "Vaiişlaĥ",
	"Vezot Haberakhah": "Zois Habroco",
	"Yevamot": "Ievomos",
	"Yitro": "Iisro",
	"Yom HaAliyah": "Yom Yerushalayim",
	"Yom HaAtzma'ut": "Iom HaAţma'ut",
	"Yom HaShoah": "Iom HaŞoah",
	"Yom HaZikaron": "Iom HaZiqaron",
	"Yom Kippur": "Iom Chipur",
	"Yom Kippur (Mincha, Alternate)": "Iom Chipur (Minha, Alternare)",
	"Yom Kippur (Mincha, Traditional)": "Iom Chipur (Minha, Tradiţional)",
	"Yom Kippur (on Shabbat)": "Iom Chipur (în Sabat)",
	"Yom Kippur Katan": "Iom Chipur Coton",
	"Yom Yerushalayim": "Iom Ieruşolaiim",
	"Yoma": "Iumo",
	"Zevachim": "Zvochim",
	"day": "zi",
	"day of the Omer": "ziuă de Omer",
	"improper sedra year type calculated.": "tip de an sedra inpropriu calculat.",
	"input file read error. Skipping line %s": "eroare citire fişier de intrare. Trecere peste linia %s",
	"yahrtzeit file read error. Skipping line %s": "eroare citire fişier iahrţeit. Trecere peste linia %s",
}

func Lookup_ashkenazi_romanian(s string) (string, bool) {
	v, ok := dict_ashkenazi_romanian[s]
	if ok {
		return v, true
	}
	return s, false
}
