package locales

var dict_de = map[string]string{
	"Achrei Mot": "Acharei Mot",
	"Asara B'Tevet": "Asara beTewet",
	"Av": "Aw",
	"Avodah Zarah": "Awodah Sara",
	"Baba Metzia": "Baba Mezia",
	"Beha'alotcha": "Behaalotcha",
	"Beitzah": "Beizah",
	"Berachot": "Brachot",
	"Bereshit": "Bereschit",
	"Beshalach": "Beschalach",
	"Candle lighting": "Kerzenzünden",
	"Chanukah": "Channukah",
	"Chanukah: 1 Candle": "Channukah: 1 Kerze",
	"Chanukah: 2 Candles": "Channukah: 2 Kerzen",
	"Chanukah: 3 Candles": "Channukah: 3 Kerzen",
	"Chanukah: 4 Candles": "Channukah: 4 Kerzen",
	"Chanukah: 5 Candles": "Channukah: 5 Kerzen",
	"Chanukah: 6 Candles": "Channukah: 6 Kerzen",
	"Chanukah: 7 Candles": "Channukah: 7 Kerzen",
	"Chanukah: 8 Candles": "Channukah: 8 Kerzen",
	"Chanukah: 8th Day": "Channukah: 8. Tag",
	"Chayei Sara": "Chajei Sara",
	"Cheshvan": "Cheschwan",
	"Daf Yomi": "Daf Jomi",
	"Date out of range in input file. Skipping line %s": "Datum außerhalb des Bereichs in Eingabedatei. Zeile %s übersprungen",
	"Date out of range in yahrtzeit file. Skipping line %s": "Datum außerhalb des Bereichs in Jahrzeit-Datei. Zeile %s übersprungen",
	"Days of the Omer": "Omer-Tage",
	"Devarim": "Dwarim",
	"Eikev": "Eikew",
	"Erev Pesach": "Erew Pessach",
	"Erev Purim": "Erew Purim",
	"Erev Rosh Hashana": "Erew Rosch Haschana",
	"Erev Shavuot": "Erew Schawuot",
	"Erev Simchat Torah": "Erew Simchat Torah",
	"Erev Sukkot": "Erew Sukkot",
	"Erev Tish'a B'Av": "Erew Tischa B'Av",
	"Erev Yom Kippur": "Erew Jom Kippur",
	"Error in input file.  Skipping line %s": "Fehler in Eingabedatei. Zeile %s übersprungen",
	"Error in yahrtzeit file.  Skipping line %s": "Fehler in Jahrzeit-Datei. Zeile %s übersprungen",
	"Eruvin": "Eruwin",
	"Fast begins": "Fasten beginnt",
	"Fast ends": "Fasten endet",
	"Gitin": "Gittin",
	"Ha'azinu": "haazinu",
	"Havdalah": "Hawdalah",
	"Horayot": "Horajot",
	"Iyyar": "Ijar",
	"Kedoshim": "Kedoschim",
	"Ki Tavo": "Ki Tawo",
	"Ki Teitzei": "Ki Tezei",
	"Kiddushin": "Kidduschin",
	"Kislev": "Kislew",
	"Lag BaOmer": "Lag baOmer",
	"Lech-Lecha": "Lech Lecha",
	"Leil Selichot": "Leil Slichot",
	"Metzora": "Mezora",
	"Miketz": "Mikez",
	"Mishpatim": "Mischpatim",
	"Nazir": "Nasir",
	"Nisan": "Nissan",
	"Nitzavim": "Nizawim",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Nicht nummerischer Monat in Jahrzeit-Datei. Zeile %s übersprungen",
	"Numeric hebrew month in input file.  Skipping line %s": "Nummerischer hebräischer Monat in Eingabedatei. Zeile %s übersprungen",
	"Parashat": "Parascha",
	"Pesach": "Pessach",
	"Pesach Chol ha-Moed Day 1": "Pessach Chol haMoed Tag 1",
	"Pesach Chol ha-Moed Day 2": "Pessach Chol haMoed Tag 2",
	"Pesach Chol ha-Moed Day 3": "Pessach Chol haMoed Tag 3",
	"Pesach Chol ha-Moed Day 4": "Pessach Chol haMoed Tag 4",
	"Pesach I": "Pessach I",
	"Pesach I (on Shabbat)": "Pessach I (am Schabbat)",
	"Pesach II": "Pessach II",
	"Pesach II (CH''M)": "Pessach II (Ch''M)",
	"Pesach III (CH''M)": "Pessach III (Ch''M)",
	"Pesach IV (CH''M)": "Pessach IV (Ch''M)",
	"Pesach Shabbat Chol ha-Moed": "Pessach Schabbat Chol haMoed",
	"Pesach Sheni": "Pessach Scheni",
	"Pesach V (CH''M)": "Pessach V (Ch''M)",
	"Pesach VI (CH''M)": "Pessach VI (Ch''M)",
	"Pesach VII": "Pessach VII",
	"Pesach VIII": "Pessach VIII",
	"Pesachim": "Pessachim",
	"Re'eh": "Re'e",
	"Rosh Chodesh": "Rosch Chodesch",
	"Rosh Chodesh %s": "Rosch Chodesch %s",
	"Rosh Chodesh Adar": "Rosch Chodesch Adar",
	"Rosh Chodesh Adar I": "Rosch Chodesch Adar I",
	"Rosh Chodesh Adar II": "Rosch Chodesch Adar II",
	"Rosh Chodesh Av": "Rosch Chodesch Aw",
	"Rosh Chodesh Cheshvan": "Rosch Chodesch Cheschwan",
	"Rosh Chodesh Elul": "Rosch Chodesch Elul",
	"Rosh Chodesh Iyyar": "Rosch Chodesch Ijar",
	"Rosh Chodesh Kislev": "Rosch Chodesch Kislew",
	"Rosh Chodesh Nisan": "Rosch Chodesch Nissan",
	"Rosh Chodesh Sh'vat": "Rosch Chodesch Schwat",
	"Rosh Chodesh Sivan": "Rosch Chodesch Siwan",
	"Rosh Chodesh Tamuz": "Rosch Chodesch Tammus",
	"Rosh Chodesh Tevet": "Rosch Chodesch Tewet",
	"Rosh Hashana": "Rosch haSchana",
	"Rosh Hashana I": "Rosch haSchana I",
	"Rosh Hashana I (on Shabbat)": "Rosch haSchana I (am Schabbat)",
	"Rosh Hashana II": "Rosch HaSchana II",
	"Sh'lach": "Schlach",
	"Sh'vat": "Schwat",
	"Shabbat": "Schabbat",
	"Shabbat Chazon": "Schabbat Chason",
	"Shabbat HaChodesh": "Schabbat haChodesch",
	"Shabbat HaGadol": "Schabbat haGadol",
	"Shabbat Machar Chodesh": "Schabbat Machar Chodesch",
	"Shabbat Nachamu": "Schabbat Nachamu",
	"Shabbat Parah": "Schabat Parah",
	"Shabbat Rosh Chodesh": "Schabat Rosh Chodesch",
	"Shabbat Shekalim": "Schabat Schkalim",
	"Shabbat Shuva": "Schabbat Shuwa",
	"Shabbat Zachor": "Schabat Sachor",
	"Shavuot": "Schawuot",
	"Shavuot I": "Schawuot I",
	"Shavuot II": "Schawuot II",
	"Shavuot II (on Shabbat)": "Schavuot II (am Schabbat)",
	"Shekalim": "Schkalim",
	"Shemot": "Schmot",
	"Shevuot": "Schewuot",
	"Shmini": "Schmini",
	"Shmini Atzeret": "Schmini Azeret",
	"Shoftim": "Schoftim",
	"Shushan Purim": "Schuschan Purim",
	"Sivan": "Siwan",
	"Sukkot Chol ha-Moed Day 1": "Sukkot Chol haMoed Tag 1",
	"Sukkot Chol ha-Moed Day 2": "Sukkot Chol haMoed Tag 2",
	"Sukkot Chol ha-Moed Day 3": "Sukkot Chol haMoed Tag 3",
	"Sukkot Chol ha-Moed Day 4": "Sukkot Chol haMoed Tag 4",
	"Sukkot Final Day (Hoshana Raba)": "Letzter Tag von Sukkot (Hoschana Raba)",
	"Sukkot I (on Shabbat)": "Sukkot I (am Schabat)",
	"Sukkot II (CH''M)": "Sukkot II (Ch''M)",
	"Sukkot III (CH''M)": "Sukkot III (Ch''M)",
	"Sukkot IV (CH''M)": "Sukkot IV (Ch''M)",
	"Sukkot Shabbat Chol ha-Moed": "Sukkot Schabbat Chol haMoed",
	"Sukkot V (CH''M)": "Sukkot V (Ch''M)",
	"Sukkot VI (CH''M)": "Sukkot VI (Ch''M)",
	"Sukkot VII (Hoshana Raba)": "Sukkot VII (Hoschana Raba)",
	"Ta'anit Bechorot": "Taanit Bechorot",
	"Ta'anit Esther": "Taanit Esther",
	"Tamuz": "Tammus",
	"Tazria": "Tasria",
	"Terumah": "Trumah",
	"Tetzaveh": "Tetzaweh",
	"Tevet": "Tewet",
	"Tish'a B'Av": "Tischa b'Aw",
	"Tishrei": "Tischrei",
	"Tu B'Av": "Tu b'Aw",
	"Tu B'Shvat": "Tu beSchwat",
	"Tu BiShvat": "Tu biSchwat",
	"Tzav": "Tzaw",
	"Tzom Gedaliah": "Zom Gedalia",
	"Tzom Tammuz": "Zom Tammus",
	"Unable to allocate memory for holiday.": "Dem Feiertag kann kein Speicher zugewiesen werden.",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Unbekannter hebräischer Monat in Eingabedatei. Zeile %s übersprungen",
	"Vaera": "Wajera",
	"Vaetchanan": "Waetchanan",
	"Vayakhel": "Wajakel",
	"Vayechi": "Wajechi",
	"Vayeilech": "Wajelech",
	"Vayera": "Wajera",
	"Vayeshev": "Wajeschew",
	"Vayetzei": "Wajetze",
	"Vayigash": "Wajigasch",
	"Vayikra": "Wajikra",
	"Vayishlach": "Wajischlach",
	"Vezot Haberakhah": "Wesot haBracha",
	"Yevamot": "Yewamot",
	"Yitro": "Jitro",
	"Yom HaAliyah": "Aliyah-Tag",
	"Yom HaAtzma'ut": "Unabhängigkeitstag",
	"Yom HaShoah": "Jom haSchoa",
	"Yom HaZikaron": "Jom HaSikaron",
	"Yom Kippur": "Jom Kippur",
	"Yom Kippur (Mincha, Alternate)": "Jom Kippur (Mincha, alternativ)",
	"Yom Kippur (Mincha, Traditional)": "Jom Kippur (Mincha, traditionell)",
	"Yom Kippur (on Shabbat)": "Jom Kippur (am Schabbat)",
	"Yom Kippur Katan": "Jom Kippur Katan",
	"Yom Yerushalayim": "Jerusalem-Tag",
	"Yoma": "Joma",
	"Zevachim": "Sewachim",
	"day": "Tag",
	"day of the Omer": "Tag des Omer",
	"improper sedra year type calculated.": "Falscher Jahresart für die Parascha berechnet.",
	"input file read error. Skipping line %s": "Fehler beim Einlesen der Datei. Zeile %s übersprungen",
	"min": "Min",
	"yahrtzeit file read error. Skipping line %s": "Fehler beim Einlesen der Jahrzeit-Datei. Zeile %s übersprungen",
}

func Lookup_de(s string) (string, bool) {
	v, ok := dict_de[s]
	if ok {
		return v, true
	}
	return s, false
}
