package locales

var dict_es = map[string]string{
	"Achrei Mot": "Ajarei Mot",
	"Arachin": "Arajin",
	"Bechorot": "Bejorot",
	"Bechukotai": "Bejukotai",
	"Beha'alotcha": "Behaaloteja",
	"Behar": "Bejar",
	"Berachot": "Berajot",
	"Beshalach": "Beshalaj",
	"Candle lighting": "Iluminación de velas",
	"Chagigah": "Jaguigá",
	"Chanukah": "Jánuca",
	"Chanukah: 1 Candle": "Janucá: 1 vela",
	"Chanukah: 2 Candles": "Janucá: 2 velas",
	"Chanukah: 3 Candles": "Janucá: 3 velas",
	"Chanukah: 4 Candles": "Janucá: 4 velas",
	"Chanukah: 5 Candles": "Janucá: 5 velas",
	"Chanukah: 6 Candles": "Janucá: 6 velas",
	"Chanukah: 7 Candles": "Janucá: 7 velas",
	"Chanukah: 8 Candles": "Janucá: 8 velas",
	"Chanukah: 8th Day": "Janucá: 8º día",
	"Chayei Sara": "Jayei Sara",
	"Cheshvan": "Jeshvan",
	"Chukat": "Jukat",
	"Chullin": "Julín",
	"Date out of range in input file. Skipping line %s": "Fecha fuera de rango en el archivo de entrada. Saltando la línea %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Fecha fuera de rango en el archivo yahrtzeit. Saltando la línea %s",
	"Days of the Omer": "Los días del Omer",
	"Erev Pesach": "Erev Pesaj",
	"Erev Simchat Torah": "Erev Simjat Torá",
	"Erev Sukkot": "Erev Sukot",
	"Error in input file.  Skipping line %s": "Error en el archivo de entrada. Saltando la línea %s",
	"Error in yahrtzeit file.  Skipping line %s": "Error en el archivo yahrtzeit. Saltando la línea %s",
	"Fast begins": "El ayuno comienza",
	"Fast ends": "El ayuno finaliza",
	"Ha'azinu": "Haazinu",
	"Iyyar": "Iyar",
	"Kiddushin": "Keddushin",
	"Kinnim": "Kinim",
	"Korach": "Koraj",
	"Lech-Lecha": "Lej Leja",
	"Leil Selichot": "Leil Selijot",
	"Makkot": "Makot",
	"Meilah": "Meilá",
	"Menachot": "Menajot",
	"Nasso": "Naso",
	"Niddah": "Nidá",
	"Nisan": "Nisán",
	"Noach": "Noaj",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Mes no numérico en el archivo yahrtzeit. Saltando la línea %s",
	"Numeric hebrew month in input file.  Skipping line %s": "El mes hebreo numérico en el archivo de entrada. Saltando la línea %s",
	"Parashat": "Parashá",
	"Pesach": "Pésaj",
	"Pesach Chol ha-Moed Day 1": "Pésaj Jol ha-Moed Día 1",
	"Pesach Chol ha-Moed Day 2": "Pésaj Jol ha-Moed Día 2",
	"Pesach Chol ha-Moed Day 3": "Pésaj Jol ha-Moed Día 3",
	"Pesach Chol ha-Moed Day 4": "Pésaj Jol ha-Moed Día 4",
	"Pesach I": "Pésaj I",
	"Pesach I (on Shabbat)": "Pésaj I (en Shabat)",
	"Pesach II": "Pésaj II",
	"Pesach II (CH''M)": "Pesaj II (J''M)",
	"Pesach III (CH''M)": "Pésaj III (J''M)",
	"Pesach IV (CH''M)": "Pésaj IV (J''M)",
	"Pesach Shabbat Chol ha-Moed": "Pésaj Shabat Jol ha-Moed",
	"Pesach Sheni": "Pésaj Sheni",
	"Pesach V (CH''M)": "Pésaj V (J''M)",
	"Pesach VI (CH''M)": "Pésaj VI (J''M)",
	"Pesach VII": "Pésaj VII",
	"Pesach VIII": "Pésaj VIII",
	"Pesachim": "Pesahim",
	"Pinchas": "Pinjas",
	"Re'eh": "Re´e",
	"Rosh Chodesh": "Rosh Jodesh",
	"Rosh Chodesh %s": "Rosh Jodesh %s",
	"Rosh Chodesh Adar": "Rosh Jodesh Adar",
	"Rosh Chodesh Adar I": "Rosh Jodesh Adar I",
	"Rosh Chodesh Adar II": "Rosh Jodesh Adar II",
	"Rosh Chodesh Av": "Rosh Jodesh Av",
	"Rosh Chodesh Cheshvan": "Rosh Jodesh Jeshvan",
	"Rosh Chodesh Elul": "Rosh Jodesh Elul",
	"Rosh Chodesh Iyyar": "Rosh Jodesh Iyar",
	"Rosh Chodesh Kislev": "Rosh Jodesh Kislev",
	"Rosh Chodesh Nisan": "Rosh Jodesh Nisan",
	"Rosh Chodesh Sh'vat": "Rosh Jodesh Sh'vat",
	"Rosh Chodesh Sivan": "Rosh Jodesh Sivan",
	"Rosh Chodesh Tamuz": "Rosh Jodesh Tamuz",
	"Rosh Chodesh Tevet": "Rosh Jodesh Tevet",
	"Rosh Hashana I (on Shabbat)": "Rosh Hashana I (en Shabat)",
	"Sanhedrin": "Sanedrín",
	"Sh'lach": "Sh'laj",
	"Shabbat": "Shabat",
	"Shabbat Chazon": "Shabbat Jazon",
	"Shabbat HaChodesh": "Shabat HaJodesh",
	"Shabbat HaGadol": "Shabat HaGadol",
	"Shabbat Machar Chodesh": "Shabbat Majar Jodesh",
	"Shabbat Nachamu": "Shabat Najamu",
	"Shabbat Parah": "Shabat Parah",
	"Shabbat Rosh Chodesh": "Shabat Rosh Jodesh",
	"Shabbat Shekalim": "Shabat Shekalim",
	"Shabbat Zachor": "Shabat Zajor",
	"Shabbat times for": "Horarios de Shabat para",
	"Shavuot II (on Shabbat)": "Shavuot II (en Shabat)",
	"Shevuot": "Shavuot",
	"Simchat Torah": "Simját Torá",
	"Sukkah": "Suca",
	"Sukkot": "Sukot",
	"Sukkot Chol ha-Moed Day 1": "Sukot Jol ha-Moed Día 1",
	"Sukkot Chol ha-Moed Day 2": "Sukot Jol ha-Moed Día 2",
	"Sukkot Chol ha-Moed Day 3": "Sukot Jol ha-Moed Día 3",
	"Sukkot Chol ha-Moed Day 4": "Sukot Jol ha-Moed Día 4",
	"Sukkot Final Day (Hoshana Raba)": "Día final de Sukot (Hoshana Raba)",
	"Sukkot I": "Sukot I",
	"Sukkot I (on Shabbat)": "Sucot I (en Shabat)",
	"Sukkot II": "Sukot II",
	"Sukkot II (CH''M)": "Sukot II (J''M)",
	"Sukkot III (CH''M)": "Sukot III (J''M)",
	"Sukkot IV (CH''M)": "Sukot IV (J''M)",
	"Sukkot Shabbat Chol ha-Moed": "Sukot Shabat Jol ha-Moed",
	"Sukkot V (CH''M)": "Sukot V (J''M)",
	"Sukkot VI (CH''M)": "Sukot VI (J''M)",
	"Sukkot VII (Hoshana Raba)": "Sukot VII (Hoshana Raba)",
	"Ta'anit Bechorot": "Ta'anit Bejorot",
	"Ta'anit Esther": "Ta'anit Ester",
	"Taanit": "Tanit",
	"This week's Torah portion is": "La parashá de la semana es",
	"Tish'a B'Av (observed)": "Tish'a B'Av (observado)",
	"Tu B'Shvat": "Tu BiShvat",
	"Unable to allocate memory for holiday.": "No se puede asignar memoria para las vacaciones.",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Un mes hebreo no reconocido en el archivo de entrada. Saltando la línea %s",
	"Vaetchanan": "Vaetjanan",
	"Vayakhel": "Vaiakel",
	"Vayechi": "Vayeji",
	"Vayeilech": "Vayelej",
	"Vayetzei": "Vayetze",
	"Vayishlach": "Vaishlaj",
	"Vezot Haberakhah": "Vezot Haberaja",
	"Yom HaAliyah": "Yom Yerushalayim",
	"Yom Kippur (Mincha, Alternate)": "Yom Kippur (Minja, Alterno)",
	"Yom Kippur (Mincha, Traditional)": "Yom Kipur (Minja, Tradicional)",
	"Yom Kippur (on Shabbat)": "Yom Kipur (en Shabat)",
	"Zevachim": "Zevahim",
	"day": "día",
	"day of the Omer": "día del Omer",
	"improper sedra year type calculated.": "tipo de año de sedra inapropiado calculado.",
	"input file read error. Skipping line %s": "error de lectura del archivo de entrada. Saltando la línea %s",
	"occurs on": "se celebra el",
	"on": "en el",
	"yahrtzeit file read error. Skipping line %s": "error de lectura del archivo yahrtzeit. Saltando la línea %s",
}

func Lookup_es(s string) (string, bool) {
	v, ok := dict_es[s]
	if ok {
		return v, true
	}
	return s, false
}
