package locales

var dict_hu = map[string]string{
	"Achrei Mot": "Ácháré Mot",
	"Adar": "Ádár",
	"Adar I": "Ádár I",
	"Adar II": "Ádár II",
	"Arachin": "Áráchin",
	"Asara B'Tevet": "Ászárá böTévét",
	"Av": "Áv",
	"Avodah Zarah": "Ávodá Zárá",
	"Baba Batra": "Bává Bátrá",
	"Baba Kamma": "Bává Kámá",
	"Baba Metzia": "Bává Möciá",
	"Balak": "Bálák",
	"Bamidbar": "Bámidbár",
	"Bechorot": "Böchorot",
	"Bechukotai": "Bechukotáj",
	"Beha'alotcha": "Beháálotchá",
	"Behar": "Böhár",
	"Beitzah": "Bécá",
	"Berachot": "Bráchot",
	"Bereshit": "Bérésit",
	"Beshalach": "Bösálách",
	"Candle lighting": "Gyertyagyújtás",
	"Chagigah": "Chágigá",
	"Chanukah": "Chánuká",
	"Chanukah: 1 Candle": "Chánuká: 1 gyertya",
	"Chanukah: 2 Candles": "Chánuká: 2 gyertya",
	"Chanukah: 3 Candles": "Chánuká: 3 gyertya",
	"Chanukah: 4 Candles": "Chánuká: 4 gyertya",
	"Chanukah: 5 Candles": "Chánuká: 5 gyertya",
	"Chanukah: 6 Candles": "Chánuká: 6 gyertya",
	"Chanukah: 7 Candles": "Chánuká: 7 gyertya",
	"Chanukah: 8 Candles": "Chánuká: 8 gyertya",
	"Chanukah: 8th Day": "Chánuká: 8. nap",
	"Chayei Sara": "Chájé Szárá",
	"Cheshvan": "Chesván",
	"Chukat": "Chukát",
	"Chullin": "Chulin",
	"Daf Yomi": "Daf Jomi",
	"Date out of range in input file. Skipping line %s": "Dátum a beviteli fájlon kívül. Sor kihagyása %s",
	"Date out of range in yahrtzeit file. Skipping line %s": "Jorcájton kívül eső dátum. Sor kihagyása %s",
	"Days of the Omer": "Az omer napjai",
	"Devarim": "Dvárim",
	"Eikev": "Ékev",
	"Erev Pesach": "Erev Peszách",
	"Erev Rosh Hashana": "Erev Ros hásáná",
	"Erev Shavuot": "Erev Sávuot",
	"Erev Simchat Torah": "Erev Szimchát Tóra",
	"Erev Sukkot": "Erev Szukkot",
	"Erev Tish'a B'Av": "Erev Tisá böÁv",
	"Erev Yom Kippur": "Erev Jom kipur",
	"Error in input file.  Skipping line %s": "Hiba a beviteli fájlban. Sor kihagyása %s",
	"Error in yahrtzeit file.  Skipping line %s": "Hiba a jorcájt fájlban. Sor kihagyása %s",
	"Eruvin": "Éruvin",
	"Fast begins": "A böjt kezdődik",
	"Fast ends": "A böjt végét",
	"Ha'azinu": "Háázinu",
	"Havdalah": "Hávdálá",
	"Horayot": "Horájot",
	"Iyyar": "Ijár",
	"Kedoshim": "Ködosim",
	"Keritot": "Kritot",
	"Ketubot": "Kötubot",
	"Ki Tavo": "Ki Távó",
	"Ki Teitzei": "Ki Técé",
	"Ki Tisa": "Ki Tiszá",
	"Kiddushin": "Kidusin",
	"Kinnim": "Kinim",
	"Kislev": "Kiszlév",
	"Korach": "Korách",
	"Lag BaOmer": "Lág báOmer",
	"Lech-Lecha": "Lech Löchá",
	"Leil Selichot": "Szlichot",
	"Makkot": "Mákot",
	"Masei": "Mászé",
	"Matot": "Mátot",
	"Megillah": "Mögilá",
	"Meilah": "Möilá",
	"Menachot": "Mönáchot",
	"Metzora": "Möcorá",
	"Miketz": "Mikéc",
	"Mishpatim": "Mispátim",
	"Moed Katan": "Moéd Kátán",
	"Nasso": "Nászo",
	"Nazir": "Názír",
	"Nedarim": "Nödárim",
	"Niddah": "Nidá",
	"Nisan": "Niszán",
	"Nitzavim": "Nicávim",
	"Noach": "Noách",
	"Non-numeric month in yahrtzeit file. Skipping line %s": "Nem numerikus hónap a jorcájt fájlban. Sor kihagyása %s",
	"Numeric hebrew month in input file.  Skipping line %s": "Numerikus héber hónap a beviteli fájlban. Sor kihagyása %s",
	"Parashat": "Párását",
	"Pekudei": "Pekudé",
	"Pesach": "Peszách",
	"Pesach I": "Peszách I",
	"Pesach II": "Peszách II",
	"Pesach II (CH''M)": "Peszách II (CH''M)",
	"Pesach III (CH''M)": "Peszách III (CH''M)",
	"Pesach IV (CH''M)": "Peszách IV (CH''M)",
	"Pesach Sheni": "Peszách séni",
	"Pesach V (CH''M)": "Peszách V (CH''M)",
	"Pesach VI (CH''M)": "Peszách VI (CH''M)",
	"Pesach VII": "Peszách VII",
	"Pesach VIII": "Peszách VIII",
	"Pesachim": "Peszáchim",
	"Pinchas": "Pinchász",
	"Purim Katan": "Purim Kátán",
	"Re'eh": "Röé",
	"Rosh Chodesh": "Ros chódes",
	"Rosh Chodesh %s": "Ros chódes %s",
	"Rosh Hashana": "Ros hásáná",
	"Rosh Hashana I": "Ros hásáná I",
	"Rosh Hashana II": "Ros hásáná II",
	"Sanhedrin": "Szánhedrin",
	"Sh'lach": "Slách",
	"Sh'vat": "Svát",
	"Shabbat": "Sábát",
	"Shabbat Chazon": "Sábát Cházon",
	"Shabbat HaChodesh": "Sábát háChódes",
	"Shabbat HaGadol": "Sábát háGádol",
	"Shabbat Machar Chodesh": "Sábát Máchár chódes",
	"Shabbat Nachamu": "Sábát Náchámu",
	"Shabbat Parah": "Sábát Párá",
	"Shabbat Rosh Chodesh": "Sábát Ros chódes",
	"Shabbat Shekalim": "Sábát Skálim",
	"Shabbat Shuva": "Sábát Suvá",
	"Shabbat Zachor": "Sábát Záchor",
	"Shavuot": "Sávuot",
	"Shavuot I": "Sávuot I",
	"Shavuot II": "Sávuot II",
	"Shekalim": "Skálim",
	"Shemot": "Smot",
	"Shevuot": "Sávuot",
	"Shmini": "Smini",
	"Shmini Atzeret": "Smini áceret",
	"Shoftim": "Softim",
	"Shushan Purim": "Susán purim",
	"Simchat Torah": "Szimchát Tóra",
	"Sivan": "Sziván",
	"Sotah": "Szotá",
	"Sukkah": "Szukká",
	"Sukkot": "Szukkot",
	"Sukkot I": "Szukkot I",
	"Sukkot II": "Szukkot II",
	"Sukkot II (CH''M)": "Szukkot II (CH''M)",
	"Sukkot III (CH''M)": "Szukkot III (CH''M)",
	"Sukkot IV (CH''M)": "Szukkot IV (CH''M)",
	"Sukkot V (CH''M)": "Szukkot V (CH''M)",
	"Sukkot VI (CH''M)": "Szukkot VI (CH''M)",
	"Sukkot VII (Hoshana Raba)": "Szukkot VII (Hosáná rábá)",
	"Ta'anit Bechorot": "Táánit Bechorot",
	"Ta'anit Esther": "Táánit Eszter",
	"Taanit": "Táánit",
	"Tamid": "Támid",
	"Tamuz": "Támuz",
	"Tazria": "Tázriá",
	"Temurah": "Tmurá",
	"Terumah": "Trumá",
	"Tetzaveh": "Tecáve",
	"Tevet": "Tévét",
	"Tish'a B'Av": "Tisá böÁv",
	"Tish'a B'Av (observed)": "Tisá böÁv (megfigyelt)",
	"Tu B'Av": "Tu böÁv",
	"Tu B'Shvat": "Tu biSvát",
	"Tu BiShvat": "Tu biSvát",
	"Tzav": "Cáv",
	"Tzom Gedaliah": "Com Gedáljá",
	"Tzom Tammuz": "Com Támuz",
	"Unrecognized hebrew month in input file.  Skipping line %s": "Ismeretlen héber hónap a beviteli fájlban. Sor kihagyása %s",
	"Vaera": "Vaéra",
	"Vaetchanan": "Váetchánán",
	"Vayakhel": "Vájákhél",
	"Vayechi": "Vájechi",
	"Vayeilech": "Vájélech",
	"Vayera": "Váérá",
	"Vayeshev": "Vájésev",
	"Vayetzei": "Vájécé",
	"Vayigash": "Vájigás",
	"Vayikra": "Vájikrá",
	"Vayishlach": "Vájislách",
	"Vezot Haberakhah": "Vözot háböráchá",
	"Yevamot": "Jövámot",
	"Yitro": "Jitró",
	"Yom HaAliyah": "Jom háAlija",
	"Yom HaAtzma'ut": "Jom háÁcmáut",
	"Yom HaShoah": "Jom háSoá",
	"Yom HaZikaron": "Jom háZikáron",
	"Yom Kippur": "Jom kipur",
	"Yom Kippur Katan": "Jom kipur Kátán",
	"Yom Yerushalayim": "Jom Jerusáláim",
	"Yoma": "Jomá",
	"Zevachim": "Zváchim",
	"day": "nap",
	"improper sedra year type calculated.": "Nem megfelelő szidra évtípus lett kiszámítva.",
	"input file read error. Skipping line %s": "Olvasási hiba a beviteli fájlban. Sor kihagyása %s",
	"min": "perc",
	"yahrtzeit file read error. Skipping line %s": "Jorcájt fájl-olvasási hiba. Sor kihagyása %s",
}

func Lookup_hu(s string) (string, bool) {
	v, ok := dict_hu[s]
	if ok {
		return v, true
	}
	return s, false
}
