package locales

var dict_ru = map[string]string{
	"Achrei Mot": "Ахарей Мот",
	"Adar": "Адар",
	"Adar I": "Адар I",
	"Adar II": "Адар II",
	"Arachin": "Арахин",
	"Asara B'Tevet": "Пост 10го Тевета",
	"Av": "Ав",
	"Avodah Zarah": "Авода зара",
	"Baba Batra": "Баба Батра",
	"Baba Kamma": "Баба Кама",
	"Baba Metzia": "Баба Мециа",
	"Balak": "Балак",
	"Bamidbar": "Бамидбар",
	"Bechorot": "Бехорот",
	"Bechukotai": "Бехукотай",
	"Beha'alotcha": "Вегаалотха",
	"Behar": "Бе-ар",
	"Beitzah": "Яйцо",
	"Berachot": "Благословения",
	"Bereshit": "Берешит",
	"Beshalach": "Бешалах",
	"Bo": "Бо",
	"Candle lighting": "Зажигание свечей",
	"Chagigah": "Хагига",
	"Chanukah": "Ханука",
	"Chanukah: 1 Candle": "Ханука: 1 Свеча",
	"Chanukah: 2 Candles": "Ханука: 2 Свечи",
	"Chanukah: 3 Candles": "Ханука: 3 Свечи",
	"Chanukah: 4 Candles": "Ханука: 4 Свечи",
	"Chanukah: 5 Candles": "Ханука: 5 Свечей",
	"Chanukah: 6 Candles": "Ханука: 6 Свечей",
	"Chanukah: 7 Candles": "Ханука: 7 Свечей",
	"Chanukah: 8 Candles": "Ханука: 8 Свечей",
	"Chanukah: 8th Day": "Ханука: 8-ой День",
	"Chayei Sara": "Хаей Сара",
	"Cheshvan": "Хешван",
	"Chukat": "Хукат",
	"Chullin": "Хулин",
	"Daf Yomi": "Страница Дня",
	"Days of the Omer": "Дней Омэра",
	"Devarim": "Дварим",
	"Eikev": "Эйкев",
	"Elul": "Элул",
	"Emor": "Эмор",
	"Erev Pesach": "Вечер Пэсаха",
	"Erev Purim": "Вечер Пурима",
	"Erev Rosh Hashana": "Вечер Рош-А-Шана",
	"Erev Shavuot": "Вечер Шавуота",
	"Erev Simchat Torah": "Канун Симхат Тора",
	"Erev Sukkot": "Вечер Суккота",
	"Erev Tish'a B'Av": "Вечер Девятого Ава",
	"Erev Yom Kippur": "Вечер Дня Раскаяния",
	"Eruvin": "Эрувин",
	"Fast begins": "Пост начинается",
	"Fast ends": "Пост завершается",
	"Gitin": "Гитин",
	"Ha'azinu": "А-Азину",
	"Havdalah": "Авдала",
	"Horayot": "Орайот",
	"Iyyar": "Ияр",
	"Kedoshim": "Кдошим",
	"Keritot": "Критот",
	"Ketubot": "Ктубот",
	"Ki Tavo": "Ки Таво",
	"Ki Teitzei": "Ки Теце",
	"Ki Tisa": "Ки Тиса",
	"Kiddushin": "Кидушин",
	"Kinnim": "Киним",
	"Kislev": "Кислев",
	"Korach": "Корах",
	"Lag BaOmer": "Лаг Ба Омер",
	"Lech-Lecha": "Лех-Леха",
	"Leil Selichot": "Ночь слихот",
	"Makkot": "Макот",
	"Masei": "Масей",
	"Matot": "Матот",
	"Megillah": "Свиток",
	"Meilah": "Меила",
	"Menachot": "Менахот",
	"Metzora": "Мецора",
	"Midot": "Мидот",
	"Miketz": "Микец",
	"Mishpatim": "Мишпатим",
	"Moed Katan": "Моэд Катан",
	"Nasso": "Насо",
	"Nazir": "Назир",
	"Nedarim": "Недарим",
	"Niddah": "Нида",
	"Nisan": "Нисан",
	"Nitzavim": "Ницавим",
	"Noach": "Ноах",
	"Parashat": "Глава",
	"Pekudei": "Пкудей",
	"Pesach": "Пэсах",
	"Pesach I": "Пэсах I",
	"Pesach II": "Пэсах II",
	"Pesach II (CH''M)": "Второй день Пэсах, Холь Амоэд",
	"Pesach III (CH''M)": "Третий день Пэсах, Холь Амоэд",
	"Pesach IV (CH''M)": "Четвертый день Пэсах, Холь Амоэд",
	"Pesach Sheni": "Второй Пэсах",
	"Pesach V (CH''M)": "Пятый день Пэсах, Холь Амоэд",
	"Pesach VI (CH''M)": "Шестой день Пэсах, Холь Амоэд",
	"Pesach VII": "Седьмой день Пэсах",
	"Pesach VIII": "Восьмой день Пэсах",
	"Pesachim": "Песахим",
	"Pinchas": "Пинхас",
	"Purim": "Пурим",
	"Purim Katan": "Маленький Пурим",
	"Re'eh": "Рэ-э",
	"Rosh Chodesh": "Новый Месяц",
	"Rosh Chodesh %s": "Новый Месяц %s",
	"Rosh Hashana": "Рош-А-Шана",
	"Rosh Hashana I": "Рош-А-Шана I",
	"Rosh Hashana II": "Рош-А-Шана II",
	"Sanhedrin": "Сангедрин",
	"Sh'lach": "Шлах",
	"Sh'vat": "Шват",
	"Shabbat": "Шаббат",
	"Shabbat Chazon": "Шаббат Хазон",
	"Shabbat HaChodesh": "Шаббат Месяца",
	"Shabbat HaGadol": "Большой Шаббат",
	"Shabbat Machar Chodesh": "Шаббат Перед Новомесячьем",
	"Shabbat Mevarchim Chodesh": "Шаббат мевархим Новомесячьем",
	"Shabbat Nachamu": "Шаббат Нахаму",
	"Shabbat Parah": "Шаббат Пара",
	"Shabbat Rosh Chodesh": "Шаббат Новомесячья",
	"Shabbat Shekalim": "Шаббат Шкалим",
	"Shabbat Shuva": "Шаббат Шува",
	"Shabbat Zachor": "Шаббат Захор",
	"Shavuot": "Шавуот",
	"Shavuot I": "Шавуот I",
	"Shavuot II": "Шавуот II",
	"Shekalim": "Шкалим",
	"Shemot": "Шмот",
	"Shevuot": "Швуот",
	"Shmini": "Шмини",
	"Shmini Atzeret": "Шмини Ацерет",
	"Shoftim": "Шофтим",
	"Shushan Purim": "Шушан Пурим",
	"Sigd": "Сигд",
	"Simchat Torah": "Симхат Тора",
	"Sivan": "Сиван",
	"Sotah": "Сота",
	"Sukkah": "Сукка",
	"Sukkot": "Суккот",
	"Sukkot I": "Суккот I",
	"Sukkot II": "Суккот II",
	"Sukkot II (CH''M)": "Второй день Суккота (Холь Амоэд)",
	"Sukkot III (CH''M)": "Третий день Суккота (Холь Амоэд)",
	"Sukkot IV (CH''M)": "Четвертый день Суккота (Холь Амоэд)",
	"Sukkot V (CH''M)": "Пятый день Суккота (Холь Амоэд)",
	"Sukkot VI (CH''M)": "Шестой день Суккота (Холь Амоэд)",
	"Sukkot VII (Hoshana Raba)": "Седьмой день Суккота (Ошана Раба)",
	"Ta'anit Bechorot": "Пост первенцев",
	"Ta'anit Esther": "Пост Эстер",
	"Taanit": "Пост",
	"Tamid": "Тамид",
	"Tamuz": "Тамуз",
	"Tazria": "Тазриа",
	"Temurah": "Тмура",
	"Terumah": "Трума",
	"Tetzaveh": "Тецаве",
	"Tevet": "Тевет",
	"Tish'a B'Av": "Девятое Ава",
	"Tish'a B'Av (observed)": "Девятое Ава (отмечается)",
	"Tishrei": "Тишрей",
	"Toldot": "Толдот",
	"Tu B'Av": "Пятнадцатое Ава",
	"Tu B'Shvat": "Пятнадцатое Швата",
	"Tu BiShvat": "Пятнадцатое Швата",
	"Tzav": "Цав",
	"Tzom Gedaliah": "Пост Гедальи",
	"Tzom Tammuz": "Пост Тамуза",
	"Vaera": "Ваера",
	"Vaetchanan": "Ваитханан",
	"Vayakhel": "Ваякгель",
	"Vayechi": "Ваехи",
	"Vayeilech": "Ваелех",
	"Vayera": "Ваера",
	"Vayeshev": "Ваешев",
	"Vayetzei": "Ваеце",
	"Vayigash": "Ваигаш",
	"Vayikra": "Ваикра",
	"Vayishlach": "Ваишлах",
	"Vezot Haberakhah": "Везот Абраха",
	"Yevamot": "Евамот",
	"Yitro": "Итро",
	"Yom HaAtzma'ut": "День Независимости Израиля",
	"Yom HaShoah": "День Катастрофы",
	"Yom HaZikaron": "День Памяти",
	"Yom Kippur": "День Раскаяния",
	"Yom Kippur Katan": "День Раскаяния Катан",
	"Yom Yerushalayim": "День Иерусалима",
	"Yoma": "Йома",
	"Zevachim": "Звахим",
	"day": "день",
	"min": "мин.",
}

func Lookup_ru(s string) (string, bool) {
	v, ok := dict_ru[s]
	if ok {
		return v, true
	}
	return s, false
}
