/*****************************************************************\
*       BBC BASIC for SDL 2.0 (ARM_32)                            *
*       Copyright (c) R. T. Russell, 2018-2024                    *
*                                                                 *
*       BBCDAT.S RAM data definitions                             *
*       Version 1.40a, 12-Mar-2024                                *
\*****************************************************************/

.equ	MAX_PORTS,4
.equ	MAX_FILES,8
.equ	SOUNDQL,20

.global	stavar
.global lc
.global oc
.global pc
.global dynvar
.global fnptr
.global proptr
.global prand
.global accs
.global buff
.global vpage
.global flist
.global lomem
.global pfree
.global himem
.global errtxt
.global onersp
.global errtrp
.global datptr
.global curlin
.global errlin
.global tracen
.global vcount
.global vwidth
.global errnum
.global liston
.global lstopt
.global tmps

.global path
.global keystr
.global keybdq
.global keyptr
.global spchan
.global exchan
.global tweak
.global fcbtab
.global timoff
.global usrchr
.global soundq
.global envels
.global waves
.global libase
.global eventq
.global timtrp
.global clotrp
.global siztrp
.global systrp
.global moutrp
.global alltrp
.global iMsg
.global wParam
.global lParam
.global filbuf
.global portab
.global fvtab

.global forgnd
.global bakgnd
.global hfont
.global colmsk
.global modeno
.global lthick
.global hrect
.global origx
.global origy
.global lastx
.global lasty
.global prevx
.global prevy
.global pfont
.global cmcflg
.global textwl
.global textwr
.global textwt
.global textwb
.global sizex
.global sizey
.global sclflg
.global textx
.global texty
.global charx
.global chary
.global cursa
.global cursb
.global tempo
.global pixelx
.global pixely
.global txtfor
.global txtbak
.global optval
.global farray
.global fasize

.global vduq
.global queue
.global flags
.global kbdqw
.global kbdqr
.global keyexp
.global scroln
.global vflags
.global sndqw
.global sndqr
.global sacc
.global smix
.global evtqw
.global evtqr
.global eenvel
.global escale
.global epsect
.global easect
.global epitch
.global elevel
.global ecount

.global hwndProg
.global zoom
.global offsetx
.global offsety
.global platform
.global memhdc
.global reflag
.global sysflg
.global panx
.global pany
.global prntx
.global prnty
.global prchx
.global prchy
.global cursx
.global bPaletted
.global paperl
.global paperr
.global papert
.global paperb

.global datend
.global sysvar
.global savesp
.global bbcfont
.global lastick
.global link00
.global cmdlen
.global cmdadr
.global dirlen
.global diradr
.global liblen
.global libadr
.global usrlen
.global usradr
.global tmplen
.global tmpadr
.global hwo
.global vdufmt
.global vduvar
.global vduptr
.global voices
.global chrmap
.global breakpt
.global breakhi
.global ttxtfont

.data

/* Variables used by generic modules (bbmain, bbexec, bbeval, bbasmb) */

stavar:	.fill	12,4,0	/* Static variables @% to K% */
lc:	.long	0	/* Static variable L% */
	.long	0,0	/* Static variables M%, N% */
oc:	.long	0	/* Static variable O% */
pc:	.long	0	/* Static variable P% */
	.fill	10,4,0	/* Static variables Q% to Z% */
dynvar:	.fill	54,4,0	/* Pointers to dynamic vars */
fnptr:	.long	0	/* Pointer to user FuNctions */
proptr:	.long	0	/* Pointer to user PROCedures */
accs:	.long	0	/* Pointer to string accumulator */
buff:	.long	0	/* Pointer to string input buffer */
vpage:	.long	0	/* Current value of PAGE */
tracen:	.long	0	/* Maximum line number to trace */
lomem:	.long	0	/* Current value of LOMEM */
pfree:	.long	0	/* Pointer to start of free space */
himem:	.long	0	/* Current value of HIMEM */
libase:	.long	0	/* Pointer to INSTALLed library */
errtxt:	.long	0	/* Pointer to error text for REPORT */
onersp:	.long	0	/* ESP storage for ON ERROR LOCAL */
errtrp:	.long	0	/* Pointer to ON ERROR statement */
datptr:	.long	0	/* Pointer to DATA statements */
vcount:	.long	0	/* Current value of COUNT */
curlin:	.long	0	/* Pointer to current statement */
alltrp:			/* Start of trap pointers */
timtrp:	.long	0	/* Pointer to ON TIME statement */
clotrp:	.long	0	/* Pointer to ON CLOSE statement */
siztrp:	.long	0	/* Pointer to ON MOVE statement */
systrp:	.long	0	/* Pointer to ON SYS statement */
moutrp:	.long	0	/* Pointer to ON MOUSE statement */
errlin:	.long	0	/* Pointer to last error statement */

prand:	.byte	0,0,0,0,0	/* Current 'random' number (5 bytes) */
vwidth:	.byte	0	/* Current value of WIDTH */
errnum:	.byte	0	/* Error code of last error */
liston:	.byte	0	/* *FLOAT / *HEX / *LOWERCASE / OPT */

/* Variables used by OS-specific modules (bbcmos, bbccli, bbcvdu, bbcvtx) */

path:	.long	0	/* Pointer to path/filename buffer */
keystr:	.long	0	/* Pointer to user *KEY strings */
keybdq:	.long	0	/* Pointer to keyboard queue */
eventq:	.long	0	/* Pointer to event queue */
keyptr:	.long	0	/* Pointer to *KEY string */
usrchr:	.long	0	/* Pointer to user-defined characters */

lstopt:	.byte	0	/* LISTO value (indentation) */
sclflg:	.byte	0	/* V5.3 scroll flag (COPY key) */
optval:	.byte	0	/* *OUTPUT and *INPUT values */

/* ------ End of 'absolutely-addressed' variables ------ */

farray:	.byte	0	/* Number of dimensions = 1  | */
fasize:	.long	0	/* Number of elements = 13   | */
filbuf:	.long	0	/* Pointer to file buffers   | */
portab:	.fill	MAX_PORTS,4,0	/* Table of port handles     | */
chntab:	.fill	MAX_FILES,4,0	/* Table of file handles     | */
fcbtab:	.fill	MAX_FILES,4,0	/* Table of FCBs (must follow chntab) */

spchan:	.long	0	/* Channel for *SPOOL/*SPOOLON */
exchan:	.long	0	/* Channel for *EXEC */
sacc:	.long	0,0,0,0	/* Sound accumulators */
smix:	.long	0,0,0,0	/* Stereo mix */

/* Text/graphics metrics (pointed to by @vdu%) */

vduvar:
origx:	.long	0	/* Graphics horizontal origin */
origy:	.long	0	/* Graphics vertical origin */
lastx:	.long	0	/* Immediately preceding x-coordinate */
lasty:	.long	0	/* Immediately preceding y-coordinate */
prevx:	.long	0	/* Previous x-coordinate */
prevy:	.long	0	/* Previous y-coordinate */
textwl:	.long	0	/* Text window left (pixels) */
textwr:	.long	0	/* Text window right (pixels) */
textwt:	.long	0	/* Text window top (pixels) */
textwb:	.long	0	/* Text window bottom (pixels) */
pixelx:	.long	0	/* Width of a graphics pixel */
pixely:	.long	0	/* Height of a graphics pixel */
textx:	.long	0	/* Text pointer (cursor x) */
texty:	.long	0	/* Text pointer (cursor y) */
hfont:	.long	0	/* Handle of current font */
hrect:	.long	0	/* Pointer to clipping rect */

forgnd:	.short	0	/* Graphics foreground colour/action */
bakgnd:	.short	0	/* Graphics background colour/action */

cursa:	.byte	0	/* Start (top) line of cursor */
cursb:	.byte	0	/* Finish (bottom) line of cursor */
txtfor:	.byte	0	/* Text foreground colour */
txtbak:	.byte	0	/* Text background colour */
modeno:	.byte	0	/* Mode number */
colmsk:	.byte	0	/* Mask for maximum number of colours */
vflags:	.byte	0	/* VDU driver flags */
scroln:	.byte	0	/* Scroll counter in paged mode */
cursx:	.byte	0	/* Cursor (caret) width */
lthick:	.byte	0	/* Line thickness (lines, outline shapes) */
cmcflg:	.byte	0	/* cursor movement flags */
tweak:	.byte	0	/* Character spacing adjustment (signed) */ 

sndqw:	.byte	0,0,0,0	/* Sound queue write pointers */
sndqr:	.byte	0,0,0,0	/* Sound queue read pointers */
eenvel:	.byte	0,0,0,0	/* Envelope number */
escale:	.byte	0,0,0,0	/* Envelope scaler */
epsect:	.byte	0,0,0,0	/* Envelope pitch section */
easect:	.byte	0,0,0,0	/* Envelope amplitude section */
epitch:	.byte	0,0,0,0	/* Envelope pitch (frequency) */
ecount:	.byte	0,0,0,0	/* Envelope count */
soundq:	.fill	SOUNDQL,4,0	/* Sound queue (four channels) */

vduq:	.fill	10,1,0	/* VDU queue (must precede 'queue') */
queue:	.byte	0	/* VDU queue status */

kbdqw:	.byte	0	/* Keyboard queue write pointer */
kbdqr:	.byte	0	/* Keyboard queue read pointer */
evtqw:	.byte	0	/* Event queue write pointer */
evtqr:	.byte	0	/* Event queue read pointer */
keyexp:	.byte	0	/* *KEY character counter */

/* ------ End of initialised variables ------ */

datend:

/* The following locations are NOT initialised when program is RUN */
/* (but are guaranteed to be zero on initial execution) */

sizex:	.long	0	/* Total width of client area */
sizey:	.long	0	/* Total height of client area */
charx:	.long	0	/* Average character width */
chary:	.long	0	/* Average character height */
prchx:	.long	0	/* Average character width (printer) */
prchy:	.long	0	/* Average character height (printer) */
paperl:	.long	0	/* Printer left edge */
paperr:	.long	0	/* Printer right edge */
papert:	.long	0	/* Printer top edge */
paperb:	.long	0	/* Printer bottom edge */
prntx:	.long	0	/* Horizontal printing position */
prnty:	.long	0	/* Vertical printing position */

/* ------ End of VDU variables ------ */

/* The following variables are organised as a linked-list at */
/* sysvar, for access via 'system variables' starting with @ */

sysvar:	.long	link2 - sysvar
	.asciz	"memhdc%"
memhdc:	.long	0	/* Shadow screen device context */

link2:	.long	link3 - link2
	.asciz	"wparam%"
wParam:	.long	0	/* Saved wParam for ON xxxx interrupt */

link3:	.long	link4 - link3
	.asciz	"lparam%"
lParam:	.long	0	/* Saved lParam for ON xxxx interrupt */

	.short	0	/* Padding */
link4:	.long	link5 - link4
	.asciz	"hwnd%"
hwndProg: .long	0	/* Handle for program window */

	.short	0	/* Padding */
link5:	.long	link6 - link5
	.asciz	"hpal%"
	.long	palette	/* Colour palette */

link6:	.long	link7 - link6
	.asciz	"ox%"
offsetx:.long	0	/* x-offset memhdc->hwnd */

link7:	.long	link8 - link7
	.asciz	"oy%" 
offsety:.long	0	/* y-offset memhdc->hwnd */

link8:	.long	link9 - link8
	.asciz	"hfile%("
	.long	farray	/* Pointer to file handles array */

	.byte	0,0,0	/* Padding */
link9:	.long	link10 - link9
	.asciz	"msg%"
iMsg:	.long	0	/* Saved iMsg for ON xxxx interrupt */

	.byte	0,0,0	/* Padding */
link10:	.long	link11 - link10
	.asciz	"vdu%"
	.long	vduvar	/* Pointer to VDU variables */

	.short	0	/* Padding */
link11:	.long	link12 - link11
	.asciz	"platform%"
platform: .long	0	/* SDL version & OS */

	.byte	0	/* Padding */
link12:	.long	link13 - link12
	.asciz	"flags%"
tempo:	.byte	0	/* *TEMPO value */
sysflg:	.byte	0	/* *SYS flags */
reflag:	.byte	0	/* *REFRESH flags */
flags:	.byte	0	/* Boolean flags (byte) @ 3FBH */

	.byte	0	/* Padding */
link13:	.long	link14 - link13
	.asciz	"cache%"
	.long	TTFcache /* Font cache */

	.short	0	/* Padding */
link14:	.long	link15 - link14
	.asciz	"zoom%"
zoom:	.long	0

	.byte	0,0,0	/* Padding */
link15:	.long	link16 - link15
	.asciz	"hwo%"
hwo:	.long	0	/* Handle for wave output */

link16:	.long	link17 - link16
	.asciz	"chrmap%"
chrmap:	.long	0

savesp:	.long	0	/* Store for caller's stack pointer */
flist:	.fill	33,4,0	/* Pointers to string free lists */
tmps:	.long	0	/* Temp string descriptor: address */
	.long	0	/* Temp string descriptor: length  */

lastick:.long	0	/* To check for TickCount wraparound */
timoff:	.long	0	/* Offset to add to TickCount */
envels:	.long	0	/* Pointer to ENVELOPEs */
waves:	.long	0	/* Pointer to SOUND waveforms */
voices:	.byte	0,0,0,0	/* Voices (waveforms) for sound channels */
elevel:	.byte	0,0,0,0	/* Envelope level (amplitude) */

	.byte	0,0,0	/* Padding */
link17:	.long	link18 - link17
	.asciz	"dir$"
diradr:	.long	0	/* Load directory address */
dirlen:	.long	0	/* Load directory length */

	.byte	0,0,0	/* Padding */
link18:	.long	link19 - link18
	.asciz	"lib$"
libadr:	.long	0	/* Lib directory address */
liblen:	.long	0	/* Lib directory length */

	.byte	0,0,0	/* Padding */
link19:	.long	link20 - link19
	.asciz	"cmd$"
cmdadr:	.long	0	/* Command line address */
cmdlen:	.long	0	/* Command line length */

	.byte	0,0,0	/* Padding */
link20:	.long	link21 - link20
	.asciz	"usr$"
usradr:	.long	0	/* User directory address */
usrlen:	.long	0	/* User directory length */

	.byte	0,0,0	/* Padding */
link21:	.long	link22 - link21
	.asciz	"tmp$"
tmpadr:	.long	0	/* Temp directory address */
tmplen:	.long	0	/* Temp directory length */

	.byte	0,0,0	/* Padding */
link22:	.long	link23 - link22
	.asciz	"vdu{"
vduptr:	.long	vdufmt	/* Format address */
	.long	vduvar	/* Data address */

	.byte	0	/* Padding */
link23:	.long	link24 - link23
	.asciz	"ispal%"
bPaletted: .long  0	/* Paletted display flag (BOOL) */

	.short	0	/* Padding */
link24:	.long	link25 - link24
	.asciz	"panx%"
panx:	.long	0	/* Horizontal pan */

	.short	0	/* Padding */
link25:	.long	link26 - link25
	.asciz	"pany%"
pany:	.long	0	/* Vertical pan */

	.byte	0	/* Padding */
link26:	.long	link27 - link26
	.asciz	"brkpt%"
breakpt:.long	0	/* Breakpoint (bottom of range) */

	.byte	0	/* Padding */
link27:	.long	link28 - link27
	.asciz	"brkhi%"
breakhi:.long	0	/* Breakpoint (top of range) */

	.short	0	/* Padding */
link28:	.long	link29 - link28
	.asciz	"size{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	sizex	/* Data address */

	.short	0	/* Padding */
link29:	.long	link00 - link29
	.asciz	"char{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	charx	/* Data address */

/* Structure @vdu{o{x%,y%}, l{x%,y%}, p{x%,y%}, tl%, tr%, tt%, tb%, */
/*                d{x%,y%}, c{x%,y%}, hf%, hr%, */
/*                g{a&,b&,c&,d&}, t{a&,b&,c&,d&}, m{a&,b&,c&,d&}} */

	.byte	0	/* Padding */
vdufmt:	.long	sndqw-vduvar	/* Total length (bytes) */

vlnk00:	.long	vlnk01 - vlnk00	/* Link to next */
	.asciz	"o{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	origx-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk01:	.long	vlnk02 - vlnk01
	.asciz	"l{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	lastx-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk02:	.long	vlnk03 - vlnk02
	.asciz	"p{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	prevx-vduvar	/* Data offset */

vlnk03:	.long	vlnk04 - vlnk03
	.asciz	"tl%"	/* Member name */
	.long	textwl-vduvar	/* Data offset */

vlnk04:	.long	vlnk05 - vlnk04
	.asciz	"tr%"	/* Member name */
	.long	textwr-vduvar	/* Data offset */

vlnk05:	.long	vlnk06 - vlnk05
	.asciz	"tt%"	/* Member name */
	.long	textwt-vduvar	/* Data offset */

vlnk06:	.long	vlnk07 - vlnk06
	.asciz	"tb%"	/* Member name */
	.long	textwb-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk07:	.long	vlnk08 - vlnk07
	.asciz	"d{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	pixelx-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk08:	.long	vlnk09 - vlnk08
	.asciz	"c{"	/* Member name */
	.long	ptfmt	/* Format address */
	.long	textx-vduvar	/* Data offset */

vlnk09:	.long	vlnk10 - vlnk09
	.asciz	"hf%"	/* Member name */
	.long	hfont-vduvar	/* Data offset */

vlnk10:	.long	vlnk11 - vlnk10
	.asciz	"hr%"	/* Member name */
	.long	hrect-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk11:	.long	vlnk12 - vlnk11
	.asciz	"g{"	/* Member name */
	.long	b4fmt	/* Format address */
	.long	forgnd-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk12:	.long	vlnk13 - vlnk12
	.asciz	"t{"	/* Member name */
	.long	b4fmt	/* Format address */
	.long	cursa-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk13:	.long	vlnk14 - vlnk13
	.asciz	"m{"	/* Member name */
	.long	b4fmt	/* Format address */
	.long	modeno-vduvar	/* Data offset */

	.byte	0	/* Padding */
vlnk14:	.long	0
	.asciz	"w{"	/* Member name */
	.long	b4fmt	/* Format address */
	.long	cursx-vduvar	/* Data offset */

	.byte	0,0,0	/* Padding */
link00:	.long	0	/* End of list */
	.asciz	"fn%("
	.long	fnarr	/* Pointer to function array */

/* Structure {x%,y%} */

ptfmt:	.long	8		/* Total length (bytes) */
ptlnk0:	.long	ptlnk1 - ptlnk0	/* Link to next member */
	.asciz	"x%"		/* Member name */
	.long	0		/* Member offset (bytes) */
ptlnk1:	.long	0		/* Terminating link */
	.asciz	"y%"		/* Member name */
	.long	4		/* Member offset (bytes) */

/* Structure {a&,b&,c&,d&} */

b4fmt:	.long	4		/* Total length (bytes) */
b4lnk0:	.long	b4lnk1 - b4lnk0	/* Link to next member */
	.asciz	"a&"		/* Member name */
	.long	0		/* Member offset (bytes) */
b4lnk1:	.long	b4lnk2 - b4lnk1	/* Link to next member */
	.asciz	"b&"		/* Member name */
	.long	1		/* Member offset (bytes) */
b4lnk2:	.long	b4lnk3 - b4lnk2	/* Link to next member */
	.asciz	"c&"		/* Member name */
	.long	2		/* Member offset (bytes) */
b4lnk3:	.long	0		/* Terminating link */
	.asciz	"d&"		/* Member name */
	.long	3		/* Member offset (bytes) */

/* Array of function entry points */

fnarr:	.byte	1		/* Number of dimensions */
	.long	22		/* Number of entries */
	.long	loadn		/* Load numeric */
	.long	loads		/* Load string */
	.long	storen		/* Store numeric */
	.long	stores		/* Store string */
	.long	getvar		/* Get variable address & type */
	.long	putvar		/* Create a variable */
	.long	expr		/* Evaluate expression */
	.long	item		/* Evaluate item */
	.long	lexan		/* Lexical analysis (tokenise) */
	.long	token		/* Print character or keyword */
	.long	xfloat		/* Convert integer to float */
	.long	xfix		/* Convert float to integer */
	.long	str		/* Convert a number to a string */
	.long	con		/* Convert a string to a number */
	.long	sortup		/* (Reserved in BBCSDL) */
	.long	sortdn		/* (Reserved in BBCSDL) */
	.long	0		/* Reserved for hook */
	.long	xeq		/* Run BASIC code */
	.long	putevt		/* Put event in queue */
	.long	gfxPrimitivesGetFont
	.long	gfxPrimitivesSetFont
	.long	RedefineChar

	.text

fvtab:	.byte	1		/* &19 v&  Unsigned byte (8 bits) */
	.byte	4		/* &1A v%  Signed dword (32 bits) */
	.byte	8		/* &1B v#  Float double (64 bits) */
	.byte	10		/* &1C v   Variant numeric (80 bits) */
	.byte	24		/* &1D v{} Structure (4+4 bytes) */
	.byte	40		/* &1E v%% Signed qword (64 bits) */
	.byte	136		/* &1F v$  String (4+4 bytes) */

	.align	8
bbcfont:
	.byte	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /* NUL */
	.byte	0x7E,0x81,0xA5,0x81,0xBD,0x99,0x81,0x7E /* SOH */
	.byte	0x7E,0xFF,0xDB,0xFF,0xC3,0xE7,0xFF,0x7E /* STX */
	.byte	0x6C,0xFE,0xFE,0xFE,0x7C,0x38,0x10,0x00 /* ETX */
	.byte	0x10,0x38,0x7C,0xFE,0x7C,0x38,0x10,0x00 /* EOT */
	.byte	0x10,0x38,0x38,0xD6,0xFE,0xD6,0x10,0x38 /* ENQ */
	.byte	0x10,0x38,0x7C,0xFE,0xFE,0xFE,0x38,0x7C /* ACK */
	.byte	0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00 /* BEL */
	.byte	0xFF,0xFF,0xE7,0xC3,0xC3,0xE7,0xFF,0xFF /* BS */
	.byte	0x00,0x3C,0x66,0x42,0x42,0x66,0x3C,0x00 /* HT */
	.byte	0xFF,0xC3,0x99,0xBD,0xBD,0x99,0xC3,0xFF /* LF */
	.byte	0x0F,0x07,0x0F,0x7D,0xCC,0xCC,0xCC,0x78 /* VT */
	.byte	0x3C,0x66,0x66,0x66,0x3C,0x18,0x7E,0x18 /* FF */
	.byte	0x3F,0x33,0x3F,0x30,0x30,0x70,0xF0,0xE0 /* CR */
	.byte	0x7F,0x63,0x7F,0x63,0x63,0x67,0xE6,0xC0 /* SO */
	.byte	0x99,0x5A,0x3C,0xE7,0xE7,0x3C,0x5A,0x99 /* SI */
	.byte	0x80,0xE0,0xF8,0xFE,0xF8,0xE0,0x80,0x00 /* DLE */
	.byte	0x02,0x0E,0x3E,0xFE,0x3E,0x0E,0x02,0x00 /* DC1 */
	.byte	0x18,0x3C,0x7E,0x18,0x18,0x7E,0x3C,0x18 /* DC2 */
	.byte	0x66,0x66,0x66,0x66,0x66,0x00,0x66,0x00 /* DC3 */
	.byte	0x7F,0xDB,0xDB,0x7B,0x1B,0x1B,0x1B,0x00 /* DC4 */
	.byte	0x3E,0x63,0x38,0x6C,0x6C,0x38,0xCC,0x78 /* NAK */
	.byte	0x00,0x00,0x00,0x00,0x7E,0x7E,0x7E,0x00 /* SYN */
	.byte	0x18,0x3C,0x7E,0x18,0x7E,0x3C,0x18,0xFF /* ETB */
	.byte	0x18,0x3C,0x7E,0x18,0x18,0x18,0x18,0x00 /* CAN */
	.byte	0x18,0x18,0x18,0x18,0x7E,0x3C,0x18,0x00 /* EM */
	.byte	0x00,0x18,0x0C,0xFE,0x0C,0x18,0x00,0x00 /* SUB */
	.byte	0x00,0x30,0x60,0xFE,0x60,0x30,0x00,0x00 /* ESC */
	.byte	0x00,0x00,0xC0,0xC0,0xC0,0xFE,0x00,0x00 /* FS */
	.byte	0x00,0x24,0x66,0xFF,0x66,0x24,0x00,0x00 /* GS */
	.byte	0x00,0x18,0x3C,0x7E,0xFF,0xFF,0x00,0x00 /* RS */
	.byte	0x00,0xFF,0xFF,0x7E,0x3C,0x18,0x00,0x00 /* US */
	.byte	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x30,0x30,0x30,0x30,0x30,0x00,0x30,0x00 /* ! */
	.byte	0x6C,0x6C,0x6C,0x00,0x00,0x00,0x00,0x00 /* " */
	.byte	0x6C,0x6C,0xFE,0x6C,0xFE,0x6C,0x6C,0x00 /* # */
	.byte	0x18,0x7E,0xD0,0x7C,0x16,0xFC,0x30,0x00 /* $ */
	.byte	0xC0,0xCC,0x18,0x30,0x60,0xCC,0x0C,0x00 /* % */
	.byte	0x38,0x6C,0x38,0x76,0xDC,0xCC,0x76,0x00 /* & */
	.byte	0x18,0x30,0x60,0x00,0x00,0x00,0x00,0x00 /* ' */
	.byte	0x18,0x30,0x60,0x60,0x60,0x30,0x18,0x00 /* ( */
	.byte	0x60,0x30,0x18,0x18,0x18,0x30,0x60,0x00 /* ) */
	.byte	0x00,0x6C,0x38,0xFE,0x38,0x6C,0x00,0x00 /* * */
	.byte	0x00,0x30,0x30,0xFC,0x30,0x30,0x00,0x00 /* + */
	.byte	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x60 /* , */
	.byte	0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0x00 /* - */
	.byte	0x00,0x00,0x00,0x00,0x00,0x30,0x30,0x00 /* . */
	.byte	0x00,0x0C,0x18,0x30,0x60,0xC0,0x00,0x00 /* / */
	.byte	0x78,0xCC,0xDC,0xFC,0xEC,0xCC,0x78,0x00 /* 0 */
	.byte	0x30,0x70,0x30,0x30,0x30,0x30,0xFC,0x00 /* 1 */
	.byte	0x78,0xCC,0x0C,0x18,0x30,0x60,0xFC,0x00 /* 2 */
	.byte	0x78,0xCC,0x0C,0x38,0x0C,0xCC,0x78,0x00 /* 3 */
	.byte	0x18,0x38,0x78,0xD8,0xFC,0x18,0x18,0x00 /* 4 */
	.byte	0xFC,0xC0,0xF8,0x0C,0x0C,0xCC,0x78,0x00 /* 5 */
	.byte	0x38,0x60,0xC0,0xF8,0xCC,0xCC,0x78,0x00 /* 6 */
	.byte	0xFC,0x0C,0x18,0x30,0x60,0x60,0x60,0x00 /* 7 */
	.byte	0x78,0xCC,0xCC,0x78,0xCC,0xCC,0x78,0x00 /* 8 */
	.byte	0x78,0xCC,0xCC,0x7C,0x0C,0x18,0x70,0x00 /* 9 */
	.byte	0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x00 /* : */
	.byte	0x00,0x00,0x30,0x30,0x00,0x30,0x30,0x60 /* ; */
	.byte	0x18,0x30,0x60,0xC0,0x60,0x30,0x18,0x00 /* < */
	.byte	0x00,0x00,0xFC,0x00,0xFC,0x00,0x00,0x00 /* = */
	.byte	0x60,0x30,0x18,0x0C,0x18,0x30,0x60,0x00 /* > */
	.byte	0x78,0xCC,0x18,0x30,0x30,0x00,0x30,0x00 /* ? */
	.byte	0x78,0xCC,0xDC,0xD4,0xDC,0xC0,0x78,0x00 /* @ */
	.byte	0x78,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00 /* A */
	.byte	0xF8,0xCC,0xCC,0xF8,0xCC,0xCC,0xF8,0x00 /* B */
	.byte	0x78,0xCC,0xC0,0xC0,0xC0,0xCC,0x78,0x00 /* C */
	.byte	0xF0,0xD8,0xCC,0xCC,0xCC,0xD8,0xF0,0x00 /* D */
	.byte	0xFC,0xC0,0xC0,0xF8,0xC0,0xC0,0xFC,0x00 /* E */
	.byte	0xFC,0xC0,0xC0,0xF8,0xC0,0xC0,0xC0,0x00 /* F */
	.byte	0x78,0xCC,0xC0,0xDC,0xCC,0xCC,0x78,0x00 /* G */
	.byte	0xCC,0xCC,0xCC,0xFC,0xCC,0xCC,0xCC,0x00 /* H */
	.byte	0xFC,0x30,0x30,0x30,0x30,0x30,0xFC,0x00 /* I */
	.byte	0x7C,0x18,0x18,0x18,0x18,0xD8,0x70,0x00 /* J */
	.byte	0xCC,0xD8,0xF0,0xE0,0xF0,0xD8,0xCC,0x00 /* K */
	.byte	0xC0,0xC0,0xC0,0xC0,0xC0,0xC0,0xFC,0x00 /* L */
	.byte	0xC6,0xEE,0xFE,0xD6,0xD6,0xC6,0xC6,0x00 /* M */
	.byte	0xCC,0xCC,0xEC,0xFC,0xDC,0xCC,0xCC,0x00 /* N */
	.byte	0x78,0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x00 /* O */
	.byte	0xF8,0xCC,0xCC,0xF8,0xC0,0xC0,0xC0,0x00 /* P */
	.byte	0x78,0xCC,0xCC,0xCC,0xDC,0x78,0x1C,0x00 /* Q */
	.byte	0xF8,0xCC,0xCC,0xF8,0xD8,0xCC,0xCC,0x00 /* R */
	.byte	0x78,0xCC,0xC0,0x78,0x0C,0xCC,0x78,0x00 /* S */
	.byte	0xFC,0x30,0x30,0x30,0x30,0x30,0x30,0x00 /* T */
	.byte	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x00 /* U */
	.byte	0xCC,0xCC,0xCC,0xCC,0xCC,0x78,0x30,0x00 /* V */
	.byte	0xC6,0xC6,0xD6,0xD6,0xFE,0xEE,0xC6,0x00 /* W */
	.byte	0xCC,0xCC,0x78,0x30,0x78,0xCC,0xCC,0x00 /* X */
	.byte	0xCC,0xCC,0xCC,0x78,0x30,0x30,0x30,0x00 /* Y */
	.byte	0xFC,0x0C,0x18,0x30,0x60,0xC0,0xFC,0x00 /* Z */
	.byte	0xF8,0xC0,0xC0,0xC0,0xC0,0xC0,0xF8,0x00 /* [ */
	.byte	0x00,0xC0,0x60,0x30,0x18,0x0C,0x00,0x00 /* \ */
	.byte	0x7C,0x0C,0x0C,0x0C,0x0C,0x0C,0x7C,0x00 /* ] */
	.byte	0x10,0x38,0x6C,0xC6,0x00,0x00,0x00,0x00 /* ^ */
	.byte	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xFF /* _ */
	.byte	0x60,0x30,0x18,0x00,0x00,0x00,0x00,0x00 /* ` */
	.byte	0x00,0x00,0x78,0x0C,0x7C,0xCC,0x7C,0x00 /* a */
	.byte	0xC0,0xC0,0xF8,0xCC,0xCC,0xCC,0xF8,0x00 /* b */
	.byte	0x00,0x00,0x78,0xCC,0xC0,0xCC,0x78,0x00 /* c */
	.byte	0x0C,0x0C,0x7C,0xCC,0xCC,0xCC,0x7C,0x00 /* d */
	.byte	0x00,0x00,0x78,0xCC,0xFC,0xC0,0x78,0x00 /* e */
	.byte	0x38,0x60,0x60,0xF8,0x60,0x60,0x60,0x00 /* f */
	.byte	0x00,0x00,0x7C,0xCC,0xCC,0x7C,0x0C,0x78 /* g */
	.byte	0xC0,0xC0,0xF8,0xCC,0xCC,0xCC,0xCC,0x00 /* h */
	.byte	0x30,0x00,0x70,0x30,0x30,0x30,0x78,0x00 /* i */
	.byte	0x30,0x00,0x70,0x30,0x30,0x30,0x30,0xE0 /* j */
	.byte	0xC0,0xC0,0xCC,0xD8,0xF0,0xD8,0xCC,0x00 /* k */
	.byte	0x70,0x30,0x30,0x30,0x30,0x30,0x78,0x00 /* l */
	.byte	0x00,0x00,0x6C,0xFE,0xD6,0xD6,0xC6,0x00 /* m */
	.byte	0x00,0x00,0xF8,0xCC,0xCC,0xCC,0xCC,0x00 /* n */
	.byte	0x00,0x00,0x78,0xCC,0xCC,0xCC,0x78,0x00 /* o */
	.byte	0x00,0x00,0xF8,0xCC,0xCC,0xF8,0xC0,0xC0 /* p */
	.byte	0x00,0x00,0x7C,0xCC,0xCC,0x7C,0x0C,0x0E /* q */
	.byte	0x00,0x00,0xD8,0xEC,0xC0,0xC0,0xC0,0x00 /* r */
	.byte	0x00,0x00,0x7C,0xC0,0x78,0x0C,0xF8,0x00 /* s */
	.byte	0x60,0x60,0xF8,0x60,0x60,0x60,0x38,0x00 /* t */
	.byte	0x00,0x00,0xCC,0xCC,0xCC,0xCC,0x7C,0x00 /* u */
	.byte	0x00,0x00,0xCC,0xCC,0xCC,0x78,0x30,0x00 /* v */
	.byte	0x00,0x00,0xC6,0xD6,0xD6,0xFE,0x6C,0x00 /* w */
	.byte	0x00,0x00,0xCC,0x78,0x30,0x78,0xCC,0x00 /* x */
	.byte	0x00,0x00,0xCC,0xCC,0xCC,0x7C,0x0C,0x78 /* y */
	.byte	0x00,0x00,0xFC,0x18,0x30,0x60,0xFC,0x00 /* z */
	.byte	0x18,0x30,0x30,0xE0,0x30,0x30,0x18,0x00 /* { */
	.byte	0x30,0x30,0x30,0x00,0x30,0x30,0x30,0x00 /* | */
	.byte	0x60,0x30,0x30,0x1C,0x30,0x30,0x60,0x00 /* } */
	.byte	0x76,0xDC,0x00,0x00,0x00,0x00,0x00,0x00 /* ~ */
	.byte	0x00,0x10,0x38,0x6C,0xC6,0xC6,0xFE,0x00 /* DEL */
	.byte	0x3C,0x62,0xF8,0x60,0xF8,0x62,0x3C,0x00 /* &80 euro symbol */
	.byte	0x00,0x7E,0x7E,0x7E,0x7E,0x7E,0x7E,0x00 /* &81 block (teletext) */
	.byte	0x00,0x00,0x00,0x00,0x00,0x18,0x18,0x30 /* &82 single low quotation mark */
	.byte	0x00,0x0C,0x18,0x18,0x3C,0x18,0x18,0x70 /* &83 small letter f with hook */
	.byte	0x00,0x00,0x00,0x00,0x00,0x6C,0x6C,0xD8 /* &84 double low quotation mark */
	.byte	0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x00 /* &85 horizontal ellipsis */
	.byte	0x18,0x18,0x7E,0x18,0x18,0x18,0x18,0x00 /* &86 dagger */
	.byte	0x18,0x18,0x7E,0x18,0x18,0x7E,0x18,0x18 /* &87 double dagger */
	.byte	0x10,0x38,0x6C,0x00,0x00,0x00,0x00,0x00 /* &88 circumflex accent */
	.byte	0xC6,0xCC,0x18,0x30,0x60,0xDB,0x1B,0x00 /* &89 per mille */
	.byte	0x38,0x7C,0xC6,0x70,0x1C,0xC6,0x7C,0x00 /* &8A capital S caron */
	.byte	0x00,0x18,0x30,0x60,0x30,0x18,0x00,0x00 /* &8B left angle quotation mark */
	.byte	0x7E,0xD8,0xD8,0xDE,0xD8,0xD8,0x7E,0x00 /* &8C capital OE ligature */
	.byte	0x30,0x78,0xFC,0x30,0x30,0x30,0x30,0x00 /* &8D up arrow (teletext) */
	.byte	0x38,0xFE,0x0C,0x18,0x30,0x60,0xFE,0x00 /* &8E capital Z caron */
	.byte	0x00,0x20,0x60,0xFE,0x60,0x20,0x00,0x00 /* &8F left arrow (teletext) */
	.byte	0x00,0x08,0x0C,0xFE,0x0C,0x08,0x00,0x00 /* &90 right arrow (teletext) */
	.byte	0x30,0x30,0x18,0x00,0x00,0x00,0x00,0x00 /* &91 left single quotation mark */
	.byte	0x18,0x18,0x30,0x00,0x00,0x00,0x00,0x00 /* &92 right single quotation mark */
	.byte	0x6C,0x6C,0x36,0x00,0x00,0x00,0x00,0x00 /* &93 left double quotation mark */
	.byte	0x36,0x36,0x6C,0x00,0x00,0x00,0x00,0x00 /* &94 right double quotation mark */
	.byte	0x00,0x00,0x18,0x3C,0x3C,0x18,0x00,0x00 /* &95 bullet */
	.byte	0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0x00 /* &96 en dash */
	.byte	0x00,0x00,0x00,0xFF,0x00,0x00,0x00,0x00 /* &97 em dash */
	.byte	0x36,0x6C,0x00,0x00,0x00,0x00,0x00,0x00 /* &98 small tilde */
	.byte	0xEA,0x4E,0x4A,0x4A,0x00,0x00,0x00,0x00 /* &99 trade mark sign */
	.byte	0x6C,0x38,0x7C,0xC0,0x78,0x0C,0xF8,0x00 /* &9A small S caron */
	.byte	0x00,0x30,0x18,0x0C,0x18,0x30,0x00,0x00 /* &9B right angle quotation mark */
	.byte	0x00,0x00,0x7E,0xDB,0xDF,0xD8,0x7F,0x00 /* &9C small OE ligature */
	.byte	0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0xCC,0x00 /* &9D double line (teletext) */
	.byte	0x6C,0x38,0x7C,0x18,0x30,0x60,0x7C,0x00 /* &9E small Z caron */
	.byte	0xCC,0x00,0xCC,0xCC,0x78,0x30,0x30,0x00 /* &9F capital Y diaeresis */
	.byte	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x18,0x00,0x18,0x18,0x18,0x18,0x18,0x00 /*   */
	.byte	0x00,0x18,0x7E,0xD8,0xD8,0x7E,0x18,0x00 /*   */
	.byte	0x38,0x6C,0x60,0xF0,0x60,0x66,0xFC,0x00 /*   */
	.byte	0x66,0x3C,0x66,0x3C,0x66,0x00,0x00,0x00 /*   */
	.byte	0xC3,0x66,0x3C,0x18,0x3C,0x18,0x18,0x00 /*   */
	.byte	0x18,0x18,0x18,0x00,0x18,0x18,0x18,0x00 /*   */
	.byte	0x3C,0x60,0x3C,0x66,0x66,0x3C,0x06,0x3C /*   */
	.byte	0x66,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x7E,0x81,0x9D,0xB1,0xB1,0x9D,0x81,0x7E /*   */
	.byte	0x3C,0x6C,0x6C,0x3E,0x00,0x7E,0x00,0x00 /*   */
	.byte	0x00,0x33,0x66,0xCC,0x66,0x33,0x00,0x00 /*   */
	.byte	0x00,0x7E,0x06,0x06,0x00,0x00,0x00,0x00 /*   */
	.byte	0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x00
	.byte	0x7E,0x81,0xB9,0xA5,0xB9,0xA5,0x81,0x7E /*   */
	.byte	0x3C,0x00,0x00,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x3C,0x66,0x3C,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x18,0x18,0x7E,0x18,0x18,0x00,0x7E,0x00 /*   */
	.byte	0x70,0x18,0x30,0x60,0x78,0x00,0x00,0x00 /*   */
	.byte	0x78,0x0C,0x18,0x0C,0x78,0x00,0x00,0x00 /*   */
	.byte	0x0C,0x18,0x30,0x00,0x00,0x00,0x00,0x00 /*   */
	.byte	0x00,0x00,0x66,0x66,0x66,0x7C,0x60,0xC0 /*   */
	.byte	0x3E,0x7A,0x7A,0x3A,0x1A,0x1A,0x1A,0x00 /*   */
	.byte	0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00 /*   */
	.byte	0x00,0x00,0x00,0x00,0x00,0x08,0x18,0x00 /*   */
	.byte	0x30,0x70,0x30,0x30,0x30,0x00,0x00,0x00 /*   */
	.byte	0x38,0x6C,0x6C,0x38,0x00,0x7C,0x00,0x00 /*   */
	.byte	0x00,0xCC,0x66,0x33,0x66,0xCC,0x00,0x00 /*   */
	.byte	0x43,0xC6,0x4C,0x5A,0x36,0x6A,0xCF,0x02 /*   */
	.byte	0x40,0xC6,0x4C,0x5E,0x33,0x66,0xCC,0x0F /*   */
	.byte	0xC0,0x23,0x66,0x2D,0xDB,0x35,0x67,0x01 /*   */
	.byte	0x18,0x00,0x18,0x30,0x60,0x66,0x3C,0x00 /*   */
	.byte	0x70,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x0E,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x18,0x66,0x00,0x3C,0x66,0x7E,0x66,0x00 /*   */
	.byte	0x76,0xDC,0x00,0x3C,0x66,0x7E,0x66,0x00 /*   */
	.byte	0x66,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x18,0x18,0x00,0x3C,0x66,0x7E,0x66,0x00 /*   */
	.byte	0x3F,0x6C,0xCC,0xFE,0xCC,0xCC,0xCF,0x00 /*   */
	.byte	0x3C,0x66,0x60,0x60,0x60,0x66,0x3C,0x18 /*   */
	.byte	0x70,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x0E,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x18,0x66,0x00,0xFE,0xF0,0xC0,0xFE,0x00 /*   */
	.byte	0x66,0x00,0x3C,0x66,0x7E,0x66,0x66,0x00 /*   */
	.byte	0x70,0x00,0x7E,0x18,0x18,0x18,0x7E,0x00 /*   */
	.byte	0x0E,0x00,0x7E,0x18,0x18,0x18,0x7E,0x00 /*   */
	.byte	0x18,0x66,0x00,0x7E,0x18,0x18,0x7E,0x00 /*   */
	.byte	0x66,0x00,0x7E,0x18,0x18,0x18,0x7E,0x00 /*   */
	.byte	0x78,0x6C,0x66,0xF6,0x66,0x6C,0x78,0x00 /*   */
	.byte	0x76,0xDC,0x00,0xC6,0xF6,0xDE,0xC6,0x00 /*   */
	.byte	0x70,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x0E,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x18,0x66,0x00,0x7C,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x76,0xDC,0x00,0x7C,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x66,0x00,0x7C,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x00,0xC6,0x6C,0x38,0x6C,0xC6,0x00,0x00 /*   */
	.byte	0x3E,0x66,0x6E,0x7E,0x76,0x66,0x7C,0x00 /*   */
	.byte	0x70,0x00,0xC6,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x0E,0x00,0xC6,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x18,0x66,0x00,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x66,0x00,0xC6,0xC6,0xC6,0xC6,0x7C,0x00 /*   */
	.byte	0x0E,0x00,0x66,0x66,0x3C,0x18,0x18,0x00 /*   */
	.byte	0xC0,0xC0,0xFC,0xC6,0xFC,0xC0,0xC0,0x00 /*   */
	.byte	0x3C,0x66,0x66,0x6C,0x66,0x66,0x6C,0x00 /*   */
	.byte	0x70,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00 /*   */
	.byte	0x0E,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00 /*   */
	.byte	0x18,0x66,0x00,0x3E,0x66,0xC6,0x7E,0x00 /*   */
	.byte	0x76,0xDC,0x00,0x3E,0x66,0xC6,0x7E,0x00 /*   */
	.byte	0x66,0x00,0x3C,0x06,0x3E,0x66,0x3E,0x00 /*   */
	.byte	0x18,0x18,0x00,0x3E,0x66,0xC6,0x7E,0x00 /*   */
	.byte	0x00,0x00,0x7E,0x1B,0x7F,0xD8,0x77,0x00 /*   */
	.byte	0x00,0x00,0x3C,0x60,0x60,0x60,0x3C,0x18 /*   */
	.byte	0x70,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00 /*   */
	.byte	0x0E,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00 /*   */
	.byte	0x18,0x66,0x00,0x3C,0x7E,0x60,0x3C,0x00 /*   */
	.byte	0x66,0x00,0x3C,0x66,0x7E,0x60,0x3C,0x00 /*   */
	.byte	0x70,0x00,0x38,0x18,0x18,0x18,0x3C,0x00 /*   */
	.byte	0x0E,0x00,0x38,0x18,0x18,0x18,0x3C,0x00 /*   */
	.byte	0x18,0x66,0x00,0x38,0x18,0x18,0x3C,0x00 /*   */
	.byte	0x66,0x00,0x38,0x18,0x18,0x18,0x3C,0x00 /*   */
	.byte	0x0C,0x3E,0x0C,0x7C,0xCC,0xCC,0x78,0x00 /*   */
	.byte	0x76,0xDC,0x00,0x7C,0x66,0x66,0x66,0x00 /*   */
	.byte	0x70,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00 /*   */
	.byte	0x0E,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00 /*   */
	.byte	0x18,0x66,0x00,0x3C,0x66,0x66,0x3C,0x00 /*   */
	.byte	0x76,0xDC,0x00,0x3C,0x66,0x66,0x3C,0x00 /*   */
	.byte	0x66,0x00,0x3C,0x66,0x66,0x66,0x3C,0x00 /*   */
	.byte	0x18,0x18,0x00,0x7E,0x00,0x18,0x18,0x00 /*   */
	.byte	0x00,0x02,0x7C,0xCE,0xD6,0xE6,0x7C,0x80 /*   */
	.byte	0x70,0x00,0x66,0x66,0x66,0x66,0x3E,0x00 /*   */
	.byte	0x0E,0x00,0x66,0x66,0x66,0x66,0x3E,0x00 /*   */
	.byte	0x18,0x66,0x00,0x66,0x66,0x66,0x3E,0x00 /*   */
	.byte	0x66,0x00,0x66,0x66,0x66,0x66,0x3E,0x00 /*   */
	.byte	0x0E,0x00,0x66,0x66,0x66,0x3E,0x06,0x3C /*   */
	.byte	0x60,0x60,0x7C,0x66,0x66,0x7C,0x60,0x60 /*   */
	.byte	0x66,0x00,0x66,0x66,0x66,0x3E,0x06,0x3C /*   */

ttxtfont:
	.short	0x0000,0x0011,0x0011,0x0019,0x0015,0x0013,0x0011,0x0011,0x8800,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* NU */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* AR */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* AG */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000 /* AY */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* AB */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x8800,0xD800,0xA800,0xA800,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* AM */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x7000,0x8800,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* AC */
	.short	0x0000,0x000E,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x8800,0x8800,0x8800,0xA800,0xA800,0xD800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* AW */
	.short	0x0000,0x001F,0x0010,0x0010,0x001E,0x0010,0x0010,0x0010,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000 /* FL */
	.short	0x0000,0x000E,0x0011,0x0010,0x000E,0x0001,0x0011,0x000E,0xF800,0x2000,0x2000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ST */
	.short	0x0000,0x001F,0x0010,0x0010,0x001E,0x0010,0x0010,0x001F,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* EB */
	.short	0x0000,0x000E,0x0011,0x0010,0x000E,0x0001,0x0011,0x000E,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* SB */
	.short	0x0000,0x0011,0x0011,0x0019,0x0015,0x0013,0x0011,0x0011,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* NH */
	.short	0x0000,0x001C,0x0012,0x0011,0x0011,0x0011,0x0012,0x001C,0x8800,0x8800,0x8800,0xF800,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* DH */
	.short	0x0000,0x000E,0x0011,0x0010,0x000E,0x0001,0x0011,0x000E,0x7000,0x8800,0x8800,0x8800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* SO */
	.short	0x0000,0x000E,0x0011,0x0010,0x000E,0x0001,0x0011,0x000E,0x7000,0x2000,0x2000,0x2000,0x2000,0x2000,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* SI */
	.short	0x0000,0x001C,0x0012,0x0011,0x0011,0x0011,0x0012,0x001C,0x8000,0x8000,0x8000,0x8000,0x8000,0x8000,0xF800,0x0000,0x0000,0x0000,0x0000,0x0000 /* DL */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* GR */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* GG */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0x8800,0x8800,0x5000,0x2000,0x2000,0x2000,0x2000,0x0000,0x0000,0x0000,0x0000,0x0000 /* GY */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* GB */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0x8800,0xD800,0xA800,0xA800,0x8800,0x8800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* GM */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0x7000,0x8800,0x8000,0x8000,0x8000,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* GC */
	.short	0x0000,0x000E,0x0011,0x0010,0x0013,0x0011,0x0011,0x000E,0x8800,0x8800,0x8800,0xA800,0xA800,0xD800,0x8800,0x0000,0x0000,0x0000,0x0000,0x0000 /* GW */
	.short	0x0000,0x000E,0x0011,0x0010,0x0010,0x0010,0x0011,0x000E,0xE000,0x9000,0x8800,0x8800,0x8800,0x9000,0xE000,0x0000,0x0000,0x0000,0x0000,0x0000 /* CD */
	.short	0x0000,0x000E,0x0011,0x0010,0x0010,0x0010,0x0011,0x000E,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* CG */
	.short	0x0000,0x000E,0x0011,0x0010,0x000E,0x0001,0x0011,0x000E,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* SG */
	.short	0x0000,0x001F,0x0010,0x0010,0x001E,0x0010,0x0010,0x001F,0x7000,0x8800,0x8000,0x7000,0x0800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ES */
	.short	0x0000,0x001E,0x0011,0x0011,0x001E,0x0011,0x0011,0x001E,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* BB */
	.short	0x0000,0x0011,0x0011,0x0019,0x0015,0x0013,0x0011,0x0011,0xF000,0x8800,0x8800,0xF000,0x8800,0x8800,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* NB */
	.short	0x0000,0x0011,0x0011,0x0011,0x001F,0x0011,0x0011,0x0011,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* HG */
	.short	0x0000,0x001E,0x0011,0x0011,0x001E,0x0011,0x0011,0x0011,0x7000,0x8800,0x8000,0x9800,0x8800,0x8800,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000 /* RG */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* ! */
	.short	0x0000,0x700E,0x700E,0x700E,0x700E,0x700E,0x700E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* " */
	.short	0x0000,0x700E,0x700E,0x700E,0x700E,0xFC3F,0xFC3F,0x700E,0x700E,0xFC3F,0xFC3F,0x700E,0x700E,0x700E,0x700E,0x0000,0x0000,0x0000,0x0000,0x0000 /* # */
	.short	0x0000,0xF00F,0xF81F,0x9C39,0x8C31,0x8031,0x8039,0xF01F,0xF80F,0x9C01,0x8C01,0x8C31,0x9C39,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* $ */
	.short	0x0000,0x003C,0x0C3C,0x1C3C,0x383C,0x7000,0xE000,0xC001,0x8003,0x0007,0x000E,0x3C1C,0x3C38,0x3C30,0x3C00,0x0000,0x0000,0x0000,0x0000,0x0000 /* % */
	.short	0x0000,0x000E,0x001F,0x803B,0x8031,0x803B,0x001F,0x000E,0x001F,0x8C3B,0xDC31,0xF830,0xF838,0xDC1F,0x8C0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* & */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ' */
	.short	0x0000,0x6000,0xE000,0xC001,0x8003,0x0007,0x0006,0x0006,0x0006,0x0006,0x0007,0x8003,0xC001,0xE000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ( */
	.short	0x0000,0x0006,0x0007,0x8003,0xC001,0xE000,0x6000,0x6000,0x6000,0x6000,0xE000,0xC001,0x8003,0x0007,0x0006,0x0000,0x0000,0x0000,0x0000,0x0000 /* ) */
	.short	0x0000,0x8001,0x8001,0x8C31,0x9C39,0xF81F,0xF00F,0x8001,0x8001,0xF00F,0xF81F,0x9C39,0x8C31,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* * */
	.short	0x0000,0x0000,0x0000,0x8001,0x8001,0x8001,0x8001,0xF81F,0xF81F,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* + */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x8001,0x8003,0x0007,0x0006,0x0000,0x0000,0x0000 /* , */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* - */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* . */
	.short	0x0000,0x0000,0x0C00,0x1C00,0x3800,0x7000,0xE000,0xC001,0x8003,0x0007,0x000E,0x001C,0x0038,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* / */
	.short	0x0000,0xC003,0xE007,0x700E,0x381C,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0x381C,0x700E,0xE007,0xC003,0x0000,0x0000,0x0000,0x0000,0x0000 /* 0 */
	.short	0x0000,0x8001,0x8001,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 1 */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C00,0x1C00,0xF803,0xF007,0x000E,0x001C,0x0038,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 2 */
	.short	0x0000,0xFC3F,0xFC3F,0x1C00,0x3800,0x7000,0xE000,0xF801,0xFC01,0x0C00,0x0C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 3 */
	.short	0x0000,0x7000,0xF000,0xF001,0xB003,0x3007,0x300E,0x301C,0x3038,0xFC3F,0xFC3F,0x3000,0x3000,0x3000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000 /* 4 */
	.short	0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0xF03F,0xF83F,0x1C00,0x0C00,0x0C00,0x0C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 5 */
	.short	0x0000,0xF001,0xF007,0x000F,0x001C,0x0038,0x0030,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 6 */
	.short	0x0000,0xFC3F,0xFC3F,0x0C00,0x1C00,0x3800,0x7000,0xE000,0xC001,0x8003,0x0007,0x0006,0x0006,0x0006,0x0006,0x0000,0x0000,0x0000,0x0000,0x0000 /* 7 */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x1C38,0xF81F,0xF81F,0x1C38,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 8 */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x1C00,0x3800,0xF000,0xE00F,0x800F,0x0000,0x0000,0x0000,0x0000,0x0000 /* 9 */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* : */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x8001,0x8003,0x0007,0x0006,0x0000,0x0000,0x0000 /* ; */
	.short	0x0000,0x6000,0xE000,0xC001,0x8003,0x0007,0x000E,0x001C,0x001C,0x000E,0x0007,0x8003,0xC001,0xE000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000 /* < */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* = */
	.short	0x0000,0x0006,0x0007,0x8003,0xC001,0xE000,0x7000,0x3800,0x3800,0x7000,0xE000,0xC001,0x8003,0x0007,0x0006,0x0000,0x0000,0x0000,0x0000,0x0000 /* > */
	.short	0x0000,0xE00F,0xF01F,0x3838,0x1830,0x3800,0x7000,0xE000,0xC001,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* ? */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC31,0xFC31,0x8C31,0x8C31,0xFC31,0xFC31,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* @ */
	.short	0x0000,0x8001,0xC003,0xE007,0x700E,0x381C,0x1C38,0x0C30,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* A */
	.short	0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0000,0x0000,0x0000,0x0000,0x0000 /* B */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* C */
	.short	0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0000,0x0000,0x0000,0x0000,0x0000 /* D */
	.short	0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* E */
	.short	0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000 /* F */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0030,0x0030,0x0030,0x0030,0x3C30,0x3C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* G */
	.short	0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* H */
	.short	0x0000,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* I */
	.short	0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* J */
	.short	0x0000,0x1830,0x3830,0x7030,0xE030,0xC031,0x8033,0x003F,0x003F,0x8033,0xC031,0xE030,0x7030,0x3830,0x1830,0x0000,0x0000,0x0000,0x0000,0x0000 /* K */
	.short	0x0000,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* L */
	.short	0x0000,0x0C30,0x0C30,0x1C38,0x3C3C,0x7C3E,0xEC37,0xCC33,0x8C31,0x8C31,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* M */
	.short	0x0000,0x0C30,0x0C30,0x0C38,0x0C3C,0x0C3E,0x0C37,0x8C33,0xCC31,0xEC30,0x7C30,0x3C30,0x1C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* N */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* O */
	.short	0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000 /* P */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0xCC30,0xEC30,0x7830,0x3838,0xFC1F,0xCC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* Q */
	.short	0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0xC031,0xE030,0x7030,0x3830,0x1C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* R */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0030,0x0038,0xF01F,0xF80F,0x1C00,0x0C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* S */
	.short	0x0000,0xFC3F,0xFC3F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* T */
	.short	0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* U */
	.short	0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0x1818,0x381C,0x300C,0x700E,0xE007,0xC003,0xC003,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* V */
	.short	0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x8C31,0x8C31,0x8C31,0x8C31,0x8C31,0xFC3F,0xF81F,0x700E,0x0000,0x0000,0x0000,0x0000,0x0000 /* W */
	.short	0x0000,0x0C30,0x0C30,0x1C38,0x381C,0x700E,0xE007,0xC003,0xC003,0xE007,0x700E,0x381C,0x1C38,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* X */
	.short	0x0000,0x0C30,0x0C30,0x1C38,0x381C,0x700E,0xE007,0xC003,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* Y */
	.short	0x0000,0xFC3F,0xFC3F,0x1C00,0x3800,0x7000,0xE000,0xC001,0x8003,0x0007,0x000E,0x001C,0x0038,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* Z */
	.short	0x0000,0xE007,0xE007,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0x0006,0xE007,0xE007,0x0000,0x0000,0x0000,0x0000,0x0000 /* [ */
	.short	0x0000,0x0000,0x0030,0x0038,0x001C,0x000E,0x0007,0x8003,0xC001,0xE000,0x7000,0x3800,0x1C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* \ */
	.short	0x0000,0xE007,0xE007,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0x6000,0xE007,0xE007,0x0000,0x0000,0x0000,0x0000,0x0000 /* ] */
	.short	0x0000,0x8001,0xC003,0xE007,0x700E,0x381C,0x1818,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ^ */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFFFF,0xFFFF,0x0000,0x0000 /* _ */
	.short	0x0000,0x0006,0x0007,0x8003,0xC001,0xE000,0x6000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ` */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC1F,0xFC3F,0x0C30,0x0C30,0xFC3F,0xFC1F,0x0000,0x0000,0x0000,0x0000,0x0000 /* a */
	.short	0x0000,0x0030,0x0030,0x0030,0x0030,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0000,0x0000,0x0000,0x0000,0x0000 /* b */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC0F,0xFC1F,0x0038,0x0030,0x0030,0x0030,0x0030,0x0038,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* c */
	.short	0x0000,0x0C00,0x0C00,0x0C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* d */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* e */
	.short	0x0000,0x3000,0xF000,0xC001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* f */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC0F,0xFC1F,0x0C38,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x1C00,0xF80F,0xF00F,0x0000 /* g */
	.short	0x0000,0x0030,0x0030,0x0030,0x0030,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* h */
	.short	0x0000,0x8001,0x8001,0x0000,0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* i */
	.short	0x0000,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8003,0x000F,0x000C,0x0000 /* j */
	.short	0x0000,0x000C,0x000C,0x000C,0x180C,0x380C,0x700C,0xE00C,0xC00F,0x800F,0xC00D,0xE00C,0x700C,0x380C,0x180C,0x0000,0x0000,0x0000,0x0000,0x0000 /* k */
	.short	0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* l */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x303E,0xF83F,0xFC33,0x8C31,0x8C31,0x8C31,0x8C31,0x8C31,0x8C31,0x8C31,0x0000,0x0000,0x0000,0x0000,0x0000 /* m */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* n */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* o */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0030,0x0030,0x0030,0x0030,0x0000 /* p */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC0F,0xFC1F,0x0C38,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x0C00,0x0C00,0x0C00,0x0000 /* q */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF819,0xF81B,0x001F,0x001E,0x0018,0x0018,0x0018,0x0018,0x0018,0x0018,0x0000,0x0000,0x0000,0x0000,0x0000 /* r */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC0F,0xFC1F,0x0030,0x0030,0xF01F,0xF80F,0x0C00,0x0C00,0xF83F,0xF03F,0x0000,0x0000,0x0000,0x0000,0x0000 /* s */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0xC001,0xF000,0x3000,0x0000,0x0000,0x0000,0x0000,0x0000 /* t */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* u */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x0C30,0x0C30,0x1C38,0x1818,0x381C,0x700E,0xE007,0xC003,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* v */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x8C31,0x8C31,0x8C31,0xFC3F,0xF81F,0x700E,0x0000,0x0000,0x0000,0x0000,0x0000 /* w */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x1C38,0x781E,0xF00F,0xC003,0xC003,0xF00F,0x781E,0x1C38,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /* x */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x1C00,0xF80F,0xF00F,0x0000 /* y */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC3F,0xFC3F,0x3800,0x7000,0xE001,0x8007,0x000E,0x001C,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* z */
	.short	0x0000,0xF000,0xF001,0x8001,0x8001,0x8003,0x0003,0x000F,0x000F,0x0003,0x8003,0x8001,0x8001,0xF000,0xF000,0x0000,0x0000,0x0000,0x0000,0x0000 /* { */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* | */
	.short	0x0000,0x000F,0x800F,0x8001,0x8001,0xC001,0xC000,0xF000,0xF000,0xC000,0xC001,0x8001,0x8001,0x000F,0x000F,0x0000,0x0000,0x0000,0x0000,0x0000 /* } */
	.short	0x0000,0x000E,0x0C1F,0xDC3B,0xF831,0x7000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* ~ */
	.short	0x0000,0x8001,0xC003,0xC003,0x6006,0x6006,0x300C,0x300C,0x1818,0x1818,0x0C30,0x0C30,0x0C30,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &7F DEL */
	.short	0x0000,0xF003,0xF807,0x1C0E,0x0C0C,0xC03F,0xC03F,0x000C,0x000C,0x803F,0x803F,0x0C0C,0x1C0E,0xF807,0xF003,0x0000,0x0000,0x0000,0x0000,0x0000 /* &80 euro symbol */
	.short	0x0000,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &81 block (teletext) */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8003,0x8003,0x8001,0x8003,0x0007,0x000E,0x0000,0x0000,0x0000 /* &82 single low quotation mark */
	.short	0x0000,0x7000,0xF000,0xC001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8003,0x000F,0x000E,0x0000 /* &83 small letter f with hook */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1C0E,0x1C0E,0x0C06,0x1C0E,0x381C,0x7038,0x0000,0x0000,0x0000 /* &84 double low quotation mark */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x9819,0x9819,0x0000,0x0000,0x0000,0x0000,0x0000 /* &85 horizontal ellipsis */
	.short	0x0000,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* &86 dagger */
	.short	0x0000,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* &87 double dagger */
	.short	0x8001,0xC003,0x6006,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &88 circumflex accent */
	.short	0x0000,0x3038,0x706C,0xE06C,0xC039,0x8003,0x0007,0x000E,0x001C,0x0038,0x0070,0x1C67,0xB60D,0xB60D,0x1C07,0x0000,0x0000,0x0000,0x0000,0x0000 /* &89 per mille */
	.short	0x6006,0xE007,0xC003,0xF00F,0xF81F,0x1C38,0x0C30,0x0038,0xF01F,0xF80F,0x1C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8A capital S caron */
	.short	0x0000,0x0000,0x0000,0x8001,0x8003,0x0007,0x000E,0x000C,0x000E,0x0007,0x8003,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8B left angle quotation mark */
	.short	0x0000,0xFC0F,0xFC1F,0x8039,0x8031,0x8031,0x8031,0xF831,0xF831,0x8031,0x8031,0x8031,0x8039,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8C capital OE ligature */
	.short	0x0000,0x0000,0x8001,0xC003,0xE007,0xF00F,0xB81D,0x9C39,0x8C31,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8D up arrow (teletext) */
	.short	0x6006,0xE007,0xC003,0xFC3F,0xFC3F,0x3800,0x7000,0xE000,0xC001,0x8003,0x0007,0x000E,0x001C,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8E capital Z caron */
	.short	0x0000,0x0000,0x8001,0x8003,0x0007,0x000E,0x001C,0xFC3F,0xFC3F,0x001C,0x000E,0x0007,0x8003,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &8F left arrow (teletext) */
	.short	0x0000,0x0000,0x8001,0xC001,0xE000,0x7000,0x3800,0xFC3F,0xFC3F,0x3800,0x7000,0xE000,0xC001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &90 right arrow (teletext) */
	.short	0x0000,0x7000,0xE000,0xC001,0x8001,0xC001,0xC001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &91 left single quotation mark */
	.short	0x0000,0x8003,0x8003,0x8001,0x8003,0x0007,0x000E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &92 right single quotation mark */
	.short	0x0000,0x1C0E,0x381C,0x7038,0x6030,0x7038,0x7038,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &93 left double quotation mark */
	.short	0x0000,0x1C0E,0x1C0E,0x0C06,0x1C0E,0x381C,0x7038,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &94 right double quotation mark */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0xC003,0xE007,0xE007,0xC003,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &95 bullet */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xF81F,0xF81F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &96 en dash */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xFE7F,0xFE7F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &97 em dash */
	.short	0x6007,0xC00D,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &98 small tilde */
	.short	0x0000,0x0000,0xC67E,0xC67E,0xEE18,0xFE18,0xD618,0xD618,0xC618,0xC618,0xC618,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &99 trade mark sign */
	.short	0x0000,0x6006,0xE007,0xC003,0x0000,0xFC0F,0xFC1F,0x0038,0x0038,0xF01F,0xF80F,0x1C00,0x1C00,0xF83F,0xF03F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9A small S caron */
	.short	0x0000,0x0000,0x0000,0x8001,0xC001,0xE000,0x7000,0x3000,0x7000,0xE000,0xC001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9B right angle quotation mark */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x780E,0xFC1F,0xCC3B,0x8C31,0xFC31,0xFC31,0x8031,0xC03B,0xFC1F,0x7C0E,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9C small OE ligature */
	.short	0x0000,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x381C,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9D double line (teletext) */
	.short	0x0000,0x6006,0xE007,0xC003,0x0000,0xFC3F,0xFC3F,0x3800,0x7000,0xE001,0x8007,0x000E,0x001C,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9E small Z caron */
	.short	0x300C,0x300C,0x300C,0x0000,0x0C30,0x1C38,0x381C,0x700E,0xE007,0xC003,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /* &9F capital Y diaeresis */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /* &A0 non-break space */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x8001,0x8001,0xFC0F,0xFC1F,0x8039,0x8031,0x8031,0x8031,0x8031,0x8039,0xFC1F,0xFC0F,0x8001,0x8001,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF003,0xF807,0x1C0E,0x0C0C,0x000C,0x000C,0x803F,0x803F,0x000C,0x000C,0x000C,0x000C,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0C30,0x1C38,0xF81F,0xF00F,0x700E,0x700E,0xF00F,0xF81F,0x1C38,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0C30,0x1C38,0x381C,0x700E,0xFC3F,0xFC3F,0x8001,0x8001,0xFC3F,0xFC3F,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0030,0x0038,0xF01F,0xF81F,0x1C38,0x1C38,0xF81F,0xF80F,0x1C00,0x0C00,0x0C30,0x1C38,0xF81F,0xF00F,0x0000 /*   */
	.short	0x1818,0x1818,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xCC33,0xEC37,0x6C36,0x0C36,0x0C36,0x0C36,0x6C36,0xEC37,0xCC33,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000 /*   */
	.short	0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x1C0E,0x381C,0x7038,0x7038,0x381C,0x1C0E,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC3F,0xFC3F,0x0C00,0x0C00,0x0C00,0x0C00,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0xE007,0xE007,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xCC37,0xEC37,0x6C36,0x6C36,0xCC37,0x8C37,0xCC37,0xEC36,0x6C36,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000 /*   */
	.short	0x0000,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0xC003,0xE007,0x700E,0x381C,0x700E,0xE007,0xC003,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x8001,0x8001,0x8001,0x8001,0xFC3F,0xFC3F,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xC00F,0xE00F,0x7000,0x7000,0xE003,0xC007,0x000E,0x000C,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xC00F,0xE00F,0x7000,0x7000,0xE00F,0xE00F,0x7000,0x7000,0xE00F,0xC00F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x6000,0xE000,0xC001,0x8003,0x0007,0x0006,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x6030,0x6030,0x6030,0x6030,0x6030,0x6030,0x6030,0xF830,0xFC3F,0x8C3F,0x0030,0x0030,0x0030,0x0030,0x0000 /*   */
	.short	0x0000,0x8C0F,0x8C1F,0x8C39,0x8C31,0x8C31,0x8C39,0x8C1F,0x8C0F,0x8C01,0x8C01,0x8C01,0x8C01,0x8C01,0x8C01,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x8003,0x0007,0x0006,0x0000 /*   */
	.short	0x0000,0x8003,0x8007,0x800F,0x800D,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x7038,0x381C,0x1C0E,0x1C0E,0x381C,0x7038,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x000C,0x000C,0x000C,0x000C,0x000C,0x000C,0x000C,0x000C,0x1C0C,0x3C0C,0x7C00,0xEC00,0xCC01,0x8C01,0xFC01,0xFC01,0x0C00,0x0C00,0x0000 /*   */
	.short	0x0000,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0xF831,0xFC31,0x0C00,0x0C00,0x7C00,0xF800,0xC001,0x8001,0xFC01,0xFC01,0x0000 /*   */
	.short	0x0000,0x003E,0x003F,0x8003,0x8003,0x003F,0x003F,0x8003,0x8003,0x1C3F,0x3C3E,0x7C00,0xEC00,0xCC01,0x8C01,0xFC01,0xFC01,0x0C00,0x0C00,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x8001,0x8001,0x8003,0x0007,0x000E,0x001C,0x0C18,0x1C1C,0xF80F,0xF00F,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x300C,0x300C,0x300C,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0x6006,0x6006,0xC003,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xFC0F,0xFC1F,0x8039,0x8031,0x8031,0x8031,0xF83F,0xF83F,0x8031,0x8031,0x8031,0x8031,0xFC31,0xFC31,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0030,0x0030,0x0030,0x0030,0x0030,0x0030,0x0C30,0x1C38,0xF81F,0xF00F,0x8001,0x8003,0x0007,0x0006,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x300C,0x300C,0x300C,0x0000,0x0000,0xFC3F,0xFC3F,0x0030,0x0030,0xF03F,0xF03F,0x0030,0x0030,0xFC3F,0xFC3F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x300C,0x300C,0x300C,0x0000,0x0000,0xF00F,0xF00F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF80F,0x1C0C,0x0C0C,0x0C0C,0x0C0C,0x8C3F,0x8C3F,0x0C0C,0x0C0C,0x0C0C,0x1C0C,0xF80F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0x0C30,0x0C3C,0x0C3E,0x0C37,0x8C33,0xCC31,0xEC30,0x7C30,0x3C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x300C,0x300C,0x300C,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x1818,0x381C,0x700E,0xE007,0xC003,0xE007,0x700E,0x381C,0x1818,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xF00F,0xF81F,0x1C38,0x3C30,0x7C30,0xEC30,0xCC31,0x8C33,0x0C37,0x0C3E,0x0C3C,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x300C,0x300C,0x300C,0x0000,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0C30,0x1C38,0x381C,0x700E,0xE007,0xC003,0x8001,0x8001,0x8001,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0030,0x0030,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0030,0x0030,0x0030,0x0030,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0xC00F,0xE01F,0x7038,0x3030,0x3030,0x3030,0xF031,0xF831,0x1C30,0x0C30,0x0C30,0x1C30,0xF831,0xF031,0x0030,0x0030,0x0030,0x0030,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0x6006,0xC003,0x8001,0xF00F,0xF80F,0x1C00,0x0C00,0xFC0F,0xFC1F,0x0C38,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0x781E,0xFC1F,0x8C03,0x8C01,0xFC1F,0xFC3F,0x8031,0x8031,0xF83F,0xF81F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xFC0F,0xFC1F,0x0038,0x0030,0x0030,0x0030,0x0030,0x0038,0xFC1F,0xFC0F,0xC000,0xC001,0x8003,0x0003,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0xFC3F,0xFC3F,0x0030,0x0038,0xF01F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0x800F,0x800F,0x8001,0x8001,0x8001,0x8001,0x8001,0x8001,0xF00F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x601E,0xE01F,0xC003,0xE007,0x700E,0x380C,0x1C00,0x0C00,0xFC0F,0xFC1F,0x1C38,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x1807,0xB80F,0xF01D,0xE018,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0x0000,0xF00F,0xF81F,0x1C38,0x0C30,0x0C30,0x0C30,0x1C38,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0xFC3F,0xFC3F,0x0000,0x0000,0x8001,0x8001,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x0000,0x0000,0x0000,0x0000,0xF00F,0xF81F,0x7C38,0xEC30,0xCC31,0x8C33,0x0C37,0x1C3E,0xF81F,0xF00F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0006,0x0007,0x8003,0x8001,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x8001,0xC003,0xE007,0x6006,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0000,0x0000,0x0000,0x0000,0x0000 /*   */
	.short	0x6000,0xE000,0xC001,0x8001,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x1C00,0xF80F,0xF00F,0x0000 /*   */
	.short	0x0000,0x0030,0x0030,0x0030,0x0030,0xF03F,0xF83F,0x1C30,0x0C30,0x0C30,0x0C30,0x0C30,0x1C30,0xF83F,0xF03F,0x0030,0x0030,0x0030,0x0030,0x0000 /*   */
	.short	0x0000,0x300C,0x300C,0x300C,0x0000,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C30,0x0C38,0xFC1F,0xFC0F,0x0C00,0x1C00,0xF80F,0xF00F,0x0000 /*   */
