;/*****************************************************************\
;*       BBC BASIC for SDL 2.0 (x86_64)                            *
;*       Copyright (c) R. T. Russell, 2000-2024                    *
;*                                                                 *
;*       BBCDATA.NAS RAM data definitions                          *
;*       Version 1.40a, 12-Mar-2024                                *
;\*****************************************************************/
;
MAX_PORTS       EQU     4       ; Maximum number of i/o ports
MAX_FILES       EQU     8       ; Maximum number of open files
SOUNDQE         EQU     4       ; Number of bytes per sound entry
SOUNDQL         EQU     5*SOUNDQE ; Number of bytes per channel
;
	GLOBAL	stavar,lc,oc,pc,dynvar,fnptr,proptr,prand
	GLOBAL	accs,buff,vpage,flist,lomem,pfree,himem
	GLOBAL	errtxt,onersp,errtrp,datptr,curlin,errlin
	GLOBAL	tracen,random,vcount,vwidth,errnum,liston,tmps
;
	GLOBAL	path,keystr,keybdq,keyptr,spchan,exchan,tweak
	GLOBAL	fcbtab,timoff,usrchr,soundq,envels,waves,libase
	GLOBAL	eventq,timtrp,clotrp,siztrp,systrp,moutrp
	GLOBAL	alltrp,iMsg,wParam,lParam,filbuf,portab,fvtab
;
	GLOBAL	forgnd,bakgnd,hfont,colmsk,modeno,lthick,hrect
	GLOBAL	origx,origy,lastx,lasty,prevx,prevy,pfont,cmcflg
	GLOBAL	textwl,textwr,textwt,textwb,sizex,sizey,sclflg
	GLOBAL	textx,texty,charx,chary,cursa,cursb,tempo
	GLOBAL	pixelx,pixely,txtfor,txtbak,optval,farray,fasize
;
	GLOBAL	vduq,queue,flags,kbdqw,kbdqr,keyexp,scroln
	GLOBAL	vflags,sndqw,sndqr,sacc,smix,evtqw,evtqr
	GLOBAL	eenvel,escale,epsect,easect,epitch,elevel,ecount
;
	GLOBAL	hwndProg,zoom,offsetx,offsety,platform
	GLOBAL	memhdc,reflag,sysflg,panx,pany
	GLOBAL	prntx,prnty,prchx,prchy,cursx
	GLOBAL	paperl,paperr,papert,paperb,lstopt
;
	GLOBAL	datend,sysvar,bbcfont,lastick,link00
	GLOBAL	cmdlen,cmdadr,dirlen,diradr,liblen,libadr
	GLOBAL	usrlen,usradr,tmplen,tmpadr,hwo
	GLOBAL	voices,chrmap
	GLOBAL	breakpt,breakhi,ttxtfont
;
	EXTERN	loadn,loads,storen,stores,getvar,putvar,expr,item,lexan
	EXTERN	xfloat,xfix,xeq,token,putevt,palette,str00,con,TTFcache
;
	EXTERN	gfxPrimitivesGetFont,gfxPrimitivesSetFont,RedefineChar
	EXTERN	sortup,sortdn
;
%macro  checkalign	0
	%if (($ - $$) & 7)
	%error "Alignment fault"
	%endif
%endmacro
;
	SEGMENT .data		; Crashes if .bss
;
;The following locations are initialised to zero when program is RUN:
;Variables used by generic modules (bbmain, bbexec, bbeval, bbasmb)
;
	align	16,db 0
stavar:	times 12 dd 0		; Static variables @% to K%
lc:	dd	0		; Static variable L%
	times 2	dd 0		; Static variables M%, N%
oc:	dd	0		; Static variable O%
pc:	dd	0		; Static variable P%
	times 10 dd 0		; Static variables Q% to Z%
dynvar:	times 54 dd 0		; ( Pointers to dynamic vars   )
fnptr:	dd	0		; ( Pointer to user FuNctions  ) grouped
proptr:	dd	0		; ( Pointer to user PROCedures )
accs:	dd	0		; Pointer to string accumulator
	dd	0		; 64-bit pointer
vpage:	dd	0		; Current value of PAGE
tracen:	dd	0		; Maximum line number to trace
lomem:	dd	0		; Current value of LOMEM
pfree:	dd	0		; Pointer to start of free space
himem:	dd	0		; Current value of HIMEM
libase:	dd	0		; Pointer to INSTALLed library
errtxt:	dd	0		; Pointer to error text for REPORT
	dd	0		; 64-bit pointer
errtrp:	dd	0		; Pointer to ON ERROR statement
datptr:	dd	0		; Pointer to DATA statements
vcount:	dd	0		; Current value of COUNT
curlin:	dd	0		; Pointer to current statement
alltrp:				; Start of trap pointers
timtrp:	dd	0		; Pointer to ON TIME statement
clotrp:	dd	0		; Pointer to ON CLOSE statement
siztrp:	dd	0		; Pointer to ON MOVE statement
systrp:	dd	0		; Pointer to ON SYS statement
moutrp:	dd	0		; Pointer to ON MOUSE statement
errlin:	dd	0		; Pointer to last error statement
;
prand:
random:	times 5 db 0		; Current 'random' number (5 bytes)
vwidth:	db	0		; Current value of WIDTH
errnum:	db	0		; Error code of last error
liston:	db	0		; *FLOAT/*HEX/*LOWERCASE/OPT
;
;Variables used by OS-specific modules (bbcmos, bbccli, bbcvdu, bbcvtx)
;
	align	4,db 0
path:	dd	0		; Pointer to path/filename buffer
	dd	0		; 64-bit pointer
keybdq:	dd	0		; Pointer to keyboard queue
	dd	0		; 64-bit pointer
keyptr:	dd	0		; Pointer to *KEY string
	dd	0		; 64-bit pointer
;
lstopt:	db	0		; LISTO value (indentation)
sclflg:	db	0		; Scroll flag (COPY key)
optval:	db	0		; *OUTPUT and *INPUT values
;
; ------ End of 'absolutely-addressed' variables ------
;
farray:	db	0		; Number of dimensions = 1  |
fasize:	dd	0		; Number of elements = 16   |
filbuf:	dq	0		; Pointer to file buffers   | @hfile%%()
portab:	times MAX_PORTS dq 0	; Table of port handles     | 
chntab:	times MAX_FILES dq 0	; Table of file handles     | 
exchan:	dq	0		; Handle for *EXEC   @hfile%%(13)
spchan:	dq	0		; Handle for *SPOOL  @hfile%%(14)
ptchan:	dq	0		; Handle for printer @hfile%%(15)
;
fcbtab:	times MAX_FILES dd 0	; Table of FCBs
voices:	times 4 db 0		; Voices (waveforms) for sound channels
;
flist:	times 33 dq 0		; Pointers to string free lists
tmps:	dd	0		; Temp string descriptor: address
	dd	0		; Temp string descriptor: length
;
; Variables moved here to make room for 64-bit pointers and handles:
;
onersp:	dd	0		; ESP storage for ON ERROR LOCAL
	dd	0		; 64-bit pointer
buff:	dd	0		; Pointer to string input buffer
	dd	0		; 64-bit pointer
keystr:	dd	0		; Pointer to user *KEY strings
	dd	0		; 64-bit pointer
usrchr:	dd	0		; Pointer to user-defined characters
	dd	0		; 64-bit pointer
waves:	dd	0		; Pointer to SOUND waveforms
	dd	0		; 64-bit pointer
envels:	dd	0		; Pointer to ENVELOPEs
	dd	0		; 64-bit pointer
eventq:	dd	0		; Pointer to event queue
	dd	0		; 64-bit pointer
hrect:	dd	0		; Pointer to clip rect (part of @vdu{})
	dd	0		; 64-bit pointer
;
;Text/graphics metrics (pointed to by @vdu%):
;
vduvar:
origx:	dd	0		; Graphics horizontal origin
origy:	dd	0		; Graphics vertical origin
lastx:	dd	0		; Immediately preceding x-coordinate
lasty:	dd	0		; Immediately preceding y-coordinate
prevx:	dd	0		; Previous x-coordinate
prevy:	dd	0		; Previous y-coordinate
textwl:	dd	0		; Text window left (pixels)
textwr:	dd	0		; Text window right (pixels)
textwt:	dd	0		; Text window top (pixels)
textwb:	dd	0		; Text window bottom (pixels)
pixelx:	dd	0		; Width of a graphics pixel
pixely:	dd	0		; Height of a graphics pixel
textx:	dd	0		; Text pointer (cursor x)
texty:	dd	0		; Text pointer (cursor y)
hfont:	dd	0		; Handle of current font
	dd	0		; 64-bit handle
;
forgnd:	dw	0		; Graphics foreground colour/action
bakgnd:	dw	0		; Graphics background colour/action
;
cursa:	db	0		; Start (top) line of cursor
cursb:	db	0		; Finish (bottom) line of cursor
txtfor:	db	0		; Text foreground colour
txtbak:	db	0		; Text background colour
modeno:	db	0		; Mode number
colmsk:	db	0		; Mask for maximum number of colours
vflags:	db	0		; VDU driver flags
scroln:	db	0		; Scroll counter in paged mode
cursx:	db	0		; Cursor (caret) width
lthick:	db	0		; Line thickness (lines, outline shapes)
cmcflg:	db	0		; V5.3 cursor movement flags
tweak:	db	0		; Character spacing adjustment (signed) 
;
sndqw:	times 4 db 0		; Sound queue write pointers
sndqr:	times 4 db 0		; Sound queue read pointers
eenvel:	times 4 db 0		; Envelope number
escale:	times 4 db 0		; Envelope scaler
epsect:	times 4 db 0		; Envelope pitch section
easect:	times 4 db 0		; Envelope amplitude section
epitch:	times 4 db 0		; Envelope pitch (frequency)
ecount:	times 4 db 0		; Envelope count
soundq:	times 4*SOUNDQL db 0	; Sound queue (four channels)
vduq:	times 10 db 0		; VDU queue (must precede 'queue')
queue:	db	0		; VDU queue status
;
kbdqw:	db	0		; Keyboard queue write pointer
kbdqr:	db	0		; Keyboard queue read pointer
evtqw:	db	0		; Event queue write pointer
evtqr:	db	0		; Event queue read pointer
keyexp:	db	0		; *KEY character counter
;
	align	4,db 0
;
; ------ End of initialised variables ------
;
datend:
;
;The following locations are NOT initialised when program is RUN
;(but are guaranteed to be zero on initial execution).
;
sizex:	dd	0		; Total width of client area
sizey:	dd	0		; Total height of client area
charx:	dd	0		; Average character width
chary:	dd	0		; Average character height
prchx:	dd	0		; Average character width (printer)
prchy:	dd	0		; Average character height (printer)
paperl:	dd	0		; Printer left edge
paperr:	dd	0		; Printer right edge
papert:	dd	0		; Printer top edge
paperb:	dd	0		; Printer bottom edge
prntx:	dd	0		; Horizontal printing position
prnty:	dd	0		; Vertical printing position
;
; ------ End of VDU variables ------
;
lastick:dd	0		; To check for TickCount wraparound
timoff:	dd	0		; Offset to add to TickCount
sacc:	times 4	dd 0		; Sound accumulators (not initialised)
smix:	times 4	dd 0		; Stereo mix
elevel:	times 4 db 0		; Envelope level (amplitude)
;
;The following variables are organised as a linked-list at
;sysvar, for access via 'system variables' starting with @:
;
	align	4,db 0
;
sysvar:	dd	link1 - sysvar
	db	'wparam%',0
	checkalign
wParam:	dd	0		; Saved wParam for ON xxxx interrupt
;
link3:	dd	link4 - link3
	db	'lparam%',0
	checkalign
lParam:	dd	0		; Saved lParam for ON xxxx interrupt
;
	db	0		; Padding
link23:	dd	link24 - link23
	db	'ispal%',0
	checkalign
bPaletted: dd	0		; Paletted display flag (BOOL)
;
	times 7	db 0		; Padding
link1:	dd	link3 - link1
	db	'memhdc%%',0    ; n.b. aliased to @memhdc%
	checkalign
memhdc:	dd	0		; Shadow screen device context
	dd	0		; 64-bit handle
;
	times 7	db 0		; Padding
link9:	dd	link10 - link9
	db	'msg%',0
	checkalign
iMsg:	dd	0		; Saved iMsg for ON xxxx interrupt
;
	db	0		; Padding
link4:	dd	link5 - link4
	db	'hwnd%%',0	; n.b. aliased to @hwnd%
	checkalign
hwndProg: dd	0		; Handle for program window
	dd	0		; 64-bit handle
;
	times 5	db 0		; Padding
link12:	dd	link13 - link12
	db	'flags%',0
	checkalign
tempo:	db	0		; *TEMPO value
sysflg:	db	0		; *SYS flags
reflag:	db	0		; *REFRESH flags
flags:	db	0		; Boolean flags (byte) @ 3FBH
;
	times 7	db 0		; Padding
link16:	dd	link17 - link16
	db	'chrmap%%',0	; n.b. aliased to @chrmap%
	checkalign
chrmap:	dd	0
	dd	0		; 64-bit pointer
;
	times 5	db 0		; Padding
link5:	dd	link6 - link5
	db	'hpal%%',0
	checkalign
	dq	palette		; Colour palette
;
	times 6	db 0		; Padding
link10:	dd	link11 - link10
	db	'vdu%%',0
	checkalign
	dq	vduvar		; Pointer to VDU variables
;
	times 6	db 0		; Padding
link00:	dd	0		; End of list
	db	'fn%%(',0
	checkalign
	dq	fnarr		; Pointer to function array
;
	dw	0		; Padding
link11:	dd	link12 - link11
	db	'platform%',0
	checkalign
platform: dd	0		; SDL version & OS
;
	dd	0		; Padding
link6:	dd	link7 - link6
	db	'ox%',0	
	checkalign
offsetx:dd	0		; x-offset memhdc->hwnd
;
	dd	0		; Padding
link7:	dd	link8 - link7
	db	'oy%',0	 
	checkalign
offsety:dd	0		; y-offset memhdc->hwnd
;
	times 3	db 0		; Padding
link17:	dd	link18 - link17
	db	'dir$',0
	checkalign
diradr:	dd	0		; Program directory address
dirlen:	dd	0		; Program directory length
;
	times 7	db 0		; Padding
link18:	dd	link19 - link18
	db	'lib$',0
	checkalign
libadr:	dd	0		; Library directory address
liblen:	dd	0		; Library directory length
;
	times 6	db 0		; Padding
link24:	dd	link25 - link24
	db	'panx%',0
	checkalign
panx:	dd	0		; Horizontal pan
;
	times 3	db 0		; Padding
link19:	dd	link20 - link19
	db	'cmd$',0
	checkalign
cmdadr:	dd	0		; Command line address
cmdlen:	dd	0		; Command line length
;
	times 7	db 0		; Padding
link20:	dd	link21 - link20
	db	'usr$',0
	checkalign
usradr:	dd	0		; User directory address
usrlen:	dd	0		; User directory length
;
	times 6	db 0		; Padding
link25:	dd	link26 - link25
	db	'pany%',0
	checkalign
pany:	dd	0		; Vertical pan
;
	times 3	db 0		; Padding
link21:	dd	link22 - link21
	db	'tmp$',0
	checkalign
tmpadr:	dd	0		; Temp directory address
tmplen:	dd	0		; Temp directory length
;
	times 7	db 0		; Padding
link22:	dd	link23 - link22
	db	'vdu{',0
	checkalign
	dq	vdufmt		; Structure format address 
	dq	hrect		; Structure data address
;
	times 6	db 0		; Padding
link14:	dd	link15 - link14
	db	'zoom%',0
	checkalign
zoom:	dd	0
;
	times 7	db 0		; Padding
link8:	dd	link9 - link8
	db	'hfile%%(',0
	checkalign
	dq	farray		; Pointer to file handles array
;
	times 5	db 0		; Padding
link26:	dd	link27 - link26
	db	'brkpt%',0
	checkalign
breakpt:dd	0		; Breakpoint (bottom of range)
;
	times 3	db 0		; Padding
link15:	dd	link16 - link15
	db	'hwo%',0
	checkalign
hwo:	dd	0		; Handle for wave output
;
	db	0		; Padding
link27:	dd	link28 - link27
	db	'brkhi%',0
	checkalign
breakhi:dd	0		; Breakpoint (top of range)
;
	dw	0		; Padding
link28:	dd	link29 - link28
	db	'size{',0	; V6.1 Member name
	checkalign
	dq	ptfmt		; V6.1 Format address
	dq	sizex		; V6.1 Data offset
;
	times 6	db 0		; Padding
link29:	dd	link00 - link29
	db	'char{',0	; V6.1 Member name
	checkalign
	dq	ptfmt		; V6.1 Format address
	dq	charx		; V6.1 Data offset
;
	dd	0		; Padding
link13:	dd	link14 - link13
	db	'cache%%',0
	checkalign
	dq	TTFcache	; Font cache
;
; Structure @vdu{o{x%,y%}, l{x%,y%}, p{x%,y%}, tl%, tr%, tt%, tb%,
;                d{x%,y%}, c{x%,y%}, hf%%, hr%%,
;                g{a&,b&,c&,d&}, t{a&,b&,c&,d&}, m{a&,b&,c&,d&}}
;
	times 5	db 0		; Padding
vdufmt:	dd	sndqw-hrect	; Total length (bytes)
vlnk00:	dd	vlnk01 - vlnk00	; Link to next
	db	'o{',0		; Member name
	checkalign
	dq	ptfmt
	dq	origx-hrect	; Data offset
;
	db	0		; Padding
vlnk01:	dd	vlnk02 - vlnk01
	db	'l{',0		; Member name
	checkalign
	dq	ptfmt
	dq	lastx-hrect	; Data offset
;
	db	0		; Padding
vlnk02:	dd	vlnk03 - vlnk02
	db	'p{',0		; Member name
	checkalign
	dq	ptfmt
	dq	prevx-hrect	; Data offset
;
vlnk03:	dd	vlnk04 - vlnk03
	db	'tl%',0		; Member name
	checkalign
	dd	textwl-hrect	; Data offset
;
	dd	0		; Padding
vlnk04:	dd	vlnk05 - vlnk04
	db	'tr%',0		; Member name
	checkalign
	dd	textwr-hrect	; Data offset
;
	dd	0		; Padding
vlnk05:	dd	vlnk06 - vlnk05
	db	'tt%',0		; Member name
	checkalign
	dd	textwt-hrect	; Data offset
;
	dd	0		; Padding
vlnk06:	dd	vlnk07 - vlnk06
	db	'tb%',0		; Member name
	checkalign
	dd	textwb-hrect	; Data offset
;
	times 5	db 0		; Padding
vlnk07:	dd	vlnk08 - vlnk07
	db	'd{',0		; Member name
	checkalign
	dq	ptfmt
	dq	pixelx-hrect	; Data offset
;
	db	0		; Padding
vlnk08:	dd	vlnk09 - vlnk08
	db	'c{',0		; Member name
	checkalign
	dq	ptfmt
	dq	textx-hrect	; Data offset
;
	times 7	db 0		; Padding
vlnk09:	dd	vlnk10 - vlnk09
	db	'hf%%',0	; Member name
	checkalign
	dd	hfont-hrect	; Data offset
;
	times 3	db 0		; Padding
vlnk10:	dd	vlnk11 - vlnk10
	db	'hr%%',0	; Member name
	checkalign
	dd	hrect-hrect	; Data offset
;
	times 5	db 0		; Padding
vlnk11:	dd	vlnk12 - vlnk11
	db	'g{',0		; Member name
	checkalign
	dq	b4fmt
	dq	forgnd-hrect	; Data offset
;
	db	0		; Padding
vlnk12:	dd	vlnk13 - vlnk12
	db	't{',0		; Member name
	checkalign
	dq	b4fmt
	dq	cursa-hrect	; Data offset
;
	db	0		; Padding
vlnk13:	dd	vlnk14 - vlnk13
	db	'm{',0		; Member name
	checkalign
	dq	b4fmt
	dq	modeno-hrect	; Data offset
;
	db	0		; Padding
vlnk14:	dd	0
	db	'w{',0		; V6.1 Member name
	checkalign
	dq	b4fmt		; V6.1 Format address
	dq	cursx-hrect	; V6.1 Data offset
;
	SEGMENT .text
;
bbcfont:
	DB	00H,00H,00H,00H,00H,00H,00H,00H		;NUL
	DB	07EH,081H,0A5H,081H,0BDH,099H,081H,07EH	;SOH
	DB	07EH,0FFH,0DBH,0FFH,0C3H,0E7H,0FFH,07EH	;STX
	DB	06CH,0FEH,0FEH,0FEH,07CH,038H,010H,00H	;ETX
	DB	010H,038H,07CH,0FEH,07CH,038H,010H,00H	;EOT
	DB	010H,038H,038H,0D6H,0FEH,0D6H,010H,038H	;ENQ
	DB	010H,038H,07CH,0FEH,0FEH,0FEH,038H,07CH	;ACK
	DB	00H,00H,018H,03CH,03CH,018H,00H,00H	;BEL
	DB	0FFH,0FFH,0E7H,0C3H,0C3H,0E7H,0FFH,0FFH	;BS
	DB	00H,03CH,066H,042H,042H,066H,03CH,00H	;HT
	DB	0FFH,0C3H,099H,0BDH,0BDH,099H,0C3H,0FFH	;LF
	DB	0FH,07H,0FH,07DH,0CCH,0CCH,0CCH,078H	;VT
	DB	03CH,066H,066H,066H,03CH,018H,07EH,018H	;FF
	DB	03FH,033H,03FH,030H,030H,070H,0F0H,0E0H	;CR
	DB	07FH,063H,07FH,063H,063H,067H,0E6H,0C0H	;SO
	DB	099H,05AH,03CH,0E7H,0E7H,03CH,05AH,099H	;SI
	DB	080H,0E0H,0F8H,0FEH,0F8H,0E0H,080H,00H	;DLE
	DB	02H,0EH,03EH,0FEH,03EH,0EH,02H,00H	;DC1
	DB	018H,03CH,07EH,018H,018H,07EH,03CH,018H	;DC2
	DB	066H,066H,066H,066H,066H,00H,066H,00H	;DC3
	DB	07FH,0DBH,0DBH,07BH,01BH,01BH,01BH,00H	;DC4
	DB	03EH,063H,038H,06CH,06CH,038H,0CCH,078H	;NAK
	DB	00H,00H,00H,00H,07EH,07EH,07EH,00H	;SYN
	DB	018H,03CH,07EH,018H,07EH,03CH,018H,0FFH	;ETB
	DB	018H,03CH,07EH,018H,018H,018H,018H,00H	;CAN
	DB	018H,018H,018H,018H,07EH,03CH,018H,00H	;EM
	DB	00H,018H,0CH,0FEH,0CH,018H,00H,00H	;SUB
	DB	00H,030H,060H,0FEH,060H,030H,00H,00H	;ESC
	DB	00H,00H,0C0H,0C0H,0C0H,0FEH,00H,00H	;FS
	DB	00H,024H,066H,0FFH,066H,024H,00H,00H	;GS
	DB	00H,018H,03CH,07EH,0FFH,0FFH,00H,00H	;RS
	DB	00H,0FFH,0FFH,07EH,03CH,018H,00H,00H	;US
	DB	00H,00H,00H,00H,00H,00H,00H,00H		;" "
	DB	030H,030H,030H,030H,030H,00H,030H,00H	;"!"
	DB	06CH,06CH,06CH,00H,00H,00H,00H,00H	;"""
	DB	06CH,06CH,0FEH,06CH,0FEH,06CH,06CH,00H	;"#"
	DB	018H,07EH,0D0H,07CH,016H,0FCH,030H,00H	;"$"
	DB	0C0H,0CCH,018H,030H,060H,0CCH,0CH,00H	;"%"
	DB	038H,06CH,038H,076H,0DCH,0CCH,076H,00H	;"&"
	DB	018H,030H,060H,00H,00H,00H,00H,00H	;"'"
	DB	018H,030H,060H,060H,060H,030H,018H,00H	;"("
	DB	060H,030H,018H,018H,018H,030H,060H,00H	;")"
	DB	00H,06CH,038H,0FEH,038H,06CH,00H,00H	;"*"
	DB	00H,030H,030H,0FCH,030H,030H,00H,00H	;"+"
	DB	00H,00H,00H,00H,00H,030H,030H,060H	;","
	DB	00H,00H,00H,0FCH,00H,00H,00H,00H	;"-"
	DB	00H,00H,00H,00H,00H,030H,030H,00H	;"."
	DB	00H,0CH,018H,030H,060H,0C0H,00H,00H	;"/"
	DB	078H,0CCH,0DCH,0FCH,0ECH,0CCH,078H,00H	;"0"
	DB	030H,070H,030H,030H,030H,030H,0FCH,00H	;"1"
	DB	078H,0CCH,0CH,018H,030H,060H,0FCH,00H	;"2"
	DB	078H,0CCH,0CH,038H,0CH,0CCH,078H,00H	;"3"
	DB	018H,038H,078H,0D8H,0FCH,018H,018H,00H	;"4"
	DB	0FCH,0C0H,0F8H,0CH,0CH,0CCH,078H,00H	;"5"
	DB	038H,060H,0C0H,0F8H,0CCH,0CCH,078H,00H	;"6"
	DB	0FCH,0CH,018H,030H,060H,060H,060H,00H	;"7"
	DB	078H,0CCH,0CCH,078H,0CCH,0CCH,078H,00H	;"8"
	DB	078H,0CCH,0CCH,07CH,0CH,018H,070H,00H	;"9"
	DB	00H,00H,030H,030H,00H,030H,030H,00H	;":"
	DB	00H,00H,030H,030H,00H,030H,030H,060H	;";"
	DB	018H,030H,060H,0C0H,060H,030H,018H,00H	;"<"
	DB	00H,00H,0FCH,00H,0FCH,00H,00H,00H	;"="
	DB	060H,030H,018H,0CH,018H,030H,060H,00H	;">"
	DB	078H,0CCH,018H,030H,030H,00H,030H,00H	;"?"
	DB	078H,0CCH,0DCH,0D4H,0DCH,0C0H,078H,00H	;"@"
	DB	078H,0CCH,0CCH,0FCH,0CCH,0CCH,0CCH,00H	;"A"
	DB	0F8H,0CCH,0CCH,0F8H,0CCH,0CCH,0F8H,00H	;"B"
	DB	078H,0CCH,0C0H,0C0H,0C0H,0CCH,078H,00H	;"C"
	DB	0F0H,0D8H,0CCH,0CCH,0CCH,0D8H,0F0H,00H	;"D"
	DB	0FCH,0C0H,0C0H,0F8H,0C0H,0C0H,0FCH,00H	;"E"
	DB	0FCH,0C0H,0C0H,0F8H,0C0H,0C0H,0C0H,00H	;"F"
	DB	078H,0CCH,0C0H,0DCH,0CCH,0CCH,078H,00H	;"G"
	DB	0CCH,0CCH,0CCH,0FCH,0CCH,0CCH,0CCH,00H	;"H"
	DB	0FCH,030H,030H,030H,030H,030H,0FCH,00H	;"I"
	DB	07CH,018H,018H,018H,018H,0D8H,070H,00H	;"J"
	DB	0CCH,0D8H,0F0H,0E0H,0F0H,0D8H,0CCH,00H	;"K"
	DB	0C0H,0C0H,0C0H,0C0H,0C0H,0C0H,0FCH,00H	;"L"
	DB	0C6H,0EEH,0FEH,0D6H,0D6H,0C6H,0C6H,00H	;"M"
	DB	0CCH,0CCH,0ECH,0FCH,0DCH,0CCH,0CCH,00H	;"N"
	DB	078H,0CCH,0CCH,0CCH,0CCH,0CCH,078H,00H	;"O"
	DB	0F8H,0CCH,0CCH,0F8H,0C0H,0C0H,0C0H,00H	;"P"
	DB	078H,0CCH,0CCH,0CCH,0DCH,078H,01CH,00H	;"Q"
	DB	0F8H,0CCH,0CCH,0F8H,0D8H,0CCH,0CCH,00H	;"R"
	DB	078H,0CCH,0C0H,078H,0CH,0CCH,078H,00H	;"S"
	DB	0FCH,030H,030H,030H,030H,030H,030H,00H	;"T"
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,078H,00H	;"U"
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,078H,030H,00H	;"V"
	DB	0C6H,0C6H,0D6H,0D6H,0FEH,0EEH,0C6H,00H	;"W"
	DB	0CCH,0CCH,078H,030H,078H,0CCH,0CCH,00H	;"X"
	DB	0CCH,0CCH,0CCH,078H,030H,030H,030H,00H	;"Y"
	DB	0FCH,0CH,018H,030H,060H,0C0H,0FCH,00H	;"Z"
	DB	0F8H,0C0H,0C0H,0C0H,0C0H,0C0H,0F8H,00H	;"["
	DB	00H,0C0H,060H,030H,018H,0CH,00H,00H	;"\"
	DB	07CH,0CH,0CH,0CH,0CH,0CH,07CH,00H	;"]"
	DB	010H,038H,06CH,0C6H,00H,00H,00H,00H	;"^"
	DB	00H,00H,00H,00H,00H,00H,00H,0FFH	;"_"
	DB	060H,030H,018H,00H,00H,00H,00H,00H	;"`"
	DB	00H,00H,078H,0CH,07CH,0CCH,07CH,00H	;"a"
	DB	0C0H,0C0H,0F8H,0CCH,0CCH,0CCH,0F8H,00H	;"b"
	DB	00H,00H,078H,0CCH,0C0H,0CCH,078H,00H	;"c"
	DB	0CH,0CH,07CH,0CCH,0CCH,0CCH,07CH,00H	;"d"
	DB	00H,00H,078H,0CCH,0FCH,0C0H,078H,00H	;"e"
	DB	038H,060H,060H,0F8H,060H,060H,060H,00H	;"f"
	DB	00H,00H,07CH,0CCH,0CCH,07CH,0CH,078H	;"g"
	DB	0C0H,0C0H,0F8H,0CCH,0CCH,0CCH,0CCH,00H	;"h"
	DB	030H,00H,070H,030H,030H,030H,078H,00H	;"i"
	DB	030H,00H,070H,030H,030H,030H,030H,0E0H	;"j"
	DB	0C0H,0C0H,0CCH,0D8H,0F0H,0D8H,0CCH,00H	;"k"
	DB	070H,030H,030H,030H,030H,030H,078H,00H	;"l"
	DB	00H,00H,06CH,0FEH,0D6H,0D6H,0C6H,00H	;"m"
	DB	00H,00H,0F8H,0CCH,0CCH,0CCH,0CCH,00H	;"n"
	DB	00H,00H,078H,0CCH,0CCH,0CCH,078H,00H	;"o"
	DB	00H,00H,0F8H,0CCH,0CCH,0F8H,0C0H,0C0H	;"p"
	DB	00H,00H,07CH,0CCH,0CCH,07CH,0CH,0EH	;"q"
	DB	00H,00H,0D8H,0ECH,0C0H,0C0H,0C0H,00H	;"r"
	DB	00H,00H,07CH,0C0H,078H,0CH,0F8H,00H	;"s"
	DB	060H,060H,0F8H,060H,060H,060H,038H,00H	;"t"
	DB	00H,00H,0CCH,0CCH,0CCH,0CCH,07CH,00H	;"u"
	DB	00H,00H,0CCH,0CCH,0CCH,078H,030H,00H	;"v"
	DB	00H,00H,0C6H,0D6H,0D6H,0FEH,06CH,00H	;"w"
	DB	00H,00H,0CCH,078H,030H,078H,0CCH,00H	;"x"
	DB	00H,00H,0CCH,0CCH,0CCH,07CH,0CH,078H	;"y"
	DB	00H,00H,0FCH,018H,030H,060H,0FCH,00H	;"z"
	DB	018H,030H,030H,0E0H,030H,030H,018H,00H	;"{"
	DB	030H,030H,030H,00H,030H,030H,030H,00H	;"|"
	DB	060H,030H,030H,01CH,030H,030H,060H,00H	;"}"
	DB	076H,0DCH,00H,00H,00H,00H,00H,00H	;"~"
	DB	00H,010H,038H,06CH,0C6H,0C6H,0FEH,00H	;DEL
	DB	03CH,062H,0F8H,060H,0F8H,062H,03CH,000H ; &80 euro symbol
	DB	000H,07EH,07EH,07EH,07EH,07EH,07EH,000H ; &81 block (teletext)
	DB	000H,000H,000H,000H,000H,018H,018H,030H ; &82 single low quotation mark
	DB	000H,00CH,018H,018H,03CH,018H,018H,070H ; &83 small letter f with hook
	DB	000H,000H,000H,000H,000H,06CH,06CH,0D8H ; &84 double low quotation mark
	DB	000H,000H,000H,000H,000H,000H,054H,000H ; &85 horizontal ellipsis
	DB	018H,018H,07EH,018H,018H,018H,018H,000H ; &86 dagger
	DB	018H,018H,07EH,018H,018H,07EH,018H,018H ; &87 double dagger
	DB	010H,038H,06CH,000H,000H,000H,000H,000H ; &88 circumflex accent
	DB	0C6H,0CCH,018H,030H,060H,0DBH,01BH,000H ; &89 per mille
	DB	038H,07CH,0C6H,070H,01CH,0C6H,07CH,000H ; &8A capital S caron
	DB	000H,018H,030H,060H,030H,018H,000H,000H ; &8B left angle quotation mark
	DB	07EH,0D8H,0D8H,0DEH,0D8H,0D8H,07EH,000H ; &8C capital OE ligature
	DB	030H,078H,0FCH,030H,030H,030H,030H,000H ; &8D up arrow (teletext)
	DB	038H,0FEH,00CH,018H,030H,060H,0FEH,000H ; &8E capital Z caron
	DB	000H,020H,060H,0FEH,060H,020H,000H,000H ; &8F left arrow (teletext)
	DB	000H,008H,00CH,0FEH,00CH,008H,000H,000H ; &90 right arrow (teletext)
	DB	030H,030H,018H,000H,000H,000H,000H,000H ; &91 left single quotation mark
	DB	018H,018H,030H,000H,000H,000H,000H,000H ; &92 right single quotation mark
	DB	06CH,06CH,036H,000H,000H,000H,000H,000H ; &93 left double quotation mark
	DB	036H,036H,06CH,000H,000H,000H,000H,000H ; &94 right double quotation mark
	DB	000H,000H,018H,03CH,03CH,018H,000H,000H ; &95 bullet
	DB	000H,000H,000H,0FEH,000H,000H,000H,000H ; &96 en dash
	DB	000H,000H,000H,0FFH,000H,000H,000H,000H ; &97 em dash
	DB	036H,06CH,000H,000H,000H,000H,000H,000H ; &98 small tilde
	DB	0EAH,04EH,04AH,04AH,000H,000H,000H,000H ; &99 trade mark sign
	DB	06CH,038H,07CH,0C0H,078H,00CH,0F8H,000H ; &9A small S caron
	DB	000H,030H,018H,00CH,018H,030H,000H,000H ; &9B right angle quotation mark
	DB	000H,000H,07EH,0DBH,0DFH,0D8H,07FH,000H ; &9C small OE ligature
	DB	0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,0CCH,000H ; &9D double line (teletext)
	DB	06CH,038H,07CH,018H,030H,060H,07CH,000H ; &9E small Z caron
	DB	0CCH,000H,0CCH,0CCH,078H,030H,030H,000H ; &9F capital Y diaeresis
	DB	000H,000H,000H,000H,000H,000H,000H,000H ;" "
	DB	018H,000H,018H,018H,018H,018H,018H,000H ;" "
	DB	000H,018H,07EH,0D8H,0D8H,07EH,018H,000H ;" "
	DB	038H,06CH,060H,0F0H,060H,066H,0FCH,000H ;" "
	DB	066H,03CH,066H,03CH,066H,000H,000H,000H ;" "
	DB	0C3H,066H,03CH,018H,03CH,018H,018H,000H ;" "
	DB	018H,018H,018H,000H,018H,018H,018H,000H ;" "
	DB	03CH,060H,03CH,066H,066H,03CH,006H,03CH ;" "
	DB	066H,000H,000H,000H,000H,000H,000H,000H ;" "
	DB	07EH,081H,09DH,0B1H,0B1H,09DH,081H,07EH ;" "
	DB	03CH,06CH,06CH,03EH,000H,07EH,000H,000H ;" "
	DB	000H,033H,066H,0CCH,066H,033H,000H,000H ;" "
	DB	000H,07EH,006H,006H,000H,000H,000H,000H ;" "
	DB	000H,000H,000H,03CH,000H,000H,000H,000H ;" "
	DB	07EH,081H,0B9H,0A5H,0B9H,0A5H,081H,07EH ;" "
	DB	03CH,000H,000H,000H,000H,000H,000H,000H ;" "
	DB	03CH,066H,03CH,000H,000H,000H,000H,000H ;" "
	DB	018H,018H,07EH,018H,018H,000H,07EH,000H ;" "
	DB	070H,018H,030H,060H,078H,000H,000H,000H ;" "
	DB	078H,00CH,018H,00CH,078H,000H,000H,000H ;" "
	DB	00CH,018H,030H,000H,000H,000H,000H,000H ;" "
	DB	000H,000H,066H,066H,066H,07CH,060H,0C0H ;" "
	DB	03EH,07AH,07AH,03AH,01AH,01AH,01AH,000H ;" "
	DB	000H,000H,000H,018H,000H,000H,000H,000H ;" "
	DB	000H,000H,000H,000H,000H,008H,018H,000H ;" "
	DB	030H,070H,030H,030H,030H,000H,000H,000H ;" "
	DB	038H,06CH,06CH,038H,000H,07CH,000H,000H ;" "
	DB	000H,0CCH,066H,033H,066H,0CCH,000H,000H ;" "
	DB	043H,0C6H,04CH,05AH,036H,06AH,0CFH,002H ;" "
	DB	040H,0C6H,04CH,05EH,033H,066H,0CCH,00FH ;" "
	DB	0C0H,023H,066H,02DH,0DBH,035H,067H,001H ;" "
	DB	018H,000H,018H,030H,060H,066H,03CH,000H ;" "
	DB	070H,000H,03CH,066H,07EH,066H,066H,000H ;" "
	DB	00EH,000H,03CH,066H,07EH,066H,066H,000H ;" "
	DB	018H,066H,000H,03CH,066H,07EH,066H,000H ;" "
	DB	076H,0DCH,000H,03CH,066H,07EH,066H,000H ;" "
	DB	066H,000H,03CH,066H,07EH,066H,066H,000H ;" "
	DB	018H,018H,000H,03CH,066H,07EH,066H,000H ;" "
	DB	03FH,06CH,0CCH,0FEH,0CCH,0CCH,0CFH,000H ;" "
	DB	03CH,066H,060H,060H,060H,066H,03CH,018H ;" "
	DB	070H,000H,07EH,060H,07CH,060H,07EH,000H ;" "
	DB	00EH,000H,07EH,060H,07CH,060H,07EH,000H ;" "
	DB	018H,066H,000H,0FEH,0F0H,0C0H,0FEH,000H ;" "
	DB	066H,000H,07EH,060H,07CH,060H,07EH,000H ;" "
	DB	070H,000H,07EH,018H,018H,018H,07EH,000H ;" "
	DB	00EH,000H,07EH,018H,018H,018H,07EH,000H ;" "
	DB	018H,066H,000H,07EH,018H,018H,07EH,000H ;" "
	DB	066H,000H,07EH,018H,018H,018H,07EH,000H ;" "
	DB	078H,06CH,066H,0F6H,066H,06CH,078H,000H ;" "
	DB	076H,0DCH,000H,0C6H,0F6H,0DEH,0C6H,000H ;" "
	DB	070H,000H,07CH,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	00EH,000H,07CH,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	018H,066H,000H,07CH,0C6H,0C6H,07CH,000H ;" "
	DB	076H,0DCH,000H,07CH,0C6H,0C6H,07CH,000H ;" "
	DB	066H,000H,07CH,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	000H,0C6H,06CH,038H,06CH,0C6H,000H,000H ;" "
	DB	03EH,066H,06EH,07EH,076H,066H,07CH,000H ;" "
	DB	070H,000H,0C6H,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	00EH,000H,0C6H,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	018H,066H,000H,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	066H,000H,0C6H,0C6H,0C6H,0C6H,07CH,000H ;" "
	DB	00EH,000H,066H,066H,03CH,018H,018H,000H ;" "
	DB	0C0H,0C0H,0FCH,0C6H,0FCH,0C0H,0C0H,000H ;" "
	DB	03CH,066H,066H,06CH,066H,066H,06CH,000H ;" "
	DB	070H,000H,03CH,006H,03EH,066H,03EH,000H ;" "
	DB	00EH,000H,03CH,006H,03EH,066H,03EH,000H ;" "
	DB	018H,066H,000H,03EH,066H,0C6H,07EH,000H ;" "
	DB	076H,0DCH,000H,03EH,066H,0C6H,07EH,000H ;" "
	DB	066H,000H,03CH,006H,03EH,066H,03EH,000H ;" "
	DB	018H,018H,000H,03EH,066H,0C6H,07EH,000H ;" "
	DB	000H,000H,07EH,01BH,07FH,0D8H,077H,000H ;" "
	DB	000H,000H,03CH,060H,060H,060H,03CH,018H ;" "
	DB	070H,000H,03CH,066H,07EH,060H,03CH,000H ;" "
	DB	00EH,000H,03CH,066H,07EH,060H,03CH,000H ;" "
	DB	018H,066H,000H,03CH,07EH,060H,03CH,000H ;" "
	DB	066H,000H,03CH,066H,07EH,060H,03CH,000H ;" "
	DB	070H,000H,038H,018H,018H,018H,03CH,000H ;" "
	DB	00EH,000H,038H,018H,018H,018H,03CH,000H ;" "
	DB	018H,066H,000H,038H,018H,018H,03CH,000H ;" "
	DB	066H,000H,038H,018H,018H,018H,03CH,000H ;" "
	DB	00CH,03EH,00CH,07CH,0CCH,0CCH,078H,000H ;" "
	DB	076H,0DCH,000H,07CH,066H,066H,066H,000H ;" "
	DB	070H,000H,03CH,066H,066H,066H,03CH,000H ;" "
	DB	00EH,000H,03CH,066H,066H,066H,03CH,000H ;" "
	DB	018H,066H,000H,03CH,066H,066H,03CH,000H ;" "
	DB	076H,0DCH,000H,03CH,066H,066H,03CH,000H ;" "
	DB	066H,000H,03CH,066H,066H,066H,03CH,000H ;" "
	DB	018H,018H,000H,07EH,000H,018H,018H,000H ;" "
	DB	000H,002H,07CH,0CEH,0D6H,0E6H,07CH,080H ;" "
	DB	070H,000H,066H,066H,066H,066H,03EH,000H ;" "
	DB	00EH,000H,066H,066H,066H,066H,03EH,000H ;" "
	DB	018H,066H,000H,066H,066H,066H,03EH,000H ;" "
	DB	066H,000H,066H,066H,066H,066H,03EH,000H ;" "
	DB	00EH,000H,066H,066H,066H,03EH,006H,03CH ;" "
	DB	060H,060H,07CH,066H,066H,07CH,060H,060H ;" "
	DB	066H,000H,066H,066H,066H,03EH,006H,03CH ;" "
;
ttxtfont:
	DW	00000H,00011H,00011H,00019H,00015H,00013H,00011H,00011H,08800H,08800H,08800H,08800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; NU
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,0F000H,08800H,08800H,0F000H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; AR
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; AG
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,08800H,08800H,05000H,02000H,02000H,02000H,02000H,00000H,00000H,00000H,00000H,00000H ; AY
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; AB
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,08800H,0D800H,0A800H,0A800H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; AM
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,07000H,08800H,08000H,08000H,08000H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; AC
	DW	00000H,0000EH,00011H,00011H,0001FH,00011H,00011H,00011H,08800H,08800H,08800H,0A800H,0A800H,0D800H,08800H,00000H,00000H,00000H,00000H,00000H ; AW
	DW	00000H,0001FH,00010H,00010H,0001EH,00010H,00010H,00010H,08000H,08000H,08000H,08000H,08000H,08000H,0F800H,00000H,00000H,00000H,00000H,00000H ; FL
	DW	00000H,0000EH,00011H,00010H,0000EH,00001H,00011H,0000EH,0F800H,02000H,02000H,02000H,02000H,02000H,02000H,00000H,00000H,00000H,00000H,00000H ; ST
	DW	00000H,0001FH,00010H,00010H,0001EH,00010H,00010H,0001FH,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; EB
	DW	00000H,0000EH,00011H,00010H,0000EH,00001H,00011H,0000EH,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; SB
	DW	00000H,00011H,00011H,00019H,00015H,00013H,00011H,00011H,08800H,08800H,08800H,0F800H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; NH
	DW	00000H,0001CH,00012H,00011H,00011H,00011H,00012H,0001CH,08800H,08800H,08800H,0F800H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; DH
	DW	00000H,0000EH,00011H,00010H,0000EH,00001H,00011H,0000EH,07000H,08800H,08800H,08800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; SO
	DW	00000H,0000EH,00011H,00010H,0000EH,00001H,00011H,0000EH,07000H,02000H,02000H,02000H,02000H,02000H,07000H,00000H,00000H,00000H,00000H,00000H ; SI
	DW	00000H,0001CH,00012H,00011H,00011H,00011H,00012H,0001CH,08000H,08000H,08000H,08000H,08000H,08000H,0F800H,00000H,00000H,00000H,00000H,00000H ; DL
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,0F000H,08800H,08800H,0F000H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; GR
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; GG
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,08800H,08800H,05000H,02000H,02000H,02000H,02000H,00000H,00000H,00000H,00000H,00000H ; GY
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; GB
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,08800H,0D800H,0A800H,0A800H,08800H,08800H,08800H,00000H,00000H,00000H,00000H,00000H ; GM
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,07000H,08800H,08000H,08000H,08000H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; GC
	DW	00000H,0000EH,00011H,00010H,00013H,00011H,00011H,0000EH,08800H,08800H,08800H,0A800H,0A800H,0D800H,08800H,00000H,00000H,00000H,00000H,00000H ; GW
	DW	00000H,0000EH,00011H,00010H,00010H,00010H,00011H,0000EH,0E000H,09000H,08800H,08800H,08800H,09000H,0E000H,00000H,00000H,00000H,00000H,00000H ; CD
	DW	00000H,0000EH,00011H,00010H,00010H,00010H,00011H,0000EH,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; CG
	DW	00000H,0000EH,00011H,00010H,0000EH,00001H,00011H,0000EH,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; SG
	DW	00000H,0001FH,00010H,00010H,0001EH,00010H,00010H,0001FH,07000H,08800H,08000H,07000H,00800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; ES
	DW	00000H,0001EH,00011H,00011H,0001EH,00011H,00011H,0001EH,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; BB
	DW	00000H,00011H,00011H,00019H,00015H,00013H,00011H,00011H,0F000H,08800H,08800H,0F000H,08800H,08800H,0F000H,00000H,00000H,00000H,00000H,00000H ; NB
	DW	00000H,00011H,00011H,00011H,0001FH,00011H,00011H,00011H,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; HG
	DW	00000H,0001EH,00011H,00011H,0001EH,00011H,00011H,00011H,07000H,08800H,08000H,09800H,08800H,08800H,07000H,00000H,00000H,00000H,00000H,00000H ; RG
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "!"
	DW	00000H,0700EH,0700EH,0700EH,0700EH,0700EH,0700EH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; """
	DW	00000H,0700EH,0700EH,0700EH,0700EH,0FC3FH,0FC3FH,0700EH,0700EH,0FC3FH,0FC3FH,0700EH,0700EH,0700EH,0700EH,00000H,00000H,00000H,00000H,00000H ; "#"
	DW	00000H,0F00FH,0F81FH,09C39H,08C31H,08031H,08039H,0F01FH,0F80FH,09C01H,08C01H,08C31H,09C39H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "$"
	DW	00000H,0003CH,00C3CH,01C3CH,0383CH,07000H,0E000H,0C001H,08003H,00007H,0000EH,03C1CH,03C38H,03C30H,03C00H,00000H,00000H,00000H,00000H,00000H ; "%"
	DW	00000H,0000EH,0001FH,0803BH,08031H,0803BH,0001FH,0000EH,0001FH,08C3BH,0DC31H,0F830H,0F838H,0DC1FH,08C0FH,00000H,00000H,00000H,00000H,00000H ; "&"
	DW	00000H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "'"
	DW	00000H,06000H,0E000H,0C001H,08003H,00007H,00006H,00006H,00006H,00006H,00007H,08003H,0C001H,0E000H,06000H,00000H,00000H,00000H,00000H,00000H ; "("
	DW	00000H,00006H,00007H,08003H,0C001H,0E000H,06000H,06000H,06000H,06000H,0E000H,0C001H,08003H,00007H,00006H,00000H,00000H,00000H,00000H,00000H ; ")"
	DW	00000H,08001H,08001H,08C31H,09C39H,0F81FH,0F00FH,08001H,08001H,0F00FH,0F81FH,09C39H,08C31H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "*"
	DW	00000H,00000H,00000H,08001H,08001H,08001H,08001H,0F81FH,0F81FH,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "+"
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,08001H,08001H,08001H,08003H,00007H,00006H,00000H,00000H,00000H ; ","
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "-"
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "."
	DW	00000H,00000H,00C00H,01C00H,03800H,07000H,0E000H,0C001H,08003H,00007H,0000EH,0001CH,00038H,00030H,00000H,00000H,00000H,00000H,00000H,00000H ; "/"
	DW	00000H,0C003H,0E007H,0700EH,0381CH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0381CH,0700EH,0E007H,0C003H,00000H,00000H,00000H,00000H,00000H ; "0"
	DW	00000H,08001H,08001H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "1"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C00H,01C00H,0F803H,0F007H,0000EH,0001CH,00038H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; "2"
	DW	00000H,0FC3FH,0FC3FH,01C00H,03800H,07000H,0E000H,0F801H,0FC01H,00C00H,00C00H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "3"
	DW	00000H,07000H,0F000H,0F001H,0B003H,03007H,0300EH,0301CH,03038H,0FC3FH,0FC3FH,03000H,03000H,03000H,03000H,00000H,00000H,00000H,00000H,00000H ; "4"
	DW	00000H,0FC3FH,0FC3FH,00030H,00030H,0F03FH,0F83FH,01C00H,00C00H,00C00H,00C00H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "5"
	DW	00000H,0F001H,0F007H,0000FH,0001CH,00038H,00030H,0F03FH,0F83FH,01C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "6"
	DW	00000H,0FC3FH,0FC3FH,00C00H,01C00H,03800H,07000H,0E000H,0C001H,08003H,00007H,00006H,00006H,00006H,00006H,00000H,00000H,00000H,00000H,00000H ; "7"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,01C38H,0F81FH,0F81FH,01C38H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "8"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,01C00H,03800H,0F000H,0E00FH,0800FH,00000H,00000H,00000H,00000H,00000H ; "9"
	DW	00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; ":"
	DW	00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,08001H,08001H,08001H,08003H,00007H,00006H,00000H,00000H,00000H ; ";"
	DW	00000H,06000H,0E000H,0C001H,08003H,00007H,0000EH,0001CH,0001CH,0000EH,00007H,08003H,0C001H,0E000H,06000H,00000H,00000H,00000H,00000H,00000H ; "<"
	DW	00000H,00000H,00000H,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "="
	DW	00000H,00006H,00007H,08003H,0C001H,0E000H,07000H,03800H,03800H,07000H,0E000H,0C001H,08003H,00007H,00006H,00000H,00000H,00000H,00000H,00000H ; ">"
	DW	00000H,0E00FH,0F01FH,03838H,01830H,03800H,07000H,0E000H,0C001H,08001H,08001H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "?"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,0FC31H,0FC31H,08C31H,08C31H,0FC31H,0FC31H,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "@"
	DW	00000H,08001H,0C003H,0E007H,0700EH,0381CH,01C38H,00C30H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "A"
	DW	00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,01C30H,0F83FH,0F83FH,01C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00000H,00000H,00000H,00000H,00000H ; "B"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00030H,00030H,00030H,00030H,00030H,00030H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "C"
	DW	00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00000H,00000H,00000H,00000H,00000H ; "D"
	DW	00000H,0FC3FH,0FC3FH,00030H,00030H,00030H,00030H,0F03FH,0F03FH,00030H,00030H,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; "E"
	DW	00000H,0FC3FH,0FC3FH,00030H,00030H,00030H,00030H,0F03FH,0F03FH,00030H,00030H,00030H,00030H,00030H,00030H,00000H,00000H,00000H,00000H,00000H ; "F"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00030H,00030H,00030H,00030H,03C30H,03C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; "G"
	DW	00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "H"
	DW	00000H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "I"
	DW	00000H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C00H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "J"
	DW	00000H,01830H,03830H,07030H,0E030H,0C031H,08033H,0003FH,0003FH,08033H,0C031H,0E030H,07030H,03830H,01830H,00000H,00000H,00000H,00000H,00000H ; "K"
	DW	00000H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; "L"
	DW	00000H,00C30H,00C30H,01C38H,03C3CH,07C3EH,0EC37H,0CC33H,08C31H,08C31H,00C30H,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "M"
	DW	00000H,00C30H,00C30H,00C38H,00C3CH,00C3EH,00C37H,08C33H,0CC31H,0EC30H,07C30H,03C30H,01C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "N"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "O"
	DW	00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00030H,00030H,00030H,00030H,00030H,00030H,00000H,00000H,00000H,00000H,00000H ; "P"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,00C30H,0CC30H,0EC30H,07830H,03838H,0FC1FH,0CC0FH,00000H,00000H,00000H,00000H,00000H ; "Q"
	DW	00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,0C031H,0E030H,07030H,03830H,01C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "R"
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00030H,00038H,0F01FH,0F80FH,01C00H,00C00H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "S"
	DW	00000H,0FC3FH,0FC3FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "T"
	DW	00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "U"
	DW	00000H,00C30H,00C30H,00C30H,00C30H,01C38H,01818H,0381CH,0300CH,0700EH,0E007H,0C003H,0C003H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "V"
	DW	00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,08C31H,08C31H,08C31H,08C31H,08C31H,0FC3FH,0F81FH,0700EH,00000H,00000H,00000H,00000H,00000H ; "W"
	DW	00000H,00C30H,00C30H,01C38H,0381CH,0700EH,0E007H,0C003H,0C003H,0E007H,0700EH,0381CH,01C38H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "X"
	DW	00000H,00C30H,00C30H,01C38H,0381CH,0700EH,0E007H,0C003H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "Y"
	DW	00000H,0FC3FH,0FC3FH,01C00H,03800H,07000H,0E000H,0C001H,08003H,00007H,0000EH,0001CH,00038H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; "Z"
	DW	00000H,0E007H,0E007H,00006H,00006H,00006H,00006H,00006H,00006H,00006H,00006H,00006H,00006H,0E007H,0E007H,00000H,00000H,00000H,00000H,00000H ; "["
	DW	00000H,00000H,00030H,00038H,0001CH,0000EH,00007H,08003H,0C001H,0E000H,07000H,03800H,01C00H,00C00H,00000H,00000H,00000H,00000H,00000H,00000H ; "\"
	DW	00000H,0E007H,0E007H,06000H,06000H,06000H,06000H,06000H,06000H,06000H,06000H,06000H,06000H,0E007H,0E007H,00000H,00000H,00000H,00000H,00000H ; "]"
	DW	00000H,08001H,0C003H,0E007H,0700EH,0381CH,01818H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "^"
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,0FFFFH,0FFFFH,00000H,00000H ; "_"
	DW	00000H,00006H,00007H,08003H,0C001H,0E000H,06000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "`"
	DW	00000H,00000H,00000H,00000H,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC1FH,0FC3FH,00C30H,00C30H,0FC3FH,0FC1FH,00000H,00000H,00000H,00000H,00000H ; "a"
	DW	00000H,00030H,00030H,00030H,00030H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00000H,00000H,00000H,00000H,00000H ; "b"
	DW	00000H,00000H,00000H,00000H,00000H,0FC0FH,0FC1FH,00038H,00030H,00030H,00030H,00030H,00038H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; "c"
	DW	00000H,00C00H,00C00H,00C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; "d"
	DW	00000H,00000H,00000H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "e"
	DW	00000H,03000H,0F000H,0C001H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "f"
	DW	00000H,00000H,00000H,00000H,00000H,0FC0FH,0FC1FH,00C38H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,01C00H,0F80FH,0F00FH,00000H ; "g"
	DW	00000H,00030H,00030H,00030H,00030H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "h"
	DW	00000H,08001H,08001H,00000H,00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "i"
	DW	00000H,08001H,08001H,00000H,00000H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08003H,0000FH,0000CH,00000H ; "j"
	DW	00000H,0000CH,0000CH,0000CH,0180CH,0380CH,0700CH,0E00CH,0C00FH,0800FH,0C00DH,0E00CH,0700CH,0380CH,0180CH,00000H,00000H,00000H,00000H,00000H ; "k"
	DW	00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "l"
	DW	00000H,00000H,00000H,00000H,00000H,0303EH,0F83FH,0FC33H,08C31H,08C31H,08C31H,08C31H,08C31H,08C31H,08C31H,00000H,00000H,00000H,00000H,00000H ; "m"
	DW	00000H,00000H,00000H,00000H,00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; "n"
	DW	00000H,00000H,00000H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; "o"
	DW	00000H,00000H,00000H,00000H,00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00030H,00030H,00030H,00030H,00000H ; "p"
	DW	00000H,00000H,00000H,00000H,00000H,0FC0FH,0FC1FH,00C38H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,00C00H,00C00H,00C00H,00000H ; "q"
	DW	00000H,00000H,00000H,00000H,00000H,0F819H,0F81BH,0001FH,0001EH,00018H,00018H,00018H,00018H,00018H,00018H,00000H,00000H,00000H,00000H,00000H ; "r"
	DW	00000H,00000H,00000H,00000H,00000H,0FC0FH,0FC1FH,00030H,00030H,0F01FH,0F80FH,00C00H,00C00H,0F83FH,0F03FH,00000H,00000H,00000H,00000H,00000H ; "s"
	DW	00000H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,0C001H,0F000H,03000H,00000H,00000H,00000H,00000H,00000H ; "t"
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; "u"
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,00C30H,00C30H,01C38H,01818H,0381CH,0700EH,0E007H,0C003H,08001H,00000H,00000H,00000H,00000H,00000H ; "v"
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,00C30H,00C30H,00C30H,08C31H,08C31H,08C31H,0FC3FH,0F81FH,0700EH,00000H,00000H,00000H,00000H,00000H ; "w"
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,01C38H,0781EH,0F00FH,0C003H,0C003H,0F00FH,0781EH,01C38H,00C30H,00000H,00000H,00000H,00000H,00000H ; "x"
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,01C00H,0F80FH,0F00FH,00000H ; "y"
	DW	00000H,00000H,00000H,00000H,00000H,0FC3FH,0FC3FH,03800H,07000H,0E001H,08007H,0000EH,0001CH,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; "z"
	DW	00000H,0F000H,0F001H,08001H,08001H,08003H,00003H,0000FH,0000FH,00003H,08003H,08001H,08001H,0F000H,0F000H,00000H,00000H,00000H,00000H,00000H ; "{"
	DW	00000H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; "|"
	DW	00000H,0000FH,0800FH,08001H,08001H,0C001H,0C000H,0F000H,0F000H,0C000H,0C001H,08001H,08001H,0000FH,0000FH,00000H,00000H,00000H,00000H,00000H ; "}"
	DW	00000H,0000EH,00C1FH,0DC3BH,0F831H,07000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; "~"
	DW	00000H,08001H,0C003H,0C003H,06006H,06006H,0300CH,0300CH,01818H,01818H,00C30H,00C30H,00C30H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; &7F DEL
	DW	00000H,0F003H,0F807H,01C0EH,00C0CH,0C03FH,0C03FH,0000CH,0000CH,0803FH,0803FH,00C0CH,01C0EH,0F807H,0F003H,00000H,00000H,00000H,00000H,00000H ; &80 euro symbol
	DW	00000H,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; &81 block (teletext)
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,08003H,08003H,08001H,08003H,00007H,0000EH,00000H,00000H,00000H ; &82 single low quotation mark
	DW	00000H,07000H,0F000H,0C001H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08003H,0000FH,0000EH,00000H ; &83 small letter f with hook
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,01C0EH,01C0EH,00C06H,01C0EH,0381CH,07038H,00000H,00000H,00000H ; &84 double low quotation mark
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,09819H,09819H,00000H,00000H,00000H,00000H,00000H ; &85 horizontal ellipsis
	DW	00000H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; &86 dagger
	DW	00000H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,0F00FH,0F00FH,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; &87 double dagger
	DW	08001H,0C003H,06006H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &88 circumflex accent
	DW	00000H,03038H,0706CH,0E06CH,0C039H,08003H,00007H,0000EH,0001CH,00038H,00070H,01C67H,0B60DH,0B60DH,01C07H,00000H,00000H,00000H,00000H,00000H ; &89 per mille
	DW	06006H,0E007H,0C003H,0F00FH,0F81FH,01C38H,00C30H,00038H,0F01FH,0F80FH,01C00H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; &8A capital S caron
	DW	00000H,00000H,00000H,08001H,08003H,00007H,0000EH,0000CH,0000EH,00007H,08003H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &8B left angle quotation mark
	DW	00000H,0FC0FH,0FC1FH,08039H,08031H,08031H,08031H,0F831H,0F831H,08031H,08031H,08031H,08039H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; &8C capital OE ligature
	DW	00000H,00000H,08001H,0C003H,0E007H,0F00FH,0B81DH,09C39H,08C31H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H ; &8D up arrow (teletext)
	DW	06006H,0E007H,0C003H,0FC3FH,0FC3FH,03800H,07000H,0E000H,0C001H,08003H,00007H,0000EH,0001CH,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; &8E capital Z caron
	DW	00000H,00000H,08001H,08003H,00007H,0000EH,0001CH,0FC3FH,0FC3FH,0001CH,0000EH,00007H,08003H,08001H,00000H,00000H,00000H,00000H,00000H,00000H ; &8F left arrow (teletext)
	DW	00000H,00000H,08001H,0C001H,0E000H,07000H,03800H,0FC3FH,0FC3FH,03800H,07000H,0E000H,0C001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H ; &90 right arrow (teletext)
	DW	00000H,07000H,0E000H,0C001H,08001H,0C001H,0C001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &91 left single quotation mark
	DW	00000H,08003H,08003H,08001H,08003H,00007H,0000EH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &92 right single quotation mark
	DW	00000H,01C0EH,0381CH,07038H,06030H,07038H,07038H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &93 left double quotation mark
	DW	00000H,01C0EH,01C0EH,00C06H,01C0EH,0381CH,07038H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &94 right double quotation mark
	DW	00000H,00000H,00000H,00000H,00000H,08001H,0C003H,0E007H,0E007H,0C003H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &95 bullet
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,0F81FH,0F81FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &96 en dash
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,0FE7FH,0FE7FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &97 em dash
	DW	06007H,0C00DH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &98 small tilde
	DW	00000H,00000H,0C67EH,0C67EH,0EE18H,0FE18H,0D618H,0D618H,0C618H,0C618H,0C618H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &99 trade mark sign
	DW	00000H,06006H,0E007H,0C003H,00000H,0FC0FH,0FC1FH,00038H,00038H,0F01FH,0F80FH,01C00H,01C00H,0F83FH,0F03FH,00000H,00000H,00000H,00000H,00000H ; &9A small S caron
	DW	00000H,00000H,00000H,08001H,0C001H,0E000H,07000H,03000H,07000H,0E000H,0C001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &9B right angle quotation mark
	DW	00000H,00000H,00000H,00000H,00000H,0780EH,0FC1FH,0CC3BH,08C31H,0FC31H,0FC31H,08031H,0C03BH,0FC1FH,07C0EH,00000H,00000H,00000H,00000H,00000H ; &9C small OE ligature
	DW	00000H,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,0381CH,00000H,00000H,00000H,00000H,00000H ; &9D double line (teletext)
	DW	00000H,06006H,0E007H,0C003H,00000H,0FC3FH,0FC3FH,03800H,07000H,0E001H,08007H,0000EH,0001CH,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; &9E small Z caron
	DW	0300CH,0300CH,0300CH,00000H,00C30H,01C38H,0381CH,0700EH,0E007H,0C003H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; &9F capital Y diaeresis
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; &A0 non-break space
	DW	00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,08001H,00000H ; " "
	DW	00000H,00000H,00000H,08001H,08001H,0FC0FH,0FC1FH,08039H,08031H,08031H,08031H,08031H,08039H,0FC1FH,0FC0FH,08001H,08001H,00000H,00000H,00000H ; " "
	DW	00000H,0F003H,0F807H,01C0EH,00C0CH,0000CH,0000CH,0803FH,0803FH,0000CH,0000CH,0000CH,0000CH,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00C30H,01C38H,0F81FH,0F00FH,0700EH,0700EH,0F00FH,0F81FH,01C38H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00C30H,01C38H,0381CH,0700EH,0FC3FH,0FC3FH,08001H,08001H,0FC3FH,0FC3FH,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,08001H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00030H,00038H,0F01FH,0F81FH,01C38H,01C38H,0F81FH,0F80FH,01C00H,00C00H,00C30H,01C38H,0F81FH,0F00FH,00000H ; " "
	DW	01818H,01818H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,0CC33H,0EC37H,06C36H,00C36H,00C36H,00C36H,06C36H,0EC37H,0CC33H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H ; " "
	DW	00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,01C0EH,0381CH,07038H,07038H,0381CH,01C0EH,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,0FC3FH,0FC3FH,00C00H,00C00H,00C00H,00C00H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,0E007H,0E007H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,0CC37H,0EC37H,06C36H,06C36H,0CC37H,08C37H,0CC37H,0EC36H,06C36H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H ; " "
	DW	00000H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0C003H,0E007H,0700EH,0381CH,0700EH,0E007H,0C003H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,08001H,08001H,08001H,08001H,0FC3FH,0FC3FH,08001H,08001H,08001H,08001H,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0C00FH,0E00FH,07000H,07000H,0E003H,0C007H,0000EH,0000CH,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0C00FH,0E00FH,07000H,07000H,0E00FH,0E00FH,07000H,07000H,0E00FH,0C00FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,06000H,0E000H,0C001H,08003H,00007H,00006H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,06030H,06030H,06030H,06030H,06030H,06030H,06030H,0F830H,0FC3FH,08C3FH,00030H,00030H,00030H,00030H,00000H ; " "
	DW	00000H,08C0FH,08C1FH,08C39H,08C31H,08C31H,08C39H,08C1FH,08C0FH,08C01H,08C01H,08C01H,08C01H,08C01H,08C01H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,08001H,08001H,08003H,00007H,00006H,00000H ; " "
	DW	00000H,08003H,08007H,0800FH,0800DH,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,00000H,00000H,07038H,0381CH,01C0EH,01C0EH,0381CH,07038H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0000CH,0000CH,0000CH,0000CH,0000CH,0000CH,0000CH,0000CH,01C0CH,03C0CH,07C00H,0EC00H,0CC01H,08C01H,0FC01H,0FC01H,00C00H,00C00H,00000H ; " "
	DW	00000H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,00030H,0F831H,0FC31H,00C00H,00C00H,07C00H,0F800H,0C001H,08001H,0FC01H,0FC01H,00000H ; " "
	DW	00000H,0003EH,0003FH,08003H,08003H,0003FH,0003FH,08003H,08003H,01C3FH,03C3EH,07C00H,0EC00H,0CC01H,08C01H,0FC01H,0FC01H,00C00H,00C00H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,08001H,08001H,00000H,00000H,08001H,08001H,08003H,00007H,0000EH,0001CH,00C18H,01C1CH,0F80FH,0F00FH,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0300CH,0300CH,0300CH,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,06006H,06006H,0C003H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0FC0FH,0FC1FH,08039H,08031H,08031H,08031H,0F83FH,0F83FH,08031H,08031H,08031H,08031H,0FC31H,0FC31H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,00C30H,00030H,00030H,00030H,00030H,00030H,00030H,00C30H,01C38H,0F81FH,0F00FH,08001H,08003H,00007H,00006H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0FC3FH,0FC3FH,00030H,00030H,0F03FH,0F03FH,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0FC3FH,0FC3FH,00030H,00030H,0F03FH,0F03FH,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0FC3FH,0FC3FH,00030H,00030H,0F03FH,0F03FH,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0300CH,0300CH,0300CH,00000H,00000H,0FC3FH,0FC3FH,00030H,00030H,0F03FH,0F03FH,00030H,00030H,0FC3FH,0FC3FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0300CH,0300CH,0300CH,00000H,00000H,0F00FH,0F00FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F80FH,01C0CH,00C0CH,00C0CH,00C0CH,08C3FH,08C3FH,00C0CH,00C0CH,00C0CH,01C0CH,0F80FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,00C30H,00C3CH,00C3EH,00C37H,08C33H,0CC31H,0EC30H,07C30H,03C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0300CH,0300CH,0300CH,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,01818H,0381CH,0700EH,0E007H,0C003H,0E007H,0700EH,0381CH,01818H,00000H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0F00FH,0F81FH,01C38H,03C30H,07C30H,0EC30H,0CC31H,08C33H,00C37H,00C3EH,00C3CH,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	0300CH,0300CH,0300CH,00000H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00C30H,01C38H,0381CH,0700EH,0E007H,0C003H,08001H,08001H,08001H,08001H,08001H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00030H,00030H,0F03FH,0F83FH,01C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00030H,00030H,00030H,00030H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0C00FH,0E01FH,07038H,03030H,03030H,03030H,0F031H,0F831H,01C30H,00C30H,00C30H,01C30H,0F831H,0F031H,00030H,00030H,00030H,00030H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,06006H,0C003H,08001H,0F00FH,0F80FH,01C00H,00C00H,0FC0FH,0FC1FH,00C38H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,0781EH,0FC1FH,08C03H,08C01H,0FC1FH,0FC3FH,08031H,08031H,0F83FH,0F81FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,0FC0FH,0FC1FH,00038H,00030H,00030H,00030H,00030H,00038H,0FC1FH,0FC0FH,0C000H,0C001H,08003H,00003H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,0F00FH,0F81FH,01C38H,00C30H,0FC3FH,0FC3FH,00030H,00038H,0F01FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,0800FH,0800FH,08001H,08001H,08001H,08001H,08001H,08001H,0F00FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0601EH,0E01FH,0C003H,0E007H,0700EH,0380CH,01C00H,00C00H,0FC0FH,0FC1FH,01C38H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	01807H,0B80FH,0F01DH,0E018H,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,00000H,0F00FH,0F81FH,01C38H,00C30H,00C30H,00C30H,01C38H,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,08001H,08001H,00000H,00000H,0FC3FH,0FC3FH,00000H,00000H,08001H,08001H,00000H,00000H,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,00000H,00000H,00000H,00000H,0F00FH,0F81FH,07C38H,0EC30H,0CC31H,08C33H,00C37H,01C3EH,0F81FH,0F00FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00006H,00007H,08003H,08001H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	08001H,0C003H,0E007H,06006H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00000H,00000H,00000H,00000H,00000H ; " "
	DW	06000H,0E000H,0C001H,08001H,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,01C00H,0F80FH,0F00FH,00000H ; " "
	DW	00000H,00030H,00030H,00030H,00030H,0F03FH,0F83FH,01C30H,00C30H,00C30H,00C30H,00C30H,01C30H,0F83FH,0F03FH,00030H,00030H,00030H,00030H,00000H ; " "
	DW	00000H,0300CH,0300CH,0300CH,00000H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C30H,00C38H,0FC1FH,0FC0FH,00C00H,01C00H,0F80FH,0F00FH,00000H ; " "
;
; Structure {x%,y%}
;
ptfmt:	dd	8		; Total length (bytes)
ptlnk0:	dd	ptlnk1 - ptlnk0	; Link to next member
	db	'x%',0		; Member name
	dd	0		; Member offset (bytes)
ptlnk1:	dd	0		; Terminating link
	db	'y%',0		; Member name
	dd	4		; Member offset (bytes)
;
; Structure {a&,b&,c&,d&}
;
b4fmt:	dd	4		; Total length (bytes)
b4lnk0:	dd	b4lnk1 - b4lnk0	; Link to next member
	db	'a&',0		; Member name
	dd	0		; Member offset (bytes)
b4lnk1:	dd	b4lnk2 - b4lnk1	; Link to next member
	db	'b&',0		; Member name
	dd	1		; Member offset (bytes)
b4lnk2:	dd	b4lnk3 - b4lnk2	; Link to next member
	db	'c&',0		; Member name
	dd	2		; Member offset (bytes)
b4lnk3:	dd	0		; Terminating link
	db	'd&',0		; Member name
	dd	3		; Member offset (bytes)
;
; FastVar token type values:
;
fvtab:	db	1		; &19 v&  Unsigned byte (8 bits)
	db	4		; &1A v%  Signed dword (32 bits)
	db	8		; &1B v#  Float double (64 bits)
	db	10		; &1C v   Variant numeric (80 bits)
	db	16		; &1D v{} Structure (8+8 bytes)
	db	40		; &1E v%% Signed qword (64 bits)
	db	136		; &1F v$  String (4+4 bytes)
;
	SEGMENT .data		; Necessary for Position Independent Code
;
; Array of function entry points:
;
	times 3	db 0		; Padding
fnarr:	db	1		; Number of dimensions
	dd	(fnarrt-fnarr0)/8 ; Number of entries
	checkalign
fnarr0:	dq	loadn		; Load numeric 
	dq	loads		; Load string
	dq	storen		; Store numeric
	dq	stores		; Store string
	dq	getvar		; Get variable address
	dq	putvar		; Create variable
	dq	expr		; Evaluate expression
	dq	item		; Evaluate item
	dq	lexan		; Lexical analysis (tokenise)
	dq	token		; Print character or keyword
	dq	xfloat		; Convert integer to float
	dq	xfix		; Convert float to integer
	dq	str00		; Convert a number to a string
	dq	con		; Convert a string to a number
	dq	sortup		; (Reserved in BBCSDL)
	dq	sortdn		; (Reserved in BBCSDL)
	dq	0		; Reserved for hook
	dq	xeq		; Return to BASIC
	dq	putevt		; Store event in queue
	dq	gfxPrimitivesGetFont
	dq	gfxPrimitivesSetFont
	dq	RedefineChar
fnarrt:
;
