/*****************************************************************\
*       BBC BASIC Console Mode edition for Raspberry Pi Pico      *
*       (C) 2022  R.T.Russell  http://www.rtrussell.co.uk/        *
*                                                                 *
*       The name 'BBC BASIC' is the property of the British       *
*       Broadcasting Corporation and used with their permission   *
*                                                                 *
*       sound_sdl.c  BBCSDL-like sound (runs in second core)      *
*       Version 0.13, 09-Feb-2022                                 *
*                                                                 *
*       Supports stereo PCM audio with a 16 kHz sampling rate and *
*       ~13-bit samples (10-bit linear plus 8-fold over-sampling) *
\*****************************************************************/

#define _GNU_SOURCE
#define __USE_GNU
#include <stdio.h>
#include "bbccon.h"
#include "pico.h"
#include "pico/stdlib.h"
#include "pico/multicore.h"
#include "hardware/irq.h"  // interrupts
#include "hardware/pwm.h"  // pwm 
#include "hardware/sync.h" // wait for interrupt

void trap(void) ;
 
#ifdef PICO_AUDIO_PWM_L_PIN
#define AUDIO_PIN_L    PICO_AUDIO_PWM_L_PIN
#else
#define AUDIO_PIN_L    28
#endif
#ifdef PICO_AUDIO_PWM_R_PIN
#define AUDIO_PIN_R    PICO_AUDIO_PWM_R_PIN
#else
#define AUDIO_PIN_R    27
#endif
#define AUDIO_CHUNK 160 // number of samples for 10 milliseconds at 16 kHz
#define AUDIO_TOTAL AUDIO_CHUNK * 3 // total buffer size = 3 chunks

static const unsigned short noises[8] = {
	0x8050,
	0x8300,
	0x8180,
	0x8300,
	0x8018,
	0x8018,
	0x8018,
	0x8018} ;

// Table of SOUND pitches for 32 kHz sampling frequency):
static const unsigned short freqs[256] = {
	0,	// 0 = silence
	1026,	// 1 = 62.63 Hz
	1041,	// 2 = 63.54 Hz
	1056,	// 3 = 64.47 Hz
	1072,	// 4 = 65.41 Hz
	1087,	// 5 = 66.36 Hz
	1103,	// 6 = 67.32 Hz
	1119,	// 7 = 68.30 Hz
	1135,	// 8 = 69.30 Hz
	1152,	// 9 = 70.30 Hz
	1169,	// 10 = 71.33 Hz
	1186,	// 11 = 72.36 Hz
	1203,	// 12 = 73.42 Hz
	1220,	// 13 = 74.48 Hz
	1238,	// 14 = 75.57 Hz
	1256,	// 15 = 76.67 Hz
	1274,	// 16 = 77.78 Hz
	1293,	// 17 = 78.91 Hz
	1312,	// 18 = 80.06 Hz
	1331,	// 19 = 81.23 Hz
	1350,	// 20 = 82.41 Hz
	1370,	// 21 = 83.61 Hz
	1390,	// 22 = 84.82 Hz
	1410,	// 23 = 86.06 Hz
	1430,	// 24 = 87.31 Hz
	1451,	// 25 = 88.58 Hz
	1472,	// 26 = 89.87 Hz
	1494,	// 27 = 91.17 Hz
	1515,	// 28 = 92.50 Hz
	1538,	// 29 = 93.84 Hz
	1560,	// 30 = 95.21 Hz
	1583,	// 31 = 96.59 Hz
	1606,	// 32 = 98.00 Hz
	1629,	// 33 = 99.42 Hz
	1653,	// 34 = 100.87 Hz
	1677,	// 35 = 102.34 Hz
	1701,	// 36 = 103.83 Hz
	1726,	// 37 = 105.34 Hz
	1751,	// 38 = 106.87 Hz
	1776,	// 39 = 108.42 Hz
	1802,	// 40 = 110.00 Hz
	1828,	// 41 = 111.60 Hz
	1855,	// 42 = 113.22 Hz
	1882,	// 43 = 114.87 Hz
	1909,	// 44 = 116.54 Hz
	1937,	// 45 = 118.24 Hz
	1965,	// 46 = 119.96 Hz
	1994,	// 47 = 121.70 Hz
	2023,	// 48 = 123.47 Hz
	2052,	// 49 = 125.27 Hz
	2082,	// 50 = 127.09 Hz
	2113,	// 51 = 128.94 Hz
	2143,	// 52 = 130.81 Hz
	2174,	// 53 = 132.72 Hz
	2206,	// 54 = 134.65 Hz
	2238,	// 55 = 136.60 Hz
	2271,	// 56 = 138.59 Hz
	2304,	// 57 = 140.61 Hz
	2337,	// 58 = 142.65 Hz
	2371,	// 59 = 144.73 Hz
	2406,	// 60 = 146.83 Hz
	2441,	// 61 = 148.97 Hz
	2476,	// 62 = 151.13 Hz
	2512,	// 63 = 153.33 Hz
	2549,	// 64 = 155.56 Hz
	2586,	// 65 = 157.83 Hz
	2623,	// 66 = 160.12 Hz
	2662,	// 67 = 162.45 Hz
	2700,	// 68 = 164.81 Hz
	2740,	// 69 = 167.21 Hz
	2779,	// 70 = 169.64 Hz
	2820,	// 71 = 172.11 Hz
	2861,	// 72 = 174.61 Hz
	2902,	// 73 = 177.15 Hz
	2945,	// 74 = 179.73 Hz
	2988,	// 75 = 182.34 Hz
	3031,	// 76 = 185.00 Hz
	3075,	// 77 = 187.69 Hz
	3120,	// 78 = 190.42 Hz
	3165,	// 79 = 193.19 Hz
	3211,	// 80 = 196.00 Hz
	3258,	// 81 = 198.85 Hz
	3305,	// 82 = 201.74 Hz
	3353,	// 83 = 204.68 Hz
	3402,	// 84 = 207.65 Hz
	3452,	// 85 = 210.67 Hz
	3502,	// 86 = 213.74 Hz
	3553,	// 87 = 216.85 Hz
	3604,	// 88 = 220.00 Hz
	3657,	// 89 = 223.20 Hz
	3710,	// 90 = 226.45 Hz
	3764,	// 91 = 229.74 Hz
	3819,	// 92 = 233.08 Hz
	3874,	// 93 = 236.47 Hz
	3931,	// 94 = 239.91 Hz
	3988,	// 95 = 243.40 Hz
	4046,	// 96 = 246.94 Hz
	4105,	// 97 = 250.53 Hz
	4164,	// 98 = 254.18 Hz
	4225,	// 99 = 257.87 Hz
	4286,	// 100 = 261.63 Hz
	4349,	// 101 = 265.43 Hz
	4412,	// 102 = 269.29 Hz
	4476,	// 103 = 273.21 Hz
	4541,	// 104 = 277.18 Hz
	4607,	// 105 = 281.21 Hz
	4674,	// 106 = 285.30 Hz
	4742,	// 107 = 289.45 Hz
	4811,	// 108 = 293.66 Hz
	4881,	// 109 = 297.94 Hz
	4952,	// 110 = 302.27 Hz
	5024,	// 111 = 306.67 Hz
	5098,	// 112 = 311.13 Hz
	5172,	// 113 = 315.65 Hz
	5247,	// 114 = 320.24 Hz
	5323,	// 115 = 324.90 Hz
	5401,	// 116 = 329.63 Hz
	5479,	// 117 = 334.42 Hz
	5559,	// 118 = 339.29 Hz
	5640,	// 119 = 344.22 Hz
	5722,	// 120 = 349.23 Hz
	5805,	// 121 = 354.31 Hz
	5889,	// 122 = 359.46 Hz
	5975,	// 123 = 364.69 Hz
	6062,	// 124 = 369.99 Hz
	6150,	// 125 = 375.38 Hz
	6240,	// 126 = 380.84 Hz
	6330,	// 127 = 386.38 Hz
	6422,	// 128 = 392.00 Hz
	6516,	// 129 = 397.70 Hz
	6611,	// 130 = 403.48 Hz
	6707,	// 131 = 409.35 Hz
	6804,	// 132 = 415.30 Hz
	6903,	// 133 = 421.35 Hz
	7004,	// 134 = 427.47 Hz
	7106,	// 135 = 433.69 Hz
	7209,	// 136 = 440.00 Hz
	7314,	// 137 = 446.40 Hz
	7420,	// 138 = 452.89 Hz
	7528,	// 139 = 459.48 Hz
	7638,	// 140 = 466.16 Hz
	7749,	// 141 = 472.94 Hz
	7861,	// 142 = 479.82 Hz
	7976,	// 143 = 486.80 Hz
	8092,	// 144 = 493.88 Hz
	8209,	// 145 = 501.07 Hz
	8329,	// 146 = 508.36 Hz
	8450,	// 147 = 515.75 Hz
	8573,	// 148 = 523.25 Hz
	8698,	// 149 = 530.86 Hz
	8824,	// 150 = 538.58 Hz
	8953,	// 151 = 546.42 Hz
	9083,	// 152 = 554.37 Hz
	9215,	// 153 = 562.43 Hz
	9349,	// 154 = 570.61 Hz
	9485,	// 155 = 578.91 Hz
	9623,	// 156 = 587.33 Hz
	9763,	// 157 = 595.87 Hz
	9905,	// 158 = 604.54 Hz
	10049,	// 159 = 613.33 Hz
	10195,	// 160 = 622.25 Hz
	10343,	// 161 = 631.30 Hz
	10494,	// 162 = 640.49 Hz
	10646,	// 163 = 649.80 Hz
	10801,	// 164 = 659.26 Hz
	10958,	// 165 = 668.84 Hz
	11118,	// 166 = 678.57 Hz
	11279,	// 167 = 688.44 Hz
	11444,	// 168 = 698.46 Hz
	11610,	// 169 = 708.62 Hz
	11779,	// 170 = 718.92 Hz
	11950,	// 171 = 729.38 Hz
	12124,	// 172 = 739.99 Hz
	12300,	// 173 = 750.75 Hz
	12479,	// 174 = 761.67 Hz
	12661,	// 175 = 772.75 Hz
	12845,	// 176 = 783.99 Hz
	13032,	// 177 = 795.39 Hz
	13221,	// 178 = 806.96 Hz
	13414,	// 179 = 818.70 Hz
	13609,	// 180 = 830.61 Hz
	13807,	// 181 = 842.69 Hz
	14007,	// 182 = 854.95 Hz
	14211,	// 183 = 867.38 Hz
	14418,	// 184 = 880.00 Hz
	14628,	// 185 = 892.80 Hz
	14840,	// 186 = 905.79 Hz
	15056,	// 187 = 918.96 Hz
	15275,	// 188 = 932.33 Hz
	15497,	// 189 = 945.89 Hz
	15723,	// 190 = 959.65 Hz
	15952,	// 191 = 973.61 Hz
	16184,	// 192 = 987.77 Hz
	16419,	// 193 = 1002.13 Hz
	16658,	// 194 = 1016.71 Hz
	16900,	// 195 = 1031.50 Hz
	17146,	// 196 = 1046.50 Hz
	17395,	// 197 = 1061.72 Hz
	17648,	// 198 = 1077.17 Hz
	17905,	// 199 = 1092.83 Hz
	18165,	// 200 = 1108.73 Hz
	18430,	// 201 = 1124.86 Hz
	18698,	// 202 = 1141.22 Hz
	18970,	// 203 = 1157.82 Hz
	19246,	// 204 = 1174.66 Hz
	19526,	// 205 = 1191.74 Hz
	19810,	// 206 = 1209.08 Hz
	20098,	// 207 = 1226.67 Hz
	20390,	// 208 = 1244.51 Hz
	20687,	// 209 = 1262.61 Hz
	20987,	// 210 = 1280.97 Hz
	21293,	// 211 = 1299.61 Hz
	21602,	// 212 = 1318.51 Hz
	21917,	// 213 = 1337.69 Hz
	22235,	// 214 = 1357.15 Hz
	22559,	// 215 = 1376.89 Hz
	22887,	// 216 = 1396.91 Hz
	23220,	// 217 = 1417.23 Hz
	23558,	// 218 = 1437.85 Hz
	23900,	// 219 = 1458.76 Hz
	24248,	// 220 = 1479.98 Hz
	24601,	// 221 = 1501.50 Hz
	24958,	// 222 = 1523.34 Hz
	25322,	// 223 = 1545.50 Hz
	25690,	// 224 = 1567.98 Hz
	26063,	// 225 = 1590.79 Hz
	26443,	// 226 = 1613.93 Hz
	26827,	// 227 = 1637.40 Hz
	27217,	// 228 = 1661.22 Hz
	27613,	// 229 = 1685.38 Hz
	28015,	// 230 = 1709.90 Hz
	28422,	// 231 = 1734.77 Hz
	28836,	// 232 = 1760.00 Hz
	29255,	// 233 = 1785.60 Hz
	29681,	// 234 = 1811.57 Hz
	30113,	// 235 = 1837.92 Hz
	30551,	// 236 = 1864.66 Hz
	30995,	// 237 = 1891.78 Hz
	31446,	// 238 = 1919.29 Hz
	31903,	// 239 = 1947.21 Hz
	32367,	// 240 = 1975.53 Hz
	32838,	// 241 = 2004.27 Hz
	33316,	// 242 = 2033.42 Hz
	33800,	// 243 = 2063.00 Hz
	34292,	// 244 = 2093.00 Hz
	34791,	// 245 = 2123.45 Hz
	35297,	// 246 = 2154.33 Hz
	35810,	// 247 = 2185.67 Hz
	36331,	// 248 = 2217.46 Hz
	36859,	// 249 = 2249.71 Hz
	37395,	// 250 = 2282.44 Hz
	37939,	// 251 = 2315.64 Hz
	38491,	// 252 = 2349.32 Hz
	39051,	// 253 = 2383.49 Hz
	39619,	// 254 = 2418.16 Hz
	40195	// 255 = 2453.33 Hz
} ;

// Logarithmic amplitude table:
static const short ampl[128] = {
	0x0000, 0x0368, 0x0381, 0x039B, 0x03B6, 0x03D2, 0x03EF, 0x040C,
	0x042A, 0x044A, 0x046A, 0x048B, 0x04AD, 0x04D0, 0x04F3, 0x0518,
	0x053F, 0x0566, 0x058E, 0x05B8, 0x05E2, 0x060E, 0x063C, 0x066A,
	0x069A, 0x06CC, 0x06FE, 0x0733, 0x0768, 0x07A0, 0x07D9, 0x0813,
	0x0850, 0x088E, 0x08CE, 0x0910, 0x0953, 0x0999, 0x09E1, 0x0A2B,
	0x0A77, 0x0AC5, 0x0B16, 0x0B68, 0x0BBE, 0x0C15, 0x0C70, 0x0CCD,
	0x0D2C, 0x0D8F, 0x0DF4, 0x0E5D, 0x0EC8, 0x0F36, 0x0FA8, 0x101D,
	0x1096, 0x1112, 0x1191, 0x1214, 0x129C, 0x1327, 0x13B6, 0x1449,
	0x14E1, 0x157D, 0x161E, 0x16C3, 0x176D, 0x181C, 0x18D0, 0x198A,
	0x1A49, 0x1B0D, 0x1BD7, 0x1CA8, 0x1D7E, 0x1E5A, 0x1F3D, 0x2027,
	0x2117, 0x220E, 0x230D, 0x2413, 0x2521, 0x2636, 0x2754, 0x287A,
	0x29A8, 0x2AE0, 0x2C20, 0x2D6A, 0x2EBE, 0x301B, 0x3183, 0x32F5,
	0x3472, 0x35FA, 0x378D, 0x392C, 0x3AD8, 0x3C90, 0x3E54, 0x4026,
	0x4206, 0x43F3, 0x45EF, 0x47FA, 0x4A14, 0x4C3E, 0x4E78, 0x50C3,
	0x531E, 0x558C, 0x580B, 0x5A9D, 0x5D43, 0x5FFC, 0x62C9, 0x65AC,
	0x68A4, 0x6BB2, 0x6ED7, 0x7214, 0x7568, 0x78D6, 0x7C5D, 0x7FFF} ;

// Table of mask bytes for channel synchronisation:
static const unsigned char syncs[256] = {
	0b11111111,	// 00000000B
	0b11111111,	// 00000001B
	0b11111111,	// 00000010B
	0b11111111,	// 00000011B
	0b11111111,	// 00000100B
	0b11111010,	// 00000101B
	0b11111111,	// 00000110B
	0b11111111,	// 00000111B
	0b11111111,	// 00001000B
	0b11111111,	// 00001001B
	0b11111111,	// 00001010B
	0b11111111,	// 00001011B
	0b11111111,	// 00001100B
	0b11111111,	// 00001101B
	0b11111111,	// 00001110B
	0b11111111,	// 00001111B
	0b11111111,	// 00010000B
	0b11101110,	// 00010001B
	0b11111111,	// 00010010B
	0b11111111,	// 00010011B
	0b11101011,	// 00010100B
	0b11101010,	// 00010101B
	0b11101011,	// 00010110B
	0b11101011,	// 00010111B
	0b11111111,	// 00011000B
	0b11101110,	// 00011001B
	0b11111111,	// 00011010B
	0b11111111,	// 00011011B
	0b11111111,	// 00011100B
	0b11101110,	// 00011101B
	0b11111111,	// 00011110B
	0b11111111,	// 00011111B
	0b11111111,	// 00100000B
	0b11111111,	// 00100001B
	0b11111111,	// 00100010B
	0b11111111,	// 00100011B
	0b11111111,	// 00100100B
	0b11111010,	// 00100101B
	0b11111111,	// 00100110B
	0b11111111,	// 00100111B
	0b11111111,	// 00101000B
	0b11111111,	// 00101001B
	0b11101010,	// 00101010B
	0b11111111,	// 00101011B
	0b11111111,	// 00101100B
	0b11111111,	// 00101101B
	0b11111111,	// 00101110B
	0b11111111,	// 00101111B
	0b11111111,	// 00110000B
	0b11111111,	// 00110001B
	0b11111111,	// 00110010B
	0b11111111,	// 00110011B
	0b11111111,	// 00110100B
	0b11111010,	// 00110101B
	0b11111111,	// 00110110B
	0b11111111,	// 00110111B
	0b11111111,	// 00111000B
	0b11111111,	// 00111001B
	0b11111111,	// 00111010B
	0b11111111,	// 00111011B
	0b11111111,	// 00111100B
	0b11111111,	// 00111101B
	0b11111111,	// 00111110B
	0b11111111,	// 00111111B
	0b11111111,	// 01000000B
	0b10111110,	// 01000001B
	0b11111111,	// 01000010B
	0b11111111,	// 01000011B
	0b10111011,	// 01000100B
	0b10111010,	// 01000101B
	0b10111011,	// 01000110B
	0b10111011,	// 01000111B
	0b11111111,	// 01001000B
	0b10111110,	// 01001001B
	0b11111111,	// 01001010B
	0b11111111,	// 01001011B
	0b11111111,	// 01001100B
	0b10111110,	// 01001101B
	0b11111111,	// 01001110B
	0b11111111,	// 01001111B
	0b10101111,	// 01010000B
	0b10101110,	// 01010001B
	0b10101111,	// 01010010B
	0b10101111,	// 01010011B
	0b10101011,	// 01010100B
	0b10101010,	// 01010101B
	0b10101011,	// 01010110B
	0b10101011,	// 01010111B
	0b10101111,	// 01011000B
	0b10101110,	// 01011001B
	0b10101111,	// 01011010B
	0b10101111,	// 01011011B
	0b10101111,	// 01011100B
	0b10101110,	// 01011101B
	0b10101111,	// 01011110B
	0b10101111,	// 01011111B
	0b11111111,	// 01100000B
	0b10111110,	// 01100001B
	0b11111111,	// 01100010B
	0b11111111,	// 01100011B
	0b10111011,	// 01100100B
	0b10111010,	// 01100101B
	0b10111011,	// 01100110B
	0b10111011,	// 01100111B
	0b11111111,	// 01101000B
	0b10111110,	// 01101001B
	0b11101010,	// 01101010B
	0b11111111,	// 01101011B
	0b11111111,	// 01101100B
	0b10111110,	// 01101101B
	0b11111111,	// 01101110B
	0b11111111,	// 01101111B
	0b11111111,	// 01110000B
	0b10111110,	// 01110001B
	0b11111111,	// 01110010B
	0b11111111,	// 01110011B
	0b10111011,	// 01110100B
	0b10111010,	// 01110101B
	0b10111011,	// 01110110B
	0b10111011,	// 01110111B
	0b11111111,	// 01111000B
	0b10111110,	// 01111001B
	0b11111111,	// 01111010B
	0b11111111,	// 01111011B
	0b11111111,	// 01111100B
	0b10111110,	// 01111101B
	0b11111111,	// 01111110B
	0b11111111,	// 01111111B
	0b11111111,	// 10000000B
	0b11111111,	// 10000001B
	0b11111111,	// 10000010B
	0b11111111,	// 10000011B
	0b11111111,	// 10000100B
	0b11111010,	// 10000101B
	0b11111111,	// 10000110B
	0b11111111,	// 10000111B
	0b11111111,	// 10001000B
	0b11111111,	// 10001001B
	0b10111010,	// 10001010B
	0b11111111,	// 10001011B
	0b11111111,	// 10001100B
	0b11111111,	// 10001101B
	0b11111111,	// 10001110B
	0b11111111,	// 10001111B
	0b11111111,	// 10010000B
	0b11101110,	// 10010001B
	0b11111111,	// 10010010B
	0b11111111,	// 10010011B
	0b11101011,	// 10010100B
	0b11101010,	// 10010101B
	0b11101011,	// 10010110B
	0b11101011,	// 10010111B
	0b11111111,	// 10011000B
	0b11101110,	// 10011001B
	0b10111010,	// 10011010B
	0b11111111,	// 10011011B
	0b11111111,	// 10011100B
	0b11101110,	// 10011101B
	0b11111111,	// 10011110B
	0b11111111,	// 10011111B
	0b11111111,	// 10100000B
	0b11111111,	// 10100001B
	0b10101110,	// 10100010B
	0b11111111,	// 10100011B
	0b11111111,	// 10100100B
	0b11111010,	// 10100101B
	0b10101110,	// 10100110B
	0b11111111,	// 10100111B
	0b10101011,	// 10101000B
	0b10101011,	// 10101001B
	0b10101010,	// 10101010B
	0b10101011,	// 10101011B
	0b11111111,	// 10101100B
	0b11111111,	// 10101101B
	0b10101110,	// 10101110B
	0b11111111,	// 10101111B
	0b11111111,	// 10110000B
	0b11111111,	// 10110001B
	0b11111111,	// 10110010B
	0b11111111,	// 10110011B
	0b11111111,	// 10110100B
	0b11111010,	// 10110101B
	0b11111111,	// 10110110B
	0b11111111,	// 10110111B
	0b11111111,	// 10111000B
	0b11111111,	// 10111001B
	0b10111010,	// 10111010B
	0b11111111,	// 10111011B
	0b11111111,	// 10111100B
	0b11111111,	// 10111101B
	0b11111111,	// 10111110B
	0b11111111,	// 10111111B
	0b11111111,	// 11000000B
	0b11111111,	// 11000001B
	0b11111111,	// 11000010B
	0b11111111,	// 11000011B
	0b11111111,	// 11000100B
	0b11111010,	// 11000101B
	0b11111111,	// 11000110B
	0b11111111,	// 11000111B
	0b11111111,	// 11001000B
	0b11111111,	// 11001001B
	0b11111111,	// 11001010B
	0b11111111,	// 11001011B
	0b11111111,	// 11001100B
	0b11111111,	// 11001101B
	0b11111111,	// 11001110B
	0b11111111,	// 11001111B
	0b11111111,	// 11010000B
	0b11101110,	// 11010001B
	0b11111111,	// 11010010B
	0b11111111,	// 11010011B
	0b11101011,	// 11010100B
	0b11101010,	// 11010101B
	0b11101011,	// 11010110B
	0b11101011,	// 11010111B
	0b11111111,	// 11011000B
	0b11101110,	// 11011001B
	0b11111111,	// 11011010B
	0b11111111,	// 11011011B
	0b11111111,	// 11011100B
	0b11101110,	// 11011101B
	0b11111111,	// 11011110B
	0b11111111,	// 11011111B
	0b11111111,	// 11100000B
	0b11111111,	// 11100001B
	0b11111111,	// 11100010B
	0b11111111,	// 11100011B
	0b11111111,	// 11100100B
	0b11111010,	// 11100101B
	0b11111111,	// 11100110B
	0b11111111,	// 11100111B
	0b11111111,	// 11101000B
	0b11111111,	// 11101001B
	0b11101010,	// 11101010B
	0b11111111,	// 11101011B
	0b11111111,	// 11101100B
	0b11111111,	// 11101101B
	0b11111111,	// 11101110B
	0b11111111,	// 11101111B
	0b11111111,	// 11110000B
	0b11111111,	// 11110001B
	0b11111111,	// 11110010B
	0b11111111,	// 11110011B
	0b11111111,	// 11110100B
	0b11111010,	// 11110101B
	0b11111111,	// 11110110B
	0b11111111,	// 11110111B
	0b11111111,	// 11111000B
	0b11111111,	// 11111001B
	0b11111111,	// 11111010B
	0b11111111,	// 11111011B
	0b11111111,	// 11111100B
	0b11111111,	// 11111101B
	0b11111111,	// 11111110B
	0b10101010	// 11111111B
} ;

// Sound waveform table (8 voices):
static const short wavetable[8 * 2048] = {
// Waveform 0 (square):
        0x0000, 0x00FB, 0x01F6, 0x02F1, 0x03EC, 0x04E6, 0x05E1, 0x06DA, 
        0x07D3, 0x08CC, 0x09C4, 0x0ABB, 0x0BB1, 0x0CA6, 0x0D9A, 0x0E8E, 
        0x0F80, 0x1071, 0x1160, 0x124E, 0x133B, 0x1426, 0x1510, 0x15F8, 
        0x16DE, 0x17C3, 0x18A5, 0x1986, 0x1A65, 0x1B42, 0x1C1C, 0x1CF5, 
        0x1DCB, 0x1E9F, 0x1F71, 0x2040, 0x210D, 0x21D8, 0x22A0, 0x2365, 
        0x2428, 0x24E7, 0x25A5, 0x265F, 0x2717, 0x27CC, 0x287D, 0x292C, 
        0x29D8, 0x2A81, 0x2B27, 0x2BCA, 0x2C6A, 0x2D06, 0x2DA0, 0x2E36, 
        0x2EC9, 0x2F59, 0x2FE5, 0x306F, 0x30F5, 0x3177, 0x31F7, 0x3273, 
        0x32EB, 0x3361, 0x33D3, 0x3441, 0x34AC, 0x3514, 0x3579, 0x35DA, 
        0x3638, 0x3692, 0x36E9, 0x373D, 0x378E, 0x37DB, 0x3825, 0x386B, 
        0x38AE, 0x38EE, 0x392B, 0x3965, 0x399B, 0x39CE, 0x39FE, 0x3A2B, 
        0x3A55, 0x3A7C, 0x3A9F, 0x3AC0, 0x3ADE, 0x3AF9, 0x3B11, 0x3B26, 
        0x3B38, 0x3B48, 0x3B54, 0x3B5E, 0x3B66, 0x3B6B, 0x3B6D, 0x3B6D, 
        0x3B6A, 0x3B65, 0x3B5D, 0x3B54, 0x3B48, 0x3B39, 0x3B29, 0x3B16, 
        0x3B01, 0x3AEB, 0x3AD2, 0x3AB8, 0x3A9B, 0x3A7D, 0x3A5D, 0x3A3C, 
        0x3A19, 0x39F4, 0x39CE, 0x39A6, 0x397D, 0x3953, 0x3928, 0x38FB, 
        0x38CD, 0x389E, 0x386E, 0x383D, 0x380B, 0x37D9, 0x37A5, 0x3771, 
        0x373C, 0x3706, 0x36D0, 0x369A, 0x3663, 0x362C, 0x35F4, 0x35BC, 
        0x3584, 0x354B, 0x3513, 0x34DB, 0x34A2, 0x346A, 0x3431, 0x33F9, 
        0x33C1, 0x338A, 0x3352, 0x331B, 0x32E4, 0x32AE, 0x3279, 0x3243, 
        0x320F, 0x31DB, 0x31A8, 0x3175, 0x3143, 0x3112, 0x30E2, 0x30B2, 
        0x3084, 0x3056, 0x3029, 0x2FFE, 0x2FD3, 0x2FA9, 0x2F81, 0x2F59, 
        0x2F33, 0x2F0E, 0x2EEA, 0x2EC7, 0x2EA5, 0x2E85, 0x2E66, 0x2E48, 
        0x2E2B, 0x2E10, 0x2DF6, 0x2DDD, 0x2DC6, 0x2DB0, 0x2D9B, 0x2D87, 
        0x2D76, 0x2D65, 0x2D56, 0x2D48, 0x2D3B, 0x2D30, 0x2D26, 0x2D1E, 
        0x2D17, 0x2D11, 0x2D0D, 0x2D0A, 0x2D08, 0x2D07, 0x2D08, 0x2D0B, 
        0x2D0E, 0x2D13, 0x2D19, 0x2D20, 0x2D29, 0x2D32, 0x2D3D, 0x2D49, 
        0x2D56, 0x2D65, 0x2D74, 0x2D85, 0x2D96, 0x2DA9, 0x2DBC, 0x2DD1, 
        0x2DE7, 0x2DFD, 0x2E14, 0x2E2D, 0x2E46, 0x2E60, 0x2E7A, 0x2E96, 
        0x2EB2, 0x2ECF, 0x2EEC, 0x2F0A, 0x2F29, 0x2F48, 0x2F68, 0x2F89, 
        0x2FA9, 0x2FCB, 0x2FEC, 0x300E, 0x3030, 0x3053, 0x3076, 0x3099, 
        0x30BC, 0x30E0, 0x3103, 0x3127, 0x314B, 0x316E, 0x3192, 0x31B6, 
        0x31D9, 0x31FD, 0x3220, 0x3243, 0x3266, 0x3289, 0x32AB, 0x32CE, 
        0x32EF, 0x3311, 0x3332, 0x3353, 0x3373, 0x3393, 0x33B2, 0x33D1, 
        0x33EF, 0x340C, 0x342A, 0x3446, 0x3462, 0x347D, 0x3497, 0x34B1, 
        0x34CA, 0x34E2, 0x34F9, 0x3510, 0x3526, 0x353B, 0x354F, 0x3563, 
        0x3575, 0x3587, 0x3597, 0x35A7, 0x35B6, 0x35C4, 0x35D1, 0x35DD, 
        0x35E9, 0x35F3, 0x35FC, 0x3605, 0x360C, 0x3612, 0x3618, 0x361C, 
        0x3620, 0x3623, 0x3624, 0x3625, 0x3625, 0x3623, 0x3621, 0x361E, 
        0x361A, 0x3615, 0x360F, 0x3608, 0x3601, 0x35F8, 0x35EF, 0x35E4, 
        0x35D9, 0x35CD, 0x35C0, 0x35B3, 0x35A4, 0x3595, 0x3585, 0x3575, 
        0x3563, 0x3551, 0x353F, 0x352B, 0x3517, 0x3502, 0x34ED, 0x34D7, 
        0x34C1, 0x34AA, 0x3493, 0x347B, 0x3462, 0x344A, 0x3430, 0x3417, 
        0x33FD, 0x33E3, 0x33C8, 0x33AD, 0x3392, 0x3377, 0x335B, 0x333F, 
        0x3324, 0x3308, 0x32EB, 0x32CF, 0x32B3, 0x3297, 0x327B, 0x325E, 
        0x3242, 0x3226, 0x320A, 0x31EE, 0x31D3, 0x31B7, 0x319C, 0x3181, 
        0x3166, 0x314C, 0x3132, 0x3118, 0x30FE, 0x30E5, 0x30CD, 0x30B4, 
        0x309D, 0x3085, 0x306E, 0x3058, 0x3042, 0x302D, 0x3018, 0x3004, 
        0x2FF1, 0x2FDE, 0x2FCB, 0x2FBA, 0x2FA9, 0x2F98, 0x2F89, 0x2F7A, 
        0x2F6C, 0x2F5E, 0x2F51, 0x2F45, 0x2F3A, 0x2F30, 0x2F26, 0x2F1D, 
        0x2F15, 0x2F0E, 0x2F07, 0x2F01, 0x2EFC, 0x2EF8, 0x2EF5, 0x2EF2, 
        0x2EF1, 0x2EF0, 0x2EF0, 0x2EF0, 0x2EF2, 0x2EF4, 0x2EF7, 0x2EFB, 
        0x2F00, 0x2F06, 0x2F0C, 0x2F13, 0x2F1B, 0x2F23, 0x2F2D, 0x2F37, 
        0x2F41, 0x2F4D, 0x2F59, 0x2F66, 0x2F74, 0x2F82, 0x2F91, 0x2FA0, 
        0x2FB0, 0x2FC1, 0x2FD2, 0x2FE4, 0x2FF7, 0x300A, 0x301D, 0x3031, 
        0x3046, 0x305B, 0x3070, 0x3086, 0x309C, 0x30B2, 0x30C9, 0x30E1, 
        0x30F8, 0x3110, 0x3128, 0x3140, 0x3159, 0x3172, 0x318A, 0x31A3, 
        0x31BD, 0x31D6, 0x31EF, 0x3209, 0x3222, 0x323C, 0x3255, 0x326E, 
        0x3288, 0x32A1, 0x32BA, 0x32D3, 0x32EC, 0x3305, 0x331D, 0x3335, 
        0x334D, 0x3365, 0x337C, 0x3393, 0x33AA, 0x33C1, 0x33D7, 0x33EC, 
        0x3401, 0x3416, 0x342B, 0x343E, 0x3452, 0x3465, 0x3477, 0x3489, 
        0x349A, 0x34AB, 0x34BB, 0x34CA, 0x34D9, 0x34E7, 0x34F5, 0x3501, 
        0x350E, 0x3519, 0x3524, 0x352E, 0x3538, 0x3540, 0x3548, 0x354F, 
        0x3556, 0x355C, 0x3561, 0x3565, 0x3568, 0x356B, 0x356D, 0x356E, 
        0x356E, 0x356E, 0x356D, 0x356B, 0x3568, 0x3565, 0x3561, 0x355C, 
        0x3556, 0x354F, 0x3548, 0x3540, 0x3538, 0x352E, 0x3524, 0x3519, 
        0x350E, 0x3501, 0x34F5, 0x34E7, 0x34D9, 0x34CA, 0x34BB, 0x34AB, 
        0x349A, 0x3489, 0x3477, 0x3465, 0x3452, 0x343E, 0x342B, 0x3416, 
        0x3401, 0x33EC, 0x33D7, 0x33C1, 0x33AA, 0x3393, 0x337C, 0x3365, 
        0x334D, 0x3335, 0x331D, 0x3305, 0x32EC, 0x32D3, 0x32BA, 0x32A1, 
        0x3288, 0x326E, 0x3255, 0x323C, 0x3222, 0x3209, 0x31EF, 0x31D6, 
        0x31BD, 0x31A4, 0x318A, 0x3172, 0x3159, 0x3140, 0x3128, 0x3110, 
        0x30F8, 0x30E1, 0x30C9, 0x30B2, 0x309C, 0x3086, 0x3070, 0x305B, 
        0x3046, 0x3031, 0x301D, 0x300A, 0x2FF7, 0x2FE4, 0x2FD3, 0x2FC1, 
        0x2FB0, 0x2FA0, 0x2F91, 0x2F82, 0x2F74, 0x2F66, 0x2F59, 0x2F4D, 
        0x2F42, 0x2F37, 0x2F2D, 0x2F23, 0x2F1B, 0x2F13, 0x2F0C, 0x2F06, 
        0x2F00, 0x2EFB, 0x2EF7, 0x2EF4, 0x2EF2, 0x2EF0, 0x2EF0, 0x2EF0, 
        0x2EF1, 0x2EF2, 0x2EF5, 0x2EF8, 0x2EFC, 0x2F01, 0x2F07, 0x2F0E, 
        0x2F15, 0x2F1D, 0x2F26, 0x2F30, 0x2F3A, 0x2F45, 0x2F51, 0x2F5E, 
        0x2F6C, 0x2F7A, 0x2F89, 0x2F98, 0x2FA9, 0x2FBA, 0x2FCB, 0x2FDE, 
        0x2FF1, 0x3004, 0x3018, 0x302D, 0x3042, 0x3058, 0x306E, 0x3085, 
        0x309D, 0x30B4, 0x30CD, 0x30E5, 0x30FE, 0x3118, 0x3132, 0x314C, 
        0x3166, 0x3181, 0x319C, 0x31B7, 0x31D3, 0x31EE, 0x320A, 0x3226, 
        0x3242, 0x325E, 0x327B, 0x3297, 0x32B3, 0x32CF, 0x32EB, 0x3308, 
        0x3324, 0x333F, 0x335B, 0x3377, 0x3392, 0x33AD, 0x33C8, 0x33E3, 
        0x33FD, 0x3417, 0x3430, 0x344A, 0x3462, 0x347B, 0x3493, 0x34AA, 
        0x34C1, 0x34D7, 0x34ED, 0x3502, 0x3517, 0x352B, 0x353F, 0x3551, 
        0x3563, 0x3575, 0x3585, 0x3595, 0x35A4, 0x35B3, 0x35C0, 0x35CD, 
        0x35D9, 0x35E4, 0x35EF, 0x35F8, 0x3601, 0x3608, 0x360F, 0x3615, 
        0x361A, 0x361E, 0x3621, 0x3623, 0x3625, 0x3625, 0x3624, 0x3623, 
        0x3620, 0x361C, 0x3618, 0x3612, 0x360C, 0x3605, 0x35FC, 0x35F3, 
        0x35E9, 0x35DE, 0x35D1, 0x35C4, 0x35B6, 0x35A7, 0x3597, 0x3587, 
        0x3575, 0x3563, 0x354F, 0x353B, 0x3526, 0x3510, 0x34F9, 0x34E2, 
        0x34CA, 0x34B1, 0x3497, 0x347D, 0x3462, 0x3446, 0x342A, 0x340C, 
        0x33EF, 0x33D1, 0x33B2, 0x3393, 0x3373, 0x3353, 0x3332, 0x3311, 
        0x32EF, 0x32CE, 0x32AB, 0x3289, 0x3266, 0x3243, 0x3220, 0x31FD, 
        0x31D9, 0x31B6, 0x3192, 0x316E, 0x314B, 0x3127, 0x3103, 0x30E0, 
        0x30BC, 0x3099, 0x3076, 0x3053, 0x3030, 0x300E, 0x2FEC, 0x2FCB, 
        0x2FA9, 0x2F89, 0x2F68, 0x2F48, 0x2F29, 0x2F0A, 0x2EEC, 0x2ECF, 
        0x2EB2, 0x2E96, 0x2E7A, 0x2E60, 0x2E46, 0x2E2D, 0x2E14, 0x2DFD, 
        0x2DE7, 0x2DD1, 0x2DBC, 0x2DA9, 0x2D96, 0x2D85, 0x2D74, 0x2D65, 
        0x2D56, 0x2D49, 0x2D3D, 0x2D32, 0x2D29, 0x2D20, 0x2D19, 0x2D13, 
        0x2D0E, 0x2D0B, 0x2D08, 0x2D07, 0x2D08, 0x2D0A, 0x2D0D, 0x2D11, 
        0x2D17, 0x2D1E, 0x2D26, 0x2D30, 0x2D3B, 0x2D48, 0x2D56, 0x2D65, 
        0x2D75, 0x2D87, 0x2D9B, 0x2DB0, 0x2DC6, 0x2DDD, 0x2DF6, 0x2E10, 
        0x2E2B, 0x2E48, 0x2E66, 0x2E85, 0x2EA5, 0x2EC7, 0x2EEA, 0x2F0E, 
        0x2F33, 0x2F59, 0x2F81, 0x2FA9, 0x2FD3, 0x2FFE, 0x3029, 0x3056, 
        0x3084, 0x30B2, 0x30E2, 0x3112, 0x3143, 0x3175, 0x31A7, 0x31DB, 
        0x320F, 0x3243, 0x3279, 0x32AE, 0x32E4, 0x331B, 0x3352, 0x3389, 
        0x33C1, 0x33F9, 0x3431, 0x346A, 0x34A2, 0x34DA, 0x3513, 0x354B, 
        0x3584, 0x35BC, 0x35F4, 0x362C, 0x3663, 0x369A, 0x36D0, 0x3706, 
        0x373C, 0x3771, 0x37A5, 0x37D8, 0x380B, 0x383D, 0x386E, 0x389E, 
        0x38CD, 0x38FB, 0x3928, 0x3953, 0x397D, 0x39A6, 0x39CE, 0x39F4, 
        0x3A19, 0x3A3C, 0x3A5D, 0x3A7D, 0x3A9B, 0x3AB8, 0x3AD2, 0x3AEB, 
        0x3B01, 0x3B16, 0x3B29, 0x3B39, 0x3B47, 0x3B54, 0x3B5D, 0x3B65, 
        0x3B6A, 0x3B6D, 0x3B6D, 0x3B6B, 0x3B66, 0x3B5F, 0x3B54, 0x3B48, 
        0x3B38, 0x3B26, 0x3B11, 0x3AF9, 0x3ADE, 0x3AC0, 0x3A9F, 0x3A7C, 
        0x3A55, 0x3A2B, 0x39FE, 0x39CE, 0x399B, 0x3965, 0x392B, 0x38EE, 
        0x38AE, 0x386B, 0x3825, 0x37DB, 0x378E, 0x373D, 0x36EA, 0x3692, 
        0x3638, 0x35DA, 0x3579, 0x3514, 0x34AD, 0x3441, 0x33D3, 0x3361, 
        0x32EB, 0x3273, 0x31F7, 0x3177, 0x30F5, 0x306F, 0x2FE5, 0x2F59, 
        0x2EC9, 0x2E36, 0x2DA0, 0x2D06, 0x2C6A, 0x2BCA, 0x2B27, 0x2A81, 
        0x29D8, 0x292C, 0x287D, 0x27CC, 0x2717, 0x265F, 0x25A5, 0x24E8, 
        0x2428, 0x2365, 0x22A0, 0x21D8, 0x210D, 0x2040, 0x1F71, 0x1E9F, 
        0x1DCB, 0x1CF5, 0x1C1D, 0x1B42, 0x1A65, 0x1986, 0x18A5, 0x17C3, 
        0x16DE, 0x15F8, 0x1510, 0x1426, 0x133B, 0x124E, 0x1160, 0x1071, 
        0x0F80, 0x0E8E, 0x0D9B, 0x0CA6, 0x0BB1, 0x0ABB, 0x09C4, 0x08CC, 
        0x07D4, 0x06DA, 0x05E1, 0x04E7, 0x03EC, 0x02F1, 0x01F6, 0x00FB, 
        0x0000, 0xFF05, 0xFE0A, 0xFD0F, 0xFC14, 0xFB1A, 0xFA20, 0xF926, 
        0xF82D, 0xF734, 0xF63C, 0xF545, 0xF44F, 0xF35A, 0xF266, 0xF172, 
        0xF080, 0xEF90, 0xEEA0, 0xEDB2, 0xECC5, 0xEBDA, 0xEAF0, 0xEA08, 
        0xE922, 0xE83D, 0xE75B, 0xE67A, 0xE59B, 0xE4BE, 0xE3E4, 0xE30B, 
        0xE235, 0xE161, 0xE08F, 0xDFC0, 0xDEF3, 0xDE28, 0xDD61, 0xDC9B, 
        0xDBD9, 0xDB19, 0xDA5B, 0xD9A1, 0xD8E9, 0xD835, 0xD783, 0xD6D4, 
        0xD628, 0xD57F, 0xD4D9, 0xD436, 0xD396, 0xD2FA, 0xD260, 0xD1CA, 
        0xD137, 0xD0A7, 0xD01B, 0xCF92, 0xCF0C, 0xCE89, 0xCE0A, 0xCD8D, 
        0xCD15, 0xCC9F, 0xCC2D, 0xCBBF, 0xCB54, 0xCAEC, 0xCA87, 0xCA26, 
        0xC9C8, 0xC96E, 0xC917, 0xC8C3, 0xC872, 0xC825, 0xC7DB, 0xC795, 
        0xC752, 0xC712, 0xC6D5, 0xC69B, 0xC665, 0xC632, 0xC602, 0xC5D5, 
        0xC5AB, 0xC584, 0xC561, 0xC540, 0xC522, 0xC507, 0xC4EF, 0xC4DA, 
        0xC4C8, 0xC4B8, 0xC4AC, 0xC4A2, 0xC49A, 0xC495, 0xC493, 0xC493, 
        0xC496, 0xC49B, 0xC4A3, 0xC4AC, 0xC4B8, 0xC4C7, 0xC4D7, 0xC4EA, 
        0xC4FE, 0xC515, 0xC52E, 0xC548, 0xC565, 0xC583, 0xC5A3, 0xC5C4, 
        0xC5E7, 0xC60C, 0xC632, 0xC65A, 0xC683, 0xC6AD, 0xC6D8, 0xC705, 
        0xC733, 0xC762, 0xC792, 0xC7C3, 0xC7F5, 0xC827, 0xC85B, 0xC88F, 
        0xC8C4, 0xC8FA, 0xC930, 0xC966, 0xC99D, 0xC9D4, 0xCA0C, 0xCA44, 
        0xCA7C, 0xCAB5, 0xCAED, 0xCB25, 0xCB5E, 0xCB96, 0xCBCF, 0xCC07, 
        0xCC3F, 0xCC76, 0xCCAE, 0xCCE5, 0xCD1C, 0xCD52, 0xCD87, 0xCDBD, 
        0xCDF1, 0xCE25, 0xCE58, 0xCE8B, 0xCEBD, 0xCEEE, 0xCF1E, 0xCF4E, 
        0xCF7C, 0xCFAA, 0xCFD7, 0xD002, 0xD02D, 0xD057, 0xD07F, 0xD0A7, 
        0xD0CD, 0xD0F2, 0xD116, 0xD139, 0xD15B, 0xD17B, 0xD19A, 0xD1B8, 
        0xD1D5, 0xD1F0, 0xD20A, 0xD223, 0xD23A, 0xD250, 0xD265, 0xD278, 
        0xD28A, 0xD29B, 0xD2AA, 0xD2B8, 0xD2C5, 0xD2D0, 0xD2DA, 0xD2E2, 
        0xD2E9, 0xD2EF, 0xD2F3, 0xD2F6, 0xD2F8, 0xD2F9, 0xD2F8, 0xD2F5, 
        0xD2F2, 0xD2ED, 0xD2E7, 0xD2E0, 0xD2D7, 0xD2CE, 0xD2C3, 0xD2B7, 
        0xD2AA, 0xD29B, 0xD28C, 0xD27B, 0xD26A, 0xD257, 0xD244, 0xD22F, 
        0xD219, 0xD203, 0xD1EC, 0xD1D3, 0xD1BA, 0xD1A0, 0xD186, 0xD16A, 
        0xD14E, 0xD131, 0xD114, 0xD0F6, 0xD0D7, 0xD0B8, 0xD098, 0xD077, 
        0xD057, 0xD035, 0xD014, 0xCFF2, 0xCFD0, 0xCFAD, 0xCF8A, 0xCF67, 
        0xCF44, 0xCF20, 0xCEFD, 0xCED9, 0xCEB5, 0xCE92, 0xCE6E, 0xCE4A, 
        0xCE27, 0xCE03, 0xCDE0, 0xCDBD, 0xCD9A, 0xCD77, 0xCD55, 0xCD32, 
        0xCD11, 0xCCEF, 0xCCCE, 0xCCAD, 0xCC8D, 0xCC6D, 0xCC4E, 0xCC2F, 
        0xCC11, 0xCBF4, 0xCBD7, 0xCBBA, 0xCB9E, 0xCB83, 0xCB69, 0xCB4F, 
        0xCB36, 0xCB1E, 0xCB07, 0xCAF0, 0xCADA, 0xCAC5, 0xCAB1, 0xCA9D, 
        0xCA8B, 0xCA79, 0xCA69, 0xCA59, 0xCA4A, 0xCA3C, 0xCA2F, 0xCA23, 
        0xCA17, 0xCA0D, 0xCA04, 0xC9FB, 0xC9F4, 0xC9EE, 0xC9E8, 0xC9E4, 
        0xC9E0, 0xC9DD, 0xC9DC, 0xC9DB, 0xC9DB, 0xC9DD, 0xC9DF, 0xC9E2, 
        0xC9E6, 0xC9EB, 0xC9F1, 0xC9F8, 0xC9FF, 0xCA08, 0xCA11, 0xCA1C, 
        0xCA27, 0xCA33, 0xCA40, 0xCA4D, 0xCA5C, 0xCA6B, 0xCA7B, 0xCA8B, 
        0xCA9D, 0xCAAF, 0xCAC1, 0xCAD5, 0xCAE9, 0xCAFE, 0xCB13, 0xCB29, 
        0xCB3F, 0xCB56, 0xCB6D, 0xCB85, 0xCB9E, 0xCBB6, 0xCBD0, 0xCBE9, 
        0xCC03, 0xCC1D, 0xCC38, 0xCC53, 0xCC6E, 0xCC89, 0xCCA5, 0xCCC1, 
        0xCCDC, 0xCCF8, 0xCD15, 0xCD31, 0xCD4D, 0xCD69, 0xCD85, 0xCDA2, 
        0xCDBE, 0xCDDA, 0xCDF6, 0xCE12, 0xCE2D, 0xCE49, 0xCE64, 0xCE7F, 
        0xCE9A, 0xCEB4, 0xCECE, 0xCEE8, 0xCF02, 0xCF1B, 0xCF33, 0xCF4C, 
        0xCF63, 0xCF7B, 0xCF92, 0xCFA8, 0xCFBE, 0xCFD3, 0xCFE8, 0xCFFC, 
        0xD00F, 0xD022, 0xD035, 0xD046, 0xD057, 0xD068, 0xD077, 0xD086, 
        0xD094, 0xD0A2, 0xD0AF, 0xD0BB, 0xD0C6, 0xD0D0, 0xD0DA, 0xD0E3, 
        0xD0EB, 0xD0F2, 0xD0F9, 0xD0FF, 0xD104, 0xD108, 0xD10B, 0xD10E, 
        0xD10F, 0xD110, 0xD110, 0xD110, 0xD10E, 0xD10C, 0xD109, 0xD105, 
        0xD100, 0xD0FA, 0xD0F4, 0xD0ED, 0xD0E5, 0xD0DD, 0xD0D3, 0xD0C9, 
        0xD0BF, 0xD0B3, 0xD0A7, 0xD09A, 0xD08C, 0xD07E, 0xD06F, 0xD060, 
        0xD050, 0xD03F, 0xD02E, 0xD01C, 0xD009, 0xCFF6, 0xCFE3, 0xCFCF, 
        0xCFBA, 0xCFA5, 0xCF90, 0xCF7A, 0xCF64, 0xCF4E, 0xCF37, 0xCF1F, 
        0xCF08, 0xCEF0, 0xCED8, 0xCEC0, 0xCEA7, 0xCE8E, 0xCE76, 0xCE5D, 
        0xCE43, 0xCE2A, 0xCE11, 0xCDF7, 0xCDDE, 0xCDC4, 0xCDAB, 0xCD92, 
        0xCD78, 0xCD5F, 0xCD46, 0xCD2D, 0xCD14, 0xCCFB, 0xCCE3, 0xCCCB, 
        0xCCB3, 0xCC9B, 0xCC84, 0xCC6D, 0xCC56, 0xCC3F, 0xCC29, 0xCC14, 
        0xCBFF, 0xCBEA, 0xCBD5, 0xCBC2, 0xCBAE, 0xCB9B, 0xCB89, 0xCB77, 
        0xCB66, 0xCB55, 0xCB45, 0xCB36, 0xCB27, 0xCB19, 0xCB0B, 0xCAFF, 
        0xCAF2, 0xCAE7, 0xCADC, 0xCAD2, 0xCAC9, 0xCAC0, 0xCAB8, 0xCAB1, 
        0xCAAA, 0xCAA4, 0xCA9F, 0xCA9B, 0xCA98, 0xCA95, 0xCA93, 0xCA92, 
        0xCA92, 0xCA92, 0xCA93, 0xCA95, 0xCA98, 0xCA9B, 0xCA9F, 0xCAA4, 
        0xCAAA, 0xCAB1, 0xCAB8, 0xCAC0, 0xCAC8, 0xCAD2, 0xCADC, 0xCAE7, 
        0xCAF2, 0xCAFF, 0xCB0B, 0xCB19, 0xCB27, 0xCB36, 0xCB45, 0xCB55, 
        0xCB66, 0xCB77, 0xCB89, 0xCB9B, 0xCBAE, 0xCBC2, 0xCBD5, 0xCBEA, 
        0xCBFE, 0xCC14, 0xCC29, 0xCC3F, 0xCC56, 0xCC6D, 0xCC84, 0xCC9B, 
        0xCCB3, 0xCCCB, 0xCCE3, 0xCCFB, 0xCD14, 0xCD2D, 0xCD46, 0xCD5F, 
        0xCD78, 0xCD92, 0xCDAB, 0xCDC4, 0xCDDE, 0xCDF7, 0xCE11, 0xCE2A, 
        0xCE43, 0xCE5C, 0xCE76, 0xCE8E, 0xCEA7, 0xCEC0, 0xCED8, 0xCEF0, 
        0xCF08, 0xCF1F, 0xCF37, 0xCF4E, 0xCF64, 0xCF7A, 0xCF90, 0xCFA5, 
        0xCFBA, 0xCFCF, 0xCFE3, 0xCFF6, 0xD009, 0xD01C, 0xD02D, 0xD03F, 
        0xD050, 0xD060, 0xD06F, 0xD07E, 0xD08C, 0xD09A, 0xD0A7, 0xD0B3, 
        0xD0BE, 0xD0C9, 0xD0D3, 0xD0DD, 0xD0E5, 0xD0ED, 0xD0F4, 0xD0FA, 
        0xD100, 0xD105, 0xD109, 0xD10C, 0xD10E, 0xD110, 0xD110, 0xD110, 
        0xD10F, 0xD10E, 0xD10B, 0xD108, 0xD104, 0xD0FF, 0xD0F9, 0xD0F2, 
        0xD0EB, 0xD0E3, 0xD0DA, 0xD0D0, 0xD0C6, 0xD0BB, 0xD0AF, 0xD0A2, 
        0xD094, 0xD086, 0xD077, 0xD068, 0xD057, 0xD046, 0xD035, 0xD022, 
        0xD00F, 0xCFFC, 0xCFE8, 0xCFD3, 0xCFBE, 0xCFA8, 0xCF92, 0xCF7B, 
        0xCF63, 0xCF4C, 0xCF33, 0xCF1B, 0xCF02, 0xCEE8, 0xCECE, 0xCEB4, 
        0xCE9A, 0xCE7F, 0xCE64, 0xCE49, 0xCE2D, 0xCE12, 0xCDF6, 0xCDDA, 
        0xCDBE, 0xCDA2, 0xCD85, 0xCD69, 0xCD4D, 0xCD31, 0xCD15, 0xCCF8, 
        0xCCDC, 0xCCC1, 0xCCA5, 0xCC89, 0xCC6E, 0xCC53, 0xCC38, 0xCC1D, 
        0xCC03, 0xCBE9, 0xCBD0, 0xCBB6, 0xCB9E, 0xCB85, 0xCB6D, 0xCB56, 
        0xCB3F, 0xCB29, 0xCB13, 0xCAFE, 0xCAE9, 0xCAD5, 0xCAC1, 0xCAAF, 
        0xCA9D, 0xCA8B, 0xCA7B, 0xCA6B, 0xCA5C, 0xCA4D, 0xCA40, 0xCA33, 
        0xCA27, 0xCA1C, 0xCA11, 0xCA08, 0xC9FF, 0xC9F8, 0xC9F1, 0xC9EB, 
        0xC9E6, 0xC9E2, 0xC9DF, 0xC9DD, 0xC9DB, 0xC9DB, 0xC9DC, 0xC9DD, 
        0xC9E0, 0xC9E4, 0xC9E8, 0xC9EE, 0xC9F4, 0xC9FB, 0xCA04, 0xCA0D, 
        0xCA17, 0xCA22, 0xCA2F, 0xCA3C, 0xCA4A, 0xCA59, 0xCA68, 0xCA79, 
        0xCA8B, 0xCA9D, 0xCAB1, 0xCAC5, 0xCADA, 0xCAF0, 0xCB06, 0xCB1E, 
        0xCB36, 0xCB4F, 0xCB69, 0xCB83, 0xCB9E, 0xCBBA, 0xCBD6, 0xCBF3, 
        0xCC11, 0xCC2F, 0xCC4E, 0xCC6D, 0xCC8D, 0xCCAD, 0xCCCE, 0xCCEF, 
        0xCD11, 0xCD32, 0xCD55, 0xCD77, 0xCD9A, 0xCDBD, 0xCDE0, 0xCE03, 
        0xCE27, 0xCE4A, 0xCE6E, 0xCE92, 0xCEB5, 0xCED9, 0xCEFD, 0xCF20, 
        0xCF44, 0xCF67, 0xCF8A, 0xCFAD, 0xCFD0, 0xCFF2, 0xD014, 0xD035, 
        0xD057, 0xD077, 0xD098, 0xD0B8, 0xD0D7, 0xD0F6, 0xD114, 0xD131, 
        0xD14E, 0xD16A, 0xD186, 0xD1A0, 0xD1BA, 0xD1D3, 0xD1EC, 0xD203, 
        0xD219, 0xD22F, 0xD244, 0xD257, 0xD26A, 0xD27B, 0xD28C, 0xD29B, 
        0xD2AA, 0xD2B7, 0xD2C3, 0xD2CE, 0xD2D7, 0xD2E0, 0xD2E7, 0xD2ED, 
        0xD2F2, 0xD2F5, 0xD2F8, 0xD2F9, 0xD2F8, 0xD2F6, 0xD2F3, 0xD2EF, 
        0xD2E9, 0xD2E2, 0xD2DA, 0xD2D0, 0xD2C5, 0xD2B8, 0xD2AA, 0xD29B, 
        0xD28B, 0xD279, 0xD265, 0xD250, 0xD23A, 0xD223, 0xD20A, 0xD1F0, 
        0xD1D5, 0xD1B8, 0xD19A, 0xD17B, 0xD15B, 0xD139, 0xD116, 0xD0F2, 
        0xD0CD, 0xD0A7, 0xD07F, 0xD057, 0xD02D, 0xD002, 0xCFD7, 0xCFAA, 
        0xCF7C, 0xCF4E, 0xCF1E, 0xCEEE, 0xCEBD, 0xCE8B, 0xCE59, 0xCE25, 
        0xCDF1, 0xCDBD, 0xCD87, 0xCD52, 0xCD1C, 0xCCE5, 0xCCAE, 0xCC77, 
        0xCC3F, 0xCC07, 0xCBCF, 0xCB96, 0xCB5E, 0xCB26, 0xCAED, 0xCAB5, 
        0xCA7C, 0xCA44, 0xCA0C, 0xC9D5, 0xC99D, 0xC966, 0xC930, 0xC8FA, 
        0xC8C4, 0xC88F, 0xC85B, 0xC828, 0xC7F5, 0xC7C3, 0xC792, 0xC762, 
        0xC733, 0xC705, 0xC6D8, 0xC6AD, 0xC683, 0xC65A, 0xC632, 0xC60C, 
        0xC5E7, 0xC5C4, 0xC5A3, 0xC583, 0xC565, 0xC548, 0xC52E, 0xC515, 
        0xC4FF, 0xC4EA, 0xC4D7, 0xC4C7, 0xC4B9, 0xC4AC, 0xC4A3, 0xC49B, 
        0xC496, 0xC493, 0xC493, 0xC495, 0xC49A, 0xC4A1, 0xC4AC, 0xC4B8, 
        0xC4C8, 0xC4DA, 0xC4EF, 0xC507, 0xC522, 0xC540, 0xC561, 0xC584, 
        0xC5AB, 0xC5D5, 0xC602, 0xC632, 0xC665, 0xC69B, 0xC6D5, 0xC712, 
        0xC752, 0xC795, 0xC7DB, 0xC825, 0xC872, 0xC8C3, 0xC916, 0xC96E, 
        0xC9C8, 0xCA26, 0xCA87, 0xCAEC, 0xCB53, 0xCBBF, 0xCC2D, 0xCC9F, 
        0xCD15, 0xCD8D, 0xCE09, 0xCE89, 0xCF0B, 0xCF91, 0xD01B, 0xD0A7, 
        0xD137, 0xD1CA, 0xD260, 0xD2FA, 0xD396, 0xD436, 0xD4D9, 0xD57F, 
        0xD628, 0xD6D3, 0xD782, 0xD834, 0xD8E9, 0xD9A1, 0xDA5B, 0xDB18, 
        0xDBD8, 0xDC9B, 0xDD60, 0xDE28, 0xDEF2, 0xDFBF, 0xE08F, 0xE160, 
        0xE234, 0xE30B, 0xE3E3, 0xE4BE, 0xE59B, 0xE67A, 0xE75A, 0xE83D, 
        0xE922, 0xEA08, 0xEAF0, 0xEBDA, 0xECC5, 0xEDB2, 0xEEA0, 0xEF8F, 
        0xF080, 0xF172, 0xF265, 0xF35A, 0xF44F, 0xF545, 0xF63C, 0xF734, 
        0xF82C, 0xF925, 0xFA1F, 0xFB19, 0xFC14, 0xFD0F, 0xFE0A, 0xFF05, 
// Waveform 1 (triangular):
        0x0000, 0x0043, 0x0086, 0x00C9, 0x010C, 0x014F, 0x0192, 0x01D5, 
        0x0218, 0x025B, 0x029E, 0x02E1, 0x0324, 0x0367, 0x03AA, 0x03ED, 
        0x042F, 0x0472, 0x04B5, 0x04F7, 0x0539, 0x057C, 0x05BE, 0x0600, 
        0x0643, 0x0685, 0x06C7, 0x0708, 0x074A, 0x078C, 0x07CE, 0x080F, 
        0x0850, 0x0892, 0x08D3, 0x0914, 0x0955, 0x0996, 0x09D7, 0x0A17, 
        0x0A58, 0x0A98, 0x0AD9, 0x0B19, 0x0B59, 0x0B99, 0x0BD9, 0x0C18, 
        0x0C58, 0x0C97, 0x0CD7, 0x0D16, 0x0D55, 0x0D94, 0x0DD3, 0x0E11, 
        0x0E50, 0x0E8E, 0x0ECD, 0x0F0B, 0x0F49, 0x0F87, 0x0FC5, 0x1002, 
        0x1040, 0x107D, 0x10BB, 0x10F8, 0x1135, 0x1172, 0x11AF, 0x11EC, 
        0x1229, 0x1265, 0x12A2, 0x12DE, 0x131A, 0x1357, 0x1393, 0x13CF, 
        0x140B, 0x1447, 0x1483, 0x14BE, 0x14FA, 0x1536, 0x1571, 0x15AD, 
        0x15E8, 0x1623, 0x165F, 0x169A, 0x16D5, 0x1710, 0x174B, 0x1787, 
        0x17C2, 0x17FD, 0x1838, 0x1873, 0x18AE, 0x18E9, 0x1924, 0x195F, 
        0x199A, 0x19D5, 0x1A10, 0x1A4B, 0x1A86, 0x1AC1, 0x1AFC, 0x1B37, 
        0x1B72, 0x1BAD, 0x1BE9, 0x1C24, 0x1C5F, 0x1C9B, 0x1CD6, 0x1D11, 
        0x1D4D, 0x1D89, 0x1DC4, 0x1E00, 0x1E3C, 0x1E78, 0x1EB4, 0x1EF0, 
        0x1F2C, 0x1F69, 0x1FA5, 0x1FE1, 0x201E, 0x205B, 0x2098, 0x20D4, 
        0x2111, 0x214F, 0x218C, 0x21C9, 0x2207, 0x2244, 0x2282, 0x22C0, 
        0x22FE, 0x233C, 0x237B, 0x23B9, 0x23F7, 0x2436, 0x2475, 0x24B4, 
        0x24F3, 0x2532, 0x2572, 0x25B1, 0x25F1, 0x2631, 0x2670, 0x26B1, 
        0x26F1, 0x2731, 0x2772, 0x27B2, 0x27F3, 0x2834, 0x2875, 0x28B6, 
        0x28F7, 0x2939, 0x297A, 0x29BC, 0x29FD, 0x2A3F, 0x2A81, 0x2AC3, 
        0x2B06, 0x2B48, 0x2B8B, 0x2BCD, 0x2C10, 0x2C53, 0x2C95, 0x2CD8, 
        0x2D1B, 0x2D5F, 0x2DA2, 0x2DE5, 0x2E28, 0x2E6C, 0x2EAF, 0x2EF3, 
        0x2F37, 0x2F7A, 0x2FBE, 0x3002, 0x3046, 0x308A, 0x30CE, 0x3111, 
        0x3155, 0x3199, 0x31DD, 0x3221, 0x3266, 0x32AA, 0x32EE, 0x3332, 
        0x3376, 0x33BA, 0x33FE, 0x3442, 0x3486, 0x34C9, 0x350D, 0x3551, 
        0x3595, 0x35D9, 0x361C, 0x3660, 0x36A3, 0x36E7, 0x372A, 0x376E, 
        0x37B1, 0x37F4, 0x3837, 0x387A, 0x38BD, 0x3900, 0x3942, 0x3985, 
        0x39C7, 0x3A09, 0x3A4B, 0x3A8E, 0x3ACF, 0x3B11, 0x3B53, 0x3B94, 
        0x3BD6, 0x3C17, 0x3C58, 0x3C99, 0x3CD9, 0x3D1A, 0x3D5A, 0x3D9B, 
        0x3DDB, 0x3E1B, 0x3E5A, 0x3E9A, 0x3ED9, 0x3F19, 0x3F58, 0x3F97, 
        0x3FD5, 0x4014, 0x4052, 0x4091, 0x40CF, 0x410C, 0x414A, 0x4188, 
        0x41C5, 0x4202, 0x423F, 0x427C, 0x42B9, 0x42F5, 0x4331, 0x436E, 
        0x43AA, 0x43E5, 0x4421, 0x445C, 0x4498, 0x44D3, 0x450E, 0x4549, 
        0x4584, 0x45BE, 0x45F9, 0x4633, 0x466D, 0x46A7, 0x46E1, 0x471B, 
        0x4755, 0x478F, 0x47C8, 0x4802, 0x483B, 0x4874, 0x48AD, 0x48E6, 
        0x491F, 0x4958, 0x4991, 0x49CA, 0x4A03, 0x4A3C, 0x4A74, 0x4AAD, 
        0x4AE6, 0x4B1E, 0x4B57, 0x4B8F, 0x4BC8, 0x4C01, 0x4C39, 0x4C72, 
        0x4CAA, 0x4CE3, 0x4D1C, 0x4D55, 0x4D8D, 0x4DC6, 0x4DFF, 0x4E38, 
        0x4E71, 0x4EAA, 0x4EE4, 0x4F1D, 0x4F57, 0x4F90, 0x4FCA, 0x5004, 
        0x503E, 0x5078, 0x50B2, 0x50EC, 0x5127, 0x5162, 0x519C, 0x51D7, 
        0x5213, 0x524E, 0x528A, 0x52C5, 0x5301, 0x533E, 0x537A, 0x53B7, 
        0x53F4, 0x5431, 0x546E, 0x54AB, 0x54E9, 0x5527, 0x5566, 0x55A4, 
        0x55E3, 0x5622, 0x5661, 0x56A1, 0x56E1, 0x5721, 0x5761, 0x57A2, 
        0x57E3, 0x5824, 0x5865, 0x58A7, 0x58E9, 0x592B, 0x596E, 0x59B1, 
        0x59F4, 0x5A37, 0x5A7B, 0x5ABF, 0x5B03, 0x5B47, 0x5B8C, 0x5BD1, 
        0x5C16, 0x5C5C, 0x5CA2, 0x5CE8, 0x5D2E, 0x5D75, 0x5DBC, 0x5E03, 
        0x5E4A, 0x5E91, 0x5ED9, 0x5F21, 0x5F69, 0x5FB1, 0x5FFA, 0x6043, 
        0x608C, 0x60D5, 0x611E, 0x6167, 0x61B1, 0x61FB, 0x6245, 0x628F, 
        0x62D9, 0x6323, 0x636D, 0x63B8, 0x6402, 0x644D, 0x6497, 0x64E2, 
        0x652C, 0x6577, 0x65C2, 0x660C, 0x6657, 0x66A2, 0x66EC, 0x6737, 
        0x6781, 0x67CC, 0x6816, 0x6860, 0x68AA, 0x68F4, 0x693E, 0x6987, 
        0x69D1, 0x6A1A, 0x6A63, 0x6AAC, 0x6AF4, 0x6B3D, 0x6B84, 0x6BCC, 
        0x6C14, 0x6C5B, 0x6CA1, 0x6CE8, 0x6D2E, 0x6D73, 0x6DB9, 0x6DFD, 
        0x6E42, 0x6E86, 0x6EC9, 0x6F0C, 0x6F4E, 0x6F90, 0x6FD2, 0x7013, 
        0x7053, 0x7093, 0x70D2, 0x7110, 0x714E, 0x718B, 0x71C8, 0x7204, 
        0x723F, 0x7279, 0x72B3, 0x72EC, 0x7324, 0x735B, 0x7392, 0x73C8, 
        0x73FD, 0x7431, 0x7464, 0x7497, 0x74C8, 0x74F9, 0x7529, 0x7558, 
        0x7586, 0x75B3, 0x75DF, 0x760A, 0x7634, 0x765D, 0x7685, 0x76AC, 
        0x76D2, 0x76F7, 0x771A, 0x773D, 0x775F, 0x7780, 0x779F, 0x77BD, 
        0x77DB, 0x77F7, 0x7812, 0x782C, 0x7845, 0x785C, 0x7873, 0x7888, 
        0x789C, 0x78AF, 0x78C1, 0x78D1, 0x78E0, 0x78EE, 0x78FB, 0x7907, 
        0x7911, 0x791B, 0x7923, 0x7929, 0x792F, 0x7933, 0x7936, 0x7938, 
        0x7939, 0x7938, 0x7936, 0x7933, 0x792F, 0x7929, 0x7923, 0x791B, 
        0x7911, 0x7907, 0x78FB, 0x78EE, 0x78E0, 0x78D1, 0x78C1, 0x78AF, 
        0x789C, 0x7888, 0x7873, 0x785C, 0x7845, 0x782C, 0x7812, 0x77F7, 
        0x77DB, 0x77BE, 0x779F, 0x7780, 0x775F, 0x773D, 0x771A, 0x76F7, 
        0x76D2, 0x76AC, 0x7685, 0x765D, 0x7634, 0x760A, 0x75DF, 0x75B3, 
        0x7586, 0x7558, 0x7529, 0x74F9, 0x74C8, 0x7497, 0x7464, 0x7431, 
        0x73FD, 0x73C8, 0x7392, 0x735C, 0x7324, 0x72EC, 0x72B3, 0x7279, 
        0x723F, 0x7204, 0x71C8, 0x718B, 0x714E, 0x7110, 0x70D2, 0x7093, 
        0x7053, 0x7013, 0x6FD2, 0x6F90, 0x6F4F, 0x6F0C, 0x6EC9, 0x6E86, 
        0x6E42, 0x6DFD, 0x6DB9, 0x6D73, 0x6D2E, 0x6CE8, 0x6CA1, 0x6C5B, 
        0x6C14, 0x6BCC, 0x6B85, 0x6B3D, 0x6AF4, 0x6AAC, 0x6A63, 0x6A1A, 
        0x69D1, 0x6987, 0x693E, 0x68F4, 0x68AA, 0x6860, 0x6816, 0x67CC, 
        0x6781, 0x6737, 0x66EC, 0x66A2, 0x6657, 0x660C, 0x65C2, 0x6577, 
        0x652C, 0x64E2, 0x6497, 0x644D, 0x6402, 0x63B8, 0x636D, 0x6323, 
        0x62D9, 0x628F, 0x6245, 0x61FB, 0x61B1, 0x6167, 0x611E, 0x60D5, 
        0x608C, 0x6043, 0x5FFA, 0x5FB1, 0x5F69, 0x5F21, 0x5ED9, 0x5E91, 
        0x5E4A, 0x5E03, 0x5DBC, 0x5D75, 0x5D2E, 0x5CE8, 0x5CA2, 0x5C5C, 
        0x5C17, 0x5BD1, 0x5B8C, 0x5B47, 0x5B03, 0x5ABF, 0x5A7B, 0x5A37, 
        0x59F4, 0x59B1, 0x596E, 0x592B, 0x58E9, 0x58A7, 0x5865, 0x5824, 
        0x57E3, 0x57A2, 0x5761, 0x5721, 0x56E1, 0x56A1, 0x5661, 0x5622, 
        0x55E3, 0x55A4, 0x5566, 0x5527, 0x54E9, 0x54AC, 0x546E, 0x5431, 
        0x53F4, 0x53B7, 0x537A, 0x533E, 0x5301, 0x52C5, 0x528A, 0x524E, 
        0x5213, 0x51D7, 0x519C, 0x5162, 0x5127, 0x50EC, 0x50B2, 0x5078, 
        0x503E, 0x5004, 0x4FCA, 0x4F90, 0x4F57, 0x4F1D, 0x4EE4, 0x4EAA, 
        0x4E71, 0x4E38, 0x4DFF, 0x4DC6, 0x4D8D, 0x4D55, 0x4D1C, 0x4CE3, 
        0x4CAA, 0x4C72, 0x4C39, 0x4C01, 0x4BC8, 0x4B8F, 0x4B57, 0x4B1E, 
        0x4AE6, 0x4AAD, 0x4A74, 0x4A3C, 0x4A03, 0x49CA, 0x4991, 0x4958, 
        0x491F, 0x48E6, 0x48AD, 0x4874, 0x483B, 0x4802, 0x47C8, 0x478F, 
        0x4755, 0x471B, 0x46E1, 0x46A7, 0x466D, 0x4633, 0x45F9, 0x45BE, 
        0x4584, 0x4549, 0x450E, 0x44D3, 0x4498, 0x445D, 0x4421, 0x43E5, 
        0x43AA, 0x436E, 0x4331, 0x42F5, 0x42B9, 0x427C, 0x423F, 0x4202, 
        0x41C5, 0x4188, 0x414A, 0x410D, 0x40CF, 0x4091, 0x4052, 0x4014, 
        0x3FD5, 0x3F97, 0x3F58, 0x3F19, 0x3EDA, 0x3E9A, 0x3E5B, 0x3E1B, 
        0x3DDB, 0x3D9B, 0x3D5A, 0x3D1A, 0x3CD9, 0x3C99, 0x3C58, 0x3C17, 
        0x3BD6, 0x3B94, 0x3B53, 0x3B11, 0x3ACF, 0x3A8E, 0x3A4C, 0x3A09, 
        0x39C7, 0x3985, 0x3942, 0x3900, 0x38BD, 0x387A, 0x3837, 0x37F4, 
        0x37B1, 0x376E, 0x372A, 0x36E7, 0x36A3, 0x3660, 0x361C, 0x35D9, 
        0x3595, 0x3551, 0x350D, 0x34CA, 0x3486, 0x3442, 0x33FE, 0x33BA, 
        0x3376, 0x3332, 0x32EE, 0x32AA, 0x3266, 0x3222, 0x31DD, 0x3199, 
        0x3155, 0x3112, 0x30CE, 0x308A, 0x3046, 0x3002, 0x2FBE, 0x2F7A, 
        0x2F37, 0x2EF3, 0x2EAF, 0x2E6C, 0x2E28, 0x2DE5, 0x2DA2, 0x2D5F, 
        0x2D1B, 0x2CD8, 0x2C95, 0x2C53, 0x2C10, 0x2BCD, 0x2B8B, 0x2B48, 
        0x2B06, 0x2AC4, 0x2A81, 0x2A3F, 0x29FE, 0x29BC, 0x297A, 0x2939, 
        0x28F7, 0x28B6, 0x2875, 0x2834, 0x27F3, 0x27B2, 0x2772, 0x2731, 
        0x26F1, 0x26B1, 0x2670, 0x2631, 0x25F1, 0x25B1, 0x2572, 0x2532, 
        0x24F3, 0x24B4, 0x2475, 0x2436, 0x23F7, 0x23B9, 0x237B, 0x233C, 
        0x22FE, 0x22C0, 0x2282, 0x2244, 0x2207, 0x21C9, 0x218C, 0x214F, 
        0x2112, 0x20D4, 0x2098, 0x205B, 0x201E, 0x1FE1, 0x1FA5, 0x1F69, 
        0x1F2C, 0x1EF0, 0x1EB4, 0x1E78, 0x1E3C, 0x1E00, 0x1DC4, 0x1D89, 
        0x1D4D, 0x1D12, 0x1CD6, 0x1C9B, 0x1C5F, 0x1C24, 0x1BE9, 0x1BAD, 
        0x1B72, 0x1B37, 0x1AFC, 0x1AC1, 0x1A86, 0x1A4B, 0x1A10, 0x19D5, 
        0x199A, 0x195F, 0x1924, 0x18E9, 0x18AE, 0x1873, 0x1838, 0x17FD, 
        0x17C2, 0x1787, 0x174C, 0x1710, 0x16D5, 0x169A, 0x165F, 0x1623, 
        0x15E8, 0x15AD, 0x1571, 0x1536, 0x14FA, 0x14BE, 0x1483, 0x1447, 
        0x140B, 0x13CF, 0x1393, 0x1357, 0x131B, 0x12DE, 0x12A2, 0x1265, 
        0x1229, 0x11EC, 0x11AF, 0x1172, 0x1135, 0x10F8, 0x10BB, 0x107D, 
        0x1040, 0x1002, 0x0FC5, 0x0F87, 0x0F49, 0x0F0B, 0x0ECD, 0x0E8E, 
        0x0E50, 0x0E11, 0x0DD3, 0x0D94, 0x0D55, 0x0D16, 0x0CD7, 0x0C97, 
        0x0C58, 0x0C18, 0x0BD9, 0x0B99, 0x0B59, 0x0B19, 0x0AD9, 0x0A98, 
        0x0A58, 0x0A17, 0x09D7, 0x0996, 0x0955, 0x0914, 0x08D3, 0x0892, 
        0x0850, 0x080F, 0x07CE, 0x078C, 0x074A, 0x0708, 0x06C7, 0x0685, 
        0x0643, 0x0600, 0x05BE, 0x057C, 0x053A, 0x04F7, 0x04B5, 0x0472, 
        0x042F, 0x03ED, 0x03AA, 0x0367, 0x0324, 0x02E1, 0x029E, 0x025B, 
        0x0218, 0x01D5, 0x0192, 0x014F, 0x010C, 0x00C9, 0x0086, 0x0043, 
        0x0000, 0xFFBD, 0xFF7A, 0xFF37, 0xFEF4, 0xFEB1, 0xFE6E, 0xFE2B, 
        0xFDE8, 0xFDA5, 0xFD62, 0xFD1F, 0xFCDC, 0xFC99, 0xFC56, 0xFC13, 
        0xFBD1, 0xFB8E, 0xFB4C, 0xFB09, 0xFAC7, 0xFA84, 0xFA42, 0xFA00, 
        0xF9BE, 0xF97B, 0xF939, 0xF8F8, 0xF8B6, 0xF874, 0xF832, 0xF7F1, 
        0xF7B0, 0xF76E, 0xF72D, 0xF6EC, 0xF6AB, 0xF66A, 0xF629, 0xF5E9, 
        0xF5A8, 0xF568, 0xF528, 0xF4E7, 0xF4A7, 0xF467, 0xF428, 0xF3E8, 
        0xF3A8, 0xF369, 0xF32A, 0xF2EA, 0xF2AB, 0xF26C, 0xF22E, 0xF1EF, 
        0xF1B0, 0xF172, 0xF134, 0xF0F5, 0xF0B7, 0xF079, 0xF03B, 0xEFFE, 
        0xEFC0, 0xEF83, 0xEF45, 0xEF08, 0xEECB, 0xEE8E, 0xEE51, 0xEE14, 
        0xEDD7, 0xED9B, 0xED5E, 0xED22, 0xECE6, 0xECA9, 0xEC6D, 0xEC31, 
        0xEBF5, 0xEBB9, 0xEB7D, 0xEB42, 0xEB06, 0xEACA, 0xEA8F, 0xEA53, 
        0xEA18, 0xE9DD, 0xE9A1, 0xE966, 0xE92B, 0xE8F0, 0xE8B5, 0xE879, 
        0xE83E, 0xE803, 0xE7C8, 0xE78D, 0xE752, 0xE717, 0xE6DC, 0xE6A1, 
        0xE666, 0xE62B, 0xE5F0, 0xE5B5, 0xE57A, 0xE53F, 0xE504, 0xE4C9, 
        0xE48E, 0xE453, 0xE417, 0xE3DC, 0xE3A1, 0xE365, 0xE32A, 0xE2EF, 
        0xE2B3, 0xE277, 0xE23C, 0xE200, 0xE1C4, 0xE188, 0xE14C, 0xE110, 
        0xE0D4, 0xE097, 0xE05B, 0xE01F, 0xDFE2, 0xDFA5, 0xDF69, 0xDF2C, 
        0xDEEF, 0xDEB1, 0xDE74, 0xDE37, 0xDDF9, 0xDDBC, 0xDD7E, 0xDD40, 
        0xDD02, 0xDCC4, 0xDC86, 0xDC47, 0xDC09, 0xDBCA, 0xDB8B, 0xDB4C, 
        0xDB0D, 0xDACE, 0xDA8E, 0xDA4F, 0xDA0F, 0xD9D0, 0xD990, 0xD950, 
        0xD90F, 0xD8CF, 0xD88F, 0xD84E, 0xD80D, 0xD7CC, 0xD78B, 0xD74A, 
        0xD709, 0xD6C7, 0xD686, 0xD644, 0xD603, 0xD5C1, 0xD57F, 0xD53D, 
        0xD4FA, 0xD4B8, 0xD475, 0xD433, 0xD3F0, 0xD3AD, 0xD36B, 0xD328, 
        0xD2E5, 0xD2A1, 0xD25E, 0xD21B, 0xD1D8, 0xD194, 0xD151, 0xD10D, 
        0xD0C9, 0xD086, 0xD042, 0xCFFE, 0xCFBA, 0xCF76, 0xCF33, 0xCEEF, 
        0xCEAB, 0xCE67, 0xCE23, 0xCDDF, 0xCD9B, 0xCD56, 0xCD12, 0xCCCE, 
        0xCC8A, 0xCC46, 0xCC02, 0xCBBE, 0xCB7A, 0xCB37, 0xCAF3, 0xCAAF, 
        0xCA6B, 0xCA27, 0xC9E4, 0xC9A0, 0xC95D, 0xC919, 0xC8D6, 0xC892, 
        0xC84F, 0xC80C, 0xC7C9, 0xC786, 0xC743, 0xC701, 0xC6BE, 0xC67B, 
        0xC639, 0xC5F7, 0xC5B5, 0xC573, 0xC531, 0xC4EF, 0xC4AD, 0xC46C, 
        0xC42A, 0xC3E9, 0xC3A8, 0xC367, 0xC327, 0xC2E6, 0xC2A6, 0xC265, 
        0xC225, 0xC1E5, 0xC1A6, 0xC166, 0xC127, 0xC0E7, 0xC0A8, 0xC069, 
        0xC02B, 0xBFEC, 0xBFAE, 0xBF6F, 0xBF31, 0xBEF4, 0xBEB6, 0xBE78, 
        0xBE3B, 0xBDFE, 0xBDC1, 0xBD84, 0xBD47, 0xBD0B, 0xBCCF, 0xBC93, 
        0xBC57, 0xBC1B, 0xBBDF, 0xBBA4, 0xBB68, 0xBB2D, 0xBAF2, 0xBAB7, 
        0xBA7C, 0xBA42, 0xBA07, 0xB9CD, 0xB993, 0xB959, 0xB91F, 0xB8E5, 
        0xB8AB, 0xB871, 0xB838, 0xB7FE, 0xB7C5, 0xB78C, 0xB753, 0xB71A, 
        0xB6E1, 0xB6A8, 0xB66F, 0xB636, 0xB5FD, 0xB5C4, 0xB58C, 0xB553, 
        0xB51B, 0xB4E2, 0xB4A9, 0xB471, 0xB438, 0xB400, 0xB3C7, 0xB38E, 
        0xB356, 0xB31D, 0xB2E4, 0xB2AB, 0xB273, 0xB23A, 0xB201, 0xB1C8, 
        0xB18F, 0xB156, 0xB11C, 0xB0E3, 0xB0AA, 0xB070, 0xB036, 0xAFFC, 
        0xAFC2, 0xAF88, 0xAF4E, 0xAF14, 0xAED9, 0xAE9F, 0xAE64, 0xAE29, 
        0xADED, 0xADB2, 0xAD76, 0xAD3B, 0xACFF, 0xACC2, 0xAC86, 0xAC49, 
        0xAC0C, 0xABCF, 0xAB92, 0xAB55, 0xAB17, 0xAAD9, 0xAA9A, 0xAA5C, 
        0xAA1D, 0xA9DE, 0xA99F, 0xA95F, 0xA91F, 0xA8DF, 0xA89F, 0xA85E, 
        0xA81D, 0xA7DC, 0xA79B, 0xA759, 0xA717, 0xA6D5, 0xA692, 0xA64F, 
        0xA60C, 0xA5C9, 0xA585, 0xA541, 0xA4FD, 0xA4B9, 0xA474, 0xA42F, 
        0xA3EA, 0xA3A4, 0xA35E, 0xA318, 0xA2D2, 0xA28B, 0xA245, 0xA1FD, 
        0xA1B6, 0xA16F, 0xA127, 0xA0DF, 0xA097, 0xA04F, 0xA006, 0x9FBD, 
        0x9F74, 0x9F2B, 0x9EE2, 0x9E99, 0x9E4F, 0x9E05, 0x9DBB, 0x9D71, 
        0x9D27, 0x9CDD, 0x9C93, 0x9C48, 0x9BFE, 0x9BB4, 0x9B69, 0x9B1E, 
        0x9AD4, 0x9A89, 0x9A3E, 0x99F4, 0x99A9, 0x995E, 0x9914, 0x98C9, 
        0x987F, 0x9834, 0x97EA, 0x97A0, 0x9756, 0x970C, 0x96C2, 0x9679, 
        0x962F, 0x95E6, 0x959D, 0x9554, 0x950C, 0x94C4, 0x947C, 0x9434, 
        0x93EC, 0x93A5, 0x935F, 0x9318, 0x92D2, 0x928D, 0x9247, 0x9203, 
        0x91BE, 0x917A, 0x9137, 0x90F4, 0x90B2, 0x9070, 0x902E, 0x8FED, 
        0x8FAD, 0x8F6D, 0x8F2E, 0x8EF0, 0x8EB2, 0x8E75, 0x8E38, 0x8DFC, 
        0x8DC1, 0x8D87, 0x8D4D, 0x8D14, 0x8CDC, 0x8CA5, 0x8C6E, 0x8C38, 
        0x8C03, 0x8BCF, 0x8B9C, 0x8B69, 0x8B38, 0x8B07, 0x8AD7, 0x8AA8, 
        0x8A7A, 0x8A4D, 0x8A21, 0x89F6, 0x89CC, 0x89A3, 0x897B, 0x8954, 
        0x892E, 0x8909, 0x88E6, 0x88C3, 0x88A1, 0x8880, 0x8861, 0x8843, 
        0x8825, 0x8809, 0x87EE, 0x87D4, 0x87BB, 0x87A4, 0x878D, 0x8778, 
        0x8764, 0x8751, 0x873F, 0x872F, 0x8720, 0x8712, 0x8705, 0x86F9, 
        0x86EF, 0x86E5, 0x86DD, 0x86D7, 0x86D1, 0x86CD, 0x86CA, 0x86C8, 
        0x86C7, 0x86C8, 0x86CA, 0x86CD, 0x86D1, 0x86D7, 0x86DD, 0x86E5, 
        0x86EF, 0x86F9, 0x8705, 0x8712, 0x8720, 0x872F, 0x873F, 0x8751, 
        0x8764, 0x8778, 0x878D, 0x87A4, 0x87BB, 0x87D4, 0x87EE, 0x8809, 
        0x8825, 0x8842, 0x8861, 0x8880, 0x88A1, 0x88C3, 0x88E6, 0x8909, 
        0x892E, 0x8954, 0x897B, 0x89A3, 0x89CC, 0x89F6, 0x8A21, 0x8A4D, 
        0x8A7A, 0x8AA8, 0x8AD7, 0x8B07, 0x8B38, 0x8B69, 0x8B9C, 0x8BCF, 
        0x8C03, 0x8C38, 0x8C6E, 0x8CA4, 0x8CDC, 0x8D14, 0x8D4D, 0x8D87, 
        0x8DC1, 0x8DFC, 0x8E38, 0x8E75, 0x8EB2, 0x8EF0, 0x8F2E, 0x8F6D, 
        0x8FAD, 0x8FED, 0x902E, 0x9070, 0x90B1, 0x90F4, 0x9137, 0x917A, 
        0x91BE, 0x9203, 0x9247, 0x928D, 0x92D2, 0x9318, 0x935F, 0x93A5, 
        0x93EC, 0x9434, 0x947B, 0x94C3, 0x950C, 0x9554, 0x959D, 0x95E6, 
        0x962F, 0x9679, 0x96C2, 0x970C, 0x9756, 0x97A0, 0x97EA, 0x9834, 
        0x987F, 0x98C9, 0x9914, 0x995E, 0x99A9, 0x99F4, 0x9A3E, 0x9A89, 
        0x9AD4, 0x9B1E, 0x9B69, 0x9BB3, 0x9BFE, 0x9C48, 0x9C93, 0x9CDD, 
        0x9D27, 0x9D71, 0x9DBB, 0x9E05, 0x9E4F, 0x9E98, 0x9EE2, 0x9F2B, 
        0x9F74, 0x9FBD, 0xA006, 0xA04E, 0xA097, 0xA0DF, 0xA127, 0xA16F, 
        0xA1B6, 0xA1FD, 0xA244, 0xA28B, 0xA2D2, 0xA318, 0xA35E, 0xA3A4, 
        0xA3E9, 0xA42F, 0xA474, 0xA4B9, 0xA4FD, 0xA541, 0xA585, 0xA5C9, 
        0xA60C, 0xA64F, 0xA692, 0xA6D5, 0xA717, 0xA759, 0xA79B, 0xA7DC, 
        0xA81D, 0xA85E, 0xA89F, 0xA8DF, 0xA91F, 0xA95F, 0xA99F, 0xA9DE, 
        0xAA1D, 0xAA5C, 0xAA9A, 0xAAD9, 0xAB17, 0xAB54, 0xAB92, 0xABCF, 
        0xAC0C, 0xAC49, 0xAC86, 0xACC2, 0xACFE, 0xAD3A, 0xAD76, 0xADB2, 
        0xADED, 0xAE29, 0xAE64, 0xAE9E, 0xAED9, 0xAF14, 0xAF4E, 0xAF88, 
        0xAFC2, 0xAFFC, 0xB036, 0xB070, 0xB0A9, 0xB0E3, 0xB11C, 0xB156, 
        0xB18F, 0xB1C8, 0xB201, 0xB23A, 0xB273, 0xB2AB, 0xB2E4, 0xB31D, 
        0xB356, 0xB38E, 0xB3C7, 0xB3FF, 0xB438, 0xB471, 0xB4A9, 0xB4E2, 
        0xB51A, 0xB553, 0xB58C, 0xB5C4, 0xB5FD, 0xB636, 0xB66F, 0xB6A8, 
        0xB6E1, 0xB71A, 0xB753, 0xB78C, 0xB7C5, 0xB7FE, 0xB838, 0xB871, 
        0xB8AB, 0xB8E5, 0xB91F, 0xB959, 0xB993, 0xB9CD, 0xBA07, 0xBA42, 
        0xBA7C, 0xBAB7, 0xBAF2, 0xBB2D, 0xBB68, 0xBBA3, 0xBBDF, 0xBC1B, 
        0xBC56, 0xBC92, 0xBCCF, 0xBD0B, 0xBD47, 0xBD84, 0xBDC1, 0xBDFE, 
        0xBE3B, 0xBE78, 0xBEB6, 0xBEF3, 0xBF31, 0xBF6F, 0xBFAE, 0xBFEC, 
        0xC02A, 0xC069, 0xC0A8, 0xC0E7, 0xC126, 0xC166, 0xC1A5, 0xC1E5, 
        0xC225, 0xC265, 0xC2A5, 0xC2E6, 0xC326, 0xC367, 0xC3A8, 0xC3E9, 
        0xC42A, 0xC46C, 0xC4AD, 0xC4EF, 0xC531, 0xC572, 0xC5B4, 0xC5F7, 
        0xC639, 0xC67B, 0xC6BE, 0xC700, 0xC743, 0xC786, 0xC7C9, 0xC80C, 
        0xC84F, 0xC892, 0xC8D6, 0xC919, 0xC95C, 0xC9A0, 0xC9E4, 0xCA27, 
        0xCA6B, 0xCAAF, 0xCAF3, 0xCB36, 0xCB7A, 0xCBBE, 0xCC02, 0xCC46, 
        0xCC8A, 0xCCCE, 0xCD12, 0xCD56, 0xCD9A, 0xCDDE, 0xCE22, 0xCE66, 
        0xCEAA, 0xCEEE, 0xCF32, 0xCF76, 0xCFBA, 0xCFFE, 0xD042, 0xD086, 
        0xD0C9, 0xD10D, 0xD151, 0xD194, 0xD1D7, 0xD21B, 0xD25E, 0xD2A1, 
        0xD2E5, 0xD328, 0xD36B, 0xD3AD, 0xD3F0, 0xD433, 0xD475, 0xD4B8, 
        0xD4FA, 0xD53C, 0xD57F, 0xD5C1, 0xD602, 0xD644, 0xD686, 0xD6C7, 
        0xD709, 0xD74A, 0xD78B, 0xD7CC, 0xD80D, 0xD84E, 0xD88E, 0xD8CF, 
        0xD90F, 0xD94F, 0xD98F, 0xD9CF, 0xDA0F, 0xDA4F, 0xDA8E, 0xDACE, 
        0xDB0D, 0xDB4C, 0xDB8B, 0xDBCA, 0xDC08, 0xDC47, 0xDC85, 0xDCC4, 
        0xDD02, 0xDD40, 0xDD7E, 0xDDBC, 0xDDF9, 0xDE37, 0xDE74, 0xDEB1, 
        0xDEEE, 0xDF2B, 0xDF68, 0xDFA5, 0xDFE2, 0xE01F, 0xE05B, 0xE097, 
        0xE0D4, 0xE110, 0xE14C, 0xE188, 0xE1C4, 0xE200, 0xE23C, 0xE277, 
        0xE2B3, 0xE2EE, 0xE32A, 0xE365, 0xE3A1, 0xE3DC, 0xE417, 0xE453, 
        0xE48E, 0xE4C9, 0xE504, 0xE53F, 0xE57A, 0xE5B5, 0xE5F0, 0xE62B, 
        0xE666, 0xE6A1, 0xE6DC, 0xE717, 0xE752, 0xE78D, 0xE7C8, 0xE803, 
        0xE83E, 0xE879, 0xE8B4, 0xE8F0, 0xE92B, 0xE966, 0xE9A1, 0xE9DD, 
        0xEA18, 0xEA53, 0xEA8F, 0xEACA, 0xEB06, 0xEB42, 0xEB7D, 0xEBB9, 
        0xEBF5, 0xEC31, 0xEC6D, 0xECA9, 0xECE5, 0xED22, 0xED5E, 0xED9B, 
        0xEDD7, 0xEE14, 0xEE51, 0xEE8E, 0xEECB, 0xEF08, 0xEF45, 0xEF83, 
        0xEFC0, 0xEFFE, 0xF03B, 0xF079, 0xF0B7, 0xF0F5, 0xF133, 0xF172, 
        0xF1B0, 0xF1EF, 0xF22D, 0xF26C, 0xF2AB, 0xF2EA, 0xF329, 0xF369, 
        0xF3A8, 0xF3E8, 0xF427, 0xF467, 0xF4A7, 0xF4E7, 0xF527, 0xF568, 
        0xF5A8, 0xF5E9, 0xF629, 0xF66A, 0xF6AB, 0xF6EC, 0xF72D, 0xF76E, 
        0xF7AF, 0xF7F1, 0xF832, 0xF874, 0xF8B6, 0xF8F7, 0xF939, 0xF97B, 
        0xF9BD, 0xFA00, 0xFA42, 0xFA84, 0xFAC6, 0xFB09, 0xFB4B, 0xFB8E, 
        0xFBD1, 0xFC13, 0xFC56, 0xFC99, 0xFCDC, 0xFD1F, 0xFD62, 0xFDA5, 
        0xFDE8, 0xFE2B, 0xFE6E, 0xFEB1, 0xFEF4, 0xFF37, 0xFF7A, 0xFFBD, 
// Waveform 2:
        0x0000, 0x00DD, 0x01BA, 0x0297, 0x0374, 0x0451, 0x052D, 0x060A, 
        0x06E6, 0x07C2, 0x089E, 0x0979, 0x0A55, 0x0B2F, 0x0C0A, 0x0CE4, 
        0x0DBD, 0x0E96, 0x0F6E, 0x1046, 0x111E, 0x11F4, 0x12CA, 0x13A0, 
        0x1474, 0x1548, 0x161B, 0x16EE, 0x17BF, 0x1890, 0x1960, 0x1A2F, 
        0x1AFD, 0x1BCA, 0x1C96, 0x1D61, 0x1E2B, 0x1EF4, 0x1FBC, 0x2083, 
        0x2148, 0x220D, 0x22D0, 0x2392, 0x2453, 0x2512, 0x25D0, 0x268D, 
        0x2749, 0x2803, 0x28BC, 0x2973, 0x2A29, 0x2ADD, 0x2B90, 0x2C42, 
        0x2CF2, 0x2DA0, 0x2E4D, 0x2EF8, 0x2FA1, 0x3049, 0x30EF, 0x3194, 
        0x3237, 0x32D8, 0x3377, 0x3415, 0x34B1, 0x354B, 0x35E3, 0x367A, 
        0x370F, 0x37A1, 0x3832, 0x38C1, 0x394F, 0x39DA, 0x3A63, 0x3AEB, 
        0x3B70, 0x3BF3, 0x3C75, 0x3CF4, 0x3D72, 0x3DED, 0x3E67, 0x3EDE, 
        0x3F54, 0x3FC7, 0x4038, 0x40A7, 0x4115, 0x4180, 0x41E9, 0x424F, 
        0x42B4, 0x4317, 0x4377, 0x43D6, 0x4432, 0x448C, 0x44E4, 0x453A, 
        0x458E, 0x45DF, 0x462E, 0x467C, 0x46C7, 0x4710, 0x4757, 0x479B, 
        0x47DE, 0x481E, 0x485C, 0x4898, 0x48D2, 0x490A, 0x4940, 0x4973, 
        0x49A5, 0x49D4, 0x4A01, 0x4A2C, 0x4A55, 0x4A7C, 0x4AA0, 0x4AC3, 
        0x4AE3, 0x4B02, 0x4B1E, 0x4B38, 0x4B51, 0x4B67, 0x4B7B, 0x4B8D, 
        0x4B9D, 0x4BAC, 0x4BB8, 0x4BC2, 0x4BCA, 0x4BD0, 0x4BD5, 0x4BD7, 
        0x4BD8, 0x4BD6, 0x4BD3, 0x4BCE, 0x4BC7, 0x4BBE, 0x4BB3, 0x4BA7, 
        0x4B99, 0x4B89, 0x4B77, 0x4B63, 0x4B4E, 0x4B37, 0x4B1F, 0x4B04, 
        0x4AE8, 0x4ACB, 0x4AAC, 0x4A8B, 0x4A69, 0x4A45, 0x4A20, 0x49F9, 
        0x49D0, 0x49A7, 0x497B, 0x494F, 0x4921, 0x48F1, 0x48C1, 0x488E, 
        0x485B, 0x4826, 0x47F1, 0x47B9, 0x4781, 0x4748, 0x470D, 0x46D1, 
        0x4694, 0x4656, 0x4617, 0x45D7, 0x4596, 0x4554, 0x4511, 0x44CE, 
        0x4489, 0x4443, 0x43FD, 0x43B6, 0x436E, 0x4325, 0x42DB, 0x4291, 
        0x4246, 0x41FA, 0x41AE, 0x4161, 0x4114, 0x40C6, 0x4078, 0x4029, 
        0x3FDA, 0x3F8A, 0x3F3A, 0x3EE9, 0x3E98, 0x3E47, 0x3DF6, 0x3DA4, 
        0x3D52, 0x3D00, 0x3CAD, 0x3C5B, 0x3C08, 0x3BB6, 0x3B63, 0x3B10, 
        0x3ABD, 0x3A6A, 0x3A18, 0x39C5, 0x3972, 0x3920, 0x38CE, 0x387C, 
        0x382A, 0x37D8, 0x3787, 0x3736, 0x36E5, 0x3694, 0x3644, 0x35F5, 
        0x35A6, 0x3557, 0x3508, 0x34BB, 0x346D, 0x3421, 0x33D5, 0x3389, 
        0x333E, 0x32F4, 0x32AA, 0x3261, 0x3219, 0x31D2, 0x318B, 0x3145, 
        0x3100, 0x30BC, 0x3079, 0x3036, 0x2FF4, 0x2FB4, 0x2F74, 0x2F35, 
        0x2EF8, 0x2EBB, 0x2E7F, 0x2E44, 0x2E0B, 0x2DD2, 0x2D9B, 0x2D65, 
        0x2D2F, 0x2CFB, 0x2CC9, 0x2C97, 0x2C67, 0x2C37, 0x2C09, 0x2BDD, 
        0x2BB1, 0x2B87, 0x2B5E, 0x2B37, 0x2B11, 0x2AEC, 0x2AC8, 0x2AA6, 
        0x2A86, 0x2A66, 0x2A48, 0x2A2C, 0x2A11, 0x29F7, 0x29DF, 0x29C9, 
        0x29B4, 0x29A0, 0x298E, 0x297D, 0x296E, 0x2960, 0x2954, 0x2949, 
        0x2940, 0x2939, 0x2933, 0x292F, 0x292C, 0x292A, 0x292B, 0x292D, 
        0x2930, 0x2935, 0x293C, 0x2944, 0x294E, 0x2959, 0x2966, 0x2975, 
        0x2985, 0x2997, 0x29AA, 0x29BF, 0x29D6, 0x29EE, 0x2A08, 0x2A23, 
        0x2A40, 0x2A5F, 0x2A7F, 0x2AA0, 0x2AC3, 0x2AE8, 0x2B0E, 0x2B36, 
        0x2B60, 0x2B8B, 0x2BB7, 0x2BE5, 0x2C15, 0x2C46, 0x2C78, 0x2CAC, 
        0x2CE2, 0x2D19, 0x2D51, 0x2D8B, 0x2DC6, 0x2E03, 0x2E41, 0x2E81, 
        0x2EC2, 0x2F04, 0x2F48, 0x2F8D, 0x2FD3, 0x301B, 0x3064, 0x30AE, 
        0x30FA, 0x3147, 0x3195, 0x31E4, 0x3235, 0x3287, 0x32DA, 0x332E, 
        0x3383, 0x33DA, 0x3432, 0x348A, 0x34E4, 0x353F, 0x359B, 0x35F8, 
        0x3656, 0x36B5, 0x3715, 0x3776, 0x37D7, 0x383A, 0x389E, 0x3902, 
        0x3968, 0x39CE, 0x3A35, 0x3A9C, 0x3B05, 0x3B6E, 0x3BD8, 0x3C43, 
        0x3CAE, 0x3D1A, 0x3D87, 0x3DF4, 0x3E61, 0x3ED0, 0x3F3F, 0x3FAE, 
        0x401E, 0x408E, 0x40FF, 0x4170, 0x41E1, 0x4253, 0x42C6, 0x4338, 
        0x43AB, 0x441E, 0x4491, 0x4505, 0x4578, 0x45EC, 0x4660, 0x46D4, 
        0x4749, 0x47BD, 0x4831, 0x48A5, 0x491A, 0x498E, 0x4A02, 0x4A76, 
        0x4AEA, 0x4B5E, 0x4BD2, 0x4C45, 0x4CB8, 0x4D2B, 0x4D9E, 0x4E10, 
        0x4E82, 0x4EF4, 0x4F66, 0x4FD6, 0x5047, 0x50B7, 0x5127, 0x5196, 
        0x5205, 0x5273, 0x52E0, 0x534D, 0x53B9, 0x5425, 0x5490, 0x54FA, 
        0x5564, 0x55CD, 0x5635, 0x569C, 0x5702, 0x5768, 0x57CD, 0x5831, 
        0x5894, 0x58F6, 0x5957, 0x59B7, 0x5A17, 0x5A75, 0x5AD2, 0x5B2E, 
        0x5B89, 0x5BE3, 0x5C3C, 0x5C94, 0x5CEB, 0x5D40, 0x5D94, 0x5DE7, 
        0x5E39, 0x5E8A, 0x5ED9, 0x5F27, 0x5F74, 0x5FC0, 0x600A, 0x6052, 
        0x609A, 0x60E0, 0x6125, 0x6168, 0x61AA, 0x61EA, 0x6229, 0x6266, 
        0x62A2, 0x62DD, 0x6316, 0x634D, 0x6383, 0x63B7, 0x63EA, 0x641B, 
        0x644B, 0x6479, 0x64A5, 0x64D0, 0x64F9, 0x6521, 0x6547, 0x656B, 
        0x658D, 0x65AE, 0x65CE, 0x65EB, 0x6607, 0x6621, 0x6639, 0x6650, 
        0x6665, 0x6678, 0x668A, 0x669A, 0x66A8, 0x66B4, 0x66BE, 0x66C7, 
        0x66CE, 0x66D4, 0x66D7, 0x66D9, 0x66D9, 0x66D7, 0x66D3, 0x66CE, 
        0x66C7, 0x66BE, 0x66B4, 0x66A7, 0x6699, 0x6689, 0x6678, 0x6664, 
        0x664F, 0x6638, 0x6620, 0x6605, 0x65E9, 0x65CB, 0x65AC, 0x658A, 
        0x6567, 0x6543, 0x651C, 0x64F4, 0x64CA, 0x649F, 0x6472, 0x6443, 
        0x6412, 0x63E0, 0x63AC, 0x6377, 0x6340, 0x6307, 0x62CD, 0x6291, 
        0x6254, 0x6215, 0x61D4, 0x6192, 0x614F, 0x610A, 0x60C3, 0x607B, 
        0x6032, 0x5FE7, 0x5F9A, 0x5F4C, 0x5EFD, 0x5EAC, 0x5E5A, 0x5E07, 
        0x5DB2, 0x5D5C, 0x5D04, 0x5CAB, 0x5C51, 0x5BF6, 0x5B99, 0x5B3C, 
        0x5ADC, 0x5A7C, 0x5A1B, 0x59B8, 0x5954, 0x58EF, 0x5889, 0x5822, 
        0x57BA, 0x5751, 0x56E7, 0x567B, 0x560F, 0x55A2, 0x5534, 0x54C5, 
        0x5455, 0x53E4, 0x5372, 0x52FF, 0x528C, 0x5218, 0x51A3, 0x512D, 
        0x50B6, 0x503F, 0x4FC7, 0x4F4F, 0x4ED5, 0x4E5B, 0x4DE1, 0x4D66, 
        0x4CEA, 0x4C6E, 0x4BF1, 0x4B74, 0x4AF7, 0x4A79, 0x49FA, 0x497B, 
        0x48FC, 0x487C, 0x47FC, 0x477C, 0x46FC, 0x467B, 0x45FA, 0x4578, 
        0x44F7, 0x4475, 0x43F4, 0x4372, 0x42F0, 0x426E, 0x41EB, 0x4169, 
        0x40E7, 0x4065, 0x3FE3, 0x3F61, 0x3EDF, 0x3E5D, 0x3DDB, 0x3D59, 
        0x3CD8, 0x3C57, 0x3BD6, 0x3B55, 0x3AD4, 0x3A54, 0x39D4, 0x3954, 
        0x38D5, 0x3856, 0x37D8, 0x3759, 0x36DC, 0x365E, 0x35E2, 0x3565, 
        0x34E9, 0x346E, 0x33F3, 0x3379, 0x3300, 0x3286, 0x320E, 0x3196, 
        0x311F, 0x30A9, 0x3033, 0x2FBE, 0x2F4A, 0x2ED6, 0x2E63, 0x2DF1, 
        0x2D80, 0x2D10, 0x2CA0, 0x2C32, 0x2BC4, 0x2B57, 0x2AEB, 0x2A7F, 
        0x2A15, 0x29AC, 0x2943, 0x28DC, 0x2876, 0x2810, 0x27AC, 0x2748, 
        0x26E6, 0x2684, 0x2624, 0x25C5, 0x2567, 0x2509, 0x24AD, 0x2452, 
        0x23F9, 0x23A0, 0x2348, 0x22F2, 0x229D, 0x2249, 0x21F6, 0x21A4, 
        0x2153, 0x2104, 0x20B6, 0x2069, 0x201D, 0x1FD2, 0x1F89, 0x1F41, 
        0x1EFA, 0x1EB4, 0x1E70, 0x1E2D, 0x1DEB, 0x1DAA, 0x1D6B, 0x1D2D, 
        0x1CF0, 0x1CB4, 0x1C7A, 0x1C41, 0x1C09, 0x1BD2, 0x1B9D, 0x1B69, 
        0x1B36, 0x1B05, 0x1AD4, 0x1AA5, 0x1A78, 0x1A4B, 0x1A20, 0x19F6, 
        0x19CD, 0x19A6, 0x197F, 0x195A, 0x1937, 0x1914, 0x18F3, 0x18D3, 
        0x18B4, 0x1896, 0x187A, 0x185F, 0x1845, 0x182C, 0x1814, 0x17FE, 
        0x17E8, 0x17D4, 0x17C1, 0x17AF, 0x179F, 0x178F, 0x1780, 0x1773, 
        0x1767, 0x175B, 0x1751, 0x1748, 0x1740, 0x1739, 0x1733, 0x172E, 
        0x172A, 0x1727, 0x1725, 0x1724, 0x1724, 0x1725, 0x1727, 0x172A, 
        0x172D, 0x1732, 0x1737, 0x173D, 0x1744, 0x174C, 0x1755, 0x175F, 
        0x1769, 0x1774, 0x1780, 0x178C, 0x179A, 0x17A8, 0x17B6, 0x17C6, 
        0x17D6, 0x17E6, 0x17F8, 0x180A, 0x181C, 0x182F, 0x1843, 0x1857, 
        0x186C, 0x1881, 0x1896, 0x18AC, 0x18C3, 0x18DA, 0x18F1, 0x1909, 
        0x1921, 0x193A, 0x1953, 0x196C, 0x1986, 0x199F, 0x19B9, 0x19D4, 
        0x19EE, 0x1A09, 0x1A24, 0x1A3F, 0x1A5A, 0x1A76, 0x1A91, 0x1AAD, 
        0x1AC8, 0x1AE4, 0x1B00, 0x1B1C, 0x1B37, 0x1B53, 0x1B6F, 0x1B8B, 
        0x1BA6, 0x1BC2, 0x1BDD, 0x1BF9, 0x1C14, 0x1C2F, 0x1C4A, 0x1C64, 
        0x1C7F, 0x1C99, 0x1CB3, 0x1CCC, 0x1CE6, 0x1CFF, 0x1D17, 0x1D30, 
        0x1D48, 0x1D5F, 0x1D77, 0x1D8D, 0x1DA4, 0x1DBA, 0x1DCF, 0x1DE4, 
        0x1DF9, 0x1E0D, 0x1E20, 0x1E33, 0x1E46, 0x1E58, 0x1E69, 0x1E7A, 
        0x1E8A, 0x1E99, 0x1EA8, 0x1EB6, 0x1EC4, 0x1ED0, 0x1EDC, 0x1EE8, 
        0x1EF2, 0x1EFC, 0x1F05, 0x1F0E, 0x1F15, 0x1F1C, 0x1F22, 0x1F27, 
        0x1F2C, 0x1F2F, 0x1F32, 0x1F34, 0x1F35, 0x1F35, 0x1F34, 0x1F33, 
        0x1F30, 0x1F2D, 0x1F28, 0x1F23, 0x1F1C, 0x1F15, 0x1F0D, 0x1F04, 
        0x1EFA, 0x1EEF, 0x1EE2, 0x1ED5, 0x1EC7, 0x1EB8, 0x1EA8, 0x1E97, 
        0x1E85, 0x1E72, 0x1E5D, 0x1E48, 0x1E32, 0x1E1B, 0x1E02, 0x1DE9, 
        0x1DCE, 0x1DB3, 0x1D96, 0x1D79, 0x1D5A, 0x1D3A, 0x1D1A, 0x1CF8, 
        0x1CD5, 0x1CB1, 0x1C8C, 0x1C66, 0x1C3E, 0x1C16, 0x1BED, 0x1BC2, 
        0x1B97, 0x1B6A, 0x1B3D, 0x1B0E, 0x1ADF, 0x1AAE, 0x1A7C, 0x1A4A, 
        0x1A16, 0x19E1, 0x19AB, 0x1974, 0x193C, 0x1904, 0x18CA, 0x188F, 
        0x1853, 0x1816, 0x17D8, 0x1799, 0x175A, 0x1719, 0x16D7, 0x1695, 
        0x1651, 0x160D, 0x15C7, 0x1581, 0x153A, 0x14F2, 0x14A9, 0x145F, 
        0x1414, 0x13C9, 0x137D, 0x132F, 0x12E1, 0x1293, 0x1243, 0x11F3, 
        0x11A2, 0x1150, 0x10FD, 0x10AA, 0x1056, 0x1001, 0x0FAC, 0x0F56, 
        0x0EFF, 0x0EA7, 0x0E4F, 0x0DF7, 0x0D9D, 0x0D44, 0x0CE9, 0x0C8E, 
        0x0C33, 0x0BD7, 0x0B7A, 0x0B1D, 0x0ABF, 0x0A61, 0x0A03, 0x09A4, 
        0x0944, 0x08E5, 0x0884, 0x0824, 0x07C3, 0x0762, 0x0700, 0x069E, 
        0x063C, 0x05DA, 0x0577, 0x0514, 0x04B1, 0x044E, 0x03EA, 0x0386, 
        0x0322, 0x02BE, 0x025A, 0x01F6, 0x0191, 0x012D, 0x00C9, 0x0064, 
        0x0000, 0xFF9C, 0xFF38, 0xFED3, 0xFE6F, 0xFE0A, 0xFDA6, 0xFD42, 
        0xFCDE, 0xFC7A, 0xFC16, 0xFBB3, 0xFB4F, 0xFAEC, 0xFA89, 0xFA26, 
        0xF9C4, 0xF962, 0xF900, 0xF89E, 0xF83D, 0xF7DC, 0xF77C, 0xF71B, 
        0xF6BC, 0xF65C, 0xF5FD, 0xF59F, 0xF541, 0xF4E3, 0xF486, 0xF42A, 
        0xF3CD, 0xF372, 0xF317, 0xF2BC, 0xF263, 0xF209, 0xF1B1, 0xF159, 
        0xF101, 0xF0AA, 0xF054, 0xEFFF, 0xEFAA, 0xEF56, 0xEF03, 0xEEB0, 
        0xEE5E, 0xEE0D, 0xEDBD, 0xED6D, 0xED1F, 0xECD1, 0xEC84, 0xEC37, 
        0xEBEC, 0xEBA1, 0xEB57, 0xEB0E, 0xEAC6, 0xEA7F, 0xEA39, 0xE9F3, 
        0xE9AF, 0xE96B, 0xE929, 0xE8E7, 0xE8A6, 0xE867, 0xE828, 0xE7EA, 
        0xE7AD, 0xE771, 0xE736, 0xE6FD, 0xE6C4, 0xE68C, 0xE655, 0xE61F, 
        0xE5EA, 0xE5B6, 0xE584, 0xE552, 0xE521, 0xE4F2, 0xE4C3, 0xE496, 
        0xE469, 0xE43E, 0xE413, 0xE3EA, 0xE3C2, 0xE39B, 0xE374, 0xE34F, 
        0xE32B, 0xE308, 0xE2E7, 0xE2C6, 0xE2A6, 0xE287, 0xE26A, 0xE24D, 
        0xE232, 0xE217, 0xE1FE, 0xE1E5, 0xE1CE, 0xE1B8, 0xE1A3, 0xE18E, 
        0xE17B, 0xE169, 0xE158, 0xE148, 0xE139, 0xE12B, 0xE11E, 0xE111, 
        0xE106, 0xE0FC, 0xE0F3, 0xE0EB, 0xE0E4, 0xE0DD, 0xE0D8, 0xE0D3, 
        0xE0D0, 0xE0CD, 0xE0CC, 0xE0CB, 0xE0CB, 0xE0CC, 0xE0CE, 0xE0D1, 
        0xE0D4, 0xE0D9, 0xE0DE, 0xE0E4, 0xE0EB, 0xE0F2, 0xE0FB, 0xE104, 
        0xE10E, 0xE118, 0xE124, 0xE130, 0xE13C, 0xE14A, 0xE158, 0xE167, 
        0xE176, 0xE186, 0xE197, 0xE1A8, 0xE1BA, 0xE1CD, 0xE1DF, 0xE1F3, 
        0xE207, 0xE21C, 0xE231, 0xE246, 0xE25C, 0xE273, 0xE289, 0xE2A1, 
        0xE2B8, 0xE2D0, 0xE2E9, 0xE301, 0xE31A, 0xE334, 0xE34D, 0xE367, 
        0xE381, 0xE39C, 0xE3B6, 0xE3D1, 0xE3EC, 0xE407, 0xE423, 0xE43E, 
        0xE45A, 0xE475, 0xE491, 0xE4AD, 0xE4C9, 0xE4E4, 0xE500, 0xE51C, 
        0xE538, 0xE553, 0xE56F, 0xE58A, 0xE5A6, 0xE5C1, 0xE5DC, 0xE5F7, 
        0xE612, 0xE62C, 0xE647, 0xE661, 0xE67A, 0xE694, 0xE6AD, 0xE6C6, 
        0xE6DF, 0xE6F7, 0xE70F, 0xE726, 0xE73D, 0xE753, 0xE76A, 0xE77F, 
        0xE794, 0xE7A9, 0xE7BD, 0xE7D1, 0xE7E4, 0xE7F6, 0xE808, 0xE81A, 
        0xE82A, 0xE83A, 0xE84A, 0xE858, 0xE866, 0xE874, 0xE880, 0xE88C, 
        0xE897, 0xE8A1, 0xE8AB, 0xE8B4, 0xE8BC, 0xE8C3, 0xE8C9, 0xE8CE, 
        0xE8D3, 0xE8D6, 0xE8D9, 0xE8DB, 0xE8DC, 0xE8DC, 0xE8DB, 0xE8D9, 
        0xE8D6, 0xE8D2, 0xE8CD, 0xE8C7, 0xE8C0, 0xE8B8, 0xE8AF, 0xE8A5, 
        0xE899, 0xE88D, 0xE880, 0xE871, 0xE861, 0xE851, 0xE83F, 0xE82C, 
        0xE818, 0xE802, 0xE7EC, 0xE7D4, 0xE7BB, 0xE7A1, 0xE786, 0xE76A, 
        0xE74C, 0xE72D, 0xE70D, 0xE6EC, 0xE6C9, 0xE6A6, 0xE681, 0xE65A, 
        0xE633, 0xE60A, 0xE5E0, 0xE5B5, 0xE589, 0xE55B, 0xE52C, 0xE4FC, 
        0xE4CA, 0xE497, 0xE463, 0xE42E, 0xE3F7, 0xE3BF, 0xE386, 0xE34C, 
        0xE310, 0xE2D3, 0xE295, 0xE256, 0xE215, 0xE1D3, 0xE190, 0xE14C, 
        0xE106, 0xE0BF, 0xE077, 0xE02E, 0xDFE3, 0xDF97, 0xDF4A, 0xDEFC, 
        0xDEAD, 0xDE5C, 0xDE0A, 0xDDB7, 0xDD63, 0xDD0E, 0xDCB8, 0xDC60, 
        0xDC07, 0xDBAE, 0xDB53, 0xDAF7, 0xDA9A, 0xDA3B, 0xD9DC, 0xD97C, 
        0xD91A, 0xD8B8, 0xD855, 0xD7F0, 0xD78B, 0xD724, 0xD6BD, 0xD654, 
        0xD5EB, 0xD581, 0xD516, 0xD4A9, 0xD43C, 0xD3CF, 0xD360, 0xD2F0, 
        0xD280, 0xD20F, 0xD19D, 0xD12A, 0xD0B6, 0xD042, 0xCFCD, 0xCF57, 
        0xCEE1, 0xCE6A, 0xCDF2, 0xCD7A, 0xCD01, 0xCC87, 0xCC0D, 0xCB92, 
        0xCB17, 0xCA9B, 0xCA1F, 0xC9A2, 0xC924, 0xC8A7, 0xC829, 0xC7AA, 
        0xC72B, 0xC6AC, 0xC62C, 0xC5AC, 0xC52C, 0xC4AB, 0xC42A, 0xC3A9, 
        0xC328, 0xC2A7, 0xC225, 0xC1A3, 0xC121, 0xC09F, 0xC01D, 0xBF9B, 
        0xBF19, 0xBE97, 0xBE15, 0xBD93, 0xBD11, 0xBC8F, 0xBC0D, 0xBB8B, 
        0xBB09, 0xBA88, 0xBA06, 0xB985, 0xB905, 0xB884, 0xB804, 0xB784, 
        0xB704, 0xB685, 0xB606, 0xB588, 0xB509, 0xB48C, 0xB40F, 0xB392, 
        0xB316, 0xB29A, 0xB21F, 0xB1A5, 0xB12B, 0xB0B2, 0xB039, 0xAFC1, 
        0xAF4A, 0xAED3, 0xAE5D, 0xADE8, 0xAD74, 0xAD01, 0xAC8E, 0xAC1C, 
        0xABAB, 0xAB3B, 0xAACC, 0xAA5E, 0xA9F1, 0xA985, 0xA919, 0xA8AF, 
        0xA846, 0xA7DE, 0xA777, 0xA711, 0xA6AC, 0xA648, 0xA5E5, 0xA584, 
        0xA524, 0xA4C5, 0xA467, 0xA40A, 0xA3AF, 0xA355, 0xA2FC, 0xA2A4, 
        0xA24E, 0xA1F9, 0xA1A6, 0xA154, 0xA103, 0xA0B4, 0xA066, 0xA019, 
        0x9FCE, 0x9F85, 0x9F3D, 0x9EF6, 0x9EB1, 0x9E6E, 0x9E2C, 0x9DEB, 
        0x9DAC, 0x9D6F, 0x9D33, 0x9CF9, 0x9CC0, 0x9C89, 0x9C54, 0x9C20, 
        0x9BEE, 0x9BBD, 0x9B8E, 0x9B61, 0x9B36, 0x9B0C, 0x9AE4, 0x9ABD, 
        0x9A99, 0x9A76, 0x9A54, 0x9A35, 0x9A17, 0x99FB, 0x99E0, 0x99C8, 
        0x99B1, 0x999C, 0x9988, 0x9977, 0x9967, 0x9959, 0x994C, 0x9942, 
        0x9939, 0x9932, 0x992D, 0x9929, 0x9927, 0x9927, 0x9929, 0x992C, 
        0x9932, 0x9939, 0x9942, 0x994C, 0x9958, 0x9966, 0x9976, 0x9988, 
        0x999B, 0x99B0, 0x99C7, 0x99DF, 0x99F9, 0x9A15, 0x9A32, 0x9A52, 
        0x9A72, 0x9A95, 0x9AB9, 0x9ADF, 0x9B07, 0x9B30, 0x9B5B, 0x9B87, 
        0x9BB5, 0x9BE5, 0x9C16, 0x9C49, 0x9C7D, 0x9CB3, 0x9CEA, 0x9D23, 
        0x9D5E, 0x9D9A, 0x9DD7, 0x9E16, 0x9E56, 0x9E98, 0x9EDB, 0x9F20, 
        0x9F66, 0x9FAD, 0x9FF6, 0xA040, 0xA08C, 0xA0D9, 0xA127, 0xA176, 
        0xA1C7, 0xA218, 0xA26B, 0xA2C0, 0xA315, 0xA36C, 0xA3C4, 0xA41D, 
        0xA477, 0xA4D2, 0xA52E, 0xA58B, 0xA5E9, 0xA648, 0xA6A9, 0xA70A, 
        0xA76C, 0xA7CF, 0xA833, 0xA898, 0xA8FD, 0xA964, 0xA9CB, 0xAA33, 
        0xAA9C, 0xAB06, 0xAB70, 0xABDB, 0xAC47, 0xACB3, 0xAD20, 0xAD8D, 
        0xADFB, 0xAE6A, 0xAED9, 0xAF49, 0xAFB9, 0xB029, 0xB09A, 0xB10C, 
        0xB17D, 0xB1F0, 0xB262, 0xB2D5, 0xB348, 0xB3BB, 0xB42E, 0xB4A2, 
        0xB516, 0xB58A, 0xB5FE, 0xB672, 0xB6E6, 0xB75A, 0xB7CF, 0xB843, 
        0xB8B7, 0xB92B, 0xB9A0, 0xBA14, 0xBA87, 0xBAFB, 0xBB6F, 0xBBE2, 
        0xBC55, 0xBCC8, 0xBD3A, 0xBDAD, 0xBE1E, 0xBE90, 0xBF01, 0xBF72, 
        0xBFE2, 0xC052, 0xC0C1, 0xC130, 0xC19E, 0xC20C, 0xC279, 0xC2E6, 
        0xC352, 0xC3BD, 0xC428, 0xC492, 0xC4FB, 0xC564, 0xC5CB, 0xC632, 
        0xC698, 0xC6FE, 0xC762, 0xC7C6, 0xC828, 0xC88A, 0xC8EB, 0xC94B, 
        0xC9AA, 0xCA08, 0xCA65, 0xCAC1, 0xCB1C, 0xCB76, 0xCBCE, 0xCC26, 
        0xCC7C, 0xCCD2, 0xCD26, 0xCD79, 0xCDCB, 0xCE1C, 0xCE6B, 0xCEB9, 
        0xCF06, 0xCF52, 0xCF9C, 0xCFE5, 0xD02D, 0xD073, 0xD0B8, 0xD0FC, 
        0xD13E, 0xD17F, 0xD1BF, 0xD1FD, 0xD23A, 0xD275, 0xD2AF, 0xD2E7, 
        0xD31E, 0xD354, 0xD388, 0xD3BA, 0xD3EB, 0xD41B, 0xD449, 0xD475, 
        0xD4A0, 0xD4CA, 0xD4F1, 0xD518, 0xD53D, 0xD560, 0xD581, 0xD5A1, 
        0xD5C0, 0xD5DD, 0xD5F8, 0xD612, 0xD62A, 0xD641, 0xD656, 0xD669, 
        0xD67B, 0xD68B, 0xD69A, 0xD6A7, 0xD6B2, 0xD6BC, 0xD6C4, 0xD6CB, 
        0xD6D0, 0xD6D3, 0xD6D5, 0xD6D6, 0xD6D4, 0xD6D1, 0xD6CD, 0xD6C7, 
        0xD6C0, 0xD6B7, 0xD6AC, 0xD6A0, 0xD692, 0xD683, 0xD672, 0xD660, 
        0xD64D, 0xD637, 0xD621, 0xD609, 0xD5EF, 0xD5D4, 0xD5B8, 0xD59A, 
        0xD57A, 0xD55A, 0xD538, 0xD514, 0xD4EF, 0xD4C9, 0xD4A2, 0xD479, 
        0xD44F, 0xD423, 0xD3F7, 0xD3C9, 0xD39A, 0xD369, 0xD337, 0xD305, 
        0xD2D1, 0xD29C, 0xD265, 0xD22E, 0xD1F5, 0xD1BC, 0xD181, 0xD145, 
        0xD108, 0xD0CB, 0xD08C, 0xD04C, 0xD00C, 0xCFCA, 0xCF88, 0xCF44, 
        0xCF00, 0xCEBB, 0xCE75, 0xCE2E, 0xCDE7, 0xCD9F, 0xCD56, 0xCD0C, 
        0xCCC2, 0xCC77, 0xCC2C, 0xCBDF, 0xCB93, 0xCB45, 0xCAF8, 0xCAA9, 
        0xCA5B, 0xCA0B, 0xC9BC, 0xC96C, 0xC91B, 0xC8CA, 0xC879, 0xC828, 
        0xC7D6, 0xC784, 0xC732, 0xC6E0, 0xC68E, 0xC63B, 0xC5E8, 0xC596, 
        0xC543, 0xC4F0, 0xC49D, 0xC44B, 0xC3F8, 0xC3A5, 0xC353, 0xC300, 
        0xC2AE, 0xC25C, 0xC20B, 0xC1B9, 0xC168, 0xC117, 0xC0C6, 0xC076, 
        0xC027, 0xBFD7, 0xBF88, 0xBF3A, 0xBEEC, 0xBE9F, 0xBE52, 0xBE06, 
        0xBDBA, 0xBD6F, 0xBD25, 0xBCDB, 0xBC93, 0xBC4B, 0xBC03, 0xBBBD, 
        0xBB77, 0xBB32, 0xBAEF, 0xBAAC, 0xBA6A, 0xBA29, 0xB9E9, 0xB9AA, 
        0xB96C, 0xB92F, 0xB8F3, 0xB8B8, 0xB87F, 0xB847, 0xB80F, 0xB7DA, 
        0xB7A5, 0xB772, 0xB740, 0xB70F, 0xB6DF, 0xB6B1, 0xB685, 0xB659, 
        0xB630, 0xB607, 0xB5E0, 0xB5BB, 0xB597, 0xB575, 0xB554, 0xB535, 
        0xB518, 0xB4FC, 0xB4E1, 0xB4C9, 0xB4B2, 0xB49D, 0xB489, 0xB477, 
        0xB467, 0xB459, 0xB44D, 0xB442, 0xB439, 0xB432, 0xB42D, 0xB42A, 
        0xB428, 0xB429, 0xB42B, 0xB430, 0xB436, 0xB43E, 0xB448, 0xB454, 
        0xB463, 0xB473, 0xB485, 0xB499, 0xB4AF, 0xB4C8, 0xB4E2, 0xB4FE, 
        0xB51D, 0xB53D, 0xB560, 0xB584, 0xB5AB, 0xB5D4, 0xB5FF, 0xB62C, 
        0xB65B, 0xB68D, 0xB6C0, 0xB6F6, 0xB72E, 0xB768, 0xB7A4, 0xB7E2, 
        0xB822, 0xB865, 0xB8A9, 0xB8F0, 0xB939, 0xB984, 0xB9D1, 0xBA21, 
        0xBA72, 0xBAC6, 0xBB1C, 0xBB74, 0xBBCE, 0xBC2A, 0xBC89, 0xBCE9, 
        0xBD4C, 0xBDB1, 0xBE17, 0xBE80, 0xBEEB, 0xBF58, 0xBFC8, 0xC039, 
        0xC0AC, 0xC122, 0xC199, 0xC213, 0xC28E, 0xC30B, 0xC38B, 0xC40C, 
        0xC490, 0xC515, 0xC59D, 0xC626, 0xC6B1, 0xC73E, 0xC7CD, 0xC85E, 
        0xC8F1, 0xC986, 0xCA1C, 0xCAB5, 0xCB4F, 0xCBEB, 0xCC88, 0xCD28, 
        0xCDC9, 0xCE6C, 0xCF10, 0xCFB7, 0xD05F, 0xD108, 0xD1B3, 0xD260, 
        0xD30E, 0xD3BE, 0xD470, 0xD522, 0xD5D7, 0xD68D, 0xD744, 0xD7FD, 
        0xD8B7, 0xD972, 0xDA2F, 0xDAED, 0xDBAD, 0xDC6E, 0xDD30, 0xDDF3, 
        0xDEB7, 0xDF7D, 0xE044, 0xE10C, 0xE1D5, 0xE29F, 0xE36A, 0xE436, 
        0xE503, 0xE5D1, 0xE6A0, 0xE770, 0xE840, 0xE912, 0xE9E4, 0xEAB8, 
        0xEB8B, 0xEC60, 0xED36, 0xEE0C, 0xEEE2, 0xEFBA, 0xF091, 0xF16A, 
        0xF243, 0xF31C, 0xF3F6, 0xF4D1, 0xF5AB, 0xF686, 0xF762, 0xF83E, 
        0xF91A, 0xF9F6, 0xFAD2, 0xFBAF, 0xFC8C, 0xFD69, 0xFE46, 0xFF23, 
// Waveform 3:
        0x0000, 0xFFCE, 0xFF9C, 0xFF6A, 0xFF37, 0xFF05, 0xFED3, 0xFEA1, 
        0xFE6F, 0xFE3D, 0xFE0A, 0xFDD8, 0xFDA6, 0xFD74, 0xFD42, 0xFD10, 
        0xFCDF, 0xFCAD, 0xFC7B, 0xFC49, 0xFC18, 0xFBE6, 0xFBB5, 0xFB83, 
        0xFB52, 0xFB21, 0xFAEF, 0xFABE, 0xFA8D, 0xFA5C, 0xFA2B, 0xF9FB, 
        0xF9CA, 0xF99A, 0xF969, 0xF939, 0xF909, 0xF8D9, 0xF8A9, 0xF879, 
        0xF849, 0xF81A, 0xF7EA, 0xF7BB, 0xF78C, 0xF75D, 0xF72E, 0xF6FF, 
        0xF6D1, 0xF6A2, 0xF674, 0xF646, 0xF618, 0xF5EA, 0xF5BD, 0xF58F, 
        0xF562, 0xF535, 0xF508, 0xF4DB, 0xF4AF, 0xF483, 0xF457, 0xF42B, 
        0xF3FF, 0xF3D4, 0xF3A8, 0xF37D, 0xF352, 0xF328, 0xF2FD, 0xF2D3, 
        0xF2A9, 0xF280, 0xF256, 0xF22D, 0xF204, 0xF1DB, 0xF1B3, 0xF18A, 
        0xF162, 0xF13A, 0xF113, 0xF0EC, 0xF0C5, 0xF09E, 0xF078, 0xF051, 
        0xF02B, 0xF006, 0xEFE0, 0xEFBB, 0xEF96, 0xEF72, 0xEF4E, 0xEF2A, 
        0xEF06, 0xEEE3, 0xEEC0, 0xEE9D, 0xEE7B, 0xEE59, 0xEE37, 0xEE15, 
        0xEDF4, 0xEDD3, 0xEDB3, 0xED92, 0xED73, 0xED53, 0xED34, 0xED15, 
        0xECF6, 0xECD8, 0xECBA, 0xEC9D, 0xEC80, 0xEC63, 0xEC46, 0xEC2A, 
        0xEC0E, 0xEBF3, 0xEBD8, 0xEBBD, 0xEBA3, 0xEB89, 0xEB6F, 0xEB56, 
        0xEB3D, 0xEB25, 0xEB0D, 0xEAF5, 0xEADE, 0xEAC7, 0xEAB0, 0xEA9A, 
        0xEA84, 0xEA6F, 0xEA5A, 0xEA46, 0xEA31, 0xEA1E, 0xEA0A, 0xE9F7, 
        0xE9E5, 0xE9D3, 0xE9C1, 0xE9B0, 0xE99F, 0xE98E, 0xE97E, 0xE96F, 
        0xE95F, 0xE951, 0xE942, 0xE934, 0xE927, 0xE91A, 0xE90D, 0xE901, 
        0xE8F5, 0xE8EA, 0xE8DF, 0xE8D5, 0xE8CB, 0xE8C1, 0xE8B8, 0xE8AF, 
        0xE8A7, 0xE8A0, 0xE898, 0xE892, 0xE88B, 0xE885, 0xE880, 0xE87B, 
        0xE876, 0xE872, 0xE86F, 0xE86C, 0xE869, 0xE867, 0xE865, 0xE864, 
        0xE863, 0xE863, 0xE863, 0xE864, 0xE865, 0xE867, 0xE869, 0xE86B, 
        0xE86E, 0xE872, 0xE876, 0xE87A, 0xE87F, 0xE885, 0xE88B, 0xE891, 
        0xE898, 0xE8A0, 0xE8A8, 0xE8B0, 0xE8B9, 0xE8C3, 0xE8CD, 0xE8D7, 
        0xE8E2, 0xE8EE, 0xE8F9, 0xE906, 0xE913, 0xE920, 0xE92E, 0xE93D, 
        0xE94C, 0xE95B, 0xE96B, 0xE97C, 0xE98C, 0xE99E, 0xE9B0, 0xE9C2, 
        0xE9D5, 0xE9E9, 0xE9FD, 0xEA11, 0xEA26, 0xEA3C, 0xEA52, 0xEA69, 
        0xEA80, 0xEA97, 0xEAAF, 0xEAC8, 0xEAE1, 0xEAFB, 0xEB15, 0xEB2F, 
        0xEB4A, 0xEB66, 0xEB82, 0xEB9F, 0xEBBC, 0xEBDA, 0xEBF8, 0xEC17, 
        0xEC36, 0xEC56, 0xEC76, 0xEC97, 0xECB8, 0xECDA, 0xECFC, 0xED1F, 
        0xED42, 0xED66, 0xED8A, 0xEDAF, 0xEDD4, 0xEDFA, 0xEE20, 0xEE47, 
        0xEE6E, 0xEE96, 0xEEBF, 0xEEE7, 0xEF11, 0xEF3B, 0xEF65, 0xEF90, 
        0xEFBB, 0xEFE7, 0xF013, 0xF040, 0xF06E, 0xF09C, 0xF0CA, 0xF0F9, 
        0xF128, 0xF158, 0xF188, 0xF1B9, 0xF1EA, 0xF21C, 0xF24E, 0xF281, 
        0xF2B4, 0xF2E8, 0xF31C, 0xF351, 0xF386, 0xF3BC, 0xF3F2, 0xF429, 
        0xF460, 0xF497, 0xF4D0, 0xF508, 0xF541, 0xF57B, 0xF5B4, 0xF5EF, 
        0xF62A, 0xF665, 0xF6A1, 0xF6DD, 0xF71A, 0xF757, 0xF795, 0xF7D3, 
        0xF812, 0xF851, 0xF890, 0xF8D0, 0xF910, 0xF951, 0xF993, 0xF9D4, 
        0xFA16, 0xFA59, 0xFA9C, 0xFAE0, 0xFB24, 0xFB68, 0xFBAD, 0xFBF2, 
        0xFC38, 0xFC7E, 0xFCC4, 0xFD0B, 0xFD53, 0xFD9A, 0xFDE2, 0xFE2B, 
        0xFE74, 0xFEBE, 0xFF07, 0xFF52, 0xFF9C, 0xFFE7, 0x0032, 0x007E, 
        0x00CA, 0x0117, 0x0164, 0x01B1, 0x01FF, 0x024D, 0x029C, 0x02EB, 
        0x033A, 0x038A, 0x03DA, 0x042A, 0x047B, 0x04CC, 0x051E, 0x0570, 
        0x05C2, 0x0615, 0x0668, 0x06BB, 0x070F, 0x0763, 0x07B8, 0x080C, 
        0x0861, 0x08B7, 0x090D, 0x0963, 0x09B9, 0x0A10, 0x0A67, 0x0ABE, 
        0x0B16, 0x0B6E, 0x0BC6, 0x0C1F, 0x0C78, 0x0CD1, 0x0D2B, 0x0D85, 
        0x0DDF, 0x0E39, 0x0E94, 0x0EEF, 0x0F4B, 0x0FA6, 0x1002, 0x105E, 
        0x10BB, 0x1117, 0x1174, 0x11D2, 0x122F, 0x128D, 0x12EB, 0x1349, 
        0x13A8, 0x1406, 0x1465, 0x14C5, 0x1524, 0x1584, 0x15E4, 0x1644, 
        0x16A4, 0x1705, 0x1766, 0x17C7, 0x1828, 0x188A, 0x18EB, 0x194D, 
        0x19AF, 0x1A12, 0x1A74, 0x1AD7, 0x1B3A, 0x1B9D, 0x1C00, 0x1C63, 
        0x1CC7, 0x1D2A, 0x1D8E, 0x1DF2, 0x1E57, 0x1EBB, 0x1F1F, 0x1F84, 
        0x1FE9, 0x204E, 0x20B3, 0x2118, 0x217D, 0x21E3, 0x2248, 0x22AE, 
        0x2314, 0x237A, 0x23E0, 0x2446, 0x24AC, 0x2513, 0x2579, 0x25E0, 
        0x2646, 0x26AD, 0x2714, 0x277B, 0x27E2, 0x2849, 0x28B0, 0x2917, 
        0x297E, 0x29E6, 0x2A4D, 0x2AB4, 0x2B1C, 0x2B83, 0x2BEB, 0x2C52, 
        0x2CBA, 0x2D21, 0x2D89, 0x2DF1, 0x2E58, 0x2EC0, 0x2F28, 0x2F8F, 
        0x2FF7, 0x305F, 0x30C6, 0x312E, 0x3196, 0x31FD, 0x3265, 0x32CC, 
        0x3334, 0x339B, 0x3403, 0x346A, 0x34D2, 0x3539, 0x35A0, 0x3607, 
        0x366F, 0x36D6, 0x373D, 0x37A4, 0x380B, 0x3871, 0x38D8, 0x393F, 
        0x39A5, 0x3A0C, 0x3A72, 0x3AD8, 0x3B3F, 0x3BA5, 0x3C0B, 0x3C70, 
        0x3CD6, 0x3D3C, 0x3DA1, 0x3E06, 0x3E6C, 0x3ED1, 0x3F36, 0x3F9A, 
        0x3FFF, 0x4063, 0x40C8, 0x412C, 0x4190, 0x41F4, 0x4257, 0x42BB, 
        0x431E, 0x4381, 0x43E4, 0x4447, 0x44A9, 0x450B, 0x456E, 0x45CF, 
        0x4631, 0x4693, 0x46F4, 0x4755, 0x47B6, 0x4816, 0x4877, 0x48D7, 
        0x4937, 0x4996, 0x49F6, 0x4A55, 0x4AB4, 0x4B12, 0x4B70, 0x4BCF, 
        0x4C2C, 0x4C8A, 0x4CE7, 0x4D44, 0x4DA1, 0x4DFD, 0x4E59, 0x4EB5, 
        0x4F11, 0x4F6C, 0x4FC7, 0x5021, 0x507C, 0x50D6, 0x512F, 0x5189, 
        0x51E2, 0x523A, 0x5293, 0x52EA, 0x5342, 0x5399, 0x53F0, 0x5447, 
        0x549D, 0x54F3, 0x5549, 0x559E, 0x55F3, 0x5647, 0x569B, 0x56EF, 
        0x5742, 0x5795, 0x57E7, 0x5839, 0x588B, 0x58DC, 0x592D, 0x597E, 
        0x59CE, 0x5A1D, 0x5A6D, 0x5ABB, 0x5B0A, 0x5B58, 0x5BA5, 0x5BF2, 
        0x5C3F, 0x5C8B, 0x5CD7, 0x5D22, 0x5D6D, 0x5DB8, 0x5E02, 0x5E4B, 
        0x5E94, 0x5EDD, 0x5F25, 0x5F6D, 0x5FB4, 0x5FFB, 0x6041, 0x6086, 
        0x60CC, 0x6110, 0x6155, 0x6198, 0x61DC, 0x621E, 0x6261, 0x62A2, 
        0x62E4, 0x6324, 0x6365, 0x63A4, 0x63E3, 0x6422, 0x6460, 0x649E, 
        0x64DB, 0x6517, 0x6553, 0x658F, 0x65CA, 0x6604, 0x663E, 0x6677, 
        0x66B0, 0x66E8, 0x671F, 0x6756, 0x678D, 0x67C3, 0x67F8, 0x682D, 
        0x6861, 0x6894, 0x68C7, 0x68FA, 0x692B, 0x695D, 0x698D, 0x69BD, 
        0x69ED, 0x6A1C, 0x6A4A, 0x6A78, 0x6AA5, 0x6AD1, 0x6AFD, 0x6B28, 
        0x6B53, 0x6B7D, 0x6BA6, 0x6BCF, 0x6BF7, 0x6C1E, 0x6C45, 0x6C6B, 
        0x6C91, 0x6CB6, 0x6CDA, 0x6CFE, 0x6D21, 0x6D43, 0x6D65, 0x6D86, 
        0x6DA7, 0x6DC7, 0x6DE6, 0x6E04, 0x6E22, 0x6E3F, 0x6E5C, 0x6E78, 
        0x6E93, 0x6EAE, 0x6EC8, 0x6EE1, 0x6EF9, 0x6F11, 0x6F29, 0x6F3F, 
        0x6F55, 0x6F6A, 0x6F7F, 0x6F93, 0x6FA6, 0x6FB8, 0x6FCA, 0x6FDB, 
        0x6FEC, 0x6FFB, 0x700A, 0x7019, 0x7027, 0x7033, 0x7040, 0x704B, 
        0x7056, 0x7060, 0x706A, 0x7073, 0x707B, 0x7082, 0x7089, 0x708F, 
        0x7094, 0x7099, 0x709D, 0x70A0, 0x70A2, 0x70A4, 0x70A5, 0x70A5, 
        0x70A5, 0x70A4, 0x70A2, 0x709F, 0x709C, 0x7098, 0x7093, 0x708E, 
        0x7088, 0x7081, 0x7079, 0x7071, 0x7068, 0x705E, 0x7054, 0x7049, 
        0x703D, 0x7030, 0x7023, 0x7015, 0x7006, 0x6FF6, 0x6FE6, 0x6FD5, 
        0x6FC3, 0x6FB1, 0x6F9E, 0x6F8A, 0x6F75, 0x6F60, 0x6F4A, 0x6F33, 
        0x6F1B, 0x6F03, 0x6EEA, 0x6ED1, 0x6EB6, 0x6E9B, 0x6E7F, 0x6E62, 
        0x6E45, 0x6E27, 0x6E08, 0x6DE9, 0x6DC8, 0x6DA7, 0x6D86, 0x6D63, 
        0x6D40, 0x6D1C, 0x6CF7, 0x6CD2, 0x6CAC, 0x6C85, 0x6C5E, 0x6C35, 
        0x6C0C, 0x6BE3, 0x6BB8, 0x6B8D, 0x6B61, 0x6B35, 0x6B07, 0x6AD9, 
        0x6AAB, 0x6A7B, 0x6A4B, 0x6A1A, 0x69E8, 0x69B6, 0x6983, 0x694F, 
        0x691B, 0x68E6, 0x68B0, 0x6879, 0x6842, 0x680A, 0x67D1, 0x6798, 
        0x675E, 0x6723, 0x66E7, 0x66AB, 0x666E, 0x6631, 0x65F2, 0x65B3, 
        0x6574, 0x6533, 0x64F2, 0x64B0, 0x646E, 0x642B, 0x63E7, 0x63A2, 
        0x635D, 0x6317, 0x62D1, 0x6289, 0x6242, 0x61F9, 0x61B0, 0x6166, 
        0x611B, 0x60D0, 0x6084, 0x6037, 0x5FEA, 0x5F9C, 0x5F4D, 0x5EFE, 
        0x5EAE, 0x5E5E, 0x5E0C, 0x5DBA, 0x5D68, 0x5D15, 0x5CC1, 0x5C6C, 
        0x5C17, 0x5BC1, 0x5B6B, 0x5B14, 0x5ABC, 0x5A64, 0x5A0B, 0x59B1, 
        0x5957, 0x58FC, 0x58A1, 0x5845, 0x57E8, 0x578B, 0x572D, 0x56CF, 
        0x5670, 0x5610, 0x55AF, 0x554F, 0x54ED, 0x548B, 0x5428, 0x53C5, 
        0x5361, 0x52FD, 0x5298, 0x5232, 0x51CC, 0x5165, 0x50FE, 0x5096, 
        0x502D, 0x4FC4, 0x4F5A, 0x4EF0, 0x4E85, 0x4E1A, 0x4DAE, 0x4D42, 
        0x4CD5, 0x4C68, 0x4BFA, 0x4B8B, 0x4B1C, 0x4AAC, 0x4A3C, 0x49CB, 
        0x495A, 0x48E8, 0x4876, 0x4803, 0x4790, 0x471C, 0x46A8, 0x4633, 
        0x45BE, 0x4548, 0x44D2, 0x445B, 0x43E4, 0x436C, 0x42F4, 0x427C, 
        0x4202, 0x4189, 0x410F, 0x4094, 0x4019, 0x3F9E, 0x3F22, 0x3EA5, 
        0x3E29, 0x3DAB, 0x3D2E, 0x3CAF, 0x3C31, 0x3BB2, 0x3B33, 0x3AB3, 
        0x3A32, 0x39B2, 0x3931, 0x38AF, 0x382D, 0x37AB, 0x3728, 0x36A5, 
        0x3622, 0x359E, 0x3519, 0x3495, 0x3410, 0x338A, 0x3305, 0x327F, 
        0x31F8, 0x3171, 0x30EA, 0x3062, 0x2FDB, 0x2F52, 0x2ECA, 0x2E41, 
        0x2DB8, 0x2D2E, 0x2CA4, 0x2C1A, 0x2B8F, 0x2B04, 0x2A79, 0x29EE, 
        0x2962, 0x28D6, 0x284A, 0x27BD, 0x2730, 0x26A3, 0x2615, 0x2588, 
        0x24FA, 0x246B, 0x23DD, 0x234E, 0x22BF, 0x222F, 0x21A0, 0x2110, 
        0x2080, 0x1FF0, 0x1F5F, 0x1ECE, 0x1E3D, 0x1DAC, 0x1D1B, 0x1C89, 
        0x1BF7, 0x1B65, 0x1AD3, 0x1A41, 0x19AE, 0x191B, 0x1888, 0x17F5, 
        0x1762, 0x16CE, 0x163B, 0x15A7, 0x1513, 0x147F, 0x13EB, 0x1356, 
        0x12C2, 0x122D, 0x1198, 0x1103, 0x106E, 0x0FD9, 0x0F44, 0x0EAE, 
        0x0E19, 0x0D83, 0x0CED, 0x0C58, 0x0BC2, 0x0B2C, 0x0A96, 0x0A00, 
        0x0969, 0x08D3, 0x083D, 0x07A6, 0x0710, 0x0679, 0x05E3, 0x054C, 
        0x04B6, 0x041F, 0x0388, 0x02F1, 0x025B, 0x01C4, 0x012D, 0x0096, 
        0x0000, 0xFF6A, 0xFED3, 0xFE3C, 0xFDA5, 0xFD0F, 0xFC78, 0xFBE1, 
        0xFB4B, 0xFAB4, 0xFA1D, 0xF987, 0xF8F0, 0xF85A, 0xF7C3, 0xF72D, 
        0xF697, 0xF601, 0xF56A, 0xF4D4, 0xF43E, 0xF3A9, 0xF313, 0xF27D, 
        0xF1E7, 0xF152, 0xF0BC, 0xF027, 0xEF92, 0xEEFD, 0xEE68, 0xEDD3, 
        0xED3E, 0xECAA, 0xEC15, 0xEB81, 0xEAED, 0xEA59, 0xE9C5, 0xE932, 
        0xE89E, 0xE80B, 0xE778, 0xE6E5, 0xE652, 0xE5BF, 0xE52D, 0xE49B, 
        0xE409, 0xE377, 0xE2E5, 0xE254, 0xE1C3, 0xE132, 0xE0A1, 0xE010, 
        0xDF80, 0xDEF0, 0xDE60, 0xDDD1, 0xDD41, 0xDCB2, 0xDC23, 0xDB95, 
        0xDB07, 0xDA79, 0xD9EB, 0xD95D, 0xD8D0, 0xD843, 0xD7B7, 0xD72A, 
        0xD69E, 0xD612, 0xD587, 0xD4FC, 0xD471, 0xD3E6, 0xD35C, 0xD2D2, 
        0xD249, 0xD1BF, 0xD136, 0xD0AE, 0xD026, 0xCF9E, 0xCF16, 0xCE8F, 
        0xCE08, 0xCD82, 0xCCFB, 0xCC76, 0xCBF0, 0xCB6B, 0xCAE7, 0xCA62, 
        0xC9DF, 0xC95B, 0xC8D8, 0xC855, 0xC7D3, 0xC751, 0xC6D0, 0xC64E, 
        0xC5CE, 0xC54D, 0xC4CE, 0xC44E, 0xC3CF, 0xC351, 0xC2D3, 0xC255, 
        0xC1D8, 0xC15B, 0xC0DE, 0xC062, 0xBFE7, 0xBF6C, 0xBEF1, 0xBE77, 
        0xBDFE, 0xBD85, 0xBD0C, 0xBC94, 0xBC1C, 0xBBA5, 0xBB2E, 0xBAB8, 
        0xBA42, 0xB9CD, 0xB958, 0xB8E4, 0xB870, 0xB7FD, 0xB78A, 0xB718, 
        0xB6A6, 0xB635, 0xB5C4, 0xB554, 0xB4E4, 0xB475, 0xB407, 0xB399, 
        0xB32B, 0xB2BE, 0xB252, 0xB1E6, 0xB17B, 0xB110, 0xB0A6, 0xB03C, 
        0xAFD3, 0xAF6B, 0xAF03, 0xAE9B, 0xAE34, 0xADCE, 0xAD69, 0xAD04, 
        0xAC9F, 0xAC3B, 0xABD8, 0xAB75, 0xAB13, 0xAAB2, 0xAA51, 0xA9F0, 
        0xA991, 0xA931, 0xA8D3, 0xA875, 0xA818, 0xA7BB, 0xA75F, 0xA704, 
        0xA6A9, 0xA64F, 0xA5F5, 0xA59C, 0xA544, 0xA4EC, 0xA495, 0xA43F, 
        0xA3E9, 0xA394, 0xA33F, 0xA2EB, 0xA298, 0xA246, 0xA1F4, 0xA1A3, 
        0xA152, 0xA102, 0xA0B3, 0xA064, 0xA016, 0x9FC9, 0x9F7C, 0x9F30, 
        0x9EE5, 0x9E9A, 0x9E50, 0x9E07, 0x9DBF, 0x9D77, 0x9D2F, 0x9CE9, 
        0x9CA3, 0x9C5E, 0x9C19, 0x9BD5, 0x9B92, 0x9B50, 0x9B0E, 0x9ACD, 
        0x9A8C, 0x9A4D, 0x9A0E, 0x99CF, 0x9992, 0x9955, 0x9919, 0x98DD, 
        0x98A2, 0x9868, 0x982F, 0x97F6, 0x97BE, 0x9787, 0x9750, 0x971A, 
        0x96E5, 0x96B1, 0x967D, 0x964A, 0x9618, 0x95E6, 0x95B5, 0x9585, 
        0x9555, 0x9527, 0x94F9, 0x94CB, 0x949F, 0x9473, 0x9448, 0x941D, 
        0x93F4, 0x93CB, 0x93A2, 0x937B, 0x9354, 0x932E, 0x9309, 0x92E4, 
        0x92C0, 0x929D, 0x927B, 0x9259, 0x9238, 0x9218, 0x91F8, 0x91D9, 
        0x91BB, 0x919E, 0x9181, 0x9165, 0x914A, 0x9130, 0x9116, 0x90FD, 
        0x90E5, 0x90CD, 0x90B6, 0x90A0, 0x908B, 0x9076, 0x9062, 0x904F, 
        0x903D, 0x902B, 0x901A, 0x900A, 0x8FFA, 0x8FEB, 0x8FDD, 0x8FD0, 
        0x8FC3, 0x8FB7, 0x8FAC, 0x8FA2, 0x8F98, 0x8F8F, 0x8F87, 0x8F7F, 
        0x8F78, 0x8F72, 0x8F6D, 0x8F68, 0x8F64, 0x8F61, 0x8F5E, 0x8F5C, 
        0x8F5B, 0x8F5B, 0x8F5B, 0x8F5C, 0x8F5E, 0x8F60, 0x8F63, 0x8F67, 
        0x8F6C, 0x8F71, 0x8F77, 0x8F7E, 0x8F85, 0x8F8D, 0x8F96, 0x8FA0, 
        0x8FAA, 0x8FB5, 0x8FC0, 0x8FCC, 0x8FD9, 0x8FE7, 0x8FF6, 0x9005, 
        0x9014, 0x9025, 0x9036, 0x9048, 0x905A, 0x906D, 0x9081, 0x9096, 
        0x90AB, 0x90C1, 0x90D7, 0x90EF, 0x9107, 0x911F, 0x9138, 0x9152, 
        0x916D, 0x9188, 0x91A4, 0x91C1, 0x91DE, 0x91FC, 0x921A, 0x9239, 
        0x9259, 0x927A, 0x929B, 0x92BD, 0x92DF, 0x9302, 0x9326, 0x934A, 
        0x936F, 0x9395, 0x93BB, 0x93E2, 0x9409, 0x9431, 0x945A, 0x9483, 
        0x94AD, 0x94D8, 0x9503, 0x952F, 0x955B, 0x9588, 0x95B6, 0x95E4, 
        0x9613, 0x9643, 0x9673, 0x96A3, 0x96D4, 0x9706, 0x9739, 0x976C, 
        0x979F, 0x97D3, 0x9808, 0x983D, 0x9873, 0x98AA, 0x98E1, 0x9918, 
        0x9950, 0x9989, 0x99C2, 0x99FC, 0x9A36, 0x9A71, 0x9AAD, 0x9AE9, 
        0x9B25, 0x9B62, 0x9BA0, 0x9BDE, 0x9C1C, 0x9C5C, 0x9C9B, 0x9CDB, 
        0x9D1C, 0x9D5D, 0x9D9F, 0x9DE1, 0x9E24, 0x9E67, 0x9EAB, 0x9EEF, 
        0x9F34, 0x9F79, 0x9FBF, 0xA005, 0xA04C, 0xA093, 0xA0DB, 0xA123, 
        0xA16C, 0xA1B5, 0xA1FE, 0xA248, 0xA293, 0xA2DD, 0xA329, 0xA375, 
        0xA3C1, 0xA40D, 0xA45B, 0xA4A8, 0xA4F6, 0xA544, 0xA593, 0xA5E3, 
        0xA632, 0xA682, 0xA6D3, 0xA724, 0xA775, 0xA7C7, 0xA819, 0xA86B, 
        0xA8BE, 0xA911, 0xA965, 0xA9B9, 0xAA0D, 0xAA62, 0xAAB7, 0xAB0D, 
        0xAB63, 0xABB9, 0xAC10, 0xAC66, 0xACBE, 0xAD15, 0xAD6D, 0xADC6, 
        0xAE1E, 0xAE77, 0xAED1, 0xAF2A, 0xAF84, 0xAFDF, 0xB039, 0xB094, 
        0xB0EF, 0xB14B, 0xB1A7, 0xB203, 0xB25F, 0xB2BC, 0xB319, 0xB376, 
        0xB3D4, 0xB431, 0xB48F, 0xB4EE, 0xB54C, 0xB5AB, 0xB60A, 0xB66A, 
        0xB6C9, 0xB729, 0xB789, 0xB7EA, 0xB84A, 0xB8AB, 0xB90C, 0xB96D, 
        0xB9CF, 0xBA30, 0xBA92, 0xBAF4, 0xBB57, 0xBBB9, 0xBC1C, 0xBC7F, 
        0xBCE2, 0xBD45, 0xBDA9, 0xBE0C, 0xBE70, 0xBED4, 0xBF38, 0xBF9C, 
        0xC001, 0xC066, 0xC0CA, 0xC12F, 0xC194, 0xC1F9, 0xC25F, 0xC2C4, 
        0xC32A, 0xC38F, 0xC3F5, 0xC45B, 0xC4C1, 0xC527, 0xC58E, 0xC5F4, 
        0xC65B, 0xC6C1, 0xC728, 0xC78E, 0xC7F5, 0xC85C, 0xC8C3, 0xC92A, 
        0xC991, 0xC9F8, 0xCA60, 0xCAC7, 0xCB2E, 0xCB96, 0xCBFD, 0xCC65, 
        0xCCCC, 0xCD34, 0xCD9B, 0xCE03, 0xCE6A, 0xCED2, 0xCF3A, 0xCFA1, 
        0xD009, 0xD071, 0xD0D8, 0xD140, 0xD1A8, 0xD20F, 0xD277, 0xD2DF, 
        0xD346, 0xD3AE, 0xD415, 0xD47D, 0xD4E4, 0xD54C, 0xD5B3, 0xD61A, 
        0xD682, 0xD6E9, 0xD750, 0xD7B7, 0xD81E, 0xD885, 0xD8EC, 0xD953, 
        0xD9B9, 0xDA20, 0xDA87, 0xDAED, 0xDB53, 0xDBBA, 0xDC20, 0xDC86, 
        0xDCEC, 0xDD52, 0xDDB7, 0xDE1D, 0xDE82, 0xDEE8, 0xDF4D, 0xDFB2, 
        0xE017, 0xE07C, 0xE0E0, 0xE145, 0xE1A9, 0xE20E, 0xE272, 0xE2D5, 
        0xE339, 0xE39D, 0xE400, 0xE463, 0xE4C6, 0xE529, 0xE58C, 0xE5EE, 
        0xE651, 0xE6B3, 0xE715, 0xE776, 0xE7D8, 0xE839, 0xE89A, 0xE8FB, 
        0xE95B, 0xE9BC, 0xEA1C, 0xEA7C, 0xEADC, 0xEB3B, 0xEB9A, 0xEBF9, 
        0xEC58, 0xECB7, 0xED15, 0xED73, 0xEDD1, 0xEE2E, 0xEE8C, 0xEEE9, 
        0xEF45, 0xEFA2, 0xEFFE, 0xF05A, 0xF0B5, 0xF111, 0xF16C, 0xF1C6, 
        0xF221, 0xF27B, 0xF2D5, 0xF32F, 0xF388, 0xF3E1, 0xF439, 0xF492, 
        0xF4EA, 0xF542, 0xF599, 0xF5F0, 0xF647, 0xF69D, 0xF6F3, 0xF749, 
        0xF79F, 0xF7F4, 0xF848, 0xF89D, 0xF8F1, 0xF945, 0xF998, 0xF9EB, 
        0xFA3E, 0xFA90, 0xFAE2, 0xFB33, 0xFB85, 0xFBD6, 0xFC26, 0xFC76, 
        0xFCC6, 0xFD15, 0xFD64, 0xFDB3, 0xFE01, 0xFE4F, 0xFE9C, 0xFEE9, 
        0xFF36, 0xFF82, 0xFFCE, 0x0019, 0x0064, 0x00AE, 0x00F9, 0x0142, 
        0x018C, 0x01D5, 0x021D, 0x0266, 0x02AD, 0x02F5, 0x033C, 0x0382, 
        0x03C8, 0x040E, 0x0453, 0x0498, 0x04DC, 0x0520, 0x0564, 0x05A7, 
        0x05E9, 0x062C, 0x066D, 0x06AF, 0x06EF, 0x0730, 0x0770, 0x07AF, 
        0x07EE, 0x082D, 0x086B, 0x08A9, 0x08E6, 0x0923, 0x095F, 0x099B, 
        0x09D6, 0x0A11, 0x0A4B, 0x0A85, 0x0ABF, 0x0AF8, 0x0B30, 0x0B68, 
        0x0BA0, 0x0BD7, 0x0C0E, 0x0C44, 0x0C7A, 0x0CAF, 0x0CE4, 0x0D18, 
        0x0D4C, 0x0D7F, 0x0DB2, 0x0DE4, 0x0E16, 0x0E47, 0x0E78, 0x0EA8, 
        0x0ED8, 0x0F07, 0x0F36, 0x0F64, 0x0F92, 0x0FC0, 0x0FEC, 0x1019, 
        0x1045, 0x1070, 0x109B, 0x10C5, 0x10EF, 0x1118, 0x1141, 0x116A, 
        0x1192, 0x11B9, 0x11E0, 0x1206, 0x122C, 0x1251, 0x1276, 0x129A, 
        0x12BE, 0x12E1, 0x1304, 0x1326, 0x1348, 0x1369, 0x138A, 0x13AA, 
        0x13CA, 0x13E9, 0x1408, 0x1426, 0x1444, 0x1461, 0x147E, 0x149A, 
        0x14B6, 0x14D1, 0x14EB, 0x1505, 0x151F, 0x1538, 0x1551, 0x1569, 
        0x1580, 0x1597, 0x15AE, 0x15C4, 0x15DA, 0x15EF, 0x1603, 0x1617, 
        0x162B, 0x163E, 0x1650, 0x1662, 0x1674, 0x1684, 0x1695, 0x16A5, 
        0x16B4, 0x16C3, 0x16D2, 0x16E0, 0x16ED, 0x16FA, 0x1707, 0x1712, 
        0x171E, 0x1729, 0x1733, 0x173D, 0x1747, 0x1750, 0x1758, 0x1760, 
        0x1768, 0x176F, 0x1775, 0x177B, 0x1781, 0x1786, 0x178A, 0x178E, 
        0x1792, 0x1795, 0x1797, 0x1799, 0x179B, 0x179C, 0x179D, 0x179D, 
        0x179D, 0x179C, 0x179B, 0x1799, 0x1797, 0x1794, 0x1791, 0x178E, 
        0x178A, 0x1785, 0x1780, 0x177B, 0x1775, 0x176F, 0x1768, 0x1760, 
        0x1759, 0x1751, 0x1748, 0x173F, 0x1735, 0x172B, 0x1721, 0x1716, 
        0x170B, 0x16FF, 0x16F3, 0x16E6, 0x16D9, 0x16CC, 0x16BE, 0x16AF, 
        0x16A1, 0x1691, 0x1682, 0x1672, 0x1661, 0x1650, 0x163F, 0x162D, 
        0x161B, 0x1609, 0x15F6, 0x15E2, 0x15CF, 0x15BB, 0x15A6, 0x1591, 
        0x157C, 0x1566, 0x1550, 0x1539, 0x1522, 0x150B, 0x14F3, 0x14DB, 
        0x14C3, 0x14AA, 0x1491, 0x1477, 0x145D, 0x1443, 0x1428, 0x140D, 
        0x13F2, 0x13D6, 0x13BA, 0x139D, 0x1380, 0x1363, 0x1346, 0x1328, 
        0x130A, 0x12EB, 0x12CC, 0x12AD, 0x128D, 0x126E, 0x124D, 0x122D, 
        0x120C, 0x11EB, 0x11C9, 0x11A7, 0x1185, 0x1163, 0x1140, 0x111D, 
        0x10FA, 0x10D6, 0x10B2, 0x108E, 0x106A, 0x1045, 0x1020, 0x0FFA, 
        0x0FD5, 0x0FAF, 0x0F89, 0x0F62, 0x0F3B, 0x0F14, 0x0EED, 0x0EC6, 
        0x0E9E, 0x0E76, 0x0E4D, 0x0E25, 0x0DFC, 0x0DD3, 0x0DAA, 0x0D80, 
        0x0D57, 0x0D2D, 0x0D03, 0x0CD8, 0x0CAE, 0x0C83, 0x0C58, 0x0C2C, 
        0x0C01, 0x0BD5, 0x0BA9, 0x0B7D, 0x0B51, 0x0B25, 0x0AF8, 0x0ACB, 
        0x0A9E, 0x0A71, 0x0A43, 0x0A16, 0x09E8, 0x09BA, 0x098C, 0x095E, 
        0x092F, 0x0901, 0x08D2, 0x08A3, 0x0874, 0x0845, 0x0816, 0x07E6, 
        0x07B7, 0x0787, 0x0757, 0x0727, 0x06F7, 0x06C7, 0x0697, 0x0666, 
        0x0636, 0x0605, 0x05D5, 0x05A4, 0x0573, 0x0542, 0x0511, 0x04E0, 
        0x04AE, 0x047D, 0x044B, 0x041A, 0x03E8, 0x03B7, 0x0385, 0x0353, 
        0x0322, 0x02F0, 0x02BE, 0x028C, 0x025A, 0x0228, 0x01F6, 0x01C4, 
        0x0191, 0x015F, 0x012D, 0x00FB, 0x00C9, 0x0096, 0x0064, 0x0032, 
// Waveform 4 (sine):
        0x0000, 0x0064, 0x00C9, 0x012D, 0x0192, 0x01F6, 0x025B, 0x02BF, 
        0x0324, 0x0388, 0x03ED, 0x0451, 0x04B6, 0x051A, 0x057E, 0x05E3, 
        0x0647, 0x06AC, 0x0710, 0x0774, 0x07D9, 0x083D, 0x08A1, 0x0906, 
        0x096A, 0x09CE, 0x0A32, 0x0A97, 0x0AFB, 0x0B5F, 0x0BC3, 0x0C27, 
        0x0C8B, 0x0CEF, 0x0D53, 0x0DB7, 0x0E1B, 0x0E7F, 0x0EE3, 0x0F47, 
        0x0FAB, 0x100E, 0x1072, 0x10D6, 0x1139, 0x119D, 0x1200, 0x1264, 
        0x12C7, 0x132B, 0x138E, 0x13F2, 0x1455, 0x14B8, 0x151B, 0x157E, 
        0x15E1, 0x1644, 0x16A7, 0x170A, 0x176D, 0x17D0, 0x1833, 0x1895, 
        0x18F8, 0x195B, 0x19BD, 0x1A20, 0x1A82, 0x1AE4, 0x1B46, 0x1BA9, 
        0x1C0B, 0x1C6D, 0x1CCF, 0x1D31, 0x1D93, 0x1DF4, 0x1E56, 0x1EB8, 
        0x1F19, 0x1F7B, 0x1FDC, 0x203D, 0x209F, 0x2100, 0x2161, 0x21C2, 
        0x2223, 0x2284, 0x22E4, 0x2345, 0x23A6, 0x2406, 0x2467, 0x24C7, 
        0x2527, 0x2587, 0x25E7, 0x2647, 0x26A7, 0x2707, 0x2767, 0x27C6, 
        0x2826, 0x2885, 0x28E5, 0x2944, 0x29A3, 0x2A02, 0x2A61, 0x2AC0, 
        0x2B1E, 0x2B7D, 0x2BDB, 0x2C3A, 0x2C98, 0x2CF6, 0x2D54, 0x2DB2, 
        0x2E10, 0x2E6E, 0x2ECC, 0x2F29, 0x2F86, 0x2FE4, 0x3041, 0x309E, 
        0x30FB, 0x3158, 0x31B4, 0x3211, 0x326D, 0x32CA, 0x3326, 0x3382, 
        0x33DE, 0x343A, 0x3496, 0x34F1, 0x354D, 0x35A8, 0x3603, 0x365E, 
        0x36B9, 0x3714, 0x376F, 0x37C9, 0x3824, 0x387E, 0x38D8, 0x3932, 
        0x398C, 0x39E6, 0x3A3F, 0x3A99, 0x3AF2, 0x3B4B, 0x3BA4, 0x3BFD, 
        0x3C56, 0x3CAE, 0x3D07, 0x3D5F, 0x3DB7, 0x3E0F, 0x3E67, 0x3EBF, 
        0x3F16, 0x3F6E, 0x3FC5, 0x401C, 0x4073, 0x40CA, 0x4120, 0x4177, 
        0x41CD, 0x4223, 0x4279, 0x42CF, 0x4325, 0x437A, 0x43D0, 0x4425, 
        0x447A, 0x44CF, 0x4523, 0x4578, 0x45CC, 0x4620, 0x4674, 0x46C8, 
        0x471C, 0x476F, 0x47C3, 0x4816, 0x4869, 0x48BC, 0x490E, 0x4961, 
        0x49B3, 0x4A05, 0x4A57, 0x4AA9, 0x4AFA, 0x4B4C, 0x4B9D, 0x4BEE, 
        0x4C3F, 0x4C8F, 0x4CE0, 0x4D30, 0x4D80, 0x4DD0, 0x4E20, 0x4E6F, 
        0x4EBF, 0x4F0E, 0x4F5D, 0x4FAC, 0x4FFA, 0x5049, 0x5097, 0x50E5, 
        0x5133, 0x5180, 0x51CE, 0x521B, 0x5268, 0x52B5, 0x5301, 0x534E, 
        0x539A, 0x53E6, 0x5432, 0x547D, 0x54C9, 0x5514, 0x555F, 0x55AA, 
        0x55F4, 0x563F, 0x5689, 0x56D3, 0x571D, 0x5766, 0x57B0, 0x57F9, 
        0x5842, 0x588A, 0x58D3, 0x591B, 0x5963, 0x59AB, 0x59F3, 0x5A3A, 
        0x5A81, 0x5AC8, 0x5B0F, 0x5B56, 0x5B9C, 0x5BE2, 0x5C28, 0x5C6D, 
        0x5CB3, 0x5CF8, 0x5D3D, 0x5D82, 0x5DC6, 0x5E0B, 0x5E4F, 0x5E93, 
        0x5ED6, 0x5F1A, 0x5F5D, 0x5FA0, 0x5FE2, 0x6025, 0x6067, 0x60A9, 
        0x60EB, 0x612C, 0x616E, 0x61AF, 0x61F0, 0x6230, 0x6271, 0x62B1, 
        0x62F1, 0x6330, 0x6370, 0x63AF, 0x63EE, 0x642D, 0x646B, 0x64A9, 
        0x64E7, 0x6525, 0x6562, 0x65A0, 0x65DD, 0x6619, 0x6656, 0x6692, 
        0x66CE, 0x670A, 0x6745, 0x6781, 0x67BC, 0x67F7, 0x6831, 0x686B, 
        0x68A5, 0x68DF, 0x6919, 0x6952, 0x698B, 0x69C4, 0x69FC, 0x6A34, 
        0x6A6C, 0x6AA4, 0x6ADB, 0x6B13, 0x6B4A, 0x6B80, 0x6BB7, 0x6BED, 
        0x6C23, 0x6C58, 0x6C8E, 0x6CC3, 0x6CF8, 0x6D2C, 0x6D61, 0x6D95, 
        0x6DC9, 0x6DFC, 0x6E30, 0x6E63, 0x6E95, 0x6EC8, 0x6EFA, 0x6F2C, 
        0x6F5E, 0x6F8F, 0x6FC0, 0x6FF1, 0x7022, 0x7052, 0x7082, 0x70B2, 
        0x70E1, 0x7111, 0x7140, 0x716E, 0x719D, 0x71CB, 0x71F9, 0x7226, 
        0x7254, 0x7281, 0x72AE, 0x72DA, 0x7306, 0x7332, 0x735E, 0x7389, 
        0x73B5, 0x73DF, 0x740A, 0x7434, 0x745E, 0x7488, 0x74B1, 0x74DB, 
        0x7503, 0x752C, 0x7554, 0x757C, 0x75A4, 0x75CC, 0x75F3, 0x761A, 
        0x7640, 0x7667, 0x768D, 0x76B2, 0x76D8, 0x76FD, 0x7722, 0x7747, 
        0x776B, 0x778F, 0x77B3, 0x77D6, 0x77F9, 0x781C, 0x783F, 0x7861, 
        0x7883, 0x78A5, 0x78C6, 0x78E7, 0x7908, 0x7929, 0x7949, 0x7969, 
        0x7989, 0x79A8, 0x79C7, 0x79E6, 0x7A04, 0x7A23, 0x7A41, 0x7A5E, 
        0x7A7C, 0x7A99, 0x7AB5, 0x7AD2, 0x7AEE, 0x7B0A, 0x7B25, 0x7B41, 
        0x7B5C, 0x7B76, 0x7B91, 0x7BAB, 0x7BC4, 0x7BDE, 0x7BF7, 0x7C10, 
        0x7C29, 0x7C41, 0x7C59, 0x7C70, 0x7C88, 0x7C9F, 0x7CB6, 0x7CCC, 
        0x7CE2, 0x7CF8, 0x7D0E, 0x7D23, 0x7D38, 0x7D4D, 0x7D61, 0x7D75, 
        0x7D89, 0x7D9C, 0x7DB0, 0x7DC2, 0x7DD5, 0x7DE7, 0x7DF9, 0x7E0B, 
        0x7E1C, 0x7E2D, 0x7E3E, 0x7E4E, 0x7E5E, 0x7E6E, 0x7E7E, 0x7E8D, 
        0x7E9C, 0x7EAA, 0x7EB9, 0x7EC7, 0x7ED4, 0x7EE2, 0x7EEF, 0x7EFC, 
        0x7F08, 0x7F14, 0x7F20, 0x7F2C, 0x7F37, 0x7F42, 0x7F4C, 0x7F57, 
        0x7F61, 0x7F6A, 0x7F74, 0x7F7D, 0x7F86, 0x7F8E, 0x7F96, 0x7F9E, 
        0x7FA6, 0x7FAD, 0x7FB4, 0x7FBB, 0x7FC1, 0x7FC7, 0x7FCD, 0x7FD2, 
        0x7FD7, 0x7FDC, 0x7FE0, 0x7FE4, 0x7FE8, 0x7FEC, 0x7FEF, 0x7FF2, 
        0x7FF5, 0x7FF7, 0x7FF9, 0x7FFB, 0x7FFC, 0x7FFD, 0x7FFE, 0x7FFE, 
        0x7FFF, 0x7FFE, 0x7FFE, 0x7FFD, 0x7FFC, 0x7FFB, 0x7FF9, 0x7FF7, 
        0x7FF5, 0x7FF2, 0x7FEF, 0x7FEC, 0x7FE8, 0x7FE4, 0x7FE0, 0x7FDC, 
        0x7FD7, 0x7FD2, 0x7FCD, 0x7FC7, 0x7FC1, 0x7FBB, 0x7FB4, 0x7FAD, 
        0x7FA6, 0x7F9E, 0x7F96, 0x7F8E, 0x7F86, 0x7F7D, 0x7F74, 0x7F6A, 
        0x7F61, 0x7F57, 0x7F4C, 0x7F42, 0x7F37, 0x7F2C, 0x7F20, 0x7F14, 
        0x7F08, 0x7EFC, 0x7EEF, 0x7EE2, 0x7ED4, 0x7EC7, 0x7EB9, 0x7EAA, 
        0x7E9C, 0x7E8D, 0x7E7E, 0x7E6E, 0x7E5E, 0x7E4E, 0x7E3E, 0x7E2D, 
        0x7E1C, 0x7E0B, 0x7DF9, 0x7DE7, 0x7DD5, 0x7DC2, 0x7DB0, 0x7D9C, 
        0x7D89, 0x7D75, 0x7D61, 0x7D4D, 0x7D38, 0x7D23, 0x7D0E, 0x7CF8, 
        0x7CE2, 0x7CCC, 0x7CB6, 0x7C9F, 0x7C88, 0x7C70, 0x7C59, 0x7C41, 
        0x7C29, 0x7C10, 0x7BF7, 0x7BDE, 0x7BC4, 0x7BAB, 0x7B91, 0x7B76, 
        0x7B5C, 0x7B41, 0x7B25, 0x7B0A, 0x7AEE, 0x7AD2, 0x7AB5, 0x7A99, 
        0x7A7C, 0x7A5E, 0x7A41, 0x7A23, 0x7A04, 0x79E6, 0x79C7, 0x79A8, 
        0x7989, 0x7969, 0x7949, 0x7929, 0x7908, 0x78E7, 0x78C6, 0x78A5, 
        0x7883, 0x7861, 0x783F, 0x781C, 0x77F9, 0x77D6, 0x77B3, 0x778F, 
        0x776B, 0x7747, 0x7722, 0x76FD, 0x76D8, 0x76B2, 0x768D, 0x7667, 
        0x7640, 0x761A, 0x75F3, 0x75CC, 0x75A4, 0x757C, 0x7554, 0x752C, 
        0x7503, 0x74DB, 0x74B1, 0x7488, 0x745E, 0x7434, 0x740A, 0x73DF, 
        0x73B5, 0x7389, 0x735E, 0x7332, 0x7306, 0x72DA, 0x72AE, 0x7281, 
        0x7254, 0x7226, 0x71F9, 0x71CB, 0x719D, 0x716E, 0x7140, 0x7111, 
        0x70E1, 0x70B2, 0x7082, 0x7052, 0x7022, 0x6FF1, 0x6FC0, 0x6F8F, 
        0x6F5E, 0x6F2C, 0x6EFA, 0x6EC8, 0x6E95, 0x6E63, 0x6E30, 0x6DFC, 
        0x6DC9, 0x6D95, 0x6D61, 0x6D2C, 0x6CF8, 0x6CC3, 0x6C8E, 0x6C58, 
        0x6C23, 0x6BED, 0x6BB7, 0x6B80, 0x6B4A, 0x6B13, 0x6ADB, 0x6AA4, 
        0x6A6C, 0x6A34, 0x69FC, 0x69C4, 0x698B, 0x6952, 0x6919, 0x68DF, 
        0x68A5, 0x686B, 0x6831, 0x67F7, 0x67BC, 0x6781, 0x6745, 0x670A, 
        0x66CE, 0x6692, 0x6656, 0x6619, 0x65DD, 0x65A0, 0x6562, 0x6525, 
        0x64E7, 0x64A9, 0x646B, 0x642D, 0x63EE, 0x63AF, 0x6370, 0x6330, 
        0x62F1, 0x62B1, 0x6271, 0x6230, 0x61F0, 0x61AF, 0x616E, 0x612D, 
        0x60EB, 0x60A9, 0x6067, 0x6025, 0x5FE2, 0x5FA0, 0x5F5D, 0x5F1A, 
        0x5ED6, 0x5E93, 0x5E4F, 0x5E0B, 0x5DC6, 0x5D82, 0x5D3D, 0x5CF8, 
        0x5CB3, 0x5C6E, 0x5C28, 0x5BE2, 0x5B9C, 0x5B56, 0x5B0F, 0x5AC8, 
        0x5A81, 0x5A3A, 0x59F3, 0x59AB, 0x5963, 0x591B, 0x58D3, 0x588A, 
        0x5842, 0x57F9, 0x57B0, 0x5766, 0x571D, 0x56D3, 0x5689, 0x563F, 
        0x55F5, 0x55AA, 0x555F, 0x5514, 0x54C9, 0x547D, 0x5432, 0x53E6, 
        0x539A, 0x534E, 0x5301, 0x52B5, 0x5268, 0x521B, 0x51CE, 0x5180, 
        0x5133, 0x50E5, 0x5097, 0x5049, 0x4FFA, 0x4FAC, 0x4F5D, 0x4F0E, 
        0x4EBF, 0x4E6F, 0x4E20, 0x4DD0, 0x4D80, 0x4D30, 0x4CE0, 0x4C8F, 
        0x4C3F, 0x4BEE, 0x4B9D, 0x4B4C, 0x4AFA, 0x4AA9, 0x4A57, 0x4A05, 
        0x49B3, 0x4961, 0x490E, 0x48BC, 0x4869, 0x4816, 0x47C3, 0x476F, 
        0x471C, 0x46C8, 0x4674, 0x4620, 0x45CC, 0x4578, 0x4523, 0x44CF, 
        0x447A, 0x4425, 0x43D0, 0x437A, 0x4325, 0x42CF, 0x4279, 0x4223, 
        0x41CD, 0x4177, 0x4120, 0x40CA, 0x4073, 0x401C, 0x3FC5, 0x3F6E, 
        0x3F16, 0x3EBF, 0x3E67, 0x3E0F, 0x3DB7, 0x3D5F, 0x3D07, 0x3CAE, 
        0x3C56, 0x3BFD, 0x3BA4, 0x3B4B, 0x3AF2, 0x3A99, 0x3A3F, 0x39E6, 
        0x398C, 0x3932, 0x38D8, 0x387E, 0x3824, 0x37C9, 0x376F, 0x3714, 
        0x36B9, 0x365E, 0x3603, 0x35A8, 0x354D, 0x34F1, 0x3496, 0x343A, 
        0x33DE, 0x3382, 0x3326, 0x32CA, 0x326D, 0x3211, 0x31B4, 0x3158, 
        0x30FB, 0x309E, 0x3041, 0x2FE4, 0x2F86, 0x2F29, 0x2ECC, 0x2E6E, 
        0x2E10, 0x2DB2, 0x2D54, 0x2CF6, 0x2C98, 0x2C3A, 0x2BDC, 0x2B7D, 
        0x2B1E, 0x2AC0, 0x2A61, 0x2A02, 0x29A3, 0x2944, 0x28E5, 0x2885, 
        0x2826, 0x27C6, 0x2767, 0x2707, 0x26A7, 0x2647, 0x25E8, 0x2587, 
        0x2527, 0x24C7, 0x2467, 0x2406, 0x23A6, 0x2345, 0x22E5, 0x2284, 
        0x2223, 0x21C2, 0x2161, 0x2100, 0x209F, 0x203D, 0x1FDC, 0x1F7B, 
        0x1F19, 0x1EB8, 0x1E56, 0x1DF4, 0x1D93, 0x1D31, 0x1CCF, 0x1C6D, 
        0x1C0B, 0x1BA9, 0x1B47, 0x1AE4, 0x1A82, 0x1A20, 0x19BD, 0x195B, 
        0x18F8, 0x1895, 0x1833, 0x17D0, 0x176D, 0x170A, 0x16A7, 0x1644, 
        0x15E1, 0x157E, 0x151B, 0x14B8, 0x1455, 0x13F2, 0x138E, 0x132B, 
        0x12C7, 0x1264, 0x1200, 0x119D, 0x1139, 0x10D6, 0x1072, 0x100E, 
        0x0FAB, 0x0F47, 0x0EE3, 0x0E7F, 0x0E1B, 0x0DB7, 0x0D53, 0x0CEF, 
        0x0C8B, 0x0C27, 0x0BC3, 0x0B5F, 0x0AFB, 0x0A97, 0x0A33, 0x09CE, 
        0x096A, 0x0906, 0x08A1, 0x083D, 0x07D9, 0x0774, 0x0710, 0x06AC, 
        0x0647, 0x05E3, 0x057F, 0x051A, 0x04B6, 0x0451, 0x03ED, 0x0388, 
        0x0324, 0x02BF, 0x025B, 0x01F6, 0x0192, 0x012D, 0x00C9, 0x0064, 
        0x0000, 0xFF9C, 0xFF37, 0xFED3, 0xFE6E, 0xFE0A, 0xFDA5, 0xFD41, 
        0xFCDC, 0xFC78, 0xFC13, 0xFBAF, 0xFB4A, 0xFAE6, 0xFA82, 0xFA1D, 
        0xF9B9, 0xF954, 0xF8F0, 0xF88C, 0xF827, 0xF7C3, 0xF75F, 0xF6FA, 
        0xF696, 0xF632, 0xF5CE, 0xF569, 0xF505, 0xF4A1, 0xF43D, 0xF3D9, 
        0xF375, 0xF311, 0xF2AD, 0xF249, 0xF1E5, 0xF181, 0xF11D, 0xF0B9, 
        0xF056, 0xEFF2, 0xEF8E, 0xEF2A, 0xEEC7, 0xEE63, 0xEE00, 0xED9C, 
        0xED39, 0xECD5, 0xEC72, 0xEC0F, 0xEBAB, 0xEB48, 0xEAE5, 0xEA82, 
        0xEA1F, 0xE9BC, 0xE959, 0xE8F6, 0xE893, 0xE830, 0xE7CD, 0xE76B, 
        0xE708, 0xE6A5, 0xE643, 0xE5E1, 0xE57E, 0xE51C, 0xE4BA, 0xE457, 
        0xE3F5, 0xE393, 0xE331, 0xE2CF, 0xE26D, 0xE20C, 0xE1AA, 0xE148, 
        0xE0E7, 0xE085, 0xE024, 0xDFC3, 0xDF61, 0xDF00, 0xDE9F, 0xDE3E, 
        0xDDDD, 0xDD7C, 0xDD1C, 0xDCBB, 0xDC5A, 0xDBFA, 0xDB99, 0xDB39, 
        0xDAD9, 0xDA79, 0xDA19, 0xD9B9, 0xD959, 0xD8F9, 0xD899, 0xD83A, 
        0xD7DA, 0xD77B, 0xD71B, 0xD6BC, 0xD65D, 0xD5FE, 0xD59F, 0xD540, 
        0xD4E2, 0xD483, 0xD425, 0xD3C6, 0xD368, 0xD30A, 0xD2AC, 0xD24E, 
        0xD1F0, 0xD192, 0xD135, 0xD0D7, 0xD07A, 0xD01C, 0xCFBF, 0xCF62, 
        0xCF05, 0xCEA8, 0xCE4C, 0xCDEF, 0xCD93, 0xCD36, 0xCCDA, 0xCC7E, 
        0xCC22, 0xCBC6, 0xCB6A, 0xCB0F, 0xCAB3, 0xCA58, 0xC9FD, 0xC9A2, 
        0xC947, 0xC8EC, 0xC891, 0xC837, 0xC7DC, 0xC782, 0xC728, 0xC6CE, 
        0xC674, 0xC61A, 0xC5C1, 0xC567, 0xC50E, 0xC4B5, 0xC45C, 0xC403, 
        0xC3AA, 0xC352, 0xC2F9, 0xC2A1, 0xC249, 0xC1F1, 0xC199, 0xC141, 
        0xC0EA, 0xC092, 0xC03B, 0xBFE4, 0xBF8D, 0xBF36, 0xBEE0, 0xBE89, 
        0xBE33, 0xBDDD, 0xBD87, 0xBD31, 0xBCDB, 0xBC86, 0xBC30, 0xBBDB, 
        0xBB86, 0xBB31, 0xBADD, 0xBA88, 0xBA34, 0xB9E0, 0xB98C, 0xB938, 
        0xB8E4, 0xB891, 0xB83D, 0xB7EA, 0xB797, 0xB744, 0xB6F2, 0xB69F, 
        0xB64D, 0xB5FB, 0xB5A9, 0xB557, 0xB506, 0xB4B4, 0xB463, 0xB412, 
        0xB3C1, 0xB371, 0xB320, 0xB2D0, 0xB280, 0xB230, 0xB1E0, 0xB191, 
        0xB141, 0xB0F2, 0xB0A3, 0xB054, 0xB006, 0xAFB7, 0xAF69, 0xAF1B, 
        0xAECD, 0xAE80, 0xAE32, 0xADE5, 0xAD98, 0xAD4B, 0xACFF, 0xACB2, 
        0xAC66, 0xAC1A, 0xABCE, 0xAB83, 0xAB37, 0xAAEC, 0xAAA1, 0xAA56, 
        0xAA0C, 0xA9C1, 0xA977, 0xA92D, 0xA8E3, 0xA89A, 0xA850, 0xA807, 
        0xA7BE, 0xA776, 0xA72D, 0xA6E5, 0xA69D, 0xA655, 0xA60D, 0xA5C6, 
        0xA57F, 0xA538, 0xA4F1, 0xA4AB, 0xA464, 0xA41E, 0xA3D8, 0xA393, 
        0xA34D, 0xA308, 0xA2C3, 0xA27E, 0xA23A, 0xA1F5, 0xA1B1, 0xA16D, 
        0xA12A, 0xA0E6, 0xA0A3, 0xA060, 0xA01E, 0x9FDB, 0x9F99, 0x9F57, 
        0x9F15, 0x9ED4, 0x9E92, 0x9E51, 0x9E10, 0x9DD0, 0x9D8F, 0x9D4F, 
        0x9D0F, 0x9CD0, 0x9C90, 0x9C51, 0x9C12, 0x9BD3, 0x9B95, 0x9B57, 
        0x9B19, 0x9ADB, 0x9A9E, 0x9A60, 0x9A23, 0x99E7, 0x99AA, 0x996E, 
        0x9932, 0x98F6, 0x98BB, 0x987F, 0x9844, 0x980A, 0x97CF, 0x9795, 
        0x975B, 0x9721, 0x96E7, 0x96AE, 0x9675, 0x963C, 0x9604, 0x95CC, 
        0x9594, 0x955C, 0x9525, 0x94ED, 0x94B6, 0x9480, 0x9449, 0x9413, 
        0x93DD, 0x93A8, 0x9372, 0x933D, 0x9308, 0x92D4, 0x929F, 0x926B, 
        0x9237, 0x9204, 0x91D1, 0x919D, 0x916B, 0x9138, 0x9106, 0x90D4, 
        0x90A2, 0x9071, 0x9040, 0x900F, 0x8FDE, 0x8FAE, 0x8F7E, 0x8F4E, 
        0x8F1F, 0x8EEF, 0x8EC0, 0x8E92, 0x8E63, 0x8E35, 0x8E07, 0x8DDA, 
        0x8DAC, 0x8D7F, 0x8D52, 0x8D26, 0x8CFA, 0x8CCE, 0x8CA2, 0x8C77, 
        0x8C4C, 0x8C21, 0x8BF6, 0x8BCC, 0x8BA2, 0x8B78, 0x8B4F, 0x8B25, 
        0x8AFD, 0x8AD4, 0x8AAC, 0x8A84, 0x8A5C, 0x8A34, 0x8A0D, 0x89E6, 
        0x89C0, 0x8999, 0x8973, 0x894E, 0x8928, 0x8903, 0x88DE, 0x88B9, 
        0x8895, 0x8871, 0x884D, 0x882A, 0x8807, 0x87E4, 0x87C1, 0x879F, 
        0x877D, 0x875B, 0x873A, 0x8719, 0x86F8, 0x86D7, 0x86B7, 0x8697, 
        0x8677, 0x8658, 0x8639, 0x861A, 0x85FC, 0x85DD, 0x85BF, 0x85A2, 
        0x8584, 0x8567, 0x854B, 0x852E, 0x8512, 0x84F6, 0x84DB, 0x84BF, 
        0x84A4, 0x848A, 0x846F, 0x8455, 0x843C, 0x8422, 0x8409, 0x83F0, 
        0x83D8, 0x83BF, 0x83A7, 0x8390, 0x8378, 0x8361, 0x834A, 0x8334, 
        0x831E, 0x8308, 0x82F2, 0x82DD, 0x82C8, 0x82B3, 0x829F, 0x828B, 
        0x8277, 0x8264, 0x8251, 0x823E, 0x822B, 0x8219, 0x8207, 0x81F5, 
        0x81E4, 0x81D3, 0x81C2, 0x81B2, 0x81A2, 0x8192, 0x8182, 0x8173, 
        0x8164, 0x8156, 0x8147, 0x8139, 0x812C, 0x811E, 0x8111, 0x8104, 
        0x80F8, 0x80EC, 0x80E0, 0x80D4, 0x80C9, 0x80BE, 0x80B4, 0x80A9, 
        0x809F, 0x8096, 0x808C, 0x8083, 0x807A, 0x8072, 0x806A, 0x8062, 
        0x805A, 0x8053, 0x804C, 0x8045, 0x803F, 0x8039, 0x8033, 0x802E, 
        0x8029, 0x8024, 0x8020, 0x801C, 0x8018, 0x8014, 0x8011, 0x800E, 
        0x800B, 0x8009, 0x8007, 0x8005, 0x8004, 0x8003, 0x8002, 0x8002, 
        0x8001, 0x8002, 0x8002, 0x8003, 0x8004, 0x8005, 0x8007, 0x8009, 
        0x800B, 0x800E, 0x8011, 0x8014, 0x8018, 0x801C, 0x8020, 0x8024, 
        0x8029, 0x802E, 0x8033, 0x8039, 0x803F, 0x8045, 0x804C, 0x8053, 
        0x805A, 0x8062, 0x806A, 0x8072, 0x807A, 0x8083, 0x808C, 0x8096, 
        0x809F, 0x80A9, 0x80B4, 0x80BE, 0x80C9, 0x80D4, 0x80E0, 0x80EC, 
        0x80F8, 0x8104, 0x8111, 0x811E, 0x812C, 0x8139, 0x8147, 0x8156, 
        0x8164, 0x8173, 0x8182, 0x8192, 0x81A2, 0x81B2, 0x81C2, 0x81D3, 
        0x81E4, 0x81F5, 0x8207, 0x8219, 0x822B, 0x823E, 0x8250, 0x8264, 
        0x8277, 0x828B, 0x829F, 0x82B3, 0x82C8, 0x82DD, 0x82F2, 0x8308, 
        0x831E, 0x8334, 0x834A, 0x8361, 0x8378, 0x8390, 0x83A7, 0x83BF, 
        0x83D7, 0x83F0, 0x8409, 0x8422, 0x843C, 0x8455, 0x846F, 0x848A, 
        0x84A4, 0x84BF, 0x84DB, 0x84F6, 0x8512, 0x852E, 0x854B, 0x8567, 
        0x8584, 0x85A2, 0x85BF, 0x85DD, 0x85FB, 0x861A, 0x8639, 0x8658, 
        0x8677, 0x8697, 0x86B7, 0x86D7, 0x86F8, 0x8719, 0x873A, 0x875B, 
        0x877D, 0x879F, 0x87C1, 0x87E4, 0x8807, 0x882A, 0x884D, 0x8871, 
        0x8895, 0x88B9, 0x88DE, 0x8903, 0x8928, 0x894E, 0x8973, 0x8999, 
        0x89C0, 0x89E6, 0x8A0D, 0x8A34, 0x8A5C, 0x8A84, 0x8AAC, 0x8AD4, 
        0x8AFD, 0x8B25, 0x8B4F, 0x8B78, 0x8BA2, 0x8BCC, 0x8BF6, 0x8C21, 
        0x8C4B, 0x8C77, 0x8CA2, 0x8CCE, 0x8CFA, 0x8D26, 0x8D52, 0x8D7F, 
        0x8DAC, 0x8DDA, 0x8E07, 0x8E35, 0x8E63, 0x8E92, 0x8EC0, 0x8EEF, 
        0x8F1F, 0x8F4E, 0x8F7E, 0x8FAE, 0x8FDE, 0x900F, 0x9040, 0x9071, 
        0x90A2, 0x90D4, 0x9106, 0x9138, 0x916B, 0x919D, 0x91D0, 0x9204, 
        0x9237, 0x926B, 0x929F, 0x92D3, 0x9308, 0x933D, 0x9372, 0x93A7, 
        0x93DD, 0x9413, 0x9449, 0x9480, 0x94B6, 0x94ED, 0x9524, 0x955C, 
        0x9594, 0x95CC, 0x9604, 0x963C, 0x9675, 0x96AE, 0x96E7, 0x9721, 
        0x975B, 0x9795, 0x97CF, 0x9809, 0x9844, 0x987F, 0x98BA, 0x98F6, 
        0x9932, 0x996E, 0x99AA, 0x99E7, 0x9A23, 0x9A60, 0x9A9D, 0x9ADB, 
        0x9B19, 0x9B57, 0x9B95, 0x9BD3, 0x9C12, 0x9C51, 0x9C90, 0x9CD0, 
        0x9D0F, 0x9D4F, 0x9D8F, 0x9DD0, 0x9E10, 0x9E51, 0x9E92, 0x9ED3, 
        0x9F15, 0x9F57, 0x9F99, 0x9FDB, 0xA01D, 0xA060, 0xA0A3, 0xA0E6, 
        0xA12A, 0xA16D, 0xA1B1, 0xA1F5, 0xA23A, 0xA27E, 0xA2C3, 0xA308, 
        0xA34D, 0xA392, 0xA3D8, 0xA41E, 0xA464, 0xA4AA, 0xA4F1, 0xA538, 
        0xA57F, 0xA5C6, 0xA60D, 0xA655, 0xA69D, 0xA6E5, 0xA72D, 0xA776, 
        0xA7BE, 0xA807, 0xA850, 0xA89A, 0xA8E3, 0xA92D, 0xA977, 0xA9C1, 
        0xAA0B, 0xAA56, 0xAAA1, 0xAAEC, 0xAB37, 0xAB82, 0xABCE, 0xAC1A, 
        0xAC66, 0xACB2, 0xACFF, 0xAD4B, 0xAD98, 0xADE5, 0xAE32, 0xAE80, 
        0xAECD, 0xAF1B, 0xAF69, 0xAFB7, 0xB006, 0xB054, 0xB0A3, 0xB0F2, 
        0xB141, 0xB190, 0xB1E0, 0xB230, 0xB280, 0xB2D0, 0xB320, 0xB370, 
        0xB3C1, 0xB412, 0xB463, 0xB4B4, 0xB506, 0xB557, 0xB5A9, 0xB5FB, 
        0xB64D, 0xB69F, 0xB6F2, 0xB744, 0xB797, 0xB7EA, 0xB83D, 0xB891, 
        0xB8E4, 0xB938, 0xB98C, 0xB9E0, 0xBA34, 0xBA88, 0xBADD, 0xBB31, 
        0xBB86, 0xBBDB, 0xBC30, 0xBC86, 0xBCDB, 0xBD31, 0xBD87, 0xBDDD, 
        0xBE33, 0xBE89, 0xBEE0, 0xBF36, 0xBF8D, 0xBFE4, 0xC03B, 0xC092, 
        0xC0EA, 0xC141, 0xC199, 0xC1F1, 0xC249, 0xC2A1, 0xC2F9, 0xC352, 
        0xC3AA, 0xC403, 0xC45C, 0xC4B5, 0xC50E, 0xC567, 0xC5C1, 0xC61A, 
        0xC674, 0xC6CE, 0xC728, 0xC782, 0xC7DC, 0xC837, 0xC891, 0xC8EC, 
        0xC947, 0xC9A2, 0xC9FD, 0xCA58, 0xCAB3, 0xCB0F, 0xCB6A, 0xCBC6, 
        0xCC22, 0xCC7E, 0xCCDA, 0xCD36, 0xCD92, 0xCDEF, 0xCE4C, 0xCEA8, 
        0xCF05, 0xCF62, 0xCFBF, 0xD01C, 0xD079, 0xD0D7, 0xD134, 0xD192, 
        0xD1F0, 0xD24E, 0xD2AC, 0xD30A, 0xD368, 0xD3C6, 0xD424, 0xD483, 
        0xD4E2, 0xD540, 0xD59F, 0xD5FE, 0xD65D, 0xD6BC, 0xD71B, 0xD77B, 
        0xD7DA, 0xD839, 0xD899, 0xD8F9, 0xD959, 0xD9B8, 0xDA18, 0xDA78, 
        0xDAD9, 0xDB39, 0xDB99, 0xDBFA, 0xDC5A, 0xDCBB, 0xDD1B, 0xDD7C, 
        0xDDDD, 0xDE3E, 0xDE9F, 0xDF00, 0xDF61, 0xDFC2, 0xE024, 0xE085, 
        0xE0E7, 0xE148, 0xE1AA, 0xE20C, 0xE26D, 0xE2CF, 0xE331, 0xE393, 
        0xE3F5, 0xE457, 0xE4B9, 0xE51C, 0xE57E, 0xE5E0, 0xE643, 0xE6A5, 
        0xE708, 0xE76A, 0xE7CD, 0xE830, 0xE893, 0xE8F6, 0xE958, 0xE9BB, 
        0xEA1E, 0xEA82, 0xEAE5, 0xEB48, 0xEBAB, 0xEC0E, 0xEC72, 0xECD5, 
        0xED38, 0xED9C, 0xEDFF, 0xEE63, 0xEEC7, 0xEF2A, 0xEF8E, 0xEFF2, 
        0xF055, 0xF0B9, 0xF11D, 0xF181, 0xF1E5, 0xF249, 0xF2AD, 0xF311, 
        0xF375, 0xF3D9, 0xF43D, 0xF4A1, 0xF505, 0xF569, 0xF5CD, 0xF632, 
        0xF696, 0xF6FA, 0xF75E, 0xF7C3, 0xF827, 0xF88B, 0xF8F0, 0xF954, 
        0xF9B9, 0xFA1D, 0xFA81, 0xFAE6, 0xFB4A, 0xFBAF, 0xFC13, 0xFC78, 
        0xFCDC, 0xFD41, 0xFDA5, 0xFE0A, 0xFE6E, 0xFED3, 0xFF37, 0xFF9C, 
// Waveform 5:
        0x0000, 0x0096, 0x012D, 0x01C4, 0x025B, 0x02F1, 0x0388, 0x041E, 
        0x04B5, 0x054B, 0x05E2, 0x0678, 0x070E, 0x07A4, 0x083A, 0x08D0, 
        0x0965, 0x09FB, 0x0A90, 0x0B25, 0x0BBA, 0x0C4F, 0x0CE3, 0x0D78, 
        0x0E0C, 0x0EA0, 0x0F33, 0x0FC6, 0x1059, 0x10EC, 0x117F, 0x1211, 
        0x12A3, 0x1335, 0x13C6, 0x1457, 0x14E7, 0x1578, 0x1608, 0x1697, 
        0x1726, 0x17B5, 0x1843, 0x18D1, 0x195F, 0x19EC, 0x1A79, 0x1B05, 
        0x1B91, 0x1C1C, 0x1CA7, 0x1D32, 0x1DBC, 0x1E45, 0x1ECE, 0x1F57, 
        0x1FDF, 0x2066, 0x20ED, 0x2173, 0x21F9, 0x227E, 0x2303, 0x2387, 
        0x240B, 0x248E, 0x2510, 0x2592, 0x2613, 0x2694, 0x2714, 0x2793, 
        0x2812, 0x2890, 0x290D, 0x298A, 0x2A06, 0x2A81, 0x2AFC, 0x2B76, 
        0x2BF0, 0x2C68, 0x2CE0, 0x2D57, 0x2DCE, 0x2E44, 0x2EB9, 0x2F2D, 
        0x2FA1, 0x3014, 0x3086, 0x30F7, 0x3168, 0x31D8, 0x3247, 0x32B5, 
        0x3323, 0x338F, 0x33FB, 0x3466, 0x34D1, 0x353A, 0x35A3, 0x360B, 
        0x3672, 0x36D8, 0x373E, 0x37A2, 0x3806, 0x3869, 0x38CB, 0x392C, 
        0x398D, 0x39EC, 0x3A4B, 0x3AA9, 0x3B06, 0x3B62, 0x3BBD, 0x3C18, 
        0x3C71, 0x3CCA, 0x3D22, 0x3D78, 0x3DCE, 0x3E24, 0x3E78, 0x3ECB, 
        0x3F1E, 0x3F6F, 0x3FC0, 0x400F, 0x405E, 0x40AC, 0x40F9, 0x4145, 
        0x4191, 0x41DB, 0x4224, 0x426D, 0x42B4, 0x42FB, 0x4341, 0x4386, 
        0x43CA, 0x440D, 0x444F, 0x4490, 0x44D1, 0x4510, 0x454F, 0x458C, 
        0x45C9, 0x4605, 0x4640, 0x467A, 0x46B3, 0x46EB, 0x4722, 0x4758, 
        0x478E, 0x47C2, 0x47F6, 0x4829, 0x485B, 0x488C, 0x48BC, 0x48EB, 
        0x4919, 0x4947, 0x4973, 0x499F, 0x49CA, 0x49F4, 0x4A1D, 0x4A45, 
        0x4A6C, 0x4A93, 0x4AB8, 0x4ADD, 0x4B01, 0x4B24, 0x4B46, 0x4B68, 
        0x4B88, 0x4BA8, 0x4BC7, 0x4BE4, 0x4C02, 0x4C1E, 0x4C3A, 0x4C54, 
        0x4C6E, 0x4C87, 0x4C9F, 0x4CB7, 0x4CCE, 0x4CE4, 0x4CF9, 0x4D0D, 
        0x4D21, 0x4D33, 0x4D45, 0x4D57, 0x4D67, 0x4D77, 0x4D86, 0x4D94, 
        0x4DA2, 0x4DAF, 0x4DBB, 0x4DC6, 0x4DD1, 0x4DDB, 0x4DE4, 0x4DEC, 
        0x4DF4, 0x4DFB, 0x4E02, 0x4E08, 0x4E0D, 0x4E11, 0x4E15, 0x4E18, 
        0x4E1B, 0x4E1D, 0x4E1E, 0x4E1F, 0x4E1F, 0x4E1E, 0x4E1D, 0x4E1B, 
        0x4E19, 0x4E16, 0x4E12, 0x4E0E, 0x4E0A, 0x4E04, 0x4DFF, 0x4DF8, 
        0x4DF1, 0x4DEA, 0x4DE2, 0x4DDA, 0x4DD1, 0x4DC7, 0x4DBD, 0x4DB3, 
        0x4DA8, 0x4D9D, 0x4D91, 0x4D84, 0x4D78, 0x4D6A, 0x4D5D, 0x4D4F, 
        0x4D40, 0x4D31, 0x4D22, 0x4D12, 0x4D02, 0x4CF1, 0x4CE1, 0x4CCF, 
        0x4CBE, 0x4CAC, 0x4C99, 0x4C87, 0x4C74, 0x4C60, 0x4C4C, 0x4C38, 
        0x4C24, 0x4C0F, 0x4BFB, 0x4BE5, 0x4BD0, 0x4BBA, 0x4BA4, 0x4B8E, 
        0x4B77, 0x4B61, 0x4B4A, 0x4B32, 0x4B1B, 0x4B03, 0x4AEB, 0x4AD3, 
        0x4ABB, 0x4AA3, 0x4A8A, 0x4A71, 0x4A58, 0x4A3F, 0x4A26, 0x4A0C, 
        0x49F3, 0x49D9, 0x49BF, 0x49A5, 0x498B, 0x4971, 0x4957, 0x493D, 
        0x4922, 0x4908, 0x48ED, 0x48D3, 0x48B8, 0x489D, 0x4883, 0x4868, 
        0x484D, 0x4832, 0x4817, 0x47FC, 0x47E1, 0x47C6, 0x47AC, 0x4791, 
        0x4776, 0x475B, 0x4740, 0x4725, 0x470B, 0x46F0, 0x46D5, 0x46BB, 
        0x46A0, 0x4686, 0x466B, 0x4651, 0x4637, 0x461D, 0x4603, 0x45E9, 
        0x45CF, 0x45B5, 0x459C, 0x4582, 0x4569, 0x4550, 0x4536, 0x451D, 
        0x4505, 0x44EC, 0x44D3, 0x44BB, 0x44A3, 0x448B, 0x4473, 0x445B, 
        0x4444, 0x442C, 0x4415, 0x43FE, 0x43E7, 0x43D1, 0x43BA, 0x43A4, 
        0x438E, 0x4378, 0x4362, 0x434D, 0x4338, 0x4323, 0x430E, 0x42F9, 
        0x42E5, 0x42D1, 0x42BD, 0x42AA, 0x4296, 0x4283, 0x4270, 0x425D, 
        0x424B, 0x4239, 0x4227, 0x4215, 0x4204, 0x41F3, 0x41E2, 0x41D1, 
        0x41C0, 0x41B0, 0x41A0, 0x4191, 0x4181, 0x4172, 0x4163, 0x4155, 
        0x4146, 0x4138, 0x412A, 0x411D, 0x410F, 0x4102, 0x40F6, 0x40E9, 
        0x40DD, 0x40D1, 0x40C5, 0x40BA, 0x40AF, 0x40A4, 0x4099, 0x408F, 
        0x4084, 0x407B, 0x4071, 0x4068, 0x405E, 0x4056, 0x404D, 0x4045, 
        0x403D, 0x4035, 0x402D, 0x4026, 0x401F, 0x4018, 0x4011, 0x400B, 
        0x4005, 0x3FFF, 0x3FF9, 0x3FF4, 0x3FEF, 0x3FEA, 0x3FE5, 0x3FE0, 
        0x3FDC, 0x3FD8, 0x3FD4, 0x3FD0, 0x3FCD, 0x3FCA, 0x3FC7, 0x3FC4, 
        0x3FC1, 0x3FBF, 0x3FBC, 0x3FBA, 0x3FB9, 0x3FB7, 0x3FB5, 0x3FB4, 
        0x3FB3, 0x3FB2, 0x3FB1, 0x3FB0, 0x3FB0, 0x3FAF, 0x3FAF, 0x3FAF, 
        0x3FAF, 0x3FAF, 0x3FB0, 0x3FB0, 0x3FB1, 0x3FB1, 0x3FB2, 0x3FB3, 
        0x3FB4, 0x3FB5, 0x3FB6, 0x3FB8, 0x3FB9, 0x3FBB, 0x3FBC, 0x3FBE, 
        0x3FBF, 0x3FC1, 0x3FC3, 0x3FC5, 0x3FC7, 0x3FC9, 0x3FCB, 0x3FCD, 
        0x3FCF, 0x3FD1, 0x3FD3, 0x3FD5, 0x3FD7, 0x3FD9, 0x3FDB, 0x3FDE, 
        0x3FE0, 0x3FE2, 0x3FE4, 0x3FE6, 0x3FE8, 0x3FEA, 0x3FEC, 0x3FED, 
        0x3FEF, 0x3FF1, 0x3FF2, 0x3FF4, 0x3FF6, 0x3FF7, 0x3FF8, 0x3FF9, 
        0x3FFB, 0x3FFC, 0x3FFC, 0x3FFD, 0x3FFE, 0x3FFE, 0x3FFF, 0x3FFF, 
        0x3FFF, 0x3FFF, 0x3FFF, 0x3FFE, 0x3FFE, 0x3FFD, 0x3FFC, 0x3FFB, 
        0x3FFA, 0x3FF8, 0x3FF6, 0x3FF4, 0x3FF2, 0x3FF0, 0x3FED, 0x3FEA, 
        0x3FE7, 0x3FE4, 0x3FE1, 0x3FDD, 0x3FD9, 0x3FD4, 0x3FD0, 0x3FCB, 
        0x3FC6, 0x3FC0, 0x3FBA, 0x3FB4, 0x3FAE, 0x3FA7, 0x3FA0, 0x3F99, 
        0x3F91, 0x3F89, 0x3F81, 0x3F79, 0x3F70, 0x3F66, 0x3F5D, 0x3F53, 
        0x3F48, 0x3F3D, 0x3F32, 0x3F27, 0x3F1B, 0x3F0F, 0x3F02, 0x3EF5, 
        0x3EE7, 0x3ED9, 0x3ECB, 0x3EBC, 0x3EAD, 0x3E9E, 0x3E8E, 0x3E7D, 
        0x3E6C, 0x3E5B, 0x3E49, 0x3E37, 0x3E25, 0x3E12, 0x3DFE, 0x3DEA, 
        0x3DD6, 0x3DC1, 0x3DAB, 0x3D95, 0x3D7F, 0x3D68, 0x3D51, 0x3D39, 
        0x3D21, 0x3D08, 0x3CEF, 0x3CD5, 0x3CBA, 0x3CA0, 0x3C84, 0x3C68, 
        0x3C4C, 0x3C2F, 0x3C12, 0x3BF4, 0x3BD5, 0x3BB6, 0x3B97, 0x3B77, 
        0x3B56, 0x3B35, 0x3B14, 0x3AF1, 0x3ACF, 0x3AAC, 0x3A88, 0x3A63, 
        0x3A3F, 0x3A19, 0x39F3, 0x39CD, 0x39A6, 0x397E, 0x3956, 0x392D, 
        0x3904, 0x38DA, 0x38B0, 0x3885, 0x3859, 0x382D, 0x3801, 0x37D3, 
        0x37A6, 0x3777, 0x3749, 0x3719, 0x36E9, 0x36B9, 0x3688, 0x3656, 
        0x3624, 0x35F1, 0x35BE, 0x358A, 0x3556, 0x3521, 0x34EC, 0x34B6, 
        0x347F, 0x3448, 0x3411, 0x33D9, 0x33A0, 0x3367, 0x332D, 0x32F3, 
        0x32B8, 0x327D, 0x3241, 0x3204, 0x31C8, 0x318A, 0x314C, 0x310E, 
        0x30CF, 0x308F, 0x3050, 0x300F, 0x2FCE, 0x2F8D, 0x2F4B, 0x2F08, 
        0x2EC5, 0x2E82, 0x2E3E, 0x2DFA, 0x2DB5, 0x2D70, 0x2D2A, 0x2CE4, 
        0x2C9D, 0x2C56, 0x2C0F, 0x2BC7, 0x2B7E, 0x2B36, 0x2AEC, 0x2AA3, 
        0x2A59, 0x2A0E, 0x29C3, 0x2978, 0x292C, 0x28E0, 0x2893, 0x2847, 
        0x27F9, 0x27AC, 0x275E, 0x270F, 0x26C0, 0x2671, 0x2622, 0x25D2, 
        0x2582, 0x2532, 0x24E1, 0x2490, 0x243E, 0x23ED, 0x239B, 0x2349, 
        0x22F6, 0x22A3, 0x2250, 0x21FD, 0x21A9, 0x2155, 0x2101, 0x20AD, 
        0x2058, 0x2003, 0x1FAE, 0x1F59, 0x1F03, 0x1EAE, 0x1E58, 0x1E02, 
        0x1DAB, 0x1D55, 0x1CFE, 0x1CA8, 0x1C51, 0x1BFA, 0x1BA3, 0x1B4B, 
        0x1AF4, 0x1A9C, 0x1A45, 0x19ED, 0x1995, 0x193D, 0x18E5, 0x188D, 
        0x1835, 0x17DD, 0x1785, 0x172D, 0x16D4, 0x167C, 0x1624, 0x15CB, 
        0x1573, 0x151B, 0x14C3, 0x146A, 0x1412, 0x13BA, 0x1362, 0x130A, 
        0x12B2, 0x125A, 0x1202, 0x11AA, 0x1152, 0x10FB, 0x10A3, 0x104C, 
        0x0FF5, 0x0F9E, 0x0F47, 0x0EF0, 0x0E99, 0x0E43, 0x0DED, 0x0D97, 
        0x0D41, 0x0CEB, 0x0C95, 0x0C40, 0x0BEB, 0x0B96, 0x0B42, 0x0AED, 
        0x0A99, 0x0A45, 0x09F2, 0x099F, 0x094C, 0x08F9, 0x08A7, 0x0854, 
        0x0803, 0x07B1, 0x0760, 0x070F, 0x06BF, 0x066F, 0x061F, 0x05D0, 
        0x0581, 0x0532, 0x04E4, 0x0496, 0x0449, 0x03FC, 0x03AF, 0x0363, 
        0x0317, 0x02CC, 0x0281, 0x0237, 0x01ED, 0x01A4, 0x015B, 0x0112, 
        0x00CA, 0x0083, 0x003C, 0xFFF6, 0xFFB0, 0xFF6B, 0xFF26, 0xFEE1, 
        0xFE9E, 0xFE5A, 0xFE18, 0xFDD5, 0xFD94, 0xFD53, 0xFD12, 0xFCD2, 
        0xFC93, 0xFC54, 0xFC16, 0xFBD9, 0xFB9C, 0xFB5F, 0xFB24, 0xFAE9, 
        0xFAAE, 0xFA75, 0xFA3B, 0xFA03, 0xF9CB, 0xF994, 0xF95D, 0xF927, 
        0xF8F2, 0xF8BE, 0xF88A, 0xF857, 0xF824, 0xF7F2, 0xF7C1, 0xF791, 
        0xF761, 0xF732, 0xF704, 0xF6D6, 0xF6AA, 0xF67D, 0xF652, 0xF627, 
        0xF5FD, 0xF5D4, 0xF5AC, 0xF584, 0xF55D, 0xF537, 0xF511, 0xF4EC, 
        0xF4C8, 0xF4A5, 0xF483, 0xF461, 0xF440, 0xF420, 0xF400, 0xF3E1, 
        0xF3C4, 0xF3A6, 0xF38A, 0xF36E, 0xF354, 0xF339, 0xF320, 0xF308, 
        0xF2F0, 0xF2D9, 0xF2C3, 0xF2AD, 0xF299, 0xF285, 0xF272, 0xF25F, 
        0xF24E, 0xF23D, 0xF22D, 0xF21E, 0xF210, 0xF202, 0xF1F5, 0xF1E9, 
        0xF1DE, 0xF1D3, 0xF1CA, 0xF1C1, 0xF1B8, 0xF1B1, 0xF1AA, 0xF1A5, 
        0xF19F, 0xF19B, 0xF198, 0xF195, 0xF193, 0xF191, 0xF191, 0xF191, 
        0xF192, 0xF194, 0xF196, 0xF199, 0xF19D, 0xF1A2, 0xF1A7, 0xF1AE, 
        0xF1B4, 0xF1BC, 0xF1C4, 0xF1CD, 0xF1D7, 0xF1E2, 0xF1ED, 0xF1F9, 
        0xF205, 0xF212, 0xF220, 0xF22F, 0xF23E, 0xF24E, 0xF25F, 0xF271, 
        0xF283, 0xF295, 0xF2A9, 0xF2BD, 0xF2D1, 0xF2E7, 0xF2FC, 0xF313, 
        0xF32A, 0xF342, 0xF35A, 0xF373, 0xF38D, 0xF3A7, 0xF3C2, 0xF3DE, 
        0xF3FA, 0xF416, 0xF433, 0xF451, 0xF46F, 0xF48E, 0xF4AD, 0xF4CD, 
        0xF4EE, 0xF50F, 0xF530, 0xF552, 0xF575, 0xF597, 0xF5BB, 0xF5DF, 
        0xF603, 0xF628, 0xF64E, 0xF673, 0xF69A, 0xF6C0, 0xF6E7, 0xF70F, 
        0xF737, 0xF75F, 0xF788, 0xF7B1, 0xF7DB, 0xF805, 0xF82F, 0xF85A, 
        0xF885, 0xF8B0, 0xF8DC, 0xF908, 0xF934, 0xF961, 0xF98E, 0xF9BB, 
        0xF9E9, 0xFA17, 0xFA45, 0xFA73, 0xFAA2, 0xFAD1, 0xFB00, 0xFB2F, 
        0xFB5F, 0xFB8F, 0xFBBF, 0xFBEF, 0xFC1F, 0xFC50, 0xFC80, 0xFCB1, 
        0xFCE2, 0xFD14, 0xFD45, 0xFD76, 0xFDA8, 0xFDDA, 0xFE0B, 0xFE3D, 
        0xFE6F, 0xFEA1, 0xFED3, 0xFF05, 0xFF38, 0xFF6A, 0xFF9C, 0xFFCE, 
        0x0000, 0x0032, 0x0064, 0x0096, 0x00C8, 0x00FB, 0x012D, 0x015F, 
        0x0191, 0x01C3, 0x01F5, 0x0226, 0x0258, 0x028A, 0x02BB, 0x02EC, 
        0x031E, 0x034F, 0x0380, 0x03B0, 0x03E1, 0x0411, 0x0441, 0x0471, 
        0x04A1, 0x04D1, 0x0500, 0x052F, 0x055E, 0x058D, 0x05BB, 0x05E9, 
        0x0617, 0x0645, 0x0672, 0x069F, 0x06CC, 0x06F8, 0x0724, 0x0750, 
        0x077B, 0x07A6, 0x07D1, 0x07FB, 0x0825, 0x084F, 0x0878, 0x08A1, 
        0x08C9, 0x08F1, 0x0919, 0x0940, 0x0966, 0x098D, 0x09B2, 0x09D8, 
        0x09FD, 0x0A21, 0x0A45, 0x0A68, 0x0A8B, 0x0AAE, 0x0AD0, 0x0AF1, 
        0x0B12, 0x0B33, 0x0B53, 0x0B72, 0x0B91, 0x0BAF, 0x0BCD, 0x0BEA, 
        0x0C06, 0x0C22, 0x0C3E, 0x0C59, 0x0C73, 0x0C8D, 0x0CA6, 0x0CBE, 
        0x0CD6, 0x0CED, 0x0D04, 0x0D19, 0x0D2F, 0x0D43, 0x0D57, 0x0D6B, 
        0x0D7D, 0x0D8F, 0x0DA1, 0x0DB2, 0x0DC2, 0x0DD1, 0x0DE0, 0x0DEE, 
        0x0DFB, 0x0E07, 0x0E13, 0x0E1E, 0x0E29, 0x0E33, 0x0E3C, 0x0E44, 
        0x0E4C, 0x0E52, 0x0E59, 0x0E5E, 0x0E63, 0x0E67, 0x0E6A, 0x0E6C, 
        0x0E6E, 0x0E6F, 0x0E6F, 0x0E6F, 0x0E6D, 0x0E6B, 0x0E68, 0x0E65, 
        0x0E61, 0x0E5B, 0x0E56, 0x0E4F, 0x0E48, 0x0E3F, 0x0E36, 0x0E2D, 
        0x0E22, 0x0E17, 0x0E0B, 0x0DFE, 0x0DF0, 0x0DE2, 0x0DD3, 0x0DC3, 
        0x0DB2, 0x0DA1, 0x0D8E, 0x0D7B, 0x0D67, 0x0D53, 0x0D3D, 0x0D27, 
        0x0D10, 0x0CF8, 0x0CE0, 0x0CC7, 0x0CAD, 0x0C92, 0x0C76, 0x0C5A, 
        0x0C3C, 0x0C1F, 0x0C00, 0x0BE0, 0x0BC0, 0x0B9F, 0x0B7D, 0x0B5B, 
        0x0B38, 0x0B14, 0x0AEF, 0x0AC9, 0x0AA3, 0x0A7C, 0x0A54, 0x0A2C, 
        0x0A03, 0x09D9, 0x09AE, 0x0983, 0x0956, 0x092A, 0x08FC, 0x08CE, 
        0x089F, 0x086F, 0x083F, 0x080E, 0x07DC, 0x07A9, 0x0776, 0x0742, 
        0x070E, 0x06D9, 0x06A3, 0x066C, 0x0635, 0x05FD, 0x05C5, 0x058C, 
        0x0552, 0x0517, 0x04DC, 0x04A1, 0x0464, 0x0427, 0x03EA, 0x03AC, 
        0x036D, 0x032E, 0x02EE, 0x02AD, 0x026C, 0x022B, 0x01E9, 0x01A6, 
        0x0162, 0x011F, 0x00DA, 0x0095, 0x0050, 0x000A, 0xFFC4, 0xFF7D, 
        0xFF36, 0xFEEE, 0xFEA5, 0xFE5D, 0xFE13, 0xFDC9, 0xFD7F, 0xFD34, 
        0xFCE9, 0xFC9D, 0xFC51, 0xFC04, 0xFBB7, 0xFB6A, 0xFB1C, 0xFACE, 
        0xFA7F, 0xFA30, 0xF9E1, 0xF991, 0xF941, 0xF8F1, 0xF8A0, 0xF84F, 
        0xF7FD, 0xF7AC, 0xF75A, 0xF707, 0xF6B4, 0xF661, 0xF60E, 0xF5BB, 
        0xF567, 0xF513, 0xF4BE, 0xF46A, 0xF415, 0xF3C0, 0xF36B, 0xF315, 
        0xF2BF, 0xF26A, 0xF213, 0xF1BD, 0xF167, 0xF110, 0xF0B9, 0xF062, 
        0xF00B, 0xEFB4, 0xEF5D, 0xEF05, 0xEEAE, 0xEE56, 0xEDFE, 0xEDA6, 
        0xED4E, 0xECF6, 0xEC9E, 0xEC46, 0xEBEE, 0xEB96, 0xEB3E, 0xEAE5, 
        0xEA8D, 0xEA35, 0xE9DC, 0xE984, 0xE92C, 0xE8D3, 0xE87B, 0xE823, 
        0xE7CB, 0xE773, 0xE71B, 0xE6C3, 0xE66B, 0xE613, 0xE5BB, 0xE564, 
        0xE50C, 0xE4B5, 0xE45D, 0xE406, 0xE3AF, 0xE358, 0xE302, 0xE2AB, 
        0xE255, 0xE1FE, 0xE1A8, 0xE153, 0xE0FD, 0xE0A7, 0xE052, 0xDFFD, 
        0xDFA8, 0xDF54, 0xDEFF, 0xDEAB, 0xDE57, 0xDE03, 0xDDB0, 0xDD5D, 
        0xDD0A, 0xDCB8, 0xDC65, 0xDC13, 0xDBC2, 0xDB70, 0xDB1F, 0xDACE, 
        0xDA7E, 0xDA2E, 0xD9DE, 0xD98F, 0xD940, 0xD8F1, 0xD8A2, 0xD854, 
        0xD807, 0xD7BA, 0xD76D, 0xD720, 0xD6D4, 0xD688, 0xD63D, 0xD5F2, 
        0xD5A8, 0xD55D, 0xD514, 0xD4CA, 0xD482, 0xD439, 0xD3F1, 0xD3AA, 
        0xD363, 0xD31C, 0xD2D6, 0xD290, 0xD24B, 0xD206, 0xD1C2, 0xD17E, 
        0xD13B, 0xD0F8, 0xD0B5, 0xD073, 0xD032, 0xCFF1, 0xCFB1, 0xCF71, 
        0xCF31, 0xCEF2, 0xCEB4, 0xCE76, 0xCE39, 0xCDFC, 0xCDBF, 0xCD83, 
        0xCD48, 0xCD0D, 0xCCD3, 0xCC99, 0xCC60, 0xCC27, 0xCBEF, 0xCBB8, 
        0xCB81, 0xCB4A, 0xCB14, 0xCADF, 0xCAAA, 0xCA76, 0xCA42, 0xCA0F, 
        0xC9DC, 0xC9AA, 0xC978, 0xC947, 0xC917, 0xC8E7, 0xC8B7, 0xC889, 
        0xC85A, 0xC82D, 0xC800, 0xC7D3, 0xC7A7, 0xC77B, 0xC750, 0xC726, 
        0xC6FC, 0xC6D3, 0xC6AA, 0xC682, 0xC65A, 0xC633, 0xC60D, 0xC5E7, 
        0xC5C1, 0xC59D, 0xC578, 0xC554, 0xC531, 0xC50F, 0xC4EC, 0xC4CB, 
        0xC4AA, 0xC489, 0xC469, 0xC44A, 0xC42B, 0xC40C, 0xC3EE, 0xC3D1, 
        0xC3B4, 0xC398, 0xC37C, 0xC360, 0xC346, 0xC32B, 0xC311, 0xC2F8, 
        0xC2DF, 0xC2C7, 0xC2AF, 0xC298, 0xC281, 0xC26B, 0xC255, 0xC23F, 
        0xC22A, 0xC216, 0xC202, 0xC1EE, 0xC1DB, 0xC1C9, 0xC1B7, 0xC1A5, 
        0xC194, 0xC183, 0xC172, 0xC162, 0xC153, 0xC144, 0xC135, 0xC127, 
        0xC119, 0xC10B, 0xC0FE, 0xC0F1, 0xC0E5, 0xC0D9, 0xC0CE, 0xC0C3, 
        0xC0B8, 0xC0AD, 0xC0A3, 0xC09A, 0xC090, 0xC087, 0xC07F, 0xC077, 
        0xC06F, 0xC067, 0xC060, 0xC059, 0xC052, 0xC04C, 0xC046, 0xC040, 
        0xC03A, 0xC035, 0xC030, 0xC02C, 0xC027, 0xC023, 0xC01F, 0xC01C, 
        0xC019, 0xC016, 0xC013, 0xC010, 0xC00E, 0xC00C, 0xC00A, 0xC008, 
        0xC006, 0xC005, 0xC004, 0xC003, 0xC002, 0xC002, 0xC001, 0xC001, 
        0xC001, 0xC001, 0xC001, 0xC002, 0xC002, 0xC003, 0xC004, 0xC004, 
        0xC005, 0xC007, 0xC008, 0xC009, 0xC00A, 0xC00C, 0xC00E, 0xC00F, 
        0xC011, 0xC013, 0xC014, 0xC016, 0xC018, 0xC01A, 0xC01C, 0xC01E, 
        0xC020, 0xC022, 0xC025, 0xC027, 0xC029, 0xC02B, 0xC02D, 0xC02F, 
        0xC031, 0xC033, 0xC035, 0xC037, 0xC039, 0xC03B, 0xC03D, 0xC03F, 
        0xC041, 0xC042, 0xC044, 0xC045, 0xC047, 0xC048, 0xC04A, 0xC04B, 
        0xC04C, 0xC04D, 0xC04E, 0xC04F, 0xC04F, 0xC050, 0xC050, 0xC051, 
        0xC051, 0xC051, 0xC051, 0xC051, 0xC050, 0xC050, 0xC04F, 0xC04E, 
        0xC04D, 0xC04C, 0xC04B, 0xC049, 0xC047, 0xC046, 0xC044, 0xC041, 
        0xC03F, 0xC03C, 0xC039, 0xC036, 0xC033, 0xC030, 0xC02C, 0xC028, 
        0xC024, 0xC020, 0xC01B, 0xC016, 0xC011, 0xC00C, 0xC007, 0xC001, 
        0xBFFB, 0xBFF5, 0xBFEF, 0xBFE8, 0xBFE1, 0xBFDA, 0xBFD3, 0xBFCB, 
        0xBFC3, 0xBFBB, 0xBFB3, 0xBFAA, 0xBFA2, 0xBF98, 0xBF8F, 0xBF85, 
        0xBF7C, 0xBF71, 0xBF67, 0xBF5C, 0xBF51, 0xBF46, 0xBF3B, 0xBF2F, 
        0xBF23, 0xBF17, 0xBF0A, 0xBEFE, 0xBEF1, 0xBEE3, 0xBED6, 0xBEC8, 
        0xBEBA, 0xBEAB, 0xBE9D, 0xBE8E, 0xBE7F, 0xBE6F, 0xBE60, 0xBE50, 
        0xBE40, 0xBE2F, 0xBE1E, 0xBE0D, 0xBDFC, 0xBDEB, 0xBDD9, 0xBDC7, 
        0xBDB5, 0xBDA3, 0xBD90, 0xBD7D, 0xBD6A, 0xBD56, 0xBD43, 0xBD2F, 
        0xBD1B, 0xBD07, 0xBCF2, 0xBCDD, 0xBCC8, 0xBCB3, 0xBC9E, 0xBC88, 
        0xBC72, 0xBC5C, 0xBC46, 0xBC2F, 0xBC19, 0xBC02, 0xBBEB, 0xBBD4, 
        0xBBBC, 0xBBA5, 0xBB8D, 0xBB75, 0xBB5D, 0xBB45, 0xBB2D, 0xBB14, 
        0xBAFB, 0xBAE3, 0xBACA, 0xBAB0, 0xBA97, 0xBA7E, 0xBA64, 0xBA4B, 
        0xBA31, 0xBA17, 0xB9FD, 0xB9E3, 0xB9C9, 0xB9AF, 0xB995, 0xB97A, 
        0xB960, 0xB945, 0xB92B, 0xB910, 0xB8F5, 0xB8DB, 0xB8C0, 0xB8A5, 
        0xB88A, 0xB86F, 0xB854, 0xB83A, 0xB81F, 0xB804, 0xB7E9, 0xB7CE, 
        0xB7B3, 0xB798, 0xB77D, 0xB763, 0xB748, 0xB72D, 0xB713, 0xB6F8, 
        0xB6DE, 0xB6C3, 0xB6A9, 0xB68F, 0xB675, 0xB65B, 0xB641, 0xB627, 
        0xB60D, 0xB5F4, 0xB5DA, 0xB5C1, 0xB5A8, 0xB58F, 0xB576, 0xB55D, 
        0xB545, 0xB52D, 0xB515, 0xB4FD, 0xB4E5, 0xB4CE, 0xB4B6, 0xB49F, 
        0xB489, 0xB472, 0xB45C, 0xB446, 0xB430, 0xB41B, 0xB405, 0xB3F1, 
        0xB3DC, 0xB3C8, 0xB3B4, 0xB3A0, 0xB38D, 0xB379, 0xB367, 0xB354, 
        0xB342, 0xB331, 0xB31F, 0xB30F, 0xB2FE, 0xB2EE, 0xB2DE, 0xB2CF, 
        0xB2C0, 0xB2B1, 0xB2A3, 0xB296, 0xB288, 0xB27C, 0xB26F, 0xB263, 
        0xB258, 0xB24D, 0xB243, 0xB239, 0xB22F, 0xB226, 0xB21E, 0xB216, 
        0xB20F, 0xB208, 0xB201, 0xB1FC, 0xB1F6, 0xB1F2, 0xB1EE, 0xB1EA, 
        0xB1E7, 0xB1E5, 0xB1E3, 0xB1E2, 0xB1E1, 0xB1E1, 0xB1E2, 0xB1E3, 
        0xB1E5, 0xB1E8, 0xB1EB, 0xB1EF, 0xB1F3, 0xB1F8, 0xB1FE, 0xB205, 
        0xB20C, 0xB214, 0xB21C, 0xB225, 0xB22F, 0xB23A, 0xB245, 0xB251, 
        0xB25E, 0xB26C, 0xB27A, 0xB289, 0xB299, 0xB2A9, 0xB2BB, 0xB2CD, 
        0xB2DF, 0xB2F3, 0xB307, 0xB31C, 0xB332, 0xB349, 0xB361, 0xB379, 
        0xB392, 0xB3AC, 0xB3C6, 0xB3E2, 0xB3FE, 0xB41B, 0xB439, 0xB458, 
        0xB478, 0xB498, 0xB4BA, 0xB4DC, 0xB4FF, 0xB523, 0xB548, 0xB56D, 
        0xB594, 0xB5BB, 0xB5E3, 0xB60C, 0xB636, 0xB661, 0xB68D, 0xB6B9, 
        0xB6E7, 0xB715, 0xB744, 0xB774, 0xB7A5, 0xB7D7, 0xB80A, 0xB83D, 
        0xB872, 0xB8A7, 0xB8DE, 0xB915, 0xB94D, 0xB986, 0xB9C0, 0xB9FB, 
        0xBA37, 0xBA74, 0xBAB1, 0xBAF0, 0xBB2F, 0xBB70, 0xBBB1, 0xBBF3, 
        0xBC36, 0xBC7A, 0xBCBF, 0xBD05, 0xBD4B, 0xBD93, 0xBDDC, 0xBE25, 
        0xBE6F, 0xBEBB, 0xBF07, 0xBF54, 0xBFA2, 0xBFF1, 0xC040, 0xC091, 
        0xC0E2, 0xC135, 0xC188, 0xC1DC, 0xC231, 0xC287, 0xC2DE, 0xC336, 
        0xC38F, 0xC3E8, 0xC443, 0xC49E, 0xC4FA, 0xC557, 0xC5B5, 0xC613, 
        0xC673, 0xC6D3, 0xC735, 0xC797, 0xC7FA, 0xC85E, 0xC8C2, 0xC928, 
        0xC98E, 0xC9F5, 0xCA5D, 0xCAC6, 0xCB2F, 0xCB9A, 0xCC05, 0xCC71, 
        0xCCDD, 0xCD4B, 0xCDB9, 0xCE28, 0xCE98, 0xCF09, 0xCF7A, 0xCFEC, 
        0xD05F, 0xD0D3, 0xD147, 0xD1BC, 0xD232, 0xD2A8, 0xD320, 0xD398, 
        0xD410, 0xD48A, 0xD504, 0xD57E, 0xD5FA, 0xD676, 0xD6F3, 0xD770, 
        0xD7EE, 0xD86D, 0xD8EC, 0xD96C, 0xD9ED, 0xDA6E, 0xDAF0, 0xDB72, 
        0xDBF5, 0xDC79, 0xDCFD, 0xDD81, 0xDE07, 0xDE8D, 0xDF13, 0xDF9A, 
        0xE021, 0xE0A9, 0xE132, 0xE1BB, 0xE244, 0xE2CE, 0xE359, 0xE3E4, 
        0xE46F, 0xE4FB, 0xE587, 0xE614, 0xE6A1, 0xE72E, 0xE7BC, 0xE84B, 
        0xE8DA, 0xE969, 0xE9F8, 0xEA88, 0xEB18, 0xEBA9, 0xEC3A, 0xECCB, 
        0xED5D, 0xEDEF, 0xEE81, 0xEF14, 0xEFA6, 0xF039, 0xF0CD, 0xF160, 
        0xF1F4, 0xF288, 0xF31C, 0xF3B1, 0xF446, 0xF4DB, 0xF570, 0xF605, 
        0xF69A, 0xF730, 0xF7C6, 0xF85C, 0xF8F2, 0xF988, 0xFA1E, 0xFAB4, 
        0xFB4B, 0xFBE1, 0xFC78, 0xFD0F, 0xFDA5, 0xFE3C, 0xFED3, 0xFF6A, 
// Waveform 6:
        0x0000, 0x00FD, 0x01FA, 0x02F7, 0x03F4, 0x04F1, 0x05EE, 0x06EB, 
        0x07E7, 0x08E3, 0x09DF, 0x0ADA, 0x0BD6, 0x0CD0, 0x0DCA, 0x0EC4, 
        0x0FBD, 0x10B6, 0x11AE, 0x12A5, 0x139C, 0x1492, 0x1588, 0x167C, 
        0x1770, 0x1863, 0x1956, 0x1A47, 0x1B37, 0x1C27, 0x1D15, 0x1E03, 
        0x1EEF, 0x1FDB, 0x20C5, 0x21AE, 0x2296, 0x237D, 0x2463, 0x2547, 
        0x262A, 0x270C, 0x27EC, 0x28CB, 0x29A9, 0x2A85, 0x2B60, 0x2C3A, 
        0x2D11, 0x2DE8, 0x2EBC, 0x2F90, 0x3061, 0x3131, 0x31FF, 0x32CC, 
        0x3397, 0x3460, 0x3528, 0x35ED, 0x36B1, 0x3773, 0x3833, 0x38F1, 
        0x39AE, 0x3A68, 0x3B21, 0x3BD8, 0x3C8C, 0x3D3F, 0x3DEF, 0x3E9E, 
        0x3F4B, 0x3FF5, 0x409E, 0x4144, 0x41E8, 0x428A, 0x432A, 0x43C8, 
        0x4464, 0x44FD, 0x4594, 0x4629, 0x46BC, 0x474C, 0x47DB, 0x4867, 
        0x48F0, 0x4978, 0x49FD, 0x4A80, 0x4B00, 0x4B7E, 0x4BFA, 0x4C74, 
        0x4CEB, 0x4D60, 0x4DD2, 0x4E42, 0x4EB0, 0x4F1B, 0x4F84, 0x4FEA, 
        0x504E, 0x50B0, 0x510F, 0x516C, 0x51C6, 0x521E, 0x5274, 0x52C7, 
        0x5318, 0x5366, 0x53B2, 0x53FC, 0x5443, 0x5488, 0x54CA, 0x550A, 
        0x5548, 0x5583, 0x55BC, 0x55F2, 0x5626, 0x5658, 0x5687, 0x56B4, 
        0x56DE, 0x5706, 0x572C, 0x5750, 0x5771, 0x5790, 0x57AC, 0x57C6, 
        0x57DE, 0x57F4, 0x5807, 0x5819, 0x5827, 0x5834, 0x583F, 0x5847, 
        0x584D, 0x5851, 0x5852, 0x5852, 0x584F, 0x584B, 0x5844, 0x583B, 
        0x5830, 0x5823, 0x5814, 0x5803, 0x57EF, 0x57DA, 0x57C3, 0x57AA, 
        0x578F, 0x5772, 0x5753, 0x5733, 0x5710, 0x56EC, 0x56C5, 0x569D, 
        0x5673, 0x5648, 0x561B, 0x55EB, 0x55BB, 0x5588, 0x5554, 0x551F, 
        0x54E7, 0x54AE, 0x5474, 0x5438, 0x53FA, 0x53BB, 0x537B, 0x5339, 
        0x52F5, 0x52B1, 0x526A, 0x5223, 0x51DA, 0x5190, 0x5144, 0x50F8, 
        0x50AA, 0x505B, 0x500A, 0x4FB9, 0x4F66, 0x4F12, 0x4EBE, 0x4E68, 
        0x4E11, 0x4DB9, 0x4D60, 0x4D06, 0x4CAB, 0x4C50, 0x4BF3, 0x4B96, 
        0x4B38, 0x4AD9, 0x4A79, 0x4A18, 0x49B7, 0x4955, 0x48F2, 0x488F, 
        0x482B, 0x47C6, 0x4761, 0x46FB, 0x4695, 0x462E, 0x45C7, 0x455F, 
        0x44F7, 0x448F, 0x4426, 0x43BD, 0x4353, 0x42E9, 0x427F, 0x4215, 
        0x41AA, 0x413F, 0x40D4, 0x4069, 0x3FFE, 0x3F92, 0x3F27, 0x3EBB, 
        0x3E4F, 0x3DE3, 0x3D78, 0x3D0C, 0x3CA0, 0x3C35, 0x3BC9, 0x3B5E, 
        0x3AF2, 0x3A87, 0x3A1C, 0x39B1, 0x3947, 0x38DC, 0x3872, 0x3808, 
        0x379F, 0x3735, 0x36CC, 0x3664, 0x35FB, 0x3594, 0x352C, 0x34C5, 
        0x345E, 0x33F8, 0x3392, 0x332D, 0x32C8, 0x3264, 0x3200, 0x319D, 
        0x313A, 0x30D8, 0x3076, 0x3015, 0x2FB5, 0x2F55, 0x2EF6, 0x2E98, 
        0x2E3A, 0x2DDD, 0x2D80, 0x2D25, 0x2CCA, 0x2C6F, 0x2C16, 0x2BBD, 
        0x2B65, 0x2B0D, 0x2AB7, 0x2A61, 0x2A0C, 0x29B8, 0x2965, 0x2912, 
        0x28C0, 0x2870, 0x2820, 0x27D0, 0x2782, 0x2734, 0x26E8, 0x269C, 
        0x2651, 0x2607, 0x25BE, 0x2576, 0x252E, 0x24E8, 0x24A2, 0x245E, 
        0x241A, 0x23D7, 0x2395, 0x2354, 0x2314, 0x22D5, 0x2297, 0x2259, 
        0x221D, 0x21E2, 0x21A7, 0x216D, 0x2135, 0x20FD, 0x20C6, 0x2090, 
        0x205B, 0x2027, 0x1FF3, 0x1FC1, 0x1F90, 0x1F5F, 0x1F2F, 0x1F01, 
        0x1ED3, 0x1EA6, 0x1E7A, 0x1E4F, 0x1E24, 0x1DFB, 0x1DD2, 0x1DAB, 
        0x1D84, 0x1D5E, 0x1D39, 0x1D14, 0x1CF1, 0x1CCE, 0x1CAC, 0x1C8B, 
        0x1C6B, 0x1C4C, 0x1C2D, 0x1C0F, 0x1BF2, 0x1BD6, 0x1BBA, 0x1BA0, 
        0x1B86, 0x1B6C, 0x1B54, 0x1B3C, 0x1B25, 0x1B0E, 0x1AF8, 0x1AE3, 
        0x1ACF, 0x1ABB, 0x1AA8, 0x1A96, 0x1A84, 0x1A73, 0x1A62, 0x1A52, 
        0x1A43, 0x1A34, 0x1A26, 0x1A18, 0x1A0B, 0x19FE, 0x19F2, 0x19E7, 
        0x19DC, 0x19D1, 0x19C7, 0x19BE, 0x19B5, 0x19AC, 0x19A4, 0x199C, 
        0x1995, 0x198E, 0x1987, 0x1981, 0x197B, 0x1976, 0x1971, 0x196C, 
        0x1967, 0x1963, 0x1960, 0x195C, 0x1959, 0x1956, 0x1953, 0x1951, 
        0x194F, 0x194D, 0x194B, 0x1949, 0x1948, 0x1947, 0x1946, 0x1945, 
        0x1944, 0x1944, 0x1943, 0x1943, 0x1943, 0x1943, 0x1943, 0x1943, 
        0x1943, 0x1943, 0x1944, 0x1944, 0x1944, 0x1945, 0x1945, 0x1945, 
        0x1946, 0x1946, 0x1946, 0x1946, 0x1947, 0x1947, 0x1947, 0x1947, 
        0x1947, 0x1947, 0x1947, 0x1946, 0x1946, 0x1945, 0x1944, 0x1944, 
        0x1943, 0x1942, 0x1940, 0x193F, 0x193D, 0x193B, 0x1939, 0x1937, 
        0x1935, 0x1932, 0x1930, 0x192D, 0x192A, 0x1926, 0x1922, 0x191F, 
        0x191B, 0x1916, 0x1912, 0x190D, 0x1908, 0x1902, 0x18FD, 0x18F7, 
        0x18F1, 0x18EA, 0x18E4, 0x18DD, 0x18D5, 0x18CE, 0x18C6, 0x18BE, 
        0x18B5, 0x18AD, 0x18A4, 0x189A, 0x1891, 0x1887, 0x187D, 0x1872, 
        0x1867, 0x185C, 0x1851, 0x1845, 0x1839, 0x182D, 0x1820, 0x1813, 
        0x1806, 0x17F8, 0x17EB, 0x17DC, 0x17CE, 0x17BF, 0x17B0, 0x17A1, 
        0x1791, 0x1781, 0x1771, 0x1761, 0x1750, 0x173F, 0x172D, 0x171C, 
        0x170A, 0x16F7, 0x16E5, 0x16D2, 0x16BF, 0x16AC, 0x1698, 0x1684, 
        0x1670, 0x165C, 0x1647, 0x1632, 0x161D, 0x1608, 0x15F2, 0x15DD, 
        0x15C7, 0x15B0, 0x159A, 0x1583, 0x156D, 0x1555, 0x153E, 0x1527, 
        0x150F, 0x14F7, 0x14DF, 0x14C7, 0x14AF, 0x1496, 0x147E, 0x1465, 
        0x144C, 0x1433, 0x141A, 0x1400, 0x13E7, 0x13CD, 0x13B4, 0x139A, 
        0x1380, 0x1366, 0x134C, 0x1332, 0x1317, 0x12FD, 0x12E3, 0x12C8, 
        0x12AE, 0x1293, 0x1279, 0x125E, 0x1243, 0x1229, 0x120E, 0x11F3, 
        0x11D9, 0x11BE, 0x11A3, 0x1188, 0x116E, 0x1153, 0x1138, 0x111E, 
        0x1103, 0x10E9, 0x10CE, 0x10B4, 0x1099, 0x107F, 0x1065, 0x104B, 
        0x1031, 0x1017, 0x0FFD, 0x0FE3, 0x0FCA, 0x0FB0, 0x0F97, 0x0F7D, 
        0x0F64, 0x0F4B, 0x0F32, 0x0F19, 0x0F01, 0x0EE8, 0x0ED0, 0x0EB8, 
        0x0EA0, 0x0E88, 0x0E70, 0x0E58, 0x0E41, 0x0E2A, 0x0E13, 0x0DFC, 
        0x0DE6, 0x0DCF, 0x0DB9, 0x0DA3, 0x0D8D, 0x0D78, 0x0D62, 0x0D4D, 
        0x0D38, 0x0D24, 0x0D0F, 0x0CFB, 0x0CE7, 0x0CD3, 0x0CC0, 0x0CAD, 
        0x0C9A, 0x0C87, 0x0C74, 0x0C62, 0x0C50, 0x0C3E, 0x0C2D, 0x0C1B, 
        0x0C0A, 0x0BF9, 0x0BE9, 0x0BD9, 0x0BC9, 0x0BB9, 0x0BA9, 0x0B9A, 
        0x0B8B, 0x0B7D, 0x0B6E, 0x0B60, 0x0B52, 0x0B44, 0x0B37, 0x0B2A, 
        0x0B1D, 0x0B10, 0x0B04, 0x0AF8, 0x0AEC, 0x0AE1, 0x0AD6, 0x0ACA, 
        0x0AC0, 0x0AB5, 0x0AAB, 0x0AA1, 0x0A97, 0x0A8E, 0x0A84, 0x0A7B, 
        0x0A73, 0x0A6A, 0x0A62, 0x0A5A, 0x0A52, 0x0A4B, 0x0A43, 0x0A3C, 
        0x0A35, 0x0A2F, 0x0A28, 0x0A22, 0x0A1C, 0x0A16, 0x0A11, 0x0A0B, 
        0x0A06, 0x0A01, 0x09FC, 0x09F8, 0x09F4, 0x09EF, 0x09EB, 0x09E8, 
        0x09E4, 0x09E0, 0x09DD, 0x09DA, 0x09D7, 0x09D4, 0x09D2, 0x09CF, 
        0x09CD, 0x09CB, 0x09C8, 0x09C7, 0x09C5, 0x09C3, 0x09C1, 0x09C0, 
        0x09BF, 0x09BD, 0x09BC, 0x09BB, 0x09BA, 0x09BA, 0x09B9, 0x09B8, 
        0x09B8, 0x09B7, 0x09B7, 0x09B6, 0x09B6, 0x09B6, 0x09B5, 0x09B5, 
        0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 
        0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 0x09B5, 
        0x09B5, 0x09B4, 0x09B4, 0x09B4, 0x09B4, 0x09B4, 0x09B3, 0x09B3, 
        0x09B2, 0x09B2, 0x09B1, 0x09B0, 0x09B0, 0x09AF, 0x09AE, 0x09AD, 
        0x09AC, 0x09AA, 0x09A9, 0x09A8, 0x09A6, 0x09A5, 0x09A3, 0x09A1, 
        0x099F, 0x099D, 0x099B, 0x0998, 0x0996, 0x0993, 0x0990, 0x098E, 
        0x098B, 0x0987, 0x0984, 0x0981, 0x097D, 0x0979, 0x0975, 0x0971, 
        0x096D, 0x0969, 0x0964, 0x095F, 0x095A, 0x0955, 0x0950, 0x094B, 
        0x0945, 0x093F, 0x0939, 0x0933, 0x092D, 0x0927, 0x0920, 0x0919, 
        0x0912, 0x090B, 0x0904, 0x08FC, 0x08F4, 0x08ED, 0x08E5, 0x08DC, 
        0x08D4, 0x08CB, 0x08C3, 0x08BA, 0x08B0, 0x08A7, 0x089E, 0x0894, 
        0x088A, 0x0880, 0x0876, 0x086B, 0x0861, 0x0856, 0x084B, 0x0840, 
        0x0835, 0x082A, 0x081E, 0x0812, 0x0806, 0x07FA, 0x07EE, 0x07E2, 
        0x07D5, 0x07C9, 0x07BC, 0x07AF, 0x07A2, 0x0794, 0x0787, 0x0779, 
        0x076C, 0x075E, 0x0750, 0x0742, 0x0734, 0x0725, 0x0717, 0x0708, 
        0x06FA, 0x06EB, 0x06DC, 0x06CD, 0x06BE, 0x06AE, 0x069F, 0x0690, 
        0x0680, 0x0670, 0x0661, 0x0651, 0x0641, 0x0631, 0x0621, 0x0611, 
        0x0601, 0x05F1, 0x05E1, 0x05D0, 0x05C0, 0x05AF, 0x059F, 0x058E, 
        0x057E, 0x056D, 0x055D, 0x054C, 0x053C, 0x052B, 0x051A, 0x0509, 
        0x04F9, 0x04E8, 0x04D7, 0x04C7, 0x04B6, 0x04A5, 0x0495, 0x0484, 
        0x0473, 0x0463, 0x0452, 0x0442, 0x0431, 0x0421, 0x0410, 0x0400, 
        0x03F0, 0x03DF, 0x03CF, 0x03BF, 0x03AF, 0x039F, 0x038F, 0x037F, 
        0x036F, 0x0360, 0x0350, 0x0341, 0x0331, 0x0322, 0x0313, 0x0303, 
        0x02F4, 0x02E5, 0x02D7, 0x02C8, 0x02B9, 0x02AB, 0x029C, 0x028E, 
        0x0280, 0x0272, 0x0264, 0x0256, 0x0249, 0x023B, 0x022E, 0x0221, 
        0x0214, 0x0207, 0x01FA, 0x01EE, 0x01E1, 0x01D5, 0x01C9, 0x01BD, 
        0x01B1, 0x01A5, 0x019A, 0x018E, 0x0183, 0x0178, 0x016D, 0x0162, 
        0x0158, 0x014E, 0x0143, 0x0139, 0x0130, 0x0126, 0x011C, 0x0113, 
        0x010A, 0x0101, 0x00F8, 0x00EF, 0x00E7, 0x00DF, 0x00D7, 0x00CF, 
        0x00C7, 0x00BF, 0x00B8, 0x00B0, 0x00A9, 0x00A2, 0x009C, 0x0095, 
        0x008F, 0x0089, 0x0082, 0x007D, 0x0077, 0x0071, 0x006C, 0x0067, 
        0x0061, 0x005D, 0x0058, 0x0053, 0x004F, 0x004A, 0x0046, 0x0042, 
        0x003E, 0x003B, 0x0037, 0x0034, 0x0030, 0x002D, 0x002A, 0x0027, 
        0x0024, 0x0022, 0x001F, 0x001D, 0x001B, 0x0018, 0x0016, 0x0014, 
        0x0013, 0x0011, 0x000F, 0x000E, 0x000C, 0x000B, 0x000A, 0x0009, 
        0x0008, 0x0007, 0x0006, 0x0005, 0x0004, 0x0004, 0x0003, 0x0002, 
        0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 
        0xFFFE, 0xFFFE, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFB, 0xFFFA, 0xFFF9, 
        0xFFF8, 0xFFF7, 0xFFF6, 0xFFF5, 0xFFF4, 0xFFF2, 0xFFF1, 0xFFEF, 
        0xFFED, 0xFFEC, 0xFFEA, 0xFFE8, 0xFFE5, 0xFFE3, 0xFFE1, 0xFFDE, 
        0xFFDC, 0xFFD9, 0xFFD6, 0xFFD3, 0xFFD0, 0xFFCC, 0xFFC9, 0xFFC5, 
        0xFFC2, 0xFFBE, 0xFFBA, 0xFFB6, 0xFFB1, 0xFFAD, 0xFFA8, 0xFFA3, 
        0xFF9F, 0xFF99, 0xFF94, 0xFF8F, 0xFF89, 0xFF83, 0xFF7E, 0xFF78, 
        0xFF71, 0xFF6B, 0xFF64, 0xFF5E, 0xFF57, 0xFF50, 0xFF48, 0xFF41, 
        0xFF39, 0xFF31, 0xFF2A, 0xFF21, 0xFF19, 0xFF11, 0xFF08, 0xFEFF, 
        0xFEF6, 0xFEED, 0xFEE4, 0xFEDA, 0xFED0, 0xFEC7, 0xFEBD, 0xFEB2, 
        0xFEA8, 0xFE9E, 0xFE93, 0xFE88, 0xFE7D, 0xFE72, 0xFE66, 0xFE5B, 
        0xFE4F, 0xFE43, 0xFE37, 0xFE2B, 0xFE1F, 0xFE13, 0xFE06, 0xFDF9, 
        0xFDEC, 0xFDDF, 0xFDD2, 0xFDC5, 0xFDB7, 0xFDAA, 0xFD9C, 0xFD8E, 
        0xFD80, 0xFD72, 0xFD64, 0xFD55, 0xFD47, 0xFD38, 0xFD29, 0xFD1B, 
        0xFD0C, 0xFCFD, 0xFCED, 0xFCDE, 0xFCCF, 0xFCBF, 0xFCB0, 0xFCA0, 
        0xFC91, 0xFC81, 0xFC71, 0xFC61, 0xFC51, 0xFC41, 0xFC31, 0xFC21, 
        0xFC10, 0xFC00, 0xFBF0, 0xFBDF, 0xFBCF, 0xFBBE, 0xFBAE, 0xFB9D, 
        0xFB8D, 0xFB7C, 0xFB6B, 0xFB5B, 0xFB4A, 0xFB39, 0xFB29, 0xFB18, 
        0xFB07, 0xFAF7, 0xFAE6, 0xFAD5, 0xFAC5, 0xFAB4, 0xFAA3, 0xFA93, 
        0xFA82, 0xFA72, 0xFA61, 0xFA51, 0xFA40, 0xFA30, 0xFA1F, 0xFA0F, 
        0xF9FF, 0xF9EF, 0xF9DF, 0xF9CF, 0xF9BF, 0xF9AF, 0xF99F, 0xF990, 
        0xF980, 0xF970, 0xF961, 0xF952, 0xF942, 0xF933, 0xF924, 0xF915, 
        0xF906, 0xF8F8, 0xF8E9, 0xF8DB, 0xF8CC, 0xF8BE, 0xF8B0, 0xF8A2, 
        0xF894, 0xF887, 0xF879, 0xF86C, 0xF85E, 0xF851, 0xF844, 0xF837, 
        0xF82B, 0xF81E, 0xF812, 0xF806, 0xF7FA, 0xF7EE, 0xF7E2, 0xF7D6, 
        0xF7CB, 0xF7C0, 0xF7B5, 0xF7AA, 0xF79F, 0xF795, 0xF78A, 0xF780, 
        0xF776, 0xF76C, 0xF762, 0xF759, 0xF750, 0xF746, 0xF73D, 0xF735, 
        0xF72C, 0xF724, 0xF71B, 0xF713, 0xF70C, 0xF704, 0xF6FC, 0xF6F5, 
        0xF6EE, 0xF6E7, 0xF6E0, 0xF6D9, 0xF6D3, 0xF6CD, 0xF6C7, 0xF6C1, 
        0xF6BB, 0xF6B5, 0xF6B0, 0xF6AB, 0xF6A6, 0xF6A1, 0xF69C, 0xF697, 
        0xF693, 0xF68F, 0xF68B, 0xF687, 0xF683, 0xF67F, 0xF67C, 0xF679, 
        0xF675, 0xF672, 0xF670, 0xF66D, 0xF66A, 0xF668, 0xF665, 0xF663, 
        0xF661, 0xF65F, 0xF65D, 0xF65B, 0xF65A, 0xF658, 0xF657, 0xF656, 
        0xF654, 0xF653, 0xF652, 0xF651, 0xF650, 0xF650, 0xF64F, 0xF64E, 
        0xF64E, 0xF64D, 0xF64D, 0xF64C, 0xF64C, 0xF64C, 0xF64C, 0xF64C, 
        0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 
        0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 0xF64B, 
        0xF64B, 0xF64B, 0xF64B, 0xF64A, 0xF64A, 0xF64A, 0xF649, 0xF649, 
        0xF648, 0xF648, 0xF647, 0xF646, 0xF646, 0xF645, 0xF644, 0xF643, 
        0xF641, 0xF640, 0xF63F, 0xF63D, 0xF63B, 0xF639, 0xF637, 0xF635, 
        0xF633, 0xF631, 0xF62E, 0xF62C, 0xF629, 0xF626, 0xF623, 0xF620, 
        0xF61C, 0xF618, 0xF615, 0xF611, 0xF60C, 0xF608, 0xF604, 0xF5FF, 
        0xF5FA, 0xF5F5, 0xF5EF, 0xF5EA, 0xF5E4, 0xF5DE, 0xF5D8, 0xF5D1, 
        0xF5CB, 0xF5C4, 0xF5BD, 0xF5B5, 0xF5AE, 0xF5A6, 0xF59E, 0xF596, 
        0xF58D, 0xF585, 0xF57C, 0xF572, 0xF569, 0xF55F, 0xF555, 0xF54B, 
        0xF540, 0xF536, 0xF52B, 0xF51F, 0xF514, 0xF508, 0xF4FC, 0xF4F0, 
        0xF4E3, 0xF4D6, 0xF4C9, 0xF4BC, 0xF4AE, 0xF4A0, 0xF492, 0xF483, 
        0xF475, 0xF466, 0xF457, 0xF447, 0xF437, 0xF427, 0xF417, 0xF407, 
        0xF3F6, 0xF3E5, 0xF3D4, 0xF3C2, 0xF3B0, 0xF39E, 0xF38C, 0xF379, 
        0xF366, 0xF353, 0xF340, 0xF32D, 0xF319, 0xF305, 0xF2F1, 0xF2DC, 
        0xF2C8, 0xF2B3, 0xF29E, 0xF288, 0xF273, 0xF25D, 0xF247, 0xF231, 
        0xF21A, 0xF204, 0xF1ED, 0xF1D6, 0xF1BF, 0xF1A8, 0xF190, 0xF178, 
        0xF160, 0xF148, 0xF130, 0xF118, 0xF0FF, 0xF0E7, 0xF0CE, 0xF0B5, 
        0xF09C, 0xF083, 0xF06A, 0xF050, 0xF037, 0xF01D, 0xF003, 0xEFE9, 
        0xEFCF, 0xEFB5, 0xEF9B, 0xEF81, 0xEF67, 0xEF4C, 0xEF32, 0xEF17, 
        0xEEFD, 0xEEE2, 0xEEC8, 0xEEAD, 0xEE92, 0xEE78, 0xEE5D, 0xEE42, 
        0xEE27, 0xEE0D, 0xEDF2, 0xEDD7, 0xEDBD, 0xEDA2, 0xED87, 0xED6D, 
        0xED52, 0xED38, 0xED1D, 0xED03, 0xECE9, 0xECCE, 0xECB4, 0xEC9A, 
        0xEC80, 0xEC66, 0xEC4C, 0xEC33, 0xEC19, 0xEC00, 0xEBE6, 0xEBCD, 
        0xEBB4, 0xEB9B, 0xEB82, 0xEB6A, 0xEB51, 0xEB39, 0xEB21, 0xEB09, 
        0xEAF1, 0xEAD9, 0xEAC2, 0xEAAB, 0xEA93, 0xEA7D, 0xEA66, 0xEA50, 
        0xEA39, 0xEA23, 0xEA0E, 0xE9F8, 0xE9E3, 0xE9CE, 0xE9B9, 0xE9A4, 
        0xE990, 0xE97C, 0xE968, 0xE954, 0xE941, 0xE92E, 0xE91B, 0xE909, 
        0xE8F6, 0xE8E4, 0xE8D3, 0xE8C1, 0xE8B0, 0xE8A0, 0xE88F, 0xE87F, 
        0xE86F, 0xE85F, 0xE850, 0xE841, 0xE832, 0xE824, 0xE815, 0xE808, 
        0xE7FA, 0xE7ED, 0xE7E0, 0xE7D3, 0xE7C7, 0xE7BB, 0xE7AF, 0xE7A4, 
        0xE799, 0xE78E, 0xE783, 0xE779, 0xE76F, 0xE766, 0xE75C, 0xE753, 
        0xE74B, 0xE742, 0xE73A, 0xE732, 0xE72B, 0xE723, 0xE71C, 0xE716, 
        0xE70F, 0xE709, 0xE703, 0xE6FE, 0xE6F8, 0xE6F3, 0xE6EE, 0xE6EA, 
        0xE6E5, 0xE6E1, 0xE6DE, 0xE6DA, 0xE6D6, 0xE6D3, 0xE6D0, 0xE6CE, 
        0xE6CB, 0xE6C9, 0xE6C7, 0xE6C5, 0xE6C3, 0xE6C1, 0xE6C0, 0xE6BE, 
        0xE6BD, 0xE6BC, 0xE6BC, 0xE6BB, 0xE6BA, 0xE6BA, 0xE6B9, 0xE6B9, 
        0xE6B9, 0xE6B9, 0xE6B9, 0xE6B9, 0xE6B9, 0xE6BA, 0xE6BA, 0xE6BA, 
        0xE6BA, 0xE6BB, 0xE6BB, 0xE6BB, 0xE6BC, 0xE6BC, 0xE6BC, 0xE6BD, 
        0xE6BD, 0xE6BD, 0xE6BD, 0xE6BD, 0xE6BD, 0xE6BD, 0xE6BD, 0xE6BC, 
        0xE6BC, 0xE6BB, 0xE6BA, 0xE6B9, 0xE6B8, 0xE6B7, 0xE6B5, 0xE6B3, 
        0xE6B1, 0xE6AF, 0xE6AD, 0xE6AA, 0xE6A7, 0xE6A4, 0xE6A0, 0xE69D, 
        0xE699, 0xE694, 0xE68F, 0xE68A, 0xE685, 0xE67F, 0xE679, 0xE672, 
        0xE66B, 0xE664, 0xE65C, 0xE654, 0xE64B, 0xE642, 0xE639, 0xE62F, 
        0xE624, 0xE619, 0xE60E, 0xE602, 0xE5F5, 0xE5E8, 0xE5DA, 0xE5CC, 
        0xE5BD, 0xE5AE, 0xE59E, 0xE58D, 0xE57C, 0xE56A, 0xE558, 0xE545, 
        0xE531, 0xE51D, 0xE508, 0xE4F2, 0xE4DB, 0xE4C4, 0xE4AC, 0xE494, 
        0xE47B, 0xE460, 0xE446, 0xE42A, 0xE40E, 0xE3F1, 0xE3D3, 0xE3B4, 
        0xE395, 0xE375, 0xE354, 0xE332, 0xE30F, 0xE2EC, 0xE2C7, 0xE2A2, 
        0xE27C, 0xE255, 0xE22E, 0xE205, 0xE1DC, 0xE1B1, 0xE186, 0xE15A, 
        0xE12D, 0xE0FF, 0xE0D1, 0xE0A1, 0xE070, 0xE03F, 0xE00D, 0xDFD9, 
        0xDFA5, 0xDF70, 0xDF3A, 0xDF03, 0xDECB, 0xDE93, 0xDE59, 0xDE1E, 
        0xDDE3, 0xDDA7, 0xDD69, 0xDD2B, 0xDCEC, 0xDCAC, 0xDC6B, 0xDC29, 
        0xDBE6, 0xDBA2, 0xDB5E, 0xDB18, 0xDAD2, 0xDA8A, 0xDA42, 0xD9F9, 
        0xD9AF, 0xD964, 0xD918, 0xD8CC, 0xD87E, 0xD830, 0xD7E1, 0xD791, 
        0xD740, 0xD6EE, 0xD69B, 0xD648, 0xD5F4, 0xD59F, 0xD549, 0xD4F3, 
        0xD49B, 0xD443, 0xD3EA, 0xD391, 0xD337, 0xD2DC, 0xD280, 0xD223, 
        0xD1C6, 0xD169, 0xD10A, 0xD0AB, 0xD04B, 0xCFEB, 0xCF8A, 0xCF28, 
        0xCEC6, 0xCE64, 0xCE00, 0xCD9C, 0xCD38, 0xCCD3, 0xCC6E, 0xCC08, 
        0xCBA2, 0xCB3B, 0xCAD4, 0xCA6D, 0xCA05, 0xC99C, 0xC934, 0xC8CB, 
        0xC861, 0xC7F8, 0xC78E, 0xC724, 0xC6B9, 0xC64F, 0xC5E4, 0xC579, 
        0xC50E, 0xC4A2, 0xC437, 0xC3CB, 0xC360, 0xC2F4, 0xC288, 0xC21D, 
        0xC1B1, 0xC145, 0xC0DA, 0xC06E, 0xC003, 0xBF97, 0xBF2C, 0xBEC1, 
        0xBE56, 0xBDEB, 0xBD81, 0xBD17, 0xBCAD, 0xBC43, 0xBBDA, 0xBB71, 
        0xBB09, 0xBAA1, 0xBA39, 0xB9D2, 0xB96B, 0xB905, 0xB89F, 0xB83A, 
        0xB7D5, 0xB771, 0xB70E, 0xB6AB, 0xB649, 0xB5E8, 0xB587, 0xB528, 
        0xB4C9, 0xB46A, 0xB40D, 0xB3B0, 0xB355, 0xB2FA, 0xB2A0, 0xB247, 
        0xB1EF, 0xB198, 0xB142, 0xB0EE, 0xB09A, 0xB047, 0xAFF6, 0xAFA5, 
        0xAF56, 0xAF08, 0xAEBC, 0xAE70, 0xAE26, 0xADDD, 0xAD96, 0xAD50, 
        0xAD0B, 0xACC7, 0xAC85, 0xAC45, 0xAC06, 0xABC8, 0xAB8C, 0xAB52, 
        0xAB19, 0xAAE2, 0xAAAC, 0xAA78, 0xAA45, 0xAA15, 0xA9E6, 0xA9B8, 
        0xA98D, 0xA963, 0xA93B, 0xA914, 0xA8F0, 0xA8CD, 0xA8AD, 0xA88E, 
        0xA871, 0xA856, 0xA83D, 0xA826, 0xA811, 0xA7FD, 0xA7EC, 0xA7DD, 
        0xA7D0, 0xA7C5, 0xA7BC, 0xA7B5, 0xA7B1, 0xA7AE, 0xA7AE, 0xA7AF, 
        0xA7B3, 0xA7B9, 0xA7C1, 0xA7CC, 0xA7D9, 0xA7E7, 0xA7F9, 0xA80C, 
        0xA822, 0xA83A, 0xA854, 0xA870, 0xA88F, 0xA8B0, 0xA8D4, 0xA8FA, 
        0xA922, 0xA94C, 0xA979, 0xA9A8, 0xA9DA, 0xAA0E, 0xAA44, 0xAA7D, 
        0xAAB8, 0xAAF6, 0xAB36, 0xAB78, 0xABBD, 0xAC04, 0xAC4D, 0xAC99, 
        0xACE8, 0xAD39, 0xAD8C, 0xADE1, 0xAE39, 0xAE94, 0xAEF1, 0xAF50, 
        0xAFB2, 0xB016, 0xB07C, 0xB0E5, 0xB150, 0xB1BE, 0xB22E, 0xB2A0, 
        0xB315, 0xB38C, 0xB406, 0xB482, 0xB500, 0xB580, 0xB603, 0xB688, 
        0xB70F, 0xB799, 0xB825, 0xB8B3, 0xB944, 0xB9D7, 0xBA6C, 0xBB03, 
        0xBB9C, 0xBC38, 0xBCD6, 0xBD76, 0xBE18, 0xBEBC, 0xBF62, 0xC00B, 
        0xC0B5, 0xC162, 0xC210, 0xC2C1, 0xC374, 0xC428, 0xC4DF, 0xC597, 
        0xC652, 0xC70E, 0xC7CD, 0xC88D, 0xC94F, 0xCA13, 0xCAD8, 0xCBA0, 
        0xCC69, 0xCD34, 0xCE00, 0xCECF, 0xCF9F, 0xD070, 0xD143, 0xD218, 
        0xD2EE, 0xD3C6, 0xD4A0, 0xD57A, 0xD657, 0xD734, 0xD813, 0xD8F4, 
        0xD9D6, 0xDAB9, 0xDB9D, 0xDC83, 0xDD6A, 0xDE52, 0xDF3B, 0xE025, 
        0xE110, 0xE1FD, 0xE2EA, 0xE3D9, 0xE4C8, 0xE5B9, 0xE6AA, 0xE79C, 
        0xE88F, 0xE983, 0xEA78, 0xEB6D, 0xEC64, 0xED5A, 0xEE52, 0xEF4A, 
        0xF042, 0xF13C, 0xF235, 0xF330, 0xF42A, 0xF525, 0xF621, 0xF71C, 
        0xF819, 0xF915, 0xFA11, 0xFB0E, 0xFC0B, 0xFD08, 0xFE06, 0xFF03, 
// Waveform 7:
        0x0000, 0x0068, 0x00D1, 0x0139, 0x01A2, 0x020A, 0x0273, 0x02DB, 
        0x0344, 0x03AC, 0x0415, 0x047D, 0x04E5, 0x054E, 0x05B6, 0x061E, 
        0x0687, 0x06EF, 0x0757, 0x07BF, 0x0827, 0x088F, 0x08F7, 0x095F, 
        0x09C7, 0x0A2F, 0x0A97, 0x0AFE, 0x0B66, 0x0BCD, 0x0C35, 0x0C9C, 
        0x0D04, 0x0D6B, 0x0DD2, 0x0E39, 0x0EA0, 0x0F07, 0x0F6E, 0x0FD5, 
        0x103B, 0x10A2, 0x1108, 0x116F, 0x11D5, 0x123B, 0x12A1, 0x1307, 
        0x136D, 0x13D2, 0x1438, 0x149D, 0x1503, 0x1568, 0x15CD, 0x1632, 
        0x1697, 0x16FB, 0x1760, 0x17C4, 0x1828, 0x188C, 0x18F0, 0x1954, 
        0x19B8, 0x1A1B, 0x1A7F, 0x1AE2, 0x1B45, 0x1BA8, 0x1C0A, 0x1C6D, 
        0x1CCF, 0x1D31, 0x1D93, 0x1DF5, 0x1E57, 0x1EB8, 0x1F1A, 0x1F7B, 
        0x1FDC, 0x203C, 0x209D, 0x20FD, 0x215D, 0x21BD, 0x221D, 0x227D, 
        0x22DC, 0x233B, 0x239A, 0x23F9, 0x2457, 0x24B5, 0x2513, 0x2571, 
        0x25CF, 0x262C, 0x2689, 0x26E6, 0x2743, 0x279F, 0x27FC, 0x2858, 
        0x28B3, 0x290F, 0x296A, 0x29C5, 0x2A20, 0x2A7A, 0x2AD5, 0x2B2F, 
        0x2B88, 0x2BE2, 0x2C3B, 0x2C94, 0x2CED, 0x2D45, 0x2D9D, 0x2DF5, 
        0x2E4D, 0x2EA4, 0x2EFB, 0x2F52, 0x2FA9, 0x2FFF, 0x3055, 0x30AB, 
        0x3100, 0x3155, 0x31AA, 0x31FF, 0x3253, 0x32A7, 0x32FA, 0x334E, 
        0x33A1, 0x33F4, 0x3446, 0x3498, 0x34EA, 0x353B, 0x358D, 0x35DE, 
        0x362E, 0x367E, 0x36CE, 0x371E, 0x376D, 0x37BC, 0x380B, 0x3859, 
        0x38A7, 0x38F5, 0x3942, 0x398F, 0x39DC, 0x3A28, 0x3A74, 0x3AC0, 
        0x3B0B, 0x3B56, 0x3BA1, 0x3BEB, 0x3C35, 0x3C7F, 0x3CC8, 0x3D11, 
        0x3D59, 0x3DA1, 0x3DE9, 0x3E31, 0x3E78, 0x3EBF, 0x3F05, 0x3F4B, 
        0x3F91, 0x3FD6, 0x401B, 0x405F, 0x40A4, 0x40E7, 0x412B, 0x416E, 
        0x41B1, 0x41F3, 0x4235, 0x4277, 0x42B8, 0x42F9, 0x4339, 0x4379, 
        0x43B9, 0x43F8, 0x4437, 0x4475, 0x44B3, 0x44F1, 0x452F, 0x456B, 
        0x45A8, 0x45E4, 0x4620, 0x465B, 0x4696, 0x46D1, 0x470B, 0x4745, 
        0x477E, 0x47B7, 0x47F0, 0x4828, 0x4860, 0x4897, 0x48CE, 0x4904, 
        0x493A, 0x4970, 0x49A5, 0x49DA, 0x4A0F, 0x4A43, 0x4A76, 0x4AAA, 
        0x4ADD, 0x4B0F, 0x4B41, 0x4B72, 0x4BA4, 0x4BD4, 0x4C05, 0x4C35, 
        0x4C64, 0x4C93, 0x4CC2, 0x4CF0, 0x4D1E, 0x4D4B, 0x4D78, 0x4DA4, 
        0x4DD0, 0x4DFC, 0x4E27, 0x4E52, 0x4E7C, 0x4EA6, 0x4ED0, 0x4EF9, 
        0x4F22, 0x4F4A, 0x4F72, 0x4F99, 0x4FC0, 0x4FE6, 0x500C, 0x5032, 
        0x5057, 0x507C, 0x50A0, 0x50C4, 0x50E8, 0x510B, 0x512D, 0x514F, 
        0x5171, 0x5192, 0x51B3, 0x51D3, 0x51F3, 0x5213, 0x5232, 0x5251, 
        0x526F, 0x528D, 0x52AA, 0x52C7, 0x52E3, 0x52FF, 0x531B, 0x5336, 
        0x5351, 0x536B, 0x5385, 0x539E, 0x53B7, 0x53D0, 0x53E8, 0x53FF, 
        0x5416, 0x542D, 0x5443, 0x5459, 0x546F, 0x5484, 0x5498, 0x54AC, 
        0x54C0, 0x54D3, 0x54E6, 0x54F9, 0x550A, 0x551C, 0x552D, 0x553E, 
        0x554E, 0x555E, 0x556D, 0x557C, 0x558A, 0x5598, 0x55A6, 0x55B3, 
        0x55C0, 0x55CC, 0x55D8, 0x55E3, 0x55EE, 0x55F9, 0x5603, 0x560C, 
        0x5616, 0x561F, 0x5627, 0x562F, 0x5636, 0x563E, 0x5644, 0x564A, 
        0x5650, 0x5656, 0x565B, 0x565F, 0x5663, 0x5667, 0x566A, 0x566D, 
        0x5670, 0x5672, 0x5673, 0x5674, 0x5675, 0x5676, 0x5676, 0x5675, 
        0x5674, 0x5673, 0x5671, 0x566F, 0x566C, 0x5669, 0x5666, 0x5662, 
        0x565E, 0x5659, 0x5654, 0x564F, 0x5649, 0x5643, 0x563C, 0x5635, 
        0x562E, 0x5626, 0x561E, 0x5615, 0x560C, 0x5603, 0x55F9, 0x55EF, 
        0x55E4, 0x55D9, 0x55CE, 0x55C2, 0x55B6, 0x55A9, 0x559C, 0x558F, 
        0x5581, 0x5573, 0x5564, 0x5556, 0x5546, 0x5537, 0x5527, 0x5516, 
        0x5505, 0x54F4, 0x54E3, 0x54D1, 0x54BF, 0x54AC, 0x5499, 0x5486, 
        0x5472, 0x545E, 0x5449, 0x5435, 0x541F, 0x540A, 0x53F4, 0x53DE, 
        0x53C7, 0x53B0, 0x5399, 0x5381, 0x5369, 0x5351, 0x5338, 0x531F, 
        0x5305, 0x52EC, 0x52D2, 0x52B7, 0x529C, 0x5281, 0x5266, 0x524A, 
        0x522E, 0x5211, 0x51F5, 0x51D7, 0x51BA, 0x519C, 0x517E, 0x5160, 
        0x5141, 0x5122, 0x5103, 0x50E3, 0x50C3, 0x50A3, 0x5082, 0x5061, 
        0x5040, 0x501E, 0x4FFC, 0x4FDA, 0x4FB8, 0x4F95, 0x4F72, 0x4F4F, 
        0x4F2B, 0x4F07, 0x4EE3, 0x4EBE, 0x4E99, 0x4E74, 0x4E4F, 0x4E29, 
        0x4E03, 0x4DDD, 0x4DB6, 0x4D90, 0x4D69, 0x4D41, 0x4D1A, 0x4CF2, 
        0x4CCA, 0x4CA1, 0x4C79, 0x4C50, 0x4C26, 0x4BFD, 0x4BD3, 0x4BA9, 
        0x4B7F, 0x4B55, 0x4B2A, 0x4AFF, 0x4AD4, 0x4AA8, 0x4A7C, 0x4A50, 
        0x4A24, 0x49F8, 0x49CB, 0x499E, 0x4971, 0x4944, 0x4916, 0x48E8, 
        0x48BA, 0x488C, 0x485E, 0x482F, 0x4800, 0x47D1, 0x47A2, 0x4772, 
        0x4742, 0x4712, 0x46E2, 0x46B2, 0x4681, 0x4650, 0x461F, 0x45EE, 
        0x45BD, 0x458B, 0x455A, 0x4528, 0x44F6, 0x44C3, 0x4491, 0x445E, 
        0x442B, 0x43F8, 0x43C5, 0x4392, 0x435E, 0x432A, 0x42F7, 0x42C3, 
        0x428E, 0x425A, 0x4225, 0x41F1, 0x41BC, 0x4187, 0x4152, 0x411D, 
        0x40E7, 0x40B2, 0x407C, 0x4046, 0x4010, 0x3FDA, 0x3FA4, 0x3F6D, 
        0x3F37, 0x3F00, 0x3EC9, 0x3E92, 0x3E5B, 0x3E24, 0x3DED, 0x3DB6, 
        0x3D7E, 0x3D47, 0x3D0F, 0x3CD7, 0x3C9F, 0x3C67, 0x3C2F, 0x3BF7, 
        0x3BBE, 0x3B86, 0x3B4D, 0x3B15, 0x3ADC, 0x3AA3, 0x3A6A, 0x3A31, 
        0x39F8, 0x39BF, 0x3986, 0x394C, 0x3913, 0x38DA, 0x38A0, 0x3867, 
        0x382D, 0x37F3, 0x37B9, 0x3780, 0x3746, 0x370C, 0x36D2, 0x3698, 
        0x365D, 0x3623, 0x35E9, 0x35AF, 0x3574, 0x353A, 0x3500, 0x34C5, 
        0x348B, 0x3450, 0x3416, 0x33DB, 0x33A0, 0x3366, 0x332B, 0x32F1, 
        0x32B6, 0x327B, 0x3240, 0x3206, 0x31CB, 0x3190, 0x3155, 0x311B, 
        0x30E0, 0x30A5, 0x306A, 0x302F, 0x2FF4, 0x2FBA, 0x2F7F, 0x2F44, 
        0x2F09, 0x2ECF, 0x2E94, 0x2E59, 0x2E1E, 0x2DE4, 0x2DA9, 0x2D6E, 
        0x2D34, 0x2CF9, 0x2CBE, 0x2C84, 0x2C49, 0x2C0F, 0x2BD4, 0x2B9A, 
        0x2B5F, 0x2B25, 0x2AEB, 0x2AB0, 0x2A76, 0x2A3C, 0x2A02, 0x29C8, 
        0x298E, 0x2954, 0x291A, 0x28E0, 0x28A6, 0x286C, 0x2833, 0x27F9, 
        0x27BF, 0x2786, 0x274C, 0x2713, 0x26DA, 0x26A0, 0x2667, 0x262E, 
        0x25F5, 0x25BC, 0x2583, 0x254B, 0x2512, 0x24D9, 0x24A1, 0x2468, 
        0x2430, 0x23F8, 0x23C0, 0x2388, 0x2350, 0x2318, 0x22E0, 0x22A8, 
        0x2271, 0x2239, 0x2202, 0x21CB, 0x2194, 0x215D, 0x2126, 0x20EF, 
        0x20B8, 0x2082, 0x204B, 0x2015, 0x1FDF, 0x1FA8, 0x1F72, 0x1F3D, 
        0x1F07, 0x1ED1, 0x1E9C, 0x1E66, 0x1E31, 0x1DFC, 0x1DC7, 0x1D92, 
        0x1D5D, 0x1D29, 0x1CF4, 0x1CC0, 0x1C8C, 0x1C58, 0x1C24, 0x1BF0, 
        0x1BBD, 0x1B89, 0x1B56, 0x1B23, 0x1AF0, 0x1ABD, 0x1A8A, 0x1A58, 
        0x1A25, 0x19F3, 0x19C1, 0x198F, 0x195D, 0x192C, 0x18FA, 0x18C9, 
        0x1898, 0x1867, 0x1836, 0x1805, 0x17D5, 0x17A5, 0x1775, 0x1745, 
        0x1715, 0x16E5, 0x16B6, 0x1686, 0x1657, 0x1628, 0x15FA, 0x15CB, 
        0x159D, 0x156E, 0x1540, 0x1513, 0x14E5, 0x14B7, 0x148A, 0x145D, 
        0x1430, 0x1403, 0x13D7, 0x13AA, 0x137E, 0x1352, 0x1326, 0x12FA, 
        0x12CF, 0x12A4, 0x1279, 0x124E, 0x1223, 0x11F9, 0x11CE, 0x11A4, 
        0x117A, 0x1151, 0x1127, 0x10FE, 0x10D5, 0x10AC, 0x1083, 0x105A, 
        0x1032, 0x100A, 0x0FE2, 0x0FBA, 0x0F93, 0x0F6B, 0x0F44, 0x0F1D, 
        0x0EF7, 0x0ED0, 0x0EAA, 0x0E84, 0x0E5E, 0x0E38, 0x0E13, 0x0DED, 
        0x0DC8, 0x0DA4, 0x0D7F, 0x0D5A, 0x0D36, 0x0D12, 0x0CEE, 0x0CCB, 
        0x0CA7, 0x0C84, 0x0C61, 0x0C3E, 0x0C1C, 0x0BF9, 0x0BD7, 0x0BB5, 
        0x0B94, 0x0B72, 0x0B51, 0x0B30, 0x0B0F, 0x0AEE, 0x0ACE, 0x0AAE, 
        0x0A8E, 0x0A6E, 0x0A4E, 0x0A2F, 0x0A10, 0x09F1, 0x09D2, 0x09B3, 
        0x0995, 0x0977, 0x0959, 0x093B, 0x091E, 0x0901, 0x08E4, 0x08C7, 
        0x08AA, 0x088E, 0x0872, 0x0856, 0x083A, 0x081E, 0x0803, 0x07E8, 
        0x07CD, 0x07B2, 0x0798, 0x077D, 0x0763, 0x074A, 0x0730, 0x0716, 
        0x06FD, 0x06E4, 0x06CB, 0x06B3, 0x069A, 0x0682, 0x066A, 0x0652, 
        0x063B, 0x0624, 0x060C, 0x05F5, 0x05DF, 0x05C8, 0x05B2, 0x059C, 
        0x0586, 0x0570, 0x055B, 0x0545, 0x0530, 0x051B, 0x0507, 0x04F2, 
        0x04DE, 0x04CA, 0x04B6, 0x04A2, 0x048F, 0x047B, 0x0468, 0x0455, 
        0x0443, 0x0430, 0x041E, 0x040C, 0x03FA, 0x03E8, 0x03D6, 0x03C5, 
        0x03B4, 0x03A3, 0x0392, 0x0382, 0x0371, 0x0361, 0x0351, 0x0341, 
        0x0332, 0x0322, 0x0313, 0x0304, 0x02F5, 0x02E6, 0x02D7, 0x02C9, 
        0x02BB, 0x02AD, 0x029F, 0x0291, 0x0284, 0x0277, 0x026A, 0x025D, 
        0x0250, 0x0243, 0x0237, 0x022B, 0x021F, 0x0213, 0x0207, 0x01FB, 
        0x01F0, 0x01E5, 0x01DA, 0x01CF, 0x01C4, 0x01B9, 0x01AF, 0x01A5, 
        0x019A, 0x0190, 0x0187, 0x017D, 0x0174, 0x016A, 0x0161, 0x0158, 
        0x014F, 0x0146, 0x013E, 0x0135, 0x012D, 0x0125, 0x011D, 0x0115, 
        0x010D, 0x0106, 0x00FE, 0x00F7, 0x00F0, 0x00E9, 0x00E2, 0x00DB, 
        0x00D4, 0x00CE, 0x00C8, 0x00C1, 0x00BB, 0x00B5, 0x00AF, 0x00AA, 
        0x00A4, 0x009F, 0x0099, 0x0094, 0x008F, 0x008A, 0x0085, 0x0080, 
        0x007C, 0x0077, 0x0073, 0x006E, 0x006A, 0x0066, 0x0062, 0x005E, 
        0x005A, 0x0057, 0x0053, 0x004F, 0x004C, 0x0049, 0x0046, 0x0042, 
        0x003F, 0x003C, 0x003A, 0x0037, 0x0034, 0x0032, 0x002F, 0x002D, 
        0x002A, 0x0028, 0x0026, 0x0024, 0x0022, 0x0020, 0x001E, 0x001C, 
        0x001B, 0x0019, 0x0017, 0x0016, 0x0014, 0x0013, 0x0012, 0x0010, 
        0x000F, 0x000E, 0x000D, 0x000C, 0x000B, 0x000A, 0x0009, 0x0008, 
        0x0008, 0x0007, 0x0006, 0x0005, 0x0005, 0x0004, 0x0004, 0x0003, 
        0x0003, 0x0002, 0x0002, 0x0002, 0x0001, 0x0001, 0x0001, 0x0001, 
        0x0001, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 
        0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFF, 0xFFFE, 0xFFFE, 0xFFFE, 
        0xFFFD, 0xFFFD, 0xFFFC, 0xFFFC, 0xFFFB, 0xFFFB, 0xFFFA, 0xFFF9, 
        0xFFF8, 0xFFF8, 0xFFF7, 0xFFF6, 0xFFF5, 0xFFF4, 0xFFF3, 0xFFF2, 
        0xFFF1, 0xFFF0, 0xFFEE, 0xFFED, 0xFFEC, 0xFFEA, 0xFFE9, 0xFFE7, 
        0xFFE5, 0xFFE4, 0xFFE2, 0xFFE0, 0xFFDE, 0xFFDC, 0xFFDA, 0xFFD8, 
        0xFFD6, 0xFFD3, 0xFFD1, 0xFFCE, 0xFFCC, 0xFFC9, 0xFFC6, 0xFFC4, 
        0xFFC1, 0xFFBE, 0xFFBA, 0xFFB7, 0xFFB4, 0xFFB1, 0xFFAD, 0xFFA9, 
        0xFFA6, 0xFFA2, 0xFF9E, 0xFF9A, 0xFF96, 0xFF92, 0xFF8D, 0xFF89, 
        0xFF84, 0xFF80, 0xFF7B, 0xFF76, 0xFF71, 0xFF6C, 0xFF67, 0xFF61, 
        0xFF5C, 0xFF56, 0xFF51, 0xFF4B, 0xFF45, 0xFF3F, 0xFF38, 0xFF32, 
        0xFF2C, 0xFF25, 0xFF1E, 0xFF17, 0xFF10, 0xFF09, 0xFF02, 0xFEFA, 
        0xFEF3, 0xFEEB, 0xFEE3, 0xFEDB, 0xFED3, 0xFECB, 0xFEC2, 0xFEBA, 
        0xFEB1, 0xFEA8, 0xFE9F, 0xFE96, 0xFE8D, 0xFE83, 0xFE79, 0xFE70, 
        0xFE66, 0xFE5B, 0xFE51, 0xFE47, 0xFE3C, 0xFE31, 0xFE26, 0xFE1B, 
        0xFE10, 0xFE05, 0xFDF9, 0xFDED, 0xFDE2, 0xFDD5, 0xFDC9, 0xFDBD, 
        0xFDB0, 0xFDA3, 0xFD96, 0xFD89, 0xFD7C, 0xFD6F, 0xFD61, 0xFD53, 
        0xFD45, 0xFD37, 0xFD29, 0xFD1A, 0xFD0B, 0xFCFC, 0xFCED, 0xFCDE, 
        0xFCCF, 0xFCBF, 0xFCAF, 0xFC9F, 0xFC8F, 0xFC7E, 0xFC6E, 0xFC5D, 
        0xFC4C, 0xFC3B, 0xFC2A, 0xFC18, 0xFC06, 0xFBF4, 0xFBE2, 0xFBD0, 
        0xFBBD, 0xFBAB, 0xFB98, 0xFB85, 0xFB71, 0xFB5E, 0xFB4A, 0xFB36, 
        0xFB22, 0xFB0E, 0xFAF9, 0xFAE5, 0xFAD0, 0xFABB, 0xFAA5, 0xFA90, 
        0xFA7A, 0xFA64, 0xFA4E, 0xFA38, 0xFA21, 0xFA0B, 0xF9F4, 0xF9DD, 
        0xF9C5, 0xF9AE, 0xF996, 0xF97E, 0xF966, 0xF94D, 0xF935, 0xF91C, 
        0xF903, 0xF8EA, 0xF8D0, 0xF8B6, 0xF89D, 0xF883, 0xF868, 0xF84E, 
        0xF833, 0xF818, 0xF7FD, 0xF7E2, 0xF7C6, 0xF7AA, 0xF78E, 0xF772, 
        0xF756, 0xF739, 0xF71C, 0xF6FF, 0xF6E2, 0xF6C5, 0xF6A7, 0xF689, 
        0xF66B, 0xF64D, 0xF62E, 0xF60F, 0xF5F0, 0xF5D1, 0xF5B2, 0xF592, 
        0xF572, 0xF552, 0xF532, 0xF512, 0xF4F1, 0xF4D0, 0xF4AF, 0xF48E, 
        0xF46C, 0xF44B, 0xF429, 0xF407, 0xF3E4, 0xF3C2, 0xF39F, 0xF37C, 
        0xF359, 0xF335, 0xF312, 0xF2EE, 0xF2CA, 0xF2A6, 0xF281, 0xF25D, 
        0xF238, 0xF213, 0xF1ED, 0xF1C8, 0xF1A2, 0xF17C, 0xF156, 0xF130, 
        0xF109, 0xF0E3, 0xF0BC, 0xF095, 0xF06D, 0xF046, 0xF01E, 0xEFF6, 
        0xEFCE, 0xEFA6, 0xEF7D, 0xEF54, 0xEF2B, 0xEF02, 0xEED9, 0xEEAF, 
        0xEE86, 0xEE5C, 0xEE32, 0xEE07, 0xEDDD, 0xEDB2, 0xED87, 0xED5C, 
        0xED31, 0xED06, 0xECDA, 0xECAE, 0xEC82, 0xEC56, 0xEC29, 0xEBFD, 
        0xEBD0, 0xEBA3, 0xEB76, 0xEB49, 0xEB1B, 0xEAEE, 0xEAC0, 0xEA92, 
        0xEA63, 0xEA35, 0xEA06, 0xE9D8, 0xE9A9, 0xE97A, 0xE94A, 0xE91B, 
        0xE8EB, 0xE8BB, 0xE88B, 0xE85B, 0xE82B, 0xE7FB, 0xE7CA, 0xE799, 
        0xE768, 0xE737, 0xE706, 0xE6D4, 0xE6A3, 0xE671, 0xE63F, 0xE60D, 
        0xE5DB, 0xE5A8, 0xE576, 0xE543, 0xE510, 0xE4DD, 0xE4AA, 0xE477, 
        0xE443, 0xE410, 0xE3DC, 0xE3A8, 0xE374, 0xE340, 0xE30C, 0xE2D7, 
        0xE2A3, 0xE26E, 0xE239, 0xE204, 0xE1CF, 0xE19A, 0xE164, 0xE12F, 
        0xE0F9, 0xE0C4, 0xE08E, 0xE058, 0xE022, 0xDFEB, 0xDFB5, 0xDF7E, 
        0xDF48, 0xDF11, 0xDEDA, 0xDEA3, 0xDE6C, 0xDE35, 0xDDFE, 0xDDC7, 
        0xDD8F, 0xDD58, 0xDD20, 0xDCE8, 0xDCB0, 0xDC78, 0xDC40, 0xDC08, 
        0xDBD0, 0xDB98, 0xDB5F, 0xDB27, 0xDAEE, 0xDAB5, 0xDA7D, 0xDA44, 
        0xDA0B, 0xD9D2, 0xD999, 0xD960, 0xD926, 0xD8ED, 0xD8B4, 0xD87A, 
        0xD841, 0xD807, 0xD7CE, 0xD794, 0xD75A, 0xD720, 0xD6E6, 0xD6AC, 
        0xD672, 0xD638, 0xD5FE, 0xD5C4, 0xD58A, 0xD550, 0xD515, 0xD4DB, 
        0xD4A1, 0xD466, 0xD42C, 0xD3F1, 0xD3B7, 0xD37C, 0xD342, 0xD307, 
        0xD2CD, 0xD292, 0xD257, 0xD21D, 0xD1E2, 0xD1A7, 0xD16C, 0xD132, 
        0xD0F7, 0xD0BC, 0xD081, 0xD046, 0xD00C, 0xCFD1, 0xCF96, 0xCF5B, 
        0xCF20, 0xCEE6, 0xCEAB, 0xCE70, 0xCE35, 0xCDFA, 0xCDC0, 0xCD85, 
        0xCD4A, 0xCD10, 0xCCD5, 0xCC9A, 0xCC60, 0xCC25, 0xCBEA, 0xCBB0, 
        0xCB75, 0xCB3B, 0xCB00, 0xCAC6, 0xCA8C, 0xCA51, 0xCA17, 0xC9DD, 
        0xC9A3, 0xC969, 0xC92E, 0xC8F4, 0xC8BA, 0xC881, 0xC847, 0xC80D, 
        0xC7D3, 0xC79A, 0xC760, 0xC726, 0xC6ED, 0xC6B4, 0xC67A, 0xC641, 
        0xC608, 0xC5CF, 0xC596, 0xC55D, 0xC524, 0xC4EB, 0xC4B3, 0xC47A, 
        0xC442, 0xC409, 0xC3D1, 0xC399, 0xC361, 0xC329, 0xC2F1, 0xC2BA, 
        0xC282, 0xC24A, 0xC213, 0xC1DC, 0xC1A5, 0xC16E, 0xC137, 0xC100, 
        0xC0C9, 0xC093, 0xC05C, 0xC026, 0xBFF0, 0xBFBA, 0xBF84, 0xBF4E, 
        0xBF19, 0xBEE3, 0xBEAE, 0xBE79, 0xBE44, 0xBE0F, 0xBDDB, 0xBDA6, 
        0xBD72, 0xBD3E, 0xBD09, 0xBCD6, 0xBCA2, 0xBC6E, 0xBC3B, 0xBC08, 
        0xBBD5, 0xBBA2, 0xBB6F, 0xBB3D, 0xBB0B, 0xBAD8, 0xBAA6, 0xBA75, 
        0xBA43, 0xBA12, 0xB9E1, 0xB9B0, 0xB97F, 0xB94E, 0xB91E, 0xB8EE, 
        0xB8BE, 0xB88E, 0xB85E, 0xB82F, 0xB800, 0xB7D1, 0xB7A2, 0xB774, 
        0xB746, 0xB718, 0xB6EA, 0xB6BC, 0xB68F, 0xB662, 0xB635, 0xB608, 
        0xB5DC, 0xB5B0, 0xB584, 0xB558, 0xB52C, 0xB501, 0xB4D6, 0xB4AC, 
        0xB481, 0xB457, 0xB42D, 0xB403, 0xB3DA, 0xB3B0, 0xB388, 0xB35F, 
        0xB336, 0xB30E, 0xB2E6, 0xB2BF, 0xB297, 0xB270, 0xB24A, 0xB223, 
        0xB1FD, 0xB1D7, 0xB1B1, 0xB18C, 0xB167, 0xB142, 0xB11D, 0xB0F9, 
        0xB0D5, 0xB0B2, 0xB08E, 0xB06B, 0xB048, 0xB026, 0xB004, 0xAFE2, 
        0xAFC0, 0xAF9F, 0xAF7E, 0xAF5D, 0xAF3D, 0xAF1D, 0xAEFD, 0xAEDE, 
        0xAEBF, 0xAEA0, 0xAE82, 0xAE64, 0xAE46, 0xAE29, 0xAE0B, 0xADEF, 
        0xADD2, 0xADB6, 0xAD9A, 0xAD7F, 0xAD64, 0xAD49, 0xAD2F, 0xAD14, 
        0xACFB, 0xACE1, 0xACC8, 0xACAF, 0xAC97, 0xAC7F, 0xAC67, 0xAC50, 
        0xAC39, 0xAC22, 0xAC0C, 0xABF6, 0xABE1, 0xABCC, 0xABB7, 0xABA2, 
        0xAB8E, 0xAB7A, 0xAB67, 0xAB54, 0xAB41, 0xAB2F, 0xAB1D, 0xAB0C, 
        0xAAFB, 0xAAEA, 0xAAD9, 0xAAC9, 0xAABA, 0xAAAA, 0xAA9C, 0xAA8D, 
        0xAA7F, 0xAA71, 0xAA64, 0xAA57, 0xAA4A, 0xAA3E, 0xAA32, 0xAA27, 
        0xAA1C, 0xAA11, 0xAA07, 0xA9FD, 0xA9F4, 0xA9EB, 0xA9E2, 0xA9DA, 
        0xA9D2, 0xA9CB, 0xA9C4, 0xA9BD, 0xA9B7, 0xA9B1, 0xA9AC, 0xA9A7, 
        0xA9A2, 0xA99E, 0xA99A, 0xA997, 0xA994, 0xA991, 0xA98F, 0xA98D, 
        0xA98C, 0xA98B, 0xA98A, 0xA98A, 0xA98B, 0xA98C, 0xA98D, 0xA98E, 
        0xA990, 0xA993, 0xA996, 0xA999, 0xA99D, 0xA9A1, 0xA9A5, 0xA9AA, 
        0xA9B0, 0xA9B6, 0xA9BC, 0xA9C2, 0xA9CA, 0xA9D1, 0xA9D9, 0xA9E1, 
        0xA9EA, 0xA9F4, 0xA9FD, 0xAA07, 0xAA12, 0xAA1D, 0xAA28, 0xAA34, 
        0xAA40, 0xAA4D, 0xAA5A, 0xAA68, 0xAA76, 0xAA84, 0xAA93, 0xAAA2, 
        0xAAB2, 0xAAC2, 0xAAD3, 0xAAE4, 0xAAF6, 0xAB07, 0xAB1A, 0xAB2D, 
        0xAB40, 0xAB54, 0xAB68, 0xAB7C, 0xAB91, 0xABA7, 0xABBD, 0xABD3, 
        0xABEA, 0xAC01, 0xAC18, 0xAC30, 0xAC49, 0xAC62, 0xAC7B, 0xAC95, 
        0xACAF, 0xACCA, 0xACE5, 0xAD01, 0xAD1D, 0xAD39, 0xAD56, 0xAD73, 
        0xAD91, 0xADAF, 0xADCE, 0xADED, 0xAE0D, 0xAE2D, 0xAE4D, 0xAE6E, 
        0xAE8F, 0xAEB1, 0xAED3, 0xAEF5, 0xAF18, 0xAF3C, 0xAF60, 0xAF84, 
        0xAFA9, 0xAFCE, 0xAFF4, 0xB01A, 0xB040, 0xB067, 0xB08E, 0xB0B6, 
        0xB0DE, 0xB107, 0xB130, 0xB15A, 0xB183, 0xB1AE, 0xB1D9, 0xB204, 
        0xB22F, 0xB25C, 0xB288, 0xB2B5, 0xB2E2, 0xB310, 0xB33E, 0xB36D, 
        0xB39C, 0xB3CB, 0xB3FB, 0xB42C, 0xB45C, 0xB48D, 0xB4BF, 0xB4F1, 
        0xB523, 0xB556, 0xB589, 0xB5BD, 0xB5F1, 0xB626, 0xB65B, 0xB690, 
        0xB6C6, 0xB6FC, 0xB732, 0xB769, 0xB7A0, 0xB7D8, 0xB810, 0xB849, 
        0xB882, 0xB8BB, 0xB8F5, 0xB92F, 0xB96A, 0xB9A5, 0xB9E0, 0xBA1C, 
        0xBA58, 0xBA94, 0xBAD1, 0xBB0F, 0xBB4C, 0xBB8B, 0xBBC9, 0xBC08, 
        0xBC47, 0xBC87, 0xBCC7, 0xBD07, 0xBD48, 0xBD89, 0xBDCB, 0xBE0D, 
        0xBE4F, 0xBE92, 0xBED5, 0xBF18, 0xBF5C, 0xBFA0, 0xBFE5, 0xC02A, 
        0xC06F, 0xC0B5, 0xC0FB, 0xC141, 0xC188, 0xC1CF, 0xC217, 0xC25E, 
        0xC2A7, 0xC2EF, 0xC338, 0xC381, 0xC3CB, 0xC415, 0xC45F, 0xC4AA, 
        0xC4F5, 0xC540, 0xC58C, 0xC5D8, 0xC624, 0xC671, 0xC6BE, 0xC70B, 
        0xC759, 0xC7A7, 0xC7F5, 0xC844, 0xC893, 0xC8E2, 0xC932, 0xC982, 
        0xC9D2, 0xCA22, 0xCA73, 0xCAC4, 0xCB16, 0xCB68, 0xCBBA, 0xCC0C, 
        0xCC5F, 0xCCB2, 0xCD05, 0xCD59, 0xCDAD, 0xCE01, 0xCE56, 0xCEAB, 
        0xCF00, 0xCF55, 0xCFAB, 0xD001, 0xD057, 0xD0AE, 0xD104, 0xD15C, 
        0xD1B3, 0xD20B, 0xD262, 0xD2BB, 0xD313, 0xD36C, 0xD3C5, 0xD41E, 
        0xD478, 0xD4D1, 0xD52B, 0xD586, 0xD5E0, 0xD63B, 0xD696, 0xD6F1, 
        0xD74D, 0xD7A8, 0xD804, 0xD861, 0xD8BD, 0xD91A, 0xD977, 0xD9D4, 
        0xDA31, 0xDA8F, 0xDAED, 0xDB4B, 0xDBA9, 0xDC07, 0xDC66, 0xDCC5, 
        0xDD24, 0xDD83, 0xDDE3, 0xDE43, 0xDEA3, 0xDF03, 0xDF63, 0xDFC4, 
        0xE024, 0xE085, 0xE0E6, 0xE148, 0xE1A9, 0xE20B, 0xE26C, 0xE2CE, 
        0xE331, 0xE393, 0xE3F6, 0xE458, 0xE4BB, 0xE51E, 0xE581, 0xE5E5, 
        0xE648, 0xE6AC, 0xE70F, 0xE773, 0xE7D8, 0xE83C, 0xE8A0, 0xE905, 
        0xE969, 0xE9CE, 0xEA33, 0xEA98, 0xEAFD, 0xEB63, 0xEBC8, 0xEC2E, 
        0xEC93, 0xECF9, 0xED5F, 0xEDC5, 0xEE2B, 0xEE91, 0xEEF8, 0xEF5E, 
        0xEFC5, 0xF02B, 0xF092, 0xF0F9, 0xF160, 0xF1C7, 0xF22E, 0xF295, 
        0xF2FC, 0xF364, 0xF3CB, 0xF432, 0xF49A, 0xF502, 0xF569, 0xF5D1, 
        0xF639, 0xF6A1, 0xF709, 0xF771, 0xF7D9, 0xF841, 0xF8A9, 0xF911, 
        0xF979, 0xF9E2, 0xFA4A, 0xFAB2, 0xFB1B, 0xFB83, 0xFBEB, 0xFC54, 
        0xFCBC, 0xFD25, 0xFD8D, 0xFDF6, 0xFE5E, 0xFEC7, 0xFF2F, 0xFF98} ;

// ADVAL
int snd_free (int n)
{
	n &= 3 ; // 0,1,2,3
	n = sndqr[n] - sndqw[n] ;
	if (n <= 0)
		n += SOUNDQL ;
	return n - SOUNDQE ;
}

// ENVELOPE N,T,PI1,PI2,PI3,PN1,PN2,PN3,AA,AD,AS,AR,ALA,ALD
void envel (signed char *env)
{
	int n ;
	int chan = *env++ & 15 ;
	for (n = 0; n < 13; n++)
		*(envels + 16 * chan + n) = *env++ ;
	*(envels + 16 * chan + n) = 0 ; // Target for sustain & release
}

// SOUND Channel,Amplitude,Pitch,Duration
void sound (short chan, signed char ampl, unsigned char pitch, unsigned char duration)
{
	unsigned char al ;
	int index ;
	int ch = chan & 3 ;
	if (chan & 0xE000) return ;
	if (chan & 0x00F0) // Flush ?
	    {
		do
			sndqw[ch] = sndqr[ch] ; // might be interrupted
		while (sndqw[ch] != sndqr[ch]) ;
	    }
	al = sndqw[ch] ;
	index = ch * SOUNDQL + al ;
	soundq[index + 0] = duration ;
	soundq[index + 1] = pitch ;
	soundq[index + 2] = ampl ;
	soundq[index + 3] = chan >> 8 ;
	al += SOUNDQE ;
	if (al >= SOUNDQL)
		al = 0 ;
	while (al == sndqr[ch])
	    {
		sleep_ms (1) ;
		trap() ;
	    }
	sndqw[ch] = al ;
}

// Disable sound generation:
void quiet (void)
{
	int i ;
	for (i = 0; i < 4; i++)
	    {
		sndqw[i] = 0 ;
		sndqr[i] = 0 ;
		eenvel[i] = 0 ;
		sacc[i] = 0 ;
	    }
}

// Process note(s) from sound queue:
static unsigned char note (unsigned char mask)
{
	unsigned char al ;
	unsigned char ch ;
	for (ch = 0; ch < 4; ch++)
	    {
		while (((mask & BIT0) == 0) && ((al = sndqr[ch]) != sndqw[ch]))
		    {
			int index = ch * SOUNDQL + al ;
 			unsigned char duration = soundq[index + 0] ;
			unsigned char pitch = soundq[index + 1] ;
			signed char ampl = soundq[index + 2] ;
			unsigned char hs = soundq[index + 3] ;
			if (((mask & BIT1) == 0) && ((hs & 3) != 0))
			    {
				mask |= hs & 3 ; // waiting for sync
				break ;
			    }
			else
			    {
				soundq[index + 3] = 0x10 ;
				if ((hs & 0xF0) == 0)
				    {
					eenvel[ch] = ampl ;
					epitch[ch] = pitch ;
					easect[ch] = 0 ;
					epsect[ch] = 0 ;
					ecount[ch] = 0 ;
					escale[ch] = 1 ;
				    }
				if (duration == 0)
				    {
					easect[ch] = 3 ; // release phase
					if (ampl <= 0)
					    {
						epitch[ch] = 0 ; // silence
						if ((ch == 0) && (tempo < 128))
							eenvel[ch] = 0 ;
					    }
					al += SOUNDQE ;
					if (al >= SOUNDQL)
						al = 0 ;
					sndqr[ch] = al ;
					mask &= 0xFD ;
				    }
				else if (duration != 255)
				    {
					soundq[index + 0] = duration - 1 ;
					break ;
				    }
				else
					break ;
			    }
		    } ;
		mask = (mask >> 2) | (mask << 6) ;
	    }
	return mask ;
}

// Synthesise sound waveform:
static void tone (short *buffer)
{
	int i, ch ;
	unsigned char taps ;
	static unsigned short noise ;
	static unsigned int __attribute__((aligned(16))) tempi[4] ;
	static short __attribute__((aligned(16))) temps[8] ;

	for (ch = 0; ch < 4; ch++)
	    {
		signed char bl = eenvel[ch] ;
		if (bl < 0) // fixed amplitude
			elevel[ch] = -bl << 3 ;
		else if (bl == 0) // silence
		    {
			if (ch == 0)
				elevel[ch] = 0 ; // noise channel
			else
				epitch[ch] = 0 ;
		    }
		else // envelope
		    {
			escale[ch]-- ;
			if (escale[ch] == 0)
			    {
				signed char *ebx = envels + ((bl & 15) << 4) ;
				char cl = *ebx & 0x7F ; // strip repeat bit
				if (cl == 0) cl++ ;
				escale[ch] = cl ;
				unsigned char al = easect[ch] ; // amplitude section
				if (al < 4)
				    {
					signed char step = *(ebx + al + 7) ; // level change
					signed char target = *(ebx + al + 11) ; // target level
					signed char level = elevel[ch] ; // current level
					level += step ; // adjust level
					if ((level <= 0) && (step > 0)) level = 127 ;
					if ((level < 0) && (step < 0)) level = 0 ;
					elevel[ch] = level ; // update level
					if (((step < 0) && (level <= target)) ||
					    ((step > 0) && (level >= target)))
					    {
						al++ ; // move to next section
						if (al < 3)
						    {
							elevel[ch] = target ;
							easect[ch] = al ;
						    }
					    }
				    }
				al = epsect[ch] ; // pitch section
				if ((al >= 3) && ((*ebx & BIT7) == 0)) // repeat ?
				    {
					al = 0 ;
					epsect[ch] = 0 ;
					if (tempo & 0x40)
						epitch[ch] -= *(ebx+1) * *(ebx+4) +
							      *(ebx+2) * *(ebx+5) +
							      *(ebx+3) * *(ebx+6) ;
				    }
				if (al < 3)
				    {
					signed char step = *(ebx + al + 1) ; // pitch change
					unsigned char num = *(ebx + al + 4) ; // no.of steps
					ecount[ch]++ ;
					if (ecount[ch] >= num)
					    {
						ecount[ch] = 0 ;
						al++ ; // move to next section
						epsect[ch] = al ;
					    }
					if (num)
						epitch[ch] += step ;
				    }
			    }
		    }
	    }

	tempi[0] = voices[0] ;
	tempi[1] = voices[1] ;
	tempi[2] = voices[2] ;
	tempi[3] = voices[3] ;
	int wavep[4] = { tempi[0] << 11, tempi[1] << 11, tempi[2] << 11, tempi[3] << 11 } ;

	tempi[0] = freqs[epitch[0]] ;
	tempi[1] = freqs[epitch[1]] ;
	tempi[2] = freqs[epitch[2]] ;
	tempi[3] = freqs[epitch[3]] ;
	unsigned int inctp[4] = { tempi[0] << 14, tempi[1] << 14, tempi[2] << 14, tempi[3] << 14 } ;

	temps[0] = ampl[elevel[0]] ;
	temps[1] = ampl[elevel[1]] ;
	temps[2] = ampl[elevel[2]] ;
	temps[3] = ampl[elevel[3]] ;
	temps[4] = temps[0] ;
	temps[5] = temps[1] ;
	temps[6] = temps[2] ;
	temps[7] = temps[3] ;
	short smixp[8] = { (smix[0] * temps[0]) >> 16, (smix[1] * temps[1]) >> 16,
			   (smix[2] * temps[2]) >> 16, (smix[3] * temps[3]) >> 16, 
			   (smix[4] * temps[4]) >> 16, (smix[5] * temps[5]) >> 16, 
			   (smix[6] * temps[6]) >> 16, (smix[7] * temps[7]) >> 16 } ; 

	taps = noises[epitch[0] & 7] >> 3 ;
	if (noise == 0xFFFF) noise = 0 ;

	for (i = 0; i < AUDIO_CHUNK; i++) // samples in 0.01 seconds
	    {
		sacc[0] += inctp[0] ; sacc[1] += inctp[1] ; sacc[2] += inctp[2] ; sacc[3] += inctp[3] ;
		tempi[0] = (sacc[0] >> 21) + wavep[0] ; tempi[1] = (sacc[1] >> 21) + wavep[1] ;
		tempi[2] = (sacc[2] >> 21) + wavep[2] ; tempi[3] = (sacc[3] >> 21) + wavep[3] ;

		if (tempo < 128)
		    {
			noise = noise >> 1 ;
			noise |= (((noise & taps) == taps) || ((noise & taps) == 0)) << 15 ;
			tempi[0] = noise & 0x3FFF ;
		    }
		temps[0] = wavetable[tempi[0]] ;
		temps[1] = wavetable[tempi[1]] ;
		temps[2] = wavetable[tempi[2]] ;
		temps[3] = wavetable[tempi[3]] ;
 		temps[4] = temps[0] ;
 		temps[5] = temps[1] ;
 		temps[6] = temps[2] ;
 		temps[7] = temps[3] ;

		temps[0] = (temps[0] * smixp[0]) >> 16 ; temps[1] = (temps[1] * smixp[1]) >> 16 ; 
		temps[2] = (temps[2] * smixp[2]) >> 16 ; temps[3] = (temps[3] * smixp[3]) >> 16 ; 
		temps[4] = (temps[4] * smixp[4]) >> 16 ; temps[5] = (temps[5] * smixp[5]) >> 16 ; 
		temps[6] = (temps[6] * smixp[6]) >> 16 ; temps[7] = (temps[7] * smixp[7]) >> 16 ; 
		*buffer++ = (((int)temps[0] + (int)temps[1] + (int)temps[2] + (int)temps[3]) << 1) ; // left
		*buffer++ = (((int)temps[4] + (int)temps[5] + (int)temps[6] + (int)temps[7]) << 1) ; // right
	    }
}

// PWM Wrap Interrupt Handler (stereo, 8-fold over-sampling with dither)
void pwm_interrupt_handler(void)
{
    static unsigned short dither[8] = {0x8034, 0x8004, 0x8024, 0x8014, 0x803C, 0x800C, 0x802C, 0x801C};
    short *wav_ptr = waves + ((hwo >> 3) * 2);
    pwm_clear_irq(pwm_gpio_to_slice_num(AUDIO_PIN_L));
    if (waves == NULL) return;
    pwm_set_gpio_level(AUDIO_PIN_L, (*(wav_ptr + 0) + dither[hwo & 7]) >> 6);
    pwm_set_gpio_level(AUDIO_PIN_R, (*(wav_ptr + 1) + dither[hwo & 7]) >> 6);
    hwo++;
    if (hwo >= (AUDIO_TOTAL << 3))
        hwo = 0;
}

void core1_entry(void) {
    int wav_writeptr = AUDIO_CHUNK;

    multicore_lockout_victim_init();

    // Configure PWM for stereo audio output
    gpio_set_function(AUDIO_PIN_R, GPIO_FUNC_PWM);
    int audio_pin_slice_R = pwm_gpio_to_slice_num(AUDIO_PIN_R);
    gpio_set_function(AUDIO_PIN_L, GPIO_FUNC_PWM);
    int audio_pin_slice_L = pwm_gpio_to_slice_num(AUDIO_PIN_L);

    // Base clock 131 MHz divided by wrap 1024 to set the interrupt rate, which
    // is then divided again by eight for 8-fold over-sampling to give ~16 kHz 
    pwm_config config = pwm_get_default_config();
    pwm_config_set_clkdiv(&config, 1.0f); 
    pwm_config_set_wrap(&config, 1024); 

    // Right audio channel (shares interrupt with left channel)
    if (audio_pin_slice_R != audio_pin_slice_L)
      {
        pwm_clear_irq(audio_pin_slice_R);
        pwm_set_irq_enabled(audio_pin_slice_R, false);
        pwm_init(audio_pin_slice_R, &config, true);
      }

    // Left audio channel (AFTER right so it runs slightly late)
    pwm_clear_irq(audio_pin_slice_L);
    pwm_set_irq_enabled(audio_pin_slice_L, true);
    pwm_init(audio_pin_slice_L, &config, true);

    pwm_set_gpio_level(AUDIO_PIN_R, 0);
    pwm_set_gpio_level(AUDIO_PIN_L, 0);
    pwm_set_counter(audio_pin_slice_R, 0);
    pwm_set_counter(audio_pin_slice_L, 0);

    // set the interrupt handler function and enable it:
    irq_set_exclusive_handler(PWM_IRQ_WRAP, pwm_interrupt_handler);
    irq_set_enabled(PWM_IRQ_WRAP, true);

    while (1)
      {
	unsigned char al = note (0) ;
	unsigned char ah = tempo & 0x3F ;

	if (al)
 		note (syncs [al]) ;
	if (ah == 0)
		__wfi();
	while (ah--)
	    {
		int chunk = wav_writeptr / AUDIO_CHUNK ;
		while (chunk == ((hwo >> 3) / AUDIO_CHUNK))
			__wfi(); // Wait for Interrupt
		tone (waves + wav_writeptr * 2) ;
		wav_writeptr += AUDIO_CHUNK ;
		if (wav_writeptr >= AUDIO_TOTAL)
			wav_writeptr = 0;
	    }
      }
}

// Setup sound:
void snd_setup (void)
{
	int i ;

	// Small degree of overclocking to achieve ~15.99 kHz sampling
	set_sys_clock_khz(131000, true);

	tempo = 0x45 ;				// Default SOUND tempo

	for (i = 0; i < 8; i++)
		smix[i] = 0x4000 ;

	multicore_launch_core1(	core1_entry ) ;
}
