## [unreleased]

### Merged Pull Requests:

- Build(deps): update go toolchain to v1.25.5 ([#21459](https://github.com/netdata/netdata/issues/21459))
- Chore(go.d): include Go version in build info ([#21473](https://github.com/netdata/netdata/issues/21473))

## [2.8.3] - 2025-12-15

### Merged Pull Requests:

- Update bundled components for static builds. ([#21401](https://github.com/netdata/netdata/issues/21401))
- Disable MongoDB exporter for Ubuntu 20.04, 22.04, and 24.04 packages. ([#21403](https://github.com/netdata/netdata/issues/21403))
- Change chart variable (Windows.plugin) ([#21412](https://github.com/netdata/netdata/issues/21412))
- Fix shutdown timeout handling in completion wait function ([#21395](https://github.com/netdata/netdata/issues/21395))
- Fix validation of extent index in journal file ([#21400](https://github.com/netdata/netdata/issues/21400))
- Improve check for DBENGINE max datafile size allowed ([#21390](https://github.com/netdata/netdata/issues/21390))
- Fix(go.d/pkg/ndexec): return the output along with the error ([#21405](https://github.com/netdata/netdata/issues/21405))
- Fix(rabbitmq): remove "rabbitmq_version" check ([#21411](https://github.com/netdata/netdata/issues/21411))
- Chore(go.d/snmp): add collection stats ([#21409](https://github.com/netdata/netdata/issues/21409))
- Chore(go.d): log skipped data collection ([#21423](https://github.com/netdata/netdata/issues/21423))
- Chore(go.d/snmp): remove non-default update_every from sd config ([#21424](https://github.com/netdata/netdata/issues/21424))
- Chore(go.d): log data collection duration when skipping tick ([#21425](https://github.com/netdata/netdata/issues/21425))
- Fix(go.d): avoid blocking all jobs when stopping a slow job ([#21448](https://github.com/netdata/netdata/issues/21448))
- Use improved compression algorithms when building DEB packages. ([#21310](https://github.com/netdata/netdata/issues/21310))
- Fix(go.d): correct Windows install paths ([#21451](https://github.com/netdata/netdata/issues/21451))
- Adjust hardware collection (windows.plugin) ([#21433](https://github.com/netdata/netdata/issues/21433))
- AD fixes (windows.plugin) ([#21454](https://github.com/netdata/netdata/issues/21454))
- Fix(go.d/ap):  handle unknown values in station statistics gracefully ([#21461](https://github.com/netdata/netdata/issues/21461))
- Improve streaming connection loss detection ([#21430](https://github.com/netdata/netdata/issues/21430))

## [2.8.2] - 2025-12-03

### Merged Pull Requests:

- Improve replication logic by checking if parent is caught up with child ([#21352](https://github.com/netdata/netdata/issues/21352))
- Improve stale replication ([#21357](https://github.com/netdata/netdata/issues/21357))
- Fix(docker): add netdata user to nvidia device group on non-Debian systems ([#21358](https://github.com/netdata/netdata/issues/21358))
- Add netdata user to video group ([#21359](https://github.com/netdata/netdata/issues/21359))
- Fix(docker): fix bugs and refactor Docker entrypoint script ([#21364](https://github.com/netdata/netdata/issues/21364))
- Adjust windows sensors initialization ([#21374](https://github.com/netdata/netdata/issues/21374))
- Ci: fix MCP Registry publishing workflow ([#21342](https://github.com/netdata/netdata/issues/21342))
- Chore(go.d): disable redis lib logging ([#21344](https://github.com/netdata/netdata/issues/21344))
- Fix(go.d): prefer env-provided dirs over build-time defaults ([#21345](https://github.com/netdata/netdata/issues/21345))
- Remove retention check during datafile initialization ([#21387](https://github.com/netdata/netdata/issues/21387))
- Replace dots with slashes in OTEL metric families for hierarchical grouping ([#21371](https://github.com/netdata/netdata/issues/21371))

## [2.8.1] - 2025-11-21

### Merged Pull Requests:

- Remove log message ([#21325](https://github.com/netdata/netdata/issues/21325))
- Fix compilation when DBENGINE is disabled ([#21323](https://github.com/netdata/netdata/issues/21323))
- Fix(cgroups): improve podman container name resolution ([#21317](https://github.com/netdata/netdata/issues/21317))
- Improve(health/dyncfg): Add source unit field to alert value ([#21326](https://github.com/netdata/netdata/issues/21326))
- Disable apps plugin pss mem by default ([#21330](https://github.com/netdata/netdata/issues/21330))
- Fix(go.d): fix dyncfg vnodes configs ([#21332](https://github.com/netdata/netdata/issues/21332))

## [2.8.0] - 2025-11-19

### Merged Pull Requests:

- Improve(go.d/rabbitmq): add support for old RabbitMQ whoami tags format ([#21049](https://github.com/netdata/netdata/issues/21049))
- Ai-docs ([#21043](https://github.com/netdata/netdata/issues/21043))
- Feat(go.d/snmp): add optional ICMP ping metrics ([#21052](https://github.com/netdata/netdata/issues/21052))
- Regenerate integrations docs ([#21053](https://github.com/netdata/netdata/issues/21053))
- Feat(go.d/snmp): enable ping by default ([#21054](https://github.com/netdata/netdata/issues/21054))
- Regenerate integrations docs ([#21055](https://github.com/netdata/netdata/issues/21055))
- Chore(go.d/snmp): remove legacy custom oid collection ([#21056](https://github.com/netdata/netdata/issues/21056))
- Regenerate integrations docs ([#21058](https://github.com/netdata/netdata/issues/21058))
- Chore(go.d/ddsmp): profile definition cleanup ([#21062](https://github.com/netdata/netdata/issues/21062))
- Feat(go.d/snmp): add `ping_only` option ([#21064](https://github.com/netdata/netdata/issues/21064))
- Regenerate integrations docs ([#21065](https://github.com/netdata/netdata/issues/21065))
- Add helper to run external commands without additional privileges. ([#20990](https://github.com/netdata/netdata/issues/20990))
- Win plugin files with .plugin extension ([#21068](https://github.com/netdata/netdata/issues/21068))
- Add missing extension go.d (Windows) ([#21070](https://github.com/netdata/netdata/issues/21070))
- Declare flatten-serde-json at the workspace. ([#21072](https://github.com/netdata/netdata/issues/21072))
- Convert go collectors to use ndexec module for external command invocation ([#21067](https://github.com/netdata/netdata/issues/21067))
- Ml: implement fixed time-based training windows - corrected ([#21046](https://github.com/netdata/netdata/issues/21046))
- Build(deps): bump openssl version in static build ([#21074](https://github.com/netdata/netdata/issues/21074))
- Docs: add note about using ``--init` when not running with `pid: host` ([#21075](https://github.com/netdata/netdata/issues/21075))
- Make `nd-run` silent unless exiting with an error ([#21076](https://github.com/netdata/netdata/issues/21076))
- Build(go): add config dirs ([#21077](https://github.com/netdata/netdata/issues/21077))
- Docs: update SNMP collector metadata to reflect profile-based collection ([#21078](https://github.com/netdata/netdata/issues/21078))
- Regenerate integrations docs ([#21079](https://github.com/netdata/netdata/issues/21079))
- Clean up handling of compiler flags in our build code. ([#20821](https://github.com/netdata/netdata/issues/20821))
- Fix libbpf.a build path ([#21051](https://github.com/netdata/netdata/issues/21051))
- Adjust Disk Size (Windows.plugin) ([#21081](https://github.com/netdata/netdata/issues/21081))
- Fix duplicate header leak in ACLK HTTPS client ([#21084](https://github.com/netdata/netdata/issues/21084))
- Remote MCP support (streamable http and sse) ([#21036](https://github.com/netdata/netdata/issues/21036))
- MCP docs and log spamming fix ([#21087](https://github.com/netdata/netdata/issues/21087))
- Register Netdata to MCP Registry ([#21088](https://github.com/netdata/netdata/issues/21088))
- Fix app.mem_usage  (Windows) ([#21085](https://github.com/netdata/netdata/issues/21085))
- Fix cgroup-network spawn server cleanup on fatal exit ([#21080](https://github.com/netdata/netdata/issues/21080))
- Correctly split MCP registry update to it’s own workflow. ([#21089](https://github.com/netdata/netdata/issues/21089))
- Improve installer (Windows) ([#21090](https://github.com/netdata/netdata/issues/21090))
- Build(deps): bump github.com/docker/docker from 28.4.0+incompatible to 28.5.0+incompatible in /src/go ([#21095](https://github.com/netdata/netdata/issues/21095))
- Build(deps): bump github.com/go-ldap/ldap/v3 from 3.4.11 to 3.4.12 in /src/go ([#21094](https://github.com/netdata/netdata/issues/21094))
- Hide  mem_private_usage on Windows. ([#21093](https://github.com/netdata/netdata/issues/21093))
- Fix(packaging/docker): add missing nd-run ([#21097](https://github.com/netdata/netdata/issues/21097))
- Event loop cleanup ([#21091](https://github.com/netdata/netdata/issues/21091))
- Add documentation and fallback to /host/ for getting the machine id ([#21044](https://github.com/netdata/netdata/issues/21044))
- Update building-native-packages-locally.md ([#21101](https://github.com/netdata/netdata/issues/21101))
- Use datafile block pos ([#21098](https://github.com/netdata/netdata/issues/21098))
- Improve(go.d/snmp): Add APC PowerNet-MIB sysObjectID mappings and categories ([#21104](https://github.com/netdata/netdata/issues/21104))
- Update `cloud-notifications` documentation ([#21105](https://github.com/netdata/netdata/issues/21105))
- Regenerate integrations docs ([#21106](https://github.com/netdata/netdata/issues/21106))
- Improve logging and packet handling for unknown packet IDs ([#21099](https://github.com/netdata/netdata/issues/21099))
- Fix invalid map.csv ([#21108](https://github.com/netdata/netdata/issues/21108))
- Fix freeipmi crash ([#21109](https://github.com/netdata/netdata/issues/21109))
- Update installer documentation ([#21096](https://github.com/netdata/netdata/issues/21096))
- Ibm.d.plugin: i, db2, mq, websphere ([#21066](https://github.com/netdata/netdata/issues/21066))
- Build(deps): bump github.com/prometheus/common from 0.66.1 to 0.67.1 in /src/go ([#21111](https://github.com/netdata/netdata/issues/21111))
- Build(deps): bump github.com/ibmdb/go_ibm_db from 0.4.5 to 0.5.3 in /src/go ([#21110](https://github.com/netdata/netdata/issues/21110))
- Fix windows build ([#21113](https://github.com/netdata/netdata/issues/21113))
- Address NULL access (windows.plugin) ([#21112](https://github.com/netdata/netdata/issues/21112))
- Properly include client compoents for IBM MQ libraries. ([#21117](https://github.com/netdata/netdata/issues/21117))
- Add openSUSE Leap 16.0 and Ubuntu 25.10 to CI and package builds. ([#21100](https://github.com/netdata/netdata/issues/21100))
- Make native package dependencies consistent between DEB/RPM packages. ([#21118](https://github.com/netdata/netdata/issues/21118))
- Properly check for ODBC for IBM plugin at configuration time. ([#21116](https://github.com/netdata/netdata/issues/21116))
- Fix issues with IBM libs plugin. ([#21120](https://github.com/netdata/netdata/issues/21120))
- Improve free disk space calculation for Windows ([#21121](https://github.com/netdata/netdata/issues/21121))
- Update IBM plugin documentation. ([#21122](https://github.com/netdata/netdata/issues/21122))
- Fix(ibm.d): various fixes ([#21123](https://github.com/netdata/netdata/issues/21123))
- Fix(ibm.d/mq): change default ExponentialBackoff attempts to 2 ([#21124](https://github.com/netdata/netdata/issues/21124))
- Chore: go.d/ibm.d various fixes ([#21128](https://github.com/netdata/netdata/issues/21128))
- Build: update go otel deps ([#21129](https://github.com/netdata/netdata/issues/21129))
- Build(deps): bump github/codeql-action from 3 to 4 ([#21133](https://github.com/netdata/netdata/issues/21133))
- Build(deps): bump golang.org/x/net from 0.44.0 to 0.46.0 in /src/go ([#21137](https://github.com/netdata/netdata/issues/21137))
- Build(deps): bump github.com/gofrs/flock from 0.12.1 to 0.13.0 in /src/go ([#21134](https://github.com/netdata/netdata/issues/21134))
- Build(deps): bump github.com/docker/docker from 28.5.0+incompatible to 28.5.1+incompatible in /src/go ([#21135](https://github.com/netdata/netdata/issues/21135))
- Build(deps): bump github.com/gohugoio/hashstructure from 0.5.0 to 0.6.0 in /src/go ([#21138](https://github.com/netdata/netdata/issues/21138))
- Chore: move go.d/ibm.d shared pkgs out of go.d ([#21132](https://github.com/netdata/netdata/issues/21132))
- Improve(go.d/snmp): automatically disable SNMP bulkwalk when not supported ([#21139](https://github.com/netdata/netdata/issues/21139))
- Improve agent startup on windows ([#21125](https://github.com/netdata/netdata/issues/21125))
- Add Fedora 43 to CI and package builds. ([#21142](https://github.com/netdata/netdata/issues/21142))
- Skip status file on windows on crash ([#21140](https://github.com/netdata/netdata/issues/21140))
- Chore(go.d): update dyncfg path ([#21141](https://github.com/netdata/netdata/issues/21141))
- Updated child node behaviour change ([#21073](https://github.com/netdata/netdata/issues/21073))
- Switch to using a relative RUNPATH for IBM plugin library lookup. ([#21131](https://github.com/netdata/netdata/issues/21131))
- Fix AS400 metrics ([#21147](https://github.com/netdata/netdata/issues/21147))
- Additional checks during cgroup discovery ([#21148](https://github.com/netdata/netdata/issues/21148))
- Customize node name addition ([#21151](https://github.com/netdata/netdata/issues/21151))
- Fix NaN check in anomaly score calculation ([#21149](https://github.com/netdata/netdata/issues/21149))
- Skip adding Sentry breadcrumb during shutdown timeout ([#21150](https://github.com/netdata/netdata/issues/21150))
- Add `ServiceNow` integration ([#21154](https://github.com/netdata/netdata/issues/21154))
- Regenerate integrations docs ([#21156](https://github.com/netdata/netdata/issues/21156))
- Type 2 attestation added ([#21157](https://github.com/netdata/netdata/issues/21157))
- Docs: update Notifications description in cloud-notifications meta ([#21159](https://github.com/netdata/netdata/issues/21159))
- Regenerate integrations docs ([#21160](https://github.com/netdata/netdata/issues/21160))
- As400 improvements ([#21158](https://github.com/netdata/netdata/issues/21158))
- Enable Rust-based systemd journal handling code in Docker builds. ([#21161](https://github.com/netdata/netdata/issues/21161))
- Use parallelization for LTO processing to reduce build times. ([#20809](https://github.com/netdata/netdata/issues/20809))
- Fix feature size calculation and add error handling for KMeans training ([#21155](https://github.com/netdata/netdata/issues/21155))
- Rework maintenance thread ([#20694](https://github.com/netdata/netdata/issues/20694))
- Add Windows install types and release channels doc + update map.csv ([#21119](https://github.com/netdata/netdata/issues/21119))
- Libunwind ([#21163](https://github.com/netdata/netdata/issues/21163))
- Build(deps): bump github.com/ibmdb/go_ibm_db from 0.5.3 to 0.5.4 in /src/go ([#21167](https://github.com/netdata/netdata/issues/21167))
- Build(deps): bump github.com/ibm-messaging/mq-golang/v5 from 5.6.4 to 5.6.5 in /src/go ([#21166](https://github.com/netdata/netdata/issues/21166))
- Docs: fix map.csv for win ([#21168](https://github.com/netdata/netdata/issues/21168))
- Build(deps): bump azure/trusted-signing-action from 0.5.9 to 0.5.10 ([#21173](https://github.com/netdata/netdata/issues/21173))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.14.0 to 9.14.1 in /src/go ([#21174](https://github.com/netdata/netdata/issues/21174))
- Fix /api/v3 data update_every after filtering ([#21170](https://github.com/netdata/netdata/issues/21170))
- Swagger docs ([#21086](https://github.com/netdata/netdata/issues/21086))
- Stacktrace-common: define USE_NOTRACE if no HAVE_BACKTRACE ([#21165](https://github.com/netdata/netdata/issues/21165))
- Update swagger json from yaml ([#21176](https://github.com/netdata/netdata/issues/21176))
- Periodic sync data on windows ([#21175](https://github.com/netdata/netdata/issues/21175))
- Docs: remove ``` from cloud-notifications meta ([#21178](https://github.com/netdata/netdata/issues/21178))
- Regenerate integrations docs ([#21179](https://github.com/netdata/netdata/issues/21179))
- Chore(go.d/snmp): refactor static_tags to structured key/value format ([#21180](https://github.com/netdata/netdata/issues/21180))
- Fix(health/dyncfg): add mising "repeat" in userconfig response ([#21181](https://github.com/netdata/netdata/issues/21181))
- Windows Sensors (Part II) ([#20988](https://github.com/netdata/netdata/issues/20988))
- Regenerate integrations docs ([#21185](https://github.com/netdata/netdata/issues/21185))
- Calculate weights for multiple nodes in parallel ([#21184](https://github.com/netdata/netdata/issues/21184))
- Prometheus - exporting metrics ([#21187](https://github.com/netdata/netdata/issues/21187))
- Initialize cli earlier during agent startup ([#21188](https://github.com/netdata/netdata/issues/21188))
- Fix ML concurrent dimension training  ([#21183](https://github.com/netdata/netdata/issues/21183))
- Ci: remove update-website.yml workflow ([#21191](https://github.com/netdata/netdata/issues/21191))
- Netdata API ([#21193](https://github.com/netdata/netdata/issues/21193))
- Alerts api summary option ([#21192](https://github.com/netdata/netdata/issues/21192))
- MSSQL Small fixes (windows.plugin) ([#21197](https://github.com/netdata/netdata/issues/21197))
- As400 part3: performance optimizations ([#21164](https://github.com/netdata/netdata/issues/21164))
- Fix(packagin/otel-plugin): remove cap_net_bind_service ([#21198](https://github.com/netdata/netdata/issues/21198))
- SQL Server Jobs (windows.plugin) ([#21182](https://github.com/netdata/netdata/issues/21182))
- Regenerate integrations docs ([#21202](https://github.com/netdata/netdata/issues/21202))
- Improvement(go.d/mysql): Measure redo log occupancy ([#21153](https://github.com/netdata/netdata/issues/21153))
- Regenerate integrations docs ([#21205](https://github.com/netdata/netdata/issues/21205))
- Acquire and release metric as needed during journal v2 migration ([#21200](https://github.com/netdata/netdata/issues/21200))
- Ibm.d: various fixes ([#21204](https://github.com/netdata/netdata/issues/21204))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.14.1 to 9.16.0 in /src/go ([#21208](https://github.com/netdata/netdata/issues/21208))
- Build(deps): bump actions/upload-artifact from 4.6.2 to 5.0.0 ([#21206](https://github.com/netdata/netdata/issues/21206))
- Docs: add SNMP profile format doc ([#21201](https://github.com/netdata/netdata/issues/21201))
- Docs: add snmp profile format to snmp collector doc ([#21210](https://github.com/netdata/netdata/issues/21210))
- Regenerate integrations docs ([#21211](https://github.com/netdata/netdata/issues/21211))
- Add Expanded Chart Analysis doc and update map.csv ([#21213](https://github.com/netdata/netdata/issues/21213))
- Events Feed ([#21215](https://github.com/netdata/netdata/issues/21215))
- Dashboards and Charts ([#21216](https://github.com/netdata/netdata/issues/21216))
- Monitor Anything ([#21217](https://github.com/netdata/netdata/issues/21217))
- Systemd-journal ([#21222](https://github.com/netdata/netdata/issues/21222))
- Charts ([#21219](https://github.com/netdata/netdata/issues/21219))
- Docs: improve snmp profile format documentation ([#21223](https://github.com/netdata/netdata/issues/21223))
- Active_journal_centralization_guide_no_encryption.md ([#21221](https://github.com/netdata/netdata/issues/21221))
- Passive-journal-centralization-without-encryption.md ([#21220](https://github.com/netdata/netdata/issues/21220))
- Doc: improve COLLECTORS.md generation ([#21225](https://github.com/netdata/netdata/issues/21225))
- Docs: fix COLLECTORS.md generation ([#21228](https://github.com/netdata/netdata/issues/21228))
- Regenerate integrations docs ([#21229](https://github.com/netdata/netdata/issues/21229))
- Build(deps): bump github.com/prometheus/common from 0.67.1 to 0.67.2 in /src/go ([#21232](https://github.com/netdata/netdata/issues/21232))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.4 to 1.17.6 in /src/go ([#21231](https://github.com/netdata/netdata/issues/21231))
- Docs: improve COLLECTORS.md generation ([#21233](https://github.com/netdata/netdata/issues/21233))
- Update MCP Registry publishing workflow and migrate server.json to latest schema ([#21230](https://github.com/netdata/netdata/issues/21230))
- Regenerate integrations docs ([#21234](https://github.com/netdata/netdata/issues/21234))
- Fix handling of auto updater and data files during native package removal. ([#21203](https://github.com/netdata/netdata/issues/21203))
- Make OpenTelemetry plugin a required dependency for native DEB/RPM packages. ([#21194](https://github.com/netdata/netdata/issues/21194))
- CPU Temperature (windows.plugin) ([#20992](https://github.com/netdata/netdata/issues/20992))
- Regenerate integrations docs ([#21237](https://github.com/netdata/netdata/issues/21237))
- Apps.plugin: add PSS-based memory estimation ([#21199](https://github.com/netdata/netdata/issues/21199))
- Regenerate integrations docs ([#21241](https://github.com/netdata/netdata/issues/21241))
- Handle problematic repo configuration states in kickstart. ([#21226](https://github.com/netdata/netdata/issues/21226))
- Extend code signing in Windows CI to cover drivers. ([#21242](https://github.com/netdata/netdata/issues/21242))
- Check metric count during journal creation ([#21238](https://github.com/netdata/netdata/issues/21238))
- Switch to git-cliff for changelog generation. ([#21218](https://github.com/netdata/netdata/issues/21218))
- WebSocket: Increase inactivity timeout from 5 to 30 minutes ([#21244](https://github.com/netdata/netdata/issues/21244))
- Chore(go.d): add prefix-based func registration ([#21245](https://github.com/netdata/netdata/issues/21245))
- Fix(uninstaller): define rm_file before first use ([#21246](https://github.com/netdata/netdata/issues/21246))
- Build(deps): bump kenji-miyake/setup-git-cliff from 1 to 2 ([#21247](https://github.com/netdata/netdata/issues/21247))
- Route dyncfg GET requests through plugin ([#21249](https://github.com/netdata/netdata/issues/21249))
- Fix(go.d/ping): preserve original ping error by using %w for wrapping ([#21251](https://github.com/netdata/netdata/issues/21251))
- Improve ML shutdown checks ([#21250](https://github.com/netdata/netdata/issues/21250))
- Fix systemd-cat-native crash on realloc ([#21254](https://github.com/netdata/netdata/issues/21254))
- Format code - MSSQL (windows.plugin) ([#21256](https://github.com/netdata/netdata/issues/21256))
- Build(deps): bump github.com/ibm-messaging/mq-golang/v5 from 5.6.5 to 5.6.6 in /src/go ([#21259](https://github.com/netdata/netdata/issues/21259))
- Additional tests to MSSQL (windows.plugin) ([#21255](https://github.com/netdata/netdata/issues/21255))
- Adjust page cache locking ([#21240](https://github.com/netdata/netdata/issues/21240))
- Chore(go.d): add shared dyncfg package ([#21263](https://github.com/netdata/netdata/issues/21263))
- Fix tier check ([#21248](https://github.com/netdata/netdata/issues/21248))
- Fix aral race condition ([#21258](https://github.com/netdata/netdata/issues/21258))
- Update documentation to reflect SOC 2 Type 2 certification ([#21265](https://github.com/netdata/netdata/issues/21265))
- Improve agent startup ([#21260](https://github.com/netdata/netdata/issues/21260))
- Add missing modulo operator to alerts ([#21267](https://github.com/netdata/netdata/issues/21267))
- Improve websocket thread shutdown ([#21264](https://github.com/netdata/netdata/issues/21264))
- Build(deps): bump github.com/docker/docker from 28.5.1+incompatible to 28.5.2+incompatible in /src/go ([#21268](https://github.com/netdata/netdata/issues/21268))
- Security and Privacy ([#21271](https://github.com/netdata/netdata/issues/21271))
- Improve(go.d/sd/pipeline): add `services` config ([#21269](https://github.com/netdata/netdata/issues/21269))
- Chore(go.d/sd): make module optional in the template ([#21273](https://github.com/netdata/netdata/issues/21273))
- Compute timestamps needed for status file ([#21272](https://github.com/netdata/netdata/issues/21272))
- Detect netdata CLI initialization failure ([#21275](https://github.com/netdata/netdata/issues/21275))
- Doc: add SNMP to snmp profile format doc title ([#21277](https://github.com/netdata/netdata/issues/21277))
- Build(deps): bump golang.org/x/sync from 0.17.0 to 0.18.0 in /src/go ([#21278](https://github.com/netdata/netdata/issues/21278))
- Add openSUSE Tumbleweed to CI and package builds. ([#21276](https://github.com/netdata/netdata/issues/21276))
- MSSQL Replication - Publisher (Windows.plugin) ([#21235](https://github.com/netdata/netdata/issues/21235))
- Initialize reusable buffers when streaming ML to parent ([#21279](https://github.com/netdata/netdata/issues/21279))
- Improve forced new datafile on startup ([#21282](https://github.com/netdata/netdata/issues/21282))
- Adjust tier retention calculation ([#21280](https://github.com/netdata/netdata/issues/21280))
- Regenerate integrations docs ([#21284](https://github.com/netdata/netdata/issues/21284))
- Report failures to update native packages. ([#21144](https://github.com/netdata/netdata/issues/21144))
- Update our user/group account handling to use sysusers.d when possible. ([#21162](https://github.com/netdata/netdata/issues/21162))
- Additional check when executing a CLI command ([#21286](https://github.com/netdata/netdata/issues/21286))
- Always set ephemerality label with the correct value ([#21274](https://github.com/netdata/netdata/issues/21274))
- Installation Update ([#21292](https://github.com/netdata/netdata/issues/21292))
- Reorganize MSSQL collection. ([#21290](https://github.com/netdata/netdata/issues/21290))
- Fix repository URLs for openSUSE Tumbleweed. ([#21296](https://github.com/netdata/netdata/issues/21296))
- Sensors (windows.plugin) ([#21266](https://github.com/netdata/netdata/issues/21266))
- Account deletion update ([#21293](https://github.com/netdata/netdata/issues/21293))
- Feat(go.d): add generic sql collector ([#21281](https://github.com/netdata/netdata/issues/21281))
- Regenerate integrations docs ([#21297](https://github.com/netdata/netdata/issues/21297))
- Docs: remove prometheus SQL Exporter ([#21306](https://github.com/netdata/netdata/issues/21306))
- Regenerate integrations docs ([#21307](https://github.com/netdata/netdata/issues/21307))
- Docs: add ScyllaDB prometheus ([#21308](https://github.com/netdata/netdata/issues/21308))
- Regenerate integrations docs ([#21309](https://github.com/netdata/netdata/issues/21309))
- Fix csvjsonarray format returning invalid JSON with extra closing bracket when no data present ([#21304](https://github.com/netdata/netdata/issues/21304))
- Improve(go.d/nvidia_smi): add autodetection_retry option ([#21311](https://github.com/netdata/netdata/issues/21311))
- Regenerate integrations docs ([#21312](https://github.com/netdata/netdata/issues/21312))
- Improve(go.d/sql): add per-query execution time charts ([#21313](https://github.com/netdata/netdata/issues/21313))
- Regenerate integrations docs ([#21314](https://github.com/netdata/netdata/issues/21314))
- Additional checks during initial context load ([#21298](https://github.com/netdata/netdata/issues/21298))
- MSSQL Options (windows.plugin) ([#21301](https://github.com/netdata/netdata/issues/21301))
- Proper locking when searching for datafile ([#21302](https://github.com/netdata/netdata/issues/21302))
- Reset backfill requests on child reconnect ([#21315](https://github.com/netdata/netdata/issues/21315))
- Add helm repo when adding kuberentes to the nodes ([#21318](https://github.com/netdata/netdata/issues/21318))
- Regenerate integrations docs ([#21316](https://github.com/netdata/netdata/issues/21316))

## [2.7.0] - 2025-09-25

### Merged Pull Requests:

- Update otel-collector components deps ([#20693](https://github.com/netdata/netdata/issues/20693))
- Replace legacy functions-table.md with comprehensive UI documentation ([#20697](https://github.com/netdata/netdata/issues/20697))
- Add Getting Started Netdata guide ([#20642](https://github.com/netdata/netdata/issues/20642))
- Escape < character in plaintext ([#20699](https://github.com/netdata/netdata/issues/20699))
- Update UPDATE.md ([#20701](https://github.com/netdata/netdata/issues/20701))
- Fix(nvme)!: query controller instead of namespace for SMART metrics ([#20704](https://github.com/netdata/netdata/issues/20704))
- Ensure chat exists before handling message input ([#20700](https://github.com/netdata/netdata/issues/20700))
- Build(deps): bump k8s.io/client-go from 0.33.2 to 0.33.3 in /src/go ([#20705](https://github.com/netdata/netdata/issues/20705))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.41.0 to 1.42.0 in /src/go ([#20707](https://github.com/netdata/netdata/issues/20707))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.42.0 to 1.42.1 in /src/go ([#20709](https://github.com/netdata/netdata/issues/20709))
- Update LIBBPF ([#20696](https://github.com/netdata/netdata/issues/20696))
- Improve(go.d/snmp): add profile device meta to vnode labels ([#20718](https://github.com/netdata/netdata/issues/20718))
- Mark the completion from the worker thread ([#20719](https://github.com/netdata/netdata/issues/20719))
- Detect missing ACLK MQTT packet acknowledgents ([#20711](https://github.com/netdata/netdata/issues/20711))
- Remove H2O web server code from Netdata. ([#20713](https://github.com/netdata/netdata/issues/20713))
- Enable services status (windows.plugin) ([#20720](https://github.com/netdata/netdata/issues/20720))
- Docs: add Network-connections to the functions table ([#20721](https://github.com/netdata/netdata/issues/20721))
- Avoid static initialization ([#20722](https://github.com/netdata/netdata/issues/20722))
- Update README.md ([#20724](https://github.com/netdata/netdata/issues/20724))
- Update README.md ([#20723](https://github.com/netdata/netdata/issues/20723))
- Fix SSL certificate detection for Rocky Linux and static curl ([#20695](https://github.com/netdata/netdata/issues/20695))
- Ignore timestamps recording in gzip metadata (for reproducible builds) ([#20714](https://github.com/netdata/netdata/issues/20714))
- SNMP: make units ucum ([#20710](https://github.com/netdata/netdata/issues/20710))
- Reset chart variable after release ([#20727](https://github.com/netdata/netdata/issues/20727))
- Deployment Guides: add and update documentation for deployment strate… ([#20712](https://github.com/netdata/netdata/issues/20712))
- Revert "Deployment Guides: add and update documentation for deployment strate" ([#20728](https://github.com/netdata/netdata/issues/20728))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.9.0 to 4.9.1 in /src/go ([#20730](https://github.com/netdata/netdata/issues/20730))
- Improve thread shutdown handling for MSSQL plugin ([#20725](https://github.com/netdata/netdata/issues/20725))
- Add additional database checks during shutdown  ([#20731](https://github.com/netdata/netdata/issues/20731))
- Build(deps): bump openssl and curl version in static build ([#20734](https://github.com/netdata/netdata/issues/20734))
- Thread creation code cleanup ([#20732](https://github.com/netdata/netdata/issues/20732))
- Build(deps): bump github.com/docker/docker from 28.3.2+incompatible to 28.3.3+incompatible in /src/go ([#20739](https://github.com/netdata/netdata/issues/20739))
- Fix SNDR thread startup ([#20740](https://github.com/netdata/netdata/issues/20740))
- Revert "Revert "Deployment Guides: add and update documentation for deployment strate"" ([#20729](https://github.com/netdata/netdata/issues/20729))
- Docs: remove customize.md ([#20742](https://github.com/netdata/netdata/issues/20742))
- Chore(go.d/snmp-profiles): use same metric name for cpu usage  ([#20745](https://github.com/netdata/netdata/issues/20745))
- Use netdata mutex cond and lock ([#20737](https://github.com/netdata/netdata/issues/20737))
- Update deployment-with-centralization-points.md ([#20748](https://github.com/netdata/netdata/issues/20748))
- Remove redundant defines ([#20744](https://github.com/netdata/netdata/issues/20744))
- Change remaining pthread_ cases ([#20746](https://github.com/netdata/netdata/issues/20746))
- Split collection (Windows.plugin) ([#20677](https://github.com/netdata/netdata/issues/20677))
- Regenerate integrations docs ([#20749](https://github.com/netdata/netdata/issues/20749))
- Streaming routing documentation ([#20743](https://github.com/netdata/netdata/issues/20743))
- Chore(go.d/snmp): add org to vendor map ([#20750](https://github.com/netdata/netdata/issues/20750))
- Record proxy information when establishing ACLK ([#20747](https://github.com/netdata/netdata/issues/20747))
- Chore(go.d/snmp): remove SNMP prefix from hostname ([#20751](https://github.com/netdata/netdata/issues/20751))
- Build(deps): bump github.com/miekg/dns from 1.1.67 to 1.1.68 in /src/go ([#20753](https://github.com/netdata/netdata/issues/20753))
- Chore(go.d/snmp): add _vnode_type host label and rm duplicates ([#20754](https://github.com/netdata/netdata/issues/20754))
- Chore(go.d/snmp): add _clean_hostname host label ([#20755](https://github.com/netdata/netdata/issues/20755))
- Chore(go.d/snmp): update hostname to not include IP ([#20756](https://github.com/netdata/netdata/issues/20756))
- Improve Disk Usage Measure (Windows.plugin) ([#20752](https://github.com/netdata/netdata/issues/20752))
- Chore(go.d/snmp): update org to vendor mapping ([#20757](https://github.com/netdata/netdata/issues/20757))
- Add Oracle Linux 10 to CI and package builds. ([#20684](https://github.com/netdata/netdata/issues/20684))
- Update welcome-to-netdata.md ([#20760](https://github.com/netdata/netdata/issues/20760))
- Fix(go.d/snmp-profile): fix extends in cradlepoint.yaml ([#20762](https://github.com/netdata/netdata/issues/20762))
- Fix(go.d): validate custom binary path ([#20761](https://github.com/netdata/netdata/issues/20761))
- Chore(go.d): remove patternProperties from config_schema.json ([#20763](https://github.com/netdata/netdata/issues/20763))
- Feat(system-info): add default network interface IP detection ([#20764](https://github.com/netdata/netdata/issues/20764))
- Fix packet timeout handling ([#20766](https://github.com/netdata/netdata/issues/20766))
- Add default iface info to host labels ([#20767](https://github.com/netdata/netdata/issues/20767))
- Chore(go.d/snmp): add _net_default_iface_ip host label ([#20768](https://github.com/netdata/netdata/issues/20768))
- Feat(go.d/snmp): add configurable device down threshold for vnodes ([#20770](https://github.com/netdata/netdata/issues/20770))
- Regenerate integrations docs ([#20771](https://github.com/netdata/netdata/issues/20771))
- Add publish latency to the aclk-state command ([#20769](https://github.com/netdata/netdata/issues/20769))
- Update machine-learning-and-assisted-troubleshooting.md ([#20772](https://github.com/netdata/netdata/issues/20772))
- Aclk improvements ([#20775](https://github.com/netdata/netdata/issues/20775))
- Fix MSSQL Charts ([#20774](https://github.com/netdata/netdata/issues/20774))
- Add Debian 13 to CI and package builds. ([#20776](https://github.com/netdata/netdata/issues/20776))
- Docs(go.d/memcached): add UNIX socket access prerequisite ([#20780](https://github.com/netdata/netdata/issues/20780))
- Regenerate integrations docs ([#20781](https://github.com/netdata/netdata/issues/20781))
- Docs(go.d/mysql): add MariaDB 10.5.9+ SLAVE MONITOR privilege ([#20782](https://github.com/netdata/netdata/issues/20782))
- Regenerate integrations docs ([#20783](https://github.com/netdata/netdata/issues/20783))
- Fix(go.d/ddsnmp): respect metric tag order from profile definition ([#20784](https://github.com/netdata/netdata/issues/20784))
- Feat(go.d/ddsnmp): add metric aggregation support for SNMP profiles ([#20786](https://github.com/netdata/netdata/issues/20786))
- Chore(go.d/ddsnmp): replace Mappings with MultiValue for state-based metrics ([#20787](https://github.com/netdata/netdata/issues/20787))
- Virtual node version adjustment ([#20777](https://github.com/netdata/netdata/issues/20777))
- Build(deps): bump golang.org/x/net from 0.42.0 to 0.43.0 in /src/go ([#20796](https://github.com/netdata/netdata/issues/20796))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.11.0 to 9.12.0 in /src/go ([#20794](https://github.com/netdata/netdata/issues/20794))
- Fix(go.d): resolve potential toctou vulnerability in binary path validation ([#20798](https://github.com/netdata/netdata/issues/20798))
- Ci: handle boolean values in EOL API responses for newly released distros ([#20792](https://github.com/netdata/netdata/issues/20792))
- Fix pathvalidate non unix ([#20801](https://github.com/netdata/netdata/issues/20801))
- Add OpenTelemetry plugin implementation. ([#20765](https://github.com/netdata/netdata/issues/20765))
- Fix ping latency calculation ([#20800](https://github.com/netdata/netdata/issues/20800))
- Feat(aclk): Add detailed pulse metrics for ACLK telemetry ([#20802](https://github.com/netdata/netdata/issues/20802))
- Feat(go.d/ddsnmp): sysobjectid-based metadata override support for SNMP profiles ([#20803](https://github.com/netdata/netdata/issues/20803))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.12.0 to 9.12.1 in /src/go ([#20804](https://github.com/netdata/netdata/issues/20804))
- Feat(go.d/snmp): add SNMP sysObjectID mappings for device identification ([#20805](https://github.com/netdata/netdata/issues/20805))
- Improve(go.d/zfspool): add Ubuntu zpool binary path to config ([#20806](https://github.com/netdata/netdata/issues/20806))
- Clear packet id when processed from PUBACK ([#20808](https://github.com/netdata/netdata/issues/20808))
- Monitor memory reclamation and buffer compact ([#20810](https://github.com/netdata/netdata/issues/20810))
- Add more MSSQL metrics (windows.plugin) ([#20788](https://github.com/netdata/netdata/issues/20788))
- Improve(go.d/snmp): optimize Check() to avoid heavy collection ([#20813](https://github.com/netdata/netdata/issues/20813))
- Fix(go.d/ddsnmp): fix match_pattern regex behavior in metadata and metric collection ([#20814](https://github.com/netdata/netdata/issues/20814))
- Render latency chart if ACLK online ([#20811](https://github.com/netdata/netdata/issues/20811))
- Fix Charts (windows.plugin) ([#20815](https://github.com/netdata/netdata/issues/20815))
- Fix(go.d/ddsnmp): correct profile matching, metadata precedence, and OID handling ([#20819](https://github.com/netdata/netdata/issues/20819))
- Add ACLK buffer usage metrics ([#20820](https://github.com/netdata/netdata/issues/20820))
- Build(deps): bump k8s.io/client-go from 0.33.3 to 0.33.4 in /src/go ([#20826](https://github.com/netdata/netdata/issues/20826))
- Refactor(go.d): move nd directories to dedicated pluginconfig package ([#20827](https://github.com/netdata/netdata/issues/20827))
- Feat(go.d/snmp): add YAML overrides for sysobjectids mapping ([#20828](https://github.com/netdata/netdata/issues/20828))
- Improve(go.d/snmp): add more models to meta_overrides.yaml ([#20830](https://github.com/netdata/netdata/issues/20830))
- Chore(go.d/snmp): merge sysObjectIDs.json into meta_overrides.yaml ([#20831](https://github.com/netdata/netdata/issues/20831))
- Chore(go.d/snmp): update category of h3c devices in meta_overrides.yaml ([#20835](https://github.com/netdata/netdata/issues/20835))
- Switch to a Debian 13 base for our Docker images. ([#20816](https://github.com/netdata/netdata/issues/20816))
- Mqtt adjust buffer size ([#20834](https://github.com/netdata/netdata/issues/20834))
- Chore(go.d/snmp): load & merge per-vendor SNMP metadata overrides ([#20837](https://github.com/netdata/netdata/issues/20837))
- Use atomics for mqtt statistics ([#20836](https://github.com/netdata/netdata/issues/20836))
- Improve ACLK message parsing ([#20838](https://github.com/netdata/netdata/issues/20838))
- Improve(go.d/snmp): update netgear/dlink category in snmp meta ([#20839](https://github.com/netdata/netdata/issues/20839))
- Revert "Switch to a Debian 13 base for our Docker images." ([#20842](https://github.com/netdata/netdata/issues/20842))
- Improve(go.d/snmp): update h3c categories in snmp meta ([#20844](https://github.com/netdata/netdata/issues/20844))
- Store virtual host labels ([#20841](https://github.com/netdata/netdata/issues/20841))
- Build(deps): bump actions/checkout from 4 to 5 ([#20833](https://github.com/netdata/netdata/issues/20833))
- Do not set virtual host flag on agent restart ([#20845](https://github.com/netdata/netdata/issues/20845))
- Ci: fix docker-test.sh handling to fail on error ([#20847](https://github.com/netdata/netdata/issues/20847))
- Build(deps): bump github.com/vmware/govmomi from 0.51.0 to 0.52.0 in /src/go ([#20852](https://github.com/netdata/netdata/issues/20852))
- Ci: bump GoTestTools/gotestfmt-action version ([#20850](https://github.com/netdata/netdata/issues/20850))
- Revert "Revert "Switch to a Debian 13 base for our Docker images."" ([#20848](https://github.com/netdata/netdata/issues/20848))
- Improve(go.d/snmp): update snmp meta copilot ([#20861](https://github.com/netdata/netdata/issues/20861))
- Add cargo lock file. ([#20855](https://github.com/netdata/netdata/issues/20855))
- Add build-time check to reject known bad compiler flags. ([#20851](https://github.com/netdata/netdata/issues/20851))
- Chore(go.d/snmp): more vendor-scoped meta yaml files ([#20863](https://github.com/netdata/netdata/issues/20863))
- Kickstarter Fix for DNF5 System ([#20823](https://github.com/netdata/netdata/issues/20823))
- Windows Plugin (Sensors) ([#20840](https://github.com/netdata/netdata/issues/20840))
- Update documentation (Windows.plugin) ([#20864](https://github.com/netdata/netdata/issues/20864))
- Update documentation ([#20865](https://github.com/netdata/netdata/issues/20865))
- Regenerate integrations docs ([#20818](https://github.com/netdata/netdata/issues/20818))
- Improve(go.d/snmp): add more entries in juniper metadata file ([#20867](https://github.com/netdata/netdata/issues/20867))
- Rename default port for the OpenTelemetry Collector ([#20868](https://github.com/netdata/netdata/issues/20868))
- Fix Table field comparison in SNMP collector table tests ([#20871](https://github.com/netdata/netdata/issues/20871))
- Fix(go.d): create vnode internal data_collection_status charts in the main context ([#20872](https://github.com/netdata/netdata/issues/20872))
- Build(deps): bump github.com/coreos/go-systemd/v22 from 22.5.0 to 22.6.0 in /src/go ([#20874](https://github.com/netdata/netdata/issues/20874))
- Chore(go.d/ddsnmp): use plugincofng for loading profiles ([#20878](https://github.com/netdata/netdata/issues/20878))
- Improve(go.d/snmp): add zyxel snmp meta file ([#20879](https://github.com/netdata/netdata/issues/20879))
- Fix(go.d): fix goroutine leak and panic risk in Docker exec ([#20881](https://github.com/netdata/netdata/issues/20881))
- Improve(go.d/snmp): update tplink snmp meta ([#20882](https://github.com/netdata/netdata/issues/20882))
- Improve(go.d/snmp): add MikroTik type and model detection ([#20883](https://github.com/netdata/netdata/issues/20883))
- Fix(go.d/snmp): handle invalid SFP temperature readings for empty slots ([#20884](https://github.com/netdata/netdata/issues/20884))
- Build(deps): bump github.com/stretchr/testify from 1.10.0 to 1.11.0 in /src/go ([#20886](https://github.com/netdata/netdata/issues/20886))
- Improve(go.d/snmp): add mikrotik mtxrHlProcessorTemperature ([#20885](https://github.com/netdata/netdata/issues/20885))
- Updated logging documentation and added natural siem integration ([#20829](https://github.com/netdata/netdata/issues/20829))
- Troubleshooting: add troubleshoot and custom investigations docs ([#20759](https://github.com/netdata/netdata/issues/20759))
- Windows: round sleep to clock resolution to prevent sub-ms early-wake logs ([#20887](https://github.com/netdata/netdata/issues/20887))
- Improve(go.d/snmp): update Fortinet meta ([#20888](https://github.com/netdata/netdata/issues/20888))
- Improve(go.d/snmp): update Allied Telesis meta ([#20889](https://github.com/netdata/netdata/issues/20889))
- Improve exporting documentation clarity and structure ([#20890](https://github.com/netdata/netdata/issues/20890))
- Move exporting integrations to their own folder ([#20894](https://github.com/netdata/netdata/issues/20894))
- Improve(cgroups): skip KubeVirt helper containers in virt-launcher pods ([#20896](https://github.com/netdata/netdata/issues/20896))
- Improve snmp ubiquiti unifi ap model ([#20895](https://github.com/netdata/netdata/issues/20895))
- Fixing Supported Linux Platforms and Versions ([#20893](https://github.com/netdata/netdata/issues/20893))
- Refactor(go.d/snmp): recreate client on SNMPv3 "packet is not authentic" errors ([#20897](https://github.com/netdata/netdata/issues/20897))
- Improve(go.d/snmp): make snmp v3 auth and priv keys hidden in UI ([#20898](https://github.com/netdata/netdata/issues/20898))
- Update demo link formatting in documentation ([#20899](https://github.com/netdata/netdata/issues/20899))
- Improved alerting docs ([#20891](https://github.com/netdata/netdata/issues/20891))
- Fix processes function: Add PPID grouping and fix WOps typo ([#20902](https://github.com/netdata/netdata/issues/20902))
- Build(deps): bump k8s.io/client-go from 0.33.4 to 0.34.0 in /src/go ([#20908](https://github.com/netdata/netdata/issues/20908))
- Build(deps): bump github.com/stretchr/testify from 1.11.0 to 1.11.1 in /src/go ([#20906](https://github.com/netdata/netdata/issues/20906))
- Update link for opt-out section ([#20909](https://github.com/netdata/netdata/issues/20909))
- Update view-plan-and-billing.md ([#20910](https://github.com/netdata/netdata/issues/20910))
- Fix(go.d): try rel path before checking well-known path for user and stock dirs ([#20912](https://github.com/netdata/netdata/issues/20912))
- Chore(go.d): add build-time configuration directory paths ([#20913](https://github.com/netdata/netdata/issues/20913))
- SIGNL4 Alert Notification ([#20911](https://github.com/netdata/netdata/issues/20911))
- Fix(netdata-updater): resolve "run: command not found" error in offline install ([#20915](https://github.com/netdata/netdata/issues/20915))
- Regenerate integrations docs ([#20916](https://github.com/netdata/netdata/issues/20916))
- Chore(go.d): remove unused resolve hostname functionality ([#20922](https://github.com/netdata/netdata/issues/20922))
- Docs(go.d/nginx): improve prerequisites for NGINX collector ([#20924](https://github.com/netdata/netdata/issues/20924))
- Regenerate integrations docs ([#20925](https://github.com/netdata/netdata/issues/20925))
- Fix(go.d/weblog): remove path pattern validation in dyncfg ([#20923](https://github.com/netdata/netdata/issues/20923))
- Build(deps): bump github.com/prometheus/common from 0.65.0 to 0.66.1 in /src/go ([#20930](https://github.com/netdata/netdata/issues/20930))
- Build(deps): bump github.com/docker/docker from 28.3.3+incompatible to 28.4.0+incompatible in /src/go ([#20929](https://github.com/netdata/netdata/issues/20929))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.12.1 to 9.13.0 in /src/go ([#20928](https://github.com/netdata/netdata/issues/20928))
- Build(deps): bump actions/labeler from 5 to 6 ([#20935](https://github.com/netdata/netdata/issues/20935))
- Build(deps): bump actions/setup-go from 5 to 6 ([#20934](https://github.com/netdata/netdata/issues/20934))
- Build(deps): bump actions/setup-python from 5 to 6 ([#20936](https://github.com/netdata/netdata/issues/20936))
- Build(deps): bump golang.org/x/text from 0.28.0 to 0.29.0 in /src/go ([#20937](https://github.com/netdata/netdata/issues/20937))
- Add documentation for account deletion process ([#20927](https://github.com/netdata/netdata/issues/20927))
- MCP WEB CHAT: add ollama, deepseek support ([#20741](https://github.com/netdata/netdata/issues/20741))
- Update account.md ([#20940](https://github.com/netdata/netdata/issues/20940))
- Update sqlite to version 3.50.4 ([#20791](https://github.com/netdata/netdata/issues/20791))
- Chore(go.d/pkgs/logs): validation fixes, resource safety, and cleanup ([#20931](https://github.com/netdata/netdata/issues/20931))
- Update libbpf to 1.6.2 ([#20875](https://github.com/netdata/netdata/issues/20875))
- Migrate the map from Learn repo to netdata/netdata ([#20942](https://github.com/netdata/netdata/issues/20942))
- Add map.csv to triggers for Docs ingest workflow ([#20945](https://github.com/netdata/netdata/issues/20945))
- Update account.md ([#20946](https://github.com/netdata/netdata/issues/20946))
- Change MSSQL Cleanup and Queries (windows.plugin) ([#20892](https://github.com/netdata/netdata/issues/20892))
- Add Network Labels to Windows. ([#20938](https://github.com/netdata/netdata/issues/20938))
- Replace uv mutex and condition variables with netdata equivalents ([#20941](https://github.com/netdata/netdata/issues/20941))
- BSD Compilation ([#20944](https://github.com/netdata/netdata/issues/20944))
- Fix use after free in metric registry ([#20947](https://github.com/netdata/netdata/issues/20947))
- Build(deps): bump golang.org/x/net from 0.43.0 to 0.44.0 in /src/go ([#20949](https://github.com/netdata/netdata/issues/20949))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.5 to 5.7.6 in /src/go ([#20950](https://github.com/netdata/netdata/issues/20950))
- Move whole category and fix leftovers ([#20951](https://github.com/netdata/netdata/issues/20951))
- Fix(health/rocketchat): add missing "Content-Type: application/json" header ([#20954](https://github.com/netdata/netdata/issues/20954))
- Improve(go.d/snmp): add transform for Host-Resources-MIB storage metrics ([#20957](https://github.com/netdata/netdata/issues/20957))
- Chore(go.d/snmp): remove hrStorageTable from mikrotik-router.yaml ([#20958](https://github.com/netdata/netdata/issues/20958))
- Improve(go.d/snmp): add net-snmp.yaml profile ([#20959](https://github.com/netdata/netdata/issues/20959))
- Ensure memory ordering when updating partition list and the bitmap ([#20956](https://github.com/netdata/netdata/issues/20956))
- Fix FreeBSD (Part II) ([#20955](https://github.com/netdata/netdata/issues/20955))
- Chore(go.d/sd/snmp): remove skipping servers in snmp discovery ([#20960](https://github.com/netdata/netdata/issues/20960))
- Improve(go.d/ddsnmp): add composite virtual metrics ([#20962](https://github.com/netdata/netdata/issues/20962))
- Improve(go.d/ddsnmp): add composite metrics for CPU & Load Average in std-ucd-mib ([#20964](https://github.com/netdata/netdata/issues/20964))
- Build(deps): bump k8s.io/client-go from 0.34.0 to 0.34.1 in /src/go ([#20968](https://github.com/netdata/netdata/issues/20968))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.13.0 to 9.14.0 in /src/go ([#20966](https://github.com/netdata/netdata/issues/20966))
- Improve(go.d/ddsnmp): add group_by for virtual metrics ([#20970](https://github.com/netdata/netdata/issues/20970))
- Improve(go.d/ddsnmp): add per_row mode for virtual metrics ([#20971](https://github.com/netdata/netdata/issues/20971))
- Docs(go.d/snmp): remove legacy "custom oid" cfg examples ([#20972](https://github.com/netdata/netdata/issues/20972))
- Regenerate integrations docs ([#20973](https://github.com/netdata/netdata/issues/20973))
- Docs(go.d): add UI configuration instructions and restructure Configuration section ([#20975](https://github.com/netdata/netdata/issues/20975))
- Regenerate integrations docs ([#20976](https://github.com/netdata/netdata/issues/20976))
- Docs: restructure Setup, update SNMP prerequisites, and fix SNMP options ([#20977](https://github.com/netdata/netdata/issues/20977))
- Regenerate integrations docs ([#20978](https://github.com/netdata/netdata/issues/20978))
- Perf(go.d/ddsnmp): cache group key per aggregator per metric ([#20979](https://github.com/netdata/netdata/issues/20979))
- Docs: improve config options table with grouped section headers ([#20980](https://github.com/netdata/netdata/issues/20980))
- Regenerate integrations docs ([#20982](https://github.com/netdata/netdata/issues/20982))
- Chore: add `-c` option to gen docs for a single collector ([#20981](https://github.com/netdata/netdata/issues/20981))
- Enhance README with publishing instructions for docs ([#20952](https://github.com/netdata/netdata/issues/20952))
- Document accuracy implications of sampling algorithm ([#20991](https://github.com/netdata/netdata/issues/20991))
- Fix(macos.plugin): drop SyncookiesFailed metric on macOS 16+ ([#20994](https://github.com/netdata/netdata/issues/20994))
- Fix(go.d): skip writing HOST line for vnodes with no collected metrics ([#20995](https://github.com/netdata/netdata/issues/20995))
- Ci: rm macos 13, add macos 26 ([#20993](https://github.com/netdata/netdata/issues/20993))
- Chore(go.d): skip HOST for vnodes during Cleanup with stale label ([#20996](https://github.com/netdata/netdata/issues/20996))
- Update welcome-to-netdata.md ([#20986](https://github.com/netdata/netdata/issues/20986))
- Docs: add "per cpu core utilization" option to proc/stat meta ([#20997](https://github.com/netdata/netdata/issues/20997))
- Regenerate integrations docs ([#20998](https://github.com/netdata/netdata/issues/20998))
- Docs: Use fallback title "Config options" when folding title is empty ([#20999](https://github.com/netdata/netdata/issues/20999))
- Regenerate integrations docs ([#21000](https://github.com/netdata/netdata/issues/21000))
- Docs: add "cpu idle state" procstat config option ([#21001](https://github.com/netdata/netdata/issues/21001))
- Regenerate integrations docs ([#21002](https://github.com/netdata/netdata/issues/21002))
- Docs: add grouped headers to config options ([#20987](https://github.com/netdata/netdata/issues/20987))
- Regenerate integrations docs ([#21007](https://github.com/netdata/netdata/issues/21007))
- Deps(mcp/bridge/stdio-golang): switch to github.com/coder/websocket ([#21006](https://github.com/netdata/netdata/issues/21006))
- Fix(go.d): correct buf truncate in processMetrics ([#21008](https://github.com/netdata/netdata/issues/21008))
- Update best-practices.md ([#20984](https://github.com/netdata/netdata/issues/20984))
- Chore(go.d): use forked gosnmp to fix SNMPv3 REPORT handling for UniFi APs ([#21009](https://github.com/netdata/netdata/issues/21009))
- Chore: refactor get_doc_integrations.py to use main() and improve structure ([#20983](https://github.com/netdata/netdata/issues/20983))
- Chore(go.d/snmp): remove recreating client on "packet is not authentic" ([#21010](https://github.com/netdata/netdata/issues/21010))
- Handle virtual host disconnection ([#20860](https://github.com/netdata/netdata/issues/20860))
- Rework dbengine async wakeup on windows ([#21003](https://github.com/netdata/netdata/issues/21003))
- Fix Mermaid diagrams across multiple files ([#21011](https://github.com/netdata/netdata/issues/21011))
- Improve(go.d/ddsnmp): add alternatives support for virtual metrics ([#21013](https://github.com/netdata/netdata/issues/21013))
- Chore(go.d): don’t log "no such file or directory" for user SNMP profiles ([#21014](https://github.com/netdata/netdata/issues/21014))
- Docs: Update ToC - add realtime-monitoring and reorganize functions ([#21012](https://github.com/netdata/netdata/issues/21012))
- Fix MDX compilation errors in realtime-monitoring.md ([#21015](https://github.com/netdata/netdata/issues/21015))
- Fix MDX parsing errors in realtime-monitoring.md ([#21016](https://github.com/netdata/netdata/issues/21016))
- Docs: Add comprehensive scalability architecture documentation ([#21018](https://github.com/netdata/netdata/issues/21018))
- Docs: Rename 'Top Monitoring' to 'Top Consumers' in Functions documentation ([#21019](https://github.com/netdata/netdata/issues/21019))
- Docs: Remove parentheses from Top Consumers title to fix URL issues ([#21020](https://github.com/netdata/netdata/issues/21020))
- Fix duplicate ToC entries for Top Consumers ([#21021](https://github.com/netdata/netdata/issues/21021))
- Improve(go.d/ddsnmp): refactor IF-MIB profile with unified virtual metrics and 64-bit preference ([#21017](https://github.com/netdata/netdata/issues/21017))
- Chore(go.d/ddsnmp): update vmBuildGroupKey in per-row mode without group_by ([#21022](https://github.com/netdata/netdata/issues/21022))
- Improve(go.d/snmp): add `manual_profiles` option ([#21023](https://github.com/netdata/netdata/issues/21023))
- Build(deps): bump openssl and curl version in static build ([#21024](https://github.com/netdata/netdata/issues/21024))
- Build(deps): update go toolchain to v1.25.1 ([#21025](https://github.com/netdata/netdata/issues/21025))
- Update README.md ([#21027](https://github.com/netdata/netdata/issues/21027))
- Chore(go.d/snmp): remove/disable legacy components ([#21026](https://github.com/netdata/netdata/issues/21026))
- Regenerate integrations docs ([#21028](https://github.com/netdata/netdata/issues/21028))
- Chore(docs): rename REST API sidebar to Netdata APIs ([#21029](https://github.com/netdata/netdata/issues/21029))
- Revert "chore(docs): rename REST API sidebar to Netdata APIs" ([#21031](https://github.com/netdata/netdata/issues/21031))
- Update scalability.md ([#21030](https://github.com/netdata/netdata/issues/21030))
- Ml: implement fixed time-based training windows ([#20638](https://github.com/netdata/netdata/issues/20638))
- Docs: fix mdx parsing scalability.md ([#21032](https://github.com/netdata/netdata/issues/21032))
- Fix(docs): update mermaid diagrams leftovers plus syntax issues ([#21034](https://github.com/netdata/netdata/issues/21034))
- Improve(go.d/ddsnmp): switch profile matching to `selector` ([#21039](https://github.com/netdata/netdata/issues/21039))
- Chore(go.d/ddsnmp): Improve profile sorting by match specificity ([#21042](https://github.com/netdata/netdata/issues/21042))
- Context loading priority to vnodes ([#21040](https://github.com/netdata/netdata/issues/21040))
- Add documentation on using custom CA certificates to Learn ([#21041](https://github.com/netdata/netdata/issues/21041))
- Revert "ml: implement fixed time-based training windows ([#20638](https://github.com/netdata/netdata/issues/20638))" ([#21045](https://github.com/netdata/netdata/issues/21045))
- Properly integrate Rust code checks in CI. ([#20862](https://github.com/netdata/netdata/issues/20862))

## [2.6.0] - 2025-07-17

### Merged Pull Requests:

- Revert "Revert "fix(go.d/couchdb): correct db size charts unit"" ([#20235](https://github.com/netdata/netdata/issues/20235))
- Make all threads joinable and join on agent shutdown ([#20228](https://github.com/netdata/netdata/issues/20228))
- Let the user override the default stack size ([#20236](https://github.com/netdata/netdata/issues/20236))
- Fix build issue on old distros ([#20243](https://github.com/netdata/netdata/issues/20243))
- Session claim id in docker ([#20240](https://github.com/netdata/netdata/issues/20240))
- Fix(go.d/sd/snmp): fix snmpv3 credentials ([#20247](https://github.com/netdata/netdata/issues/20247))
- Fix(go.d/snmp): use ifDescr for interface name if ifName is empty ([#20248](https://github.com/netdata/netdata/issues/20248))
- Fix(go.d/snmp): use 32bit counters if 64 aren't available ([#20249](https://github.com/netdata/netdata/issues/20249))
- Update Netdata README ([#20251](https://github.com/netdata/netdata/issues/20251))
- Docs: fix license link and remove GH alerts syntax from FAQ ([#20252](https://github.com/netdata/netdata/issues/20252))
- Fix obsolete chart cleanup to properly handle vnodes ([#20254](https://github.com/netdata/netdata/issues/20254))
- Chore(go.d/snmp): make enable_profiles configurable (needed for dev) ([#20255](https://github.com/netdata/netdata/issues/20255))
- Fix(go.d/sd/snmp): fix snmnpv3 again ([#20256](https://github.com/netdata/netdata/issues/20256))
- Clearify the path of `plugins.d/go.d.plugin` in docs ([#20258](https://github.com/netdata/netdata/issues/20258))
- Update documentation for native DEB/RPM packages ([#20257](https://github.com/netdata/netdata/issues/20257))
- Docs: reword go.d Troubleshooting section for clarity ([#20259](https://github.com/netdata/netdata/issues/20259))
- Fix(go.d/mysql): fix MariaDB User CPU Time ([#20262](https://github.com/netdata/netdata/issues/20262))
- Minor fixes ([#20263](https://github.com/netdata/netdata/issues/20263))
- Update Netdata README with improved structure ([#20265](https://github.com/netdata/netdata/issues/20265))
- Schedule journal file indexing after database file rotation ([#20264](https://github.com/netdata/netdata/issues/20264))
- Build(deps): bump golang.org/x/net from 0.39.0 to 0.40.0 in /src/go ([#20270](https://github.com/netdata/netdata/issues/20270))
- Build(deps): bump github.com/miekg/dns from 1.1.65 to 1.1.66 in /src/go ([#20268](https://github.com/netdata/netdata/issues/20268))
- SNMP first cisco yaml file pass ([#20246](https://github.com/netdata/netdata/issues/20246))
- Chore(go.d/snmp): small cleanup snmp profiles code ([#20274](https://github.com/netdata/netdata/issues/20274))
- Switch to poll from epoll ([#20273](https://github.com/netdata/netdata/issues/20273))
- Switch to uv threads ([#20250](https://github.com/netdata/netdata/issues/20250))
- Improve MSSQL (Part III) ([#20230](https://github.com/netdata/netdata/issues/20230))
- Docs: update mssql meta ([#20278](https://github.com/netdata/netdata/issues/20278))
- Regenerate integrations docs ([#20279](https://github.com/netdata/netdata/issues/20279))
- Improved StatsD documentation ([#20282](https://github.com/netdata/netdata/issues/20282))
- New Windows Metrics (CPU and Memory) ([#20277](https://github.com/netdata/netdata/issues/20277))
- Regenerate integrations docs ([#20284](https://github.com/netdata/netdata/issues/20284))
- Model Context Protocol Server (MCP) for Netdata ([#20244](https://github.com/netdata/netdata/issues/20244))
- Add "unix://" scheme to DOCKER_HOST in run.sh ([#20286](https://github.com/netdata/netdata/issues/20286))
- Improve agent shutdown ([#20280](https://github.com/netdata/netdata/issues/20280))
- Comment metric tags that could be metrics ([#20272](https://github.com/netdata/netdata/issues/20272))
- Fix(go.d): sanitize vnode labels before creating vnode ([#20293](https://github.com/netdata/netdata/issues/20293))
- Build(deps): bump k8s.io/client-go from 0.33.0 to 0.33.1 in /src/go ([#20295](https://github.com/netdata/netdata/issues/20295))
- Build(deps): bump github.com/prometheus/common from 0.63.0 to 0.64.0 in /src/go ([#20296](https://github.com/netdata/netdata/issues/20296))
- Minor code adjustments ([#20290](https://github.com/netdata/netdata/issues/20290))
- Fix when docker socket group id points to an existing group in container ([#20288](https://github.com/netdata/netdata/issues/20288))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.4 to 5.7.5 in /src/go ([#20299](https://github.com/netdata/netdata/issues/20299))
- Updating SOC2 compliance status ([#20300](https://github.com/netdata/netdata/issues/20300))
- Docs: Observability centralization points ([#20292](https://github.com/netdata/netdata/issues/20292))
- Fix(go.d/snmp): replace newline control chars with spaces in system info ([#20301](https://github.com/netdata/netdata/issues/20301))
- Docs: fix `<br>` in streaming ([#20302](https://github.com/netdata/netdata/issues/20302))
- Fix heap-use-after-free in plugins.d inflight functions ([#20304](https://github.com/netdata/netdata/issues/20304))
- Fix use after free of streaming current parent ([#20305](https://github.com/netdata/netdata/issues/20305))
- Improve metasync shutdown ([#20303](https://github.com/netdata/netdata/issues/20303))
- Improve user transition log messages ([#20308](https://github.com/netdata/netdata/issues/20308))
- Docs: fix tip in streaming readme ([#20310](https://github.com/netdata/netdata/issues/20310))
- Plugins dyncfg is always on localhost ([#20312](https://github.com/netdata/netdata/issues/20312))
- Netdata ai ([#20309](https://github.com/netdata/netdata/issues/20309))
- Docs: fix netdata-assistant.md ([#20314](https://github.com/netdata/netdata/issues/20314))
- IIS W3SCV W3MP Metrics (windows.plugin) ([#20245](https://github.com/netdata/netdata/issues/20245))
- Regenerate integrations docs ([#20315](https://github.com/netdata/netdata/issues/20315))
- Reduce memory allocations in event loops ([#20306](https://github.com/netdata/netdata/issues/20306))
- Cisco yaml pass ([#20291](https://github.com/netdata/netdata/issues/20291))
- Ci: ignore changes in src/go/otel-collector/release-config.yaml.in ([#20222](https://github.com/netdata/netdata/issues/20222))
- Build(deps): update otel dependencies version ([#20319](https://github.com/netdata/netdata/issues/20319))
- SNMP: _generic-if.yaml pass ([#20317](https://github.com/netdata/netdata/issues/20317))
- Update libbpf ([#20316](https://github.com/netdata/netdata/issues/20316))
- Build(deps): bump github.com/lmittmann/tint from 1.0.7 to 1.1.0 in /src/go ([#20320](https://github.com/netdata/netdata/issues/20320))
- _generic-tcp.yaml pass ([#20321](https://github.com/netdata/netdata/issues/20321))
- Dont init dyncfg for vnode ([#20324](https://github.com/netdata/netdata/issues/20324))
- Cancel health initialization if shutdown has been requested ([#20318](https://github.com/netdata/netdata/issues/20318))
- SOC 2 cloud doc update ([#20325](https://github.com/netdata/netdata/issues/20325))
- Generic-udp.yaml pass ([#20326](https://github.com/netdata/netdata/issues/20326))
- Generic-bgp4.yaml ([#20328](https://github.com/netdata/netdata/issues/20328))
- Generic-ospf.yaml pass ([#20327](https://github.com/netdata/netdata/issues/20327))
- Update alerting and notification documentation Agent ([#20329](https://github.com/netdata/netdata/issues/20329))
- Update SCIM documentation ([#20330](https://github.com/netdata/netdata/issues/20330))
- Regenerate integrations docs ([#20332](https://github.com/netdata/netdata/issues/20332))
- Code cleanup and improvements ([#20323](https://github.com/netdata/netdata/issues/20323))
- Alerts cloud ([#20334](https://github.com/netdata/netdata/issues/20334))
- _generic-ip.yaml ([#20331](https://github.com/netdata/netdata/issues/20331))
- Build(deps): bump github.com/vmware/govmomi from 0.50.0 to 0.51.0 in /src/go ([#20341](https://github.com/netdata/netdata/issues/20341))
- SNMP: _generic-lldp.yaml ([#20342](https://github.com/netdata/netdata/issues/20342))
- Switch back to epoll from poll ([#20337](https://github.com/netdata/netdata/issues/20337))
- Fix(go.d/dyncfg): fix duplicate potential "name" in userconfig action ([#20346](https://github.com/netdata/netdata/issues/20346))
- Improvement(go.d/sd): better prometheus exporters detection ([#20348](https://github.com/netdata/netdata/issues/20348))
- SNMP: _generic-rtp.yaml ([#20343](https://github.com/netdata/netdata/issues/20343))
- SNMP: _generic-sip.yaml ([#20344](https://github.com/netdata/netdata/issues/20344))
- SNMP: _generic-ucd.yaml ([#20349](https://github.com/netdata/netdata/issues/20349))
- Build(deps): update otel dependencies version ([#20352](https://github.com/netdata/netdata/issues/20352))
- Add installing flex to install-required-packages.sh ([#20322](https://github.com/netdata/netdata/issues/20322))
- Feat(go.d/dyncfg): add autodetect_retry to dyncfg jobs ([#20357](https://github.com/netdata/netdata/issues/20357))
- Chore(go.d): fix some golangcilint warning ([#20360](https://github.com/netdata/netdata/issues/20360))
- Windows updated ([#20358](https://github.com/netdata/netdata/issues/20358))
- Updated configuration reference ([#20347](https://github.com/netdata/netdata/issues/20347))
- _cisco-voice.yaml ([#20361](https://github.com/netdata/netdata/issues/20361))
- SNMP: _generic-ups.yaml ([#20351](https://github.com/netdata/netdata/issues/20351))
- SNMP: _cisco-wlc.yaml ([#20364](https://github.com/netdata/netdata/issues/20364))
- Chore(otel.plugin): fix building ([#20368](https://github.com/netdata/netdata/issues/20368))
- Split systemd-journal plugin and add Rust-based journal file reader ([#20345](https://github.com/netdata/netdata/issues/20345))
- SNMP: _cisco-ipsec-flow-monitor.yaml ([#20353](https://github.com/netdata/netdata/issues/20353))
- SNMP: _fortinet-fortigate-vpn-tunnel.yaml ([#20367](https://github.com/netdata/netdata/issues/20367))
- SNMP: _fortinet-fortigate-cpu-memory.yaml ([#20366](https://github.com/netdata/netdata/issues/20366))
- Build(deps): bump github.com/lmittmann/tint from 1.1.0 to 1.1.1 in /src/go ([#20370](https://github.com/netdata/netdata/issues/20370))
- SNMP: fortinet-appliance.yaml ([#20369](https://github.com/netdata/netdata/issues/20369))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.8.0 to 9.9.0 in /src/go ([#20372](https://github.com/netdata/netdata/issues/20372))
- Build(deps): bump github.com/docker/docker from 28.1.1+incompatible to 28.2.1+incompatible in /src/go ([#20371](https://github.com/netdata/netdata/issues/20371))
- Fix(go.d/oracledb): correct tablespace usage calculation for all types ([#20373](https://github.com/netdata/netdata/issues/20373))
- Regenerate integrations docs ([#20375](https://github.com/netdata/netdata/issues/20375))
- SNMP: fortinet-fortigate.yaml and remove un-needed profile ([#20374](https://github.com/netdata/netdata/issues/20374))
- Chore(otel.plugin): add more receivers/exporter ([#20376](https://github.com/netdata/netdata/issues/20376))
- Test(go.d/oracledb): fix test ([#20378](https://github.com/netdata/netdata/issues/20378))
- SNMP: fortinet-fortiswitch.yaml ([#20377](https://github.com/netdata/netdata/issues/20377))
- Improve datafile rotation and indexing ([#20354](https://github.com/netdata/netdata/issues/20354))
- SNMP: _aruba-switch-cpu-memory.yaml ([#20381](https://github.com/netdata/netdata/issues/20381))
- Update documentation ([#20380](https://github.com/netdata/netdata/issues/20380))
- SNMP: aruba-switch.yaml ([#20385](https://github.com/netdata/netdata/issues/20385))
- SNMP: aruba-cx-switch.yaml ([#20383](https://github.com/netdata/netdata/issues/20383))
- SNMP: aruba-clearpass.yaml ([#20382](https://github.com/netdata/netdata/issues/20382))
- Apps.plugin documentation and grouping matches improvements ([#20386](https://github.com/netdata/netdata/issues/20386))
- Build(deps): bump github.com/docker/docker from 28.2.1+incompatible to 28.2.2+incompatible in /src/go ([#20387](https://github.com/netdata/netdata/issues/20387))
- Model Context Protocol (MCP) Part 2 ([#20287](https://github.com/netdata/netdata/issues/20287))
- Improvement(go.d/httpcheck): add resp validation debug logging ([#20392](https://github.com/netdata/netdata/issues/20392))
- Improve DynCfg documentation ([#20384](https://github.com/netdata/netdata/issues/20384))
- Feat(go.d): allow to debug a specific job ([#20394](https://github.com/netdata/netdata/issues/20394))
- Maintenance: update restart, backup, uninstall, and restore docs ([#20398](https://github.com/netdata/netdata/issues/20398))
- Improve retention calculation after datafile deletion ([#20350](https://github.com/netdata/netdata/issues/20350))
- Rename nd-mcp on windows ([#20404](https://github.com/netdata/netdata/issues/20404))
- SNMP: _juniper-firewall.yaml ([#20407](https://github.com/netdata/netdata/issues/20407))
- SNMP: _juniper-userfirewall.yaml ([#20409](https://github.com/netdata/netdata/issues/20409))
- SNMP: _juniper-scu.yaml ([#20408](https://github.com/netdata/netdata/issues/20408))
- SNMP: _juniper-dcu.yaml ([#20406](https://github.com/netdata/netdata/issues/20406))
- Improvement(go.d): add ddsnmp profile collector (scalar only) ([#20415](https://github.com/netdata/netdata/issues/20415))
- Fix context updates ([#20416](https://github.com/netdata/netdata/issues/20416))
- SNMP: apc_ups.yaml ([#20419](https://github.com/netdata/netdata/issues/20419))
- Chore(go.d/ddsnmp): correctly handle all mapping types ([#20420](https://github.com/netdata/netdata/issues/20420))
- Improve metrics centralization points documentation ([#20412](https://github.com/netdata/netdata/issues/20412))
- Update_installer: Update remove instruction ([#20418](https://github.com/netdata/netdata/issues/20418))
- Docs: remove sizing-netdata-parents.md ([#20421](https://github.com/netdata/netdata/issues/20421))
- ML: Add documentation for Netdata Insights ([#20425](https://github.com/netdata/netdata/issues/20425))
- Feat(go.d/snmp): enable profile scalar metrics collection ([#20426](https://github.com/netdata/netdata/issues/20426))
- Docs(go.d): add example how to debug a specific job ([#20399](https://github.com/netdata/netdata/issues/20399))
- Chore(go.d/ddsnmp): lazy ddsnmp profile loading ([#20427](https://github.com/netdata/netdata/issues/20427))
- Update MSSQL Metadata ([#20429](https://github.com/netdata/netdata/issues/20429))
- Update ddsnmp mikrotik-router.yaml ([#20428](https://github.com/netdata/netdata/issues/20428))
- Regenerate integrations docs ([#20430](https://github.com/netdata/netdata/issues/20430))
- Enforce correct CPU architecture for Go plugin builds. ([#20405](https://github.com/netdata/netdata/issues/20405))
- Improve statement finalization and cleanup ([#20433](https://github.com/netdata/netdata/issues/20433))
- Adjust stream connector timeout during agent shutdown ([#20434](https://github.com/netdata/netdata/issues/20434))
- Fix heap-use-after-free in query progress updates ([#20431](https://github.com/netdata/netdata/issues/20431))
- Mcp3 ([#20435](https://github.com/netdata/netdata/issues/20435))
- Fix registry save integer overflow and add failure backoff ([#20437](https://github.com/netdata/netdata/issues/20437))
- Improvement(go.d/ddsnmp): use dev type and vendor from meta for family ([#20439](https://github.com/netdata/netdata/issues/20439))
- Chore(go.d/ddsnmp): add basic SNMP table walking functionality ([#20441](https://github.com/netdata/netdata/issues/20441))
- Build(deps): bump golang.org/x/net from 0.40.0 to 0.41.0 in /src/go ([#20444](https://github.com/netdata/netdata/issues/20444))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.40.0 to 1.41.0 in /src/go ([#20449](https://github.com/netdata/netdata/issues/20449))
- Build(deps): bump github.com/lmittmann/tint from 1.1.1 to 1.1.2 in /src/go ([#20446](https://github.com/netdata/netdata/issues/20446))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.3 to 1.17.4 in /src/go ([#20447](https://github.com/netdata/netdata/issues/20447))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.9.0 to 9.10.0 in /src/go ([#20445](https://github.com/netdata/netdata/issues/20445))
- Feat: improve SCIM documentation ([#20451](https://github.com/netdata/netdata/issues/20451))
- Regenerate integrations docs ([#20453](https://github.com/netdata/netdata/issues/20453))
- Improvement(go.d/ddsnmp): dedup metrics when merging profiles ([#20456](https://github.com/netdata/netdata/issues/20456))
- Weblog collector: Exclude 429 from 4xx ([#20443](https://github.com/netdata/netdata/issues/20443))
- Build(deps): bump github.com/sijms/go-ora/v2 from 2.8.24 to 2.9.0 in /src/go ([#20457](https://github.com/netdata/netdata/issues/20457))
- Chore(go.d/smartctl): debug log exec output ([#20460](https://github.com/netdata/netdata/issues/20460))
- Build: update otel-collector deps ([#20461](https://github.com/netdata/netdata/issues/20461))
- Improvement(go.d/ddsnmp): add table metrics, tags from the same table ([#20463](https://github.com/netdata/netdata/issues/20463))
- Improve database indexing and rotation handling in event loop ([#20459](https://github.com/netdata/netdata/issues/20459))
- Improvement(go.d/ddsnmp): add table metrics and tags caching optimization ([#20465](https://github.com/netdata/netdata/issues/20465))
- Add MSSQL Wait statistics (windows.plugin) ([#20307](https://github.com/netdata/netdata/issues/20307))
- Regenerate integrations docs ([#20466](https://github.com/netdata/netdata/issues/20466))
- Vendor protobuf in static builds. ([#17774](https://github.com/netdata/netdata/issues/17774))
- Improve datafile rotation and indexing during shutdown ([#20464](https://github.com/netdata/netdata/issues/20464))
- Handle orphan journal files by deleting unmatched entries ([#20462](https://github.com/netdata/netdata/issues/20462))
- Remove static build timeouts from regular builds. ([#20470](https://github.com/netdata/netdata/issues/20470))
- Improvement(go.d/snmp): create table charts ([#20471](https://github.com/netdata/netdata/issues/20471))
- Add MCP documentation ([#20469](https://github.com/netdata/netdata/issues/20469))
- Update mcp.md ([#20475](https://github.com/netdata/netdata/issues/20475))
- Chore(go.d/ddsnmp): add dependency-based expiration to table cache ([#20474](https://github.com/netdata/netdata/issues/20474))
- Improvement(go.d): add bearer_token_file to request cfg ([#20476](https://github.com/netdata/netdata/issues/20476))
- Fix(go.d/redis): don't clear tls for rediss ([#20478](https://github.com/netdata/netdata/issues/20478))
- Chore(go.d/ddsnmp): split table collection into walk and process phases ([#20479](https://github.com/netdata/netdata/issues/20479))
- Chore(go.d/ddsnmp): collect cross-table metrics and tags ([#20481](https://github.com/netdata/netdata/issues/20481))
- Correctly ignore patches that are already applied. ([#20480](https://github.com/netdata/netdata/issues/20480))
- Modify Uninstall Action (windows.installer) ([#20467](https://github.com/netdata/netdata/issues/20467))
- Fix typo. ([#20417](https://github.com/netdata/netdata/issues/20417))
- Chore(go.d/ddsnmp):  support extracting table index components as tags ([#20482](https://github.com/netdata/netdata/issues/20482))
- Build(deps): bump github.com/go-sql-driver/mysql from 1.9.2 to 1.9.3 in /src/go ([#20483](https://github.com/netdata/netdata/issues/20483))
- Anue ([#20488](https://github.com/netdata/netdata/issues/20488))
- Fix(go.d): add missing props to config schemas ([#20489](https://github.com/netdata/netdata/issues/20489))
- Fix fluentd schema permit_plugin ([#20490](https://github.com/netdata/netdata/issues/20490))
- Chore(go.d/ddsnmp): fix table metrics collection ([#20492](https://github.com/netdata/netdata/issues/20492))
- Fix: mark import groups as not supported SCIM feature ([#20495](https://github.com/netdata/netdata/issues/20495))
- Regenerate integrations docs ([#20496](https://github.com/netdata/netdata/issues/20496))
- Chore(go.d/ddsnmp): fix table metrics again ([#20497](https://github.com/netdata/netdata/issues/20497))
- Chore(go.d/ddsnmp): better label values sanitization ([#20500](https://github.com/netdata/netdata/issues/20500))
- Feat(go.d/ddsnmp): make SNMP profile collection configurable ([#20503](https://github.com/netdata/netdata/issues/20503))
- Fix snmp prof mikrotik mem tagging ([#20504](https://github.com/netdata/netdata/issues/20504))
- Additional checks on metasync thread shutdown ([#20455](https://github.com/netdata/netdata/issues/20455))
- Improve(go.d/snmp profiles): simplify _generic-if.yaml and add interface type tags ([#20505](https://github.com/netdata/netdata/issues/20505))
- Monitor Exchange Server (Window.plugin) ([#20454](https://github.com/netdata/netdata/issues/20454))
- Feat(go.d/snmp profile): add sensors to mikrotik-router.yaml ([#20507](https://github.com/netdata/netdata/issues/20507))
- Feat(go.d/snmp profile): add fallback support for duplicate metric tags ([#20508](https://github.com/netdata/netdata/issues/20508))
- Chore(go.d/ddsnmp): fix table collection with caching ([#20509](https://github.com/netdata/netdata/issues/20509))
- Regenerate integrations docs ([#20506](https://github.com/netdata/netdata/issues/20506))
- Test(go.d/ddsnmp): add more tests for table metrics ([#20510](https://github.com/netdata/netdata/issues/20510))
- Improve(go.d/snmp): add SNMP- prefix for vnode hostname ([#20512](https://github.com/netdata/netdata/issues/20512))
- Docs: add Netdata MCP Server preview announcement ([#20513](https://github.com/netdata/netdata/issues/20513))
- Update machine-learning-and-assisted-troubleshooting.md ([#20514](https://github.com/netdata/netdata/issues/20514))
- Use ARAL for labels ([#20502](https://github.com/netdata/netdata/issues/20502))
- Cleanup pending statements during shutdown ([#20511](https://github.com/netdata/netdata/issues/20511))
- Update mcp.md ([#20515](https://github.com/netdata/netdata/issues/20515))
- Improve(go.d/snmp-profiles): Add hrSystemUptime metric for system upt… ([#20516](https://github.com/netdata/netdata/issues/20516))
- Fix(go.d/ddsnmp): remove singular-to-plural conversion in metric family ([#20517](https://github.com/netdata/netdata/issues/20517))
- Drop POWER8+ builds. ([#20518](https://github.com/netdata/netdata/issues/20518))
- Chore(go.d/snmp-profiles): remove unsupported constant_value_one metrics ([#20519](https://github.com/netdata/netdata/issues/20519))
- MCP Part 4 ([#20452](https://github.com/netdata/netdata/issues/20452))
- Improve(go.d/snmp-profiles): metrics deduplication ([#20520](https://github.com/netdata/netdata/issues/20520))
- Upd generic check in snmp prof metrics deduplication ([#20521](https://github.com/netdata/netdata/issues/20521))
- Update units in _generic-if.yaml ([#20523](https://github.com/netdata/netdata/issues/20523))
- Improve(go.d/snmp): log device profiles matched by sysObjectID ([#20524](https://github.com/netdata/netdata/issues/20524))
- Improve(go.d/snmp-profiles): allow users to add custom SNMP profiles ([#20526](https://github.com/netdata/netdata/issues/20526))
- Improve(go.d/snmp): add Go template-based metric transformations for SNMP profiles ([#20528](https://github.com/netdata/netdata/issues/20528))
- Improve(go.d/snmp): dd support for non-identifying tags in table metrics ([#20530](https://github.com/netdata/netdata/issues/20530))
- Build(deps): bump k8s.io/client-go from 0.33.1 to 0.33.2 in /src/go ([#20532](https://github.com/netdata/netdata/issues/20532))
- Lock before checking the statement pool ([#20536](https://github.com/netdata/netdata/issues/20536))
- Refactor(go.d/ddsnmpcollector): restructure into components ([#20543](https://github.com/netdata/netdata/issues/20543))
- SNMP: bluecat profile ([#20538](https://github.com/netdata/netdata/issues/20538))
- Update SQLITE to version 3.50.1 ([#20539](https://github.com/netdata/netdata/issues/20539))
- Build(deps): bump github.com/prometheus/common from 0.64.0 to 0.65.0 in /src/go ([#20545](https://github.com/netdata/netdata/issues/20545))
- Improve(go.d/snmp-profiles): add DHCP tags transform to bluecat profile ([#20547](https://github.com/netdata/netdata/issues/20547))
- Enable Rust-based journal file reader in static builds. ([#20477](https://github.com/netdata/netdata/issues/20477))
- Properly parse disconnect reason ([#20540](https://github.com/netdata/netdata/issues/20540))
- MSI parameter ([#20550](https://github.com/netdata/netdata/issues/20550))
- Hardware (Windows.plugin) ([#20522](https://github.com/netdata/netdata/issues/20522))
- Fix save alert config transition on shutdown ([#20553](https://github.com/netdata/netdata/issues/20553))
- Regenerate integrations docs ([#20552](https://github.com/netdata/netdata/issues/20552))
- Mcp disclaimer update ([#20563](https://github.com/netdata/netdata/issues/20563))
- Additional checks for valid db during db_execute ([#20560](https://github.com/netdata/netdata/issues/20560))
- Check that there is a valid thread when performing ACLK sync shutdown ([#20555](https://github.com/netdata/netdata/issues/20555))
- Simplify MRG loading mechanism logic ([#20562](https://github.com/netdata/netdata/issues/20562))
- Improve(go.d/smartctl): enable direct smartctl execution on non-Linux ([#20567](https://github.com/netdata/netdata/issues/20567))
- Add CLI command to schedule update information ([#20558](https://github.com/netdata/netdata/issues/20558))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.10.0 to 9.11.0 in /src/go ([#20568](https://github.com/netdata/netdata/issues/20568))
- Improve(go.d/smartctl): add configurable concurrent device scanning ([#20569](https://github.com/netdata/netdata/issues/20569))
- Regenerate integrations docs ([#20571](https://github.com/netdata/netdata/issues/20571))
- Switch install types ([#20564](https://github.com/netdata/netdata/issues/20564))
- Improve(go.d/smartctl): add Win default path for smartctl executable ([#20574](https://github.com/netdata/netdata/issues/20574))
- Chore(go.d/snmp-profiles): skip abstract when loading ([#20576](https://github.com/netdata/netdata/issues/20576))
- NUMA Windows  ([#20573](https://github.com/netdata/netdata/issues/20573))
- Regenerate integrations docs ([#20577](https://github.com/netdata/netdata/issues/20577))
- Add Remove Node guide ([#20549](https://github.com/netdata/netdata/issues/20549))
- Improve SQLite library shutdown handling and initialization state ([#20559](https://github.com/netdata/netdata/issues/20559))
- Add Rocky Linux 10 to CI and package builds. ([#20578](https://github.com/netdata/netdata/issues/20578))
- Fix(go.d/ddsnmp): walk cross-table columns when referenced table has no metrics ([#20583](https://github.com/netdata/netdata/issues/20583))
- Fix(go.d/ddsnmp): include table name in config id ([#20584](https://github.com/netdata/netdata/issues/20584))
- Add defines for cleanup statements ([#20570](https://github.com/netdata/netdata/issues/20570))
- Remove devType/Vendor/ from ddsnmp metric families ([#20585](https://github.com/netdata/netdata/issues/20585))
- Fix(go.d/ddsnmp): correct matching same profile multiple times ([#20586](https://github.com/netdata/netdata/issues/20586))
- Ddsnmp add pow transform func and allow mapping duplicate values ([#20587](https://github.com/netdata/netdata/issues/20587))
- Doc: update SCIM doc ([#20588](https://github.com/netdata/netdata/issues/20588))
- Regenerate integrations docs ([#20589](https://github.com/netdata/netdata/issues/20589))
- Build(deps): bump github.com/go-viper/mapstructure/v2 from 2.2.1 to 2.3.0 in /src/go/otel-collector/exporter/netdataexporter ([#20591](https://github.com/netdata/netdata/issues/20591))
- Mcp5 ([#20529](https://github.com/netdata/netdata/issues/20529))
- Build(deps): bump github.com/go-viper/mapstructure/v2 from 2.2.1 to 2.3.0 in /src/go/otel-collector/exporter/journaldexporter ([#20592](https://github.com/netdata/netdata/issues/20592))
- SNMP: new version of families Cisco pass ([#20432](https://github.com/netdata/netdata/issues/20432))
- SNMP: palo-alto.yaml ([#20391](https://github.com/netdata/netdata/issues/20391))
- SNMP: aruba-wireless-controller.yaml ([#20389](https://github.com/netdata/netdata/issues/20389))
- SNMP: _juniper-cos.yaml ([#20402](https://github.com/netdata/netdata/issues/20402))
- Improve(go.d/snmp-profiles): extend transformEntitySensorValue ([#20594](https://github.com/netdata/netdata/issues/20594))
- SNMP: _juniper-virtualchassis.yaml ([#20410](https://github.com/netdata/netdata/issues/20410))
- SNMP: juniper-pulse-secure.yaml ([#20413](https://github.com/netdata/netdata/issues/20413))
- SNMP: 3com profiles ([#20468](https://github.com/netdata/netdata/issues/20468))
- SNMP: a10 yamls ([#20472](https://github.com/netdata/netdata/issues/20472))
- SNMP: APC profiles ([#20491](https://github.com/netdata/netdata/issues/20491))
- SNMP: Alcatel profiles ([#20487](https://github.com/netdata/netdata/issues/20487))
- SNMP: Arista profiles ([#20498](https://github.com/netdata/netdata/issues/20498))
- SNMP: second pass of aruba profiles ([#20499](https://github.com/netdata/netdata/issues/20499))
- SNMP: avaya profiles ([#20525](https://github.com/netdata/netdata/issues/20525))
- SNMP: audiocodes profile ([#20501](https://github.com/netdata/netdata/issues/20501))
- SNMP: avocent profile ([#20527](https://github.com/netdata/netdata/issues/20527))
- SNMP: brother profile ([#20548](https://github.com/netdata/netdata/issues/20548))
- SNMP: cradlepoint profile ([#20561](https://github.com/netdata/netdata/issues/20561))
- Build(deps): bump github.com/docker/docker from 28.2.2+incompatible to 28.3.0+incompatible in /src/go ([#20595](https://github.com/netdata/netdata/issues/20595))
- SNMP: avtech Profiles ([#20535](https://github.com/netdata/netdata/issues/20535))
- SNMP: barracuda Profiles ([#20537](https://github.com/netdata/netdata/issues/20537))
- SNMP: brocade profiles ([#20546](https://github.com/netdata/netdata/issues/20546))
- SNMP: checkpoint profiles ([#20556](https://github.com/netdata/netdata/issues/20556))
- SNMP: chrysalis profiles ([#20557](https://github.com/netdata/netdata/issues/20557))
- SNMP: Chatsworth profile ([#20554](https://github.com/netdata/netdata/issues/20554))
- SNMP: cyberpower-pdu profile ([#20575](https://github.com/netdata/netdata/issues/20575))
- Docs: fix 404 link in README.md ([#20597](https://github.com/netdata/netdata/issues/20597))
- Migrate from stable to nightly and vice versa ([#20551](https://github.com/netdata/netdata/issues/20551))
- Update generic snmp profiles ([#20599](https://github.com/netdata/netdata/issues/20599))
- Small snmp-related changes ([#20603](https://github.com/netdata/netdata/issues/20603))
- Improve mikrotik-router snmp profile ([#20605](https://github.com/netdata/netdata/issues/20605))
- Fix compilation on windows ([#20602](https://github.com/netdata/netdata/issues/20602))
- Ignore duplicate entries when rebuilding the alert version table ([#20579](https://github.com/netdata/netdata/issues/20579))
- Chore(go.d/snmp): add disable_legacy_collection option ([#20606](https://github.com/netdata/netdata/issues/20606))
- Metadata worker should respect shutdown request ([#20598](https://github.com/netdata/netdata/issues/20598))
- Improve netapp snmp profile ([#20608](https://github.com/netdata/netdata/issues/20608))
- Update fortinet snmp profiles ([#20609](https://github.com/netdata/netdata/issues/20609))
- SNMP Mikrotik profile make units in transform ucum ([#20611](https://github.com/netdata/netdata/issues/20611))
- Update sqlite version to 3.50.2 ([#20601](https://github.com/netdata/netdata/issues/20601))
- Improve datafile indexing ([#20607](https://github.com/netdata/netdata/issues/20607))
- Update tripplite snmp profiles ([#20613](https://github.com/netdata/netdata/issues/20613))
- Bump otel-collector components to v0.129.0 ([#20615](https://github.com/netdata/netdata/issues/20615))
- Transfer Learn PR 2473 ([#20600](https://github.com/netdata/netdata/issues/20600))
- Chore(go.d/snmp-profiles): move fam desc and unit under chart_meta ([#20614](https://github.com/netdata/netdata/issues/20614))
- Chore(go.d/snmp-profiles): small cleanup ([#20618](https://github.com/netdata/netdata/issues/20618))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p1 ([#20620](https://github.com/netdata/netdata/issues/20620))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p2 ([#20621](https://github.com/netdata/netdata/issues/20621))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p3 ([#20622](https://github.com/netdata/netdata/issues/20622))
- Fix coverity issues ([#20612](https://github.com/netdata/netdata/issues/20612))
- Improve journal v2 file creation on startup  ([#20619](https://github.com/netdata/netdata/issues/20619))
- Improve packet ID generation ([#20624](https://github.com/netdata/netdata/issues/20624))
- At a glance ([#20627](https://github.com/netdata/netdata/issues/20627))
- Fix syntax error on learn doc ([#20628](https://github.com/netdata/netdata/issues/20628))
- Nidl Framework Documentation ([#20629](https://github.com/netdata/netdata/issues/20629))
- [WIP] Move NIDL-Framework.md to docs/ directory ([#20630](https://github.com/netdata/netdata/issues/20630))
- Move NIDL to docs ([#20632](https://github.com/netdata/netdata/issues/20632))
- Build(deps): bump github.com/docker/docker from 28.3.0+incompatible to 28.3.1+incompatible in /src/go ([#20633](https://github.com/netdata/netdata/issues/20633))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p4 ([#20623](https://github.com/netdata/netdata/issues/20623))
- Update NIDL-Framework.md ([#20634](https://github.com/netdata/netdata/issues/20634))
- Refactor(go.d/iprange): migrate from net to net/netip ([#20636](https://github.com/netdata/netdata/issues/20636))
- MCP in Netdata Operations Diagram ([#20637](https://github.com/netdata/netdata/issues/20637))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p5 ([#20635](https://github.com/netdata/netdata/issues/20635))
- Improve ACLK connection handling ([#20625](https://github.com/netdata/netdata/issues/20625))
- Rework datafiles ([#20581](https://github.com/netdata/netdata/issues/20581))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p6 ([#20640](https://github.com/netdata/netdata/issues/20640))
- Add Screen to Windows installer ([#20593](https://github.com/netdata/netdata/issues/20593))
- Additional checks for ACLK proxy setting ([#20639](https://github.com/netdata/netdata/issues/20639))
- Update Cloud OIDC Authorization Server setup docs ([#20643](https://github.com/netdata/netdata/issues/20643))
- Regenerate integrations docs ([#20644](https://github.com/netdata/netdata/issues/20644))
- SNMP Profiles pass ep1 ([#20641](https://github.com/netdata/netdata/issues/20641))
- Chore(go.d/snmp-profiles): fix quotes ([#20645](https://github.com/netdata/netdata/issues/20645))
- SNMP profiles pass ep2 ([#20647](https://github.com/netdata/netdata/issues/20647))
- Sophos ([#20648](https://github.com/netdata/netdata/issues/20648))
- Build(deps): bump github.com/docker/docker from 28.3.1+incompatible to 28.3.2+incompatible in /src/go ([#20650](https://github.com/netdata/netdata/issues/20650))
- Build(deps): bump golang.org/x/text from 0.26.0 to 0.27.0 in /src/go ([#20651](https://github.com/netdata/netdata/issues/20651))
- Build(deps): bump github.com/miekg/dns from 1.1.66 to 1.1.67 in /src/go ([#20649](https://github.com/netdata/netdata/issues/20649))
- Fix documentation regarding header_match ([#20652](https://github.com/netdata/netdata/issues/20652))
- Regenerate integrations docs ([#20655](https://github.com/netdata/netdata/issues/20655))
- ASP.NET (windows.plugin) ([#20485](https://github.com/netdata/netdata/issues/20485))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p7 ([#20646](https://github.com/netdata/netdata/issues/20646))
- Stop submitting analytics ([#20654](https://github.com/netdata/netdata/issues/20654))
- Fix coverity issues ([#20656](https://github.com/netdata/netdata/issues/20656))
- Improve job completion handling with timeout mechanism ([#20657](https://github.com/netdata/netdata/issues/20657))
- Chore(go.d/snmp-profiles): charts meta fixes and fam updates p8 ([#20660](https://github.com/netdata/netdata/issues/20660))
- Cloud Docs: updated ([#20661](https://github.com/netdata/netdata/issues/20661))
- Docs: fix "Unsupported markdown: list" in NC readme diagram ([#20665](https://github.com/netdata/netdata/issues/20665))
- Fix datafile creation race condition ([#20662](https://github.com/netdata/netdata/issues/20662))
- Regenerate integrations docs ([#20659](https://github.com/netdata/netdata/issues/20659))
- Build(deps): bump golang.org/x/net from 0.41.0 to 0.42.0 in /src/go ([#20667](https://github.com/netdata/netdata/issues/20667))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.8.1 to 4.9.0 in /src/go ([#20666](https://github.com/netdata/netdata/issues/20666))
- Windows Pluging (Freedom to update every) ([#20580](https://github.com/netdata/netdata/issues/20580))
- Update netdata-enterprise-evaluation-corrected.md
- Add comprehensive welcome document ([#20669](https://github.com/netdata/netdata/issues/20669))
- Add ML anomaly detection accuracy analysis documentation ([#20663](https://github.com/netdata/netdata/issues/20663))
- Escape chars on documentation ([#20671](https://github.com/netdata/netdata/issues/20671))
- Regenerate integrations docs ([#20668](https://github.com/netdata/netdata/issues/20668))
- Update welcome-to-netdata.md
- Nd-mcp add claude cli cmd for adding netdata mcp ([#20440](https://github.com/netdata/netdata/issues/20440))
- Feat(go.d/snmp): enable table metrics by default ([#20674](https://github.com/netdata/netdata/issues/20674))
- Regenerate integrations docs ([#20675](https://github.com/netdata/netdata/issues/20675))
- Build(deps): bump azure/trusted-signing-action from 0.5.1 to 0.5.9 ([#20670](https://github.com/netdata/netdata/issues/20670))
- Improve agent shutdown on windows ([#20672](https://github.com/netdata/netdata/issues/20672))
- Code cleanup ([#20673](https://github.com/netdata/netdata/issues/20673))
- Agent docs alignement ([#20676](https://github.com/netdata/netdata/issues/20676))
- Chore(charts.d): suppress broken pipe error from echo during cleanup ([#20680](https://github.com/netdata/netdata/issues/20680))
- Fix deadlock in dictionary cleanup ([#20679](https://github.com/netdata/netdata/issues/20679))
- Remove Ubuntu 24.10 from CI and package builds. ([#20681](https://github.com/netdata/netdata/issues/20681))
- Fix systemd-journal-plugin RPM package. ([#20686](https://github.com/netdata/netdata/issues/20686))
- Fix log message format for buffered reader error ([#20687](https://github.com/netdata/netdata/issues/20687))
- Docs: update continue ext setup ([#20689](https://github.com/netdata/netdata/issues/20689))
- Docs: fix file location in continue setup ([#20690](https://github.com/netdata/netdata/issues/20690))
- Remove Fedora 40 from CI and package builds. ([#20685](https://github.com/netdata/netdata/issues/20685))
- Docs: remove Profiles heading from collapsible section ([#20691](https://github.com/netdata/netdata/issues/20691))

## [2.5.0] - 2025-05-05

### Merged Pull Requests:

- SNMP, Custom descriptions and units ([#20100](https://github.com/netdata/netdata/issues/20100))
- Create Empty Directories (Windows installer) ([#20124](https://github.com/netdata/netdata/issues/20124))
- Fix cleanup and exit and memory leaks ([#20120](https://github.com/netdata/netdata/issues/20120))
- Sqlite upgrade to version 3.49.1 ([#19933](https://github.com/netdata/netdata/issues/19933))
- Work to find leaks easily ([#20106](https://github.com/netdata/netdata/issues/20106))
- Fix compilation when using FSANITIZE_ADDRESS ([#20129](https://github.com/netdata/netdata/issues/20129))
- Handle corrupted journal data when populating the MRG during startup. ([#20128](https://github.com/netdata/netdata/issues/20128))
- Free ACLK message ([#20125](https://github.com/netdata/netdata/issues/20125))
- Make sure pattern array items are added and evaluated in order ([#20130](https://github.com/netdata/netdata/issues/20130))
- Fix Locks (Windows Locks) ([#20131](https://github.com/netdata/netdata/issues/20131))
- Update README.md ([#20133](https://github.com/netdata/netdata/issues/20133))
- Installation-Static Build-Windows ([#20122](https://github.com/netdata/netdata/issues/20122))
- Expression evaluator in re2c/lemon ([#20126](https://github.com/netdata/netdata/issues/20126))
- Install fix admonition docs ([#20136](https://github.com/netdata/netdata/issues/20136))
- Update MSI to use a single unified EULA instead of multiple license pages. ([#20134](https://github.com/netdata/netdata/issues/20134))
- Create netdata-kubernetes.md
- Update netdata-kubernetes.md
- Improve error handling and logging for journal and data files ([#20112](https://github.com/netdata/netdata/issues/20112))
- Fix MSSQL and improvements ([#20032](https://github.com/netdata/netdata/issues/20032))
- Chore(otel/journaldexporter): improve remote tests ([#20143](https://github.com/netdata/netdata/issues/20143))
- Docs: cleanup language and fix minor grammar issues ([#20144](https://github.com/netdata/netdata/issues/20144))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.39.0 to 1.40.0 in /src/go ([#20149](https://github.com/netdata/netdata/issues/20149))
- Build(deps): bump github.com/invopop/jsonschema from 0.12.0 to 0.13.0 in /src/go ([#20152](https://github.com/netdata/netdata/issues/20152))
- Build(deps): bump github.com/go-ldap/ldap/v3 from 3.4.10 to 3.4.11 in /src/go ([#20151](https://github.com/netdata/netdata/issues/20151))
- Build(deps): bump github.com/docker/docker from 28.0.4+incompatible to 28.1.1+incompatible in /src/go ([#20153](https://github.com/netdata/netdata/issues/20153))
- Chore(go.d/apcupsd): log UPS response in debug mode ([#20157](https://github.com/netdata/netdata/issues/20157))
- Improvement(cgroups): filter systemd-nspawn payload by default ([#20155](https://github.com/netdata/netdata/issues/20155))
- Improve metadata event loop shutdown ([#20132](https://github.com/netdata/netdata/issues/20132))
- Fix compilation with DBENGINE disabled ([#20154](https://github.com/netdata/netdata/issues/20154))
- Fix(dyncfg/health): correct db lookup absolute option name ([#20161](https://github.com/netdata/netdata/issues/20161))
- Chore(go.d/snmp): remove unused ddsnmp ([#20164](https://github.com/netdata/netdata/issues/20164))
- Docs: update macOS/freeBSD versions in  Versions & Platforms ([#20165](https://github.com/netdata/netdata/issues/20165))
- Chore(go.d): remove wmi->win collector rename handling ([#20166](https://github.com/netdata/netdata/issues/20166))
- Dashboards and charts ([#20162](https://github.com/netdata/netdata/issues/20162))
- Update platforms for CI and package builds. ([#20119](https://github.com/netdata/netdata/issues/20119))
- Update kickstart.md ([#20167](https://github.com/netdata/netdata/issues/20167))
- Improvement(cgroups): improve systemd-nspawn filter for default ([#20168](https://github.com/netdata/netdata/issues/20168))
- Fix integrations config file sample ([#20169](https://github.com/netdata/netdata/issues/20169))
- Regenerate integrations docs ([#20170](https://github.com/netdata/netdata/issues/20170))
- Chore(otel/netdataexporter): add exporter module skeleton ([#20171](https://github.com/netdata/netdata/issues/20171))
- Build(deps): bump github.com/vmware/govmomi from 0.49.0 to 0.50.0 in /src/go ([#20173](https://github.com/netdata/netdata/issues/20173))
- Build(deps): update go toolchain to v1.24.2 ([#20176](https://github.com/netdata/netdata/issues/20176))
- Fix memory leaks and service thread corruption ([#20159](https://github.com/netdata/netdata/issues/20159))
- Fix labels memory accounting ([#20158](https://github.com/netdata/netdata/issues/20158))
- Bump go mod 1.24.0 ([#20179](https://github.com/netdata/netdata/issues/20179))
- Build(deps): bump k8s.io/client-go from 0.32.3 to 0.33.0 in /src/go ([#20175](https://github.com/netdata/netdata/issues/20175))
- Retry nightly changelog generation. ([#20178](https://github.com/netdata/netdata/issues/20178))
- Improve pgc fatal errors ([#20181](https://github.com/netdata/netdata/issues/20181))
- Group anomaly rate per chart context instead of type. ([#20180](https://github.com/netdata/netdata/issues/20180))
- Some fixes for macOS < 11 ([#20145](https://github.com/netdata/netdata/issues/20145))
- Ensure atomicity when logging pending message ([#20185](https://github.com/netdata/netdata/issues/20185))
- Fix recursive lock ([#20188](https://github.com/netdata/netdata/issues/20188))
- Ensure atomicity when logging pending message 3/3 ([#20189](https://github.com/netdata/netdata/issues/20189))
- Fix repeating alert crash ([#20186](https://github.com/netdata/netdata/issues/20186))
- Added dyncfg docs ([#20187](https://github.com/netdata/netdata/issues/20187))
- Ignore maintenance signals on exit ([#20190](https://github.com/netdata/netdata/issues/20190))
- Limit the max number of threads based on memory too ([#20192](https://github.com/netdata/netdata/issues/20192))
- Exporting exit fix ([#20191](https://github.com/netdata/netdata/issues/20191))
- Cleanup ML cached pointers on child disconnection ([#20195](https://github.com/netdata/netdata/issues/20195))
- Rrdset/rrddim find function do not return obsolete metadata ([#20196](https://github.com/netdata/netdata/issues/20196))
- Improve systemd journal logs documentation ([#20184](https://github.com/netdata/netdata/issues/20184))
- Spinlocks now timeout at 10 minutes, to reveal deadlocks ([#20197](https://github.com/netdata/netdata/issues/20197))
- Add fast path to waitq ([#20198](https://github.com/netdata/netdata/issues/20198))
- Rrd metadata needs to be discoverable while replication is running ([#20200](https://github.com/netdata/netdata/issues/20200))
- Reorganize code (IIS) ([#20182](https://github.com/netdata/netdata/issues/20182))
- Add a default busy timeout ([#20201](https://github.com/netdata/netdata/issues/20201))
- Rrd metadata search fix ([#20203](https://github.com/netdata/netdata/issues/20203))
- Remove the status file spinlock to avoid deadlocks ([#20205](https://github.com/netdata/netdata/issues/20205))
- Call spinlock_init() when initializing rrdlabels spinlock ([#20206](https://github.com/netdata/netdata/issues/20206))
- Added more annotations in spinlock deadlock detection ([#20207](https://github.com/netdata/netdata/issues/20207))
- Avoid indexing journal files when db rotation is running ([#20204](https://github.com/netdata/netdata/issues/20204))
- Use one spinlock to access v2 and mmap related data ([#20202](https://github.com/netdata/netdata/issues/20202))
- Fix hardcoding of eval variables ([#20210](https://github.com/netdata/netdata/issues/20210))
- Small fixes ([#20209](https://github.com/netdata/netdata/issues/20209))
- Security and Privacy Design ([#20208](https://github.com/netdata/netdata/issues/20208))
- Add Fedora 42 to CI and package builds. ([#20177](https://github.com/netdata/netdata/issues/20177))
- Improve health log cleanup ([#20213](https://github.com/netdata/netdata/issues/20213))
- Use nd threads in exporting ([#20212](https://github.com/netdata/netdata/issues/20212))
- Small fixes2 ([#20219](https://github.com/netdata/netdata/issues/20219))
- SNMP profiles units and description generation ([#20163](https://github.com/netdata/netdata/issues/20163))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.7.3 to 9.8.0 in /src/go ([#20220](https://github.com/netdata/netdata/issues/20220))
- Chore(otel/netdataexporter): poc version ([#20199](https://github.com/netdata/netdata/issues/20199))
- Documentation and helpers for centralizing namespaced logs ([#20217](https://github.com/netdata/netdata/issues/20217))
- Enable analytics data collection  ([#20221](https://github.com/netdata/netdata/issues/20221))
- Fix crashes 7 ([#20224](https://github.com/netdata/netdata/issues/20224))
- Fix crashes 8 ([#20225](https://github.com/netdata/netdata/issues/20225))
- Fix potential null pointer dereference when accessing journalfile ([#20226](https://github.com/netdata/netdata/issues/20226))
- Clean up prepared statements on thread exit ([#20211](https://github.com/netdata/netdata/issues/20211))
- Improve MSSQL (Windows.plugin Part II) ([#20141](https://github.com/netdata/netdata/issues/20141))
- Status file 28 ([#20229](https://github.com/netdata/netdata/issues/20229))
- Regenerate integrations docs ([#20227](https://github.com/netdata/netdata/issues/20227))
- Docs: rename DynCfg developer doc to avoid title conflict ([#20232](https://github.com/netdata/netdata/issues/20232))
- Fix(go.d/couchdb): correct db size charts unit ([#20233](https://github.com/netdata/netdata/issues/20233))
- Revert "fix(go.d/couchdb): correct db size charts unit" ([#20234](https://github.com/netdata/netdata/issues/20234))

## [2.4.0] - 2025-04-14

### Merged Pull Requests:

- New exit cause: shutdown timeout ([#19903](https://github.com/netdata/netdata/issues/19903))
- Fix reliability calculation ([#19909](https://github.com/netdata/netdata/issues/19909))
- Store alert config asynchronously ([#19885](https://github.com/netdata/netdata/issues/19885))
- Post the first status when there is no last status ([#19912](https://github.com/netdata/netdata/issues/19912))
- Do not enqueue command if aclk is not initialized ([#19914](https://github.com/netdata/netdata/issues/19914))
- Detect null datafile while finding datafiles in range ([#19913](https://github.com/netdata/netdata/issues/19913))
- Align cmsgbuf to size_t to avoid unaligned memory access. ([#19917](https://github.com/netdata/netdata/issues/19917))
- Make sure ACLK sync thread completes initialization ([#19916](https://github.com/netdata/netdata/issues/19916))
- Exclude external code from CodeQL scanning. ([#19923](https://github.com/netdata/netdata/issues/19923))
- Remove ilove endpoint ([#19919](https://github.com/netdata/netdata/issues/19919))
- Do not expose web server filenames ([#19925](https://github.com/netdata/netdata/issues/19925))
- Fix TOCTOU race in daemon status file handling. ([#19924](https://github.com/netdata/netdata/issues/19924))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.7.1 to 9.7.3 in /src/go ([#19926](https://github.com/netdata/netdata/issues/19926))
- Fix compile without dbengine ([#19930](https://github.com/netdata/netdata/issues/19930))
- Fix max_page_length calculation for GORILLA_32BIT page type ([#19932](https://github.com/netdata/netdata/issues/19932))
- Initial implementation of libbacktrace ([#19910](https://github.com/netdata/netdata/issues/19910))
- Metadata event loop code cleanup ([#19929](https://github.com/netdata/netdata/issues/19929))
- Fix path to copy drop-in crontab from ([#19935](https://github.com/netdata/netdata/issues/19935))
- Status file v21 ([#19928](https://github.com/netdata/netdata/issues/19928))
- Status file 21b ([#19937](https://github.com/netdata/netdata/issues/19937))
- Fix logic for libbacktrace enablement in CMakeLists,txt ([#19936](https://github.com/netdata/netdata/issues/19936))
- Build(deps): bump github.com/go-sql-driver/mysql from 1.9.0 to 1.9.1 in /src/go ([#19943](https://github.com/netdata/netdata/issues/19943))
- Build(deps): bump github.com/miekg/dns from 1.1.63 to 1.1.64 in /src/go ([#19945](https://github.com/netdata/netdata/issues/19945))
- Build(deps): bump github.com/docker/docker from 28.0.1+incompatible to 28.0.2+incompatible in /src/go ([#19942](https://github.com/netdata/netdata/issues/19942))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.2 to 5.7.3 in /src/go ([#19944](https://github.com/netdata/netdata/issues/19944))
- Don't build libunwind in static builds when it's not needed. ([#19939](https://github.com/netdata/netdata/issues/19939))
- Detect low ram conditions more aggresively ([#19938](https://github.com/netdata/netdata/issues/19938))
- Build(deps): bump github.com/DataDog/datadog-agent/pkg/networkdevice/profile from 0.65.0-devel.0.20250317105920-ce55f088ab29 to 0.66.0-devel in /src/go ([#19941](https://github.com/netdata/netdata/issues/19941))
- Set default CMake build type to include debug info. ([#19946](https://github.com/netdata/netdata/issues/19946))
- Disable generation of debuginfo packages for DEB distros. ([#19948](https://github.com/netdata/netdata/issues/19948))
- Daemon status 22 ([#19953](https://github.com/netdata/netdata/issues/19953))
- Enable interface to release sqlite memory ([#19952](https://github.com/netdata/netdata/issues/19952))
- Fix claiming on startup ([#19954](https://github.com/netdata/netdata/issues/19954))
- Fix rrdcalc_unlink_from_rrdset() ([#19956](https://github.com/netdata/netdata/issues/19956))
- Improve event loop thread creation ([#19951](https://github.com/netdata/netdata/issues/19951))
- Status file 22b ([#19957](https://github.com/netdata/netdata/issues/19957))
- Use UPDATE_DISCONNECTED mode for libbacktrace. ([#19958](https://github.com/netdata/netdata/issues/19958))
- Large-scale cleanup of static build infrastructure. ([#19852](https://github.com/netdata/netdata/issues/19852))
- Build(deps): bump actions/upload-artifact from 4.6.1 to 4.6.2 ([#19949](https://github.com/netdata/netdata/issues/19949))
- Fix undefined ([#19960](https://github.com/netdata/netdata/issues/19960))
- Daemon status 22c ([#19959](https://github.com/netdata/netdata/issues/19959))
- Don’t skip building Go code on static builds. ([#19961](https://github.com/netdata/netdata/issues/19961))
- Build(deps): bump github.com/docker/docker from 28.0.2+incompatible to 28.0.4+incompatible in /src/go ([#19967](https://github.com/netdata/netdata/issues/19967))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.3 to 5.7.4 in /src/go ([#19968](https://github.com/netdata/netdata/issues/19968))
- Update SCIM docs with Groups support ([#19969](https://github.com/netdata/netdata/issues/19969))
- Regenerate integrations docs ([#19970](https://github.com/netdata/netdata/issues/19970))
- Fix crash in variable_lookup_add_result_with_score() ([#19972](https://github.com/netdata/netdata/issues/19972))
- Doc Linux improved order in kickstart ([#19975](https://github.com/netdata/netdata/issues/19975))
- Set max datafile size to 1GiB ([#19977](https://github.com/netdata/netdata/issues/19977))
- Improve ACLK sync shutdown process ([#19966](https://github.com/netdata/netdata/issues/19966))
- Fix random crash during shutdown ([#19978](https://github.com/netdata/netdata/issues/19978))
- Release memory when calculating metric correlations ([#19979](https://github.com/netdata/netdata/issues/19979))
- Installation section Improvements ([#19981](https://github.com/netdata/netdata/issues/19981))
- Set sqlite max soft and hard heap limit ([#19963](https://github.com/netdata/netdata/issues/19963))
- Revert "fix undefined" ([#19982](https://github.com/netdata/netdata/issues/19982))
- Improvement(health/dyncfg): add widget to load available contexts ([#19904](https://github.com/netdata/netdata/issues/19904))
- Keep errno in out of memory situations ([#19984](https://github.com/netdata/netdata/issues/19984))
- Do not allocate or access zero sized arrays ([#19983](https://github.com/netdata/netdata/issues/19983))
- Improve agent shutdown ([#19980](https://github.com/netdata/netdata/issues/19980))
- Perflib: do not dereference null pointer ([#19985](https://github.com/netdata/netdata/issues/19985))
- Fix MSI installer ([#19962](https://github.com/netdata/netdata/issues/19962))
- IIS Application Pool (Windows.plugin) ([#19950](https://github.com/netdata/netdata/issues/19950))
- Regenerate integrations docs ([#19986](https://github.com/netdata/netdata/issues/19986))
- Installation + docker, improvements ([#19987](https://github.com/netdata/netdata/issues/19987))
- Ebpf.plugin: rework memory ([#19844](https://github.com/netdata/netdata/issues/19844))
- Regenerate integrations docs ([#19988](https://github.com/netdata/netdata/issues/19988))
- Fast restart on busy parents ([#19964](https://github.com/netdata/netdata/issues/19964))
- Update synology.md ([#19989](https://github.com/netdata/netdata/issues/19989))
- Added worker last job id to status file ([#19992](https://github.com/netdata/netdata/issues/19992))
- Docs: improve Synology NAS installation documentation clarity ([#19993](https://github.com/netdata/netdata/issues/19993))
- Add kanelatechnical to CODEOWNERS ([#19994](https://github.com/netdata/netdata/issues/19994))
- Improve shutdown and datafile rotation ([#19991](https://github.com/netdata/netdata/issues/19991))
- Status file 24 ([#19996](https://github.com/netdata/netdata/issues/19996))
- Detect more CI ([#19999](https://github.com/netdata/netdata/issues/19999))
- Update synology.md ([#20001](https://github.com/netdata/netdata/issues/20001))
- Use v4 UUIDs ([#20002](https://github.com/netdata/netdata/issues/20002))
- Deployment Guides Improved ([#20004](https://github.com/netdata/netdata/issues/20004))
- Fix(go.d/megacli): handle BBU hardware component is not present ([#20008](https://github.com/netdata/netdata/issues/20008))
- Fix crashes No 3 ([#20007](https://github.com/netdata/netdata/issues/20007))
- Daemon status 24c ([#20003](https://github.com/netdata/netdata/issues/20003))
- Update synology.md ([#20010](https://github.com/netdata/netdata/issues/20010))
- Added agent-events backend ([#20012](https://github.com/netdata/netdata/issues/20012))
- Agent-events: add deduplicating web server ([#20014](https://github.com/netdata/netdata/issues/20014))
- Minor changes when handling systemd integration. ([#20006](https://github.com/netdata/netdata/issues/20006))
- Daemon status 24d ([#20011](https://github.com/netdata/netdata/issues/20011))
- Validate journal file headers to prevent invalid memory access ([#20013](https://github.com/netdata/netdata/issues/20013))
- Blacklist leaked machine guids ([#20016](https://github.com/netdata/netdata/issues/20016))
- Properly clean up install paths after runtime checks in static builds. ([#20017](https://github.com/netdata/netdata/issues/20017))
- Additional checks then creating a v2 journal file ([#20018](https://github.com/netdata/netdata/issues/20018))
- Windows installer + ML (all) improved ([#20021](https://github.com/netdata/netdata/issues/20021))
- On prem files moved to their own repo ([#20023](https://github.com/netdata/netdata/issues/20023))
- Series of NFCs to make the code more maintainable. ([#20022](https://github.com/netdata/netdata/issues/20022))
- Daemon status 25 ([#20026](https://github.com/netdata/netdata/issues/20026))
- Kickstart.sh: add missing option --offline-install-source to USAGE ([#20025](https://github.com/netdata/netdata/issues/20025))
- Logs enhancements ([#20027](https://github.com/netdata/netdata/issues/20027))
- More completely disable our own telemetry in CI. ([#20009](https://github.com/netdata/netdata/issues/20009))
- Fix crash ([#20028](https://github.com/netdata/netdata/issues/20028))
- Trim-all ([#20029](https://github.com/netdata/netdata/issues/20029))
- Improvement(go.d): add `_hostname` label for virtual nodes ([#20030](https://github.com/netdata/netdata/issues/20030))
- Improve estimated disk space usage for data file rotation ([#20019](https://github.com/netdata/netdata/issues/20019))
- Improve kickstart so it can add the netdata user/group on Synology DSM ([#20024](https://github.com/netdata/netdata/issues/20024))
- Check for host timer validity in ACLK synchronization ([#20031](https://github.com/netdata/netdata/issues/20031))
- Chore(otel/journaldexporter): convert logs to journald format ([#20033](https://github.com/netdata/netdata/issues/20033))
- Chore(otel/journaldexporter): add trusted journald fields ([#20038](https://github.com/netdata/netdata/issues/20038))
- Daemon status 26 - dmi strings ([#20037](https://github.com/netdata/netdata/issues/20037))
- Update netdata-updater-daily.in ([#20039](https://github.com/netdata/netdata/issues/20039))
- Fix ACLK synchronization fatal on shutdown ([#20034](https://github.com/netdata/netdata/issues/20034))
- Handle journal_v2 file creation failure due to OOM ([#19965](https://github.com/netdata/netdata/issues/19965))
- Trace crashes No 4 ([#20043](https://github.com/netdata/netdata/issues/20043))
- Daemon status 26b ([#20041](https://github.com/netdata/netdata/issues/20041))
- Daemon status 26c ([#20044](https://github.com/netdata/netdata/issues/20044))
- Fix(go.d/megacli): handle Adapters with no drives ([#20046](https://github.com/netdata/netdata/issues/20046))
- Daemon status 26d ([#20047](https://github.com/netdata/netdata/issues/20047))
- Added checksum to detect corruption in netdev rename tasks ([#20048](https://github.com/netdata/netdata/issues/20048))
- Fix releasing statements after databases are closed ([#20045](https://github.com/netdata/netdata/issues/20045))
- Fix cgroup netdev renames ([#20050](https://github.com/netdata/netdata/issues/20050))
- Daemon status 26e ([#20051](https://github.com/netdata/netdata/issues/20051))
- Remove unnecessary parameters for oidc configuration ([#20053](https://github.com/netdata/netdata/issues/20053))
- Regenerate integrations docs ([#20054](https://github.com/netdata/netdata/issues/20054))
- Nested code block in doc ([#20056](https://github.com/netdata/netdata/issues/20056))
- Daemon status 27 ([#20058](https://github.com/netdata/netdata/issues/20058))
- Observability cent points improved ([#20052](https://github.com/netdata/netdata/issues/20052))
- Fix memory leaks ([#20062](https://github.com/netdata/netdata/issues/20062))
- Improve agent-events web server ([#20063](https://github.com/netdata/netdata/issues/20063))
- Agent-events: fix metric names ([#20064](https://github.com/netdata/netdata/issues/20064))
- Agent-events: fix metrics ([#20065](https://github.com/netdata/netdata/issues/20065))
- Ci: remove codeql-action build-mode none ([#20066](https://github.com/netdata/netdata/issues/20066))
- Agent-events: Consolidate metrics into a single labeled counter ([#20067](https://github.com/netdata/netdata/issues/20067))
- Agent-events: fix more metrics ([#20068](https://github.com/netdata/netdata/issues/20068))
- Fix(go.d/prometheus): don't use "ratio" as unit ([#20069](https://github.com/netdata/netdata/issues/20069))
- Update nodes-ephemerality.md ([#20073](https://github.com/netdata/netdata/issues/20073))
- Build(deps): bump github.com/fsnotify/fsnotify from 1.8.0 to 1.9.0 in /src/go ([#20070](https://github.com/netdata/netdata/issues/20070))
- Build(deps): bump golang.org/x/text from 0.23.0 to 0.24.0 in /src/go ([#20071](https://github.com/netdata/netdata/issues/20071))
- Build(deps): bump github.com/miekg/dns from 1.1.64 to 1.1.65 in /src/go ([#20072](https://github.com/netdata/netdata/issues/20072))
- Build(deps): bump golang.org/x/net from 0.37.0 to 0.38.0 in /src/go ([#20000](https://github.com/netdata/netdata/issues/20000))
- Agent events No 7 ([#20074](https://github.com/netdata/netdata/issues/20074))
- Update README.md
- Improve ephemerality docs, adding `remove-stale-node` ([#20057](https://github.com/netdata/netdata/issues/20057))
- Add Docker tags for the last few nightly builds. ([#19734](https://github.com/netdata/netdata/issues/19734))
- Improve jv2 load ([#19995](https://github.com/netdata/netdata/issues/19995))
- Cleanup during shutdown ([#20078](https://github.com/netdata/netdata/issues/20078))
- Fix crash during shutdown when there are pending messages to cloud ([#20080](https://github.com/netdata/netdata/issues/20080))
- Do not try to index jv2 files during shutdown ([#20079](https://github.com/netdata/netdata/issues/20079))
- Daemon status 27b ([#20076](https://github.com/netdata/netdata/issues/20076))
- ACLK synchronization improvements ([#20077](https://github.com/netdata/netdata/issues/20077))
- Address Chart name (Windows Hyper V) ([#20060](https://github.com/netdata/netdata/issues/20060))
- Fix memory allocation for timer callback data when cancelling a timer ([#20084](https://github.com/netdata/netdata/issues/20084))
- Skip non-native builds in CI on PRs in most cases. ([#20055](https://github.com/netdata/netdata/issues/20055))
- Fix inverted logic for skipping non-native CI jobs on PRs. ([#20087](https://github.com/netdata/netdata/issues/20087))
- Alerts and Notifications ([#20085](https://github.com/netdata/netdata/issues/20085))
- Update src/aclk/aclk-schemas to latest version. ([#19940](https://github.com/netdata/netdata/issues/19940))
- Fix typo in .github/scripts/gen-docker-tags.py ([#20089](https://github.com/netdata/netdata/issues/20089))
- Windows Services Monitoring ([#19990](https://github.com/netdata/netdata/issues/19990))
- Regenerate integrations docs ([#20091](https://github.com/netdata/netdata/issues/20091))
- Daemon status 27c ([#20088](https://github.com/netdata/netdata/issues/20088))
- Protected access against SIGBUS/SIGSEGV for journal v2 files ([#20092](https://github.com/netdata/netdata/issues/20092))
- Document switching from a native package to a static build ([#20075](https://github.com/netdata/netdata/issues/20075))
- SNMP Collector, use custom YAML files for auto single metrics ([#20020](https://github.com/netdata/netdata/issues/20020))
- Daemon status 27d ([#20096](https://github.com/netdata/netdata/issues/20096))
- Fix ACLK Backoff Timeout Logic ([#20095](https://github.com/netdata/netdata/issues/20095))
- Release memory after journalfile creation ([#20094](https://github.com/netdata/netdata/issues/20094))
- Protection access improvements 1 ([#20093](https://github.com/netdata/netdata/issues/20093))
- Add the number of cpu cores to the status file ([#20101](https://github.com/netdata/netdata/issues/20101))
- Fix Windows registry name crashes ([#20097](https://github.com/netdata/netdata/issues/20097))
- Improve journal file access error logging protect retention recalculation ([#20098](https://github.com/netdata/netdata/issues/20098))
- Properly integrate dlib into our build system. ([#20086](https://github.com/netdata/netdata/issues/20086))
- Daemon status 27f ([#20104](https://github.com/netdata/netdata/issues/20104))
- Further improve ACLK synchronization shutdown ([#20105](https://github.com/netdata/netdata/issues/20105))
- Build(deps): bump github.com/prometheus-community/pro-bing from 0.6.1 to 0.7.0 in /src/go ([#20107](https://github.com/netdata/netdata/issues/20107))
- Build(deps): bump github.com/go-sql-driver/mysql from 1.9.1 to 1.9.2 in /src/go ([#20109](https://github.com/netdata/netdata/issues/20109))
- Build(deps): bump golang.org/x/net from 0.38.0 to 0.39.0 in /src/go ([#20108](https://github.com/netdata/netdata/issues/20108))
- Docs: clarify static build transition process for EOL platforms ([#20110](https://github.com/netdata/netdata/issues/20110))
- Fix completion marking in ACLK cancel node update timer logic ([#20111](https://github.com/netdata/netdata/issues/20111))
- Netdatacli remove/mark stale, swap order in help output ([#20113](https://github.com/netdata/netdata/issues/20113))
- Fix memory leaks ([#20116](https://github.com/netdata/netdata/issues/20116))
- Feat(system-info): improve Windows OS detection and categorization ([#20117](https://github.com/netdata/netdata/issues/20117))
- Dump Netdata buildinfo during CI. ([#19918](https://github.com/netdata/netdata/issues/19918))
- Chore(otel/journaldexporter): add socket/remote clients ([#20121](https://github.com/netdata/netdata/issues/20121))

## [2.3.0] - 2025-03-19

### Merged Pull Requests:

- Pulse stream-parents ([#19445](https://github.com/netdata/netdata/issues/19445))
- Use aral in ACLK ([#19459](https://github.com/netdata/netdata/issues/19459))
- Child should be online before initializing health ([#19463](https://github.com/netdata/netdata/issues/19463))
- Streaming nodes accounting ([#19466](https://github.com/netdata/netdata/issues/19466))
- Fix crash when cleaning up virtual nodes ([#19467](https://github.com/netdata/netdata/issues/19467))
- Don’t fail fast on static builds and Docker builds. ([#19465](https://github.com/netdata/netdata/issues/19465))
- Unregister node from the agent to run in a worker thread ([#19471](https://github.com/netdata/netdata/issues/19471))
- Optimized rrdhost_status ([#19472](https://github.com/netdata/netdata/issues/19472))
- Build(deps): bump github.com/prometheus-community/pro-bing from 0.5.0 to 0.6.0 in /src/go ([#19477](https://github.com/netdata/netdata/issues/19477))
- Build(deps): bump github.com/miekg/dns from 1.1.62 to 1.1.63 in /src/go ([#19475](https://github.com/netdata/netdata/issues/19475))
- Build(deps): bump github.com/docker/docker from 27.5.0+incompatible to 27.5.1+incompatible in /src/go ([#19476](https://github.com/netdata/netdata/issues/19476))
- Use QEMU from the runner environment instead of an external copy. ([#19468](https://github.com/netdata/netdata/issues/19468))
- Chore(go.d/ping): set privileged by default for dyncfg jobs ([#19480](https://github.com/netdata/netdata/issues/19480))
- Regenerate integrations docs ([#19481](https://github.com/netdata/netdata/issues/19481))
- Add system-info columns to streaming function ([#19482](https://github.com/netdata/netdata/issues/19482))
- Coverity fixes ([#19484](https://github.com/netdata/netdata/issues/19484))
- Add agent name and version in streaming function ([#19485](https://github.com/netdata/netdata/issues/19485))
- Improve alert transition processing ([#19487](https://github.com/netdata/netdata/issues/19487))
- LTO Benchmark ([#19488](https://github.com/netdata/netdata/issues/19488))
- Proc.plugin: remove traces of /proc/spl/kstat/zfs/pool/state ([#19491](https://github.com/netdata/netdata/issues/19491))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.8.0 to 4.8.1 in /src/go ([#19493](https://github.com/netdata/netdata/issues/19493))
- Further improve alert processing ([#19489](https://github.com/netdata/netdata/issues/19489))
- Proc.plugin: add `ifb4*` to excluded interface name patterns ([#19494](https://github.com/netdata/netdata/issues/19494))
- Fix absolute injection ([#19496](https://github.com/netdata/netdata/issues/19496))
- Fix absolute injection again ([#19497](https://github.com/netdata/netdata/issues/19497))
- Create impact-on-resources.md ([#19499](https://github.com/netdata/netdata/issues/19499))
- Add worker for alert queue processing ([#19498](https://github.com/netdata/netdata/issues/19498))
- Fix up libsensors vendoring. ([#19369](https://github.com/netdata/netdata/issues/19369))
- Improve metadata cleanup ([#19479](https://github.com/netdata/netdata/issues/19479))
- Docs(go.d/postgres): add config example with unix socket + custom port ([#19501](https://github.com/netdata/netdata/issues/19501))
- Regenerate integrations docs ([#19502](https://github.com/netdata/netdata/issues/19502))
- Build(deps): bump github.com/vmware/govmomi from 0.47.0 to 0.48.0 in /src/go ([#19504](https://github.com/netdata/netdata/issues/19504))
- Fix(go.d/nvme): support v2.11 output format ([#19505](https://github.com/netdata/netdata/issues/19505))
- ACLK: allow encoded proxy username and password to work ([#19508](https://github.com/netdata/netdata/issues/19508))
- Update buildinfo  ([#19506](https://github.com/netdata/netdata/issues/19506))
- Make handling of cross-platform emulation for static builds smarter. ([#19470](https://github.com/netdata/netdata/issues/19470))
- Fix alert transition ([#19507](https://github.com/netdata/netdata/issues/19507))
- Max data file size ([#19495](https://github.com/netdata/netdata/issues/19495))
- Invert order of checks in pgd_append_point(). ([#19515](https://github.com/netdata/netdata/issues/19515))
- Compile time and runtime check of required compiler flags ([#19513](https://github.com/netdata/netdata/issues/19513))
- Link the ebpf plugin against libbpf directly instead of through libnetdata. ([#19514](https://github.com/netdata/netdata/issues/19514))
- Chore(go.d/nvme): fix :dog: warning ([#19510](https://github.com/netdata/netdata/issues/19510))
- Docs(go.d/httpcheck): add alerts to metadata ([#19516](https://github.com/netdata/netdata/issues/19516))
- Regenerate integrations docs ([#19517](https://github.com/netdata/netdata/issues/19517))
- Improve ACLK query processing ([#19518](https://github.com/netdata/netdata/issues/19518))
- Ci: increase static build timeout 180->300m ([#19519](https://github.com/netdata/netdata/issues/19519))
- Update README.md
- Chore(packaging): remove old dashboard ([#19523](https://github.com/netdata/netdata/issues/19523))
- Fix MSSQL Instance ([#19527](https://github.com/netdata/netdata/issues/19527))
- Active Directory Metrics (Windows.plugin) ([#19461](https://github.com/netdata/netdata/issues/19461))
- Netdata.spec/plugin-go: remove dependency for lm_sensors ([#19511](https://github.com/netdata/netdata/issues/19511))
- Chore(go.d/snmp): enable create_vnode by default ([#19529](https://github.com/netdata/netdata/issues/19529))
- Ci: bump static build timeout to 6hr ([#19528](https://github.com/netdata/netdata/issues/19528))
- Regenerate integrations docs ([#19530](https://github.com/netdata/netdata/issues/19530))
- Docs(web/gui): remove info about old dashboard from readme ([#19531](https://github.com/netdata/netdata/issues/19531))
- Fix heap use after free ([#19532](https://github.com/netdata/netdata/issues/19532))
- Inline functions related to metrics ingestion ([#19524](https://github.com/netdata/netdata/issues/19524))
- Fix coverity issue ([#19535](https://github.com/netdata/netdata/issues/19535))
- Fix contexts stay not-live when children reconnect ([#19536](https://github.com/netdata/netdata/issues/19536))
- Allow dbengine to read at offsets above 4GiB ([#19538](https://github.com/netdata/netdata/issues/19538))
- Allow dbengine to read at offsets above 4GiB - again ([#19539](https://github.com/netdata/netdata/issues/19539))
- Format PGDs on fatal() ([#19521](https://github.com/netdata/netdata/issues/19521))
- Bundle cmake cache. ([#19509](https://github.com/netdata/netdata/issues/19509))
- SMSEagle integration ([#19520](https://github.com/netdata/netdata/issues/19520))
- Regenerate integrations docs ([#19541](https://github.com/netdata/netdata/issues/19541))
- Add NetFramework Metrics (part II) ([#19008](https://github.com/netdata/netdata/issues/19008))
- Modify eBPF.plugin integration (Part I) ([#19219](https://github.com/netdata/netdata/issues/19219))
- Use database/rrd.h instead of daemon/common.h ([#19540](https://github.com/netdata/netdata/issues/19540))
- Virtual hosts now get hops = 1 ([#19546](https://github.com/netdata/netdata/issues/19546))
- Chore: remove old dashboard leftovers ([#19545](https://github.com/netdata/netdata/issues/19545))
- Actually handle the `-fexceptions` requirement correctly in our build system. ([#19534](https://github.com/netdata/netdata/issues/19534))
- Add LTO support in CMake build system. ([#17027](https://github.com/netdata/netdata/issues/17027))
- Chore(windows.plugin): format perflib ad and netframework ([#19544](https://github.com/netdata/netdata/issues/19544))
- Add CLR Remoting metadata ([#19203](https://github.com/netdata/netdata/issues/19203))
- Regenerate integrations docs ([#19548](https://github.com/netdata/netdata/issues/19548))
- Active Directory Certification Service (windows.plugin) ([#19492](https://github.com/netdata/netdata/issues/19492))
- Fix cloud connect after claim ([#19547](https://github.com/netdata/netdata/issues/19547))
- Fix(go.d/mysql): fix typo in test name ([#19550](https://github.com/netdata/netdata/issues/19550))
- Fix(go.d/mysql): don't collect global variables on every iteration ([#19549](https://github.com/netdata/netdata/issues/19549))
- Format ebpf ([#19553](https://github.com/netdata/netdata/issues/19553))
- Rename appconfig to inicfg and drop config_* function-like macros. ([#19552](https://github.com/netdata/netdata/issues/19552))
- Format Windows.plugin ([#19554](https://github.com/netdata/netdata/issues/19554))
- Docs(start-stop-restart): fix restart typo ([#19555](https://github.com/netdata/netdata/issues/19555))
- MSSQL Multiple Instances (windows.plugin) ([#19559](https://github.com/netdata/netdata/issues/19559))
- Build(deps): bump github.com/lmittmann/tint from 1.0.6 to 1.0.7 in /src/go ([#19558](https://github.com/netdata/netdata/issues/19558))
- Metadata (AD and ADCS), and small fixes ([#19557](https://github.com/netdata/netdata/issues/19557))
- Regenerate integrations docs ([#19561](https://github.com/netdata/netdata/issues/19561))
- Cgroups.plugin: fixes to cgroup path validation ([#19490](https://github.com/netdata/netdata/issues/19490))
- Feat(go.d/dnsquery): support system DNS servers from /etc/resolv.conf ([#19562](https://github.com/netdata/netdata/issues/19562))
- Regenerate integrations docs ([#19563](https://github.com/netdata/netdata/issues/19563))
- Start using new GitHub hosted ARM runners for CI when appropriate. ([#19427](https://github.com/netdata/netdata/issues/19427))
- Add a new agent status when connecting to the cloud ([#19564](https://github.com/netdata/netdata/issues/19564))
- Build(deps): bump github.com/prometheus-community/pro-bing from 0.6.0 to 0.6.1 in /src/go ([#19567](https://github.com/netdata/netdata/issues/19567))
- Fix memory leak ([#19569](https://github.com/netdata/netdata/issues/19569))
- Code cleanup on ACLK messages ([#19566](https://github.com/netdata/netdata/issues/19566))
- Fix(go.d): clean up charts for stopped and removed jobs ([#19573](https://github.com/netdata/netdata/issues/19573))
- Inline dbengine query critical path ([#19537](https://github.com/netdata/netdata/issues/19537))
- Improve data write ([#19525](https://github.com/netdata/netdata/issues/19525))
- Fix(go.d/nvme): add missing "/dev/" prefix to device path for v2.11 ([#19577](https://github.com/netdata/netdata/issues/19577))
- Fix static build conditions to run on release and nightly builds. ([#19579](https://github.com/netdata/netdata/issues/19579))
- Build(deps): update go toolchain to v1.23.6 ([#19578](https://github.com/netdata/netdata/issues/19578))
- Fix(go.d/apache): make ?auto param check non-fatal ([#19580](https://github.com/netdata/netdata/issues/19580))
- Generate protobuf source files in build dir. ([#19576](https://github.com/netdata/netdata/issues/19576))
- Format missing file (eBPF.plugin) ([#19582](https://github.com/netdata/netdata/issues/19582))
- Protection against extreme cardinality ([#19486](https://github.com/netdata/netdata/issues/19486))
- Improvement(go.d/zookeeper): add more metrics ([#19584](https://github.com/netdata/netdata/issues/19584))
- Regenerate integrations docs ([#19585](https://github.com/netdata/netdata/issues/19585))
- Docs(go.d/zookeeper): fix ZooKeeper server scope name ([#19587](https://github.com/netdata/netdata/issues/19587))
- Regenerate integrations docs ([#19588](https://github.com/netdata/netdata/issues/19588))
- Docs(health): clarify "special user of the conf operator" ([#19589](https://github.com/netdata/netdata/issues/19589))
- Docs(health): clarify "special user of the cond operator" p2 ([#19590](https://github.com/netdata/netdata/issues/19590))
- Switch from x86 to ARM build host for POWER8+ builds. ([#19575](https://github.com/netdata/netdata/issues/19575))
- Add agent version during ACLK handshake ([#19583](https://github.com/netdata/netdata/issues/19583))
- Fix incomplete implementation of journal watcher ([#19592](https://github.com/netdata/netdata/issues/19592))
- Add check for available active instances when checking for extreme cardinality ([#19594](https://github.com/netdata/netdata/issues/19594))
- Free resources where writing datafile extents ([#19593](https://github.com/netdata/netdata/issues/19593))
- Build(deps): bump github.com/gohugoio/hashstructure from 0.3.0 to 0.5.0 in /src/go ([#19598](https://github.com/netdata/netdata/issues/19598))
- Build(deps): bump golang.org/x/text from 0.21.0 to 0.22.0 in /src/go ([#19597](https://github.com/netdata/netdata/issues/19597))
- Dequeue from hub before deleting contexts ([#19599](https://github.com/netdata/netdata/issues/19599))
- Update manage-notification-methods.md ([#19601](https://github.com/netdata/netdata/issues/19601))
- Streaming alerts ([#19586](https://github.com/netdata/netdata/issues/19586))
- Make remove-stale-node remove also ephemeral nodes ([#19602](https://github.com/netdata/netdata/issues/19602))
- Cleanup hosts - leftover code ([#19603](https://github.com/netdata/netdata/issues/19603))
- Docs: reword nodes-ephemerality for clarity ([#19604](https://github.com/netdata/netdata/issues/19604))
- Add interpolation to median and percentile ([#19606](https://github.com/netdata/netdata/issues/19606))
- Disable LTO for openSUSE package builds. ([#19607](https://github.com/netdata/netdata/issues/19607))
- Close database if we encounter error during startup ([#19600](https://github.com/netdata/netdata/issues/19600))
- Cleanup code that writes extents to the database ([#19596](https://github.com/netdata/netdata/issues/19596))
- Silence new alerts ([#19610](https://github.com/netdata/netdata/issues/19610))
- Allow indirect access when agent is claimed, but offline (indirect cloud connectivity) ([#19611](https://github.com/netdata/netdata/issues/19611))
- Do not register removed node on agent restart ([#19609](https://github.com/netdata/netdata/issues/19609))
- Chore: remove fluentbit.log from Dockerfile ([#19613](https://github.com/netdata/netdata/issues/19613))
- Improvement(health): clarify clickhouse_replicated_readonly_tables info ([#19616](https://github.com/netdata/netdata/issues/19616))
- Add sentry fatal message breadcrumb. ([#19608](https://github.com/netdata/netdata/issues/19608))
- Fix(go.d/mysql): handle Cpu_time in microseconds in v11.4.5+ ([#19618](https://github.com/netdata/netdata/issues/19618))
- Fix: correct typo in NetdataCompilerFlags ([#19614](https://github.com/netdata/netdata/issues/19614))
- Switch to Ubuntu 22.04 runner images for CI build jobs. ([#19619](https://github.com/netdata/netdata/issues/19619))
- Feat(health): add system_reboot_detection alarm ([#19624](https://github.com/netdata/netdata/issues/19624))
- Build(deps): bump github.com/vmware/govmomi from 0.48.0 to 0.48.1 in /src/go ([#19625](https://github.com/netdata/netdata/issues/19625))
- Build(deps): bump golang.org/x/net from 0.34.0 to 0.35.0 in /src/go ([#19626](https://github.com/netdata/netdata/issues/19626))
- HyperV Adjusts (windows.plugin) ([#19623](https://github.com/netdata/netdata/issues/19623))
- Do not send sentry reports on rrd_init() failures ([#19628](https://github.com/netdata/netdata/issues/19628))
- Detect the system ca bundle at runtime ([#19622](https://github.com/netdata/netdata/issues/19622))
- Revert "HyperV Adjusts (windows.plugin)" ([#19630](https://github.com/netdata/netdata/issues/19630))
- More perflib error checking ([#19631](https://github.com/netdata/netdata/issues/19631))
- Fix windows logs ([#19632](https://github.com/netdata/netdata/issues/19632))
- Docs(exporting): remove influxdb (via graphite) exporter ([#19633](https://github.com/netdata/netdata/issues/19633))
- Regenerate integrations docs ([#19634](https://github.com/netdata/netdata/issues/19634))
- Docs(exporting): clarify graphite exporters ([#19635](https://github.com/netdata/netdata/issues/19635))
- Docs: add missing prop to graphite meta ([#19637](https://github.com/netdata/netdata/issues/19637))
- Regenerate integrations docs ([#19636](https://github.com/netdata/netdata/issues/19636))
- Revert "fix windows logs" ([#19639](https://github.com/netdata/netdata/issues/19639))
- Fix windows logs 2 - do not renumber - append fields ([#19640](https://github.com/netdata/netdata/issues/19640))
- Ci: fix win build ([#19642](https://github.com/netdata/netdata/issues/19642))
- Add Group=netdata to systemd unit file ([#19638](https://github.com/netdata/netdata/issues/19638))
- Docs: move /run/dbus mount to Docker recommended way ([#19645](https://github.com/netdata/netdata/issues/19645))
- Make onewayalloc fallback to malloc ([#19646](https://github.com/netdata/netdata/issues/19646))
- Build(deps): bump k8s.io/client-go from 0.32.1 to 0.32.2 in /src/go ([#19652](https://github.com/netdata/netdata/issues/19652))
- Add agent timezones as host labels ([#19656](https://github.com/netdata/netdata/issues/19656))
- Improvement(go.d/k8sstate): collect deployments ([#19657](https://github.com/netdata/netdata/issues/19657))
- Regenerate integrations docs ([#19658](https://github.com/netdata/netdata/issues/19658))
- Speed up aral when a single item is allocated and freed repeateadly ([#19660](https://github.com/netdata/netdata/issues/19660))
- Avoid dbengine event loop starvation by running uv_run periodically ([#19661](https://github.com/netdata/netdata/issues/19661))
- Improvement(go.d/k8sstate): add deployment conditions ([#19662](https://github.com/netdata/netdata/issues/19662))
- Regenerate integrations docs ([#19663](https://github.com/netdata/netdata/issues/19663))
- Add k8s_state_deployment_condition_available alert ([#19664](https://github.com/netdata/netdata/issues/19664))
- Chore(go.d/sensors): disable by default ([#19667](https://github.com/netdata/netdata/issues/19667))
- Improvement(go.d dyncfg): add user to source ([#19666](https://github.com/netdata/netdata/issues/19666))
- Chore: remove lock files from go.d/python.d ([#19668](https://github.com/netdata/netdata/issues/19668))
- Fix(go.d/k8sstate): correct deployment conditions ([#19671](https://github.com/netdata/netdata/issues/19671))
- Improvement(go.d dyncfg): log collector dyncfg actions ([#19672](https://github.com/netdata/netdata/issues/19672))
- Chore: remove netdata_configured_lock_dir ([#19669](https://github.com/netdata/netdata/issues/19669))
- Fix(go.d dyncfg): don't overwrite source ([#19673](https://github.com/netdata/netdata/issues/19673))
- Test(go.d dyncfg): fix tests ([#19676](https://github.com/netdata/netdata/issues/19676))
- Dyncfg users actions log ([#19674](https://github.com/netdata/netdata/issues/19674))
- Fix native package installation on RHEL. ([#19643](https://github.com/netdata/netdata/issues/19643))
- Initial setup of custom OpenTelemetry Collector distribution ([#19678](https://github.com/netdata/netdata/issues/19678))
- Build(deps): bump github.com/go-sql-driver/mysql from 1.8.1 to 1.9.0 in /src/go ([#19679](https://github.com/netdata/netdata/issues/19679))
- Build: change go.mod version to 1.23.6 ([#19680](https://github.com/netdata/netdata/issues/19680))
- Fix freebsd compilation ([#19677](https://github.com/netdata/netdata/issues/19677))
- Build: change go.mod version to 1.23.4 to fix win ci builds ([#19681](https://github.com/netdata/netdata/issues/19681))
- Fix(go.d/mysql): handle Cpu_time in microseconds in v10.11.11+ ([#19683](https://github.com/netdata/netdata/issues/19683))
- Improve dyncfg src type anon message ([#19684](https://github.com/netdata/netdata/issues/19684))
- Allow parsing empty json arrays and objects ([#19685](https://github.com/netdata/netdata/issues/19685))
- Switch back to x86 hosts for POWER8+ builds. ([#19686](https://github.com/netdata/netdata/issues/19686))
- Chore(go.d/mysql): InnodbOSLogIO in MariaDB >= 10.8 ([#19687](https://github.com/netdata/netdata/issues/19687))
- Chore(go.d/pkg/iprange): add iterator ([#19688](https://github.com/netdata/netdata/issues/19688))
- Load health config before creating localhost ([#19689](https://github.com/netdata/netdata/issues/19689))
- Enable libunwind in native packages and Docker images. ([#19452](https://github.com/netdata/netdata/issues/19452))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.7.0 to 9.7.1 in /src/go ([#19693](https://github.com/netdata/netdata/issues/19693))
- Build(deps): bump github.com/docker/docker from 27.5.1+incompatible to 28.0.0+incompatible in /src/go ([#19692](https://github.com/netdata/netdata/issues/19692))
- Change the moto and the description of netdata ([#19696](https://github.com/netdata/netdata/issues/19696))
- Build(deps): bump github.com/sijms/go-ora/v2 from 2.8.23 to 2.8.24 in /src/go ([#19698](https://github.com/netdata/netdata/issues/19698))
- Build(deps): bump actions/upload-artifact from 4.6.0 to 4.6.1 ([#19697](https://github.com/netdata/netdata/issues/19697))
- Build(deps): update go.d packages ([#19700](https://github.com/netdata/netdata/issues/19700))
- Detect netdata exit reasons ([#19617](https://github.com/netdata/netdata/issues/19617))
- Under MSYS2 use stat ([#19703](https://github.com/netdata/netdata/issues/19703))
- Add host/os fields to status file ([#19704](https://github.com/netdata/netdata/issues/19704))
- Document journal v2 index file format. ([#19701](https://github.com/netdata/netdata/issues/19701))
- Fix runtime directory; annotate daemon status file ([#19706](https://github.com/netdata/netdata/issues/19706))
- Daemon status improvements 3 ([#19707](https://github.com/netdata/netdata/issues/19707))
- Check for final step ([#19708](https://github.com/netdata/netdata/issues/19708))
- Avoid post initialization errors repeateadly ([#19709](https://github.com/netdata/netdata/issues/19709))
- Fix Fresh Installation on Microsoft ([#19710](https://github.com/netdata/netdata/issues/19710))
- 4 malloc arenas for parents, not IoT ([#19711](https://github.com/netdata/netdata/issues/19711))
- Deduplicate all crash reports ([#19712](https://github.com/netdata/netdata/issues/19712))
- Systemd-journal: allow almost all fields to be facets ([#19713](https://github.com/netdata/netdata/issues/19713))
- Do not use mmap when the mmap limit is too low ([#19714](https://github.com/netdata/netdata/issues/19714))
- Do not call cleanup and exit on fatal conditions during startup ([#19715](https://github.com/netdata/netdata/issues/19715))
- Chore(go.d): add file persister ([#19716](https://github.com/netdata/netdata/issues/19716))
- Unified out of memory handling ([#19717](https://github.com/netdata/netdata/issues/19717))
- Attempt to save status file from the signal handler ([#19718](https://github.com/netdata/netdata/issues/19718))
- Save status on out of memory event ([#19719](https://github.com/netdata/netdata/issues/19719))
- More status file annotations ([#19721](https://github.com/netdata/netdata/issues/19721))
- Status has install type ([#19722](https://github.com/netdata/netdata/issues/19722))
- Minor status file annotation fixes ([#19723](https://github.com/netdata/netdata/issues/19723))
- Allow configuring journal v2 unmount time; turn it off for parents ([#19724](https://github.com/netdata/netdata/issues/19724))
- Handle flushing state during exit ([#19725](https://github.com/netdata/netdata/issues/19725))
- Improve status file deduplication ([#19726](https://github.com/netdata/netdata/issues/19726))
- Docs: clarify Windows Agent limits on free plans ([#19727](https://github.com/netdata/netdata/issues/19727))
- Do not post empty reports ([#19729](https://github.com/netdata/netdata/issues/19729))
- Improved descriptions of exit reasons ([#19730](https://github.com/netdata/netdata/issues/19730))
- Fix json generation of apps.plugin processes function info ([#19732](https://github.com/netdata/netdata/issues/19732))
- Support https_proxy too ([#19733](https://github.com/netdata/netdata/issues/19733))
- Add more information about claiming failures ([#19735](https://github.com/netdata/netdata/issues/19735))
- Allow insecure cloud connections ([#19736](https://github.com/netdata/netdata/issues/19736))
- Add another step when initializing web ([#19731](https://github.com/netdata/netdata/issues/19731))
- Capture deadly signals ([#19737](https://github.com/netdata/netdata/issues/19737))
- Zero mtime when a fallback check fails ([#19740](https://github.com/netdata/netdata/issues/19740))
- Work on agent-events crashes ([#19741](https://github.com/netdata/netdata/issues/19741))
- Fix(go.d): ignore sigpipe to exit gracefully ([#19739](https://github.com/netdata/netdata/issues/19739))
- Allow coredumps to be generated ([#19743](https://github.com/netdata/netdata/issues/19743))
- Pass NULL to sensors_init() when the standard files exist in /etc/ ([#19744](https://github.com/netdata/netdata/issues/19744))
- More strict parsing of the output of system-info.sh ([#19745](https://github.com/netdata/netdata/issues/19745))
- Build(deps): bump github.com/gosnmp/gosnmp from 1.38.0 to 1.39.0 in /src/go ([#19747](https://github.com/netdata/netdata/issues/19747))
- Build(deps): bump github.com/axiomhq/hyperloglog from 0.2.3 to 0.2.5 in /src/go ([#19750](https://github.com/netdata/netdata/issues/19750))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.2 to 1.17.3 in /src/go ([#19748](https://github.com/netdata/netdata/issues/19748))
- Build(deps): bump github.com/docker/docker from 28.0.0+incompatible to 28.0.1+incompatible in /src/go ([#19746](https://github.com/netdata/netdata/issues/19746))
- Build(deps): bump github.com/likexian/whois from 1.15.5 to 1.15.6 in /src/go ([#19749](https://github.com/netdata/netdata/issues/19749))
- Status file improvements (dedup and signal handler use) ([#19751](https://github.com/netdata/netdata/issues/19751))
- Status file version 8 ([#19753](https://github.com/netdata/netdata/issues/19753))
- Feat(go.d): add snmp devices discovery ([#19720](https://github.com/netdata/netdata/issues/19720))
- Chore(go.d/sd/snmp): comment out  defaults in snmp.conf ([#19755](https://github.com/netdata/netdata/issues/19755))
- Improvement(go.d/sd/snmp): support device cache ttl 0 ([#19756](https://github.com/netdata/netdata/issues/19756))
- Status file timings per step ([#19758](https://github.com/netdata/netdata/issues/19758))
- Fix(go.d/nvidia_smi): handle xml gpu_power_readings change ([#19759](https://github.com/netdata/netdata/issues/19759))
- Fix(go.d/sd/snmp): use rescan and cache ttl only when set ([#19760](https://github.com/netdata/netdata/issues/19760))
- Make status file use fixed size character arrays ([#19761](https://github.com/netdata/netdata/issues/19761))
- Fix invalid free ([#19763](https://github.com/netdata/netdata/issues/19763))
- Post status syncrhonously ([#19766](https://github.com/netdata/netdata/issues/19766))
- Detect crashes during status file processing ([#19767](https://github.com/netdata/netdata/issues/19767))
- Copy fields only when the source is valid ([#19768](https://github.com/netdata/netdata/issues/19768))
- Add documentation outlining how to use custom CA certificates with Netdata. ([#19754](https://github.com/netdata/netdata/issues/19754))
- Add handling for sigabrt in the status file ([#19769](https://github.com/netdata/netdata/issues/19769))
- Block all signals before spawning any threads ([#19770](https://github.com/netdata/netdata/issues/19770))
- Block signals before curl ([#19771](https://github.com/netdata/netdata/issues/19771))
- Chore(go.d/sd): rename discoverers pkgs ([#19772](https://github.com/netdata/netdata/issues/19772))
- Improvement(go.d/sd): add file path to k8s/snmp discovered job source ([#19776](https://github.com/netdata/netdata/issues/19776))
- Fix(go.d/sd): fix logging cfg source when disabled ([#19777](https://github.com/netdata/netdata/issues/19777))
- Fix SIGSEGV on static installs due to dengine log ([#19774](https://github.com/netdata/netdata/issues/19774))
- Kickstart: install native pkg on RPi2+ ([#19773](https://github.com/netdata/netdata/issues/19773))
- Add repository priority configuration for DEB package repositories. ([#19705](https://github.com/netdata/netdata/issues/19705))
- Add unique machine id to status file ([#19778](https://github.com/netdata/netdata/issues/19778))
- Revert broken DEB priority configuration in repoconfig packages. ([#19783](https://github.com/netdata/netdata/issues/19783))
- Restructure shutdown logic used during updates. ([#19781](https://github.com/netdata/netdata/issues/19781))
- Improve agent shutdown ([#19775](https://github.com/netdata/netdata/issues/19775))
- Enable libunwind in static builds ([#19764](https://github.com/netdata/netdata/issues/19764))
- Add datadog profiles for snmp collector ([#19785](https://github.com/netdata/netdata/issues/19785))
- Chore: rename snmp.profiles.d -> snmp.profiles ([#19786](https://github.com/netdata/netdata/issues/19786))
- Detect when running in CI and disable posting status ([#19787](https://github.com/netdata/netdata/issues/19787))
- User configurable crash reporting ([#19789](https://github.com/netdata/netdata/issues/19789))
- Docs(go.d/snmp): add snmp discovery information ([#19790](https://github.com/netdata/netdata/issues/19790))
- Regenerate integrations docs ([#19791](https://github.com/netdata/netdata/issues/19791))
- Improvement(go.d/k8s_state): collect cronjobs ([#19793](https://github.com/netdata/netdata/issues/19793))
- Regenerate integrations docs ([#19794](https://github.com/netdata/netdata/issues/19794))
- Status file improvements 12 ([#19792](https://github.com/netdata/netdata/issues/19792))
- Improvement(go.d/k8s_state): add more CronJob metrics ([#19796](https://github.com/netdata/netdata/issues/19796))
- Bump dag jinja to 3.1.6 ([#19800](https://github.com/netdata/netdata/issues/19800))
- Modify eBPF.plugin integration (Part II, the sockets) ([#19572](https://github.com/netdata/netdata/issues/19572))
- Build(deps): bump golang.org/x/net from 0.35.0 to 0.37.0 in /src/go ([#19799](https://github.com/netdata/netdata/issues/19799))
- Regenerate integrations docs ([#19797](https://github.com/netdata/netdata/issues/19797))
- Add k8s_state_cronjob_last_execution_failed alert ([#19801](https://github.com/netdata/netdata/issues/19801))
- Regenerate integrations docs ([#19803](https://github.com/netdata/netdata/issues/19803))
- Async-signal-safe stack traces ([#19802](https://github.com/netdata/netdata/issues/19802))
- ADFS (windows.plugin) ([#19699](https://github.com/netdata/netdata/issues/19699))
- Regenerate integrations docs ([#19804](https://github.com/netdata/netdata/issues/19804))
- Fix memory corruption in streaming ([#19805](https://github.com/netdata/netdata/issues/19805))
- Help finding leaks and running valgrind ([#19806](https://github.com/netdata/netdata/issues/19806))
- Fix fsanitize ifdefs ([#19809](https://github.com/netdata/netdata/issues/19809))
- Do not change the scheduling policy by default ([#19808](https://github.com/netdata/netdata/issues/19808))
- Detect memory leaks ([#19811](https://github.com/netdata/netdata/issues/19811))
- Avoid zero timeout in libuv timers ([#19810](https://github.com/netdata/netdata/issues/19810))
- Fix(go.d/filecheck): remove dyncfg path validation pattern  ([#19815](https://github.com/netdata/netdata/issues/19815))
- Fix(go.d/pihole): switch to pihole6 api ([#19807](https://github.com/netdata/netdata/issues/19807))
- Regenerate integrations docs ([#19816](https://github.com/netdata/netdata/issues/19816))
- Fix LSAN and memory leaks ([#19819](https://github.com/netdata/netdata/issues/19819))
- Acquire datafile for deletion before calculating retention ([#19812](https://github.com/netdata/netdata/issues/19812))
- Free all memory on exit ([#19821](https://github.com/netdata/netdata/issues/19821))
- Include libucontext in static builds to vendor libunwind even on POWER. ([#19817](https://github.com/netdata/netdata/issues/19817))
- Integrate OpenTelemetry collector build into build system. ([#19702](https://github.com/netdata/netdata/issues/19702))
- Use notice log level for "machine ID found" ([#19825](https://github.com/netdata/netdata/issues/19825))
- Build(otel-collector): update to v0.121.0 ([#19824](https://github.com/netdata/netdata/issues/19824))
- Finding leaks No 2 ([#19823](https://github.com/netdata/netdata/issues/19823))
- Rrdhost name fix heap-use-after-free ([#19826](https://github.com/netdata/netdata/issues/19826))
- Fix rrdset name crash on rrdset obsoletion ([#19449](https://github.com/netdata/netdata/issues/19449))
- Revert "fix rrdset name crash on rrdset obsoletion" ([#19828](https://github.com/netdata/netdata/issues/19828))
- Improvement(go.d/k8state): add CronJob suspend status ([#19829](https://github.com/netdata/netdata/issues/19829))
- Fix typo in otel collector build infra. ([#19832](https://github.com/netdata/netdata/issues/19832))
- Regenerate integrations docs ([#19833](https://github.com/netdata/netdata/issues/19833))
- Store status file in /var/lib/netdata, not in /var/cache/netdata ([#19831](https://github.com/netdata/netdata/issues/19831))
- Free strings judy arrays to show leaked strings ([#19827](https://github.com/netdata/netdata/issues/19827))
- When destroying pgc, check if the cache is null ([#19837](https://github.com/netdata/netdata/issues/19837))
- Fix rrdset name crash on cleanup ([#19838](https://github.com/netdata/netdata/issues/19838))
- Fix for building with protobuf 30.0 ([#19835](https://github.com/netdata/netdata/issues/19835))
- Fix RRDDIM_MEM storage engine index ([#19830](https://github.com/netdata/netdata/issues/19830))
- Docs: fix typos in nodes-ephemerality.md ([#19840](https://github.com/netdata/netdata/issues/19840))
- Build(deps): bump k8s.io/client-go from 0.32.2 to 0.32.3 in /src/go ([#19848](https://github.com/netdata/netdata/issues/19848))
- Build(deps): bump github.com/vmware/govmomi from 0.48.1 to 0.49.0 in /src/go ([#19845](https://github.com/netdata/netdata/issues/19845))
- Fix updating on RPi2+ ([#19850](https://github.com/netdata/netdata/issues/19850))
- Add oci meta info ([#19839](https://github.com/netdata/netdata/issues/19839))
- Minor fixes ([#19849](https://github.com/netdata/netdata/issues/19849))
- Fix contexts labels to avoid clearing the rrdlabels pointer ([#19853](https://github.com/netdata/netdata/issues/19853))
- Make sure alerts are concurrently altered by dyncfg ([#19854](https://github.com/netdata/netdata/issues/19854))
- Fix crashes identified by sentry ([#19856](https://github.com/netdata/netdata/issues/19856))
- Daemon status 15 ([#19857](https://github.com/netdata/netdata/issues/19857))
- Netdata-uninstaller: improve input prompt with more descriptive guidance ([#19855](https://github.com/netdata/netdata/issues/19855))
- Disable UNW_LOCAL_ONLY on static builds ([#19858](https://github.com/netdata/netdata/issues/19858))
- Fix(macos.plugin): correct disks/network devices charts ([#19859](https://github.com/netdata/netdata/issues/19859))
- Restore needed variables for pluginsd ([#19860](https://github.com/netdata/netdata/issues/19860))
- Initial commit with snmp profile code ([#19813](https://github.com/netdata/netdata/issues/19813))
- Build(deps): bump github.com/prometheus/common from 0.62.0 to 0.63.0 in /src/go ([#19864](https://github.com/netdata/netdata/issues/19864))
- Daemon status file 16 ([#19863](https://github.com/netdata/netdata/issues/19863))
- Improvement(macos.plugin): add options to filter net ifaces and mountpoints ([#19865](https://github.com/netdata/netdata/issues/19865))
- Fixed sentry dedup ([#19867](https://github.com/netdata/netdata/issues/19867))
- Fixed sentry version ([#19868](https://github.com/netdata/netdata/issues/19868))
- Release memory on shutdown - detect invalid extent in journal files ([#19861](https://github.com/netdata/netdata/issues/19861))
- Fix(freebsd.plugin): correct disks/network devices charts ([#19866](https://github.com/netdata/netdata/issues/19866))
- Daemon status file 17 ([#19869](https://github.com/netdata/netdata/issues/19869))
- Remove tj-actions/changed-files from CI jobs. ([#19870](https://github.com/netdata/netdata/issues/19870))
- Sentry events annotations ([#19872](https://github.com/netdata/netdata/issues/19872))
- Add the fatal to the exit reasons ([#19873](https://github.com/netdata/netdata/issues/19873))
- Make sure the daemon status hash does not depend on random bytes ([#19874](https://github.com/netdata/netdata/issues/19874))
- Do not lose exit reasons ([#19875](https://github.com/netdata/netdata/issues/19875))
- SIGABRT and already running are fatal conditions ([#19878](https://github.com/netdata/netdata/issues/19878))
- Add stack trace information to the compiler and linker ([#19879](https://github.com/netdata/netdata/issues/19879))
- Change log priorities on agent-events ([#19880](https://github.com/netdata/netdata/issues/19880))
- Daemon-status-18 ([#19876](https://github.com/netdata/netdata/issues/19876))
- Ci: use step-security/changed-files ([#19881](https://github.com/netdata/netdata/issues/19881))
- Docs(go.d/snmp): improve auto-detection section ([#19882](https://github.com/netdata/netdata/issues/19882))
- Regenerate integrations docs ([#19883](https://github.com/netdata/netdata/issues/19883))
- Daemon status 18b ([#19884](https://github.com/netdata/netdata/issues/19884))
- Chore(go.d/snmp/ddsnmp): use dd profile definition ([#19886](https://github.com/netdata/netdata/issues/19886))
- Update DEB/RPM package signing key info. ([#19888](https://github.com/netdata/netdata/issues/19888))
- Fix(go.d/snmp/ddsnmp): correct profile directory path ([#19887](https://github.com/netdata/netdata/issues/19887))
- Remove deadlock from dyncfg health ([#19890](https://github.com/netdata/netdata/issues/19890))
- Fix typo in README title ([#19891](https://github.com/netdata/netdata/issues/19891))
- Make sure all rrdcalcs are unlinked the moment they are deleted ([#19893](https://github.com/netdata/netdata/issues/19893))
- Do not recurse cleanup on shutdown ([#19894](https://github.com/netdata/netdata/issues/19894))
- Build: update otel deps to v0.122.0 ([#19895](https://github.com/netdata/netdata/issues/19895))
- Fix for system shutdown ([#19897](https://github.com/netdata/netdata/issues/19897))
- More strict checks on log-fw ([#19898](https://github.com/netdata/netdata/issues/19898))
- More compilation flags for stack traces ([#19899](https://github.com/netdata/netdata/issues/19899))
- Do not use errno when hashing status events ([#19900](https://github.com/netdata/netdata/issues/19900))
- Fix compile without dbengine ([#19902](https://github.com/netdata/netdata/issues/19902))
- Improve CI reliability by allowing for better retry behavior. ([#19834](https://github.com/netdata/netdata/issues/19834))
- Revert "Fix compile without dbengine" ([#19905](https://github.com/netdata/netdata/issues/19905))
- Bump repoconfig version used in kickstart script to 5-1. ([#19906](https://github.com/netdata/netdata/issues/19906))
- Remove auto-retry on changelog generation. ([#19908](https://github.com/netdata/netdata/issues/19908))

## [2.2.0] - 2025-01-22

### Merged Pull Requests:

- Feat(go.d): add  NATS collector ([#19252](https://github.com/netdata/netdata/issues/19252))
- Docs: fix nats metadata suffix ([#19253](https://github.com/netdata/netdata/issues/19253))
- Regenerate integrations docs ([#19254](https://github.com/netdata/netdata/issues/19254))
- Updated copyright notices ([#19256](https://github.com/netdata/netdata/issues/19256))
- Docs: change "node-membership-rules" filename/title ([#19257](https://github.com/netdata/netdata/issues/19257))
- Fix crash when the DRM file does not contain the right information ([#19258](https://github.com/netdata/netdata/issues/19258))
- Add an alert guide for reboot required ([#19260](https://github.com/netdata/netdata/issues/19260))
- HELP and TYPE in prometheus fix ([#19261](https://github.com/netdata/netdata/issues/19261))
- Improvement(go.d/nats): add accstatz metrics ([#19262](https://github.com/netdata/netdata/issues/19262))
- Regenerate integrations docs ([#19263](https://github.com/netdata/netdata/issues/19263))
- Improvement(go.d/nats): add routez metrics ([#19264](https://github.com/netdata/netdata/issues/19264))
- Regenerate integrations docs ([#19265](https://github.com/netdata/netdata/issues/19265))
- Build(deps): bump github.com/axiomhq/hyperloglog from 0.2.0 to 0.2.2 in /src/go ([#19270](https://github.com/netdata/netdata/issues/19270))
- Build(deps): bump github.com/jackc/pgx/v5 from 5.7.1 to 5.7.2 in /src/go ([#19271](https://github.com/netdata/netdata/issues/19271))
- Build(deps): bump github.com/docker/docker from 27.4.0+incompatible to 27.4.1+incompatible in /src/go ([#19268](https://github.com/netdata/netdata/issues/19268))
- Build(deps): bump golang.org/x/net from 0.32.0 to 0.33.0 in /src/go ([#19269](https://github.com/netdata/netdata/issues/19269))
- Build(deps): bump actions/upload-artifact from 4.4.2 to 4.5.0 ([#19272](https://github.com/netdata/netdata/issues/19272))
- Build(deps): update go toolchain to v1.23.4 ([#19273](https://github.com/netdata/netdata/issues/19273))
- Improvement(go.d/nats): add gatewayz metrics ([#19266](https://github.com/netdata/netdata/issues/19266))
- Regenerate integrations docs ([#19276](https://github.com/netdata/netdata/issues/19276))
- Skip label cleanup during metadata processing ([#19274](https://github.com/netdata/netdata/issues/19274))
- Fix(go.d/rabbitmq): handle insufficient perms when querying definitions ([#19277](https://github.com/netdata/netdata/issues/19277))
- Updates to onprem docs ([#19275](https://github.com/netdata/netdata/issues/19275))
- Fix metric retention check and cleanup ([#19278](https://github.com/netdata/netdata/issues/19278))
- Improvement(go.d/nats): add server_id label ([#19280](https://github.com/netdata/netdata/issues/19280))
- Regenerate integrations docs ([#19281](https://github.com/netdata/netdata/issues/19281))
- Docs: improve on-prem troubleshooting readability ([#19279](https://github.com/netdata/netdata/issues/19279))
- Improvement(go.d/nats): add leafz metrics ([#19282](https://github.com/netdata/netdata/issues/19282))
- Regenerate integrations docs ([#19283](https://github.com/netdata/netdata/issues/19283))
- Fix go.d/nats tests ([#19284](https://github.com/netdata/netdata/issues/19284))
- Improvement(go.d/nats): add basic jetstream metrics ([#19285](https://github.com/netdata/netdata/issues/19285))
- Regenerate integrations docs ([#19286](https://github.com/netdata/netdata/issues/19286))
- Bump dag req jinja version ([#19287](https://github.com/netdata/netdata/issues/19287))
- Fix(netdata-updater.sh): remove commit_check_file directory ([#19288](https://github.com/netdata/netdata/issues/19288))
- Fix(netdata-updater.sh): ensure tmpdir-path argument is always passed ([#19289](https://github.com/netdata/netdata/issues/19289))
- Remove go.d/windows ([#19290](https://github.com/netdata/netdata/issues/19290))
- Build(deps): add bison and flex ([#19292](https://github.com/netdata/netdata/issues/19292))
- Monitor sensors using libsensors via debugfs.plugin ([#19251](https://github.com/netdata/netdata/issues/19251))
- DBENGINE: pgc tuning, replication tuning ([#19237](https://github.com/netdata/netdata/issues/19237))
- Fix(debugfs/sensors): correct driver label value ([#19294](https://github.com/netdata/netdata/issues/19294))
- More descriptive alert transition logs ([#19297](https://github.com/netdata/netdata/issues/19297))
- Nd_poll() fairness ([#19298](https://github.com/netdata/netdata/issues/19298))
- Improve stream sending thread error message ([#19300](https://github.com/netdata/netdata/issues/19300))
- Streaming improvements No 12 ([#19299](https://github.com/netdata/netdata/issues/19299))
- Revert waiting-queue optimization ([#19301](https://github.com/netdata/netdata/issues/19301))
- Improvement(go.d/nats): add cluster_name label and jetstream status chart ([#19303](https://github.com/netdata/netdata/issues/19303))
- Waiting Queue ([#19302](https://github.com/netdata/netdata/issues/19302))
- WAITQ: fixed mixed up ordering ([#19305](https://github.com/netdata/netdata/issues/19305))
- Fix shutdown ([#19306](https://github.com/netdata/netdata/issues/19306))
- Load rrdcontext dimensions in batches ([#19304](https://github.com/netdata/netdata/issues/19304))
- Fix aral memory accounting ([#19308](https://github.com/netdata/netdata/issues/19308))
- Docs(go.d/nats): add missing labels to meta ([#19309](https://github.com/netdata/netdata/issues/19309))
- Regenerate integrations docs ([#19310](https://github.com/netdata/netdata/issues/19310))
- Fix(go.d/nats): add missing cid label to gw charts ([#19311](https://github.com/netdata/netdata/issues/19311))
- Fix(go.d/sd): correctly adding tags in classify ([#19312](https://github.com/netdata/netdata/issues/19312))
- Add yugabytedb docker manager ([#19313](https://github.com/netdata/netdata/issues/19313))
- Locks Improvements ([#19314](https://github.com/netdata/netdata/issues/19314))
- Feat(cgroup-name.sh): Add support for `netdata.cloud/*` container labels ([#19315](https://github.com/netdata/netdata/issues/19315))
- Fix(cgroup-rename): prevent leading comma in Docker LABELS when IMAGE empty ([#19318](https://github.com/netdata/netdata/issues/19318))
- Build(deps): bump github.com/vmware/govmomi from 0.46.3 to 0.47.0 in /src/go ([#19322](https://github.com/netdata/netdata/issues/19322))
- Fix(kickstart.sh): correct wrong function name in perpare_offline_install ([#19323](https://github.com/netdata/netdata/issues/19323))
- Fix(netdata-updater.sh): use explicit paths for temp dir creation ([#19293](https://github.com/netdata/netdata/issues/19293))
- FD Leaks Fix ([#19327](https://github.com/netdata/netdata/issues/19327))
- CGROUP labels ([#19316](https://github.com/netdata/netdata/issues/19316))
- Build(deps): bump golang.org/x/net from 0.33.0 to 0.34.0 in /src/go ([#19330](https://github.com/netdata/netdata/issues/19330))
- Improvement(go.d/docker): add option to filter containers ([#19337](https://github.com/netdata/netdata/issues/19337))
- Docs(go.d/docker): fix syntax error in meta ([#19339](https://github.com/netdata/netdata/issues/19339))
- Regenerate integrations docs ([#19340](https://github.com/netdata/netdata/issues/19340))
- Improvement(go.d/docker): respect ignore label ([#19341](https://github.com/netdata/netdata/issues/19341))
- Convert invalid utf8 sequences to hex characters ([#19333](https://github.com/netdata/netdata/issues/19333))
- Improvement(go.d/k8sstate): respect ignore annotation ([#19342](https://github.com/netdata/netdata/issues/19342))
- Contexts Loading ([#19336](https://github.com/netdata/netdata/issues/19336))
- Abort on fatal and report system available bytes on allocation failures. ([#19332](https://github.com/netdata/netdata/issues/19332))
- Add alert version to aclk-state ([#19335](https://github.com/netdata/netdata/issues/19335))
- Add option to updater to report status of auto-updates on the system. ([#19248](https://github.com/netdata/netdata/issues/19248))
- Add instructions for Docker Compose ([#19331](https://github.com/netdata/netdata/issues/19331))
- Regenerate integrations docs ([#19344](https://github.com/netdata/netdata/issues/19344))
- Assorted systemd detection fixes ([#19345](https://github.com/netdata/netdata/issues/19345))
- Use sqlite3_status64() ([#19347](https://github.com/netdata/netdata/issues/19347))
- Log a summary of metadata ignored contexts ([#19348](https://github.com/netdata/netdata/issues/19348))
- PGC wanted size ([#19349](https://github.com/netdata/netdata/issues/19349))
- Lower compression level to lower cpu resources on parents ([#19350](https://github.com/netdata/netdata/issues/19350))
- RRDCONTEXTS: loading report ([#19351](https://github.com/netdata/netdata/issues/19351))
- Annotate logs with stack trace when libunwind is available ([#19334](https://github.com/netdata/netdata/issues/19334))
- Minor fixes ([#19353](https://github.com/netdata/netdata/issues/19353))
- Fix compilation on windows ([#19354](https://github.com/netdata/netdata/issues/19354))
- Stream receiver/sender compress BEGIN-SET-END performance ([#19352](https://github.com/netdata/netdata/issues/19352))
- Stream Compression Fix ([#19355](https://github.com/netdata/netdata/issues/19355))
- Fix coverity issues ([#19317](https://github.com/netdata/netdata/issues/19317))
- Allow compiling with FSANITIZE_ADDRESS ([#19357](https://github.com/netdata/netdata/issues/19357))
- Fix flood protection ([#19358](https://github.com/netdata/netdata/issues/19358))
- Fix os_system_memory() for concurrent use and call it from pulse ([#19359](https://github.com/netdata/netdata/issues/19359))
- Respect flood protection configuration for daemon ([#19360](https://github.com/netdata/netdata/issues/19360))
- Avoid checking replication status all the time ([#19361](https://github.com/netdata/netdata/issues/19361))
- Metrics-cardinality function ([#19362](https://github.com/netdata/netdata/issues/19362))
- Prevent memory corruption in dbengine ([#19363](https://github.com/netdata/netdata/issues/19363))
- Revert "prevent memory corruption in dbengine" ([#19364](https://github.com/netdata/netdata/issues/19364))
- Prevent memory corruption in dbengine ([#19365](https://github.com/netdata/netdata/issues/19365))
- Improve context load time during startup ([#19321](https://github.com/netdata/netdata/issues/19321))
- Metrics cardinality improvements ([#19366](https://github.com/netdata/netdata/issues/19366))
- Stream-thread fix memory corruption ([#19367](https://github.com/netdata/netdata/issues/19367))
- Metrics cardinality - more statistics and groupings ([#19368](https://github.com/netdata/netdata/issues/19368))
- Fix for PGC wanted_cache_size getting to zero ([#19370](https://github.com/netdata/netdata/issues/19370))
- Disable libunwind on forked children ([#19374](https://github.com/netdata/netdata/issues/19374))
- Fix alert entry traversal when doing cleanup ([#19373](https://github.com/netdata/netdata/issues/19373))
- Build(deps): bump go.mongodb.org/mongo-driver from 1.17.1 to 1.17.2 in /src/go ([#19377](https://github.com/netdata/netdata/issues/19377))
- Build(deps): bump github.com/axiomhq/hyperloglog from 0.2.2 to 0.2.3 in /src/go ([#19378](https://github.com/netdata/netdata/issues/19378))
- Pulse extended memory statistics, now report glibc allocations ([#19379](https://github.com/netdata/netdata/issues/19379))
- ARAL: fast path to quickly allocate elements on a new page ([#19376](https://github.com/netdata/netdata/issues/19376))
- Limit the glibc unused memory ([#19380](https://github.com/netdata/netdata/issues/19380))
- Fix mallinfo2 ([#19381](https://github.com/netdata/netdata/issues/19381))
- Used_arena should exclude unused memory ([#19382](https://github.com/netdata/netdata/issues/19382))
- Added mmap count charts ([#19384](https://github.com/netdata/netdata/issues/19384))
- Reduce glibc memory fragmentation ([#19385](https://github.com/netdata/netdata/issues/19385))
- Build(deps): bump actions/upload-artifact from 4.5.0 to 4.6.0 ([#19387](https://github.com/netdata/netdata/issues/19387))
- Build(deps): bump azure/trusted-signing-action from 0.5.0 to 0.5.1 ([#19388](https://github.com/netdata/netdata/issues/19388))
- Fix issues with $PATH and netdatacli detection. ([#19371](https://github.com/netdata/netdata/issues/19371))
- Reduce glibc fragmentation Part 2 ([#19390](https://github.com/netdata/netdata/issues/19390))
- Feat(go.d.plugin): add YugabyteDB collector ([#19325](https://github.com/netdata/netdata/issues/19325))
- Regenerate integrations docs ([#19394](https://github.com/netdata/netdata/issues/19394))
- Build(go.d): switch to gohugoio/hashstructure ([#19395](https://github.com/netdata/netdata/issues/19395))
- Make libunwind opt-in at build time instead of auto-enabled. ([#19393](https://github.com/netdata/netdata/issues/19393))
- UUIDMap ([#19307](https://github.com/netdata/netdata/issues/19307))
- Remove openSUSE 15.5 from CI and package builds. ([#19392](https://github.com/netdata/netdata/issues/19392))
- Update kickstart script to use new repository host. ([#18962](https://github.com/netdata/netdata/issues/18962))
- Unified memory API ([#19396](https://github.com/netdata/netdata/issues/19396))
- Check cluster centers size in copy constructor of inlined kmeans ([#19356](https://github.com/netdata/netdata/issues/19356))
- Verify and cleanup deleted contexts ([#19389](https://github.com/netdata/netdata/issues/19389))
- Fix nodes staying in initializing status ([#19398](https://github.com/netdata/netdata/issues/19398))
- Use worker when dispatching alert transitions to the cloud ([#19397](https://github.com/netdata/netdata/issues/19397))
- Revert "Update kickstart script to use new repository host." ([#19400](https://github.com/netdata/netdata/issues/19400))
- Do not process contexts before they are loaded ([#19401](https://github.com/netdata/netdata/issues/19401))
- Split rrdhost/rrdset/rrddim and rrd.h ([#19399](https://github.com/netdata/netdata/issues/19399))
- System memory calculation for cgroups v1 fix ([#19402](https://github.com/netdata/netdata/issues/19402))
- Delay context cleanup checks after startup ([#19403](https://github.com/netdata/netdata/issues/19403))
- Fix loading contexts ([#19404](https://github.com/netdata/netdata/issues/19404))
- RRD files split, renames, cleanup Part 2 ([#19405](https://github.com/netdata/netdata/issues/19405))
- Fixed http clients accounting ([#19406](https://github.com/netdata/netdata/issues/19406))
- Build(deps): bump github.com/docker/docker from 27.4.1+incompatible to 27.5.0+incompatible in /src/go ([#19408](https://github.com/netdata/netdata/issues/19408))
- Build(deps): bump github.com/bmatcuk/doublestar/v4 from 4.7.1 to 4.8.0 in /src/go ([#19407](https://github.com/netdata/netdata/issues/19407))
- Alert prototypes: use r/w spinlock instead of spinlock ([#19410](https://github.com/netdata/netdata/issues/19410))
- REFCOUNT: use only compare-and-exchange ([#19411](https://github.com/netdata/netdata/issues/19411))
- Query systemd for unit file paths on install/uninstall. ([#19346](https://github.com/netdata/netdata/issues/19346))
- Packaging(windows): use local copy of GPL-3 ([#19414](https://github.com/netdata/netdata/issues/19414))
- Add "netdata-" prefix to streaming and metrics-cardinality functions ([#19413](https://github.com/netdata/netdata/issues/19413))
- Hostnames: convert to utf8 and santitize ([#19418](https://github.com/netdata/netdata/issues/19418))
- Cleanup contexts during loading ([#19416](https://github.com/netdata/netdata/issues/19416))
- PULSE: network traffic ([#19419](https://github.com/netdata/netdata/issues/19419))
- Fix mmaps accounting ([#19420](https://github.com/netdata/netdata/issues/19420))
- Log stream_info payload when it cannot be parsed ([#19424](https://github.com/netdata/netdata/issues/19424))
- Add 'type' to GH report forms ([#19421](https://github.com/netdata/netdata/issues/19421))
- Fix coverity issues ([#19422](https://github.com/netdata/netdata/issues/19422))
- ACLK timeout ([#19425](https://github.com/netdata/netdata/issues/19425))
- Feat(go.d/ethtool): collect module ddm info using ethtool ([#19426](https://github.com/netdata/netdata/issues/19426))
- Fix(go.d/ethtool): use ndsudo for module info ([#19429](https://github.com/netdata/netdata/issues/19429))
- Docs: fix go.d/ethtool meta ([#19430](https://github.com/netdata/netdata/issues/19430))
- Drop Fedora 39 from CI and package builds. ([#19431](https://github.com/netdata/netdata/issues/19431))
- Regenerate integrations docs ([#19432](https://github.com/netdata/netdata/issues/19432))
- Cleanup context check list on startup ([#19433](https://github.com/netdata/netdata/issues/19433))
- Fix go.d/ethtool config schema ([#19434](https://github.com/netdata/netdata/issues/19434))
- Add 'ethtool -m' to ndsudo ([#19428](https://github.com/netdata/netdata/issues/19428))
- Add more aclk worker jobs ([#19435](https://github.com/netdata/netdata/issues/19435))
- Build(deps): bump k8s.io/client-go from 0.32.0 to 0.32.1 in /src/go ([#19437](https://github.com/netdata/netdata/issues/19437))
- Build(deps): bump github.com/prometheus/common from 0.61.0 to 0.62.0 in /src/go ([#19439](https://github.com/netdata/netdata/issues/19439))
- Build(deps): bump github.com/sijms/go-ora/v2 from 2.8.22 to 2.8.23 in /src/go ([#19438](https://github.com/netdata/netdata/issues/19438))
- Move dbengine-retention chart to pulse ([#19444](https://github.com/netdata/netdata/issues/19444))
- Handle incoming ACLK traffic asynchronously ([#19436](https://github.com/netdata/netdata/issues/19436))
- Fix Child web remote access Config in Parent-Child Deployment Examples ([#19443](https://github.com/netdata/netdata/issues/19443))
- Build(deps): update go toolchain to v1.23.5 ([#19442](https://github.com/netdata/netdata/issues/19442))
- Make sure ACLK synchronization event loop runs frequently ([#19446](https://github.com/netdata/netdata/issues/19446))
- Cleanup metadata event loop ([#19447](https://github.com/netdata/netdata/issues/19447))
- Do not run queries synchronously in the event loop ([#19448](https://github.com/netdata/netdata/issues/19448))
- Add missing information in rule based membership document ([#19423](https://github.com/netdata/netdata/issues/19423))
- Enable libunwind in Docker images. ([#19409](https://github.com/netdata/netdata/issues/19409))
- Enable libunwind in DEB native packages. ([#19417](https://github.com/netdata/netdata/issues/19417))
- Revert libunwind being enabled in Docker and DEB builds. ([#19450](https://github.com/netdata/netdata/issues/19450))
- Simplify the rrdhost_ingestion_status call ([#19456](https://github.com/netdata/netdata/issues/19456))
- Fix(go.d/upsd): remove UPS load charts if UPS load not found ([#19457](https://github.com/netdata/netdata/issues/19457))
- Control stream-info requests rate ([#19458](https://github.com/netdata/netdata/issues/19458))
- Fix up handling of libunwind in CMake. ([#19451](https://github.com/netdata/netdata/issues/19451))

## [2.1.0] - 2024-12-19

### Merged Pull Requests:

- Update Windows Documentation ([#18928](https://github.com/netdata/netdata/issues/18928))
- Regenerate integrations.js ([#18966](https://github.com/netdata/netdata/issues/18966))
- Bump github.com/Wing924/ltsv from 0.3.1 to 0.4.0 in /src/go ([#18636](https://github.com/netdata/netdata/issues/18636))
- Go mod tidy ([#18967](https://github.com/netdata/netdata/issues/18967))
- Build(deps): bump golang.org/x/text from 0.19.0 to 0.20.0 in /src/go ([#18968](https://github.com/netdata/netdata/issues/18968))
- Fix(go.d/snmp): don't return error if no sysName ([#18970](https://github.com/netdata/netdata/issues/18970))
- Feat(go.d/rabbitmq): add cluster support ([#18965](https://github.com/netdata/netdata/issues/18965))
- Regenerate integrations.js ([#18971](https://github.com/netdata/netdata/issues/18971))
- Add rabbitmq alerts ([#18972](https://github.com/netdata/netdata/issues/18972))
- Regenerate integrations.js ([#18973](https://github.com/netdata/netdata/issues/18973))
- Improvement(go.d/rabbitmq): add queue status and net partitions ([#18976](https://github.com/netdata/netdata/issues/18976))
- Ci: fix win jobs ([#18979](https://github.com/netdata/netdata/issues/18979))
- Regenerate integrations.js ([#18977](https://github.com/netdata/netdata/issues/18977))
- Added /api/v3/stream_path ([#18943](https://github.com/netdata/netdata/issues/18943))
- Improvement(go.d.plugin): add data collection status chart ([#18981](https://github.com/netdata/netdata/issues/18981))
- Build(deps): bump golang.org/x/net from 0.30.0 to 0.31.0 in /src/go ([#18986](https://github.com/netdata/netdata/issues/18986))
- Chore(go.d.plugin): fix duplicate boolToInt ([#18987](https://github.com/netdata/netdata/issues/18987))
- Update GH bug report ([#18988](https://github.com/netdata/netdata/issues/18988))
- Health: enable go.d data collection job status alert ([#18989](https://github.com/netdata/netdata/issues/18989))
- Update plugin_data_collection_status alert summary/info ([#18990](https://github.com/netdata/netdata/issues/18990))
- Do not intentionally abort on non-0 exit code. ([#18991](https://github.com/netdata/netdata/issues/18991))
- Docs: single line win deploy ([#18994](https://github.com/netdata/netdata/issues/18994))
- Docs: win deploy remove `./` ([#18996](https://github.com/netdata/netdata/issues/18996))
- Regenerate integrations.js ([#18997](https://github.com/netdata/netdata/issues/18997))
- Fix: exclude volumes w/o drive letter from disk_space_usage_alert ([#19000](https://github.com/netdata/netdata/issues/19000))
- Improvement(go.d/x509check): support checking full chain expiry time ([#19001](https://github.com/netdata/netdata/issues/19001))
- Regenerate integrations.js ([#19002](https://github.com/netdata/netdata/issues/19002))
- Fix(go.d/dyncfg): remove additionalProperties check ([#19003](https://github.com/netdata/netdata/issues/19003))
- Improve Installer (Part II) ([#18983](https://github.com/netdata/netdata/issues/18983))
- Fix(go.d/x509check): correct check revocation code ([#19004](https://github.com/netdata/netdata/issues/19004))
- Fix(go.d/dyncfg): remove additionalProperties ([#19006](https://github.com/netdata/netdata/issues/19006))
- Set expires header when serving files ([#19005](https://github.com/netdata/netdata/issues/19005))
- Docs(go.d/windows): add deprecation notice ([#19009](https://github.com/netdata/netdata/issues/19009))
- Regenerate integrations.js ([#19010](https://github.com/netdata/netdata/issues/19010))
- Backport of fixes from balance-parents ([#19012](https://github.com/netdata/netdata/issues/19012))
- Add missing spinlock unlocks on containers ([#19011](https://github.com/netdata/netdata/issues/19011))
- Fix has_receiver condition in rrdhost_status() ([#19014](https://github.com/netdata/netdata/issues/19014))
- Remove MSI test ([#19015](https://github.com/netdata/netdata/issues/19015))
- Fix(go.d/ping): fix "interface" option ([#19016](https://github.com/netdata/netdata/issues/19016))
- Regenerate integrations.js ([#19018](https://github.com/netdata/netdata/issues/19018))
- IIS Metadata ([#18765](https://github.com/netdata/netdata/issues/18765))
- Docs: just iis ([#19021](https://github.com/netdata/netdata/issues/19021))
- Add SQL Express Metrics ([#18992](https://github.com/netdata/netdata/issues/18992))
- Regenerate integrations.js ([#19022](https://github.com/netdata/netdata/issues/19022))
- Chore(windows.plugin): format win collectors code ([#19019](https://github.com/netdata/netdata/issues/19019))
- Docs(go.d/windows): remove references to old MSI ([#19024](https://github.com/netdata/netdata/issues/19024))
- Improvement(go.d.plugin): automatically set GOMAXPROCS ([#19023](https://github.com/netdata/netdata/issues/19023))
- Regenerate integrations.js ([#19025](https://github.com/netdata/netdata/issues/19025))
- Chore(go.d.plugin): set nooplogger for automaxprocs ([#19026](https://github.com/netdata/netdata/issues/19026))
- Fix(windows/iis): dont sanitize site name for labels ([#19027](https://github.com/netdata/netdata/issues/19027))
- Improvement(windows/iis): add requests by type chart ([#19028](https://github.com/netdata/netdata/issues/19028))
- Regenerate integrations.js ([#19029](https://github.com/netdata/netdata/issues/19029))
- Build(deps): bump github.com/vmware/govmomi from 0.46.0 to 0.46.1 in /src/go ([#19030](https://github.com/netdata/netdata/issues/19030))
- Update ram-requirements.md
- Build(deps): bump github.com/gorcon/rcon from 1.3.5 to 1.4.0 in /src/go ([#19031](https://github.com/netdata/netdata/issues/19031))
- Fix: ensure correct startup order for Netdata service on FreeBSD ([#19032](https://github.com/netdata/netdata/issues/19032))
- Add `shutdown` keyword to ensure graceful service termination on FreeBSD ([#19033](https://github.com/netdata/netdata/issues/19033))
- --dev option to installer ([#19034](https://github.com/netdata/netdata/issues/19034))
- Fix(windows/netframework): dont sanitize proc name for labels ([#19036](https://github.com/netdata/netdata/issues/19036))
- Improvement(go.d.plugin): terminate on QUIT command ([#19038](https://github.com/netdata/netdata/issues/19038))
- Tidy up CI to improve overall run times. ([#18957](https://github.com/netdata/netdata/issues/18957))
- Fix(go.d/nvidia_smi): disable loop mode by default on Win ([#19039](https://github.com/netdata/netdata/issues/19039))
- Fix(go.d/nvidia_smi): disable loop mode on Win ([#19040](https://github.com/netdata/netdata/issues/19040))
- Add Custom Actions (Installer) ([#19041](https://github.com/netdata/netdata/issues/19041))
- Add a special version number to bypass alert snapshots ([#19042](https://github.com/netdata/netdata/issues/19042))
- Capitalize the word "cloud" ([#19043](https://github.com/netdata/netdata/issues/19043))
- Capitalize the word "Agent" ([#19044](https://github.com/netdata/netdata/issues/19044))
- Regenerate integrations.js ([#19045](https://github.com/netdata/netdata/issues/19045))
- Feat(go.d/pkg/web): add "force_http2" option ([#19047](https://github.com/netdata/netdata/issues/19047))
- Regenerate integrations.js ([#19048](https://github.com/netdata/netdata/issues/19048))
- Fix MSSQL algorithm (Windows.plugin) ([#19035](https://github.com/netdata/netdata/issues/19035))
- Fix(go.d/pkg/web): correct close idle connections ([#19052](https://github.com/netdata/netdata/issues/19052))
- Update documentation about our native package repos. ([#19049](https://github.com/netdata/netdata/issues/19049))
- Windows doc updates ([#19054](https://github.com/netdata/netdata/issues/19054))
- Securing Agents section docs cleanup ([#19053](https://github.com/netdata/netdata/issues/19053))
- Build(deps): bump k8s.io/client-go from 0.31.2 to 0.31.3 in /src/go ([#19059](https://github.com/netdata/netdata/issues/19059))
- Build(deps): bump github.com/vmware/govmomi from 0.46.1 to 0.46.2 in /src/go ([#19058](https://github.com/netdata/netdata/issues/19058))
- Add links to mssql perflib object docs ([#19062](https://github.com/netdata/netdata/issues/19062))
- Register service to delay start ([#19063](https://github.com/netdata/netdata/issues/19063))
- Claim -> connect in docs ([#19060](https://github.com/netdata/netdata/issues/19060))
- Regenerate integrations.js ([#19065](https://github.com/netdata/netdata/issues/19065))
- Docs(systemd-journal.plugin): correct "Full-text search" ([#19066](https://github.com/netdata/netdata/issues/19066))
- Update gorilla comp internal charts family ([#19068](https://github.com/netdata/netdata/issues/19068))
- Build(deps): bump github.com/prometheus-community/pro-bing from 0.4.2-0.20241106090159-5a5f1d731cf5 to 0.5.0 in /src/go ([#19070](https://github.com/netdata/netdata/issues/19070))
- Build(deps): bump github.com/stretchr/testify from 1.9.0 to 1.10.0 in /src/go ([#19069](https://github.com/netdata/netdata/issues/19069))
- Create a terminology dictionary for Netdata ([#19071](https://github.com/netdata/netdata/issues/19071))
- Collector configuration page edits ([#19072](https://github.com/netdata/netdata/issues/19072))
- RAM and CPU resource util pages ([#19074](https://github.com/netdata/netdata/issues/19074))
- Database docs edits ([#19075](https://github.com/netdata/netdata/issues/19075))
- Remove Go windows integration ([#19078](https://github.com/netdata/netdata/issues/19078))
- Regenerate integrations.js ([#19079](https://github.com/netdata/netdata/issues/19079))
- Split database overview and configuration reference ([#19077](https://github.com/netdata/netdata/issues/19077))
- Chore(go.d.plugin): renames ([#19081](https://github.com/netdata/netdata/issues/19081))
- Update integrations gen script ([#19085](https://github.com/netdata/netdata/issues/19085))
- Regenerate integrations.js ([#19086](https://github.com/netdata/netdata/issues/19086))
- Fix(go.d/hpssa): handle HPE Smart Array line ([#19084](https://github.com/netdata/netdata/issues/19084))
- Docs: fix go.d modules rename leftovers ([#19087](https://github.com/netdata/netdata/issues/19087))
- Regenerate integrations.js ([#19088](https://github.com/netdata/netdata/issues/19088))
- Docs(systemd-journal.plugin): correct full-text search ([#19093](https://github.com/netdata/netdata/issues/19093))
- Chore(go.d.plugin): renames part 2 ([#19090](https://github.com/netdata/netdata/issues/19090))
- Collected and available metrics, instances and contexts ([#19094](https://github.com/netdata/netdata/issues/19094))
- Remove stale docs, and update links and optimization documentation ([#19089](https://github.com/netdata/netdata/issues/19089))
- Update Registry docs ([#19095](https://github.com/netdata/netdata/issues/19095))
- Reset parameter when generating an alert snapshot ([#19097](https://github.com/netdata/netdata/issues/19097))
- Use mimalloc ([#19080](https://github.com/netdata/netdata/issues/19080))
- Daemon docs edits ([#19091](https://github.com/netdata/netdata/issues/19091))
- Claiming proxy defaults and additonal log info ([#19098](https://github.com/netdata/netdata/issues/19098))
- Edit the organize doc ([#19101](https://github.com/netdata/netdata/issues/19101))
- Update connecting documentation ([#19100](https://github.com/netdata/netdata/issues/19100))
- Docs: fix img tag ([#19102](https://github.com/netdata/netdata/issues/19102))
- Chore(go.d/pkg/socket): add err to callback return values ([#19103](https://github.com/netdata/netdata/issues/19103))
- Docs edits on Cloud versions and On Prem ([#19104](https://github.com/netdata/netdata/issues/19104))
- On-prem docs edits 2 ([#19105](https://github.com/netdata/netdata/issues/19105))
- Docs: update On-Prem System Requirements ([#19107](https://github.com/netdata/netdata/issues/19107))
- Feat(proc.plugin): add Reboot Required collector ([#19109](https://github.com/netdata/netdata/issues/19109))
- Fix(proc/reboot_required): disable on non Debian-based systems ([#19110](https://github.com/netdata/netdata/issues/19110))
- Docs: format, typos, and some simplifications in `docs/` ([#19112](https://github.com/netdata/netdata/issues/19112))
- Change dim order because of colours in reboot_required ([#19111](https://github.com/netdata/netdata/issues/19111))
- Disable python.d/example ([#19114](https://github.com/netdata/netdata/issues/19114))
- Fix undefined behaviour. ([#19116](https://github.com/netdata/netdata/issues/19116))
- Disable mimalloc by default / enable explicitly if needed ([#19118](https://github.com/netdata/netdata/issues/19118))
- Change default nice level to 0 ([#19120](https://github.com/netdata/netdata/issues/19120))
- Move eBPF code from linetdata to src/collector ([#19121](https://github.com/netdata/netdata/issues/19121))
- Integrations gha, remove .js and .json files after the process ([#19125](https://github.com/netdata/netdata/issues/19125))
- Regenerate integrations docs ([#19126](https://github.com/netdata/netdata/issues/19126))
- Address installer minor issues (Windows) ([#19122](https://github.com/netdata/netdata/issues/19122))
- Reduce EBPF memory usage ([#19117](https://github.com/netdata/netdata/issues/19117))
- Avoid scanning charts for replication status ([#19124](https://github.com/netdata/netdata/issues/19124))
- Fix(system-info): change id_like and name mac -> macOS ([#19128](https://github.com/netdata/netdata/issues/19128))
- Fix(packaging): correct go linux 386 checksum ([#19127](https://github.com/netdata/netdata/issues/19127))
- Docs(windows/hyperv): add Hyper-V metadata ([#19129](https://github.com/netdata/netdata/issues/19129))
- Regenerate integrations docs ([#19131](https://github.com/netdata/netdata/issues/19131))
- Chore(windows/hyperv): small Hyper-V fixes ([#19130](https://github.com/netdata/netdata/issues/19130))
- Balance streaming parents ([#18945](https://github.com/netdata/netdata/issues/18945))
- Ci: fix build/Prepare Artifacts ([#19133](https://github.com/netdata/netdata/issues/19133))
- Docs: restructure readme intro for better readability ([#19134](https://github.com/netdata/netdata/issues/19134))
- Minor beatification of log messages ([#19135](https://github.com/netdata/netdata/issues/19135))
- Fixed bug in streaming sender read ([#19136](https://github.com/netdata/netdata/issues/19136))
- Docs: Edits in the main Netdata Cloud readme ([#19139](https://github.com/netdata/netdata/issues/19139))
- Ci: fix build/create release ([#19138](https://github.com/netdata/netdata/issues/19138))
- Docs: Plans and ACLK docs edits ([#19140](https://github.com/netdata/netdata/issues/19140))
- Docs: fix a typo in aclk readme ([#19141](https://github.com/netdata/netdata/issues/19141))
- Chore(go.d.plugin): improve function parser ([#19143](https://github.com/netdata/netdata/issues/19143))
- Modify Claim Screen (Windows Installer) ([#19132](https://github.com/netdata/netdata/issues/19132))
- Chore(go.d.plugin): simplify netdataapi pkg ([#19145](https://github.com/netdata/netdata/issues/19145))
- Chore(go.d.plugin): simplify main ([#19146](https://github.com/netdata/netdata/issues/19146))
- Build(deps): bump github.com/axiomhq/hyperloglog from 0.2.0 to 0.2.1 in /src/go ([#19151](https://github.com/netdata/netdata/issues/19151))
- Build(deps): bump golang.org/x/net from 0.31.0 to 0.32.0 in /src/go ([#19149](https://github.com/netdata/netdata/issues/19149))
- MSSQL Metadatas (windows.plugin) ([#19147](https://github.com/netdata/netdata/issues/19147))
- Regenerate integrations docs ([#19152](https://github.com/netdata/netdata/issues/19152))
- Build(deps): bump github.com/prometheus/common from 0.60.1 to 0.61.0 in /src/go ([#19148](https://github.com/netdata/netdata/issues/19148))
- Fix(go.d): unlock job files on quit/restart ([#19153](https://github.com/netdata/netdata/issues/19153))
- Fix(go.d): correct unlockall impl ([#19154](https://github.com/netdata/netdata/issues/19154))
- Fix(go.d): correct sd dir ([#19155](https://github.com/netdata/netdata/issues/19155))
- Fix(build): fix building go.d on 32bit ([#19156](https://github.com/netdata/netdata/issues/19156))
- Streaming [#1](https://github.com/netdata/netdata/issues/1) ([#19137](https://github.com/netdata/netdata/issues/19137))
- NET Framework metadata (Windows.plugin Part 1) ([#19158](https://github.com/netdata/netdata/issues/19158))
- Regenerate integrations docs ([#19161](https://github.com/netdata/netdata/issues/19161))
- Docs: edit Authentication and Authorization section ([#19160](https://github.com/netdata/netdata/issues/19160))
- Docs: leftover links + changes on api-tokens.md ([#19162](https://github.com/netdata/netdata/issues/19162))
- Regenerate integrations docs ([#19164](https://github.com/netdata/netdata/issues/19164))
- Streaming improvements No 2 ([#19167](https://github.com/netdata/netdata/issues/19167))
- Add units per context to /api/v3/contexts ([#19165](https://github.com/netdata/netdata/issues/19165))
- Send quit to plugins ([#19166](https://github.com/netdata/netdata/issues/19166))
- Remove Option from Installer (Windows) ([#19159](https://github.com/netdata/netdata/issues/19159))
- Update cloud virtual host name ([#19163](https://github.com/netdata/netdata/issues/19163))
- Build(deps): bump github.com/docker/docker from 27.3.1+incompatible to 27.4.0+incompatible in /src/go ([#19172](https://github.com/netdata/netdata/issues/19172))
- Processor Metadata (Windows Plugin) ([#19171](https://github.com/netdata/netdata/issues/19171))
- Regenerate integrations docs ([#19173](https://github.com/netdata/netdata/issues/19173))
- Docs: reorder silent mode and add full pipeline command example ([#19176](https://github.com/netdata/netdata/issues/19176))
- Add Objects metadata (Windows Plugin) ([#19175](https://github.com/netdata/netdata/issues/19175))
- Regenerate integrations docs ([#19177](https://github.com/netdata/netdata/issues/19177))
- Bump repository config fetched by kickstart to latest version ([#19181](https://github.com/netdata/netdata/issues/19181))
- Chore(go.d): pass context to init/check/collect/cleanup ([#19180](https://github.com/netdata/netdata/issues/19180))
- Fixup URLs in package repo documentation to use index files. ([#19174](https://github.com/netdata/netdata/issues/19174))
- Disks Metadata (Windows plugin) ([#19182](https://github.com/netdata/netdata/issues/19182))
- Regenerate integrations docs ([#19184](https://github.com/netdata/netdata/issues/19184))
- Fix(kickstart): netdata_avail_check on Ubuntu ([#19183](https://github.com/netdata/netdata/issues/19183))
- Move dependency handling for integrations to script. ([#19185](https://github.com/netdata/netdata/issues/19185))
- Add GitHub workflow ([#18128](https://github.com/netdata/netdata/issues/18128))
- Streaming improvements No 3 ([#19168](https://github.com/netdata/netdata/issues/19168))
- Ci: fix update-website workflow ([#19187](https://github.com/netdata/netdata/issues/19187))
- Build(deps): bump golang.org/x/crypto from 0.30.0 to 0.31.0 in /src/go ([#19189](https://github.com/netdata/netdata/issues/19189))
- Docs: remove a duplicated row ([#19190](https://github.com/netdata/netdata/issues/19190))
- Rw_spinlocks: allow recursive readers, even when writers are waiting ([#19191](https://github.com/netdata/netdata/issues/19191))
- Network Metadata (Windows plugin) ([#19188](https://github.com/netdata/netdata/issues/19188))
- Regenerate integrations docs ([#19192](https://github.com/netdata/netdata/issues/19192))
- Streaming improvements No 4 ([#19186](https://github.com/netdata/netdata/issues/19186))
- Add cross-architecture build tests for Go code. ([#19195](https://github.com/netdata/netdata/issues/19195))
- Streaming Improvements No 5 ([#19193](https://github.com/netdata/netdata/issues/19193))
- Remove July arrays ([#19194](https://github.com/netdata/netdata/issues/19194))
- Streaming improvements No 6 ([#19196](https://github.com/netdata/netdata/issues/19196))
- Streaming improvements No 7 ([#19204](https://github.com/netdata/netdata/issues/19204))
- Feat(go.d.plugin): add dyncfg vnodes ([#19205](https://github.com/netdata/netdata/issues/19205))
- Dyncfg vnodes improvements ([#19207](https://github.com/netdata/netdata/issues/19207))
- Build(deps): bump k8s.io/client-go from 0.31.3 to 0.32.0 in /src/go ([#19210](https://github.com/netdata/netdata/issues/19210))
- Build(deps): bump github.com/vmware/govmomi from 0.46.2 to 0.46.3 ([#19213](https://github.com/netdata/netdata/issues/19213))
- Add dyncfg vnode option to collectors ([#19214](https://github.com/netdata/netdata/issues/19214))
- Fix: use setuid as a fallback for static builds when setcap fails for plugins ([#19215](https://github.com/netdata/netdata/issues/19215))
- Streaming improvements No 8 ([#19206](https://github.com/netdata/netdata/issues/19206))
- Remove ENABLE_H2O=1 from installer ([#19216](https://github.com/netdata/netdata/issues/19216))
- Add pcre2 dev to install-requires-packages.sh ([#19217](https://github.com/netdata/netdata/issues/19217))
- Disable h20 ([#19218](https://github.com/netdata/netdata/issues/19218))
- Removing IP address information. Bumping traefik version ([#19222](https://github.com/netdata/netdata/issues/19222))
- Add dynamic rooms docs ([#19199](https://github.com/netdata/netdata/issues/19199))
- Fix compiler warnings ([#19221](https://github.com/netdata/netdata/issues/19221))
- Fix(ml): remove logging for earch not acquired dimension ([#19226](https://github.com/netdata/netdata/issues/19226))
- Add MegaCli64 to ndsudo ([#19223](https://github.com/netdata/netdata/issues/19223))
- Ci: replace exit 1 with conditional skip in website update workflow ([#19227](https://github.com/netdata/netdata/issues/19227))
- Build(deps): bump github.com/lmittmann/tint from 1.0.5 to 1.0.6 in /src/go ([#19229](https://github.com/netdata/netdata/issues/19229))
- Fix: fix heap use after free in health ([#19228](https://github.com/netdata/netdata/issues/19228))
- Docs: split redistributed and add judy and dlib ([#19230](https://github.com/netdata/netdata/issues/19230))
- Docs: update ui 3rd party link ([#19231](https://github.com/netdata/netdata/issues/19231))
- Fix(go.d/mongodb): add missing disconnect in initClient ([#19232](https://github.com/netdata/netdata/issues/19232))
- Docs: fix win deploy command for nightly ([#19236](https://github.com/netdata/netdata/issues/19236))
- Fix memory leak  ([#19233](https://github.com/netdata/netdata/issues/19233))
- Allow more threads to load contexts during startup ([#19234](https://github.com/netdata/netdata/issues/19234))
- RRDHOST system-info isolation ([#19235](https://github.com/netdata/netdata/issues/19235))
- Feat(go.d.plugin): enable dyncfg vnodes ([#19238](https://github.com/netdata/netdata/issues/19238))
- Update netdata internal metrics ctx ([#19239](https://github.com/netdata/netdata/issues/19239))
- Fix the renamed function under windows ([#19240](https://github.com/netdata/netdata/issues/19240))
- Do not call finalize on shutdown ([#19241](https://github.com/netdata/netdata/issues/19241))
- Avoid blocking waiting for an event during shutdown ([#19244](https://github.com/netdata/netdata/issues/19244))
- Chore(go.d): simplify cli is help ([#19246](https://github.com/netdata/netdata/issues/19246))
- Chore(aclk/mqtt): remove client_id len check ([#19247](https://github.com/netdata/netdata/issues/19247))
- Health transition saving optimization ([#19245](https://github.com/netdata/netdata/issues/19245))
- Use inactive memory when calculating cgroups total memory ([#19249](https://github.com/netdata/netdata/issues/19249))
- Fix static builds to ensure usability on intended baseline hardware. ([#19224](https://github.com/netdata/netdata/issues/19224))

## [2.0.0] - 2024-11-07

### Merged Pull Requests:

- Remove python.d/boinc ([#18397](https://github.com/netdata/netdata/issues/18397))
- Go.d boinc ([#18398](https://github.com/netdata/netdata/issues/18398))
- Regenerate integrations.js ([#18400](https://github.com/netdata/netdata/issues/18400))
- Fix warnings in Dockerfile ([#18395](https://github.com/netdata/netdata/issues/18395))
- Go.d dnsmasqdhcp: simplify parseDHCPRangeValue ([#18401](https://github.com/netdata/netdata/issues/18401))
- Remove python.d/anomalies ([#18402](https://github.com/netdata/netdata/issues/18402))
- Remove pyyaml2 ([#18404](https://github.com/netdata/netdata/issues/18404))
- Imporve netdatacli help usage readability ([#18403](https://github.com/netdata/netdata/issues/18403))
- Fix coverity issues ([#18405](https://github.com/netdata/netdata/issues/18405))
- Kickstart: fix write_claim_config when executed as a regular user ([#18406](https://github.com/netdata/netdata/issues/18406))
- Bump google-github-actions/upload-cloud-storage from 2.1.2 to 2.1.3 ([#18407](https://github.com/netdata/netdata/issues/18407))
- Bump tj-actions/changed-files from 44 to 45 ([#18408](https://github.com/netdata/netdata/issues/18408))
- SPAWN-SERVER: re-evaluate signals even 500ms ([#18411](https://github.com/netdata/netdata/issues/18411))
- Use existing ACLK event loop for cloud queries ([#18218](https://github.com/netdata/netdata/issues/18218))
- Add "smbstatus -P" to ndsudo ([#18414](https://github.com/netdata/netdata/issues/18414))
- Remove python.d/sambsa ([#18413](https://github.com/netdata/netdata/issues/18413))
- Restore /api/v1/badge.svg ([#18416](https://github.com/netdata/netdata/issues/18416))
- Update README.md
- Add go.d samba ([#18418](https://github.com/netdata/netdata/issues/18418))
- Fix hyperlink in go.d samba meta ([#18420](https://github.com/netdata/netdata/issues/18420))
- Regenerate integrations.js ([#18421](https://github.com/netdata/netdata/issues/18421))
- Remove checks.plugin dir ([#18424](https://github.com/netdata/netdata/issues/18424))
- Reset last connected when removing stale nodes with netdatacli ([#18425](https://github.com/netdata/netdata/issues/18425))
- Vendor https://github.com/mdlayher/lmsensors ([#18427](https://github.com/netdata/netdata/issues/18427))
- Go.d lmsensors improve performance ([#18429](https://github.com/netdata/netdata/issues/18429))
- Ci fix InvalidDefaultArgInFrom warn ([#18428](https://github.com/netdata/netdata/issues/18428))
- ACLK code cleanup ([#18417](https://github.com/netdata/netdata/issues/18417))
- Go.d/sensors: add sysfs scan method to collect metrics ([#18431](https://github.com/netdata/netdata/issues/18431))
- Remove charts.d/sensors ([#18426](https://github.com/netdata/netdata/issues/18426))
- Regenerate integrations.js ([#18432](https://github.com/netdata/netdata/issues/18432))
- Go.d remove duplicates in testing ([#18435](https://github.com/netdata/netdata/issues/18435))
- Stream paths propagated to children and parents ([#18430](https://github.com/netdata/netdata/issues/18430))
- Improve agent shutdown time ([#18434](https://github.com/netdata/netdata/issues/18434))
- Remove deadlock from sender ([#18438](https://github.com/netdata/netdata/issues/18438))
- Fix charts.d/sensors leftovers ([#18439](https://github.com/netdata/netdata/issues/18439))
- Fix receiver deadlock ([#18440](https://github.com/netdata/netdata/issues/18440))
- Do not free the sender when the sender thread exits ([#18441](https://github.com/netdata/netdata/issues/18441))
- Claim on Windows ([#18410](https://github.com/netdata/netdata/issues/18410))
- Proper precedence when calculating time_to_evict ([#18444](https://github.com/netdata/netdata/issues/18444))
- Go.d add support for symlinked vnode config files ([#18445](https://github.com/netdata/netdata/issues/18445))
- Go.d remove vnode disable ([#18446](https://github.com/netdata/netdata/issues/18446))
- Exit slabinfo.plugin on EPIPE ([#18448](https://github.com/netdata/netdata/issues/18448))
- Go.d sensors add parsing intrusion to exec method ([#18449](https://github.com/netdata/netdata/issues/18449))
- Regenerate integrations.js ([#18450](https://github.com/netdata/netdata/issues/18450))
- Bump github.com/Masterminds/sprig/v3 from 3.2.3 to 3.3.0 in /src/go ([#18453](https://github.com/netdata/netdata/issues/18453))
- Bump github.com/prometheus/common from 0.55.0 to 0.57.0 in /src/go ([#18452](https://github.com/netdata/netdata/issues/18452))
- Bump github.com/docker/docker from 27.1.2+incompatible to 27.2.0+incompatible in /src/go ([#18451](https://github.com/netdata/netdata/issues/18451))
- Ilert Integration ([#18447](https://github.com/netdata/netdata/issues/18447))
- Regenerate integrations.js ([#18454](https://github.com/netdata/netdata/issues/18454))
- Bump github.com/likexian/whois from 1.15.4 to 1.15.5 in /src/go ([#18457](https://github.com/netdata/netdata/issues/18457))
- Bump github.com/likexian/whois-parser from 1.24.19 to 1.24.20 in /src/go ([#18456](https://github.com/netdata/netdata/issues/18456))
- Bump google-github-actions/upload-cloud-storage from 2.1.3 to 2.2.0 ([#18458](https://github.com/netdata/netdata/issues/18458))
- Netdata-claim.sh: fix parsing url arg ([#18460](https://github.com/netdata/netdata/issues/18460))
- Windows Permissions ([#18443](https://github.com/netdata/netdata/issues/18443))
- Go.d storcli: fix unmarshal driveInfo ([#18466](https://github.com/netdata/netdata/issues/18466))
- Cleanup, rename and packaging fix (Windows Codes) ([#18455](https://github.com/netdata/netdata/issues/18455))
- Fix node index in alerts ([#18469](https://github.com/netdata/netdata/issues/18469))
- Improve processing of pending alerts ([#18470](https://github.com/netdata/netdata/issues/18470))
- W1sensor collector Go implementation ([#18464](https://github.com/netdata/netdata/issues/18464))
- Check correct number of bits for LZC of XOR value. ([#18463](https://github.com/netdata/netdata/issues/18463))
- Remove w1sensor in favor of Go implementation ([#18471](https://github.com/netdata/netdata/issues/18471))
- Added version to systemd-journal info response ([#18474](https://github.com/netdata/netdata/issues/18474))
- Regenerate integrations.js ([#18473](https://github.com/netdata/netdata/issues/18473))
- Config parsers ([#17238](https://github.com/netdata/netdata/issues/17238))
- Prevent sigsegv in config-parsers ([#18476](https://github.com/netdata/netdata/issues/18476))
- Add Access-Control-Allow-Headers: x-netdata-auth ([#18477](https://github.com/netdata/netdata/issues/18477))
- Add Access-Control-Allow-Headers: x-transaction-id ([#18478](https://github.com/netdata/netdata/issues/18478))
- Added missing comma in Access-Control-Allow-Headers ([#18479](https://github.com/netdata/netdata/issues/18479))
- Regenerate integrations.js ([#18475](https://github.com/netdata/netdata/issues/18475))
- Fix win sysinfo installed ram calculation ([#18482](https://github.com/netdata/netdata/issues/18482))
- Update LIbbpf ([#18480](https://github.com/netdata/netdata/issues/18480))
- Bump golang.org/x/text from 0.17.0 to 0.18.0 in /src/go ([#18486](https://github.com/netdata/netdata/issues/18486))
- Bump github.com/prometheus/common from 0.57.0 to 0.58.0 in /src/go ([#18487](https://github.com/netdata/netdata/issues/18487))
- Remove Warnings (ebpf) ([#18484](https://github.com/netdata/netdata/issues/18484))
- Improve processing on removed alerts after agent restart ([#18488](https://github.com/netdata/netdata/issues/18488))
- Remove charts.d/apcupsd ([#18481](https://github.com/netdata/netdata/issues/18481))
- Add go.d/apcupsd ([#18489](https://github.com/netdata/netdata/issues/18489))
- Regenerate integrations.js ([#18493](https://github.com/netdata/netdata/issues/18493))
- Bump github.com/jackc/pgx/v5 from 5.6.0 to 5.7.0 in /src/go ([#18498](https://github.com/netdata/netdata/issues/18498))
- Bump github.com/prometheus/common from 0.58.0 to 0.59.1 in /src/go ([#18497](https://github.com/netdata/netdata/issues/18497))
- Bump golang.org/x/net from 0.28.0 to 0.29.0 in /src/go ([#18496](https://github.com/netdata/netdata/issues/18496))
- Bump peter-evans/create-pull-request from 6 to 7 ([#18495](https://github.com/netdata/netdata/issues/18495))
- Bump github.com/docker/docker from 27.2.0+incompatible to 27.2.1+incompatible in /src/go ([#18502](https://github.com/netdata/netdata/issues/18502))
- Add varnishstat and varnishadm to ndsudo ([#18503](https://github.com/netdata/netdata/issues/18503))
- Remove python.d/varnish ([#18499](https://github.com/netdata/netdata/issues/18499))
- Server dashboard v3 static files, when available ([#18507](https://github.com/netdata/netdata/issues/18507))
- Varnish collector Go implementation ([#18491](https://github.com/netdata/netdata/issues/18491))
- Regenerate integrations.js ([#18508](https://github.com/netdata/netdata/issues/18508))
- Go.d add function to execute a command inside a Docker container ([#18509](https://github.com/netdata/netdata/issues/18509))
- Go.d/varnish: add docker support ([#18512](https://github.com/netdata/netdata/issues/18512))
- Go.d/varnish update meta ([#18516](https://github.com/netdata/netdata/issues/18516))
- Go.d update redis lib to v9 ([#18513](https://github.com/netdata/netdata/issues/18513))
- Bump github.com/jackc/pgx/v5 from 5.7.0 to 5.7.1 in /src/go ([#18515](https://github.com/netdata/netdata/issues/18515))
- Regenerate integrations.js ([#18517](https://github.com/netdata/netdata/issues/18517))
- [WIP] Windows-Events Logs Explorer ([#18483](https://github.com/netdata/netdata/issues/18483))
- Improve netdatacli docs ([#18518](https://github.com/netdata/netdata/issues/18518))
- Remove save-database from netdatacli usage ([#18519](https://github.com/netdata/netdata/issues/18519))
- Go.d/snmp: add an option to automatically create vnode ([#18520](https://github.com/netdata/netdata/issues/18520))
- Regenerate integrations.js ([#18522](https://github.com/netdata/netdata/issues/18522))
- Windows Events: recalculate the length of unicode strings returned every time ([#18525](https://github.com/netdata/netdata/issues/18525))
- Go.d snmp add private enterprise numbers mapping ([#18523](https://github.com/netdata/netdata/issues/18523))
- Go.d snmp: add sys descr, contact and loc as host labels for vnode ([#18527](https://github.com/netdata/netdata/issues/18527))
- Go.d/snmp: add "organization" label (vnode) ([#18529](https://github.com/netdata/netdata/issues/18529))
- Go.d snmp handle multiline sysDescr ([#18530](https://github.com/netdata/netdata/issues/18530))
- Go.d add vnode guid validation ([#18531](https://github.com/netdata/netdata/issues/18531))
- Bump github.com/vmware/govmomi from 0.42.0 to 0.43.0 in /src/go ([#18532](https://github.com/netdata/netdata/issues/18532))
- Go.d snmp fix vnode host labels ([#18534](https://github.com/netdata/netdata/issues/18534))
- Go.d snmp change label name organization->vendor ([#18535](https://github.com/netdata/netdata/issues/18535))
- Windows Plugin Metrics (Thermal and Memory) ([#18494](https://github.com/netdata/netdata/issues/18494))
- Add typesense to apps_groups.conf ([#18537](https://github.com/netdata/netdata/issues/18537))
- Go.d add typesense collector ([#18538](https://github.com/netdata/netdata/issues/18538))
- Go.d typesense: fix name in meta ([#18542](https://github.com/netdata/netdata/issues/18542))
- Regenerate integrations.js ([#18543](https://github.com/netdata/netdata/issues/18543))
- Go.d fix duplicate closeBody func ([#18544](https://github.com/netdata/netdata/issues/18544))
- Go.d pkg web renames ([#18545](https://github.com/netdata/netdata/issues/18545))
- Bump k8s.io/client-go from 0.31.0 to 0.31.1 in /src/go ([#18549](https://github.com/netdata/netdata/issues/18549))
- Go.d move doing http req logic to web ([#18546](https://github.com/netdata/netdata/issues/18546))
- Go.d fix Goland code inspection warnings ([#18552](https://github.com/netdata/netdata/issues/18552))
- Fix some docs issues ([#18553](https://github.com/netdata/netdata/issues/18553))
- Add go.d/nginxunit ([#18554](https://github.com/netdata/netdata/issues/18554))
- Go.d fix typesense/nginxunit meta ([#18556](https://github.com/netdata/netdata/issues/18556))
- Regenerate integrations.js ([#18558](https://github.com/netdata/netdata/issues/18558))
- Add nginx unit to apps_groups.conf ([#18557](https://github.com/netdata/netdata/issues/18557))
- Go.d/prometheus: add label_prefix config option ([#18559](https://github.com/netdata/netdata/issues/18559))
- Regenerate integrations.js ([#18560](https://github.com/netdata/netdata/issues/18560))
- Misc code cleanup ([#18540](https://github.com/netdata/netdata/issues/18540))
- Go.d rename example => testrandom ([#18561](https://github.com/netdata/netdata/issues/18561))
- Fetch metadata by hash for DEB repos. ([#18536](https://github.com/netdata/netdata/issues/18536))
- Assorted build cleanup for external data collection plugins. ([#18501](https://github.com/netdata/netdata/issues/18501))
- Add charts for TCPv4/TCPV6/ICMP errors in windows ([#18526](https://github.com/netdata/netdata/issues/18526))
- Windows Events Improvements 1 ([#18528](https://github.com/netdata/netdata/issues/18528))
- Add cpu model to host labels ([#18562](https://github.com/netdata/netdata/issues/18562))
- Windows Events Improvements 2 ([#18563](https://github.com/netdata/netdata/issues/18563))
- Windows Events Log Explorer improvements 3 ([#18564](https://github.com/netdata/netdata/issues/18564))
- Go.d sd docker: remove unnecessary info message ([#18570](https://github.com/netdata/netdata/issues/18570))
- Go.d/portcheck: add UDP support ([#18569](https://github.com/netdata/netdata/issues/18569))
- Windows Events Log improvements 4 ([#18567](https://github.com/netdata/netdata/issues/18567))
- Regenerate integrations.js ([#18571](https://github.com/netdata/netdata/issues/18571))
- Go.d portcheck update meta ([#18573](https://github.com/netdata/netdata/issues/18573))
- Regenerate integrations.js ([#18574](https://github.com/netdata/netdata/issues/18574))
- Go.d/portcheck schema add tabs ([#18575](https://github.com/netdata/netdata/issues/18575))
- Regenerate integrations.js ([#18576](https://github.com/netdata/netdata/issues/18576))
- Go.d/portcheck: update status duration calculation ([#18577](https://github.com/netdata/netdata/issues/18577))
- WEIGHTS: use node_id when available, otherwise host_id ([#18579](https://github.com/netdata/netdata/issues/18579))
- Reduce connection timeout and fallback to IPV4 for ACLK connections ([#18568](https://github.com/netdata/netdata/issues/18568))
- Go.d move packages ([#18580](https://github.com/netdata/netdata/issues/18580))
- Bump go.mongodb.org/mongo-driver from 1.16.1 to 1.17.0 in /src/go ([#18589](https://github.com/netdata/netdata/issues/18589))
- Bump github.com/docker/docker from 27.2.1+incompatible to 27.3.0+incompatible in /src/go ([#18588](https://github.com/netdata/netdata/issues/18588))
- Update kickstart.sh ([#18587](https://github.com/netdata/netdata/issues/18587))
- Go.d/sensors refactor ([#18581](https://github.com/netdata/netdata/issues/18581))
- Regenerate integrations.js ([#18592](https://github.com/netdata/netdata/issues/18592))
- Go.d/sensors update meta ([#18595](https://github.com/netdata/netdata/issues/18595))
- Go.d/sensors fix meta ([#18597](https://github.com/netdata/netdata/issues/18597))
- Regenerate integrations.js ([#18598](https://github.com/netdata/netdata/issues/18598))
- Bump github.com/docker/docker from 27.3.0+incompatible to 27.3.1+incompatible in /src/go ([#18600](https://github.com/netdata/netdata/issues/18600))
- Add DLLs to CmakeLists.txt ([#18590](https://github.com/netdata/netdata/issues/18590))
- Publish Windows installers on nightly builds. ([#18603](https://github.com/netdata/netdata/issues/18603))
- Add ceph commands to ndsudo ([#18583](https://github.com/netdata/netdata/issues/18583))
- WEB SERVER: retry sending data when errno is EAGAIN ([#18607](https://github.com/netdata/netdata/issues/18607))
- Correctly include Windows installer in release creation. ([#18609](https://github.com/netdata/netdata/issues/18609))
- POST Functions ([#18611](https://github.com/netdata/netdata/issues/18611))
- Feat: HW req for onprem installation. ([#18608](https://github.com/netdata/netdata/issues/18608))
- Go.d/uwsgi: don't write just connect and read ([#18618](https://github.com/netdata/netdata/issues/18618))
- Go.d/hddtemp: connect and read ([#18619](https://github.com/netdata/netdata/issues/18619))
- Revert "Add ceph commands to ndsudo" ([#18620](https://github.com/netdata/netdata/issues/18620))
- Remove python ceph collector implementation ([#18584](https://github.com/netdata/netdata/issues/18584))
- Port Ceph collector to Go ([#18582](https://github.com/netdata/netdata/issues/18582))
- Regenerate integrations.js ([#18627](https://github.com/netdata/netdata/issues/18627))
- Go.d/ceph: fix leftovers [#18582](https://github.com/netdata/netdata/issues/18582) ([#18628](https://github.com/netdata/netdata/issues/18628))
- Go.d/postgres: fix checkpoints query for postgres 17 ([#18629](https://github.com/netdata/netdata/issues/18629))
- Regenerate integrations.js ([#18630](https://github.com/netdata/netdata/issues/18630))
- Go.d pkg/socket: keep only one timeout option ([#18633](https://github.com/netdata/netdata/issues/18633))
- Go.d/smartctl: fix exit status check in scan ([#18635](https://github.com/netdata/netdata/issues/18635))
- Change default pages per extent ([#18623](https://github.com/netdata/netdata/issues/18623))
- Misc mqtt related code cleanup ([#18622](https://github.com/netdata/netdata/issues/18622))
- Remove Python OpenLDAP implementation ([#18626](https://github.com/netdata/netdata/issues/18626))
- Update file names. ([#18638](https://github.com/netdata/netdata/issues/18638))
- Move plugins.d directory outside of collectors ([#18637](https://github.com/netdata/netdata/issues/18637))
- Apps.plugin for windows ([#18594](https://github.com/netdata/netdata/issues/18594))
- Port the OpenLDAP collector from Python to Go ([#18625](https://github.com/netdata/netdata/issues/18625))
- Regenerate integrations.js ([#18647](https://github.com/netdata/netdata/issues/18647))
- Fixed freebsd cpu calculation ([#18648](https://github.com/netdata/netdata/issues/18648))
- Go.d remove duplicate chart check in tests ([#18650](https://github.com/netdata/netdata/issues/18650))
- Use temporary file for commit date check. ([#18646](https://github.com/netdata/netdata/issues/18646))
- Log  agent start / stop timing events ([#18632](https://github.com/netdata/netdata/issues/18632))
- Windows Installer (Silent mode) ([#18613](https://github.com/netdata/netdata/issues/18613))
- Go.d sd fix sprig funcmap ([#18658](https://github.com/netdata/netdata/issues/18658))
- New wording about edit-config script in docs ([#18639](https://github.com/netdata/netdata/issues/18639))
- Bump go toolchain v1.22.8 ([#18659](https://github.com/netdata/netdata/issues/18659))
- Apps.plugin improvements ([#18652](https://github.com/netdata/netdata/issues/18652))
- Handle mqtt ping timeouts ([#18653](https://github.com/netdata/netdata/issues/18653))
- Fix win apps uptime ([#18662](https://github.com/netdata/netdata/issues/18662))
- Docs directory lint documentation and fix issues ([#18660](https://github.com/netdata/netdata/issues/18660))
- Docs lint on `packaging/` dir ([#18665](https://github.com/netdata/netdata/issues/18665))
- Remove python implementation of oracledb ([#18651](https://github.com/netdata/netdata/issues/18651))
- Apps_groups.conf: add oracledb ([#18666](https://github.com/netdata/netdata/issues/18666))
- Regenerate integrations.js ([#18667](https://github.com/netdata/netdata/issues/18667))
- Remove section in python plugin readme ([#18669](https://github.com/netdata/netdata/issues/18669))
- Windows.plugin (IIS) ([#18566](https://github.com/netdata/netdata/issues/18566))
- Add go.d/oracle ([#18654](https://github.com/netdata/netdata/issues/18654))
- Regenerate integrations.js ([#18671](https://github.com/netdata/netdata/issues/18671))
- Add FAQ to SCIM integration doc ([#18664](https://github.com/netdata/netdata/issues/18664))
- Src dir docs pass ([#18670](https://github.com/netdata/netdata/issues/18670))
- Regenerate integrations.js ([#18672](https://github.com/netdata/netdata/issues/18672))
- Adjust content api/v1/info (Windows) ([#18656](https://github.com/netdata/netdata/issues/18656))
- Properly set start/shutdown times to parent/child ([#18668](https://github.com/netdata/netdata/issues/18668))
- Apps plugin improvements2 ([#18673](https://github.com/netdata/netdata/issues/18673))
- Go.d downgrade go-ora to v2.8.20 ([#18677](https://github.com/netdata/netdata/issues/18677))
- Bump github.com/tidwall/gjson from 1.17.3 to 1.18.0 in /src/go ([#18681](https://github.com/netdata/netdata/issues/18681))
- Bump github.com/prometheus/common from 0.59.1 to 0.60.0 in /src/go ([#18680](https://github.com/netdata/netdata/issues/18680))
- Docs fixes ([#18676](https://github.com/netdata/netdata/issues/18676))
- Bump go.mongodb.org/mongo-driver from 1.17.0 to 1.17.1 in /src/go ([#18679](https://github.com/netdata/netdata/issues/18679))
- Regenerate integrations.js ([#18682](https://github.com/netdata/netdata/issues/18682))
- Embed CPU architecture info in Windows installer filename. ([#18661](https://github.com/netdata/netdata/issues/18661))
- Go.d/chrony: collect serverstats using chronyc ([#18685](https://github.com/netdata/netdata/issues/18685))
- Regenerate integrations.js ([#18686](https://github.com/netdata/netdata/issues/18686))
- UTF8 support for chart ids, names and other metadata ([#18684](https://github.com/netdata/netdata/issues/18684))
- Fix sanitization issues ([#18687](https://github.com/netdata/netdata/issues/18687))
- Add MSSQL metrics (Part I). ([#18591](https://github.com/netdata/netdata/issues/18591))
- Send node info update after ACLK connection timeout ([#18683](https://github.com/netdata/netdata/issues/18683))
- Fix(cgroups.plugin): handle containers no env vars ([#18691](https://github.com/netdata/netdata/issues/18691))
- Go.d/nvidia_smi: use configured "timeout" in loop mode ([#18692](https://github.com/netdata/netdata/issues/18692))
- Regenerate integrations.js ([#18693](https://github.com/netdata/netdata/issues/18693))
- Cgroups.plugin: call `setresuid` before spawn server init ([#18694](https://github.com/netdata/netdata/issues/18694))
- Fix ram usage calculation in LXC ([#18695](https://github.com/netdata/netdata/issues/18695))
- Fix system-info disk space in LXC ([#18696](https://github.com/netdata/netdata/issues/18696))
- Bump golang.org/x/net from 0.29.0 to 0.30.0 in /src/go ([#18701](https://github.com/netdata/netdata/issues/18701))
- Improve apps.plugin readme ([#18705](https://github.com/netdata/netdata/issues/18705))
- Update windows documentation ([#18703](https://github.com/netdata/netdata/issues/18703))
- Feat(go.d/sensors): add a config option to update/add sensor label value ([#18707](https://github.com/netdata/netdata/issues/18707))
- Detect when swap is disabled when agent is running ([#18702](https://github.com/netdata/netdata/issues/18702))
- Fix wrong config file name in go.d/oracledb meta ([#18709](https://github.com/netdata/netdata/issues/18709))
- Regenerate integrations.js ([#18708](https://github.com/netdata/netdata/issues/18708))
- Add link to meta section on integrations template ([#18713](https://github.com/netdata/netdata/issues/18713))
- Regenerate integrations.js ([#18714](https://github.com/netdata/netdata/issues/18714))
- Add instructions to configure SCIM integration in Okta ([#18710](https://github.com/netdata/netdata/issues/18710))
- Regenerate integrations.js ([#18715](https://github.com/netdata/netdata/issues/18715))
- Go.d: use lib function to check if stderr connected to journal ([#18718](https://github.com/netdata/netdata/issues/18718))
- Add check for 64bit builtin atomics ([#18565](https://github.com/netdata/netdata/issues/18565))
- Windows Plugin metadata ([#18599](https://github.com/netdata/netdata/issues/18599))
- Fix(go.d/portcheck): stop checking UDP ports on ICMP listen error ([#18721](https://github.com/netdata/netdata/issues/18721))
- Fix logs POST query payload parsing ([#18722](https://github.com/netdata/netdata/issues/18722))
- Reset the log sources to apply user selection ([#18725](https://github.com/netdata/netdata/issues/18725))
- Apps.plugin: print also the original comm ([#18727](https://github.com/netdata/netdata/issues/18727))
- Systemd-cat-native negative timeout ([#18729](https://github.com/netdata/netdata/issues/18729))
- Pass correct GOOS and GOARCH on to package builders in CI. ([#18717](https://github.com/netdata/netdata/issues/18717))
- Windows installer (Change descriptions add helping) ([#18711](https://github.com/netdata/netdata/issues/18711))
- Fix handling of workflow artifacts. ([#18726](https://github.com/netdata/netdata/issues/18726))
- Improve windows installer ([#18649](https://github.com/netdata/netdata/issues/18649))
- Fix(perf.plugin): disable if all events disabled during init ([#18728](https://github.com/netdata/netdata/issues/18728))
- [storcli] Support for controller ROC temperature. ([#18732](https://github.com/netdata/netdata/issues/18732))
- Static install: bump openssl and curl to latest stable versions ([#18719](https://github.com/netdata/netdata/issues/18719))
- Apps.plugin; allow parents to identify the children ([#18734](https://github.com/netdata/netdata/issues/18734))
- MSSQL Metrics (Part II). ([#18689](https://github.com/netdata/netdata/issues/18689))
- Fix(go.d/sensors): fix parsing power accuracy ([#18735](https://github.com/netdata/netdata/issues/18735))
- Delay child disconnect update ([#18712](https://github.com/netdata/netdata/issues/18712))
- Windows deploy metadata ([#18733](https://github.com/netdata/netdata/issues/18733))
- Sanitizers should not remove trailing underscores ([#18738](https://github.com/netdata/netdata/issues/18738))
- Add `ilert` cloud notification integration ([#18736](https://github.com/netdata/netdata/issues/18736))
- Docs(apps.plugin): fix prefix/suffix pattern example ([#18742](https://github.com/netdata/netdata/issues/18742))
- Feat(go.d/nvme): add model_number label ([#18741](https://github.com/netdata/netdata/issues/18741))
- Regenerate integrations.js ([#18720](https://github.com/netdata/netdata/issues/18720))
- Fix(apps.plugin): fix debug msg spam on macOS/freeBSD ([#18743](https://github.com/netdata/netdata/issues/18743))
- Fix crash on agent initialization ([#18746](https://github.com/netdata/netdata/issues/18746))
- Fix issues with Cloud Notification Integrations metadata ([#18745](https://github.com/netdata/netdata/issues/18745))
- Simplify sentence on cloud notification integrations ([#18750](https://github.com/netdata/netdata/issues/18750))
- Fix(freebsd.plugin): fix sysctl arcstats.p fails on FreeBSD 14 ([#18748](https://github.com/netdata/netdata/issues/18748))
- Fix(python.d.plugin): fix plugin exit if no python found ([#18747](https://github.com/netdata/netdata/issues/18747))
- Regenerate integrations.js ([#18749](https://github.com/netdata/netdata/issues/18749))
- Remove CR (windows.plugin) ([#18737](https://github.com/netdata/netdata/issues/18737))
- Update metadata.yaml ([#18755](https://github.com/netdata/netdata/issues/18755))
- Regenerate integrations.js ([#18756](https://github.com/netdata/netdata/issues/18756))
- Add Ubuntu 24.10 and Fedora 41 to CI. ([#18753](https://github.com/netdata/netdata/issues/18753))
- Fix(go.d/sd/net_listeners): exit if local-listeners constantly times out ([#18757](https://github.com/netdata/netdata/issues/18757))
- Local-listeners without libmnl ([#18759](https://github.com/netdata/netdata/issues/18759))
- SPAWN SERVER: close all open fds on callback ([#18764](https://github.com/netdata/netdata/issues/18764))
- Fix(proc.plugin/zfs): fix arcstats.pm ([#18758](https://github.com/netdata/netdata/issues/18758))
- Adjust option (Windows claim) ([#18763](https://github.com/netdata/netdata/issues/18763))
- Bump github.com/sijms/go-ora/v2 from 2.8.20 to 2.8.22 in /src/go ([#18767](https://github.com/netdata/netdata/issues/18767))
- Bump github.com/bmatcuk/doublestar/v4 from 4.6.1 to 4.7.1 in /src/go ([#18768](https://github.com/netdata/netdata/issues/18768))
- Bump github.com/vmware/govmomi from 0.43.0 to 0.44.1 in /src/go ([#18766](https://github.com/netdata/netdata/issues/18766))
- Remove the overview section from cloud notif. integrations ([#18754](https://github.com/netdata/netdata/issues/18754))
- Regenerate integrations.js ([#18771](https://github.com/netdata/netdata/issues/18771))
- NetFramework (Part I) ([#18762](https://github.com/netdata/netdata/issues/18762))
- Fix(go.d/sd/netlisteners): fix exec deadline exceeded check ([#18774](https://github.com/netdata/netdata/issues/18774))
- Fix storing of repeat field ([#18760](https://github.com/netdata/netdata/issues/18760))
- Fix(go.d/apcupsd): fix ups_load value divided by 100 ([#18780](https://github.com/netdata/netdata/issues/18780))
- Log to windows ([#18688](https://github.com/netdata/netdata/issues/18688))
- Sqlite upgrade to version 3.46.1 ([#18772](https://github.com/netdata/netdata/issues/18772))
- Expand ml enabled option ([#18761](https://github.com/netdata/netdata/issues/18761))
- Load chart labels on demand ([#18699](https://github.com/netdata/netdata/issues/18699))
- Update README.md, fix a typo ([#18781](https://github.com/netdata/netdata/issues/18781))
- Document ML enabled `auto` ([#18784](https://github.com/netdata/netdata/issues/18784))
- Bump github.com/redis/go-redis/v9 from 9.6.1 to 9.6.2 in /src/go ([#18783](https://github.com/netdata/netdata/issues/18783))
- Fix(netdata-updater.sh): ensure `--non-interactive` flag is passed during self-update ([#18786](https://github.com/netdata/netdata/issues/18786))
- Windows Alerts Improvements ([#18785](https://github.com/netdata/netdata/issues/18785))
- Fix broken claiming via kickstart on some systems. ([#18789](https://github.com/netdata/netdata/issues/18789))
- Systemd-journal; support querying archived files ([#18792](https://github.com/netdata/netdata/issues/18792))
- Add ref to dyncfg ([#18793](https://github.com/netdata/netdata/issues/18793))
- Ιmplementation to add logs integrations ([#18791](https://github.com/netdata/netdata/issues/18791))
- Regenerate integrations.js ([#18794](https://github.com/netdata/netdata/issues/18794))
- Unify claiming response json ([#18777](https://github.com/netdata/netdata/issues/18777))
- Windows fixes (chart labels and warnings) ([#18796](https://github.com/netdata/netdata/issues/18796))
- Fix atomic builtins test that currently fails for llvm+compiler_rt when gcc is not present ([#18788](https://github.com/netdata/netdata/issues/18788))
- Schedule a node state update after context load ([#18795](https://github.com/netdata/netdata/issues/18795))
- Docs: fix grammar in readme ([#18799](https://github.com/netdata/netdata/issues/18799))
- Bugfix for logs integrations ([#18800](https://github.com/netdata/netdata/issues/18800))
- Regenerate integrations.js ([#18801](https://github.com/netdata/netdata/issues/18801))
- Feat(apps.plugin): add vernemq to apps_groups.conf ([#18802](https://github.com/netdata/netdata/issues/18802))
- Remove macOS 12 from CI, and add macOS 15. ([#18797](https://github.com/netdata/netdata/issues/18797))
- Local-listeners improvements ([#18798](https://github.com/netdata/netdata/issues/18798))
- Cgroup-network now uses its own spawn server ([#18674](https://github.com/netdata/netdata/issues/18674))
- Fix(go.d/sensors): ignore 'unknown' values ([#18806](https://github.com/netdata/netdata/issues/18806))
- Allow local-listeners to associate container sockets with pids ([#18807](https://github.com/netdata/netdata/issues/18807))
- Aesthetic changes in the code ([#18808](https://github.com/netdata/netdata/issues/18808))
- Calculate currently collected metrics ([#18803](https://github.com/netdata/netdata/issues/18803))
- Fix(proc/proc_net_dev): delay collecting all virtual interfaces ([#18812](https://github.com/netdata/netdata/issues/18812))
- Fix variable scope to prevent invalid memory access ([#18813](https://github.com/netdata/netdata/issues/18813))
- Comment out dictionary with hashtable code for now ([#18814](https://github.com/netdata/netdata/issues/18814))
- Claiming should wait for node id and status ONLINE only ([#18816](https://github.com/netdata/netdata/issues/18816))
- Revert "Fix atomic builtins test that currently fails for llvm+compiler_rt when gcc is not present" ([#18811](https://github.com/netdata/netdata/issues/18811))
- Optimizations for servers with vast amounts of sockets ([#18820](https://github.com/netdata/netdata/issues/18820))
- Windows storage metrics ([#18810](https://github.com/netdata/netdata/issues/18810))
- Fixes last PR merge ([#18821](https://github.com/netdata/netdata/issues/18821))
- Numa basic meminfo ([#18822](https://github.com/netdata/netdata/issues/18822))
- Fix compilation on windows ([#18823](https://github.com/netdata/netdata/issues/18823))
- More windows metrics ([#18824](https://github.com/netdata/netdata/issues/18824))
- Fix(go.d/vernemq)!: support prometheus namespace added in v2.0 ([#18815](https://github.com/netdata/netdata/issues/18815))
- Regenerate integrations.js ([#18826](https://github.com/netdata/netdata/issues/18826))
- Common O/S Caching Layer for users and groups ([#18825](https://github.com/netdata/netdata/issues/18825))
- Build(deps): bump github.com/redis/go-redis/v9 from 9.6.2 to 9.7.0 in /src/go ([#18828](https://github.com/netdata/netdata/issues/18828))
- Remove old obsolete check for excess data in request ([#18830](https://github.com/netdata/netdata/issues/18830))
- Add the Windows event logs integration to the meta ([#18829](https://github.com/netdata/netdata/issues/18829))
- Feat(go.d/nvidia_smi): add "index" label to GPU charts ([#18833](https://github.com/netdata/netdata/issues/18833))
- Chore(go.d/vernemq): remove unused file ([#18835](https://github.com/netdata/netdata/issues/18835))
- Regenerate integrations.js ([#18834](https://github.com/netdata/netdata/issues/18834))
- Remove RRDSET_FLAG_DETAIL. ([#18837](https://github.com/netdata/netdata/issues/18837))
- Spawn-server-nofork: invalid magic ([#18831](https://github.com/netdata/netdata/issues/18831))
- Update enterprise SSO docs ([#18836](https://github.com/netdata/netdata/issues/18836))
- Feat(go.d/vernemq): add "Queued PUBLISH Messages" chart ([#18838](https://github.com/netdata/netdata/issues/18838))
- Regenerate integrations.js ([#18839](https://github.com/netdata/netdata/issues/18839))
- Un-vendor proprietary dashboard code. ([#18437](https://github.com/netdata/netdata/issues/18437))
- Docs(web/gui): remove legacy dashboard description ([#18841](https://github.com/netdata/netdata/issues/18841))
- Silence up-to-date installation targets. ([#18842](https://github.com/netdata/netdata/issues/18842))
- Fix(packaging): fix installing libcurl_dev on FreeBSD ([#18845](https://github.com/netdata/netdata/issues/18845))
- Feat(go.d/sd/nl): make timeout and interval configurable ([#18847](https://github.com/netdata/netdata/issues/18847))
- Fix(packaging): check for sys/capability.h only on Linux ([#18849](https://github.com/netdata/netdata/issues/18849))
- Reorganize top-level headers in libnetdata. ([#18643](https://github.com/netdata/netdata/issues/18643))
- Make integration links absolute ([#18851](https://github.com/netdata/netdata/issues/18851))
- Regenerate integrations.js ([#18852](https://github.com/netdata/netdata/issues/18852))
- Do not load/save context data in RAM mode ([#18790](https://github.com/netdata/netdata/issues/18790))
- Chore(ci): print versions in check_successful_update ([#18853](https://github.com/netdata/netdata/issues/18853))
- Build(deps): bump github.com/vmware/govmomi from 0.44.1 to 0.45.0 in /src/go ([#18854](https://github.com/netdata/netdata/issues/18854))
- Feat(proc/numa): add numa node mem activity ([#18855](https://github.com/netdata/netdata/issues/18855))
- Fix(apps.plugin): add tini to Linux managers ([#18856](https://github.com/netdata/netdata/issues/18856))
- Feat(go.d.plugin): add MaxScale collector ([#18859](https://github.com/netdata/netdata/issues/18859))
- Regenerate integrations.js ([#18860](https://github.com/netdata/netdata/issues/18860))
- Do not build H2O by default. ([#18861](https://github.com/netdata/netdata/issues/18861))
- Prevent memory corruption during ACLK OTP decode ([#18863](https://github.com/netdata/netdata/issues/18863))
- Docs(go.d/ping): clarify permissions ([#18868](https://github.com/netdata/netdata/issues/18868))
- Regenerate integrations.js ([#18869](https://github.com/netdata/netdata/issues/18869))
- Fix: correct health schema typo preventing Action alert rendering. ([#18871](https://github.com/netdata/netdata/issues/18871))
- Fix corruption in expression value replacement ([#18865](https://github.com/netdata/netdata/issues/18865))
- Build(deps): bump k8s.io/client-go from 0.31.1 to 0.31.2 in /src/go ([#18873](https://github.com/netdata/netdata/issues/18873))
- Build(deps): bump github.com/prometheus/common from 0.60.0 to 0.60.1 in /src/go ([#18874](https://github.com/netdata/netdata/issues/18874))
- Build(deps): bump github.com/vmware/govmomi from 0.45.0 to 0.45.1 in /src/go ([#18872](https://github.com/netdata/netdata/issues/18872))
- Fix: correct go.d.plugin permission for source builds ([#18876](https://github.com/netdata/netdata/issues/18876))
- Include windows.h globally in libnetdata ([#18878](https://github.com/netdata/netdata/issues/18878))
- Adjust text_sanitizer to accept the default value ([#18870](https://github.com/netdata/netdata/issues/18870))
- Windows storage fixes ([#18880](https://github.com/netdata/netdata/issues/18880))
- Build(deps): bump azure/trusted-signing-action from 0.4.0 to 0.5.0 ([#18883](https://github.com/netdata/netdata/issues/18883))
- Properly sanitize prometheus names and values ([#18884](https://github.com/netdata/netdata/issues/18884))
- Fix(go.d/k8sstate): use static list of warning/terminated reasons ([#18885](https://github.com/netdata/netdata/issues/18885))
- Improvement(go.d/k8sstate): collect pod status reason ([#18887](https://github.com/netdata/netdata/issues/18887))
- Regenerate integrations.js ([#18886](https://github.com/netdata/netdata/issues/18886))
- Remove python.d/spigotmc ([#18889](https://github.com/netdata/netdata/issues/18889))
- Feat(go.d.plugin): add spigotmc collector ([#18890](https://github.com/netdata/netdata/issues/18890))
- Regenerate integrations.js ([#18891](https://github.com/netdata/netdata/issues/18891))
- Log2journal: fix config parsing memory leaks ([#18893](https://github.com/netdata/netdata/issues/18893))
- Fix coverity issues ([#18892](https://github.com/netdata/netdata/issues/18892))
- Start-stop-restart for windows, plus move info to its own file ([#18894](https://github.com/netdata/netdata/issues/18894))
- Docs edit ([#18895](https://github.com/netdata/netdata/issues/18895))
- Remove python.d/zscores ([#18897](https://github.com/netdata/netdata/issues/18897))
- Regenerate integrations.js ([#18899](https://github.com/netdata/netdata/issues/18899))
- Coverity fixes ([#18896](https://github.com/netdata/netdata/issues/18896))
- Add basis for MSI installer. ([#18787](https://github.com/netdata/netdata/issues/18787))
- Chore(go.d.plugin): add build tags to modules ([#18900](https://github.com/netdata/netdata/issues/18900))
- Regenerate integrations.js ([#18901](https://github.com/netdata/netdata/issues/18901))
- Updating Netdata docs ([#18898](https://github.com/netdata/netdata/issues/18898))
- Versioning for functions ([#18902](https://github.com/netdata/netdata/issues/18902))
- Update uninstallation docs and remove reinstallation page ([#18907](https://github.com/netdata/netdata/issues/18907))
- Uninstall docs edits ([#18908](https://github.com/netdata/netdata/issues/18908))
- Fix(debugfs/extfrag): add zone label ([#18910](https://github.com/netdata/netdata/issues/18910))
- Proc.plugin: log as info if a dir not exists ([#18909](https://github.com/netdata/netdata/issues/18909))
- Fix potential wait forever in mqtt loop ([#18913](https://github.com/netdata/netdata/issues/18913))
- Fix a potential invalid double free memory ([#18905](https://github.com/netdata/netdata/issues/18905))
- Docs: fix broken links in metadata ([#18915](https://github.com/netdata/netdata/issues/18915))
- Regenerate integrations.js ([#18917](https://github.com/netdata/netdata/issues/18917))
- Build(deps): bump github.com/fsnotify/fsnotify from 1.7.0 to 1.8.0 in /src/go ([#18920](https://github.com/netdata/netdata/issues/18920))
- Docs: fix ui license link ([#18918](https://github.com/netdata/netdata/issues/18918))
- Log2journal now uses libnetdata ([#18919](https://github.com/netdata/netdata/issues/18919))
- Go.d/portcheck: separate tabs for tcp/upd ports ([#18922](https://github.com/netdata/netdata/issues/18922))
- Add `dagster` to apps_groups.conf ([#18912](https://github.com/netdata/netdata/issues/18912))
- Docs: small fixes and pass on sizing Agents ([#18923](https://github.com/netdata/netdata/issues/18923))
- Chore(go.d/nvidia_smi): remove use_csv_format (deprecated) from config ([#18924](https://github.com/netdata/netdata/issues/18924))
- Update CI to generate MSI installer for Windows using WiX. ([#18914](https://github.com/netdata/netdata/issues/18914))
- Update Libbpf ([#18921](https://github.com/netdata/netdata/issues/18921))
- Fix release generation in build workflow.
- Add randomness per thread to heartbeat ([#18929](https://github.com/netdata/netdata/issues/18929))
- Docs: Changes to title and CPU requirements ([#18925](https://github.com/netdata/netdata/issues/18925))
- Installation section simplification ([#18911](https://github.com/netdata/netdata/issues/18911))
- Improve the documentation on removing stale nodes ([#18927](https://github.com/netdata/netdata/issues/18927))
- Regenerate integrations.js ([#18932](https://github.com/netdata/netdata/issues/18932))
- Better randomness for heartbeat ([#18930](https://github.com/netdata/netdata/issues/18930))
- Add hyper-v metrics ([#18697](https://github.com/netdata/netdata/issues/18697))
- Fix(go.d/prometheus): correct unsupported protocol scheme "file" error ([#18938](https://github.com/netdata/netdata/issues/18938))
- Improve ACLK sync CPU usage ([#18935](https://github.com/netdata/netdata/issues/18935))
- Random numbers improvements ([#18939](https://github.com/netdata/netdata/issues/18939))
- Random numbers No 3 ([#18940](https://github.com/netdata/netdata/issues/18940))
- Docs: grammar/format fixes to `docs/netdata-agent/` ([#18942](https://github.com/netdata/netdata/issues/18942))
- Streaming re-organization ([#18941](https://github.com/netdata/netdata/issues/18941))
- Switch DEB/RPM repositories to new subdomain. ([#18916](https://github.com/netdata/netdata/issues/18916))
- Hyper collector fixes ([#18934](https://github.com/netdata/netdata/issues/18934))
- Docs: fix Caddy docker compose example ([#18944](https://github.com/netdata/netdata/issues/18944))
- Fix memory leak when using libcurl ([#18947](https://github.com/netdata/netdata/issues/18947))
- Docs: add "Plugin Privileges" section ([#18946](https://github.com/netdata/netdata/issues/18946))
- Docs: simplify go.d.plugin readme ([#18949](https://github.com/netdata/netdata/issues/18949))
- Fix br elements ([#18952](https://github.com/netdata/netdata/issues/18952))
- Update README.md ([#18954](https://github.com/netdata/netdata/issues/18954))
- Chore(go.d.plugin): remove duplicate logging in init/check ([#18955](https://github.com/netdata/netdata/issues/18955))
- Build(deps): bump github.com/vmware/govmomi from 0.45.1 to 0.46.0 in /src/go ([#18959](https://github.com/netdata/netdata/issues/18959))
- Adjust max possible extent size ([#18960](https://github.com/netdata/netdata/issues/18960))
- Build(deps): update go toolchain to v1.23.3 ([#18961](https://github.com/netdata/netdata/issues/18961))
- MSI Improvements ([#18903](https://github.com/netdata/netdata/issues/18903))
- Precompile Python code on Windows. ([#18951](https://github.com/netdata/netdata/issues/18951))
- Adjust API version ([#18906](https://github.com/netdata/netdata/issues/18906))
- Include Windows artifacts for all builds, not just nightlies.
- Properly create release branch for major releases.

## [1.99.0] - 2024-08-23

### Merged Pull Requests:

- WIP - Netdata v2 ([#18125](https://github.com/netdata/netdata/issues/18125))
- Bump version to v1.99.0 for v2.0 prerelease nightlies.

