// Code generated by metricgen; DO NOT EDIT.
// source: contexts.yaml

package contexts

import (
	"github.com/netdata/netdata/go/plugins/plugin/go.d/agent/module"
	"github.com/netdata/netdata/go/plugins/plugin/ibm.d/framework"
	"strings"
)

// cleanLabelValue cleans a label value for use in instance/dimension IDs
func cleanLabelValue(value string) string {
	// Replace problematic characters
	r := strings.NewReplacer(
		" ", "_",
		".", "_",
		"-", "_",
		"/", "_",
		":", "_",
		"=", "_",
		",", "_",
		"(", "_",
		")", "_",
	)
	return strings.ToLower(r.Replace(value))
}

// EmptyLabels is used for contexts without labels
type EmptyLabels struct{}

// InstanceID for empty labels just returns the context name
func (EmptyLabels) InstanceID(contextName string) string {
	return contextName
}

// --- ActiveJob ---

// ActiveJobCPUValues defines the type-safe values for ActiveJob.CPU context
type ActiveJobCPUValues struct {
	Cpu int64
}

// ActiveJobCPUContext provides type-safe operations for ActiveJob.CPU context
type ActiveJobCPUContext struct {
	framework.Context[ActiveJobLabels]
}

// Set provides type-safe dimension setting for ActiveJob.CPU context
func (c ActiveJobCPUContext) Set(state *framework.CollectorState, labels ActiveJobLabels, values ActiveJobCPUValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"cpu": values.Cpu,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ActiveJobCPUContext) SetUpdateEvery(state *framework.CollectorState, labels ActiveJobLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ActiveJobResourcesValues defines the type-safe values for ActiveJob.Resources context
type ActiveJobResourcesValues struct {
	Temp_storage int64
}

// ActiveJobResourcesContext provides type-safe operations for ActiveJob.Resources context
type ActiveJobResourcesContext struct {
	framework.Context[ActiveJobLabels]
}

// Set provides type-safe dimension setting for ActiveJob.Resources context
func (c ActiveJobResourcesContext) Set(state *framework.CollectorState, labels ActiveJobLabels, values ActiveJobResourcesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"temp_storage": values.Temp_storage,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ActiveJobResourcesContext) SetUpdateEvery(state *framework.CollectorState, labels ActiveJobLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ActiveJobTimeValues defines the type-safe values for ActiveJob.Time context
type ActiveJobTimeValues struct {
	Cpu_time   int64
	Total_time int64
}

// ActiveJobTimeContext provides type-safe operations for ActiveJob.Time context
type ActiveJobTimeContext struct {
	framework.Context[ActiveJobLabels]
}

// Set provides type-safe dimension setting for ActiveJob.Time context
func (c ActiveJobTimeContext) Set(state *framework.CollectorState, labels ActiveJobLabels, values ActiveJobTimeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"cpu_time":   values.Cpu_time,
		"total_time": values.Total_time,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ActiveJobTimeContext) SetUpdateEvery(state *framework.CollectorState, labels ActiveJobLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ActiveJobActivityValues defines the type-safe values for ActiveJob.Activity context
type ActiveJobActivityValues struct {
	Disk_io                  int64
	Interactive_transactions int64
}

// ActiveJobActivityContext provides type-safe operations for ActiveJob.Activity context
type ActiveJobActivityContext struct {
	framework.Context[ActiveJobLabels]
}

// Set provides type-safe dimension setting for ActiveJob.Activity context
func (c ActiveJobActivityContext) Set(state *framework.CollectorState, labels ActiveJobLabels, values ActiveJobActivityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"disk_io":                  values.Disk_io,
		"interactive_transactions": values.Interactive_transactions,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ActiveJobActivityContext) SetUpdateEvery(state *framework.CollectorState, labels ActiveJobLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ActiveJobThreadsValues defines the type-safe values for ActiveJob.Threads context
type ActiveJobThreadsValues struct {
	Threads int64
}

// ActiveJobThreadsContext provides type-safe operations for ActiveJob.Threads context
type ActiveJobThreadsContext struct {
	framework.Context[ActiveJobLabels]
}

// Set provides type-safe dimension setting for ActiveJob.Threads context
func (c ActiveJobThreadsContext) Set(state *framework.CollectorState, labels ActiveJobLabels, values ActiveJobThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"threads": values.Threads,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ActiveJobThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels ActiveJobLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// ActiveJobLabels defines the required labels for ActiveJob contexts
type ActiveJobLabels struct {
	Job_name   string
	Job_status string
	Subsystem  string
	Job_type   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l ActiveJobLabels) InstanceID(contextName string) string {
	// Label order from YAML: job_name, job_status, subsystem, job_type
	return contextName + "." + cleanLabelValue(l.Job_name) + "_" + cleanLabelValue(l.Job_status) + "_" + cleanLabelValue(l.Subsystem) + "_" + cleanLabelValue(l.Job_type)
}

// ActiveJob contains all metric contexts for ActiveJob
var ActiveJob = struct {
	CPU       ActiveJobCPUContext
	Resources ActiveJobResourcesContext
	Time      ActiveJobTimeContext
	Activity  ActiveJobActivityContext
	Threads   ActiveJobThreadsContext
}{
	CPU: ActiveJobCPUContext{
		Context: framework.Context[ActiveJobLabels]{
			Name:        "as400.activejob_cpu",
			Family:      "workloads/active_jobs",
			Title:       "Active Job CPU Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    506,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "cpu",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_name",
				"job_status",
				"subsystem",
				"job_type",
			},
		},
	},
	Resources: ActiveJobResourcesContext{
		Context: framework.Context[ActiveJobLabels]{
			Name:        "as400.activejob_resources",
			Family:      "workloads/active_jobs",
			Title:       "Active Job Resources",
			Units:       "MiB",
			Type:        module.Stacked,
			Priority:    507,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "temp_storage",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_name",
				"job_status",
				"subsystem",
				"job_type",
			},
		},
	},
	Time: ActiveJobTimeContext{
		Context: framework.Context[ActiveJobLabels]{
			Name:        "as400.activejob_time",
			Family:      "workloads/active_jobs",
			Title:       "Active Job Elapsed Time",
			Units:       "seconds",
			Type:        module.Line,
			Priority:    508,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "cpu_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "total_time",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_name",
				"job_status",
				"subsystem",
				"job_type",
			},
		},
	},
	Activity: ActiveJobActivityContext{
		Context: framework.Context[ActiveJobLabels]{
			Name:        "as400.activejob_activity",
			Family:      "workloads/active_jobs",
			Title:       "Active Job Activity",
			Units:       "operations/s",
			Type:        module.Area,
			Priority:    509,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "disk_io",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "interactive_transactions",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_name",
				"job_status",
				"subsystem",
				"job_type",
			},
		},
	},
	Threads: ActiveJobThreadsContext{
		Context: framework.Context[ActiveJobLabels]{
			Name:        "as400.activejob_threads",
			Family:      "workloads/active_jobs",
			Title:       "Active Job Thread Count",
			Units:       "threads",
			Type:        module.Line,
			Priority:    510,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "threads",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_name",
				"job_status",
				"subsystem",
				"job_type",
			},
		},
	},
}

// --- Disk ---

// DiskBusyValues defines the type-safe values for Disk.Busy context
type DiskBusyValues struct {
	Busy int64
}

// DiskBusyContext provides type-safe operations for Disk.Busy context
type DiskBusyContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.Busy context
func (c DiskBusyContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskBusyValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"busy": values.Busy,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskBusyContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskIORequestsValues defines the type-safe values for Disk.IORequests context
type DiskIORequestsValues struct {
	Read  int64
	Write int64
}

// DiskIORequestsContext provides type-safe operations for Disk.IORequests context
type DiskIORequestsContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.IORequests context
func (c DiskIORequestsContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskIORequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":  values.Read,
		"write": values.Write,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskIORequestsContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskSpaceUsageValues defines the type-safe values for Disk.SpaceUsage context
type DiskSpaceUsageValues struct {
	Used int64
}

// DiskSpaceUsageContext provides type-safe operations for Disk.SpaceUsage context
type DiskSpaceUsageContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.SpaceUsage context
func (c DiskSpaceUsageContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskSpaceUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskSpaceUsageContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskCapacityValues defines the type-safe values for Disk.Capacity context
type DiskCapacityValues struct {
	Available int64
	Used      int64
}

// DiskCapacityContext provides type-safe operations for Disk.Capacity context
type DiskCapacityContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.Capacity context
func (c DiskCapacityContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskCapacityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"available": values.Available,
		"used":      values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskCapacityContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskBlocksValues defines the type-safe values for Disk.Blocks context
type DiskBlocksValues struct {
	Read  int64
	Write int64
}

// DiskBlocksContext provides type-safe operations for Disk.Blocks context
type DiskBlocksContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.Blocks context
func (c DiskBlocksContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskBlocksValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"read":  values.Read,
		"write": values.Write,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskBlocksContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskSSDHealthValues defines the type-safe values for Disk.SSDHealth context
type DiskSSDHealthValues struct {
	Life_remaining int64
}

// DiskSSDHealthContext provides type-safe operations for Disk.SSDHealth context
type DiskSSDHealthContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.SSDHealth context
func (c DiskSSDHealthContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskSSDHealthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"life_remaining": values.Life_remaining,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskSSDHealthContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskSSDPowerOnValues defines the type-safe values for Disk.SSDPowerOn context
type DiskSSDPowerOnValues struct {
	Power_on_days int64
}

// DiskSSDPowerOnContext provides type-safe operations for Disk.SSDPowerOn context
type DiskSSDPowerOnContext struct {
	framework.Context[DiskLabels]
}

// Set provides type-safe dimension setting for Disk.SSDPowerOn context
func (c DiskSSDPowerOnContext) Set(state *framework.CollectorState, labels DiskLabels, values DiskSSDPowerOnValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"power_on_days": values.Power_on_days,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c DiskSSDPowerOnContext) SetUpdateEvery(state *framework.CollectorState, labels DiskLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// DiskLabels defines the required labels for Disk contexts
type DiskLabels struct {
	Disk_unit          string
	Disk_type          string
	Disk_model         string
	Hardware_status    string
	Disk_serial_number string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l DiskLabels) InstanceID(contextName string) string {
	// Label order from YAML: disk_unit, disk_type, disk_model, hardware_status, disk_serial_number
	return contextName + "." + cleanLabelValue(l.Disk_unit) + "_" + cleanLabelValue(l.Disk_type) + "_" + cleanLabelValue(l.Disk_model) + "_" + cleanLabelValue(l.Hardware_status) + "_" + cleanLabelValue(l.Disk_serial_number)
}

// Disk contains all metric contexts for Disk
var Disk = struct {
	Busy       DiskBusyContext
	IORequests DiskIORequestsContext
	SpaceUsage DiskSpaceUsageContext
	Capacity   DiskCapacityContext
	Blocks     DiskBlocksContext
	SSDHealth  DiskSSDHealthContext
	SSDPowerOn DiskSSDPowerOnContext
}{
	Busy: DiskBusyContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_busy",
			Family:      "storage/disk/devices",
			Title:       "Disk Busy Percentage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    307,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "busy",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	IORequests: DiskIORequestsContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_io_requests",
			Family:      "storage/disk/devices",
			Title:       "Disk I/O Requests",
			Units:       "requests/s",
			Type:        module.Area,
			Priority:    308,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	SpaceUsage: DiskSpaceUsageContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_space_usage",
			Family:      "storage/disk/devices",
			Title:       "Disk Space Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    309,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	Capacity: DiskCapacityContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_capacity",
			Family:      "storage/disk/devices",
			Title:       "Disk Capacity",
			Units:       "gigabytes",
			Type:        module.Stacked,
			Priority:    310,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "available",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	Blocks: DiskBlocksContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_blocks",
			Family:      "storage/disk/devices",
			Title:       "Disk Block Operations",
			Units:       "blocks/s",
			Type:        module.Area,
			Priority:    311,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "read",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "write",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	SSDHealth: DiskSSDHealthContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_ssd_health",
			Family:      "storage/disk/devices",
			Title:       "Disk SSD Health",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    312,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "life_remaining",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
	SSDPowerOn: DiskSSDPowerOnContext{
		Context: framework.Context[DiskLabels]{
			Name:        "as400.disk_ssd_age",
			Family:      "storage/disk/devices",
			Title:       "Disk SSD Power On Days",
			Units:       "days",
			Type:        module.Line,
			Priority:    313,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "power_on_days",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"disk_unit",
				"disk_type",
				"disk_model",
				"hardware_status",
				"disk_serial_number",
			},
		},
	},
}

// --- HTTPServer ---

// HTTPServerConnectionsValues defines the type-safe values for HTTPServer.Connections context
type HTTPServerConnectionsValues struct {
	Normal int64
	Ssl    int64
}

// HTTPServerConnectionsContext provides type-safe operations for HTTPServer.Connections context
type HTTPServerConnectionsContext struct {
	framework.Context[HTTPServerLabels]
}

// Set provides type-safe dimension setting for HTTPServer.Connections context
func (c HTTPServerConnectionsContext) Set(state *framework.CollectorState, labels HTTPServerLabels, values HTTPServerConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"normal": values.Normal,
		"ssl":    values.Ssl,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HTTPServerConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels HTTPServerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HTTPServerThreadsValues defines the type-safe values for HTTPServer.Threads context
type HTTPServerThreadsValues struct {
	Active int64
	Idle   int64
}

// HTTPServerThreadsContext provides type-safe operations for HTTPServer.Threads context
type HTTPServerThreadsContext struct {
	framework.Context[HTTPServerLabels]
}

// Set provides type-safe dimension setting for HTTPServer.Threads context
func (c HTTPServerThreadsContext) Set(state *framework.CollectorState, labels HTTPServerLabels, values HTTPServerThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
		"idle":   values.Idle,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HTTPServerThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels HTTPServerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HTTPServerRequestsValues defines the type-safe values for HTTPServer.Requests context
type HTTPServerRequestsValues struct {
	Requests  int64
	Responses int64
	Rejected  int64
}

// HTTPServerRequestsContext provides type-safe operations for HTTPServer.Requests context
type HTTPServerRequestsContext struct {
	framework.Context[HTTPServerLabels]
}

// Set provides type-safe dimension setting for HTTPServer.Requests context
func (c HTTPServerRequestsContext) Set(state *framework.CollectorState, labels HTTPServerLabels, values HTTPServerRequestsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"requests":  values.Requests,
		"responses": values.Responses,
		"rejected":  values.Rejected,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HTTPServerRequestsContext) SetUpdateEvery(state *framework.CollectorState, labels HTTPServerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HTTPServerBytesValues defines the type-safe values for HTTPServer.Bytes context
type HTTPServerBytesValues struct {
	Received int64
	Sent     int64
}

// HTTPServerBytesContext provides type-safe operations for HTTPServer.Bytes context
type HTTPServerBytesContext struct {
	framework.Context[HTTPServerLabels]
}

// Set provides type-safe dimension setting for HTTPServer.Bytes context
func (c HTTPServerBytesContext) Set(state *framework.CollectorState, labels HTTPServerLabels, values HTTPServerBytesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"received": values.Received,
		"sent":     values.Sent,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c HTTPServerBytesContext) SetUpdateEvery(state *framework.CollectorState, labels HTTPServerLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// HTTPServerLabels defines the required labels for HTTPServer contexts
type HTTPServerLabels struct {
	Server   string
	Function string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l HTTPServerLabels) InstanceID(contextName string) string {
	// Label order from YAML: server, function
	return contextName + "." + cleanLabelValue(l.Server) + "_" + cleanLabelValue(l.Function)
}

// HTTPServer contains all metric contexts for HTTPServer
var HTTPServer = struct {
	Connections HTTPServerConnectionsContext
	Threads     HTTPServerThreadsContext
	Requests    HTTPServerRequestsContext
	Bytes       HTTPServerBytesContext
}{
	Connections: HTTPServerConnectionsContext{
		Context: framework.Context[HTTPServerLabels]{
			Name:        "as400.http_server_connections",
			Family:      "network/http",
			Title:       "HTTP Server Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    601,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "normal",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "ssl",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"server",
				"function",
			},
		},
	},
	Threads: HTTPServerThreadsContext{
		Context: framework.Context[HTTPServerLabels]{
			Name:        "as400.http_server_threads",
			Family:      "network/http",
			Title:       "HTTP Server Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    602,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "idle",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"server",
				"function",
			},
		},
	},
	Requests: HTTPServerRequestsContext{
		Context: framework.Context[HTTPServerLabels]{
			Name:        "as400.http_server_requests",
			Family:      "network/http",
			Title:       "HTTP Server Requests",
			Units:       "requests/s",
			Type:        module.Area,
			Priority:    603,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "requests",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "responses",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "rejected",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"server",
				"function",
			},
		},
	},
	Bytes: HTTPServerBytesContext{
		Context: framework.Context[HTTPServerLabels]{
			Name:        "as400.http_server_bytes",
			Family:      "network/http",
			Title:       "HTTP Server Throughput",
			Units:       "bytes/s",
			Type:        module.Area,
			Priority:    604,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "received",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "sent",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"server",
				"function",
			},
		},
	},
}

// --- JobQueue ---

// JobQueueLengthValues defines the type-safe values for JobQueue.Length context
type JobQueueLengthValues struct {
	Jobs int64
}

// JobQueueLengthContext provides type-safe operations for JobQueue.Length context
type JobQueueLengthContext struct {
	framework.Context[JobQueueLabels]
}

// Set provides type-safe dimension setting for JobQueue.Length context
func (c JobQueueLengthContext) Set(state *framework.CollectorState, labels JobQueueLabels, values JobQueueLengthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"jobs": values.Jobs,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c JobQueueLengthContext) SetUpdateEvery(state *framework.CollectorState, labels JobQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// JobQueueLabels defines the required labels for JobQueue contexts
type JobQueueLabels struct {
	Job_queue string
	Library   string
	Status    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l JobQueueLabels) InstanceID(contextName string) string {
	// Label order from YAML: job_queue, library, status
	return contextName + "." + cleanLabelValue(l.Job_queue) + "_" + cleanLabelValue(l.Library) + "_" + cleanLabelValue(l.Status)
}

// JobQueue contains all metric contexts for JobQueue
var JobQueue = struct {
	Length JobQueueLengthContext
}{
	Length: JobQueueLengthContext{
		Context: framework.Context[JobQueueLabels]{
			Name:        "as400.jobqueue_length",
			Family:      "queues/job",
			Title:       "Job Queue Length",
			Units:       "jobs",
			Type:        module.Line,
			Priority:    505,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "jobs",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"job_queue",
				"library",
				"status",
			},
		},
	},
}

// --- MessageQueue ---

// MessageQueueMessagesValues defines the type-safe values for MessageQueue.Messages context
type MessageQueueMessagesValues struct {
	Total         int64
	Informational int64
	Inquiry       int64
	Diagnostic    int64
	Escape        int64
	Notify        int64
	Sender_copy   int64
}

// MessageQueueMessagesContext provides type-safe operations for MessageQueue.Messages context
type MessageQueueMessagesContext struct {
	framework.Context[MessageQueueLabels]
}

// Set provides type-safe dimension setting for MessageQueue.Messages context
func (c MessageQueueMessagesContext) Set(state *framework.CollectorState, labels MessageQueueLabels, values MessageQueueMessagesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"total":         values.Total,
		"informational": values.Informational,
		"inquiry":       values.Inquiry,
		"diagnostic":    values.Diagnostic,
		"escape":        values.Escape,
		"notify":        values.Notify,
		"sender_copy":   values.Sender_copy,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MessageQueueMessagesContext) SetUpdateEvery(state *framework.CollectorState, labels MessageQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MessageQueueSeverityValues defines the type-safe values for MessageQueue.Severity context
type MessageQueueSeverityValues struct {
	Max int64
}

// MessageQueueSeverityContext provides type-safe operations for MessageQueue.Severity context
type MessageQueueSeverityContext struct {
	framework.Context[MessageQueueLabels]
}

// Set provides type-safe dimension setting for MessageQueue.Severity context
func (c MessageQueueSeverityContext) Set(state *framework.CollectorState, labels MessageQueueLabels, values MessageQueueSeverityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"max": values.Max,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c MessageQueueSeverityContext) SetUpdateEvery(state *framework.CollectorState, labels MessageQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// MessageQueueLabels defines the required labels for MessageQueue contexts
type MessageQueueLabels struct {
	Library string
	Queue   string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l MessageQueueLabels) InstanceID(contextName string) string {
	// Label order from YAML: library, queue
	return contextName + "." + cleanLabelValue(l.Library) + "_" + cleanLabelValue(l.Queue)
}

// MessageQueue contains all metric contexts for MessageQueue
var MessageQueue = struct {
	Messages MessageQueueMessagesContext
	Severity MessageQueueSeverityContext
}{
	Messages: MessageQueueMessagesContext{
		Context: framework.Context[MessageQueueLabels]{
			Name:        "as400.message_queue_messages",
			Family:      "queues/message",
			Title:       "Message Queue Messages",
			Units:       "messages",
			Type:        module.Stacked,
			Priority:    700,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "informational",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "inquiry",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "diagnostic",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "escape",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "notify",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "sender_copy",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"library",
				"queue",
			},
		},
	},
	Severity: MessageQueueSeverityContext{
		Context: framework.Context[MessageQueueLabels]{
			Name:        "as400.message_queue_severity",
			Family:      "queues/message",
			Title:       "Message Queue Severity",
			Units:       "severity",
			Type:        module.Line,
			Priority:    701,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "max",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"library",
				"queue",
			},
		},
	},
}

// --- NetworkInterface ---

// NetworkInterfaceStatusValues defines the type-safe values for NetworkInterface.Status context
type NetworkInterfaceStatusValues struct {
	Active int64
}

// NetworkInterfaceStatusContext provides type-safe operations for NetworkInterface.Status context
type NetworkInterfaceStatusContext struct {
	framework.Context[NetworkInterfaceLabels]
}

// Set provides type-safe dimension setting for NetworkInterface.Status context
func (c NetworkInterfaceStatusContext) Set(state *framework.CollectorState, labels NetworkInterfaceLabels, values NetworkInterfaceStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active": values.Active,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c NetworkInterfaceStatusContext) SetUpdateEvery(state *framework.CollectorState, labels NetworkInterfaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// NetworkInterfaceMTUValues defines the type-safe values for NetworkInterface.MTU context
type NetworkInterfaceMTUValues struct {
	Mtu int64
}

// NetworkInterfaceMTUContext provides type-safe operations for NetworkInterface.MTU context
type NetworkInterfaceMTUContext struct {
	framework.Context[NetworkInterfaceLabels]
}

// Set provides type-safe dimension setting for NetworkInterface.MTU context
func (c NetworkInterfaceMTUContext) Set(state *framework.CollectorState, labels NetworkInterfaceLabels, values NetworkInterfaceMTUValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"mtu": values.Mtu,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c NetworkInterfaceMTUContext) SetUpdateEvery(state *framework.CollectorState, labels NetworkInterfaceLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// NetworkInterfaceLabels defines the required labels for NetworkInterface contexts
type NetworkInterfaceLabels struct {
	Interface        string
	Interface_type   string
	Connection_type  string
	Internet_address string
	Network_address  string
	Subnet_mask      string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l NetworkInterfaceLabels) InstanceID(contextName string) string {
	// Label order from YAML: interface, interface_type, connection_type, internet_address, network_address, subnet_mask
	return contextName + "." + cleanLabelValue(l.Interface) + "_" + cleanLabelValue(l.Interface_type) + "_" + cleanLabelValue(l.Connection_type) + "_" + cleanLabelValue(l.Internet_address) + "_" + cleanLabelValue(l.Network_address) + "_" + cleanLabelValue(l.Subnet_mask)
}

// NetworkInterface contains all metric contexts for NetworkInterface
var NetworkInterface = struct {
	Status NetworkInterfaceStatusContext
	MTU    NetworkInterfaceMTUContext
}{
	Status: NetworkInterfaceStatusContext{
		Context: framework.Context[NetworkInterfaceLabels]{
			Name:        "as400.network_interface_status",
			Family:      "network/interfaces",
			Title:       "Network Interface Status",
			Units:       "status",
			Type:        module.Line,
			Priority:    403,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"interface",
				"interface_type",
				"connection_type",
				"internet_address",
				"network_address",
				"subnet_mask",
			},
		},
	},
	MTU: NetworkInterfaceMTUContext{
		Context: framework.Context[NetworkInterfaceLabels]{
			Name:        "as400.network_interface_mtu",
			Family:      "network/interfaces",
			Title:       "Network Interface MTU",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    404,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "mtu",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"interface",
				"interface_type",
				"connection_type",
				"internet_address",
				"network_address",
				"subnet_mask",
			},
		},
	},
}

// --- Observability ---

// ObservabilityQueryLatencyFastValues defines the type-safe values for Observability.QueryLatencyFast context
type ObservabilityQueryLatencyFastValues struct {
	Count_disks                  int64
	Count_http_servers           int64
	Count_network_interfaces     int64
	Detect_ibmi_version_primary  int64
	Detect_ibmi_version_fallback int64
	Disk_instances               int64
	Disk_instances_enhanced      int64
	Disk_status                  int64
	Http_server_info             int64
	Job_info                     int64
	Memory_pools                 int64
	Network_connections          int64
	Network_interfaces           int64
	Serial_number                int64
	System_name                  int64
	System_activity              int64
	System_model                 int64
	System_status                int64
	Temp_storage_named           int64
	Temp_storage_total           int64
	Technology_refresh_level     int64
	Active_job                   int64
}

// ObservabilityQueryLatencyFastContext provides type-safe operations for Observability.QueryLatencyFast context
type ObservabilityQueryLatencyFastContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for Observability.QueryLatencyFast context
func (c ObservabilityQueryLatencyFastContext) Set(state *framework.CollectorState, labels EmptyLabels, values ObservabilityQueryLatencyFastValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"count_disks":                  values.Count_disks,
		"count_http_servers":           values.Count_http_servers,
		"count_network_interfaces":     values.Count_network_interfaces,
		"detect_ibmi_version_primary":  values.Detect_ibmi_version_primary,
		"detect_ibmi_version_fallback": values.Detect_ibmi_version_fallback,
		"disk_instances":               values.Disk_instances,
		"disk_instances_enhanced":      values.Disk_instances_enhanced,
		"disk_status":                  values.Disk_status,
		"http_server_info":             values.Http_server_info,
		"job_info":                     values.Job_info,
		"memory_pools":                 values.Memory_pools,
		"network_connections":          values.Network_connections,
		"network_interfaces":           values.Network_interfaces,
		"serial_number":                values.Serial_number,
		"system_name":                  values.System_name,
		"system_activity":              values.System_activity,
		"system_model":                 values.System_model,
		"system_status":                values.System_status,
		"temp_storage_named":           values.Temp_storage_named,
		"temp_storage_total":           values.Temp_storage_total,
		"technology_refresh_level":     values.Technology_refresh_level,
		"active_job":                   values.Active_job,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ObservabilityQueryLatencyFastContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// ObservabilityQueryLatencySlowValues defines the type-safe values for Observability.QueryLatencySlow context
type ObservabilityQueryLatencySlowValues struct {
	Analyze_plan_cache       int64
	Count_subsystems         int64
	Subsystems               int64
	Message_queue_aggregates int64
	Job_queues               int64
	Output_queue_info        int64
	Plan_cache_summary       int64
}

// ObservabilityQueryLatencySlowContext provides type-safe operations for Observability.QueryLatencySlow context
type ObservabilityQueryLatencySlowContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for Observability.QueryLatencySlow context
func (c ObservabilityQueryLatencySlowContext) Set(state *framework.CollectorState, labels EmptyLabels, values ObservabilityQueryLatencySlowValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"analyze_plan_cache":       values.Analyze_plan_cache,
		"count_subsystems":         values.Count_subsystems,
		"subsystems":               values.Subsystems,
		"message_queue_aggregates": values.Message_queue_aggregates,
		"job_queues":               values.Job_queues,
		"output_queue_info":        values.Output_queue_info,
		"plan_cache_summary":       values.Plan_cache_summary,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ObservabilityQueryLatencySlowContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// ObservabilityQueryLatencyBatchValues defines the type-safe values for Observability.QueryLatencyBatch context
type ObservabilityQueryLatencyBatchValues struct {
	Message_queue_totals int64
	Job_queue_totals     int64
	Output_queue_totals  int64
}

// ObservabilityQueryLatencyBatchContext provides type-safe operations for Observability.QueryLatencyBatch context
type ObservabilityQueryLatencyBatchContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for Observability.QueryLatencyBatch context
func (c ObservabilityQueryLatencyBatchContext) Set(state *framework.CollectorState, labels EmptyLabels, values ObservabilityQueryLatencyBatchValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"message_queue_totals": values.Message_queue_totals,
		"job_queue_totals":     values.Job_queue_totals,
		"output_queue_totals":  values.Output_queue_totals,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c ObservabilityQueryLatencyBatchContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// Observability contains all metric contexts for Observability
var Observability = struct {
	QueryLatencyFast  ObservabilityQueryLatencyFastContext
	QueryLatencySlow  ObservabilityQueryLatencySlowContext
	QueryLatencyBatch ObservabilityQueryLatencyBatchContext
}{
	QueryLatencyFast: ObservabilityQueryLatencyFastContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "netdata.plugin_ibm.as400_query_latency_fast",
			Family:      "plugins/ibm.d/latency",
			Title:       "AS400 Query Latency (Fast Path)",
			Units:       "ms",
			Type:        module.Stacked,
			Priority:    146000,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "count_disks",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "count_http_servers",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "count_network_interfaces",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "detect_ibmi_version_primary",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "detect_ibmi_version_fallback",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "disk_instances",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "disk_instances_enhanced",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "disk_status",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "http_server_info",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "job_info",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "memory_pools",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "network_connections",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "network_interfaces",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "serial_number",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "system_name",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "system_activity",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "system_model",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "system_status",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "temp_storage_named",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "temp_storage_total",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "technology_refresh_level",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "active_job",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	QueryLatencySlow: ObservabilityQueryLatencySlowContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "netdata.plugin_ibm.as400_query_latency_slow",
			Family:      "plugins/ibm.d/latency",
			Title:       "AS400 Query Latency (Slow Path)",
			Units:       "ms",
			Type:        module.Stacked,
			Priority:    146010,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "analyze_plan_cache",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "count_subsystems",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "subsystems",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "message_queue_aggregates",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "job_queues",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "output_queue_info",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "plan_cache_summary",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	QueryLatencyBatch: ObservabilityQueryLatencyBatchContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "netdata.plugin_ibm.as400_query_latency_batch",
			Family:      "plugins/ibm.d/latency",
			Title:       "AS400 Query Latency (Batch Path)",
			Units:       "ms",
			Type:        module.Stacked,
			Priority:    146020,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "message_queue_totals",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "job_queue_totals",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "output_queue_totals",
					Algorithm: module.Incremental,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- OutputQueue ---

// OutputQueueFilesValues defines the type-safe values for OutputQueue.Files context
type OutputQueueFilesValues struct {
	Files int64
}

// OutputQueueFilesContext provides type-safe operations for OutputQueue.Files context
type OutputQueueFilesContext struct {
	framework.Context[OutputQueueLabels]
}

// Set provides type-safe dimension setting for OutputQueue.Files context
func (c OutputQueueFilesContext) Set(state *framework.CollectorState, labels OutputQueueLabels, values OutputQueueFilesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"files": values.Files,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c OutputQueueFilesContext) SetUpdateEvery(state *framework.CollectorState, labels OutputQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// OutputQueueWritersValues defines the type-safe values for OutputQueue.Writers context
type OutputQueueWritersValues struct {
	Writers int64
}

// OutputQueueWritersContext provides type-safe operations for OutputQueue.Writers context
type OutputQueueWritersContext struct {
	framework.Context[OutputQueueLabels]
}

// Set provides type-safe dimension setting for OutputQueue.Writers context
func (c OutputQueueWritersContext) Set(state *framework.CollectorState, labels OutputQueueLabels, values OutputQueueWritersValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"writers": values.Writers,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c OutputQueueWritersContext) SetUpdateEvery(state *framework.CollectorState, labels OutputQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// OutputQueueStatusValues defines the type-safe values for OutputQueue.Status context
type OutputQueueStatusValues struct {
	Released int64
}

// OutputQueueStatusContext provides type-safe operations for OutputQueue.Status context
type OutputQueueStatusContext struct {
	framework.Context[OutputQueueLabels]
}

// Set provides type-safe dimension setting for OutputQueue.Status context
func (c OutputQueueStatusContext) Set(state *framework.CollectorState, labels OutputQueueLabels, values OutputQueueStatusValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"released": values.Released,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c OutputQueueStatusContext) SetUpdateEvery(state *framework.CollectorState, labels OutputQueueLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// OutputQueueLabels defines the required labels for OutputQueue contexts
type OutputQueueLabels struct {
	Library string
	Queue   string
	Status  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l OutputQueueLabels) InstanceID(contextName string) string {
	// Label order from YAML: library, queue, status
	return contextName + "." + cleanLabelValue(l.Library) + "_" + cleanLabelValue(l.Queue) + "_" + cleanLabelValue(l.Status)
}

// OutputQueue contains all metric contexts for OutputQueue
var OutputQueue = struct {
	Files   OutputQueueFilesContext
	Writers OutputQueueWritersContext
	Status  OutputQueueStatusContext
}{
	Files: OutputQueueFilesContext{
		Context: framework.Context[OutputQueueLabels]{
			Name:        "as400.output_queue_files",
			Family:      "queues/output",
			Title:       "Output Queue Files",
			Units:       "files",
			Type:        module.Line,
			Priority:    702,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "files",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"library",
				"queue",
				"status",
			},
		},
	},
	Writers: OutputQueueWritersContext{
		Context: framework.Context[OutputQueueLabels]{
			Name:        "as400.output_queue_writers",
			Family:      "queues/output",
			Title:       "Output Queue Writers",
			Units:       "writers",
			Type:        module.Line,
			Priority:    703,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "writers",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"library",
				"queue",
				"status",
			},
		},
	},
	Status: OutputQueueStatusContext{
		Context: framework.Context[OutputQueueLabels]{
			Name:        "as400.output_queue_status",
			Family:      "queues/output",
			Title:       "Output Queue Status",
			Units:       "state",
			Type:        module.Line,
			Priority:    704,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "released",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"library",
				"queue",
				"status",
			},
		},
	},
}

// --- PlanCache ---

// PlanCacheSummaryValues defines the type-safe values for PlanCache.Summary context
type PlanCacheSummaryValues struct {
	Value int64
}

// PlanCacheSummaryContext provides type-safe operations for PlanCache.Summary context
type PlanCacheSummaryContext struct {
	framework.Context[PlanCacheLabels]
}

// Set provides type-safe dimension setting for PlanCache.Summary context
func (c PlanCacheSummaryContext) Set(state *framework.CollectorState, labels PlanCacheLabels, values PlanCacheSummaryValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"value": values.Value,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c PlanCacheSummaryContext) SetUpdateEvery(state *framework.CollectorState, labels PlanCacheLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// PlanCacheLabels defines the required labels for PlanCache contexts
type PlanCacheLabels struct {
	Metric string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l PlanCacheLabels) InstanceID(contextName string) string {
	// Label order from YAML: metric
	return contextName + "." + cleanLabelValue(l.Metric)
}

// PlanCache contains all metric contexts for PlanCache
var PlanCache = struct {
	Summary PlanCacheSummaryContext
}{
	Summary: PlanCacheSummaryContext{
		Context: framework.Context[PlanCacheLabels]{
			Name:        "as400.plan_cache_summary",
			Family:      "database/cache",
			Title:       "Plan Cache Summary",
			Units:       "value",
			Type:        module.Line,
			Priority:    802,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "value",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"metric",
			},
		},
	},
}

// --- QueueOverview ---

// QueueOverviewCountValues defines the type-safe values for QueueOverview.Count context
type QueueOverviewCountValues struct {
	Queues int64
}

// QueueOverviewCountContext provides type-safe operations for QueueOverview.Count context
type QueueOverviewCountContext struct {
	framework.Context[QueueOverviewLabels]
}

// Set provides type-safe dimension setting for QueueOverview.Count context
func (c QueueOverviewCountContext) Set(state *framework.CollectorState, labels QueueOverviewLabels, values QueueOverviewCountValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"queues": values.Queues,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueOverviewCountContext) SetUpdateEvery(state *framework.CollectorState, labels QueueOverviewLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueOverviewItemsValues defines the type-safe values for QueueOverview.Items context
type QueueOverviewItemsValues struct {
	Items int64
}

// QueueOverviewItemsContext provides type-safe operations for QueueOverview.Items context
type QueueOverviewItemsContext struct {
	framework.Context[QueueOverviewLabels]
}

// Set provides type-safe dimension setting for QueueOverview.Items context
func (c QueueOverviewItemsContext) Set(state *framework.CollectorState, labels QueueOverviewLabels, values QueueOverviewItemsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"items": values.Items,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c QueueOverviewItemsContext) SetUpdateEvery(state *framework.CollectorState, labels QueueOverviewLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// QueueOverviewLabels defines the required labels for QueueOverview contexts
type QueueOverviewLabels struct {
	Queue_type string
	Item_type  string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l QueueOverviewLabels) InstanceID(contextName string) string {
	// Label order from YAML: queue_type, item_type
	return contextName + "." + cleanLabelValue(l.Queue_type) + "_" + cleanLabelValue(l.Item_type)
}

// QueueOverview contains all metric contexts for QueueOverview
var QueueOverview = struct {
	Count QueueOverviewCountContext
	Items QueueOverviewItemsContext
}{
	Count: QueueOverviewCountContext{
		Context: framework.Context[QueueOverviewLabels]{
			Name:        "as400.queues_count",
			Family:      "queues/overview",
			Title:       "Queue Counts",
			Units:       "queues",
			Type:        module.Line,
			Priority:    504,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "queues",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_type",
				"item_type",
			},
		},
	},
	Items: QueueOverviewItemsContext{
		Context: framework.Context[QueueOverviewLabels]{
			Name:        "as400.queued_items",
			Family:      "queues/overview",
			Title:       "Queued Items",
			Units:       "items",
			Type:        module.Line,
			Priority:    505,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "items",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"queue_type",
				"item_type",
			},
		},
	},
}

// --- Subsystem ---

// SubsystemJobsValues defines the type-safe values for Subsystem.Jobs context
type SubsystemJobsValues struct {
	Active  int64
	Maximum int64
}

// SubsystemJobsContext provides type-safe operations for Subsystem.Jobs context
type SubsystemJobsContext struct {
	framework.Context[SubsystemLabels]
}

// Set provides type-safe dimension setting for Subsystem.Jobs context
func (c SubsystemJobsContext) Set(state *framework.CollectorState, labels SubsystemLabels, values SubsystemJobsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"active":  values.Active,
		"maximum": values.Maximum,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SubsystemJobsContext) SetUpdateEvery(state *framework.CollectorState, labels SubsystemLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// SubsystemLabels defines the required labels for Subsystem contexts
type SubsystemLabels struct {
	Subsystem string
	Library   string
	Status    string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l SubsystemLabels) InstanceID(contextName string) string {
	// Label order from YAML: subsystem, library, status
	return contextName + "." + cleanLabelValue(l.Subsystem) + "_" + cleanLabelValue(l.Library) + "_" + cleanLabelValue(l.Status)
}

// Subsystem contains all metric contexts for Subsystem
var Subsystem = struct {
	Jobs SubsystemJobsContext
}{
	Jobs: SubsystemJobsContext{
		Context: framework.Context[SubsystemLabels]{
			Name:        "as400.subsystem_jobs",
			Family:      "workloads/subsystems",
			Title:       "Subsystem Jobs",
			Units:       "jobs",
			Type:        module.Line,
			Priority:    504,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "maximum",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"subsystem",
				"library",
				"status",
			},
		},
	},
}

// --- System ---

// SystemCPUUtilizationValues defines the type-safe values for System.CPUUtilization context
type SystemCPUUtilizationValues struct {
	Utilization int64
}

// SystemCPUUtilizationContext provides type-safe operations for System.CPUUtilization context
type SystemCPUUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPUUtilization context
func (c SystemCPUUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemCPUEntitledUtilizationValues defines the type-safe values for System.CPUEntitledUtilization context
type SystemCPUEntitledUtilizationValues struct {
	Utilization int64
}

// SystemCPUEntitledUtilizationContext provides type-safe operations for System.CPUEntitledUtilization context
type SystemCPUEntitledUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPUEntitledUtilization context
func (c SystemCPUEntitledUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUEntitledUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"utilization": values.Utilization,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUEntitledUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemCPUDetailsValues defines the type-safe values for System.CPUDetails context
type SystemCPUDetailsValues struct {
	Configured int64
}

// SystemCPUDetailsContext provides type-safe operations for System.CPUDetails context
type SystemCPUDetailsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPUDetails context
func (c SystemCPUDetailsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUDetailsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"configured": values.Configured,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUDetailsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemCPUCapacityValues defines the type-safe values for System.CPUCapacity context
type SystemCPUCapacityValues struct {
	Capacity int64
}

// SystemCPUCapacityContext provides type-safe operations for System.CPUCapacity context
type SystemCPUCapacityContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.CPUCapacity context
func (c SystemCPUCapacityContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemCPUCapacityValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"capacity": values.Capacity,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemCPUCapacityContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTotalJobsValues defines the type-safe values for System.TotalJobs context
type SystemTotalJobsValues struct {
	Total int64
}

// SystemTotalJobsContext provides type-safe operations for System.TotalJobs context
type SystemTotalJobsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TotalJobs context
func (c SystemTotalJobsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTotalJobsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTotalJobsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemActiveJobsByTypeValues defines the type-safe values for System.ActiveJobsByType context
type SystemActiveJobsByTypeValues struct {
	Batch       int64
	Interactive int64
	Active      int64
}

// SystemActiveJobsByTypeContext provides type-safe operations for System.ActiveJobsByType context
type SystemActiveJobsByTypeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.ActiveJobsByType context
func (c SystemActiveJobsByTypeContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemActiveJobsByTypeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"batch":       values.Batch,
		"interactive": values.Interactive,
		"active":      values.Active,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemActiveJobsByTypeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemJobQueueLengthValues defines the type-safe values for System.JobQueueLength context
type SystemJobQueueLengthValues struct {
	Waiting int64
}

// SystemJobQueueLengthContext provides type-safe operations for System.JobQueueLength context
type SystemJobQueueLengthContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.JobQueueLength context
func (c SystemJobQueueLengthContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemJobQueueLengthValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"waiting": values.Waiting,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemJobQueueLengthContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMainStorageSizeValues defines the type-safe values for System.MainStorageSize context
type SystemMainStorageSizeValues struct {
	Total int64
}

// SystemMainStorageSizeContext provides type-safe operations for System.MainStorageSize context
type SystemMainStorageSizeContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MainStorageSize context
func (c SystemMainStorageSizeContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMainStorageSizeValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMainStorageSizeContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTemporaryStorageValues defines the type-safe values for System.TemporaryStorage context
type SystemTemporaryStorageValues struct {
	Current int64
	Maximum int64
}

// SystemTemporaryStorageContext provides type-safe operations for System.TemporaryStorage context
type SystemTemporaryStorageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TemporaryStorage context
func (c SystemTemporaryStorageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTemporaryStorageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"current": values.Current,
		"maximum": values.Maximum,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTemporaryStorageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryPoolUsageValues defines the type-safe values for System.MemoryPoolUsage context
type SystemMemoryPoolUsageValues struct {
	Machine     int64
	Base        int64
	Interactive int64
	Spool       int64
}

// SystemMemoryPoolUsageContext provides type-safe operations for System.MemoryPoolUsage context
type SystemMemoryPoolUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryPoolUsage context
func (c SystemMemoryPoolUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryPoolUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"machine":     values.Machine,
		"base":        values.Base,
		"interactive": values.Interactive,
		"spool":       values.Spool,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryPoolUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryPoolDefinedValues defines the type-safe values for System.MemoryPoolDefined context
type SystemMemoryPoolDefinedValues struct {
	Machine int64
	Base    int64
}

// SystemMemoryPoolDefinedContext provides type-safe operations for System.MemoryPoolDefined context
type SystemMemoryPoolDefinedContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryPoolDefined context
func (c SystemMemoryPoolDefinedContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryPoolDefinedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"machine": values.Machine,
		"base":    values.Base,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryPoolDefinedContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryPoolReservedValues defines the type-safe values for System.MemoryPoolReserved context
type SystemMemoryPoolReservedValues struct {
	Machine int64
	Base    int64
}

// SystemMemoryPoolReservedContext provides type-safe operations for System.MemoryPoolReserved context
type SystemMemoryPoolReservedContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryPoolReserved context
func (c SystemMemoryPoolReservedContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryPoolReservedValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"machine": values.Machine,
		"base":    values.Base,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryPoolReservedContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryPoolThreadsValues defines the type-safe values for System.MemoryPoolThreads context
type SystemMemoryPoolThreadsValues struct {
	Machine int64
	Base    int64
}

// SystemMemoryPoolThreadsContext provides type-safe operations for System.MemoryPoolThreads context
type SystemMemoryPoolThreadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryPoolThreads context
func (c SystemMemoryPoolThreadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryPoolThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"machine": values.Machine,
		"base":    values.Base,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryPoolThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemMemoryPoolMaxThreadsValues defines the type-safe values for System.MemoryPoolMaxThreads context
type SystemMemoryPoolMaxThreadsValues struct {
	Machine int64
	Base    int64
}

// SystemMemoryPoolMaxThreadsContext provides type-safe operations for System.MemoryPoolMaxThreads context
type SystemMemoryPoolMaxThreadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.MemoryPoolMaxThreads context
func (c SystemMemoryPoolMaxThreadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemMemoryPoolMaxThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"machine": values.Machine,
		"base":    values.Base,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemMemoryPoolMaxThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemDiskBusyAverageValues defines the type-safe values for System.DiskBusyAverage context
type SystemDiskBusyAverageValues struct {
	Busy int64
}

// SystemDiskBusyAverageContext provides type-safe operations for System.DiskBusyAverage context
type SystemDiskBusyAverageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.DiskBusyAverage context
func (c SystemDiskBusyAverageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemDiskBusyAverageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"busy": values.Busy,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemDiskBusyAverageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSystemASPUsageValues defines the type-safe values for System.SystemASPUsage context
type SystemSystemASPUsageValues struct {
	Used int64
}

// SystemSystemASPUsageContext provides type-safe operations for System.SystemASPUsage context
type SystemSystemASPUsageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SystemASPUsage context
func (c SystemSystemASPUsageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSystemASPUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"used": values.Used,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSystemASPUsageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSystemASPStorageValues defines the type-safe values for System.SystemASPStorage context
type SystemSystemASPStorageValues struct {
	Total int64
}

// SystemSystemASPStorageContext provides type-safe operations for System.SystemASPStorage context
type SystemSystemASPStorageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SystemASPStorage context
func (c SystemSystemASPStorageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSystemASPStorageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSystemASPStorageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTotalAuxiliaryStorageValues defines the type-safe values for System.TotalAuxiliaryStorage context
type SystemTotalAuxiliaryStorageValues struct {
	Total int64
}

// SystemTotalAuxiliaryStorageContext provides type-safe operations for System.TotalAuxiliaryStorage context
type SystemTotalAuxiliaryStorageContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TotalAuxiliaryStorage context
func (c SystemTotalAuxiliaryStorageContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTotalAuxiliaryStorageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"total": values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTotalAuxiliaryStorageContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSystemThreadsValues defines the type-safe values for System.SystemThreads context
type SystemSystemThreadsValues struct {
	Active        int64
	Per_processor int64
}

// SystemSystemThreadsContext provides type-safe operations for System.SystemThreads context
type SystemSystemThreadsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SystemThreads context
func (c SystemSystemThreadsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSystemThreadsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"active":        values.Active,
		"per_processor": values.Per_processor,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSystemThreadsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemNetworkConnectionsValues defines the type-safe values for System.NetworkConnections context
type SystemNetworkConnectionsValues struct {
	Remote int64
	Total  int64
}

// SystemNetworkConnectionsContext provides type-safe operations for System.NetworkConnections context
type SystemNetworkConnectionsContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.NetworkConnections context
func (c SystemNetworkConnectionsContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemNetworkConnectionsValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"remote": values.Remote,
		"total":  values.Total,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemNetworkConnectionsContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemNetworkConnectionStatesValues defines the type-safe values for System.NetworkConnectionStates context
type SystemNetworkConnectionStatesValues struct {
	Listen     int64
	Close_wait int64
}

// SystemNetworkConnectionStatesContext provides type-safe operations for System.NetworkConnectionStates context
type SystemNetworkConnectionStatesContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.NetworkConnectionStates context
func (c SystemNetworkConnectionStatesContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemNetworkConnectionStatesValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"listen":     values.Listen,
		"close_wait": values.Close_wait,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemNetworkConnectionStatesContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemTempStorageTotalValues defines the type-safe values for System.TempStorageTotal context
type SystemTempStorageTotalValues struct {
	Current int64
	Peak    int64
}

// SystemTempStorageTotalContext provides type-safe operations for System.TempStorageTotal context
type SystemTempStorageTotalContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.TempStorageTotal context
func (c SystemTempStorageTotalContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemTempStorageTotalValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"current": values.Current,
		"peak":    values.Peak,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemTempStorageTotalContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSystemActivityCPURateValues defines the type-safe values for System.SystemActivityCPURate context
type SystemSystemActivityCPURateValues struct {
	Average int64
}

// SystemSystemActivityCPURateContext provides type-safe operations for System.SystemActivityCPURate context
type SystemSystemActivityCPURateContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SystemActivityCPURate context
func (c SystemSystemActivityCPURateContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSystemActivityCPURateValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"average": values.Average,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSystemActivityCPURateContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// SystemSystemActivityCPUUtilizationValues defines the type-safe values for System.SystemActivityCPUUtilization context
type SystemSystemActivityCPUUtilizationValues struct {
	Average int64
	Minimum int64
	Maximum int64
}

// SystemSystemActivityCPUUtilizationContext provides type-safe operations for System.SystemActivityCPUUtilization context
type SystemSystemActivityCPUUtilizationContext struct {
	framework.Context[EmptyLabels]
}

// Set provides type-safe dimension setting for System.SystemActivityCPUUtilization context
func (c SystemSystemActivityCPUUtilizationContext) Set(state *framework.CollectorState, labels EmptyLabels, values SystemSystemActivityCPUUtilizationValues) {
	state.SetMetricsForGeneratedCode(&c.Context, nil, map[string]int64{
		"average": values.Average,
		"minimum": values.Minimum,
		"maximum": values.Maximum,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c SystemSystemActivityCPUUtilizationContext) SetUpdateEvery(state *framework.CollectorState, labels EmptyLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, nil, updateEvery)
}

// System contains all metric contexts for System
var System = struct {
	CPUUtilization               SystemCPUUtilizationContext
	CPUEntitledUtilization       SystemCPUEntitledUtilizationContext
	CPUDetails                   SystemCPUDetailsContext
	CPUCapacity                  SystemCPUCapacityContext
	TotalJobs                    SystemTotalJobsContext
	ActiveJobsByType             SystemActiveJobsByTypeContext
	JobQueueLength               SystemJobQueueLengthContext
	MainStorageSize              SystemMainStorageSizeContext
	TemporaryStorage             SystemTemporaryStorageContext
	MemoryPoolUsage              SystemMemoryPoolUsageContext
	MemoryPoolDefined            SystemMemoryPoolDefinedContext
	MemoryPoolReserved           SystemMemoryPoolReservedContext
	MemoryPoolThreads            SystemMemoryPoolThreadsContext
	MemoryPoolMaxThreads         SystemMemoryPoolMaxThreadsContext
	DiskBusyAverage              SystemDiskBusyAverageContext
	SystemASPUsage               SystemSystemASPUsageContext
	SystemASPStorage             SystemSystemASPStorageContext
	TotalAuxiliaryStorage        SystemTotalAuxiliaryStorageContext
	SystemThreads                SystemSystemThreadsContext
	NetworkConnections           SystemNetworkConnectionsContext
	NetworkConnectionStates      SystemNetworkConnectionStatesContext
	TempStorageTotal             SystemTempStorageTotalContext
	SystemActivityCPURate        SystemSystemActivityCPURateContext
	SystemActivityCPUUtilization SystemSystemActivityCPUUtilizationContext
}{
	CPUUtilization: SystemCPUUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.cpu_utilization",
			Family:      "compute/cpu",
			Title:       "CPU Utilization (100% = 1 CPU core)",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    101,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	CPUEntitledUtilization: SystemCPUEntitledUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.cpu_utilization_entitled",
			Family:      "compute/cpu",
			Title:       "CPU Utilization (as % of entitlement)",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    102,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "utilization",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	CPUDetails: SystemCPUDetailsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.cpu_configuration",
			Family:      "compute/cpu",
			Title:       "CPU Configuration",
			Units:       "cpus",
			Type:        module.Line,
			Priority:    102,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "configured",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	CPUCapacity: SystemCPUCapacityContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.cpu_capacity",
			Family:      "compute/cpu",
			Title:       "Current CPU Capacity",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    103,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "capacity",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TotalJobs: SystemTotalJobsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.total_jobs",
			Family:      "workloads/jobs",
			Title:       "Total Jobs in System",
			Units:       "jobs",
			Type:        module.Line,
			Priority:    501,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	ActiveJobsByType: SystemActiveJobsByTypeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.active_jobs_by_type",
			Family:      "workloads/jobs",
			Title:       "Active Jobs by Type",
			Units:       "jobs",
			Type:        module.Stacked,
			Priority:    502,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "batch",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "interactive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	JobQueueLength: SystemJobQueueLengthContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.job_queue_length",
			Family:      "workloads/jobs",
			Title:       "Job Queue Length",
			Units:       "jobs",
			Type:        module.Line,
			Priority:    503,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "waiting",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MainStorageSize: SystemMainStorageSizeContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.main_storage_size",
			Family:      "memory/overview",
			Title:       "Main Storage Size",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    201,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TemporaryStorage: SystemTemporaryStorageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.temporary_storage",
			Family:      "storage/temp/overview",
			Title:       "Temporary Storage",
			Units:       "MiB",
			Type:        module.Line,
			Priority:    304,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "maximum",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryPoolUsage: SystemMemoryPoolUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.memory_pool_usage",
			Family:      "memory/pools",
			Title:       "Memory Pool Usage",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    203,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "machine",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "base",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "interactive",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "spool",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryPoolDefined: SystemMemoryPoolDefinedContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.memory_pool_defined",
			Family:      "memory/pools",
			Title:       "Memory Pool Defined Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    204,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "machine",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "base",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryPoolReserved: SystemMemoryPoolReservedContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.memory_pool_reserved",
			Family:      "memory/pools",
			Title:       "Memory Pool Reserved Size",
			Units:       "bytes",
			Type:        module.Stacked,
			Priority:    205,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "machine",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "base",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryPoolThreads: SystemMemoryPoolThreadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.memory_pool_threads",
			Family:      "memory/pools",
			Title:       "Memory Pool Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    206,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "machine",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "base",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	MemoryPoolMaxThreads: SystemMemoryPoolMaxThreadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.memory_pool_max_threads",
			Family:      "memory/pools",
			Title:       "Memory Pool Maximum Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    207,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "machine",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "base",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	DiskBusyAverage: SystemDiskBusyAverageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.disk_busy_average",
			Family:      "storage/disk/summary",
			Title:       "Average Disk Busy Percentage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    306,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "busy",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SystemASPUsage: SystemSystemASPUsageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.system_asp_usage",
			Family:      "storage/asp",
			Title:       "System ASP Usage",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    301,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "used",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SystemASPStorage: SystemSystemASPStorageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.system_asp_storage",
			Family:      "storage/asp",
			Title:       "System ASP Storage",
			Units:       "MiB",
			Type:        module.Line,
			Priority:    302,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TotalAuxiliaryStorage: SystemTotalAuxiliaryStorageContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.total_auxiliary_storage",
			Family:      "storage/asp",
			Title:       "Total Auxiliary Storage",
			Units:       "MiB",
			Type:        module.Line,
			Priority:    303,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SystemThreads: SystemSystemThreadsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.system_threads",
			Family:      "compute/threads",
			Title:       "System Threads",
			Units:       "threads",
			Type:        module.Line,
			Priority:    104,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "active",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "per_processor",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	NetworkConnections: SystemNetworkConnectionsContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.network_connections",
			Family:      "network/summary",
			Title:       "Network Connections",
			Units:       "connections",
			Type:        module.Line,
			Priority:    401,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "remote",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "total",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	NetworkConnectionStates: SystemNetworkConnectionStatesContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.network_connection_states",
			Family:      "network/summary",
			Title:       "Network Connection States",
			Units:       "connections",
			Type:        module.Line,
			Priority:    402,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "listen",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "close_wait",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	TempStorageTotal: SystemTempStorageTotalContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.temp_storage_total",
			Family:      "storage/temp/overview",
			Title:       "Temporary Storage Total",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    304,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "peak",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SystemActivityCPURate: SystemSystemActivityCPURateContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.system_activity_cpu_rate",
			Family:      "compute/activity",
			Title:       "System CPU Rate",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    105,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "average",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
	SystemActivityCPUUtilization: SystemSystemActivityCPUUtilizationContext{
		Context: framework.Context[EmptyLabels]{
			Name:        "as400.system_activity_cpu_utilization",
			Family:      "compute/activity",
			Title:       "System CPU Utilization",
			Units:       "percentage",
			Type:        module.Line,
			Priority:    106,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "average",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "minimum",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
				{
					Name:      "maximum",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1000,
					Precision: 1,
				},
			},
			LabelKeys: []string{},
		},
	},
}

// --- TempStorageBucket ---

// TempStorageBucketUsageValues defines the type-safe values for TempStorageBucket.Usage context
type TempStorageBucketUsageValues struct {
	Current int64
	Peak    int64
}

// TempStorageBucketUsageContext provides type-safe operations for TempStorageBucket.Usage context
type TempStorageBucketUsageContext struct {
	framework.Context[TempStorageBucketLabels]
}

// Set provides type-safe dimension setting for TempStorageBucket.Usage context
func (c TempStorageBucketUsageContext) Set(state *framework.CollectorState, labels TempStorageBucketLabels, values TempStorageBucketUsageValues) {
	state.SetMetricsForGeneratedCode(&c.Context, labels, map[string]int64{
		"current": values.Current,
		"peak":    values.Peak,
	})
}

// SetUpdateEvery sets the update interval for this instance
func (c TempStorageBucketUsageContext) SetUpdateEvery(state *framework.CollectorState, labels TempStorageBucketLabels, updateEvery int) {
	state.SetUpdateEveryOverrideForGeneratedCode(&c.Context, labels, updateEvery)
}

// TempStorageBucketLabels defines the required labels for TempStorageBucket contexts
type TempStorageBucketLabels struct {
	Bucket string
}

// InstanceID generates a unique instance ID using the hardcoded label order from YAML
func (l TempStorageBucketLabels) InstanceID(contextName string) string {
	// Label order from YAML: bucket
	return contextName + "." + cleanLabelValue(l.Bucket)
}

// TempStorageBucket contains all metric contexts for TempStorageBucket
var TempStorageBucket = struct {
	Usage TempStorageBucketUsageContext
}{
	Usage: TempStorageBucketUsageContext{
		Context: framework.Context[TempStorageBucketLabels]{
			Name:        "as400.temp_storage_bucket",
			Family:      "storage/temp/buckets",
			Title:       "Temporary Storage Bucket Usage",
			Units:       "bytes",
			Type:        module.Line,
			Priority:    305,
			UpdateEvery: 1,
			Dimensions: []framework.Dimension{
				{
					Name:      "current",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
				{
					Name:      "peak",
					Algorithm: module.Absolute,
					Mul:       1,
					Div:       1,
					Precision: 1,
				},
			},
			LabelKeys: []string{
				"bucket",
			},
		},
	},
}

// GetAllContexts returns all contexts for framework registration
func GetAllContexts() []interface{} {
	return []interface{}{
		&ActiveJob.CPU.Context,
		&ActiveJob.Resources.Context,
		&ActiveJob.Time.Context,
		&ActiveJob.Activity.Context,
		&ActiveJob.Threads.Context,
		&Disk.Busy.Context,
		&Disk.IORequests.Context,
		&Disk.SpaceUsage.Context,
		&Disk.Capacity.Context,
		&Disk.Blocks.Context,
		&Disk.SSDHealth.Context,
		&Disk.SSDPowerOn.Context,
		&HTTPServer.Connections.Context,
		&HTTPServer.Threads.Context,
		&HTTPServer.Requests.Context,
		&HTTPServer.Bytes.Context,
		&JobQueue.Length.Context,
		&MessageQueue.Messages.Context,
		&MessageQueue.Severity.Context,
		&NetworkInterface.Status.Context,
		&NetworkInterface.MTU.Context,
		&Observability.QueryLatencyFast.Context,
		&Observability.QueryLatencySlow.Context,
		&Observability.QueryLatencyBatch.Context,
		&OutputQueue.Files.Context,
		&OutputQueue.Writers.Context,
		&OutputQueue.Status.Context,
		&PlanCache.Summary.Context,
		&QueueOverview.Count.Context,
		&QueueOverview.Items.Context,
		&Subsystem.Jobs.Context,
		&System.CPUUtilization.Context,
		&System.CPUEntitledUtilization.Context,
		&System.CPUDetails.Context,
		&System.CPUCapacity.Context,
		&System.TotalJobs.Context,
		&System.ActiveJobsByType.Context,
		&System.JobQueueLength.Context,
		&System.MainStorageSize.Context,
		&System.TemporaryStorage.Context,
		&System.MemoryPoolUsage.Context,
		&System.MemoryPoolDefined.Context,
		&System.MemoryPoolReserved.Context,
		&System.MemoryPoolThreads.Context,
		&System.MemoryPoolMaxThreads.Context,
		&System.DiskBusyAverage.Context,
		&System.SystemASPUsage.Context,
		&System.SystemASPStorage.Context,
		&System.TotalAuxiliaryStorage.Context,
		&System.SystemThreads.Context,
		&System.NetworkConnections.Context,
		&System.NetworkConnectionStates.Context,
		&System.TempStorageTotal.Context,
		&System.SystemActivityCPURate.Context,
		&System.SystemActivityCPUUtilization.Context,
		&TempStorageBucket.Usage.Context,
	}
}
