
		SELECT
			COALESCE(MESSAGE_QUEUE_LIBRARY, '*UNKNOWN') AS MESSAGE_QUEUE_LIBRARY,
			COALESCE(MESSAGE_QUEUE_NAME, '*UNKNOWN') AS MESSAGE_QUEUE_NAME,
			COUNT(*) AS MESSAGE_COUNT,
			SUM(CASE WHEN MESSAGE_TYPE = 'INFORMATIONAL' THEN 1 ELSE 0 END) AS INFORMATIONAL_MESSAGES,
			SUM(CASE WHEN MESSAGE_TYPE = 'INQUIRY' THEN 1 ELSE 0 END) AS INQUIRY_MESSAGES,
			SUM(CASE WHEN MESSAGE_TYPE = 'DIAGNOSTIC' THEN 1 ELSE 0 END) AS DIAGNOSTIC_MESSAGES,
			SUM(CASE WHEN MESSAGE_TYPE = 'ESCAPE' THEN 1 ELSE 0 END) AS ESCAPE_MESSAGES,
			SUM(CASE WHEN MESSAGE_TYPE = 'NOTIFY' THEN 1 ELSE 0 END) AS NOTIFY_MESSAGES,
			SUM(CASE WHEN MESSAGE_TYPE = 'SENDER COPY' THEN 1 ELSE 0 END) AS SENDER_COPY_MESSAGES,
			COALESCE(MAX(SEVERITY), 0) AS MAX_SEVERITY
		FROM QSYS2.MESSAGE_QUEUE_INFO
		GROUP BY MESSAGE_QUEUE_LIBRARY, MESSAGE_QUEUE_NAME
		ORDER BY MESSAGE_COUNT DESC
		FETCH FIRST 200 ROWS ONLY
	