<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/health/notifications/matrix/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/health/notifications/matrix/metadata.yaml"
sidebar_label: "Matrix"
learn_status: "Published"
learn_rel_path: "Alerts & Notifications/Notifications/Agent Dispatched Notifications"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE NOTIFICATION'S metadata.yaml FILE"
endmeta-->

# Matrix


<img src="https://netdata.cloud/img/matrix.svg" width="150"/>


Send notifications to Matrix network rooms using Netdata's Agent alert notification feature, which supports dozens of endpoints, user roles, and more.


<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Setup


### Prerequisites

#### 

- The url of the homeserver (`https://homeserver:port`).
- Credentials for connecting to the homeserver, in the form of a valid access token for your account (or for a dedicated notification account). These tokens usually don't expire.
- The Room ids that you want to sent the notification to.
- Access to the terminal where Netdata Agent is running



### Configuration

#### Options

The following options can be defined for this notification

<details open><summary>Config Options</summary>



| Option | Description | Default | Required |
|:-----|:------------|:--------|:---------:|
| SEND_MATRIX | Set `SEND_MATRIX` to YES | YES | yes |
| MATRIX_HOMESERVER | set `MATRIX_HOMESERVER` to the URL of the Matrix homeserver. |  | yes |
| MATRIX_ACCESSTOKEN | Set `MATRIX_ACCESSTOKEN` to the access token from your Matrix account. |  | yes |
| DEFAULT_RECIPIENT_MATRIX | Set `DEFAULT_RECIPIENT_MATRIX`  to the Rooms you want the alert notifications to be sent to. The format is `!roomid:homeservername`. |  | yes |

##### MATRIX_ACCESSTOKEN

To obtain the access token, you can use the following curl command:
```
curl -XPOST -d '{"type":"m.login.password", "user":"example", "password":"wordpass"}' "https://homeserver:8448/_matrix/client/r0/login"
```


##### DEFAULT_RECIPIENT_MATRIX

The Room ids are unique identifiers and can be obtained from the Room settings in a Matrix client (e.g. Riot).

You can define multiple Rooms like this: `!roomid1:homeservername` `!roomid2:homeservername`.

All roles will default to this variable if left unconfigured.

You can have different Rooms per role, by editing `DEFAULT_RECIPIENT_MATRIX` with the `!roomid:homeservername` you want, in the following entries at the bottom of the same file:

```text
role_recipients_matrix[sysadmin]="!roomid1:homeservername"
role_recipients_matrix[domainadmin]="!roomid2:homeservername"
role_recipients_matrix[dba]="!roomid3:homeservername"
role_recipients_matrix[webmaster]="!roomid4:homeservername"
role_recipients_matrix[proxyadmin]="!roomid5:homeservername"
role_recipients_matrix[sitemgr]="!roomid6:homeservername"
```



</details>



#### via File

The configuration file name for this integration is `health_alarm_notify.conf`.


You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config health_alarm_notify.conf
```

##### Examples

###### Basic Configuration



```yaml
#------------------------------------------------------------------------------
# Matrix notifications

SEND_MATRIX="YES"
MATRIX_HOMESERVER="https://matrix.org:8448"
MATRIX_ACCESSTOKEN="XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX"
DEFAULT_RECIPIENT_MATRIX="!XXXXXXXXXXXX:matrix.org"

```


## Troubleshooting

### Test Notification

You can run the following command by hand, to test alerts configuration:

```bash
# become user netdata
sudo su -s /bin/bash netdata

# enable debugging info on the console
export NETDATA_ALARM_NOTIFY_DEBUG=1

# send test alarms to sysadmin
/usr/libexec/netdata/plugins.d/alarm-notify.sh test

# send test alarms to any role
/usr/libexec/netdata/plugins.d/alarm-notify.sh test "ROLE"
```

Note that this will test _all_ alert mechanisms for the selected role.


