/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.multitabs.impl;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.AbstractAction;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

class ScrollAction
extends AbstractAction
implements ChangeListener,
MouseWheelListener {
    private final JScrollPane scrollPane;
    private final boolean isHorizontal;
    private final boolean isScrollLeft;

    public ScrollAction(JScrollPane scrollPane, int orientation, boolean isScrollLeft) {
        this.isScrollLeft = isScrollLeft;
        this.scrollPane = scrollPane;
        this.isHorizontal = orientation == 1 || orientation == 3;
        scrollPane.getViewport().addChangeListener(this);
        scrollPane.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent e) {
                ScrollAction.this.updateEnabled();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.updateEnabled();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int increment = this.getDefaultIncrement();
        this.scroll(increment);
    }

    private void updateEnabled() {
        boolean enable = true;
        Component content = this.scrollPane.getViewport().getView();
        if (null != content) {
            Dimension size = content.getSize();
            Dimension viewSize = this.scrollPane.getViewport().getExtentSize();
            Point position = this.scrollPane.getViewport().getViewPosition();
            enable = this.isHorizontal ? (this.isScrollLeft ? position.x > 0 : position.x + viewSize.width < size.width) : (this.isScrollLeft ? position.y > 0 : position.y + viewSize.height < size.height);
        }
        this.setEnabled(enable);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateEnabled();
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        int rotation = e.getWheelRotation();
        if (rotation < 0 && this.isScrollLeft || rotation > 0 && !this.isScrollLeft) {
            int increment = this.getDefaultIncrement();
            this.scroll(increment *= Math.abs(rotation));
            e.consume();
        }
    }

    private int getDefaultIncrement() {
        Component content = this.scrollPane.getViewport().getView();
        Point position = this.scrollPane.getViewport().getViewPosition();
        int increment = this.isHorizontal ? 30 : 8;
        Dimension viewSize = this.scrollPane.getViewport().getExtentSize();
        if (content instanceof Scrollable) {
            increment = ((Scrollable)((Object)content)).getScrollableUnitIncrement(new Rectangle(position, viewSize), this.isHorizontal ? 0 : 1, this.isScrollLeft ? -1 : 1);
        }
        return increment;
    }

    private void scroll(int increment) {
        Component content = this.scrollPane.getViewport().getView();
        Dimension size = content.getSize();
        Dimension viewSize = this.scrollPane.getViewport().getExtentSize();
        Point position = this.scrollPane.getViewport().getViewPosition();
        if (this.isHorizontal) {
            position.x += increment;
            position.x = Math.max(position.x, 0);
            position.x = Math.min(position.x, size.width - viewSize.width);
        } else {
            position.y += increment;
            position.y = Math.max(position.y, 0);
            position.y = Math.min(position.y, size.height - viewSize.height);
        }
        this.scrollPane.getViewport().setViewPosition(position);
    }
}

