/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.statistics.plugin;

import it.unimi.dsi.fastutil.objects.Object2DoubleOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.gephi.graph.api.Column;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.EdgeIterable;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.GraphController;
import org.gephi.graph.api.GraphModel;
import org.gephi.graph.api.Node;
import org.gephi.graph.api.NodeIterable;
import org.gephi.graph.api.Table;
import org.gephi.statistics.plugin.ChartUtils;
import org.gephi.statistics.plugin.ColumnUtils;
import org.gephi.statistics.spi.Statistics;
import org.gephi.utils.longtask.spi.LongTask;
import org.gephi.utils.progress.Progress;
import org.gephi.utils.progress.ProgressTicket;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;
import org.openide.util.Lookup;

public class PageRank
implements Statistics,
LongTask {
    public static final String PAGERANK = "pageranks";
    private ProgressTicket progress;
    private boolean isCanceled;
    private double epsilon = 0.001;
    private double probability = 0.85;
    private boolean useEdgeWeight = false;
    private double[] pageranks;
    private boolean isDirected;

    public PageRank() {
        GraphController graphController = (GraphController)Lookup.getDefault().lookup(GraphController.class);
        if (graphController != null && graphController.getGraphModel() != null) {
            this.isDirected = graphController.getGraphModel().isDirected();
        }
    }

    public boolean getDirected() {
        return this.isDirected;
    }

    public void setDirected(boolean isDirected) {
        this.isDirected = isDirected;
    }

    public void execute(GraphModel graphModel) {
        Object graph = this.isDirected ? graphModel.getDirectedGraphVisible() : graphModel.getUndirectedGraphVisible();
        this.execute((Graph)graph);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(Graph graph) {
        this.isCanceled = false;
        Column column = this.initializeAttributeColunms(graph.getModel());
        graph.readLock();
        try {
            HashMap<Node, Integer> indicies = this.createIndiciesMap(graph);
            this.pageranks = this.calculatePagerank(graph, indicies, this.isDirected, this.useEdgeWeight, this.epsilon, this.probability);
            this.saveCalculatedValues(graph, column, indicies, this.pageranks);
        }
        finally {
            graph.readUnlockAll();
        }
    }

    private Column initializeAttributeColunms(GraphModel graphModel) {
        Table nodeTable = graphModel.getNodeTable();
        ColumnUtils.cleanUpColumns(nodeTable, new String[]{PAGERANK}, Double.class);
        Column pagerankCol = nodeTable.getColumn(PAGERANK);
        if (pagerankCol == null) {
            pagerankCol = nodeTable.addColumn(PAGERANK, "PageRank", Double.class, (Object)new Double(0.0));
        }
        return pagerankCol;
    }

    private void saveCalculatedValues(Graph graph, Column attributeColumn, HashMap<Node, Integer> indicies, double[] nodePagrank) {
        for (Node s : graph.getNodes()) {
            int s_index = indicies.get(s);
            s.setAttribute(attributeColumn, (Object)nodePagrank[s_index]);
        }
    }

    private void setInitialValues(Graph graph, Map<Node, Integer> indicies, double[] pagerankValues, double[] weights, boolean directed, boolean useWeights) {
        int N = graph.getNodeCount();
        for (Node s : graph.getNodes()) {
            int index = indicies.get(s);
            pagerankValues[index] = 1.0 / (double)N;
            if (!useWeights) continue;
            double sum = 0.0;
            EdgeIterable eIter = directed ? ((DirectedGraph)graph).getOutEdges(s) : graph.getEdges(s);
            for (Edge edge : eIter) {
                if (edge.isSelfLoop()) continue;
                sum += edge.getWeight();
            }
            weights[index] = sum;
        }
    }

    private double calculateR(Graph graph, double[] pagerankValues, HashMap<Node, Integer> indicies, boolean directed, double prob) {
        int N = graph.getNodeCount();
        double r = (1.0 - prob) / (double)N;
        NodeIterable nodesIterable = graph.getNodes();
        double danglingNodesRankContrib = 0.0;
        for (Node s : graph.getNodes()) {
            int s_index = indicies.get(s);
            int outDegree = directed ? ((DirectedGraph)graph).getOutDegree(s) : graph.getDegree(s);
            if (outDegree == 0) {
                danglingNodesRankContrib += pagerankValues[s_index];
            }
            if (!this.isCanceled) continue;
            nodesIterable.doBreak();
            break;
        }
        return r += (danglingNodesRankContrib *= prob / (double)N);
    }

    private Map<Node, Set<Node>> calculateInNeighborsPerNode(Graph graph, boolean directed) {
        Object2ObjectOpenHashMap inNeighborsPerNode = new Object2ObjectOpenHashMap();
        NodeIterable nodesIterable = graph.getNodes();
        for (Node node : nodesIterable) {
            ObjectOpenHashSet nodeInNeighbors = new ObjectOpenHashSet();
            EdgeIterable edgesIterable = directed ? ((DirectedGraph)graph).getInEdges(node) : graph.getEdges(node);
            for (Edge edge : edgesIterable) {
                if (!edge.isSelfLoop()) {
                    Node neighbor = graph.getOpposite(node, edge);
                    nodeInNeighbors.add(neighbor);
                }
                if (!this.isCanceled) continue;
                edgesIterable.doBreak();
                break;
            }
            inNeighborsPerNode.put(node, nodeInNeighbors);
            if (!this.isCanceled) continue;
            nodesIterable.doBreak();
            break;
        }
        return inNeighborsPerNode;
    }

    private Map<Node, Object2DoubleOpenHashMap<Node>> calculateInWeightPerNodeAndNeighbor(Graph graph, boolean directed, boolean useWeights) {
        Object2ObjectOpenHashMap inWeightPerNodeAndNeighbor = new Object2ObjectOpenHashMap();
        if (useWeights) {
            NodeIterable nodesIterable = graph.getNodes();
            for (Node node : nodesIterable) {
                Object2DoubleOpenHashMap inWeightPerNeighbor = new Object2DoubleOpenHashMap();
                inWeightPerNeighbor.defaultReturnValue(0.0);
                EdgeIterable edgesIterable = directed ? ((DirectedGraph)graph).getInEdges(node) : graph.getEdges(node);
                for (Edge edge : edgesIterable) {
                    if (!edge.isSelfLoop()) {
                        Node neighbor = graph.getOpposite(node, edge);
                        inWeightPerNeighbor.addTo((Object)neighbor, edge.getWeight());
                    }
                    if (!this.isCanceled) continue;
                    edgesIterable.doBreak();
                    break;
                }
                if (this.isCanceled) {
                    nodesIterable.doBreak();
                    break;
                }
                inWeightPerNodeAndNeighbor.put((Object)node, (Object)inWeightPerNeighbor);
            }
        }
        return inWeightPerNodeAndNeighbor;
    }

    private double updateValueForNode(Graph graph, Node node, double[] pagerankValues, double[] weights, HashMap<Node, Integer> indicies, boolean directed, boolean useWeights, double r, double prob, Map<Node, Set<Node>> inNeighborsPerNode, Object2DoubleOpenHashMap<Node> inWeightPerNeighbor) {
        double res = r;
        double sumNeighbors = 0.0;
        for (Node neighbor : inNeighborsPerNode.get(node)) {
            int neigh_index = indicies.get(neighbor);
            if (useWeights) {
                double weight = inWeightPerNeighbor.getDouble((Object)neighbor) / weights[neigh_index];
                sumNeighbors += pagerankValues[neigh_index] * weight;
                continue;
            }
            int outDegree = directed ? ((DirectedGraph)graph).getOutDegree(neighbor) : graph.getDegree(neighbor);
            sumNeighbors += pagerankValues[neigh_index] / (double)outDegree;
        }
        return res += prob * sumNeighbors;
    }

    double[] calculatePagerank(Graph graph, HashMap<Node, Integer> indicies, boolean directed, boolean useWeights, double eps, double prob) {
        boolean done;
        int N = graph.getNodeCount();
        double[] pagerankValues = new double[N];
        double[] temp = new double[N];
        Progress.start((ProgressTicket)this.progress);
        double[] weights = useWeights ? new double[N] : null;
        Map<Node, Set<Node>> inNeighborsPerNode = this.calculateInNeighborsPerNode(graph, directed);
        Map<Node, Object2DoubleOpenHashMap<Node>> inWeightPerNodeAndNeighbor = this.calculateInWeightPerNodeAndNeighbor(graph, directed, useWeights);
        this.setInitialValues(graph, indicies, pagerankValues, weights, directed, useWeights);
        do {
            done = true;
            double r = this.calculateR(graph, pagerankValues, indicies, directed, prob);
            NodeIterable nodesIterable = graph.getNodes();
            for (Node s : nodesIterable) {
                int s_index = indicies.get(s);
                temp[s_index] = this.updateValueForNode(graph, s, pagerankValues, weights, indicies, directed, useWeights, r, prob, inNeighborsPerNode, inWeightPerNodeAndNeighbor.get(s));
                if ((temp[s_index] - pagerankValues[s_index]) / pagerankValues[s_index] >= eps) {
                    done = false;
                }
                if (!this.isCanceled) continue;
                nodesIterable.doBreak();
                return pagerankValues;
            }
            pagerankValues = temp;
            temp = new double[N];
        } while (!done && !this.isCanceled);
        return pagerankValues;
    }

    public HashMap<Node, Integer> createIndiciesMap(Graph graph) {
        HashMap<Node, Integer> newIndicies = new HashMap<Node, Integer>();
        int index = 0;
        for (Node s : graph.getNodes()) {
            newIndicies.put(s, index);
            ++index;
        }
        return newIndicies;
    }

    public String getReport() {
        HashMap<Double, Integer> dist = new HashMap<Double, Integer>();
        for (int i = 0; i < this.pageranks.length; ++i) {
            Double d = this.pageranks[i];
            if (dist.containsKey(d)) {
                Integer v = (Integer)dist.get(d);
                dist.put(d, v + 1);
                continue;
            }
            dist.put(d, 1);
        }
        XYSeries dSeries = ChartUtils.createXYSeries(dist, "PageRanks");
        XYSeriesCollection dataset = new XYSeriesCollection();
        dataset.addSeries(dSeries);
        JFreeChart chart = ChartFactory.createXYLineChart((String)"PageRank Distribution", (String)"Score", (String)"Count", (XYDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)false, (boolean)false);
        chart.removeLegend();
        ChartUtils.decorateChart(chart);
        ChartUtils.scaleChart(chart, dSeries, true);
        String imageFile = ChartUtils.renderChart(chart, "pageranks.png");
        String report = "<HTML> <BODY> <h1>PageRank Report </h1> <hr> <br /><h2> Parameters: </h2>Epsilon = " + this.epsilon + "<br>Probability = " + this.probability + "<br> <h2> Results: </h2>" + imageFile + "<br /><br /><h2> Algorithm: </h2>Page, Lawrence and Brin, Sergey and Motwani, Rajeev and Winograd, Terry (1999) <i>The PageRank Citation Ranking: Bringing Order to the Web.</i> Technical Report. Stanford InfoLab.<br /></BODY> </HTML>";
        return report;
    }

    public boolean cancel() {
        this.isCanceled = true;
        return true;
    }

    public void setProgressTicket(ProgressTicket progressTicket) {
        this.progress = progressTicket;
    }

    public double getProbability() {
        return this.probability;
    }

    public void setProbability(double prob) {
        this.probability = prob;
    }

    public double getEpsilon() {
        return this.epsilon;
    }

    public void setEpsilon(double eps) {
        this.epsilon = eps;
    }

    public boolean isUseEdgeWeight() {
        return this.useEdgeWeight;
    }

    public void setUseEdgeWeight(boolean useEdgeWeight) {
        this.useEdgeWeight = useEdgeWeight;
    }
}

