/*
 * Decompiled with CFR 0.152.
 */
package org.freedesktop.dbus.connections.base;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import java.util.Queue;
import org.freedesktop.dbus.DBusAsyncReply;
import org.freedesktop.dbus.DBusCallInfo;
import org.freedesktop.dbus.DBusMatchRule;
import org.freedesktop.dbus.MethodTuple;
import org.freedesktop.dbus.RemoteInvocationHandler;
import org.freedesktop.dbus.connections.base.DBusBoundPropertyHandler;
import org.freedesktop.dbus.connections.base.GlobalHandler;
import org.freedesktop.dbus.connections.config.ReceivingServiceConfig;
import org.freedesktop.dbus.connections.config.TransportConfig;
import org.freedesktop.dbus.connections.impl.ConnectionConfig;
import org.freedesktop.dbus.errors.UnknownMethod;
import org.freedesktop.dbus.errors.UnknownObject;
import org.freedesktop.dbus.exceptions.DBusException;
import org.freedesktop.dbus.exceptions.DBusExecutionException;
import org.freedesktop.dbus.interfaces.CallbackHandler;
import org.freedesktop.dbus.interfaces.DBusInterface;
import org.freedesktop.dbus.interfaces.DBusSigHandler;
import org.freedesktop.dbus.messages.DBusSignal;
import org.freedesktop.dbus.messages.Error;
import org.freedesktop.dbus.messages.ExportedObject;
import org.freedesktop.dbus.messages.Message;
import org.freedesktop.dbus.messages.MethodCall;
import org.freedesktop.dbus.messages.MethodReturn;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public abstract class ConnectionMessageHandler
extends DBusBoundPropertyHandler {
    protected ConnectionMessageHandler(ConnectionConfig _conCfg, TransportConfig _transportConfig, ReceivingServiceConfig _rsCfg) throws DBusException {
        super(_conCfg, _transportConfig, _rsCfg);
    }

    @Override
    protected void handleException(Message _methodOrSignal, DBusExecutionException _exception) {
        try {
            this.sendMessage(this.getMessageFactory().createError(_methodOrSignal, _exception));
        }
        catch (DBusException _ex) {
            this.getLogger().warn("Exception caught while processing previous error.", (Throwable)_ex);
        }
    }

    private void handleMessage(DBusSignal _signal, boolean _useThreadPool) {
        Runnable command;
        this.getLogger().debug("Handling incoming signal: {}", (Object)_signal);
        ArrayList handlers = new ArrayList();
        ArrayList genericHandlers = new ArrayList();
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            handlers.addAll(entry.getValue());
        }
        for (Map.Entry<DBusMatchRule, Queue<DBusSigHandler<? extends DBusSignal>>> entry : this.getGenericHandledSignals().entrySet()) {
            if (!entry.getKey().matches(_signal, false)) continue;
            genericHandlers.addAll(entry.getValue());
        }
        if (handlers.isEmpty() && genericHandlers.isEmpty()) {
            return;
        }
        ConnectionMessageHandler conn = this;
        for (DBusSigHandler h : handlers) {
            this.getLogger().trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> {
                try {
                    DBusSignal rs = _signal.getClass().equals(DBusSignal.class) ? _signal.createReal(conn) : _signal;
                    if (rs == null) {
                        return;
                    }
                    h.handle(rs);
                }
                catch (DBusException _ex) {
                    this.getLogger().warn("Exception while running signal handler '{}' for signal '{}':", new Object[]{h, _signal, _ex});
                    this.handleException(_signal, new DBusExecutionException("Error handling signal " + _signal.getInterface() + "." + _signal.getName() + ": " + _ex.getMessage(), _ex));
                }
            };
            if (_useThreadPool) {
                this.getReceivingService().execSignalHandler(command);
                continue;
            }
            command.run();
        }
        for (DBusSigHandler h : genericHandlers) {
            this.getLogger().trace("Adding Runnable for signal {} with handler {}", (Object)_signal, (Object)h);
            command = () -> h.handle(_signal);
            if (_useThreadPool) {
                this.getReceivingService().execSignalHandler(command);
                continue;
            }
            command.run();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(final Error _err) {
        this.getLogger().debug("Handling incoming error: {}", (Object)_err);
        MethodCall m = null;
        if (this.getPendingCalls() == null) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_err.getReplySerial())) {
                m = this.getPendingCalls().remove(_err.getReplySerial());
            }
        }
        if (m != null) {
            m.setReply(_err);
            CallbackHandler<? extends Object> cbh = this.getCallbackManager().removeCallback(m);
            this.getLogger().trace("{} = pendingCallbacks.remove({})", cbh, (Object)m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                this.getLogger().trace("Adding Error Runnable with callback handler {}", fcbh);
                Runnable command = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            ConnectionMessageHandler.this.getLogger().trace("Running Error Callback for {}", (Object)_err);
                            DBusCallInfo info = new DBusCallInfo(_err);
                            ConnectionMessageHandler.this.getInfoMap().put(Thread.currentThread(), info);
                            fcbh.handleError(_err.getException());
                            ConnectionMessageHandler.this.getInfoMap().remove(Thread.currentThread());
                        }
                        catch (Exception _ex) {
                            ConnectionMessageHandler.this.getLogger().debug("Exception while running error callback.", (Throwable)_ex);
                        }
                    }
                };
                this.getReceivingService().execErrorHandler(command);
            }
        } else {
            this.getPendingErrorQueue().add(_err);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleMessage(final MethodReturn _mr) {
        this.getLogger().debug("Handling incoming method return: {}", (Object)_mr);
        MethodCall m = null;
        if (null == this.getPendingCalls()) {
            return;
        }
        Map<Long, MethodCall> map = this.getPendingCalls();
        synchronized (map) {
            if (this.getPendingCalls().containsKey(_mr.getReplySerial())) {
                m = this.getPendingCalls().remove(_mr.getReplySerial());
            }
        }
        if (null != m) {
            m.setReply(_mr);
            _mr.setCall(m);
            CallbackHandler<? extends Object> cbh = this.getCallbackManager().getCallback(m);
            DBusAsyncReply<?> asr = this.getCallbackManager().getCallbackReply(m);
            this.getCallbackManager().removeCallback(m);
            if (null != cbh) {
                final CallbackHandler<? extends Object> fcbh = cbh;
                final DBusAsyncReply<?> fasr = asr;
                if (fasr == null) {
                    this.getLogger().debug("Cannot add runnable for method, given method callback was null");
                    return;
                }
                this.getLogger().trace("Adding Runnable for method {} with callback handler {}", fcbh, (Object)fasr.getMethod());
                Runnable r = new Runnable(){

                    @Override
                    public synchronized void run() {
                        try {
                            ConnectionMessageHandler.this.getLogger().trace("Running Callback for {}", (Object)_mr);
                            DBusCallInfo info = new DBusCallInfo(_mr);
                            ConnectionMessageHandler.this.getInfoMap().put(Thread.currentThread(), info);
                            Object convertRV = RemoteInvocationHandler.convertRV(_mr.getParameters(), fasr.getMethod(), fasr.getConnection());
                            fcbh.handle(convertRV);
                            ConnectionMessageHandler.this.getInfoMap().remove(Thread.currentThread());
                        }
                        catch (Exception _ex) {
                            ConnectionMessageHandler.this.getLogger().debug("Exception while running callback.", (Throwable)_ex);
                        }
                    }
                };
                this.getReceivingService().execMethodReturnHandler(r);
            }
        } else {
            try {
                this.sendMessage(this.getMessageFactory().createError(_mr, new DBusExecutionException("Spurious reply. No message with the given serial id was awaiting a reply.")));
            }
            catch (DBusException _exDe) {
                this.getLogger().trace("Could not send error message", (Throwable)_exDe);
            }
        }
    }

    void handleMessage(Message _message) throws DBusException {
        if (_message instanceof DBusSignal) {
            DBusSignal sig = (DBusSignal)_message;
            this.handleMessage(sig, true);
        } else if (_message instanceof MethodCall) {
            MethodCall mc = (MethodCall)_message;
            this.handleMessage(mc);
        } else if (_message instanceof MethodReturn) {
            MethodReturn mr = (MethodReturn)_message;
            this.handleMessage(mr);
        } else if (_message instanceof Error) {
            Error err = (Error)_message;
            this.handleMessage(err);
        }
    }

    private void handleMessage(MethodCall _methodCall) throws DBusException {
        ExportedObject exportObject;
        this.getLogger().debug("Handling incoming method call: {}", (Object)_methodCall);
        Method meth = null;
        DBusInterface o = null;
        if (null == _methodCall.getInterface() || _methodCall.getInterface().equals("org.freedesktop.DBus.Peer") || _methodCall.getInterface().equals("org.freedesktop.DBus.Introspectable")) {
            exportObject = this.doWithExportedObjectsAndReturn(DBusException.class, eos -> (ExportedObject)eos.get(null));
            if (null != exportObject && null == exportObject.getObject().get()) {
                this.unExportObject(null);
                exportObject = null;
            }
            if (exportObject != null) {
                meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()));
            }
            if (meth != null) {
                o = new GlobalHandler(this, _methodCall.getPath());
            }
        }
        if (o == null) {
            exportObject = this.doWithExportedObjectsAndReturn(DBusException.class, eos -> (ExportedObject)eos.get(_methodCall.getPath()));
            this.getLogger().debug("Found exported object: {}", exportObject == null ? "<no object found>" : exportObject);
            if (exportObject != null && exportObject.getObject().get() == null) {
                this.getLogger().info("Unexporting {} implicitly (object present: {}, reference present: {})", new Object[]{_methodCall.getPath(), exportObject != null, exportObject.getObject().get() == null});
                this.unExportObject(_methodCall.getPath());
                exportObject = null;
            }
            if (exportObject == null) {
                exportObject = this.getFallbackContainer().get(_methodCall.getPath());
                this.getLogger().debug("Found {} in fallback container", exportObject == null ? "no" : exportObject);
            }
            if (exportObject == null) {
                this.getLogger().debug("No object found for method {}", (Object)_methodCall.getPath());
                this.sendMessage(this.getMessageFactory().createError(_methodCall, new UnknownObject(_methodCall.getPath() + " is not an object provided by this process.")));
                return;
            }
            if (this.getLogger().isTraceEnabled()) {
                this.getLogger().trace("Searching for method {}  with signature {}", (Object)_methodCall.getName(), (Object)_methodCall.getSig());
                this.getLogger().trace("List of methods on {}: ", (Object)exportObject);
                for (MethodTuple mt : exportObject.getMethods().keySet()) {
                    this.getLogger().trace("   {} => {}", (Object)mt, (Object)exportObject.getMethods().get(mt));
                }
            }
            Object[] params = _methodCall.getParameters();
            switch (this.handleDBusBoundProperties(exportObject, _methodCall, params)) {
                case HANDLED: {
                    return;
                }
                case NO_PROPERTY: {
                    this.rejectUnknownProperty(_methodCall, params);
                    return;
                }
            }
            if (meth == null && (meth = exportObject.getMethods().get(new MethodTuple(_methodCall.getName(), _methodCall.getSig()))) == null) {
                this.sendMessage(this.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' does not exist on this object.", _methodCall.getInterface(), _methodCall.getName()))));
                return;
            }
            o = exportObject.getObject().get();
        }
        if (ExportedObject.isExcluded(meth)) {
            this.sendMessage(this.getMessageFactory().createError(_methodCall, new UnknownMethod(String.format("The method `%s.%s' is not exported.", _methodCall.getInterface(), _methodCall.getName()))));
            return;
        }
        this.queueInvokeMethod(_methodCall, meth, o);
    }
}

