/*
 * Decompiled with CFR 0.152.
 */
package ir.amirab.util.datasize;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0017\u0018\u0019B\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0086\u0002J\u0010\u0010\u000b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\nH\u0002J\u001e\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u00032\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\n0\rJ\u0016\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00122\u0006\u0010\t\u001a\u00020\nJ\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH&J\u0010\u0010\u0016\u001a\u00020\u00152\u0006\u0010\t\u001a\u00020\nH&R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00030\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0001\u0002\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lir/amirab/util/datasize/SizeFactors;", "", "baseValue", "", "<init>", "(J)V", "getBaseValue", "()J", "get", "factorValue", "Lir/amirab/util/datasize/SizeFactors$FactorValue;", "getFactorSize", "factors", "", "bestFactor", "value", "acceptedFactors", "removeFactor", "", "withFactor", "toString", "", "toLongString", "FactorValue", "DecimalSizeFactors", "BinarySizeFactors", "Lir/amirab/util/datasize/SizeFactors$BinarySizeFactors;", "Lir/amirab/util/datasize/SizeFactors$DecimalSizeFactors;", "utils"})
@SourceDebugExtension(value={"SMAP\nSizeFactors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SizeFactors.kt\nir/amirab/util/datasize/SizeFactors\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1563#2:123\n1634#2,3:124\n543#2,6:127\n2393#2,14:133\n*S KotlinDebug\n*F\n+ 1 SizeFactors.kt\nir/amirab/util/datasize/SizeFactors\n*L\n27#1:123\n27#1:124,3\n45#1:127,6\n52#1:133,14\n*E\n"})
public abstract sealed class SizeFactors {
    private final long baseValue;
    @NotNull
    private final List<Long> factors;

    /*
     * WARNING - void declaration
     */
    private SizeFactors(long baseValue) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        this.baseValue = baseValue;
        Iterable iterable = (Iterable)FactorValue.getEntries();
        SizeFactors sizeFactors = this;
        boolean $i$f$map = false;
        void var5_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            FactorValue factorValue = (FactorValue)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((long)Math.pow(this.baseValue, it.ordinal()));
        }
        sizeFactors.factors = (List)destination$iv$iv;
    }

    public final long getBaseValue() {
        return this.baseValue;
    }

    public final long get(@NotNull FactorValue factorValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
        return this.getFactorSize(factorValue);
    }

    private final long getFactorSize(FactorValue factorValue) {
        return ((Number)this.factors.get(factorValue.ordinal())).longValue();
    }

    @NotNull
    public final FactorValue bestFactor(long value, @NotNull List<? extends FactorValue> acceptedFactors) {
        FactorValue factorValue;
        FactorValue factorValue2;
        FactorValue it;
        Iterator<FactorValue> iterator$iv;
        block9: {
            Intrinsics.checkNotNullParameter(acceptedFactors, (String)"acceptedFactors");
            if (!(!((Collection)acceptedFactors).isEmpty())) {
                boolean $i$a$-require-SizeFactors$bestFactor$22 = false;
                String $i$a$-require-SizeFactors$bestFactor$22 = "acceptedFactors must not be empty";
                throw new IllegalArgumentException($i$a$-require-SizeFactors$bestFactor$22.toString());
            }
            if (value == 0L) {
                return (FactorValue)((Object)CollectionsKt.first(acceptedFactors));
            }
            if (acceptedFactors.size() == 1) {
                return (FactorValue)((Object)CollectionsKt.first(acceptedFactors));
            }
            List<? extends FactorValue> $this$lastOrNull$iv = acceptedFactors;
            boolean $i$f$lastOrNull = false;
            iterator$iv = $this$lastOrNull$iv.listIterator($this$lastOrNull$iv.size());
            while (iterator$iv.hasPrevious()) {
                FactorValue element$iv;
                it = element$iv = iterator$iv.previous();
                boolean bl = false;
                if (!(this.getFactorSize(it) <= value)) continue;
                factorValue2 = element$iv;
                break block9;
            }
            factorValue2 = null;
        }
        FactorValue inRange = factorValue2;
        if (inRange != null) {
            return inRange;
        }
        Iterable $this$minBy$iv = acceptedFactors;
        boolean $i$f$minByOrThrow = false;
        iterator$iv = $this$minBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            throw new NoSuchElementException();
        }
        FactorValue minElem$iv = iterator$iv.next();
        if (!iterator$iv.hasNext()) {
            factorValue = minElem$iv;
        } else {
            it = minElem$iv;
            boolean bl = false;
            long minValue$iv = Math.abs(value - this.getFactorSize(it));
            do {
                FactorValue e$iv;
                FactorValue it2 = e$iv = iterator$iv.next();
                $i$a$-minByOrThrow-SizeFactors$bestFactor$2 = false;
                long v$iv = Math.abs(value - this.getFactorSize(it2));
                if (minValue$iv <= v$iv) continue;
                minElem$iv = e$iv;
                minValue$iv = v$iv;
            } while (iterator$iv.hasNext());
            factorValue = minElem$iv;
        }
        return factorValue;
    }

    public static /* synthetic */ FactorValue bestFactor$default(SizeFactors sizeFactors, long l, List list, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: bestFactor");
        }
        if ((n & 2) != 0) {
            list = (List)FactorValue.getEntries();
        }
        return sizeFactors.bestFactor(l, list);
    }

    public final long removeFactor(double value, @NotNull FactorValue factorValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
        return (long)(value * (double)this.getFactorSize(factorValue));
    }

    public final double withFactor(double value, @NotNull FactorValue factorValue) {
        Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
        if (factorValue == FactorValue.None) {
            return value;
        }
        return value / (double)this.getFactorSize(factorValue);
    }

    @NotNull
    public abstract String toString(@NotNull FactorValue var1);

    @NotNull
    public abstract String toLongString(@NotNull FactorValue var1);

    public /* synthetic */ SizeFactors(long baseValue, DefaultConstructorMarker $constructor_marker) {
        this(baseValue);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0004\u001a\u00020\u0005H\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lir/amirab/util/datasize/SizeFactors$BinarySizeFactors;", "Lir/amirab/util/datasize/SizeFactors;", "<init>", "()V", "toString", "", "factorValue", "Lir/amirab/util/datasize/SizeFactors$FactorValue;", "toLongString", "equals", "", "other", "", "hashCode", "", "utils"})
    public static final class BinarySizeFactors
    extends SizeFactors {
        @NotNull
        public static final BinarySizeFactors INSTANCE = new BinarySizeFactors();

        private BinarySizeFactors() {
            super(1024L, null);
        }

        @Override
        @NotNull
        public String toString(@NotNull FactorValue factorValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
            return switch (WhenMappings.$EnumSwitchMapping$0[factorValue.ordinal()]) {
                case 1 -> "";
                case 2 -> "Ki";
                case 3 -> "Mi";
                case 4 -> "Gi";
                case 5 -> "Ti";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Override
        @NotNull
        public String toLongString(@NotNull FactorValue factorValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
            return switch (WhenMappings.$EnumSwitchMapping$0[factorValue.ordinal()]) {
                case 1 -> "";
                case 2 -> "Kibi";
                case 3 -> "Mebi";
                case 4 -> "Gibi";
                case 5 -> "Tebi";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String toString() {
            return "BinarySizeFactors";
        }

        public int hashCode() {
            return -409748755;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof BinarySizeFactors)) {
                return false;
            }
            BinarySizeFactors cfr_ignored_0 = (BinarySizeFactors)other;
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FactorValue.values().length];
                try {
                    nArray[FactorValue.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Kilo.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Mega.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Giga.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Tera.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u0004\u001a\u00020\u0005H\u00d6\u0001\u00a8\u0006\u000f"}, d2={"Lir/amirab/util/datasize/SizeFactors$DecimalSizeFactors;", "Lir/amirab/util/datasize/SizeFactors;", "<init>", "()V", "toString", "", "factorValue", "Lir/amirab/util/datasize/SizeFactors$FactorValue;", "toLongString", "equals", "", "other", "", "hashCode", "", "utils"})
    public static final class DecimalSizeFactors
    extends SizeFactors {
        @NotNull
        public static final DecimalSizeFactors INSTANCE = new DecimalSizeFactors();

        private DecimalSizeFactors() {
            super(1000L, null);
        }

        @Override
        @NotNull
        public String toString(@NotNull FactorValue factorValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
            return switch (WhenMappings.$EnumSwitchMapping$0[factorValue.ordinal()]) {
                case 1 -> "";
                case 2 -> "K";
                case 3 -> "M";
                case 4 -> "G";
                case 5 -> "T";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @Override
        @NotNull
        public String toLongString(@NotNull FactorValue factorValue) {
            Intrinsics.checkNotNullParameter((Object)((Object)factorValue), (String)"factorValue");
            return switch (WhenMappings.$EnumSwitchMapping$0[factorValue.ordinal()]) {
                case 1 -> "";
                case 2 -> "Kilo";
                case 3 -> "Mega";
                case 4 -> "Giga";
                case 5 -> "Tera";
                default -> throw new NoWhenBranchMatchedException();
            };
        }

        @NotNull
        public String toString() {
            return "DecimalSizeFactors";
        }

        public int hashCode() {
            return -1972586713;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DecimalSizeFactors)) {
                return false;
            }
            DecimalSizeFactors cfr_ignored_0 = (DecimalSizeFactors)other;
            return true;
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[FactorValue.values().length];
                try {
                    nArray[FactorValue.None.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Kilo.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Mega.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Giga.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[FactorValue.Tera.ordinal()] = 5;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\b\u00a8\u0006\t"}, d2={"Lir/amirab/util/datasize/SizeFactors$FactorValue;", "", "<init>", "(Ljava/lang/String;I)V", "None", "Kilo", "Mega", "Giga", "Tera", "utils"})
    public static final class FactorValue
    extends Enum<FactorValue> {
        public static final /* enum */ FactorValue None = new FactorValue();
        public static final /* enum */ FactorValue Kilo = new FactorValue();
        public static final /* enum */ FactorValue Mega = new FactorValue();
        public static final /* enum */ FactorValue Giga = new FactorValue();
        public static final /* enum */ FactorValue Tera = new FactorValue();
        private static final /* synthetic */ FactorValue[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static FactorValue[] values() {
            return (FactorValue[])$VALUES.clone();
        }

        public static FactorValue valueOf(String value) {
            return Enum.valueOf(FactorValue.class, value);
        }

        @NotNull
        public static EnumEntries<FactorValue> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = factorValueArray = new FactorValue[]{FactorValue.None, FactorValue.Kilo, FactorValue.Mega, FactorValue.Giga, FactorValue.Tera};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

