/*
 * Decompiled with CFR 0.152.
 */
package io.github.irgaly.kfswatch.internal.platform;

import com.sun.nio.file.SensitivityWatchEventModifier;
import io.github.irgaly.kfswatch.internal.platform.FileWatcherEvent;
import io.github.irgaly.kfswatch.internal.platform.FileWatcherRawEvent;
import io.github.irgaly.kfswatch.internal.platform.Logger;
import io.github.irgaly.kfswatch.internal.platform.Platform;
import io.github.irgaly.kfswatch.internal.platform.PlatformPath;
import java.io.File;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.concurrent.ThreadsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0010 \n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u00aa\u0002\u0012K\u0010\u0002\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003\u0012!\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\r\u0012!\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\r\u0012#\u0010\u000f\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\r\u00128\u0010\u0010\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u000b0\u0011\u0012#\u0010\u0013\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r\u0012\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0014\u0010)\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+J\u0014\u0010,\u001a\u00020\u000b2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\u00040+J\u0006\u0010-\u001a\u00020\u000bJ\u0006\u0010.\u001a\u00020\u000bJ\u0006\u0010/\u001a\u00020\u000bJ\u0006\u00100\u001a\u00020\u000bRS\u0010\u0002\u001aG\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\b\u0012\u0013\u0012\u00110\t\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b0\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\f\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R)\u0010\u000e\u001a\u001d\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u000f\u001a\u001f\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0004\u0012\u00020\u000b0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R@\u0010\u0010\u001a4\u0012\u0015\u0012\u0013\u0018\u00010\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0007\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\u0012\u0012\u0004\u0012\u00020\u000b0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010\u0013\u001a\u001f\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0005\u0012\b\b\u0006\u0012\u0004\b\b(\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u00020\"0 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010#\u001a\u00020$8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010(\u001a\u0004\b%\u0010&\u00a8\u00061"}, d2={"Lio/github/irgaly/kfswatch/internal/platform/FileWatcher;", "", "onEvent", "Lkotlin/Function3;", "", "Lkotlin/ParameterName;", "name", "targetDirectory", "path", "Lio/github/irgaly/kfswatch/internal/platform/FileWatcherEvent;", "event", "", "onStart", "Lkotlin/Function1;", "onStop", "onOverflow", "onError", "Lkotlin/Function2;", "message", "onRawEvent", "Lio/github/irgaly/kfswatch/internal/platform/FileWatcherRawEvent;", "logger", "Lio/github/irgaly/kfswatch/internal/platform/Logger;", "<init>", "(Lkotlin/jvm/functions/Function3;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function2;Lkotlin/jvm/functions/Function1;Lio/github/irgaly/kfswatch/internal/platform/Logger;)V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "threadLock", "Ljava/util/concurrent/Semaphore;", "watchService", "Ljava/nio/file/WatchService;", "keys", "", "Lio/github/irgaly/kfswatch/internal/platform/PlatformPath;", "Ljava/nio/file/WatchKey;", "needsSensitivityHigh", "", "getNeedsSensitivityHigh", "()Z", "needsSensitivityHigh$delegate", "Lkotlin/Lazy;", "start", "targetDirectories", "", "stop", "stopAll", "pause", "resume", "close", "kfswatch"})
@SourceDebugExtension(value={"SMAP\nFileWatcher.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileWatcher.kt\nio/github/irgaly/kfswatch/internal/platform/FileWatcher\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,252:1\n1563#2:253\n1634#2,3:254\n1869#2:257\n295#2,2:258\n1870#2:260\n1193#2,2:263\n1267#2,4:265\n1869#2,2:269\n216#3,2:261\n216#3,2:271\n*S KotlinDebug\n*F\n+ 1 FileWatcher.kt\nio/github/irgaly/kfswatch/internal/platform/FileWatcher\n*L\n50#1:253\n50#1:254,3\n205#1:257\n207#1:258,2\n205#1:260\n121#1:263,2\n121#1:265,4\n125#1:269,2\n225#1:261,2\n192#1:271,2\n*E\n"})
public final class FileWatcher {
    @NotNull
    private final Function3<String, String, FileWatcherEvent, Unit> onEvent;
    @NotNull
    private final Function1<String, Unit> onStart;
    @NotNull
    private final Function1<String, Unit> onStop;
    @NotNull
    private final Function1<String, Unit> onOverflow;
    @NotNull
    private final Function2<String, String, Unit> onError;
    @Nullable
    private final Function1<FileWatcherRawEvent, Unit> onRawEvent;
    @Nullable
    private final Logger logger;
    @NotNull
    private final ReentrantLock lock;
    @NotNull
    private final Semaphore threadLock;
    @Nullable
    private WatchService watchService;
    @NotNull
    private final Map<PlatformPath, WatchKey> keys;
    @NotNull
    private final Lazy needsSensitivityHigh$delegate;

    public FileWatcher(@NotNull Function3<? super String, ? super String, ? super FileWatcherEvent, Unit> onEvent2, @NotNull Function1<? super String, Unit> onStart2, @NotNull Function1<? super String, Unit> onStop2, @NotNull Function1<? super String, Unit> onOverflow2, @NotNull Function2<? super String, ? super String, Unit> onError2, @Nullable Function1<? super FileWatcherRawEvent, Unit> onRawEvent2, @Nullable Logger logger) {
        Intrinsics.checkNotNullParameter(onEvent2, (String)"onEvent");
        Intrinsics.checkNotNullParameter(onStart2, (String)"onStart");
        Intrinsics.checkNotNullParameter(onStop2, (String)"onStop");
        Intrinsics.checkNotNullParameter(onOverflow2, (String)"onOverflow");
        Intrinsics.checkNotNullParameter(onError2, (String)"onError");
        this.onEvent = onEvent2;
        this.onStart = onStart2;
        this.onStop = onStop2;
        this.onOverflow = onOverflow2;
        this.onError = onError2;
        this.onRawEvent = onRawEvent2;
        this.logger = logger;
        this.lock = new ReentrantLock();
        this.threadLock = new Semaphore(1);
        this.keys = new LinkedHashMap();
        this.needsSensitivityHigh$delegate = LazyKt.lazy(FileWatcher::needsSensitivityHigh_delegate$lambda$0);
    }

    public /* synthetic */ FileWatcher(Function3 function3, Function1 function1, Function1 function12, Function1 function13, Function2 function2, Function1 function14, Logger logger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 0x40) != 0) {
            logger = null;
        }
        this((Function3<? super String, ? super String, ? super FileWatcherEvent, Unit>)function3, (Function1<? super String, Unit>)function1, (Function1<? super String, Unit>)function12, (Function1<? super String, Unit>)function13, (Function2<? super String, ? super String, Unit>)function2, (Function1<? super FileWatcherRawEvent, Unit>)function14, logger);
    }

    private final boolean getNeedsSensitivityHigh() {
        Lazy lazy = this.needsSensitivityHigh$delegate;
        return (Boolean)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public final void start(@NotNull List<String> targetDirectories) {
        Intrinsics.checkNotNullParameter(targetDirectories, (String)"targetDirectories");
        Lock lock = this.lock;
        lock.lock();
        try {
            void $this$mapTo$iv$iv;
            boolean bl = false;
            Ref.ObjectRef watchService = new Ref.ObjectRef();
            watchService.element = this.watchService;
            Iterable $this$map$iv = targetDirectories;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                collection.add(new PlatformPath((String)it));
            }
            for (PlatformPath targetDirectoryPath : CollectionsKt.subtract((Iterable)((List)destination$iv$iv), (Iterable)this.keys.keySet())) {
                String targetDirectory = targetDirectoryPath.getOriginalPath();
                if (63 <= this.keys.size()) {
                    this.onError.invoke((Object)targetDirectory, (Object)("too many targets: max = 63, cannot start watching " + targetDirectory));
                    continue;
                }
                File targetFile = new File(targetDirectory);
                if (!targetFile.exists()) {
                    this.onError.invoke((Object)targetDirectory, (Object)("directory not exists: " + targetDirectory));
                    continue;
                }
                if (!targetFile.isDirectory()) {
                    this.onError.invoke((Object)targetDirectory, (Object)("target is not directory: " + targetDirectory));
                    continue;
                }
                try {
                    WatchKey watchKey;
                    if (watchService.element == null) {
                        watchService.element = FileSystems.getDefault().newWatchService();
                    }
                    if (this.getNeedsSensitivityHigh()) {
                        var9_14 = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                        WatchEvent.Kind[] kindArray = var9_14;
                        var9_14 = new WatchEvent.Modifier[]{SensitivityWatchEventModifier.HIGH};
                        watchKey = targetFile.toPath().register((WatchService)watchService.element, kindArray, (WatchEvent.Modifier[])var9_14);
                    } else {
                        var9_14 = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
                        watchKey = targetFile.toPath().register((WatchService)watchService.element, (WatchEvent.Kind<?>[])var9_14);
                    }
                    WatchKey key = watchKey;
                    this.keys.put(targetDirectoryPath, key);
                    this.onStart.invoke((Object)targetDirectory);
                }
                catch (IOException error) {
                    this.onError.invoke((Object)targetDirectory, (Object)("FileWatcher.start() failed: " + error));
                }
            }
            if (this.watchService == null && watchService.element != null) {
                this.watchService = (WatchService)watchService.element;
                ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Kfswatch_FileWatcher", (int)1, () -> FileWatcher.start$lambda$14$lambda$13(this, watchService), (int)7, null);
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop(@NotNull List<String> targetDirectories) {
        Intrinsics.checkNotNullParameter(targetDirectories, (String)"targetDirectories");
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            Iterable $this$forEach$iv = targetDirectories;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Map.Entry originalEntry;
                Object v0;
                PlatformPath path;
                block7: {
                    String targetDirectory = (String)element$iv;
                    boolean bl2 = false;
                    path = new PlatformPath(targetDirectory);
                    Iterable $this$firstOrNull$iv = this.keys.entrySet();
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Map.Entry it = (Map.Entry)element$iv2;
                        boolean bl3 = false;
                        if (!Intrinsics.areEqual(it.getKey(), (Object)path)) continue;
                        v0 = element$iv2;
                        break block7;
                    }
                    v0 = null;
                }
                if ((originalEntry = (Map.Entry)v0) == null) continue;
                ((WatchKey)originalEntry.getValue()).cancel();
                this.onStop.invoke((Object)((PlatformPath)originalEntry.getKey()).getOriginalPath());
                this.keys.remove(path);
            }
            if (this.keys.isEmpty()) {
                WatchService watchService = this.watchService;
                if (watchService != null) {
                    watchService.close();
                }
                this.watchService = null;
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stopAll() {
        Lock lock = this.lock;
        lock.lock();
        try {
            boolean bl = false;
            WatchService watchService = this.watchService;
            if (watchService != null) {
                watchService.close();
            }
            this.watchService = null;
            Map<PlatformPath, WatchKey> $this$forEach$iv = this.keys;
            boolean $i$f$forEach = false;
            Iterator<Map.Entry<PlatformPath, WatchKey>> iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<PlatformPath, WatchKey> element$iv;
                Map.Entry<PlatformPath, WatchKey> it = element$iv = iterator.next();
                boolean bl2 = false;
                this.onStop.invoke((Object)it.getKey().getOriginalPath());
            }
            this.keys.clear();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    public final void pause() {
        this.threadLock.tryAcquire();
    }

    public final void resume() {
        this.threadLock.release();
    }

    public final void close() {
        ThreadsKt.thread$default((boolean)false, (boolean)false, null, (String)"Kfswatch_FileWatcher_close", (int)5, () -> FileWatcher.close$lambda$20(this), (int)7, null);
    }

    private static final boolean needsSensitivityHigh_delegate$lambda$0() {
        boolean isMacos = Platform.Companion.isJvmMacos();
        String string = System.getProperty("java.specification.version");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getProperty(...)");
        double runtimeVersion = Double.parseDouble(string);
        return isMacos && runtimeVersion < 19.0;
    }

    private static final String start$lambda$14$lambda$13$lambda$2() {
        return "FileWatcher thread start";
    }

    private static final String start$lambda$14$lambda$13$lambda$8$lambda$6(WatchEvent $event) {
        return "WatchService: kind = " + $event.kind() + ", context = " + $event.context() + ", count = " + $event.count();
    }

    private static final String start$lambda$14$lambda$13$lambda$8$lambda$7(String $targetDirectory) {
        return "Events overflowed: " + $targetDirectory;
    }

    private static final String start$lambda$14$lambda$13$lambda$9(WatchKey $key) {
        Watchable watchable = $key.watchable();
        Intrinsics.checkNotNull((Object)watchable, (String)"null cannot be cast to non-null type java.nio.file.Path");
        return "WatchService: key is invalid, stop watching: " + ((Object)((Path)watchable)).toString();
    }

    private static final String start$lambda$14$lambda$13$lambda$10() {
        return "FileWatcher thread finishing";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static final Unit start$lambda$14$lambda$13(FileWatcher this$0, Ref.ObjectRef $watchService) {
        Logger logger = this$0.logger;
        if (logger != null) {
            logger.debug((Function0<String>)((Function0)FileWatcher::start$lambda$14$lambda$13$lambda$2));
        }
        try {
            while (true) {
                String $i$a$-withLock-FileWatcher$start$1$2$targetDirectory$22;
                boolean bl;
                Lock lock = this$0.lock;
                lock.lock();
                try {
                    bl = false;
                    bl = this$0.keys.isEmpty();
                }
                finally {
                    lock.unlock();
                }
                boolean finishing = bl;
                if (finishing) break;
                this$0.threadLock.acquire();
                this$0.threadLock.release();
                WatchKey key = ((WatchService)$watchService.element).take();
                Lock lock2 = this$0.lock;
                lock2.lock();
                try {
                    void $this$associateTo$iv$iv;
                    boolean $i$a$-withLock-FileWatcher$start$1$2$targetDirectory$22 = false;
                    Iterable $this$associate$iv = this$0.keys.entrySet();
                    boolean $i$f$associate = false;
                    int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                    Iterable iterable = $this$associate$iv;
                    Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                    boolean $i$f$associateTo = false;
                    for (Object element$iv$iv : $this$associateTo$iv$iv) {
                        Map map = destination$iv$iv;
                        Map.Entry it = (Map.Entry)element$iv$iv;
                        boolean bl2 = false;
                        Pair pair = TuplesKt.to(it.getValue(), it.getKey());
                        map.put(pair.getFirst(), pair.getSecond());
                    }
                    PlatformPath platformPath = (PlatformPath)destination$iv$iv.get(key);
                    $i$a$-withLock-FileWatcher$start$1$2$targetDirectory$22 = platformPath != null ? platformPath.getOriginalPath() : null;
                }
                finally {
                    lock2.unlock();
                }
                String targetDirectory = $i$a$-withLock-FileWatcher$start$1$2$targetDirectory$22;
                List<WatchEvent<?>> list = key.pollEvents();
                Intrinsics.checkNotNullExpressionValue(list, (String)"pollEvents(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    Object object;
                    WatchEvent event = (WatchEvent)element$iv;
                    boolean bl3 = false;
                    Logger logger2 = this$0.logger;
                    if (logger2 != null) {
                        logger2.debug((Function0<String>)((Function0)() -> FileWatcher.start$lambda$14$lambda$13$lambda$8$lambda$6(event)));
                    }
                    Function1<FileWatcherRawEvent, Unit> function1 = this$0.onRawEvent;
                    if (function1 != null) {
                        String string = event.kind().name();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"name(...)");
                        int n = event.count();
                        Object t = event.context();
                        Intrinsics.checkNotNullExpressionValue(t, (String)"context(...)");
                        object = event.context();
                        Path path = object instanceof Path ? (Path)object : null;
                        function1.invoke((Object)new FileWatcherRawEvent.JvmWatchServiceRawEvent(string, n, t, path != null ? ((Object)path).toString() : null));
                    }
                    if (targetDirectory == null) continue;
                    object = event.context();
                    Path path = object instanceof Path ? (Path)object : null;
                    String path2 = path != null ? ((Object)path).toString() : null;
                    WatchEvent.Kind kind = event.kind();
                    if (Intrinsics.areEqual((Object)kind, StandardWatchEventKinds.ENTRY_CREATE)) {
                        String string = path2;
                        if (string == null) {
                            object = "Required value was null.";
                            throw new IllegalStateException(object.toString());
                        }
                        this$0.onEvent.invoke((Object)targetDirectory, (Object)string, (Object)FileWatcherEvent.Create);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kind, StandardWatchEventKinds.ENTRY_DELETE)) {
                        String string = path2;
                        if (string == null) {
                            object = "Required value was null.";
                            throw new IllegalStateException(object.toString());
                        }
                        this$0.onEvent.invoke((Object)targetDirectory, (Object)string, (Object)FileWatcherEvent.Delete);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)kind, StandardWatchEventKinds.ENTRY_MODIFY)) {
                        String string = path2;
                        if (string == null) {
                            object = "Required value was null.";
                            throw new IllegalStateException(object.toString());
                        }
                        this$0.onEvent.invoke((Object)targetDirectory, (Object)string, (Object)FileWatcherEvent.Modify);
                        continue;
                    }
                    if (!Intrinsics.areEqual((Object)kind, StandardWatchEventKinds.OVERFLOW)) continue;
                    Logger logger3 = this$0.logger;
                    if (logger3 != null) {
                        logger3.debug((Function0<String>)((Function0)() -> FileWatcher.start$lambda$14$lambda$13$lambda$8$lambda$7(targetDirectory)));
                    }
                    this$0.onOverflow.invoke((Object)targetDirectory);
                }
                boolean valid = key.reset();
                if (valid) continue;
                Logger logger4 = this$0.logger;
                if (logger4 != null) {
                    logger4.debug((Function0<String>)((Function0)() -> FileWatcher.start$lambda$14$lambda$13$lambda$9(key)));
                }
                Watchable watchable = key.watchable();
                Intrinsics.checkNotNull((Object)watchable, (String)"null cannot be cast to non-null type java.nio.file.Path");
                this$0.stop(CollectionsKt.listOf((Object)((Object)((Path)watchable)).toString()));
            }
        }
        catch (ClosedWatchServiceException closedWatchServiceException) {
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Logger logger5 = this$0.logger;
        if (logger5 != null) {
            logger5.debug((Function0<String>)((Function0)FileWatcher::start$lambda$14$lambda$13$lambda$10));
        }
        Lock lock = this$0.lock;
        lock.lock();
        try {
            boolean bl = false;
            if (Intrinsics.areEqual((Object)this$0.watchService, (Object)$watchService.element)) {
                WatchService watchService = this$0.watchService;
                if (watchService != null) {
                    watchService.close();
                }
                this$0.watchService = null;
                Map<PlatformPath, WatchKey> $this$forEach$iv = this$0.keys;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<PlatformPath, WatchKey>> iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry<PlatformPath, WatchKey> element$iv;
                    Map.Entry<PlatformPath, WatchKey> it = element$iv = iterator.next();
                    boolean bl4 = false;
                    this$0.onStop.invoke((Object)it.getKey().getOriginalPath());
                }
                this$0.keys.clear();
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
        return Unit.INSTANCE;
    }

    private static final Unit close$lambda$20(FileWatcher this$0) {
        this$0.stopAll();
        return Unit.INSTANCE;
    }
}

