/*
 * Decompiled with CFR 0.152.
 */
package androidx.datastore.core;

import androidx.datastore.core.Data;
import androidx.datastore.core.Final;
import androidx.datastore.core.NoValueDataState;
import androidx.datastore.core.ReadException;
import androidx.datastore.core.State;
import androidx.datastore.core.UnInitialized;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00028\u00000\u00072\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007R \u0010\u0005\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\u0006X\u0082\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0004R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\u00078F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00070\r8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0012"}, d2={"Landroidx/datastore/core/DataStoreInMemoryCache;", "T", "", "<init>", "()V", "cachedValue", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Landroidx/datastore/core/State;", "getCachedValue$annotations", "currentState", "getCurrentState", "()Landroidx/datastore/core/State;", "flow", "Lkotlinx/coroutines/flow/Flow;", "getFlow", "()Lkotlinx/coroutines/flow/Flow;", "tryUpdate", "newState", "datastore-core"})
@SourceDebugExtension(value={"SMAP\nDataStoreInMemoryCache.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataStoreInMemoryCache.kt\nandroidx/datastore/core/DataStoreInMemoryCache\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,78:1\n198#2,5:79\n*S KotlinDebug\n*F\n+ 1 DataStoreInMemoryCache.kt\nandroidx/datastore/core/DataStoreInMemoryCache\n*L\n41#1:79,5\n*E\n"})
public final class DataStoreInMemoryCache<T> {
    @NotNull
    private final MutableStateFlow<State<T>> cachedValue;

    public DataStoreInMemoryCache() {
        UnInitialized unInitialized = UnInitialized.INSTANCE;
        Intrinsics.checkNotNull((Object)unInitialized, (String)"null cannot be cast to non-null type androidx.datastore.core.State<T of androidx.datastore.core.DataStoreInMemoryCache>");
        this.cachedValue = StateFlowKt.MutableStateFlow((Object)unInitialized);
    }

    private static /* synthetic */ void getCachedValue$annotations() {
    }

    @NotNull
    public final State<T> getCurrentState() {
        return (State)this.cachedValue.getValue();
    }

    @NotNull
    public final Flow<State<T>> getFlow() {
        return (Flow)this.cachedValue;
    }

    @NotNull
    public final State<T> tryUpdate(@NotNull State<T> newState) {
        State state;
        State nextValue$iv;
        Object prevValue$iv;
        Intrinsics.checkNotNullParameter(newState, (String)"newState");
        MutableStateFlow<State<T>> $this$updateAndGet$iv = this.cachedValue;
        boolean $i$f$updateAndGet = false;
        do {
            prevValue$iv = $this$updateAndGet$iv.getValue();
            State cached = (State)prevValue$iv;
            boolean bl = false;
            State state2 = cached;
            if (state2 instanceof ReadException || Intrinsics.areEqual((Object)state2, (Object)UnInitialized.INSTANCE)) {
                state = newState;
                continue;
            }
            if (state2 instanceof Data) {
                if (newState.getVersion() > ((Data)cached).getVersion()) {
                    state = newState;
                    continue;
                }
                state = cached;
                continue;
            }
            if (state2 instanceof Final) {
                state = cached;
                continue;
            }
            if (state2 instanceof NoValueDataState) {
                throw new IllegalStateException("This is a bug in DataStore. Please file a bug at: https://issuetracker.google.com/issues/new?component=907884&template=1466542".toString());
            }
            throw new NoWhenBranchMatchedException();
        } while (!$this$updateAndGet$iv.compareAndSet(prevValue$iv, nextValue$iv = state));
        State updated = nextValue$iv;
        return updated;
    }
}

