/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Pointer;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.systemTray.Checkbox;
import dorkbox.systemTray.Entry;
import dorkbox.systemTray.Menu;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.Separator;
import dorkbox.systemTray.Status;
import dorkbox.systemTray.peer.MenuPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenuItemCheckbox;
import dorkbox.systemTray.ui.gtk.GtkMenuItemSeparator;
import dorkbox.systemTray.ui.gtk.GtkMenuItemStatus;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

class GtkMenu
extends GtkBaseMenuItem
implements MenuPeer {
    private final List<GtkBaseMenuItem> menuEntries = new ArrayList<GtkBaseMenuItem>();
    private final GtkMenu parent;
    volatile Pointer _nativeMenu;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';
    private final AtomicBoolean obliterateInProgress = new AtomicBoolean(false);

    GtkMenu() {
        super(null);
        this.parent = null;
    }

    private GtkMenu(GtkMenu parent) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
    }

    GtkMenu getParent() {
        return this.parent;
    }

    protected void onMenuAdded(Pointer menu) {
    }

    private void deleteMenu(boolean recursiveDeleteParentMenu) {
        if (this.obliterateInProgress.get()) {
            return;
        }
        if (this._nativeMenu != null) {
            int menuEntriesSize = this.menuEntries.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = this.menuEntries.get(i);
                menuEntry__.onDeleteMenu(this._nativeMenu);
            }
            Gtk.Gtk2.gtk_widget_destroy(this._nativeMenu);
        }
        if (this.parent != null && recursiveDeleteParentMenu) {
            this.parent.deleteMenu(true);
        }
    }

    private void createMenu(boolean recursiveCreateParentMenu) {
        GtkBaseMenuItem menuEntry__;
        int i;
        if (this.obliterateInProgress.get()) {
            return;
        }
        this._nativeMenu = Gtk.Gtk2.gtk_menu_new();
        if (this.parent != null) {
            Gtk.Gtk2.gtk_menu_item_set_submenu(this._native, this._nativeMenu);
        }
        if (this.parent != null && recursiveCreateParentMenu) {
            this.parent.createMenu(true);
        }
        boolean hasImages = false;
        int menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            menuEntry__ = this.menuEntries.get(i);
            hasImages |= menuEntry__.hasImage();
        }
        menuEntriesSize = this.menuEntries.size();
        for (i = 0; i < menuEntriesSize; ++i) {
            GtkMenu subMenu;
            menuEntry__ = this.menuEntries.get(i);
            menuEntry__.onCreateMenu(this._nativeMenu, hasImages);
            if (!(menuEntry__ instanceof GtkMenu) || (subMenu = (GtkMenu)menuEntry__).getParent() == this) continue;
            subMenu.createMenu(recursiveCreateParentMenu);
        }
        this.onMenuAdded(this._nativeMenu);
    }

    private void obliterateMenu() {
        if (this._nativeMenu != null && !this.obliterateInProgress.get()) {
            this.obliterateInProgress.set(true);
            ArrayList<GtkBaseMenuItem> menuEntriesCopy = new ArrayList<GtkBaseMenuItem>(this.menuEntries);
            this.menuEntries.clear();
            int menuEntriesSize = menuEntriesCopy.size();
            for (int i = 0; i < menuEntriesSize; ++i) {
                GtkBaseMenuItem menuEntry__ = menuEntriesCopy.get(i);
                menuEntry__.remove();
            }
            menuEntriesCopy.clear();
            Gtk.Gtk2.gtk_widget_destroy(this._nativeMenu);
            this._nativeMenu = null;
            this.obliterateInProgress.set(false);
        }
    }

    @Override
    public void add(Menu parentMenu, Entry entry, int index) {
        GtkEventDispatch.dispatchAndWait(() -> {
            this.deleteMenu(false);
            GtkBaseMenuItem item = null;
            if (entry instanceof Menu) {
                item = new GtkMenu(this);
                this.menuEntries.add(index, item);
            } else if (entry instanceof Separator) {
                item = new GtkMenuItemSeparator(this);
                this.menuEntries.add(index, item);
            } else if (entry instanceof Checkbox) {
                item = new GtkMenuItemCheckbox(this);
                this.menuEntries.add(index, item);
            } else if (entry instanceof Status) {
                item = new GtkMenuItemStatus(this);
                this.menuEntries.add(index, item);
            } else if (entry instanceof MenuItem) {
                item = new GtkMenuItem(this);
                this.menuEntries.add(index, item);
            }
            if (entry instanceof Menu) {
                ((Menu)entry).bind((MenuPeer)((Object)item), parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Separator) {
                ((Separator)entry).bind((GtkMenuItemSeparator)item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Checkbox) {
                ((Checkbox)entry).bind((GtkMenuItemCheckbox)item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof Status) {
                ((Status)entry).bind((GtkMenuItemStatus)item, parentMenu, parentMenu.getImageResizeUtil());
            } else if (entry instanceof MenuItem) {
                ((MenuItem)entry).bind((GtkMenuItem)item, parentMenu, parentMenu.getImageResizeUtil());
            }
            this.createMenu(false);
            if (this.parent == null) {
                Gtk.Gtk2.gtk_widget_show_all(this._nativeMenu);
            }
        });
    }

    @Override
    public void setImage(MenuItem menuItem) {
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(() -> {
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            if (menuItem.getImage() != null) {
                this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.image);
                Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
            }
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_sensitive(this._native, menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        GtkEventDispatch.dispatch(() -> {
            Gtk.Gtk2.gtk_menu_item_set_label(this._native, textWithMnemonic);
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setCallback(MenuItem menuItem) {
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        this.mnemonicKey = shortcut != '\u0000' ? Character.toLowerCase(shortcut) : (char)'\u0000';
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_tooltip_text(this._native, menuItem.getTooltip()));
    }

    public void remove(GtkBaseMenuItem item) {
        this.menuEntries.remove(item);
        this.deleteMenu(true);
        this.createMenu(true);
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(() -> {
            GtkMenu parent = this.getParent();
            if (parent != null) {
                parent.menuEntries.remove(this);
            }
            this.obliterateMenu();
            if (parent != null) {
                Gtk.Gtk2.gtk_menu_item_set_submenu(this._native, null);
                parent.deleteMenu(true);
                parent.createMenu(true);
            }
        });
    }
}

