/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.gtk;

import com.sun.jna.Callback;
import com.sun.jna.Pointer;
import dorkbox.jna.linux.GCallback;
import dorkbox.jna.linux.GObject;
import dorkbox.jna.linux.Gtk;
import dorkbox.jna.linux.GtkEventDispatch;
import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.gtk.GtkBaseMenuItem;
import dorkbox.systemTray.ui.gtk.GtkMenu;
import dorkbox.systemTray.util.EventDispatch;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

class GtkMenuItem
extends GtkBaseMenuItem
implements MenuItemPeer,
GCallback {
    private final GtkMenu parent;
    private volatile ActionListener callback;
    private volatile Pointer image;
    private volatile char mnemonicKey = '\u0000';

    GtkMenuItem(GtkMenu parent) {
        super(Gtk.Gtk2.gtk_image_menu_item_new_with_mnemonic(""));
        this.parent = parent;
        GObject.g_signal_connect_object((Pointer)this._native, (String)"activate", (Callback)this, null, (int)0);
    }

    public int callback(Pointer instance, Pointer data) {
        ActionListener callback = this.callback;
        if (callback != null) {
            GtkEventDispatch.proxyClick((ActionListener)callback);
        }
        return 1;
    }

    @Override
    public void setImage(MenuItem menuItem) {
        boolean hadImage = this.hasImage();
        this.setLegitImage(menuItem.getImage() != null);
        GtkEventDispatch.dispatch(() -> {
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            if (menuItem.getImage() != null) {
                this.removeSpacerImage();
                this.image = Gtk.Gtk2.gtk_image_new_from_file(menuItem.getImage().getAbsolutePath());
                Gtk.Gtk2.gtk_image_menu_item_set_image(this._native, this.image);
                Gtk.Gtk2.gtk_image_menu_item_set_always_show_image(this._native, true);
            } else if (hadImage) {
                this.addSpacerImage();
            }
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_sensitive(this._native, menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        int i;
        String text;
        String textWithMnemonic = this.mnemonicKey != '\u0000' ? ((text = menuItem.getText()) != null ? ((i = text.toLowerCase().indexOf(this.mnemonicKey)) >= 0 ? text.substring(0, i) + "_" + text.substring(i) : menuItem.getText()) : null) : menuItem.getText();
        GtkEventDispatch.dispatch(() -> {
            Gtk.Gtk2.gtk_menu_item_set_label(this._native, textWithMnemonic);
            Gtk.Gtk2.gtk_widget_show_all(this._native);
        });
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    });
                }
            };
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        char shortcut = menuItem.getShortcut();
        this.mnemonicKey = shortcut != '\u0000' ? Character.toLowerCase(shortcut) : (char)'\u0000';
        this.setText(menuItem);
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        GtkEventDispatch.dispatch(() -> Gtk.Gtk2.gtk_widget_set_tooltip_text(this._native, menuItem.getTooltip()));
    }

    @Override
    public void remove() {
        GtkEventDispatch.dispatch(() -> {
            GtkMenuItem.super.remove();
            this.callback = null;
            Gtk.Gtk2.gtk_container_remove(this.parent._nativeMenu, this._native);
            if (this.image != null) {
                Gtk.Gtk2.gtk_container_remove(this._native, this.image);
                this.image = null;
            }
            this.parent.remove(this);
        });
    }
}

