/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.ui.osx;

import dorkbox.systemTray.MenuItem;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.peer.MenuItemPeer;
import dorkbox.systemTray.ui.osx.AwtOsxMenu;
import dorkbox.systemTray.util.AwtAccessor;
import dorkbox.systemTray.util.EventDispatch;
import dorkbox.util.SwingUtil;
import java.awt.Image;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.ImageIcon;

class AwtOsxMenuItem
implements MenuItemPeer {
    private final AwtOsxMenu parent;
    private final java.awt.MenuItem _native = new java.awt.MenuItem();
    private volatile ActionListener callback;
    private final Object peerObj;

    AwtOsxMenuItem(AwtOsxMenu parent) {
        this.parent = parent;
        parent._native.add(this._native);
        this.peerObj = AwtAccessor.getPeer(this._native);
    }

    @Override
    public void setImage(MenuItem menuItem) {
        File imageFile = menuItem.getImage();
        if (this.peerObj != null && imageFile != null) {
            Image image = new ImageIcon(imageFile.getAbsolutePath()).getImage();
            SwingUtil.INSTANCE.invokeLater(() -> {
                try {
                    AwtAccessor.setImage(this.peerObj, image);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Unable to setImage for awt-osx menus.", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void setEnabled(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setEnabled(menuItem.getEnabled()));
    }

    @Override
    public void setText(MenuItem menuItem) {
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setLabel(menuItem.getText()));
    }

    @Override
    public void setCallback(final MenuItem menuItem) {
        if (this.callback != null) {
            this._native.removeActionListener(this.callback);
        }
        this.callback = menuItem.getCallback();
        if (this.callback != null) {
            this.callback = new ActionListener(){
                final ActionListener cb;
                {
                    this.cb = menuItem.getCallback();
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    EventDispatch.runLater(() -> {
                        try {
                            this.cb.actionPerformed(new ActionEvent(menuItem, 1001, ""));
                        }
                        catch (Throwable throwable) {
                            SystemTray.logger.error("Error calling menu entry {} click event.", (Object)menuItem.getText(), (Object)throwable);
                        }
                    });
                }
            };
            this._native.addActionListener(this.callback);
        }
    }

    @Override
    public void setShortcut(MenuItem menuItem) {
        int vKey = SwingUtil.INSTANCE.getVirtualKey(menuItem.getShortcut());
        SwingUtil.INSTANCE.invokeLater(() -> this._native.setShortcut(new MenuShortcut(vKey)));
    }

    @Override
    public void setTooltip(MenuItem menuItem) {
        String tooltipText = menuItem.getTooltip();
        if (this.peerObj != null && tooltipText != null) {
            SwingUtil.INSTANCE.invokeLater(() -> {
                try {
                    AwtAccessor.setToolTipText(this.peerObj, tooltipText);
                }
                catch (Exception e) {
                    SystemTray.logger.error("Unable to setTooltip for awt-osx menus.", (Throwable)e);
                }
            });
        }
    }

    @Override
    public void remove() {
        SwingUtil.INSTANCE.invokeLater(() -> {
            this._native.deleteShortcut();
            this._native.setEnabled(false);
            if (this.callback != null) {
                this._native.removeActionListener(this.callback);
                this.callback = null;
            }
            this.parent._native.remove(this._native);
            this._native.removeNotify();
        });
    }
}

