/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.systemTray.SystemTray;
import dorkbox.util.NamedThreadFactory;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class EventDispatch {
    private static int THREAD_PRIORITY = 5;
    private static ExecutorService eventDispatchExecutor = null;
    private static volatile CountDownLatch shutdownLatch = null;
    private static volatile boolean insideDispatch = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLater(Runnable runnable) {
        Class<EventDispatch> clazz = EventDispatch.class;
        synchronized (EventDispatch.class) {
            if (eventDispatchExecutor == null) {
                if (insideDispatch) {
                    SystemTray.logger.error("Unable to create a new event dispatch, while executing within the same context.");
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                shutdownLatch = new CountDownLatch(1);
                eventDispatchExecutor = Executors.newSingleThreadExecutor((ThreadFactory)new NamedThreadFactory("SystemTrayEventDispatch", Thread.currentThread().getThreadGroup(), THREAD_PRIORITY, true));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            eventDispatchExecutor.execute(() -> {
                insideDispatch = true;
                runnable.run();
                insideDispatch = false;
            });
            return;
        }
    }

    public static void shutdown() {
        EventDispatch.runLater(() -> {
            ExecutorService executorService = null;
            Class<EventDispatch> clazz = EventDispatch.class;
            synchronized (EventDispatch.class) {
                executorService = eventDispatchExecutor;
                eventDispatchExecutor = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                if (executorService != null) {
                    List<Runnable> runnables = executorService.shutdownNow();
                    for (int i = 0; i < runnables.size(); ++i) {
                        try {
                            runnables.get(i).run();
                            continue;
                        }
                        catch (Exception e) {
                            SystemTray.logger.error("Error shutting down EventDispatch", (Throwable)e);
                        }
                    }
                    shutdownLatch.countDown();
                }
                return;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void waitForShutdown() {
        CountDownLatch latch = null;
        Class<EventDispatch> clazz = EventDispatch.class;
        synchronized (EventDispatch.class) {
            latch = shutdownLatch;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (latch != null) {
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return;
        }
    }
}

