/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.systemTray.util;

import dorkbox.jna.ClassUtils;
import dorkbox.os.OS;
import dorkbox.systemTray.SystemTray;
import dorkbox.systemTray.util.SystemTrayFixes;
import java.awt.Robot;
import java.util.concurrent.atomic.AtomicBoolean;
import javassist.ClassPool;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;

public class SystemTrayFixesWindows {
    private static AtomicBoolean loaded = new AtomicBoolean(false);

    public static void fix(int trayIconSize) {
        if (loaded.getAndSet(true)) {
            return;
        }
        if (OS.INSTANCE.getJavaVersion() > 8) {
            return;
        }
        if (SystemTrayFixes.isSwingTrayLoaded("sun.awt.windows.WTrayIconPeer")) {
            throw new RuntimeException("Unable to initialize the Swing System Tray, it has already been created!");
        }
        try {
            Robot robot = new Robot();
            ClassPool pool = ClassPool.getDefault();
            CtClass trayClass = pool.get("sun.awt.windows.WSystemTrayPeer");
            trayClass.setModifiers(trayClass.getModifiers() & 1);
            trayClass.getConstructors()[0].setModifiers(trayClass.getConstructors()[0].getModifiers() & 1);
            CtMethod method = trayClass.getDeclaredMethod("getTrayIconSize");
            CtBehavior[] methodInfos = new CtBehavior[]{method};
            SystemTrayFixes.fixTraySize(methodInfos, 16, trayIconSize);
            method.getMethodInfo().rebuildStackMapForME(trayClass.getClassPool());
            byte[] trayBytes = trayClass.toBytecode();
            CtClass trayIconClass = pool.get("sun.awt.windows.WTrayIconPeer");
            CtMethod ctMethodCreate = trayIconClass.getDeclaredMethod("createNativeImage");
            CtMethod ctMethodUpdate = trayIconClass.getDeclaredMethod("updateNativeImage");
            int TRAY_MASK = trayIconSize * trayIconSize / 8;
            ctMethodCreate.setBody("{java.awt.image.BufferedImage bufferedImage = $1;java.awt.image.Raster rasterImage = bufferedImage.getRaster();final byte[] mask = new byte[" + TRAY_MASK + "];final int pixels[] = ((java.awt.image.DataBufferInt)rasterImage.getDataBuffer()).getData();int numberOfPixels = pixels.length;int rasterImageWidth = rasterImage.getWidth();for (int i = 0; i < numberOfPixels; i++) {int iByte = i / 8;int augmentMask = 1 << (7 - (i % 8));if ((pixels[i] & 0xFF000000) == 0) {if (iByte < mask.length) {mask[iByte] |= augmentMask;}}}if (rasterImage instanceof sun.awt.image.IntegerComponentRaster) {rasterImageWidth = ((sun.awt.image.IntegerComponentRaster)rasterImage).getScanlineStride();}setNativeIcon(((java.awt.image.DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData(), mask, rasterImageWidth, rasterImage.getWidth(), rasterImage.getHeight());}");
            ctMethodUpdate.setBody("{java.awt.Image image = $1;if (isDisposed()) {return;}int imageWidth = image.getWidth(observer);int imageHeight = image.getWidth(observer);java.awt.image.BufferedImage trayIcon = new java.awt.image.BufferedImage(imageWidth, imageHeight, java.awt.image.BufferedImage.TYPE_INT_ARGB);java.awt.Graphics2D g = trayIcon.createGraphics();if (g != null) {try {g.addRenderingHints(new java.awt.RenderingHints(java.awt.RenderingHints.KEY_RENDERING,java.awt.RenderingHints.VALUE_RENDER_QUALITY));g.drawImage(image, 0, 0, imageWidth, imageHeight, observer);createNativeImage(trayIcon);updateNativeIcon(!firstUpdate);if (firstUpdate) {firstUpdate = false;}} finally {g.dispose();}}}");
            ctMethodCreate.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            ctMethodUpdate.getMethodInfo().rebuildStackMapForME(trayIconClass.getClassPool());
            byte[] trayIconBytes = trayIconClass.toBytecode();
            ClassUtils.defineClass((byte[])trayBytes);
            ClassUtils.defineClass((byte[])trayIconBytes);
            if (SystemTray.DEBUG) {
                SystemTray.logger.debug("Successfully changed tray icon size to: {}", (Object)trayIconSize);
            }
        }
        catch (Exception e) {
            SystemTray.logger.error("Error setting tray icon size to: {}", (Object)trayIconSize, (Object)e);
        }
    }
}

