/*
 * Decompiled with CFR 0.152.
 */
package dorkbox.collections;

import dorkbox.collections.Collections;
import dorkbox.collections.ObjectSet;
import dorkbox.collections.StateException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.jvm.internal.markers.KMutableCollection;
import kotlin.jvm.internal.markers.KMutableIterator;
import kotlin.jvm.internal.markers.KMutableMap;
import kotlin.jvm.internal.markers.KMutableSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010%\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0010'\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0011\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u001c\n\u0002\u0010\u0014\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u001c\n\u0002\u0010$\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\t\b\u0016\u0018\u0000 \u0080\u0001*\b\b\u0000\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003:\f\u0080\u0001\u0081\u0001\u0082\u0001\u0083\u0001\u0084\u0001\u0085\u0001B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0005B\u001b\b\u0016\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\tB\u0017\b\u0016\u0012\u000e\u0010\n\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010S\u001a\u00020TH\u0016J\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0007H\u0016J\u0015\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010YJ\u0010\u0010Z\u001a\u00020W2\u0006\u0010[\u001a\u00020\u0004H\u0016J\u000e\u0010\\\u001a\u00020T2\u0006\u0010]\u001a\u00020\u0007J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0012H\u0016J\u0013\u0010^\u001a\u00020W2\b\u0010_\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\u001f\u0010`\u001a\u0004\u0018\u00018\u00002\b\u0010[\u001a\u0004\u0018\u00010\u00022\u0006\u0010a\u001a\u00020W\u00a2\u0006\u0002\u0010bJ\u0018\u0010c\u001a\u0004\u0018\u00010\u00042\u0006\u0010X\u001a\u00028\u0000H\u0096\u0002\u00a2\u0006\u0002\u0010dJ\"\u0010c\u001a\u0004\u0018\u00010\u00042\u0006\u0010X\u001a\u00028\u00002\b\u0010e\u001a\u0004\u0018\u00010\u0004H\u0086\u0002\u00a2\u0006\u0002\u0010fJ#\u0010g\u001a\u00020\u00042\u0006\u0010X\u001a\u00028\u00002\u0006\u0010e\u001a\u00020\u00042\u0006\u0010h\u001a\u00020\u0004\u00a2\u0006\u0002\u0010iJ\b\u0010j\u001a\u00020\u0007H\u0016J\b\u0010k\u001a\u00020WH\u0016J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0016J\u0010\u0010l\u001a\u00020\u00072\u0006\u0010X\u001a\u00020\u0002H\u0016J\u0006\u0010m\u001a\u00020WJ\u0010\u0010n\u001a\u00020\u00072\u0006\u0010o\u001a\u00020\u0002H\u0014J\u001f\u0010p\u001a\u0004\u0018\u00010\u00042\u0006\u0010X\u001a\u00028\u00002\u0006\u0010[\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010qJ#\u0010p\u001a\u00020\u00042\u0006\u0010X\u001a\u00028\u00002\u0006\u0010[\u001a\u00020\u00042\u0006\u0010e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010iJ\u0018\u0010r\u001a\u00020T2\u000e\u0010s\u001a\n\u0012\u0006\b\u0001\u0012\u00028\u00000\u0000H\u0016J\u001e\u0010r\u001a\u00020T2\u0014\u0010s\u001a\u0010\u0012\u0006\b\u0001\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040tH\u0016J\u001d\u0010u\u001a\u00020T2\u0006\u0010X\u001a\u00028\u00002\u0006\u0010[\u001a\u00020\u0004H\u0002\u00a2\u0006\u0002\u0010vJ\u0017\u0010w\u001a\u0004\u0018\u00010\u00042\u0006\u0010X\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010dJ\u001b\u0010w\u001a\u00020\u00042\u0006\u0010X\u001a\u00028\u00002\u0006\u0010e\u001a\u00020\u0004\u00a2\u0006\u0002\u0010xJ\u000e\u0010y\u001a\u00020T2\u0006\u0010z\u001a\u00020\u0007J\u0010\u0010{\u001a\u00020T2\u0006\u0010U\u001a\u00020\u0007H\u0016J\b\u0010|\u001a\u00020}H\u0016J\u000e\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020}J\u0018\u0010|\u001a\u00020}2\u0006\u0010~\u001a\u00020}2\u0006\u0010\u007f\u001a\u00020WH\u0014J\b\u0010F\u001a\u00020KH\u0016R&\u0010\f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00040\u000e0\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\"\u0010\u0011\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010\u0012X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0014\"\u0004\b\u0019\u0010\u0016R$\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00018\u00000\u001bX\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010 \u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR\u001a\u0010!\u001a\b\u0012\u0004\u0012\u00028\u00000\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u0010R\"\u0010#\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\"\u0010)\u001a\n\u0012\u0004\u0012\u00028\u0000\u0018\u00010$X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010&\"\u0004\b+\u0010(R\u001a\u0010\b\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u001a\u00100\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b1\u00102\"\u0004\b3\u00104R\u001a\u00105\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b6\u00102\"\u0004\b7\u00104R\u001a\u00108\u001a\u00020\u0007X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u00102\"\u0004\b:\u00104R\u0014\u0010;\u001a\u00020\u00078VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b<\u00102R\u001a\u0010=\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00102\"\u0004\b?\u00104R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u001a\u0010F\u001a\b\u0012\u0004\u0012\u00020\u00040G8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bH\u0010IR\u001c\u0010J\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bL\u0010M\"\u0004\bN\u0010OR\u001c\u0010P\u001a\u0004\u0018\u00010KX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010M\"\u0004\bR\u0010O\u00a8\u0006\u0086\u0001"}, d2={"Ldorkbox/collections/ObjectFloatMap;", "K", "", "", "", "()V", "initialCapacity", "", "loadFactor", "(IF)V", "map", "(Ldorkbox/collections/ObjectFloatMap;)V", "entries", "", "", "getEntries", "()Ljava/util/Set;", "entries1", "Ldorkbox/collections/ObjectFloatMap$Entries;", "getEntries1", "()Ldorkbox/collections/ObjectFloatMap$Entries;", "setEntries1", "(Ldorkbox/collections/ObjectFloatMap$Entries;)V", "entries2", "getEntries2", "setEntries2", "keyTable", "", "getKeyTable", "()[Ljava/lang/Object;", "setKeyTable", "([Ljava/lang/Object;)V", "[Ljava/lang/Object;", "keys", "getKeys", "keys1", "Ldorkbox/collections/ObjectFloatMap$Keys;", "getKeys1", "()Ldorkbox/collections/ObjectFloatMap$Keys;", "setKeys1", "(Ldorkbox/collections/ObjectFloatMap$Keys;)V", "keys2", "getKeys2", "setKeys2", "getLoadFactor", "()F", "setLoadFactor", "(F)V", "mapSize", "getMapSize", "()I", "setMapSize", "(I)V", "mask", "getMask", "setMask", "shift", "getShift", "setShift", "size", "getSize", "threshold", "getThreshold", "setThreshold", "valueTable", "", "getValueTable", "()[F", "setValueTable", "([F)V", "values", "", "getValues", "()Ljava/util/Collection;", "values1", "Ldorkbox/collections/ObjectFloatMap$Values;", "getValues1", "()Ldorkbox/collections/ObjectFloatMap$Values;", "setValues1", "(Ldorkbox/collections/ObjectFloatMap$Values;)V", "values2", "getValues2", "setValues2", "clear", "", "maximumCapacity", "containsKey", "", "key", "(Ljava/lang/Object;)Z", "containsValue", "value", "ensureCapacity", "additionalCapacity", "equals", "other", "findKey", "identity", "(Ljava/lang/Object;Z)Ljava/lang/Object;", "get", "(Ljava/lang/Object;)Ljava/lang/Float;", "defaultValue", "(Ljava/lang/Object;Ljava/lang/Float;)Ljava/lang/Float;", "getAndIncrement", "increment", "(Ljava/lang/Object;FF)F", "hashCode", "isEmpty", "locateKey", "notEmpty", "place", "item", "put", "(Ljava/lang/Object;F)Ljava/lang/Float;", "putAll", "from", "", "putResize", "(Ljava/lang/Object;F)V", "remove", "(Ljava/lang/Object;F)F", "resize", "newSize", "shrink", "toString", "", "separator", "braces", "Companion", "Entries", "Entry", "Keys", "MapIterator", "Values", "Collections"})
@SourceDebugExtension(value={"SMAP\nObjectFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1024:1\n215#2,2:1025\n1#3:1027\n*S KotlinDebug\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap\n*L\n245#1:1025,2\n*E\n"})
public class ObjectFloatMap<K>
implements Map<K, Float>,
KMutableMap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int mapSize;
    @NotNull
    private K[] keyTable;
    @NotNull
    private float[] valueTable;
    private float loadFactor;
    private int threshold;
    private int shift;
    private int mask;
    @Nullable
    private transient Entries<K> entries1;
    @Nullable
    private transient Entries<K> entries2;
    @Nullable
    private transient Values values1;
    @Nullable
    private transient Values values2;
    @Nullable
    private transient Keys<K> keys1;
    @Nullable
    private transient Keys<K> keys2;
    @NotNull
    public static final String version = "2.4";
    @NotNull
    private static final Object dummy = new Object();

    protected final int getMapSize() {
        return this.mapSize;
    }

    protected final void setMapSize(int n) {
        this.mapSize = n;
    }

    @NotNull
    public final K[] getKeyTable() {
        return this.keyTable;
    }

    public final void setKeyTable(@NotNull K[] KArray) {
        Intrinsics.checkNotNullParameter(KArray, (String)"<set-?>");
        this.keyTable = KArray;
    }

    @NotNull
    public final float[] getValueTable() {
        return this.valueTable;
    }

    public final void setValueTable(@NotNull float[] fArray) {
        Intrinsics.checkNotNullParameter((Object)fArray, (String)"<set-?>");
        this.valueTable = fArray;
    }

    public final float getLoadFactor() {
        return this.loadFactor;
    }

    public final void setLoadFactor(float f) {
        this.loadFactor = f;
    }

    public final int getThreshold() {
        return this.threshold;
    }

    public final void setThreshold(int n) {
        this.threshold = n;
    }

    protected final int getShift() {
        return this.shift;
    }

    protected final void setShift(int n) {
        this.shift = n;
    }

    protected final int getMask() {
        return this.mask;
    }

    protected final void setMask(int n) {
        this.mask = n;
    }

    @Nullable
    public final Entries<K> getEntries1() {
        return this.entries1;
    }

    public final void setEntries1(@Nullable Entries<K> entries) {
        this.entries1 = entries;
    }

    @Nullable
    public final Entries<K> getEntries2() {
        return this.entries2;
    }

    public final void setEntries2(@Nullable Entries<K> entries) {
        this.entries2 = entries;
    }

    @Nullable
    public final Values getValues1() {
        return this.values1;
    }

    public final void setValues1(@Nullable Values values) {
        this.values1 = values;
    }

    @Nullable
    public final Values getValues2() {
        return this.values2;
    }

    public final void setValues2(@Nullable Values values) {
        this.values2 = values;
    }

    @Nullable
    public final Keys<K> getKeys1() {
        return this.keys1;
    }

    public final void setKeys1(@Nullable Keys<K> keys) {
        this.keys1 = keys;
    }

    @Nullable
    public final Keys<K> getKeys2() {
        return this.keys2;
    }

    public final void setKeys2(@Nullable Keys<K> keys) {
        this.keys2 = keys;
    }

    public ObjectFloatMap() {
        this(51, 0.8f);
    }

    public ObjectFloatMap(int initialCapacity, float loadFactor) {
        if (loadFactor <= 0.0f || loadFactor >= 1.0f) {
            throw new StateException("loadFactor must be > 0 and < 1: " + loadFactor);
        }
        this.loadFactor = loadFactor;
        int tableSize = ObjectSet.Companion.tableSize(initialCapacity, loadFactor);
        this.threshold = (int)((float)tableSize * loadFactor);
        this.mask = tableSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        this.keyTable = new Object[tableSize];
        this.valueTable = new float[tableSize];
    }

    public /* synthetic */ ObjectFloatMap(int n, float f, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 51;
        }
        if ((n2 & 2) != 0) {
            f = 0.8f;
        }
        this(n, f);
    }

    public ObjectFloatMap(@NotNull ObjectFloatMap<? extends K> map) {
        Intrinsics.checkNotNullParameter(map, (String)"map");
        this((int)((float)map.keyTable.length * map.loadFactor), map.loadFactor);
        System.arraycopy(map.keyTable, 0, this.keyTable, 0, map.keyTable.length);
        System.arraycopy(map.valueTable, 0, this.valueTable, 0, map.valueTable.length);
        this.mapSize = map.mapSize;
    }

    public int getSize() {
        return this.mapSize;
    }

    protected int place(@NotNull Object item) {
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        return (int)((long)item.hashCode() * -7046029254386353131L >>> this.shift);
    }

    public int locateKey(@NotNull Object key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (keyTable[i] != null) {
            K other;
            if (Intrinsics.areEqual(other, (Object)key)) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    @Nullable
    public Float put(@NotNull K key, float value) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        if (i >= 0) {
            float oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return Float.valueOf(oldValue);
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return null;
    }

    public final float put(@NotNull K key, float value, float defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        if (i >= 0) {
            float oldValue = this.valueTable[i];
            this.valueTable[i] = value;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = value;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    public void putAll(@NotNull ObjectFloatMap<? extends K> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.mapSize);
        K[] keyTable = from.keyTable;
        float[] valueTable = from.valueTable;
        K key = null;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            key = keyTable[i];
            if (key == null) continue;
            this.put(key, valueTable[i]);
        }
    }

    @Override
    public void putAll(@NotNull Map<? extends K, ? extends Float> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.ensureCapacity(from.size());
        Map<K, Float> $this$forEach$iv = from;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<K, Float>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<K, Float> element$iv;
            Map.Entry<K, Float> entry = element$iv = iterator.next();
            boolean bl = false;
            K k = entry.getKey();
            float v = ((Number)entry.getValue()).floatValue();
            this.put(k, v);
        }
    }

    private final void putResize(K key, float value) {
        K[] keyTable = this.keyTable;
        int i = this.place(key);
        while (true) {
            if (keyTable[i] == null) {
                keyTable[i] = key;
                this.valueTable[i] = value;
                return;
            }
            i = i + 1 & this.mask;
        }
    }

    @Override
    @Nullable
    public Float get(@Nullable K key) {
        if (key == null) {
            return null;
        }
        int i = this.locateKey(key);
        return i < 0 ? null : Float.valueOf(this.valueTable[i]);
    }

    @Nullable
    public final Float get(@NotNull K key, @Nullable Float defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        return i < 0 ? defaultValue : Float.valueOf(this.valueTable[i]);
    }

    public final float getAndIncrement(@NotNull K key, float defaultValue, float increment) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        if (i >= 0) {
            float oldValue = this.valueTable[i];
            float[] fArray = this.valueTable;
            int n = i;
            fArray[n] = fArray[n] + increment;
            return oldValue;
        }
        i = -(i + 1);
        this.keyTable[i] = key;
        this.valueTable[i] = defaultValue + increment;
        ++this.mapSize;
        if (this.mapSize >= this.threshold) {
            this.resize(this.keyTable.length << 1);
        }
        return defaultValue;
    }

    @Override
    @Nullable
    public Float remove(@Nullable K key) {
        if (key == null) {
            return null;
        }
        int i = this.locateKey(key);
        if (i < 0) {
            return null;
        }
        K[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        float oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        Object k = null;
        while (true) {
            K k2;
            K it = k2 = keyTable[next];
            boolean bl = false;
            k = it;
            if (k2 == null) break;
            Object v0 = k;
            Intrinsics.checkNotNull(v0);
            int placement = this.place(v0);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        valueTable[i] = 0.0f;
        int n = this.mapSize;
        this.mapSize = n + -1;
        return Float.valueOf(oldValue);
    }

    public final float remove(@NotNull K key, float defaultValue) {
        Intrinsics.checkNotNullParameter(key, (String)"key");
        int i = this.locateKey(key);
        if (i < 0) {
            return defaultValue;
        }
        K[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        float oldValue = valueTable[i];
        int mask = this.mask;
        int next = i + 1 & mask;
        Object k = null;
        while (true) {
            K k2;
            K it = k2 = keyTable[next];
            boolean bl = false;
            k = it;
            if (k2 == null) break;
            Object v0 = k;
            Intrinsics.checkNotNull(v0);
            int placement = this.place(v0);
            if ((next - placement & mask) > (i - placement & mask)) {
                keyTable[i] = k;
                valueTable[i] = valueTable[next];
                i = next;
            }
            next = next + 1 & mask;
        }
        keyTable[i] = null;
        valueTable[i] = 0.0f;
        int n = this.mapSize;
        this.mapSize = n + -1;
        return oldValue;
    }

    public final boolean notEmpty() {
        return this.mapSize > 0;
    }

    @Override
    public boolean isEmpty() {
        return this.mapSize == 0;
    }

    public void shrink(int maximumCapacity) {
        if (maximumCapacity < 0) {
            throw new StateException("maximumCapacity must be >= 0: " + maximumCapacity);
        }
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length > tableSize) {
            this.resize(tableSize);
        }
    }

    public void clear(int maximumCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(maximumCapacity, this.loadFactor);
        if (this.keyTable.length <= tableSize) {
            this.clear();
            return;
        }
        this.mapSize = 0;
        this.resize(tableSize);
    }

    @Override
    public void clear() {
        if (this.mapSize == 0) {
            return;
        }
        this.mapSize = 0;
        Arrays.fill(this.keyTable, null);
        Arrays.fill(this.valueTable, 0.0f);
    }

    public boolean containsValue(float value) {
        float[] valueTable = this.valueTable;
        if (value == 0.0f) {
            K[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == null || !(valueTable[i] == 0.0f)) continue;
                    return true;
                } while (0 <= n);
            }
        } else {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!(valueTable[i = n--] == value)) continue;
                    return true;
                } while (0 <= n);
            }
        }
        return false;
    }

    @Override
    public boolean containsKey(@Nullable Object key) {
        if (key == null) {
            return false;
        }
        return this.locateKey(key) >= 0;
    }

    @Nullable
    public final K findKey(@Nullable Object value, boolean identity) {
        float[] valueTable = this.valueTable;
        if (value == null) {
            K[] keyTable = this.keyTable;
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (keyTable[i = n--] == null || !(valueTable[i] == 0.0f)) continue;
                    return keyTable[i];
                } while (0 <= n);
            }
        } else if (identity) {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)Float.valueOf(valueTable[i = n--]), (Object)value)) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        } else {
            int n = valueTable.length + -1;
            if (0 <= n) {
                do {
                    int i;
                    if (!Intrinsics.areEqual((Object)value, (Object)Float.valueOf(valueTable[i = n--]))) continue;
                    return this.keyTable[i];
                } while (0 <= n);
            }
        }
        return null;
    }

    public final void ensureCapacity(int additionalCapacity) {
        int tableSize = ObjectSet.Companion.tableSize(this.mapSize + additionalCapacity, this.loadFactor);
        if (this.keyTable.length < tableSize) {
            this.resize(tableSize);
        }
    }

    public final void resize(int newSize) {
        int oldCapacity = this.keyTable.length;
        this.threshold = (int)((float)newSize * this.loadFactor);
        this.mask = newSize - 1;
        this.shift = Long.numberOfLeadingZeros(this.mask);
        K[] oldKeyTable = this.keyTable;
        float[] oldValueTable = this.valueTable;
        this.keyTable = new Object[newSize];
        this.valueTable = new float[newSize];
        if (this.mapSize > 0) {
            for (int i = 0; i < oldCapacity; ++i) {
                K key = oldKeyTable[i];
                if (key == null) continue;
                this.putResize(key, oldValueTable[i]);
            }
        }
    }

    @Override
    public int hashCode() {
        int h = this.mapSize;
        K[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            h += key.hashCode();
            float value = valueTable[i];
            if (value == 0.0f) continue;
            h += Float.hashCode(value);
        }
        return h;
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof ObjectFloatMap)) {
            return false;
        }
        ObjectFloatMap cfr_ignored_0 = (ObjectFloatMap)other;
        if (((ObjectFloatMap)other).size() != this.mapSize) {
            return false;
        }
        K[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            K key = keyTable[i];
            if (key == null) continue;
            Float otherValue = ((ObjectFloatMap)other).get(key, Float.valueOf(0.0f));
            if (Intrinsics.areEqual((Float)otherValue, (float)0.0f) && !((ObjectFloatMap)other).containsKey(key)) {
                return false;
            }
            if (Intrinsics.areEqual((Float)otherValue, (float)valueTable[i])) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public final String toString(@NotNull String separator) {
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        return this.toString(separator, false);
    }

    @NotNull
    public String toString() {
        return this.toString(", ", true);
    }

    @NotNull
    protected String toString(@NotNull String separator, boolean braces) {
        K key;
        Intrinsics.checkNotNullParameter((Object)separator, (String)"separator");
        if (this.mapSize == 0) {
            return braces ? "{}" : "";
        }
        StringBuilder buffer = new StringBuilder(32);
        if (braces) {
            buffer.append('{');
        }
        K[] keyTable = this.keyTable;
        float[] valueTable = this.valueTable;
        int i = keyTable.length;
        while (i-- > 0) {
            K k = keyTable[i];
            if (k == null) continue;
            key = k;
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
            break;
        }
        while (i-- > 0) {
            if (keyTable[i] == null) continue;
            buffer.append(separator);
            buffer.append(key);
            buffer.append('=');
            buffer.append(valueTable[i]);
        }
        if (braces) {
            buffer.append('}');
        }
        String string = buffer.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"buffer.toString()");
        return string;
    }

    @NotNull
    public Set<Map.Entry<K, Float>> getEntries() {
        Entries<K> entries = this.entries();
        Intrinsics.checkNotNull(entries, (String)"null cannot be cast to non-null type kotlin.collections.MutableSet<kotlin.collections.MutableMap.MutableEntry<K of dorkbox.collections.ObjectFloatMap, kotlin.Float>>");
        return TypeIntrinsics.asMutableSet(entries);
    }

    @NotNull
    public Entries<K> entries() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Entries(this);
        }
        if (this.entries1 == null) {
            this.entries1 = new Entries(this);
            this.entries2 = new Entries(this);
        }
        Entries<K> entries = this.entries1;
        Intrinsics.checkNotNull(entries);
        if (!entries.getValid()) {
            Entries<K> entries2 = this.entries1;
            Intrinsics.checkNotNull(entries2);
            entries2.reset();
            Entries<K> entries3 = this.entries1;
            Intrinsics.checkNotNull(entries3);
            entries3.setValid(true);
            Entries<K> entries4 = this.entries2;
            Intrinsics.checkNotNull(entries4);
            entries4.setValid(false);
            Entries<K> entries5 = this.entries1;
            Intrinsics.checkNotNull(entries5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Entries<K of dorkbox.collections.ObjectFloatMap>");
            return entries5;
        }
        Entries<K> entries6 = this.entries2;
        Intrinsics.checkNotNull(entries6);
        entries6.reset();
        Entries<K> entries7 = this.entries2;
        Intrinsics.checkNotNull(entries7);
        entries7.setValid(true);
        Entries<K> entries8 = this.entries1;
        Intrinsics.checkNotNull(entries8);
        entries8.setValid(false);
        Entries<K> entries9 = this.entries2;
        Intrinsics.checkNotNull(entries9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Entries<K of dorkbox.collections.ObjectFloatMap>");
        return entries9;
    }

    @NotNull
    public Collection<Float> getValues() {
        return this.values();
    }

    @NotNull
    public Values values() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Values((ObjectFloatMap<?>)this);
        }
        if (this.values1 == null) {
            this.values1 = new Values((ObjectFloatMap<?>)this);
            this.values2 = new Values((ObjectFloatMap<?>)this);
        }
        Values values = this.values1;
        Intrinsics.checkNotNull((Object)values);
        if (!values.getValid()) {
            Values values2 = this.values1;
            Intrinsics.checkNotNull((Object)values2);
            values2.reset();
            Values values3 = this.values1;
            Intrinsics.checkNotNull((Object)values3);
            values3.setValid(true);
            Values values4 = this.values2;
            Intrinsics.checkNotNull((Object)values4);
            values4.setValid(false);
            Values values5 = this.values1;
            Intrinsics.checkNotNull((Object)values5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Values");
            return values5;
        }
        Values values6 = this.values2;
        Intrinsics.checkNotNull((Object)values6);
        values6.reset();
        Values values7 = this.values2;
        Intrinsics.checkNotNull((Object)values7);
        values7.setValid(true);
        Values values8 = this.values1;
        Intrinsics.checkNotNull((Object)values8);
        values8.setValid(false);
        Values values9 = this.values2;
        Intrinsics.checkNotNull((Object)values9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Values");
        return values9;
    }

    @NotNull
    public Set<K> getKeys() {
        return this.keys();
    }

    @NotNull
    public Keys<K> keys() {
        if (Collections.INSTANCE.getAllocateIterators()) {
            return new Keys(this);
        }
        if (this.keys1 == null) {
            this.keys1 = new Keys(this);
            this.keys2 = new Keys(this);
        }
        Keys<K> keys = this.keys1;
        Intrinsics.checkNotNull(keys);
        if (!keys.getValid()) {
            Keys<K> keys2 = this.keys1;
            Intrinsics.checkNotNull(keys2);
            keys2.reset();
            Keys<K> keys3 = this.keys1;
            Intrinsics.checkNotNull(keys3);
            keys3.setValid(true);
            Keys<K> keys4 = this.keys2;
            Intrinsics.checkNotNull(keys4);
            keys4.setValid(false);
            Keys<K> keys5 = this.keys1;
            Intrinsics.checkNotNull(keys5, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Keys<K of dorkbox.collections.ObjectFloatMap>");
            return keys5;
        }
        Keys<K> keys6 = this.keys2;
        Intrinsics.checkNotNull(keys6);
        keys6.reset();
        Keys<K> keys7 = this.keys2;
        Intrinsics.checkNotNull(keys7);
        keys7.setValid(true);
        Keys<K> keys8 = this.keys1;
        Intrinsics.checkNotNull(keys8);
        keys8.setValid(false);
        Keys<K> keys9 = this.keys2;
        Intrinsics.checkNotNull(keys9, (String)"null cannot be cast to non-null type dorkbox.collections.ObjectFloatMap.Keys<K of dorkbox.collections.ObjectFloatMap>");
        return keys9;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\n\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u00032\u001a\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u0006\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00010\u00040\u0005B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0012\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001c\u0010\u0015\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0019H\u0016J\u0017\u0010\u001a\u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002J\u001c\u0010\u001b\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\t\u0010\u001c\u001a\u00020\u0013H\u0096\u0002J\b\u0010\u001d\u001a\u00020\u0013H\u0016J\u000f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0096\u0002J\u0016\u0010 \u001a\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004H\u0016J\u001c\u0010!\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016J\u001c\u0010\"\u001a\u00020\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00040\u0017H\u0016R \u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Ldorkbox/collections/ObjectFloatMap$Entries;", "K", "", "", "Ldorkbox/collections/ObjectFloatMap$Entry;", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "entry", "getEntry", "()Ldorkbox/collections/ObjectFloatMap$Entry;", "setEntry", "(Ldorkbox/collections/ObjectFloatMap$Entry;)V", "size", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "remove", "removeAll", "retainAll", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Entries\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1024:1\n1855#2,2:1025\n1855#2,2:1027\n288#2,2:1030\n1855#2,2:1033\n13579#3:1029\n13580#3:1032\n*S KotlinDebug\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Entries\n*L\n751#1:1025,2\n772#1:1027,2\n792#1:1030,2\n804#1:1033,2\n790#1:1029\n790#1:1032\n*E\n"})
    public static class Entries<K>
    extends MapIterator<K, Integer, Entry<K>>
    implements Set<Entry<K>>,
    KMutableSet {
        @NotNull
        private Entry<K> entry;

        public Entries(@NotNull ObjectFloatMap<K> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
            this.entry = new Entry<K>(map);
        }

        @NotNull
        public final Entry<K> getEntry() {
            return this.entry;
        }

        public final void setEntry(@NotNull Entry<K> entry) {
            Intrinsics.checkNotNullParameter(entry, (String)"<set-?>");
            this.entry = entry;
        }

        @Override
        @NotNull
        public Entry<K> next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            K[] keyTable = this.getMap().getKeyTable();
            Object k = keyTable[this.getNextIndex()];
            Intrinsics.checkNotNull(k);
            this.entry.setKey(k);
            this.entry.setValue(this.getMap().getValueTable()[this.getNextIndex()]);
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return this.entry;
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        public boolean add(@NotNull Entry<K> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            this.getMap().put(element.getKey(), element.getValue().floatValue());
            return true;
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Entry<K>> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean added = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry it = (Entry)element$iv;
                boolean bl = false;
                this.getMap().put(it.getKey(), it.getValue().floatValue());
                added = true;
            }
            return added;
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                float v = ((Number)((Map.Entry)entry).getValue()).floatValue();
                if (Intrinsics.areEqual((Float)((Float)this.getMap().get(k)), (float)v)) continue;
                return false;
            }
            return true;
        }

        public boolean contains(@NotNull Entry<K> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            return Intrinsics.areEqual((Float)((Float)this.getMap().get((Object)element.getKey())), (float)element.getValue().floatValue());
        }

        @Override
        @NotNull
        public Entries<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                boolean hasElement;
                Object v0;
                Object key;
                block2: {
                    Object element$iv;
                    key = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    if (key == null) continue;
                    Iterable $this$firstOrNull$iv = elements;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv2 : $this$firstOrNull$iv) {
                        Entry it = (Entry)element$iv2;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual(it.getKey(), key)) continue;
                        v0 = element$iv2;
                        break block2;
                    }
                    v0 = null;
                }
                boolean bl = hasElement = v0 != null;
                if (hasElement) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Entry entry = (Entry)element$iv;
                boolean bl = false;
                Object k = ((Map.Entry)entry).getKey();
                removed = this.getMap().remove(k) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(@NotNull Entry<K> element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            boolean removed = this.getMap().remove((Object)this.entry.getKey()) != null;
            this.reset();
            return removed;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u001f\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0014\n\u0002\b\u0002\b\u0016\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u0014\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00020\u0003B\u0011\u0012\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u000f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0011\u0010\u0014\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0096\u0002J\u0016\u0010\u0015\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\t\u0010\u0016\u001a\u00020\rH\u0096\u0002J\b\u0010\u0017\u001a\u00020\rH\u0016J\t\u0010\u0018\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u0019\u001a\u00020\u0002H\u0096\u0002\u00a2\u0006\u0002\u0010\u001aJ\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0002H\u0016J\u0016\u0010\u001c\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011H\u0016J\b\u0010\u001e\u001a\u00020\u001fH\u0016J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fR\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006!"}, d2={"Ldorkbox/collections/ObjectFloatMap$Values;", "", "", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "size", "", "getSize", "()I", "add", "", "element", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Float;", "remove", "removeAll", "retainAll", "toArray", "", "array", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Values\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1024:1\n1855#2,2:1025\n1855#2,2:1029\n13579#3,2:1027\n*S KotlinDebug\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Values\n*L\n854#1:1025,2\n887#1:1029,2\n872#1:1027,2\n*E\n"})
    public static class Values
    extends MapIterator<Object, Float, Float>
    implements Collection<Float>,
    KMutableCollection {
        public Values(@NotNull ObjectFloatMap<?> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public Float next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            float value = this.getMap().getValueTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            return Float.valueOf(value);
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends Float> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean add(float element) {
            throw new IllegalStateException("Cannot add values to a map without keys");
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                if (this.getMap().containsValue(Float.valueOf(it))) continue;
                return false;
            }
            return true;
        }

        public boolean contains(float element) {
            return this.getMap().containsValue(Float.valueOf(element));
        }

        @NotNull
        public Values iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Float value;
                Object element$iv;
                Object key = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (key == null || CollectionsKt.contains((Iterable)elements, (Object)(value = (Float)this.getMap().get(key)))) continue;
                this.getMap().remove(key);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                float it = ((Number)element$iv).floatValue();
                boolean bl = false;
                Object key = this.getMap().findKey(Float.valueOf(it), false);
                if (key == null) continue;
                removed = this.getMap().remove(key) != null || removed;
            }
            this.reset();
            return removed;
        }

        public boolean remove(float element) {
            boolean removed = false;
            Object key = this.getMap().findKey(Float.valueOf(element), false);
            if (key != null) {
                removed = this.getMap().remove(key) != null;
            }
            this.reset();
            return removed;
        }

        @NotNull
        public float[] toArray() {
            float[] array = new float[this.getMap().size()];
            int index = 0;
            while (this.hasNext()) {
                array[index++] = this.next().floatValue();
            }
            return array;
        }

        @NotNull
        public final float[] toArray(@NotNull float[] array) {
            Intrinsics.checkNotNullParameter((Object)array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                array[index++] = this.next().floatValue();
            }
            return array;
        }

        @Override
        public <T> T[] toArray(T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            return CollectionToArray.toArray((Collection)this, (Object[])array);
        }

        @Override
        public Object[] toArray() {
            return CollectionToArray.toArray((Collection)this);
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0010\u0011\n\u0002\b\u0005\b\u0016\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u00032\u0016\u0012\u0004\u0012\u0002H\u0001\u0012\u0006\u0012\u0004\u0018\u00010\u0002\u0012\u0004\u0012\u0002H\u00010\u0004B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0010\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0016\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u0016\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\t\u0010\u0017\u001a\u00020\rH\u0096\u0002J\b\u0010\u0018\u001a\u00020\rH\u0016J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00010\u0000H\u0096\u0002J\u000e\u0010\u001a\u001a\u00028\u0001H\u0096\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0015\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00028\u0001H\u0016\u00a2\u0006\u0002\u0010\u000fJ\u0016\u0010\u001d\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\u0016\u0010\u001e\u001a\u00020\r2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00010\u0012H\u0016J\u0013\u0010\u001f\u001a\b\u0012\u0004\u0012\u00028\u00010 H\u0016\u00a2\u0006\u0002\u0010!J)\u0010\u001f\u001a\b\u0012\u0004\u0012\u0002H\"0 \"\b\b\u0002\u0010\"*\u00028\u00012\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\"0 \u00a2\u0006\u0002\u0010$R\u0014\u0010\b\u001a\u00020\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Ldorkbox/collections/ObjectFloatMap$Keys;", "K", "", "", "Ldorkbox/collections/ObjectFloatMap$MapIterator;", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "size", "", "getSize", "()I", "add", "", "element", "(Ljava/lang/Object;)Z", "addAll", "elements", "", "clear", "", "contains", "containsAll", "hasNext", "isEmpty", "iterator", "next", "()Ljava/lang/Object;", "remove", "removeAll", "retainAll", "toArray", "", "()[Ljava/lang/Object;", "T", "array", "([Ljava/lang/Object;)[Ljava/lang/Object;", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Keys\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1024:1\n1855#2,2:1025\n1855#2,2:1029\n13579#3,2:1027\n*S KotlinDebug\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$Keys\n*L\n963#1:1025,2\n993#1:1029,2\n981#1:1027,2\n*E\n"})
    public static class Keys<K>
    extends MapIterator<K, Object, K>
    implements Set<K>,
    KMutableSet {
        public Keys(@NotNull ObjectFloatMap<K> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            super(map);
        }

        @Override
        public boolean hasNext() {
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            return this.getHasNext();
        }

        @Override
        @NotNull
        public K next() {
            if (!this.getHasNext()) {
                throw new NoSuchElementException();
            }
            if (!this.getValid()) {
                throw new RuntimeException("#iterator() cannot be used nested.");
            }
            Object key = this.getMap().getKeyTable()[this.getNextIndex()];
            this.setCurrentIndex(this.getNextIndex());
            this.findNextIndex();
            Object k = key;
            Intrinsics.checkNotNull(k);
            return k;
        }

        @Override
        public boolean add(@NotNull K element) {
            Intrinsics.checkNotNullParameter(element, (String)"element");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        @Override
        public boolean addAll(@NotNull Collection<? extends K> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            throw new IllegalStateException("Cannot add keys to a map without values");
        }

        public int getSize() {
            return this.getMap().getMapSize();
        }

        @Override
        public void clear() {
            this.getMap().clear();
            this.reset();
        }

        @Override
        public boolean isEmpty() {
            return this.getMap().isEmpty();
        }

        @Override
        public boolean containsAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().containsKey(it)) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean contains(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            return this.getMap().containsKey(element);
        }

        @Override
        @NotNull
        public Keys<K> iterator() {
            return this;
        }

        @Override
        public boolean retainAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            K[] $this$forEach$iv = this.getMap().getKeyTable();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                Object element$iv;
                Object it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                if (it == null || elements.contains(it)) continue;
                this.getMap().remove(it);
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean removeAll(@NotNull Collection<? extends Object> elements) {
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            boolean removed = false;
            Iterable $this$forEach$iv = elements;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.iterator();
            while (iterator.hasNext()) {
                Object element$iv;
                Object it = element$iv = iterator.next();
                boolean bl = false;
                if (this.getMap().remove(it) != null) continue;
                removed = true;
            }
            this.reset();
            return removed;
        }

        @Override
        public boolean remove(@Nullable Object element) {
            if (element == null) {
                return false;
            }
            boolean removed = this.getMap().remove(element) == null;
            this.reset();
            return removed;
        }

        @Override
        @NotNull
        public K[] toArray() {
            int n = 0;
            int n2 = this.getMap().getMapSize();
            Object[] objectArray = new Object[n2];
            while (n < n2) {
                int n3 = n++;
                Intrinsics.checkNotNull(this.next(), (String)"null cannot be cast to non-null type kotlin.Any");
            }
            return objectArray;
        }

        @Override
        @NotNull
        public final <T extends K> T[] toArray(@NotNull T[] array) {
            Intrinsics.checkNotNullParameter(array, (String)"array");
            int index = 0;
            while (this.getHasNext()) {
                int n = index++;
                K k = this.next();
                Intrinsics.checkNotNull(k, (String)"null cannot be cast to non-null type T of dorkbox.collections.ObjectFloatMap.Keys.toArray");
                array[n] = k;
            }
            return array;
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Ldorkbox/collections/ObjectFloatMap$Companion;", "", "()V", "dummy", "getDummy$Collections", "()Ljava/lang/Object;", "version", "", "Collections"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Object getDummy$Collections() {
            return dummy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    /*
     * Duplicate member names - consider using --renamedupmembers true
     */
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0010'\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u00020\u00040\u0003B\u0013\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\u0002\u0010\u0007J\u0015\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0015\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016R\u001c\u0010\b\u001a\u00028\u0001X\u0096.\u00a2\u0006\u0010\n\u0002\u0010\r\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0004X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0019"}, d2={"Ldorkbox/collections/ObjectFloatMap$Entry;", "K", "", "", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "key", "getKey", "()Ljava/lang/Object;", "setKey", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "getMap", "()Ldorkbox/collections/ObjectFloatMap;", "value", "getValue", "()Ljava/lang/Float;", "setValue", "(F)V", "newValue", "(F)Ljava/lang/Float;", "toString", "", "Collections"})
    public static final class Entry<K>
    implements Map.Entry<K, Float>,
    KMutableMap.Entry {
        @NotNull
        private final ObjectFloatMap<K> map;
        public K key;
        private float value;

        public Entry(@NotNull ObjectFloatMap<K> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
        }

        @NotNull
        public final ObjectFloatMap<K> getMap() {
            return this.map;
        }

        @Override
        @NotNull
        public K getKey() {
            K k = this.key;
            if (k != null) {
                return k;
            }
            Intrinsics.throwUninitializedPropertyAccessException((String)"key");
            return (K)Unit.INSTANCE;
        }

        public void setKey(@NotNull K k) {
            Intrinsics.checkNotNullParameter(k, (String)"<set-?>");
            this.key = k;
        }

        @Override
        @NotNull
        public Float getValue() {
            return Float.valueOf(this.value);
        }

        @Override
        public void setValue(float f) {
            this.value = f;
        }

        @Override
        @NotNull
        public Float setValue(float newValue) {
            float oldValue = this.getValue().floatValue();
            Float f = Float.valueOf(newValue);
            ((Map)this.map).put(this.getKey(), f);
            this.setValue(newValue);
            return Float.valueOf(oldValue);
        }

        @NotNull
        public String toString() {
            return "" + this.getKey() + '=' + this.getValue().floatValue();
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\u0010)\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0001\u0010\u0001*\u00020\u0002*\u0004\b\u0002\u0010\u0003*\u0004\b\u0003\u0010\u00042\b\u0012\u0004\u0012\u0002H\u00040\u00052\b\u0012\u0004\u0012\u0002H\u00040\u0006B\u0013\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0002\u0010\tJ\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0016J\b\u0010!\u001a\u00020\u001fH\u0016R\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u001a\u0010\u0018\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\r\"\u0004\b\u001a\u0010\u000fR\u001a\u0010\u001b\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u0013\"\u0004\b\u001d\u0010\u0015\u00a8\u0006\""}, d2={"Ldorkbox/collections/ObjectFloatMap$MapIterator;", "K", "", "V", "I", "", "", "map", "Ldorkbox/collections/ObjectFloatMap;", "(Ldorkbox/collections/ObjectFloatMap;)V", "currentIndex", "", "getCurrentIndex", "()I", "setCurrentIndex", "(I)V", "hasNext", "", "getHasNext", "()Z", "setHasNext", "(Z)V", "getMap", "()Ldorkbox/collections/ObjectFloatMap;", "nextIndex", "getNextIndex", "setNextIndex", "valid", "getValid", "setValid", "findNextIndex", "", "remove", "reset", "Collections"})
    @SourceDebugExtension(value={"SMAP\nObjectFloatMap.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ObjectFloatMap.kt\ndorkbox/collections/ObjectFloatMap$MapIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,1024:1\n1#2:1025\n*E\n"})
    public static abstract class MapIterator<K, V, I>
    implements Iterable<I>,
    Iterator<I>,
    KMappedMarker,
    KMutableIterator {
        @NotNull
        private final ObjectFloatMap<K> map;
        private boolean hasNext;
        private int nextIndex;
        private int currentIndex;
        private boolean valid;

        public MapIterator(@NotNull ObjectFloatMap<K> map) {
            Intrinsics.checkNotNullParameter(map, (String)"map");
            this.map = map;
            this.valid = true;
            this.reset();
        }

        @NotNull
        public final ObjectFloatMap<K> getMap() {
            return this.map;
        }

        public final boolean getHasNext() {
            return this.hasNext;
        }

        public final void setHasNext(boolean bl) {
            this.hasNext = bl;
        }

        public final int getNextIndex() {
            return this.nextIndex;
        }

        public final void setNextIndex(int n) {
            this.nextIndex = n;
        }

        public final int getCurrentIndex() {
            return this.currentIndex;
        }

        public final void setCurrentIndex(int n) {
            this.currentIndex = n;
        }

        public final boolean getValid() {
            return this.valid;
        }

        public final void setValid(boolean bl) {
            this.valid = bl;
        }

        public void reset() {
            this.currentIndex = -1;
            this.nextIndex = -1;
            this.findNextIndex();
        }

        public final void findNextIndex() {
            block1: {
                K[] keyTable = this.map.getKeyTable();
                int n = keyTable.length;
                do {
                    ++this.nextIndex;
                    if (this.nextIndex >= n) break block1;
                } while (keyTable[this.nextIndex] == null);
                this.hasNext = true;
                return;
            }
            this.hasNext = false;
        }

        @Override
        public void remove() {
            Object object;
            int i = this.currentIndex;
            if (!(i >= 0)) {
                boolean $i$a$-check-ObjectFloatMap$MapIterator$remove$22 = false;
                String $i$a$-check-ObjectFloatMap$MapIterator$remove$22 = "next must be called before remove.";
                throw new IllegalStateException($i$a$-check-ObjectFloatMap$MapIterator$remove$22.toString());
            }
            K[] keyTable = this.map.getKeyTable();
            float[] valueTable = this.map.getValueTable();
            int mask = this.map.getMask();
            int next = i + 1 & mask;
            Object key = null;
            while (true) {
                object = keyTable[next];
                K it = object;
                boolean bl = false;
                key = it;
                if (object == null) break;
                Object v0 = key;
                Intrinsics.checkNotNull(v0);
                int placement = this.map.place(v0);
                if ((next - placement & mask) > (i - placement & mask)) {
                    keyTable[i] = key;
                    valueTable[i] = valueTable[next];
                    i = next;
                }
                next = next + 1 & mask;
            }
            keyTable[i] = null;
            valueTable[i] = 0.0f;
            object = this.map;
            int n = ((ObjectFloatMap)object).getMapSize();
            ((ObjectFloatMap)object).setMapSize(n + -1);
            if (i != this.currentIndex) {
                this.nextIndex += -1;
            }
            this.currentIndex = -1;
        }

        @Override
        public Iterator<I> iterator() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

