/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.sef;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.PostfixExpression;
import org.eclipse.jdt.core.dom.PrefixExpression;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.internal.core.manipulation.dom.NecessaryParenthesesChecker;
import org.eclipse.jdt.internal.corext.SourceRangeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.sef.SelfEncapsulateFieldRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.text.edits.TextEditGroup;

public class AccessAnalyzer
extends ASTVisitor {
    private ICompilationUnit fCUnit;
    private IVariableBinding fFieldBinding;
    private ITypeBinding fDeclaringClassBinding;
    private String fGetter;
    private String fSetter;
    private ASTRewrite fRewriter;
    private ImportRewrite fImportRewriter;
    private List<TextEditGroup> fGroupDescriptions;
    private RefactoringStatus fStatus;
    private boolean fSetterMustReturnValue;
    private boolean fEncapsulateDeclaringClass;
    private boolean fIsFieldFinal;
    private boolean fRemoveStaticImport;
    private boolean fReferencingGetter;
    private boolean fReferencingSetter;
    private static final String READ_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_read_access;
    private static final String WRITE_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_write_access;
    private static final String PREFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_prefix_access;
    private static final String POSTFIX_ACCESS = RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_encapsulate_postfix_access;

    public AccessAnalyzer(SelfEncapsulateFieldRefactoring refactoring, ICompilationUnit unit, IVariableBinding field, ITypeBinding declaringClass, ASTRewrite rewriter, ImportRewrite importRewrite) {
        Assert.isNotNull((Object)((Object)refactoring));
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)field);
        Assert.isNotNull((Object)declaringClass);
        Assert.isNotNull((Object)rewriter);
        Assert.isNotNull((Object)importRewrite);
        this.fCUnit = unit;
        this.fFieldBinding = field.getVariableDeclaration();
        this.fDeclaringClassBinding = declaringClass;
        this.fRewriter = rewriter;
        this.fImportRewriter = importRewrite;
        this.fGroupDescriptions = new ArrayList<TextEditGroup>();
        this.fGetter = refactoring.getGetterName();
        this.fSetter = refactoring.getSetterName();
        this.fEncapsulateDeclaringClass = refactoring.getEncapsulateDeclaringClass();
        try {
            this.fIsFieldFinal = Flags.isFinal((int)refactoring.getField().getFlags());
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.fStatus = new RefactoringStatus();
    }

    public boolean getSetterMustReturnValue() {
        return this.fSetterMustReturnValue;
    }

    public RefactoringStatus getStatus() {
        return this.fStatus;
    }

    public List<TextEditGroup> getGroupDescriptions() {
        return this.fGroupDescriptions;
    }

    public boolean visit(Assignment node) {
        Expression leftHandSide = node.getLeftHandSide();
        if (!this.considerBinding(this.resolveBinding(leftHandSide), (ASTNode)leftHandSide)) {
            return true;
        }
        this.checkParent((ASTNode)node);
        Expression rightHandSide = node.getRightHandSide();
        if (!this.fIsFieldFinal) {
            List<InfixExpression> arguments = new ArrayList<Expression>();
            AST ast = node.getAST();
            Expression receiver = this.getReceiver(leftHandSide);
            Assignment.Operator operator = node.getOperator();
            if (operator != Assignment.Operator.ASSIGN) {
                if (!this.fSetter.isEmpty() && this.fGetter.isEmpty()) {
                    InfixExpression argument = ast.newInfixExpression();
                    MethodInvocation invocation = ast.newMethodInvocation();
                    invocation.setName(ast.newSimpleName(this.fSetter));
                    if (receiver != null) {
                        invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                    }
                    invocation.arguments().add(argument);
                    argument.setOperator(ASTNodes.convertToInfixOperator(node.getOperator()));
                    argument.setLeftOperand((Expression)ast.newSimpleName(leftHandSide.toString()));
                    Expression rhs = (Expression)this.fRewriter.createCopyTarget((ASTNode)rightHandSide);
                    argument.setRightOperand(rhs);
                    this.fRewriter.replace((ASTNode)node, (ASTNode)invocation, this.createGroupDescription(WRITE_ACCESS));
                    this.fReferencingSetter = true;
                    return false;
                }
                if (this.fSetter.isEmpty() && !this.fGetter.isEmpty()) {
                    Assignment assignment = ast.newAssignment();
                    assignment.setLeftHandSide((Expression)ast.newSimpleName(leftHandSide.toString()));
                    InfixExpression argument = ast.newInfixExpression();
                    MethodInvocation invocation = ast.newMethodInvocation();
                    invocation.setName(ast.newSimpleName(this.fGetter));
                    if (receiver != null) {
                        invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                    }
                    argument.setOperator(ASTNodes.convertToInfixOperator(node.getOperator()));
                    argument.setLeftOperand((Expression)invocation);
                    Expression rhs = (Expression)this.fRewriter.createCopyTarget((ASTNode)rightHandSide);
                    argument.setRightOperand(rhs);
                    assignment.setRightHandSide((Expression)argument);
                    this.fRewriter.replace((ASTNode)node, (ASTNode)assignment, this.createGroupDescription(READ_ACCESS));
                    this.fReferencingGetter = true;
                    return false;
                }
            } else if (this.fSetter.isEmpty() && !this.fGetter.isEmpty()) {
                rightHandSide.accept((ASTVisitor)this);
                return false;
            }
            if (!this.fSetter.isEmpty()) {
                MethodInvocation invocation = ast.newMethodInvocation();
                invocation.setName(ast.newSimpleName(this.fSetter));
                this.fReferencingSetter = true;
                if (receiver != null) {
                    invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                }
                arguments = invocation.arguments();
                this.fRewriter.replace((ASTNode)node, (ASTNode)invocation, this.createGroupDescription(WRITE_ACCESS));
            }
            if (node.getOperator() == Assignment.Operator.ASSIGN) {
                arguments.add((InfixExpression)((Expression)this.fRewriter.createCopyTarget((ASTNode)rightHandSide)));
            } else if (!this.fGetter.isEmpty()) {
                InfixExpression exp = ast.newInfixExpression();
                exp.setOperator(ASTNodes.convertToInfixOperator(node.getOperator()));
                MethodInvocation getter = ast.newMethodInvocation();
                getter.setName(ast.newSimpleName(this.fGetter));
                this.fReferencingGetter = true;
                if (receiver != null) {
                    getter.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                }
                exp.setLeftOperand((Expression)getter);
                Expression rhs = (Expression)this.fRewriter.createCopyTarget((ASTNode)rightHandSide);
                if (NecessaryParenthesesChecker.needsParenthesesForRightOperand(rightHandSide, exp, leftHandSide.resolveTypeBinding())) {
                    ParenthesizedExpression p = ast.newParenthesizedExpression();
                    p.setExpression(rhs);
                    rhs = p;
                }
                exp.setRightOperand(rhs);
                arguments.add(exp);
            }
        }
        rightHandSide.accept((ASTVisitor)this);
        return false;
    }

    public boolean visit(SimpleName node) {
        if (!node.isDeclaration() && this.considerBinding(node.resolveBinding(), (ASTNode)node) && !this.fGetter.isEmpty()) {
            this.fReferencingGetter = true;
            this.fRewriter.replace((ASTNode)node, this.fRewriter.createStringPlaceholder(this.fGetter + "()", 32), this.createGroupDescription(READ_ACCESS));
        }
        return true;
    }

    public boolean visit(ImportDeclaration node) {
        if (this.considerBinding(node.resolveBinding(), (ASTNode)node)) {
            this.fRemoveStaticImport = true;
        }
        return false;
    }

    public boolean visit(PrefixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        PrefixExpression.Operator operator = node.getOperator();
        if (operator != PrefixExpression.Operator.INCREMENT && operator != PrefixExpression.Operator.DECREMENT) {
            return true;
        }
        this.checkParent((ASTNode)node);
        this.fRewriter.replace((ASTNode)node, this.createInvocation(node.getAST(), node.getOperand(), node.getOperator().toString()), this.createGroupDescription(PREFIX_ACCESS));
        return false;
    }

    public boolean visit(PostfixExpression node) {
        Expression operand = node.getOperand();
        if (!this.considerBinding(this.resolveBinding(operand), (ASTNode)operand)) {
            return true;
        }
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fStatus.addError(RefactoringCoreMessages.SelfEncapsulateField_AccessAnalyzer_cannot_convert_postfix_expression, JavaStatusContext.create((ITypeRoot)this.fCUnit, SourceRangeFactory.create((ASTNode)node)));
            return false;
        }
        this.fRewriter.replace((ASTNode)node, this.createInvocation(node.getAST(), node.getOperand(), node.getOperator().toString()), this.createGroupDescription(POSTFIX_ACCESS));
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        String name = node.getName().getIdentifier();
        return !name.equals(this.fGetter) && !name.equals(this.fSetter);
    }

    public void endVisit(CompilationUnit node) {
        if (!this.fRemoveStaticImport) {
            return;
        }
        ITypeBinding type = this.fFieldBinding.getDeclaringClass();
        String fieldName = this.fFieldBinding.getName();
        String typeName = type.getQualifiedName();
        if (this.fRemoveStaticImport) {
            this.fImportRewriter.removeStaticImport(typeName + "." + fieldName);
        }
        if (this.fReferencingGetter) {
            this.fImportRewriter.addStaticImport(typeName, this.fGetter, false);
        }
        if (this.fReferencingSetter) {
            this.fImportRewriter.addStaticImport(typeName, this.fSetter, false);
        }
    }

    private boolean considerBinding(IBinding binding, ASTNode node) {
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        boolean result = Bindings.equals((IBinding)this.fFieldBinding, (IBinding)((IVariableBinding)binding).getVariableDeclaration());
        if (!result || this.fEncapsulateDeclaringClass) {
            return result;
        }
        AbstractTypeDeclaration type = ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        if (type != null) {
            ITypeBinding declaringType = type.resolveBinding();
            return !Bindings.equals((IBinding)this.fDeclaringClassBinding, (IBinding)declaringType);
        }
        return true;
    }

    private void checkParent(ASTNode node) {
        ASTNode parent = node.getParent();
        if (!(parent instanceof ExpressionStatement)) {
            this.fSetterMustReturnValue = true;
        }
    }

    private IBinding resolveBinding(Expression expression) {
        if (expression instanceof SimpleName) {
            return ((SimpleName)expression).resolveBinding();
        }
        if (expression instanceof QualifiedName) {
            return ((QualifiedName)expression).resolveBinding();
        }
        if (expression instanceof FieldAccess) {
            return ((FieldAccess)expression).getName().resolveBinding();
        }
        if (expression instanceof SuperFieldAccess) {
            return ((SuperFieldAccess)expression).getName().resolveBinding();
        }
        if (expression instanceof ParenthesizedExpression) {
            return this.resolveBinding(((ParenthesizedExpression)expression).getExpression());
        }
        return null;
    }

    private Expression getReceiver(Expression expression) {
        int type = expression.getNodeType();
        switch (type) {
            case 42: {
                return null;
            }
            case 40: {
                return ((QualifiedName)expression).getQualifier();
            }
            case 22: {
                return ((FieldAccess)expression).getExpression();
            }
            case 36: {
                return this.getReceiver(((ParenthesizedExpression)expression).getExpression());
            }
        }
        return null;
    }

    private ASTNode createInvocation(AST ast, Expression operand, String operator) {
        block43: {
            boolean nomatch;
            MethodInvocation invocation;
            InfixExpression argument;
            block44: {
                block40: {
                    boolean nomatch2;
                    MethodInvocation getter;
                    Assignment invocation2;
                    InfixExpression argument2;
                    block41: {
                        block37: {
                            boolean nomatch3;
                            MethodInvocation invocation3;
                            InfixExpression argument3;
                            Expression receiver;
                            block38: {
                                if (this.fSetter.isEmpty() || this.fGetter.isEmpty()) break block37;
                                receiver = this.getReceiver(operand);
                                argument3 = ast.newInfixExpression();
                                invocation3 = ast.newMethodInvocation();
                                invocation3.setName(ast.newSimpleName(this.fSetter));
                                if (receiver != null) {
                                    invocation3.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                                }
                                invocation3.arguments().add(argument3);
                                nomatch3 = false;
                                if (operator == null) break block38;
                                switch (operator) {
                                    case "++": {
                                        argument3.setOperator(InfixExpression.Operator.PLUS);
                                        break;
                                    }
                                    case "--": {
                                        argument3.setOperator(InfixExpression.Operator.MINUS);
                                        break;
                                    }
                                    default: {
                                        nomatch3 = true;
                                    }
                                }
                            }
                            if (nomatch3) {
                                Assert.isTrue((boolean)false, (String)"Should not happen");
                            }
                            MethodInvocation getter2 = ast.newMethodInvocation();
                            getter2.setName(ast.newSimpleName(this.fGetter));
                            if (receiver != null) {
                                getter2.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                            }
                            argument3.setLeftOperand((Expression)getter2);
                            argument3.setRightOperand((Expression)ast.newNumberLiteral("1"));
                            this.fReferencingGetter = true;
                            this.fReferencingSetter = true;
                            return invocation3;
                        }
                        if (!this.fSetter.isEmpty() || this.fGetter.isEmpty()) break block40;
                        Expression receiver = this.getReceiver(operand);
                        argument2 = ast.newInfixExpression();
                        invocation2 = ast.newAssignment();
                        invocation2.setLeftHandSide((Expression)ast.newSimpleName(operand.toString()));
                        if (receiver != null) {
                            invocation2.setLeftHandSide((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                        }
                        getter = ast.newMethodInvocation();
                        getter.setName(ast.newSimpleName(this.fGetter));
                        nomatch2 = false;
                        if (operator == null) break block41;
                        switch (operator) {
                            case "++": {
                                argument2.setOperator(InfixExpression.Operator.PLUS);
                                break;
                            }
                            case "--": {
                                argument2.setOperator(InfixExpression.Operator.MINUS);
                                break;
                            }
                            default: {
                                nomatch2 = true;
                            }
                        }
                    }
                    if (nomatch2) {
                        Assert.isTrue((boolean)false, (String)"Should not happen");
                    }
                    argument2.setRightOperand((Expression)ast.newNumberLiteral("1"));
                    argument2.setLeftOperand((Expression)getter);
                    invocation2.setRightHandSide((Expression)argument2);
                    this.fReferencingGetter = true;
                    this.fReferencingSetter = false;
                    return invocation2;
                }
                if (this.fSetter.isEmpty() || !this.fGetter.isEmpty()) break block43;
                Expression receiver = this.getReceiver(operand);
                argument = ast.newInfixExpression();
                invocation = ast.newMethodInvocation();
                invocation.setName(ast.newSimpleName(this.fSetter));
                if (receiver != null) {
                    invocation.setExpression((Expression)this.fRewriter.createCopyTarget((ASTNode)receiver));
                }
                invocation.arguments().add(argument);
                nomatch = false;
                if (operator == null) break block44;
                switch (operator) {
                    case "++": {
                        argument.setOperator(InfixExpression.Operator.PLUS);
                        break;
                    }
                    case "--": {
                        argument.setOperator(InfixExpression.Operator.MINUS);
                        break;
                    }
                    default: {
                        nomatch = true;
                    }
                }
            }
            if (nomatch) {
                Assert.isTrue((boolean)false, (String)"Should not happen");
            }
            argument.setLeftOperand((Expression)ast.newSimpleName(operand.toString()));
            argument.setRightOperand((Expression)ast.newNumberLiteral("1"));
            this.fReferencingGetter = false;
            this.fReferencingSetter = true;
            return invocation;
        }
        return null;
    }

    private TextEditGroup createGroupDescription(String name) {
        TextEditGroup result = new TextEditGroup(name);
        this.fGroupDescriptions.add(result);
        return result;
    }
}

