#ifndef NETSIO_PROTO_H
#define NETSIO_PROTO_H

#define NETSIO_DATA_BYTE        0x01
#define NETSIO_DATA_BLOCK       0x02

#define NETSIO_FILL_BUFFER      0x02
#define NETSIO_TRANSMITT_BUFFER 0x03

#define NETSIO_DATA_BYTE_SYNC   0x09

#define NETSIO_COMMAND_OFF      0x10
#define NETSIO_COMMAND_ON       0x11
#define NETSIO_COMMAND_OFF_SYNC 0x18
#define NETSIO_MOTOR_OFF        0x20
#define NETSIO_MOTOR_ON         0x21
#define NETSIO_PROCEED_OFF      0x30
#define NETSIO_PROCEED_ON       0x31
#define NETSIO_INTERRUPT_OFF    0x40
#define NETSIO_INTERRUPT_ON     0x41

#define NETSIO_SPEED_CHANGE     0x80
#define NETSIO_SYNC_RESPONSE    0x81

#define NETSIO_DEVICE_DISCONNECT 0xC0
#define NETSIO_DEVICE_CONNECT   0xC1
#define NETSIO_PING_REQUEST     0xC2
#define NETSIO_PING_RESPONSE    0xC3
#define NETSIO_ALIVE_REQUEST    0xC4
#define NETSIO_ALIVE_RESPONSE   0xC5
#define NETSIO_CREDIT_STATUS    0xC6
#define NETSIO_CREDIT_UPDATE    0xC7

#define NETSIO_WARM_RESET       0xFE
#define NETSIO_COLD_RESET       0xFF


#define NETSIO_EMPTY_SYNC       0x00
#define NETSIO_ACK_SYNC         0x01

#define NETSIO_PORT             9997

#endif // NETSIO_PROTO_H
