#ifndef COMPAT_UNAME_H
#define COMPAT_UNAME_H

#if defined(_WIN32)

#ifdef __cplusplus
extern "C" {
#endif

#define UTSNAME_MAXLENGTH 65

struct utsname {
	char sysname [UTSNAME_MAXLENGTH]; // name of this implementation of the operating system
	char nodename[UTSNAME_MAXLENGTH]; // name of this node within an implementation - dependent communications network
	char release [UTSNAME_MAXLENGTH]; //  current release level of this implementation
	char version [UTSNAME_MAXLENGTH]; //  current version level of this release
	char machine [UTSNAME_MAXLENGTH]; //  name of the hardware type on which the system is running
};

int uname(struct utsname *name);

#ifdef __cplusplus
}
#endif

#else

#include <sys/utsname.h>

#endif

#endif // COMPAT_UNAME_H