/*
 * Decompiled with CFR 0.152.
 */
package com.charliemouse.cambozola;

import java.awt.Rectangle;

public class PercentArea {
    public static final int LEFT = -1;
    public static final int RIGHT = 1;
    public static final int UP = -1;
    public static final int DOWN = 1;
    double p1x;
    double p1y;
    double p2x;
    double p2y;
    double centx;
    double centy;

    public PercentArea() {
        this.reset();
    }

    public boolean setBounds(double ax1, double ay1, double ax2, double ay2) {
        boolean mod = true;
        this.p1x = Math.max(Math.min(ax1, ax2), 0.0);
        this.p2x = Math.min(Math.max(ax1, ax2), 100.0);
        this.p1y = Math.max(Math.min(ay1, ay2), 0.0);
        this.p2y = Math.min(Math.max(ay1, ay2), 100.0);
        this.centx = (this.p1x + this.p2x) / 2.0;
        this.centy = (this.p1y + this.p2y) / 2.0;
        return mod;
    }

    public boolean setBoundsAspect(double cx, double cy, double w, double h) {
        boolean mod = true;
        double mw = Math.min(w, 100.0) / 2.0;
        double mh = Math.min(h, 100.0) / 2.0;
        double cxd = cx;
        if (cx <= mw) {
            cxd = mw;
        } else if (cx + mw > 100.0) {
            cxd = 100.0 - mw;
        }
        double cyd = cy;
        if (cy <= mh) {
            cyd = mh;
        } else if (cy + mh > 100.0) {
            cyd = 100.0 - mh;
        }
        this.p1x = cxd - mw;
        this.p1y = cyd - mh;
        this.p2x = cxd + mw;
        this.p2y = cyd + mh;
        this.centx = cxd;
        this.centy = cyd;
        return mod;
    }

    public void reset() {
        this.setBounds(0.0, 0.0, 100.0, 100.0);
    }

    public double getWidth() {
        return this.p2x - this.p1x;
    }

    public double getHeight() {
        return this.p2y - this.p1y;
    }

    public Rectangle getArea(int width, int height) {
        double x = this.p1x * (double)width / 100.0;
        double y = this.p1y * (double)height / 100.0;
        double w = this.getWidth() * (double)width / 100.0;
        double h = this.getHeight() * (double)height / 100.0;
        return new Rectangle((int)x, (int)y, (int)w, (int)h);
    }

    public boolean zoomIn() {
        double w = this.getWidth() / 4.0;
        double h = this.getHeight() / 4.0;
        if (w < 1.0 || h < 1.0) {
            return false;
        }
        return this.setBounds(this.centx - w, this.centy - h, this.centx + w, this.centy + h);
    }

    public boolean zoomOut() {
        double w = this.getWidth() * 2.0;
        double h = this.getHeight() * 2.0;
        return this.setBoundsAspect(this.centx, this.centy, w, h);
    }

    public boolean panHorizontal(int dir) {
        double jump = Math.max(this.getWidth() / 5.0, 1.0) * (double)dir;
        return this.setBoundsAspect(this.centx + jump, this.centy, this.getWidth(), this.getHeight());
    }

    public boolean panVertical(int dir) {
        double jump = Math.max(this.getHeight() / 5.0, 1.0) * (double)dir;
        return this.setBoundsAspect(this.centx, this.centy + jump, this.getWidth(), this.getHeight());
    }

    public String toString() {
        return "[" + this.p1x + "," + this.p1y + "] ==> [" + this.p2x + "," + this.p2y + "] (w=" + this.getWidth() + ", h=" + this.getHeight() + ")";
    }
}

